/*------------------------------------------------------------------------------
--       Copyright (c) 2015-2017, VeriSilicon Inc. All rights reserved        --
--         Copyright (c) 2011-2014, Google Inc. All rights reserved.          --
--         Copyright (c) 2007-2010, Hantro OY. All rights reserved.           --
--                                                                            --
-- This software is confidential and proprietary and may be used only as      --
--   expressly authorized by VeriSilicon in a written licensing agreement.    --
--                                                                            --
--         This entire notice must be reproduced on all copies                --
--                       and may not be removed.                              --
--                                                                            --
--------------------------------------------------------------------------------
-- Redistribution and use in source and binary forms, with or without         --
-- modification, are permitted provided that the following conditions are met:--
--   * Redistributions of source code must retain the above copyright notice, --
--       this list of conditions and the following disclaimer.                --
--   * Redistributions in binary form must reproduce the above copyright      --
--       notice, this list of conditions and the following disclaimer in the  --
--       documentation and/or other materials provided with the distribution. --
--   * Neither the names of Google nor the names of its contributors may be   --
--       used to endorse or promote products derived from this software       --
--       without specific prior written permission.                           --
--------------------------------------------------------------------------------
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"--
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  --
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE --
-- ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE  --
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR        --
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF       --
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS   --
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN    --
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)    --
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE --
-- POSSIBILITY OF SUCH DAMAGE.                                                --
--------------------------------------------------------------------------------
--                                                                            --
-  Description : CABAC initialization tables
-
------------------------------------------------------------------------------*/

#ifndef __H264CABACCONTEXT_H__
#define __H264CABACCONTEXT_H__

#include "basetype.h"

/* m and n values for given CtxIdx */

/* I Slices */
static const int h264ContextInitIntra[460][2] = {
    /* 0 -> 10 */
    {20, -15}, {2, 54}, {3, 74}, {20, -15},
    {2, 54}, {3, 74}, {-28, 127}, {-23, 104},
    {-6, 53}, {-1, 54}, {7, 51},

    /* 11 -> 23 unsused for I */
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0},

    /* 24 -> 39 */
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0}, {0, 0}, {0, 0},

    /* 40 -> 53 */
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0},

    /* 54 -> 59 */
    {0, 0}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}, {0, 0},

    /* 60 -> 69 */
    {0, 41}, {0, 63}, {0, 63}, {0, 63},
    {-9, 83}, {4, 86}, {0, 97}, {-7, 72},
    {13, 41}, {3, 62},

    /* 70 -> 87 */
    {0, 11}, {1, 55}, {0, 69}, {-17, 127},
    {-13, 102}, {0, 82}, {-7, 74}, {-21, 107},
    {-27, 127}, {-31, 127}, {-24, 127}, {-18, 95},
    {-27, 127}, {-21, 114}, {-30, 127}, {-17, 123},
    {-12, 115}, {-16, 122},

    /* 88 -> 104 */
    {-11, 115}, {-12, 63}, {-2, 68}, {-15, 84},
    {-13, 104}, {-3, 70}, {-8, 93}, {-10, 90},
    {-30, 127}, {-1, 74}, {-6, 97}, {-7, 91},
    {-20, 127}, {-4, 56}, {-5, 82}, {-7, 76},
    {-22, 125},

    /* 105 -> 135 */
    {-7, 93}, {-11, 87}, {-3, 77}, {-5, 71},
    {-4, 63}, {-4, 68}, {-12, 84}, {-7, 62},
    {-7, 65}, {8, 61}, {5, 56}, {-2, 66},
    {1, 64}, {0, 61}, {-2, 78}, {1, 50},
    {7, 52}, {10, 35}, {0, 44}, {11, 38},
    {1, 45}, {0, 46}, {5, 44}, {31, 17},
    {1, 51}, {7, 50}, {28, 19}, {16, 33},
    {14, 62}, {-13, 108}, {-15, 100},

    /* 136 -> 165 */
    {-13, 101}, {-13, 91}, {-12, 94}, {-10, 88},
    {-16, 84}, {-10, 86}, {-7, 83}, {-13, 87},
    {-19, 94}, {1, 70}, {0, 72}, {-5, 74},
    {18, 59}, {-8, 102}, {-15, 100}, {0, 95},
    {-4, 75}, {2, 72}, {-11, 75}, {-3, 71},
    {15, 46}, {-13, 69}, {0, 62}, {0, 65},
    {21, 37}, {-15, 72}, {9, 57}, {16, 54},
    {0, 62}, {12, 72},

    /* 166 -> 196 */
    {24, 0}, {15, 9}, {8, 25}, {13, 18},
    {15, 9}, {13, 19}, {10, 37}, {12, 18},
    {6, 29}, {20, 33}, {15, 30}, {4, 45},
    {1, 58}, {0, 62}, {7, 61}, {12, 38},
    {11, 45}, {15, 39}, {11, 42}, {13, 44},
    {16, 45}, {12, 41}, {10, 49}, {30, 34},
    {18, 42}, {10, 55}, {17, 51}, {17, 46},
    {0, 89}, {26, -19}, {22, -17},

    /* 197 -> 226 */
    {26, -17}, {30, -25}, {28, -20}, {33, -23},
    {37, -27}, {33, -23}, {40, -28}, {38, -17},
    {33, -11}, {40, -15}, {41, -6}, {38, 1},
    {41, 17}, {30, -6}, {27, 3}, {26, 22},
    {37, -16}, {35, -4}, {38, -8}, {38, -3},
    {37, 3}, {38, 5}, {42, 0}, {35, 16},
    {39, 22}, {14, 48}, {27, 37}, {21, 60},
    {12, 68}, {2, 97},

    /* 227 -> 251 */
    {-3, 71}, {-6, 42}, {-5, 50}, {-3, 54},
    {-2, 62}, {0, 58}, {1, 63}, {-2, 72},
    {-1, 74}, {-9, 91}, {-5, 67}, {-5, 27},
    {-3, 39}, {-2, 44}, {0, 46}, {-16, 64},
    {-8, 68}, {-10, 78}, {-6, 77}, {-10, 86},
    {-12, 92}, {-15, 55}, {-10, 60}, {-6, 62},
    {-4, 65},

    /* 252 -> 275 */
    {-12, 73}, {-8, 76}, {-7, 80}, {-9, 88},
    {-17, 110}, {-11, 97}, {-20, 84}, {-11, 79},
    {-6, 73}, {-4, 74}, {-13, 86}, {-13, 96},
    {-11, 97}, {-19, 117}, {-8, 78}, {-5, 33},
    {-4, 48}, {-2, 53}, {-3, 62}, {-13, 71},
    {-10, 79}, {-12, 86}, {-13, 90}, {-14, 97},

    /* 276 special case, bypass used */
    {0, 0},

    /* 277 -> 307 */
    {-6, 93}, {-6, 84}, {-8, 79}, {0, 66},
    {-1, 71}, {0, 62}, {-2, 60}, {-2, 59},
    {-5, 75}, {-3, 62}, {-4, 58}, {-9, 66},
    {-1, 79}, {0, 71}, {3, 68}, {10, 44},
    {-7, 62}, {15, 36}, {14, 40}, {16, 27},
    {12, 29}, {1, 44}, {20, 36}, {18, 32},
    {5, 42}, {1, 48}, {10, 62}, {17, 46},
    {9, 64}, {-12, 104}, {-11, 97},

    /* 308 -> 337 */
    {-16, 96}, {-7, 88}, {-8, 85}, {-7, 85},
    {-9, 85}, {-13, 88}, {4, 66}, {-3, 77},
    {-3, 76}, {-6, 76}, {10, 58}, {-1, 76},
    {-1, 83}, {-7, 99}, {-14, 95}, {2, 95},
    {0, 76}, {-5, 74}, {0, 70}, {-11, 75},
    {1, 68}, {0, 65}, {-14, 73}, {3, 62},
    {4, 62}, {-1, 68}, {-13, 75}, {11, 55},
    {5, 64}, {12, 70},

    /* 338 -> 368 */
    {15, 6}, {6, 19}, {7, 16}, {12, 14},
    {18, 13}, {13, 11}, {13, 15}, {15, 16},
    {12, 23}, {13, 23}, {15, 20}, {14, 26},
    {14, 44}, {17, 40}, {17, 47}, {24, 17},
    {21, 21}, {25, 22}, {31, 27}, {22, 29},
    {19, 35}, {14, 50}, {10, 57}, {7, 63},
    {-2, 77}, {-4, 82}, {-3, 94}, {9, 69},
    {-12, 109}, {36, -35}, {36, -34},

    /* 369 -> 398 */
    {32, -26}, {37, -30}, {44, -32}, {34, -18},
    {34, -15}, {40, -15}, {33, -7}, {35, -5},
    {33, 0}, {38, 2}, {33, 13}, {23, 35},
    {13, 58}, {29, -3}, {26, 0}, {22, 30},
    {31, -7}, {35, -15}, {34, -3}, {34, 3},
    {36, -1}, {34, 5}, {32, 11}, {35, 5},
    {34, 12}, {39, 11}, {30, 29}, {34, 26},
    {29, 39}, {19, 66},

    /* 399 -> 435 */
    {31, 21}, {31, 31}, {25, 50},
    {-17, 120}, {-20, 112}, {-18, 114}, {-11, 85},
    {-15, 92}, {-14, 89}, {-26, 71}, {-15, 81},
    {-14, 80}, {0, 68}, {-14, 70}, {-24, 56},
    {-23, 68}, {-24, 50}, {-11, 74}, {23, -13},
    {26, -13}, {40, -15}, {49, -14}, {44, 3},
    {45, 6}, {44, 34}, {33, 54}, {19, 82},
    {-3, 75}, {-1, 23}, {1, 34}, {1, 43},
    {0, 54}, {-2, 55}, {0, 61}, {1, 64},
    {0, 68}, {-9, 92},

    /* 436 -> 459 */
    {-14, 106}, {-13, 97}, {-15, 90}, {-12, 90},
    {-18, 88}, {-10, 73}, {-9, 79}, {-14, 86},
    {-10, 73}, {-10, 70}, {-10, 69}, {-5, 66},
    {-9, 64}, {-5, 58}, {2, 59}, {21, -10},
    {24, -11}, {28, -8}, {28, -1}, {29, 3},
    {29, 9}, {35, 20}, {29, 36}, {14, 67}
};

/* P and B  Slices can have  cabac_init_idc == 0, 1 or 2 */

static const i32 h264ContextInit[3][460][2] = {
    /* cabac_init_idc == 0 */
    {
     /* 0 -> 10 */
     {20, -15}, {2, 54}, {3, 74}, {20, -15},
     {2, 54}, {3, 74}, {-28, 127}, {-23, 104},
     {-6, 53}, {-1, 54}, {7, 51},

     /* 11 -> 23 */
     {23, 33}, {23, 2}, {21, 0}, {1, 9},
     {0, 49}, {-37, 118}, {5, 57}, {-13, 78},
     {-11, 65}, {1, 62}, {12, 49}, {-4, 73},
     {17, 50},

     /* 24 -> 39 */
     {18, 64}, {9, 43}, {29, 0}, {26, 67},
     {16, 90}, {9, 104}, {-46, 127}, {-20, 104},
     {1, 67}, {-13, 78}, {-11, 65}, {1, 62},
     {-6, 86}, {-17, 95}, {-6, 61}, {9, 45},

     /* 40 -> 53 */
     {-3, 69}, {-6, 81}, {-11, 96}, {6, 55},
     {7, 67}, {-5, 86}, {2, 88}, {0, 58},
     {-3, 76}, {-10, 94}, {5, 54}, {4, 69},
     {-3, 81}, {0, 88},

     /* 54 -> 59 */
     {-7, 67}, {-5, 74}, {-4, 74}, {-5, 80},
     {-7, 72}, {1, 58},

     /* 60 -> 69 */
     {0, 41}, {0, 63}, {0, 63}, {0, 63},
     {-9, 83}, {4, 86}, {0, 97}, {-7, 72},
     {13, 41}, {3, 62},

     /* 70 -> 87 */
     {0, 45}, {-4, 78}, {-3, 96}, {-27, 126},
     {-28, 98}, {-25, 101}, {-23, 67}, {-28, 82},
     {-20, 94}, {-16, 83}, {-22, 110}, {-21, 91},
     {-18, 102}, {-13, 93}, {-29, 127}, {-7, 92},
     {-5, 89}, {-7, 96}, {-13, 108}, {-3, 46},
     {-1, 65}, {-1, 57}, {-9, 93}, {-3, 74},
     {-9, 92}, {-8, 87}, {-23, 126}, {5, 54},
     {6, 60}, {6, 59}, {6, 69}, {-1, 48},
     {0, 68}, {-4, 69}, {-8, 88},

     /* 105 -> 165 */
     {-2, 85}, {-6, 78}, {-1, 75}, {-7, 77},
     {2, 54}, {5, 50}, {-3, 68}, {1, 50},
     {6, 42}, {-4, 81}, {1, 63}, {-4, 70},
     {0, 67}, {2, 57}, {-2, 76}, {11, 35},
     {4, 64}, {1, 61}, {11, 35}, {18, 25},
     {12, 24}, {13, 29}, {13, 36}, {-10, 93},
     {-7, 73}, {-2, 73}, {13, 46}, {9, 49},
     {-7, 100}, {9, 53}, {2, 53}, {5, 53},
     {-2, 61}, {0, 56}, {0, 56}, {-13, 63},
     {-5, 60}, {-1, 62}, {4, 57}, {-6, 69},
     {4, 57}, {14, 39}, {4, 51}, {13, 68},
     {3, 64}, {1, 61}, {9, 63}, {7, 50},
     {16, 39}, {5, 44}, {4, 52}, {11, 48},
     {-5, 60}, {-1, 59}, {0, 59}, {22, 33},
     {5, 44}, {14, 43}, {-1, 78}, {0, 60},
     {9, 69},

     /* 166 -> 226 */
     {11, 28}, {2, 40}, {3, 44}, {0, 49},
     {0, 46}, {2, 44}, {2, 51}, {0, 47},
     {4, 39}, {2, 62}, {6, 46}, {0, 54},
     {3, 54}, {2, 58}, {4, 63}, {6, 51},
     {6, 57}, {7, 53}, {6, 52}, {6, 55},
     {11, 45}, {14, 36}, {8, 53}, {-1, 82},
     {7, 55}, {-3, 78}, {15, 46}, {22, 31},
     {-1, 84}, {25, 7}, {30, -7}, {28, 3},
     {28, 4}, {32, 0}, {34, -1}, {30, 6},
     {30, 6}, {32, 9}, {31, 19}, {26, 27},
     {26, 30}, {37, 20}, {28, 34}, {17, 70},
     {1, 67}, {5, 59}, {9, 67}, {16, 30},
     {18, 32}, {18, 35}, {22, 29}, {24, 31},
     {23, 38}, {18, 43}, {20, 41}, {11, 63},
     {9, 59}, {9, 64}, {-1, 94}, {-2, 89},
     {-9, 108},

     /* 227 -> 275 */
     {-6, 76}, {-2, 44}, {0, 45}, {0, 52},
     {-3, 64}, {-2, 59}, {-4, 70}, {-4, 75},
     {-8, 82}, {-17, 102}, {-9, 77}, {3, 24},
     {0, 42}, {0, 48}, {0, 55}, {-6, 59},
     {-7, 71}, {-12, 83}, {-11, 87}, {-30, 119},
     {1, 58}, {-3, 29}, {-1, 36}, {1, 38},
     {2, 43}, {-6, 55}, {0, 58}, {0, 64},
     {-3, 74}, {-10, 90}, {0, 70}, {-4, 29},
     {5, 31}, {7, 42}, {1, 59}, {-2, 58},
     {-3, 72}, {-3, 81}, {-11, 97}, {0, 58},
     {8, 5}, {10, 14}, {14, 18}, {13, 27},
     {2, 40}, {0, 58}, {-3, 70}, {-6, 79},
     {-8, 85},

     /* 276 special case, bypass used */
     {0, 0},

     /* 277 -> 337 */
     {-13, 106}, {-16, 106}, {-10, 87}, {-21, 114},
     {-18, 110}, {-14, 98}, {-22, 110}, {-21, 106},
     {-18, 103}, {-21, 107}, {-23, 108}, {-26, 112},
     {-10, 96}, {-12, 95}, {-5, 91}, {-9, 93},
     {-22, 94}, {-5, 86}, {9, 67}, {-4, 80},
     {-10, 85}, {-1, 70}, {7, 60}, {9, 58},
     {5, 61}, {12, 50}, {15, 50}, {18, 49},
     {17, 54}, {10, 41}, {7, 46}, {-1, 51},
     {7, 49}, {8, 52}, {9, 41}, {6, 47},
     {2, 55}, {13, 41}, {10, 44}, {6, 50},
     {5, 53}, {13, 49}, {4, 63}, {6, 64},
     {-2, 69}, {-2, 59}, {6, 70}, {10, 44},
     {9, 31}, {12, 43}, {3, 53}, {14, 34},
     {10, 38}, {-3, 52}, {13, 40}, {17, 32},
     {7, 44}, {7, 38}, {13, 50}, {10, 57},
     {26, 43},

     /* 338 -> 398 */
     {14, 11}, {11, 14}, {9, 11}, {18, 11},
     {21, 9}, {23, -2}, {32, -15}, {32, -15},
     {34, -21}, {39, -23}, {42, -33}, {41, -31},
     {46, -28}, {38, -12}, {21, 29}, {45, -24},
     {53, -45}, {48, -26}, {65, -43}, {43, -19},
     {39, -10}, {30, 9}, {18, 26}, {20, 27},
     {0, 57}, {-14, 82}, {-5, 75}, {-19, 97},
     {-35, 125}, {27, 0}, {28, 0}, {31, -4},
     {27, 6}, {34, 8}, {30, 10}, {24, 22},
     {33, 19}, {22, 32}, {26, 31}, {21, 41},
     {26, 44}, {23, 47}, {16, 65}, {14, 71},
     {8, 60}, {6, 63}, {17, 65}, {21, 24},
     {23, 20}, {26, 23}, {27, 32}, {28, 23},
     {28, 24}, {23, 40}, {24, 32}, {28, 29},
     {23, 42}, {19, 57}, {22, 53}, {22, 61},
     {11, 86},

     /* 399 -> 435 */
     {12, 40}, {11, 51}, {14, 59},
     {-4, 79}, {-7, 71}, {-5, 69}, {-9, 70},
     {-8, 66}, {-10, 68}, {-19, 73}, {-12, 69},
     {-16, 70}, {-15, 67}, {-20, 62}, {-19, 70},
     {-16, 66}, {-22, 65}, {-20, 63}, {9, -2},
     {26, -9}, {33, -9}, {39, -7}, {41, -2},
     {45, 3}, {49, 9}, {45, 27}, {36, 59},
     {-6, 66}, {-7, 35}, {-7, 42}, {-8, 45},
     {-5, 48}, {-12, 56}, {-6, 60}, {-5, 62},
     {-8, 66}, {-8, 76},

     /* 436 -> 459 */
     {-5, 85}, {-6, 81}, {-10, 77}, {-7, 81},
     {-17, 80}, {-18, 73}, {-4, 74}, {-10, 83},
     {-9, 71}, {-9, 67}, {-1, 61}, {-8, 66},
     {-14, 66}, {0, 59}, {2, 59}, {21, -13},
     {33, -14}, {39, -7}, {46, -2}, {51, 2},
     {60, 6}, {61, 17}, {55, 34}, {42, 62},
     },

    /* cabac_init_idc == 1 */
    {
     /* 0 -> 10 */
     {20, -15}, {2, 54}, {3, 74}, {20, -15},
     {2, 54}, {3, 74}, {-28, 127}, {-23, 104},
     {-6, 53}, {-1, 54}, {7, 51},

     /* 11 -> 23 */
     {22, 25}, {34, 0}, {16, 0}, {-2, 9},
     {4, 41}, {-29, 118}, {2, 65}, {-6, 71},
     {-13, 79}, {5, 52}, {9, 50}, {-3, 70},
     {10, 54},

     /* 24 -> 39 */
     {26, 34}, {19, 22}, {40, 0}, {57, 2},
     {41, 36}, {26, 69}, {-45, 127}, {-15, 101},
     {-4, 76}, {-6, 71}, {-13, 79}, {5, 52},
     {6, 69}, {-13, 90}, {0, 52}, {8, 43},

     /* 40 -> 53 */
     {-2, 69}, {-5, 82}, {-10, 96}, {2, 59},
     {2, 75}, {-3, 87}, {-3, 100}, {1, 56},
     {-3, 74}, {-6, 85}, {0, 59}, {-3, 81},
     {-7, 86}, {-5, 95},

     /* 54 -> 59 */
     {-1, 66}, {-1, 77}, {1, 70}, {-2, 86},
     {-5, 72}, {0, 61},

     /* 60 -> 69 */
     {0, 41}, {0, 63}, {0, 63}, {0, 63},
     {-9, 83}, {4, 86}, {0, 97}, {-7, 72},
     {13, 41}, {3, 62},

     /* 70 -> 104 */
     {13, 15}, {7, 51}, {2, 80}, {-39, 127},
     {-18, 91}, {-17, 96}, {-26, 81}, {-35, 98},
     {-24, 102}, {-23, 97}, {-27, 119}, {-24, 99},
     {-21, 110}, {-18, 102}, {-36, 127}, {0, 80},
     {-5, 89}, {-7, 94}, {-4, 92}, {0, 39},
     {0, 65}, {-15, 84}, {-35, 127}, {-2, 73},
     {-12, 104}, {-9, 91}, {-31, 127}, {3, 55},
     {7, 56}, {7, 55}, {8, 61}, {-3, 53},
     {0, 68}, {-7, 74}, {-9, 88},

     /* 105 -> 165 */
     {-13, 103}, {-13, 91}, {-9, 89}, {-14, 92},
     {-8, 76}, {-12, 87}, {-23, 110}, {-24, 105},
     {-10, 78}, {-20, 112}, {-17, 99}, {-78, 127},
     {-70, 127}, {-50, 127}, {-46, 127}, {-4, 66},
     {-5, 78}, {-4, 71}, {-8, 72}, {2, 59},
     {-1, 55}, {-7, 70}, {-6, 75}, {-8, 89},
     {-34, 119}, {-3, 75}, {32, 20}, {30, 22},
     {-44, 127}, {0, 54}, {-5, 61}, {0, 58},
     {-1, 60}, {-3, 61}, {-8, 67}, {-25, 84},
     {-14, 74}, {-5, 65}, {5, 52}, {2, 57},
     {0, 61}, {-9, 69}, {-11, 70}, {18, 55},
     {-4, 71}, {0, 58}, {7, 61}, {9, 41},
     {18, 25}, {9, 32}, {5, 43}, {9, 47},
     {0, 44}, {0, 51}, {2, 46}, {19, 38},
     {-4, 66}, {15, 38}, {12, 42}, {9, 34},
     {0, 89},

     /* 166 -> 226 */
     {4, 45}, {10, 28}, {10, 31}, {33, -11},
     {52, -43}, {18, 15}, {28, 0}, {35, -22},
     {38, -25}, {34, 0}, {39, -18}, {32, -12},
     {102, -94}, {0, 0}, {56, -15}, {33, -4},
     {29, 10}, {37, -5}, {51, -29}, {39, -9},
     {52, -34}, {69, -58}, {67, -63}, {44, -5},
     {32, 7}, {55, -29}, {32, 1}, {0, 0},
     {27, 36}, {33, -25}, {34, -30}, {36, -28},
     {38, -28}, {38, -27}, {34, -18}, {35, -16},
     {34, -14}, {32, -8}, {37, -6}, {35, 0},
     {30, 10}, {28, 18}, {26, 25}, {29, 41},
     {0, 75}, {2, 72}, {8, 77}, {14, 35},
     {18, 31}, {17, 35}, {21, 30}, {17, 45},
     {20, 42}, {18, 45}, {27, 26}, {16, 54},
     {7, 66}, {16, 56}, {11, 73}, {10, 67},
     {-10, 116},

     /* 227 -> 275 */
     {-23, 112}, {-15, 71}, {-7, 61}, {0, 53},
     {-5, 66}, {-11, 77}, {-9, 80}, {-9, 84},
     {-10, 87}, {-34, 127}, {-21, 101}, {-3, 39},
     {-5, 53}, {-7, 61}, {-11, 75}, {-15, 77},
     {-17, 91}, {-25, 107}, {-25, 111}, {-28, 122},
     {-11, 76}, {-10, 44}, {-10, 52}, {-10, 57},
     {-9, 58}, {-16, 72}, {-7, 69}, {-4, 69},
     {-5, 74}, {-9, 86}, {2, 66}, {-9, 34},
     {1, 32}, {11, 31}, {5, 52}, {-2, 55},
     {-2, 67}, {0, 73}, {-8, 89}, {3, 52},
     {7, 4}, {10, 8}, {17, 8}, {16, 19},
     {3, 37}, {-1, 61}, {-5, 73}, {-1, 70},
     {-4, 78},

     /* 276 special case, bypass used */
     {0, 0},

     /* 277 -> 337 */
     {-21, 126}, {-23, 124}, {-20, 110}, {-26, 126},
     {-25, 124}, {-17, 105}, {-27, 121}, {-27, 117},
     {-17, 102}, {-26, 117}, {-27, 116}, {-33, 122},
     {-10, 95}, {-14, 100}, {-8, 95}, {-17, 111},
     {-28, 114}, {-6, 89}, {-2, 80}, {-4, 82},
     {-9, 85}, {-8, 81}, {-1, 72}, {5, 64},
     {1, 67}, {9, 56}, {0, 69}, {1, 69},
     {7, 69}, {-7, 69}, {-6, 67}, {-16, 77},
     {-2, 64}, {2, 61}, {-6, 67}, {-3, 64},
     {2, 57}, {-3, 65}, {-3, 66}, {0, 62},
     {9, 51}, {-1, 66}, {-2, 71}, {-2, 75},
     {-1, 70}, {-9, 72}, {14, 60}, {16, 37},
     {0, 47}, {18, 35}, {11, 37}, {12, 41},
     {10, 41}, {2, 48}, {12, 41}, {13, 41},
     {0, 59}, {3, 50}, {19, 40}, {3, 66},
     {18, 50},

     /* 338 -> 398 */
     {19, -6}, {18, -6}, {14, 0}, {26, -12},
     {31, -16}, {33, -25}, {33, -22}, {37, -28},
     {39, -30}, {42, -30}, {47, -42}, {45, -36},
     {49, -34}, {41, -17}, {32, 9}, {69, -71},
     {63, -63}, {66, -64}, {77, -74}, {54, -39},
     {52, -35}, {41, -10}, {36, 0}, {40, -1},
     {30, 14}, {28, 26}, {23, 37}, {12, 55},
     {11, 65}, {37, -33}, {39, -36}, {40, -37},
     {38, -30}, {46, -33}, {42, -30}, {40, -24},
     {49, -29}, {38, -12}, {40, -10}, {38, -3},
     {46, -5}, {31, 20}, {29, 30}, {25, 44},
     {12, 48}, {11, 49}, {26, 45}, {22, 22},
     {23, 22}, {27, 21}, {33, 20}, {26, 28},
     {30, 24}, {27, 34}, {18, 42}, {25, 39},
     {18, 50}, {12, 70}, {21, 54}, {14, 71},
     {11, 83},

     /* 399 -> 435 */
     {25, 32}, {21, 49}, {21, 54},
     {-5, 85}, {-6, 81}, {-10, 77}, {-7, 81},
     {-17, 80}, {-18, 73}, {-4, 74}, {-10, 83},
     {-9, 71}, {-9, 67}, {-1, 61}, {-8, 66},
     {-14, 66}, {0, 59}, {2, 59}, {17, -10},
     {32, -13}, {42, -9}, {49, -5}, {53, 0},
     {64, 3}, {68, 10}, {66, 27}, {47, 57},
     {-5, 71}, {0, 24}, {-1, 36}, {-2, 42},
     {-2, 52}, {-9, 57}, {-6, 63}, {-4, 65},
     {-4, 67}, {-7, 82},

     /* 436 -> 459 */
     {-3, 81}, {-3, 76}, {-7, 72}, {-6, 78},
     {-12, 72}, {-14, 68}, {-3, 70}, {-6, 76},
     {-5, 66}, {-5, 62}, {0, 57}, {-4, 61},
     {-9, 60}, {1, 54}, {2, 58}, {17, -10},
     {32, -13}, {42, -9}, {49, -5}, {53, 0},
     {64, 3}, {68, 10}, {66, 27}, {47, 57},
     },

    /* cabac_init_idc == 2 */
    {
     /* 0 -> 10 */
     {20, -15}, {2, 54}, {3, 74}, {20, -15},
     {2, 54}, {3, 74}, {-28, 127}, {-23, 104},
     {-6, 53}, {-1, 54}, {7, 51},

     /* 11 -> 23 */
     {29, 16}, {25, 0}, {14, 0}, {-10, 51},
     {-3, 62}, {-27, 99}, {26, 16}, {-4, 85},
     {-24, 102}, {5, 57}, {6, 57}, {-17, 73},
     {14, 57},

     /* 24 -> 39 */
     {20, 40}, {20, 10}, {29, 0}, {54, 0},
     {37, 42}, {12, 97}, {-32, 127}, {-22, 117},
     {-2, 74}, {-4, 85}, {-24, 102}, {5, 57},
     {-6, 93}, {-14, 88}, {-6, 44}, {4, 55},

     /* 40 -> 53 */
     {-11, 89}, {-15, 103}, {-21, 116}, {19, 57},
     {20, 58}, {4, 84}, {6, 96}, {1, 63},
     {-5, 85}, {-13, 106}, {5, 63}, {6, 75},
     {-3, 90}, {-1, 101},

     /* 54 -> 59 */
     {3, 55}, {-4, 79}, {-2, 75}, {-12, 97},
     {-7, 50}, {1, 60},

     /* 60 -> 69 */
     {0, 41}, {0, 63}, {0, 63}, {0, 63},
     {-9, 83}, {4, 86}, {0, 97}, {-7, 72},
     {13, 41}, {3, 62},

     /* 70 -> 104 */
     {7, 34}, {-9, 88}, {-20, 127}, {-36, 127},
     {-17, 91}, {-14, 95}, {-25, 84}, {-25, 86},
     {-12, 89}, {-17, 91}, {-31, 127}, {-14, 76},
     {-18, 103}, {-13, 90}, {-37, 127}, {11, 80},
     {5, 76}, {2, 84}, {5, 78}, {-6, 55},
     {4, 61}, {-14, 83}, {-37, 127}, {-5, 79},
     {-11, 104}, {-11, 91}, {-30, 127}, {0, 65},
     {-2, 79}, {0, 72}, {-4, 92}, {-6, 56},
     {3, 68}, {-8, 71}, {-13, 98},

     /* 105 -> 165 */
     {-4, 86}, {-12, 88}, {-5, 82}, {-3, 72},
     {-4, 67}, {-8, 72}, {-16, 89}, {-9, 69},
     {-1, 59}, {5, 66}, {4, 57}, {-4, 71},
     {-2, 71}, {2, 58}, {-1, 74}, {-4, 44},
     {-1, 69}, {0, 62}, {-7, 51}, {-4, 47},
     {-6, 42}, {-3, 41}, {-6, 53}, {8, 76},
     {-9, 78}, {-11, 83}, {9, 52}, {0, 67},
     {-5, 90}, {1, 67}, {-15, 72}, {-5, 75},
     {-8, 80}, {-21, 83}, {-21, 64}, {-13, 31},
     {-25, 64}, {-29, 94}, {9, 75}, {17, 63},
     {-8, 74}, {-5, 35}, {-2, 27}, {13, 91},
     {3, 65}, {-7, 69}, {8, 77}, {-10, 66},
     {3, 62}, {-3, 68}, {-20, 81}, {0, 30},
     {1, 7}, {-3, 23}, {-21, 74}, {16, 66},
     {-23, 124}, {17, 37}, {44, -18}, {50, -34},
     {-22, 127},

     /* 166 -> 226 */
     {4, 39}, {0, 42}, {7, 34}, {11, 29},
     {8, 31}, {6, 37}, {7, 42}, {3, 40},
     {8, 33}, {13, 43}, {13, 36}, {4, 47},
     {3, 55}, {2, 58}, {6, 60}, {8, 44},
     {11, 44}, {14, 42}, {7, 48}, {4, 56},
     {4, 52}, {13, 37}, {9, 49}, {19, 58},
     {10, 48}, {12, 45}, {0, 69}, {20, 33},
     {8, 63}, {35, -18}, {33, -25}, {28, -3},
     {24, 10}, {27, 0}, {34, -14}, {52, -44},
     {39, -24}, {19, 17}, {31, 25}, {36, 29},
     {24, 33}, {34, 15}, {30, 20}, {22, 73},
     {20, 34}, {19, 31}, {27, 44}, {19, 16},
     {15, 36}, {15, 36}, {21, 28}, {25, 21},
     {30, 20}, {31, 12}, {27, 16}, {24, 42},
     {0, 93}, {14, 56}, {15, 57}, {26, 38},
     {-24, 127},

     /* 227 -> 275 */
     {-24, 115}, {-22, 82}, {-9, 62}, {0, 53},
     {0, 59}, {-14, 85}, {-13, 89}, {-13, 94},
     {-11, 92}, {-29, 127}, {-21, 100}, {-14, 57},
     {-12, 67}, {-11, 71}, {-10, 77}, {-21, 85},
     {-16, 88}, {-23, 104}, {-15, 98}, {-37, 127},
     {-10, 82}, {-8, 48}, {-8, 61}, {-8, 66},
     {-7, 70}, {-14, 75}, {-10, 79}, {-9, 83},
     {-12, 92}, {-18, 108}, {-4, 79}, {-22, 69},
     {-16, 75}, {-2, 58}, {1, 58}, {-13, 78},
     {-9, 83}, {-4, 81}, {-13, 99}, {-13, 81},
     {-6, 38}, {-13, 62}, {-6, 58}, {-2, 59},
     {-16, 73}, {-10, 76}, {-13, 86}, {-9, 83},
     {-10, 87},

     /* 276 special case, bypass used */
     {0, 0},

     /* 277 -> 337 */
     {-22, 127}, {-25, 127}, {-25, 120}, {-27, 127},
     {-19, 114}, {-23, 117}, {-25, 118}, {-26, 117},
     {-24, 113}, {-28, 118}, {-31, 120}, {-37, 124},
     {-10, 94}, {-15, 102}, {-10, 99}, {-13, 106},
     {-50, 127}, {-5, 92}, {17, 57}, {-5, 86},
     {-13, 94}, {-12, 91}, {-2, 77}, {0, 71},
     {-1, 73}, {4, 64}, {-7, 81}, {5, 64},
     {15, 57}, {1, 67}, {0, 68}, {-10, 67},
     {1, 68}, {0, 77}, {2, 64}, {0, 68},
     {-5, 78}, {7, 55}, {5, 59}, {2, 65},
     {14, 54}, {15, 44}, {5, 60}, {2, 70},
     {-2, 76}, {-18, 86}, {12, 70}, {5, 64},
     {-12, 70}, {11, 55}, {5, 56}, {0, 69},
     {2, 65}, {-6, 74}, {5, 54}, {7, 54},
     {-6, 76}, {-11, 82}, {-2, 77}, {-2, 77},
     {25, 42},

     /* 338 -> 398 */
     {17, -13}, {16, -9}, {17, -12}, {27, -21},
     {37, -30}, {41, -40}, {42, -41}, {48, -47},
     {39, -32}, {46, -40}, {52, -51}, {46, -41},
     {52, -39}, {43, -19}, {32, 11}, {61, -55},
     {56, -46}, {62, -50}, {81, -67}, {45, -20},
     {35, -2}, {28, 15}, {34, 1}, {39, 1},
     {30, 17}, {20, 38}, {18, 45}, {15, 54},
     {0, 79}, {36, -16}, {37, -14}, {37, -17},
     {32, 1}, {34, 15}, {29, 15}, {24, 25},
     {34, 22}, {31, 16}, {35, 18}, {31, 28},
     {33, 41}, {36, 28}, {27, 47}, {21, 62},
     {18, 31}, {19, 26}, {36, 24}, {24, 23},
     {27, 16}, {24, 30}, {31, 29}, {22, 41},
     {22, 42}, {16, 60}, {15, 52}, {14, 60},
     {3, 78}, {-16, 123}, {21, 53}, {22, 56},
     {25, 61},

     /* 399 -> 435 */
     {21, 33}, {19, 50}, {17, 61},
     {-3, 78}, {-8, 74}, {-9, 72}, {-10, 72},
     {-18, 75}, {-12, 71}, {-11, 63}, {-5, 70},
     {-17, 75}, {-14, 72}, {-16, 67}, {-8, 53},
     {-14, 59}, {-9, 52}, {-11, 68}, {9, -2},
     {30, -10}, {31, -4}, {33, -1}, {33, 7},
     {31, 12}, {37, 23}, {31, 38}, {20, 64},
     {-9, 71}, {-7, 37}, {-8, 44}, {-11, 49},
     {-10, 56}, {-12, 59}, {-8, 63}, {-9, 67},
     {-6, 68}, {-10, 79},

     /* 436 -> 459 */
     {-3, 78}, {-8, 74}, {-9, 72}, {-10, 72},
     {-18, 75}, {-12, 71}, {-11, 63}, {-5, 70},
     {-17, 75}, {-14, 72}, {-16, 67}, {-8, 53},
     {-14, 59}, {-9, 52}, {-11, 68}, {9, -2},
     {30, -10}, {31, -4}, {33, -1}, {33, 7},
     {31, 12}, {37, 23}, {31, 38}, {20, 64},
     }
};

#ifdef H8290_PRECALC_CABAC_INIT
static const u8 preCalculatedContextTable[3][48256] = {
/*cabac_init_idc = 0*/
{124,18,21,124,18,21,125,81,20,18,24,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,39,45,67,17,44,2,104,16,11,125,77,37,21,87,125,125,
125,63,125,101,125,119,103,117,103,0,9,41,81,13,59,53,125,21,67,55,
125,14,37,25,123,59,47,27,15,0,9,41,2,3,4,14,5,1,4,29,
26,22,56,38,50,36,34,38,92,24,26,88,60,2,89,73,75,55,61,49,
41,45,39,47,61,13,17,21,8,77,73,63,23,17,23,15,34,11,2,3,
52,17,12,18,2,17,124,108,76,90,108,88,52,90,68,60,66,36,10,2,
4,50,36,48,42,38,36,44,28,58,42,16,24,34,51,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,92,124,120,82,124,124,124,124,120,116,124,
94,82,30,52,6,9,67,15,42,26,18,2,10,0,17,21,55,7,72,48,
38,34,1,9,29,27,45,57,16,6,2,3,19,25,33,49,93,67,41,31,
19,21,45,65,67,107,29,60,30,20,2,15,31,45,53,67,124,59,41,31,
5,15,2,6,8,23,2,10,5,31,15,9,38,2,54,46,72,68,38,54,
62,42,30,2,34,1,81,67,65,49,43,43,43,49,5,27,25,25,10,25,
39,71,63,63,25,21,13,23,9,3,19,2,2,9,23,16,1,13,114,88,
94,98,100,104,96,94,80,80,86,74,38,46,32,92,84,82,72,68,56,26,
12,0,27,37,61,11,91,124,124,124,124,124,124,124,124,124,124,124,122,100,
56,10,124,124,66,124,124,124,120,124,116,104,116,102,104,68,74,48,5,84,
64,26,113,97,101,43,57,51,15,35,33,9,13,14,9,26,21,124,124,124,
124,120,114,58,18,37,23,80,58,40,18,16,4,1,9,57,85,67,53,53,
49,19,31,45,19,13,11,5,1,10,8,124,124,124,124,120,108,86,54,7,
0,0,0,0,124,18,21,124,18,21,125,81,20,18,24,60,122,124,108,28,
109,12,29,3,2,28,19,26,1,40,124,7,53,81,125,81,7,29,3,2,
45,63,4,36,11,35,65,16,7,45,49,10,25,61,18,11,35,49,7,21,
21,33,17,10,44,0,0,0,39,45,67,17,44,2,36,29,65,125,69,75,
7,37,61,39,93,55,77,59,125,57,51,65,89,34,3,12,59,21,57,47,
125,18,6,8,11,30,9,11,49,43,29,23,27,18,26,9,26,42,35,0,
13,7,12,25,56,1,4,56,76,78,68,54,59,19,19,34,28,73,20,20,
20,4,14,14,0,6,2,12,11,12,48,24,9,1,4,0,26,48,38,22,
30,6,8,8,60,38,40,29,6,11,70,46,38,28,34,38,24,32,48,2,
34,18,18,10,0,24,12,20,22,16,36,54,20,37,16,29,34,64,41,112,
124,120,118,124,124,114,114,108,88,72,66,86,58,13,7,8,7,66,62,56,
68,64,50,40,44,0,8,1,61,51,89,25,38,36,22,1,8,13,23,37,
77,27,78,42,30,16,8,15,39,47,111,10,68,54,50,40,16,10,1,21,
53,13,68,64,42,8,10,17,35,67,10,116,98,90,72,46,10,13,31,43,
124,85,85,47,101,93,69,93,85,79,87,89,97,65,63,55,59,61,45,7,
33,43,13,6,10,4,26,26,28,18,44,34,24,28,22,44,32,16,44,38,
26,20,28,0,1,11,8,13,38,64,40,20,58,50,22,46,62,38,50,26,
12,40,104,98,104,104,108,124,124,124,124,124,124,124,124,124,68,124,124,124,
124,124,124,108,74,72,12,37,23,67,123,124,124,124,114,110,106,82,88,62,
64,44,38,32,3,15,6,0,3,78,86,80,62,80,78,46,62,68,42,12,
20,4,45,46,24,8,31,15,11,13,5,9,19,11,13,7,2,13,5,3,
0,124,124,124,124,124,120,108,72,8,5,56,42,36,30,14,6,2,5,25,
43,35,27,35,33,19,21,39,15,7,4,5,5,8,8,124,124,124,124,122,
114,92,58,2,0,0,0,0,124,18,21,124,18,21,123,77,22,20,24,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,37,45,67,15,44,2,104,16,
11,123,75,37,19,83,123,123,123,59,123,97,123,115,101,115,101,2,7,39,
79,11,57,51,123,19,65,53,123,16,35,23,119,57,45,25,13,2,7,39,
4,1,4,14,3,1,4,27,26,22,56,38,50,36,34,38,90,24,26,86,
58,2,87,71,73,53,59,47,39,43,37,45,57,13,17,19,6,75,71,63,
21,17,21,13,34,9,2,3,50,15,12,16,2,17,124,108,76,90,108,88,
52,90,68,58,66,36,10,2,4,50,36,48,42,38,34,44,28,56,40,16,
22,32,51,124,124,124,124,124,124,124,124,124,124,124,124,124,120,88,124,118,
80,124,124,124,124,116,112,122,90,78,30,50,4,9,67,13,44,28,20,4,
10,0,15,19,53,5,74,50,40,34,0,7,27,25,43,55,18,8,4,1,
17,23,31,47,89,65,37,29,17,19,43,63,65,103,27,62,32,22,4,13,
29,43,51,65,124,57,39,29,5,13,2,8,10,21,4,12,3,29,15,9,
38,4,54,46,70,68,38,52,60,42,30,2,32,1,79,65,63,47,41,41,
41,47,5,25,23,23,10,23,37,69,61,63,25,19,13,21,9,3,17,2,
2,7,21,16,1,13,114,88,94,98,98,104,96,94,80,80,86,74,38,44,
30,90,82,80,70,66,54,26,12,0,25,35,59,11,89,124,124,124,124,124,
124,124,124,124,124,122,118,96,54,10,124,124,64,124,124,124,116,124,112,100,
112,98,100,66,70,46,7,82,62,24,109,93,97,41,55,49,11,33,31,9,
11,18,5,30,19,124,124,124,124,116,110,54,14,39,21,82,58,40,18,18,
4,1,9,55,83,65,51,51,45,17,29,43,17,11,9,3,0,12,8,124,
124,124,124,118,106,82,52,7,0,0,0,0,124,18,21,124,18,21,123,77,
22,20,24,58,120,124,108,28,103,12,27,1,2,28,17,24,3,40,124,9,
55,81,121,77,7,27,1,2,43,59,6,36,9,33,63,16,7,43,49,10,
23,59,18,11,33,49,5,19,19,31,15,10,44,0,0,0,37,45,67,15,
44,2,36,27,63,121,65,71,3,33,57,37,89,51,73,57,123,55,49,63,
87,36,1,14,57,19,55,45,121,18,6,8,11,32,9,9,47,41,27,21,
25,18,26,7,26,42,33,0,11,7,12,23,56,1,4,56,74,78,68,54,
57,17,17,34,28,71,20,20,20,6,14,14,2,8,4,12,9,12,48,24,
9,1,4,0,26,46,38,22,30,8,10,8,58,38,40,27,6,11,70,46,
38,28,34,38,24,32,48,2,34,18,18,10,0,24,12,20,22,16,36,54,
20,35,16,27,34,62,39,110,124,118,116,122,124,112,112,104,86,70,64,82,
56,15,7,8,7,64,60,54,66,62,48,38,42,0,8,1,59,49,87,23,
40,36,22,0,10,11,21,35,73,25,78,42,30,16,10,13,37,45,107,10,
70,56,50,40,18,10,1,19,51,13,70,64,42,8,12,15,33,65,10,116,
98,90,72,46,10,11,29,41,124,83,83,45,97,89,67,89,81,75,83,85,
93,63,61,53,57,57,43,7,31,41,11,6,10,4,26,26,26,16,44,34,
26,28,22,44,32,16,44,38,26,20,28,0,1,9,10,13,38,64,40,20,
58,50,24,46,60,38,50,26,12,38,104,98,104,102,106,124,124,124,124,124,
124,124,124,124,66,124,124,124,124,124,124,106,72,70,12,35,21,63,117,124,
124,124,112,106,104,80,84,60,62,42,36,30,5,15,6,0,5,76,84,78,
60,78,76,44,60,66,40,10,18,2,45,46,24,8,29,13,9,11,3,7,
15,9,11,5,6,9,3,0,4,124,124,124,124,124,116,102,68,4,3,58,
44,38,32,16,8,4,3,23,41,33,25,33,29,15,19,37,13,5,6,3,
3,8,8,124,124,124,124,116,108,86,52,1,0,0,0,0,124,18,21,124,
18,21,119,75,22,20,24,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
35,45,67,15,42,2,104,16,11,121,73,37,19,81,119,119,121,57,119,95,
119,113,99,113,99,4,7,37,77,11,57,49,119,19,65,53,121,16,35,23,
117,57,43,25,13,2,7,37,4,1,2,14,3,1,4,27,26,22,54,38,
48,36,34,38,86,24,26,82,56,0,85,69,71,51,57,45,37,41,37,43,
55,13,17,19,4,75,69,63,21,17,19,13,32,7,2,3,48,13,10,14,
2,19,120,106,74,88,106,86,50,88,68,56,64,36,10,2,4,48,34,46,
40,36,32,42,26,52,38,14,20,30,51,124,124,124,124,124,124,124,124,124,
124,124,124,124,116,82,124,114,76,124,124,124,124,112,108,116,86,74,28,46,
2,11,67,13,44,28,20,4,10,0,15,19,51,5,74,50,40,34,2,7,
25,25,41,53,20,10,4,1,15,23,31,45,87,63,35,27,17,19,41,61,
63,101,27,62,32,22,4,11,27,41,49,63,124,57,39,29,5,13,2,8,
10,21,4,12,1,29,15,9,36,4,52,44,68,66,38,50,58,42,30,0,
30,3,77,63,61,47,41,41,39,45,5,25,23,23,8,23,37,69,59,63,
25,19,13,19,9,3,15,2,2,7,19,14,1,15,112,88,94,96,96,102,
94,92,78,78,84,72,36,42,28,86,80,76,66,64,52,24,10,0,25,35,
59,13,87,124,124,124,124,124,124,124,124,124,124,118,114,92,52,8,124,120,
62,124,124,124,112,120,108,96,108,94,96,62,66,42,9,78,58,20,107,91,
95,39,53,47,7,31,29,9,9,20,3,32,17,124,124,124,124,110,104,48,
10,41,21,82,58,40,18,18,4,1,9,53,81,63,49,49,43,15,27,41,
15,9,7,3,2,12,8,124,124,124,122,114,102,78,48,9,0,0,0,0,
124,18,21,124,18,21,119,75,22,20,24,56,118,122,108,28,99,12,25,0,
2,26,17,22,5,38,120,13,57,83,115,75,7,25,0,2,43,57,6,34,
9,33,61,16,7,43,49,10,23,57,18,11,33,49,5,19,19,31,15,10,
44,0,0,0,35,45,67,15,42,2,36,27,63,117,61,67,1,29,55,35,
87,49,71,55,119,55,49,63,85,36,1,14,55,19,53,45,119,18,6,8,
11,32,9,9,47,41,27,21,25,18,26,7,26,42,33,0,11,7,12,23,
54,1,4,54,72,76,66,52,55,17,17,32,26,71,18,20,20,6,14,14,
4,8,4,12,9,12,46,24,11,1,4,1,26,44,38,22,28,8,10,8,
56,38,38,27,6,13,68,46,38,28,34,38,24,32,48,2,34,18,18,10,
0,24,12,20,22,16,34,52,18,35,16,27,32,60,39,106,124,114,112,118,
120,108,108,100,82,66,60,78,52,17,7,8,9,62,58,52,64,58,46,36,
40,1,6,3,59,49,85,23,40,36,22,0,10,11,21,35,71,23,78,42,
30,16,10,13,35,43,103,10,70,56,50,40,18,10,1,19,49,13,70,64,
42,8,12,15,33,63,10,114,96,88,70,46,10,11,29,41,124,81,81,43,
95,87,65,87,79,73,81,83,89,61,59,53,55,55,43,9,31,39,11,6,
8,4,24,24,24,14,42,34,26,28,20,42,32,16,42,36,26,20,26,0,
1,9,10,13,36,62,38,20,56,48,24,44,58,38,50,24,10,34,102,96,
102,100,104,124,124,124,124,124,124,124,124,124,64,124,124,124,124,124,124,102,
70,68,12,33,21,61,113,120,120,124,108,102,100,76,80,58,58,40,32,28,
7,17,4,0,7,74,82,74,56,74,72,42,56,62,38,8,16,0,47,44,
22,6,29,13,9,9,3,5,13,7,9,3,8,7,1,2,6,124,124,124,
124,120,110,96,62,0,3,58,44,38,32,18,8,4,3,23,41,33,23,33,
27,13,19,35,11,3,6,3,1,8,8,124,124,124,120,110,100,78,46,7,
0,0,0,0,124,18,21,124,18,21,115,71,24,20,22,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,35,45,67,13,40,2,104,16,11,119,71,37,
17,79,115,115,117,55,115,93,115,111,97,111,97,6,7,35,75,11,55,49,
115,19,63,51,119,16,35,21,113,55,41,25,13,2,7,35,6,0,2,14,
3,1,4,27,26,20,54,38,46,36,34,38,82,24,24,78,54,1,83,67,
69,49,55,45,35,41,35,41,53,13,17,19,2,73,67,63,21,17,17,13,
30,5,2,3,46,11,10,12,2,21,118,104,74,86,104,84,50,86,66,54,
62,36,10,2,2,46,32,44,38,34,30,40,26,48,36,14,18,28,51,124,
124,124,124,124,124,124,124,124,124,124,124,124,110,78,124,110,74,124,122,124,
118,108,102,112,82,68,26,42,0,13,67,13,46,28,20,4,10,0,15,19,
51,5,74,50,40,34,4,5,25,23,41,51,22,10,6,1,13,21,29,45,
85,61,33,25,15,19,39,59,61,99,25,62,32,22,4,9,27,39,47,61,
124,55,37,27,5,13,2,8,10,21,4,12,1,29,15,9,36,6,50,42,
66,64,38,48,56,42,30,0,28,3,75,61,59,45,39,39,39,43,5,25,
23,21,8,23,37,67,57,63,25,19,13,17,9,3,13,2,2,7,17,12,
1,17,110,86,92,94,94,100,92,90,76,76,82,70,34,40,26,84,78,74,
62,60,50,22,10,1,25,35,59,13,85,124,124,124,124,124,124,124,124,124,
124,114,108,88,48,6,122,118,58,124,124,120,108,116,104,92,104,90,90,58,
62,38,11,74,54,18,105,89,93,37,51,45,5,29,27,9,7,24,0,36,
15,124,124,124,124,104,98,42,6,43,21,82,58,40,18,18,4,1,9,53,
79,61,47,47,41,15,27,39,15,9,7,3,2,12,8,124,124,124,118,110,
98,74,44,11,0,0,0,0,124,18,21,124,18,21,115,71,24,20,22,52,
114,120,108,28,95,12,23,2,2,24,17,20,7,38,116,15,59,83,109,73,
7,23,2,2,41,55,8,34,9,31,59,14,9,43,49,10,23,57,18,11,
33,49,3,19,19,31,13,10,44,0,0,0,35,45,67,13,40,2,36,27,
63,113,57,65,2,25,53,33,83,47,69,53,115,53,49,61,83,36,1,14,
55,19,53,43,115,18,4,6,13,32,9,9,45,41,25,21,23,18,26,7,
26,40,33,0,11,7,12,23,52,1,4,52,70,74,64,50,55,15,17,30,
26,69,18,20,20,6,14,14,6,8,4,12,7,12,44,24,13,1,4,1,
24,42,38,22,26,8,10,8,52,38,36,27,6,13,66,46,38,28,34,38,
24,32,48,2,32,18,18,10,0,22,10,18,20,14,32,50,18,35,14,27,
30,56,39,104,124,110,108,114,116,104,104,96,78,64,58,74,48,19,7,8,
9,60,56,50,60,56,42,34,38,3,6,3,59,49,85,21,40,36,22,0,
10,11,21,33,69,23,78,42,30,16,12,11,33,41,99,10,70,56,50,40,
20,10,1,19,49,13,70,64,40,8,12,15,33,61,10,114,96,86,68,46,
10,11,27,39,124,79,79,43,93,85,63,83,77,71,79,79,87,61,57,53,
55,51,43,9,31,39,11,4,8,4,22,22,22,12,42,32,26,26,20,42,
30,16,40,36,24,20,24,0,3,9,10,15,36,62,36,20,54,48,24,42,
56,36,48,22,10,32,100,94,102,98,102,122,124,124,124,124,124,124,124,124,
62,124,124,124,124,124,124,98,68,66,12,31,21,59,109,116,116,124,104,98,
96,74,76,54,56,38,30,24,9,19,4,1,9,72,78,72,52,70,68,38,
54,58,34,6,12,3,49,42,20,4,29,11,9,9,1,5,11,5,7,1,
10,5,0,6,8,124,124,124,124,116,104,90,56,3,1,60,46,40,32,20,
10,4,1,21,41,31,23,31,25,11,19,35,11,3,6,1,0,8,8,124,
124,124,114,104,92,70,38,11,0,0,0,0,124,18,21,124,18,21,113,69,
24,20,22,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,33,47,67,13,
38,2,104,16,11,117,69,37,17,75,113,111,115,53,113,89,111,109,97,109,
97,6,7,33,73,11,55,47,111,19,63,51,117,16,33,21,111,55,41,25,
11,2,7,35,6,0,0,12,3,1,4,27,26,20,52,38,46,36,34,36,
78,24,24,74,52,3,81,65,67,47,55,43,33,39,35,39,51,13,17,17,
0,73,65,63,21,17,17,13,28,3,2,3,42,9,8,10,2,23,114,102,
72,84,102,82,48,84,66,50,60,34,10,2,2,44,32,42,38,32,28,38,
24,44,34,12,16,26,51,124,124,124,124,124,124,124,124,124,124,124,124,118,
106,72,124,108,70,124,118,124,114,102,98,106,78,64,24,40,3,15,67,13,
46,30,20,4,10,0,15,19,49,3,76,50,40,34,6,5,23,23,39,51,
24,12,6,1,13,21,29,43,83,61,31,25,15,19,37,57,61,97,25,64,
32,22,4,7,25,39,45,59,124,55,37,27,5,13,2,8,10,19,4,12,
0,29,15,9,34,6,48,40,64,62,38,44,54,40,30,1,26,5,75,61,
57,45,39,39,37,41,7,25,23,21,6,23,37,67,55,63,25,17,13,17,
9,3,11,2,0,7,15,12,3,19,108,86,92,92,92,98,90,88,74,74,
80,68,32,38,24,80,74,70,58,58,48,20,8,1,25,35,59,15,85,124,
124,124,124,124,124,124,124,124,120,110,104,84,46,4,118,114,56,124,124,116,
104,110,100,88,100,86,86,54,58,34,13,70,50,14,103,87,91,37,49,43,
1,27,25,9,5,26,2,38,15,124,124,124,124,98,92,36,2,45,21,82,
58,40,18,18,4,1,9,51,77,59,45,47,39,13,25,37,13,7,5,1,
4,14,8,124,124,124,114,106,94,70,40,13,0,0,0,0,124,18,21,124,
18,21,113,69,24,20,22,50,112,116,108,28,89,10,21,2,2,22,17,18,
9,36,112,19,61,85,103,71,7,21,2,2,41,53,8,32,9,31,59,14,
9,41,49,10,23,55,16,13,33,49,3,17,19,29,13,10,44,0,0,0,
33,47,67,13,38,2,36,27,63,111,55,61,4,23,51,31,81,43,67,51,
111,53,47,61,81,36,1,14,53,19,51,43,113,16,4,6,13,32,9,9,
45,41,25,21,23,18,24,7,26,40,33,0,11,7,12,23,52,3,4,52,
68,72,62,48,53,15,17,28,24,69,16,20,18,6,14,14,8,10,4,10,
7,10,42,22,15,1,4,3,24,40,36,20,26,10,10,8,50,36,34,27,
6,15,66,46,38,28,34,38,24,32,46,2,32,18,18,10,1,22,10,18,
20,14,32,48,16,35,14,27,28,54,39,100,124,106,104,110,112,100,100,92,
74,60,54,68,44,21,7,6,11,58,54,48,58,52,40,32,34,3,4,5,
59,49,83,21,40,36,22,0,10,11,21,33,67,21,78,42,30,16,12,11,
33,41,95,10,70,56,50,40,20,10,1,19,47,13,70,62,40,8,12,15,
33,61,10,112,94,84,66,46,10,11,27,39,124,77,77,41,89,83,61,81,
73,69,75,77,83,59,57,51,53,49,41,11,31,37,11,4,6,2,20,20,
20,10,40,32,26,26,18,40,30,16,38,34,24,18,22,1,3,9,10,15,
34,60,34,20,52,46,24,40,54,36,48,20,8,28,98,94,100,96,98,120,
124,124,124,124,124,124,124,124,58,124,124,124,124,124,124,94,66,62,12,29,
19,57,105,114,112,120,102,94,92,70,72,52,52,34,26,22,11,21,2,1,
11,68,76,68,50,66,64,36,50,54,32,4,10,5,49,40,20,2,29,11,
7,7,1,3,9,5,5,0,12,3,2,8,10,124,124,124,122,110,98,84,
50,9,1,60,46,40,34,20,10,6,1,21,39,31,21,31,23,9,19,33,
9,1,6,1,2,8,8,124,124,122,108,98,84,62,32,17,0,0,0,0,
124,18,21,124,18,21,109,65,24,20,20,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,33,47,67,11,36,2,104,16,11,115,67,37,15,73,109,107,
111,51,109,87,107,107,95,107,95,8,7,31,71,11,53,45,107,19,63,49,
113,18,33,19,109,53,39,25,11,4,5,33,8,2,0,12,3,1,4,27,
26,18,50,38,44,36,34,36,74,24,22,72,50,5,79,63,65,45,53,41,
31,37,33,37,49,13,17,17,1,71,63,63,19,17,15,13,26,1,2,3,
40,7,8,8,2,23,112,100,72,82,100,80,46,84,66,48,58,34,10,2,
0,44,30,40,36,30,26,38,22,40,32,10,14,24,51,124,124,124,124,124,
124,124,124,124,124,124,124,114,102,68,120,104,66,124,114,120,110,98,94,100,
74,58,22,36,5,15,67,13,46,30,20,4,10,0,15,19,49,3,76,50,
40,34,8,3,21,23,37,49,26,14,6,0,11,19,27,43,81,59,27,23,
15,17,35,55,59,95,23,64,34,22,4,5,23,37,43,57,124,55,37,25,
5,13,2,8,10,19,4,14,0,29,15,9,32,8,46,38,62,62,38,42,
52,40,30,3,24,5,73,59,55,43,37,37,37,39,7,25,23,21,4,23,
37,65,53,63,25,17,13,15,9,3,9,2,0,7,13,10,3,19,106,86,
90,92,90,96,88,86,74,72,78,66,30,36,22,78,72,68,54,56,46,18,
6,3,25,33,59,15,83,124,124,124,124,124,124,124,124,120,116,106,100,80,
42,2,114,110,54,122,124,112,100,106,96,84,96,82,80,50,54,30,15,66,
46,12,101,83,89,35,47,41,2,25,23,9,3,30,6,42,13,124,124,124,
124,94,86,32,1,47,21,82,58,40,18,18,4,1,9,51,75,57,43,45,
37,11,25,35,11,5,3,1,4,14,8,124,124,124,112,102,90,66,36,15,
0,0,0,0,124,18,21,124,18,21,109,65,24,20,20,46,108,114,108,28,
85,10,19,4,2,22,15,16,11,36,108,23,63,85,97,67,7,19,4,2,
41,51,8,32,9,31,57,14,11,41,49,10,23,53,16,13,33,49,1,17,
17,29,11,10,44,0,0,0,33,47,67,11,36,2,36,25,63,107,51,59,
8,19,47,29,79,41,65,49,107,51,47,59,79,36,1,14,53,19,51,41,
109,16,4,6,13,32,9,7,43,41,25,21,21,18,24,7,26,40,31,0,
9,7,12,23,50,3,4,50,66,72,60,46,51,13,17,26,24,67,16,20,
18,6,14,14,10,10,4,10,7,10,40,22,17,1,4,3,22,38,36,20,
24,10,10,8,48,36,32,27,6,15,64,46,38,28,34,38,24,32,46,2,
32,18,18,10,1,22,10,16,20,14,30,46,16,35,12,27,26,52,39,98,
122,104,102,106,108,96,96,88,70,56,50,64,42,23,7,6,11,56,52,46,
56,50,36,30,32,5,4,5,59,49,83,21,40,36,22,0,10,9,19,31,
65,21,78,42,30,16,12,9,31,39,91,10,70,56,50,40,20,10,1,19,
45,13,72,62,38,8,12,15,33,59,10,112,92,82,64,46,10,11,27,37,
124,75,75,39,87,81,59,79,71,67,73,73,79,57,55,51,53,47,41,11,
29,35,11,2,6,2,20,18,18,8,38,30,26,24,18,40,30,16,36,32,
24,18,20,1,3,9,10,15,32,60,34,20,50,44,24,38,52,34,46,18,
6,24,96,92,100,94,96,116,124,124,124,124,124,124,124,124,56,124,124,124,
124,124,122,90,64,60,12,27,19,55,101,110,110,116,98,90,88,68,68,50,
48,32,22,18,13,23,2,1,13,66,72,64,46,64,62,32,48,52,28,2,
8,7,51,40,18,0,27,9,7,7,0,1,7,3,3,2,16,1,4,10,
14,124,124,124,116,106,92,78,44,13,1,62,48,42,34,22,10,6,0,19,
39,31,19,29,21,7,17,31,9,1,6,0,4,8,8,124,124,116,102,92,
78,54,24,23,0,0,0,0,124,18,23,124,18,23,105,63,26,20,20,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,31,47,67,11,36,0,104,16,
11,113,67,37,15,71,105,103,109,49,105,85,103,105,93,105,93,10,7,29,
71,9,53,45,103,19,61,49,111,18,33,19,105,53,37,23,11,4,5,31,
8,2,1,12,3,1,4,27,26,18,50,38,42,36,34,36,70,24,22,68,
48,7,79,61,65,45,51,41,29,37,33,37,45,13,17,17,3,71,61,63,
19,17,13,11,24,1,2,3,38,5,6,6,2,25,108,98,70,82,98,80,
46,82,64,46,56,34,10,2,0,42,28,38,34,30,24,36,22,36,30,10,
12,22,51,124,124,124,124,124,124,124,124,124,124,124,124,108,96,62,116,100,
64,124,108,114,104,94,88,96,68,54,20,32,7,17,67,11,48,30,22,4,
10,0,15,19,47,3,76,52,40,34,10,3,21,21,37,47,28,14,8,0,
9,19,27,41,79,57,25,21,13,17,35,55,57,91,23,64,34,22,6,5,
23,35,43,55,124,53,35,25,5,13,2,8,10,19,6,14,2,29,15,11,
32,8,44,36,60,60,38,40,50,40,30,3,22,7,71,57,53,43,37,37,
35,39,7,23,21,19,4,23,37,65,51,63,25,17,13,13,9,3,7,0,
0,7,13,8,3,21,104,84,90,90,88,96,88,84,72,72,76,64,28,34,
20,74,70,64,50,52,42,16,6,3,25,33,57,17,81,124,124,124,124,124,
124,124,124,116,110,102,94,76,40,2,112,108,50,118,124,108,96,102,92,80,
90,78,76,46,50,28,19,62,42,8,99,81,87,33,45,39,4,23,21,9,
1,32,8,44,11,124,124,124,118,88,82,26,5,51,19,82,58,40,18,18,
4,1,9,49,73,57,41,43,35,11,23,33,11,5,3,1,6,14,8,124,
124,122,108,100,88,60,34,17,0,0,0,0,124,18,23,124,18,23,105,63,
26,20,20,44,106,112,108,28,81,10,19,6,2,20,15,14,13,34,106,25,
65,87,91,65,7,19,6,2,39,49,10,30,7,29,55,12,11,41,49,10,
21,53,16,13,31,49,1,17,17,29,11,10,44,0,0,0,31,47,67,11,
36,0,36,25,61,103,47,55,10,15,45,27,75,39,63,49,105,51,47,59,
79,38,1,14,51,17,49,41,107,16,2,4,15,32,9,7,43,41,23,21,
21,18,24,5,26,38,31,0,9,7,12,23,48,3,4,48,64,70,60,46,
51,13,17,26,22,67,14,20,18,6,14,14,10,10,4,10,5,10,38,22,
17,3,4,5,22,36,36,20,22,10,10,8,44,36,30,27,6,17,62,46,
36,28,34,38,24,32,46,2,30,18,16,10,1,20,8,16,18,12,28,44,
14,35,12,25,24,48,39,94,118,100,98,102,104,92,92,84,66,54,48,60,
38,25,7,6,13,54,50,44,52,46,34,28,30,7,2,7,59,49,81,19,
40,36,22,2,10,9,19,31,63,19,76,42,30,16,14,9,29,37,87,10,
72,56,50,40,22,10,1,17,45,13,72,62,38,8,12,13,31,57,10,110,
92,80,64,46,10,9,25,37,124,75,73,39,85,79,57,75,69,65,71,71,
77,57,53,51,51,43,41,13,29,35,11,2,4,2,18,16,16,6,38,30,
26,24,16,38,28,16,36,32,22,18,20,1,5,9,10,17,32,58,32,18,
48,44,26,38,50,34,46,18,6,22,94,90,98,92,94,114,124,124,124,124,
124,124,124,122,54,124,124,124,124,124,118,86,62,58,12,25,19,51,95,106,
106,112,94,86,84,64,64,46,46,30,20,16,15,25,0,3,15,64,70,62,
42,60,58,30,44,48,26,1,4,11,53,38,16,1,27,9,7,5,0,1,
3,1,1,4,18,2,6,14,16,124,124,120,112,100,88,72,40,17,0,62,
48,42,34,24,12,6,0,19,39,29,19,29,19,5,17,31,7,0,6,0,
6,8,8,124,124,112,96,84,70,48,18,27,0,0,0,0,124,18,23,124,
18,23,101,59,26,20,18,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
31,47,67,9,34,0,104,16,11,111,65,37,13,67,103,99,105,47,103,81,
99,103,91,103,93,12,7,27,69,9,51,43,99,19,61,47,109,18,31,17,
103,51,37,23,9,4,5,29,10,4,1,10,3,1,4,27,26,16,48,38,
42,36,34,34,66,24,20,64,46,9,77,59,63,43,49,39,27,35,31,35,
43,13,17,15,5,69,59,63,19,17,13,11,22,0,2,3,34,3,6,4,
2,27,106,96,70,80,96,78,44,80,64,44,54,34,10,2,1,40,28,36,
34,28,22,34,20,32,28,8,10,20,51,124,124,124,124,124,124,124,124,124,
124,120,122,104,92,58,112,98,60,124,104,110,100,88,84,90,64,48,18,30,
11,19,67,11,48,32,22,4,10,0,15,19,47,1,78,52,40,34,12,1,
19,21,35,45,30,16,8,0,7,17,25,41,77,57,23,21,13,17,33,53,
57,89,21,66,34,22,6,3,21,33,41,53,124,53,35,23,5,13,2,8,
10,17,6,14,2,29,15,11,30,10,42,34,58,58,38,38,48,38,30,5,
20,7,69,57,51,41,35,35,35,37,7,23,21,19,2,23,37,63,49,63,
25,15,13,13,9,3,5,0,0,7,11,8,5,23,102,84,88,88,86,94,
86,82,70,70,74,62,26,32,18,72,66,62,46,50,40,14,4,5,25,33,
57,17,79,124,124,124,124,124,124,124,122,112,106,98,90,72,36,0,108,104,
48,114,124,104,92,98,88,76,86,74,70,42,46,24,21,58,38,6,97,79,
85,33,43,37,8,21,19,9,0,36,12,48,11,124,124,122,112,82,76,20,
9,53,19,82,58,40,18,18,4,1,9,49,71,55,39,41,33,9,23,31,
9,3,1,0,6,16,8,124,124,118,104,96,84,56,30,19,0,0,0,0,
124,18,23,124,18,23,101,59,26,20,18,40,102,108,108,28,75,8,17,6,
2,18,15,12,15,34,102,29,67,87,85,63,7,17,6,2,39,47,10,30,
7,29,55,12,13,39,49,10,21,51,14,13,31,49,0,15,17,27,9,10,
44,0,0,0,31,47,67,9,34,0,36,25,61,101,43,53,14,11,43,25,
73,35,61,47,101,49,45,57,77,38,1,14,51,17,49,39,103,14,2,4,
15,32,9,7,41,41,23,21,19,18,22,5,26,38,31,0,9,7,12,23,
48,3,4,48,62,68,58,44,49,11,17,24,22,65,14,20,16,6,14,14,
12,12,4,10,5,10,36,22,19,3,4,5,20,34,34,20,22,12,10,8,
42,34,28,27,6,17,62,46,36,28,34,38,24,32,46,2,30,18,16,10,
1,20,8,14,18,12,28,42,14,35,10,25,22,46,39,92,114,96,94,98,
100,88,88,80,62,50,44,54,34,27,7,4,13,52,48,42,50,44,30,26,
28,7,2,7,59,49,81,19,40,36,22,2,10,9,19,29,61,19,76,42,
30,16,14,7,27,37,83,10,72,56,50,40,22,10,1,17,43,13,72,60,
36,8,12,13,31,57,10,110,90,78,62,46,10,9,25,35,124,73,71,37,
81,77,55,73,65,63,67,67,73,55,51,49,51,41,39,13,29,33,11,0,
4,0,16,14,14,4,36,28,26,22,16,38,28,16,34,30,22,16,18,1,
5,9,10,17,30,58,30,18,46,42,26,36,48,32,44,16,4,18,92,90,
98,90,90,110,124,124,124,124,124,124,124,118,50,124,124,124,124,124,112,82,
60,56,12,23,17,49,91,104,102,108,92,82,80,62,60,44,42,26,16,12,
17,27,0,3,17,60,66,58,40,56,54,26,42,44,22,3,2,13,53,36,
16,3,27,7,5,5,2,0,1,0,0,6,20,4,8,16,18,124,122,116,
106,96,82,66,34,21,0,64,50,44,36,26,12,8,2,17,37,29,17,27,
17,3,17,29,7,0,6,2,8,8,8,124,124,106,90,78,62,40,10,33,
0,0,0,0,124,16,23,124,16,23,99,57,26,20,18,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,29,49,67,9,32,0,104,16,11,109,63,37,
13,65,99,95,103,45,99,79,97,101,91,101,91,12,7,25,67,9,51,43,
97,19,61,47,107,18,31,17,101,51,35,23,9,4,5,29,10,4,3,10,
3,1,4,27,26,16,46,38,40,36,34,34,62,24,20,60,44,11,75,57,
61,41,49,39,25,35,31,33,41,13,17,15,9,69,57,63,19,19,11,11,
20,2,2,3,32,1,4,2,2,29,102,94,68,78,94,76,42,78,62,40,
52,32,10,2,1,38,26,34,32,26,20,32,18,28,24,6,8,18,51,124,
124,124,124,124,124,124,124,124,122,116,116,98,86,52,108,94,56,122,100,104,
94,84,78,84,60,44,16,26,13,21,69,11,48,32,22,4,10,0,15,19,
45,1,78,52,40,34,14,1,19,21,35,45,32,16,8,0,7,17,25,39,
75,55,21,19,13,17,31,51,55,87,21,66,34,22,6,1,21,33,39,53,
124,53,35,23,5,13,2,8,10,17,6,14,4,29,15,11,28,10,40,32,
56,56,38,34,44,38,30,7,18,9,69,55,49,41,35,35,33,35,9,23,
21,19,0,23,37,63,49,65,25,15,13,11,9,3,5,0,1,7,9,6,
5,25,100,82,88,86,82,92,84,80,68,68,72,60,24,30,16,68,64,58,
42,46,38,12,2,5,25,33,57,19,79,124,124,124,124,124,124,122,116,108,
102,94,84,68,34,1,104,100,44,110,122,98,86,92,82,72,82,68,66,38,
40,20,23,54,34,2,95,77,83,31,41,37,10,19,19,9,0,38,14,50,
9,124,124,116,106,76,70,14,13,55,19,82,58,40,18,18,4,1,9,47,
71,53,37,41,31,9,21,31,9,3,1,0,8,16,6,124,124,114,100,92,
80,52,26,21,0,0,0,0,124,16,23,124,16,23,99,57,26,20,18,38,
100,106,108,28,71,8,15,8,2,16,15,10,19,32,98,33,69,89,81,61,
7,15,8,2,39,45,10,28,7,29,53,10,13,39,51,10,21,51,14,15,
31,49,0,15,17,27,9,10,44,0,0,0,29,49,67,9,32,0,36,25,
61,97,41,49,16,9,41,23,71,33,59,45,97,49,45,57,75,38,1,14,
49,17,47,39,101,14,0,2,17,32,9,7,41,41,23,21,19,16,22,5,
26,36,31,0,9,7,10,23,46,5,4,46,58,66,56,42,49,11,17,22,
20,65,12,18,16,6,14,14,14,12,4,8,5,8,34,20,21,3,4,7,
20,32,34,18,20,12,10,8,38,34,26,27,6,19,60,44,36,28,34,36,
22,32,44,0,28,18,16,8,3,18,6,14,16,10,26,40,12,35,10,25,
20,42,39,88,110,92,90,94,94,84,84,76,58,46,40,50,30,29,7,4,
15,50,44,38,46,40,28,22,24,9,0,9,59,49,79,19,40,36,22,2,
10,9,19,29,59,17,76,42,30,16,14,7,27,35,81,10,72,56,50,38,
22,10,1,17,43,13,72,60,36,8,12,13,31,55,10,108,88,76,60,44,
10,9,25,35,124,71,69,37,79,75,55,71,63,61,65,65,71,55,51,49,
49,39,39,15,29,33,11,0,2,0,14,12,10,2,34,28,26,22,14,36,
26,14,32,28,20,16,16,3,7,9,10,19,28,56,28,18,44,40,26,34,
46,32,44,14,2,14,90,88,96,86,88,108,124,124,124,124,124,124,124,112,
48,124,124,124,124,122,108,78,56,52,12,23,17,47,87,100,98,104,88,76,
76,58,56,40,38,24,12,10,19,29,1,5,19,58,64,54,36,52,50,24,
38,40,20,5,1,17,55,34,14,5,27,7,5,3,2,0,0,0,2,8,
22,6,10,18,20,122,118,112,102,90,76,60,28,27,0,64,50,44,36,26,
12,8,2,17,37,29,17,27,15,1,17,29,5,2,6,2,8,8,6,124,
122,102,84,72,54,32,4,39,0,0,0,0,124,16,23,124,16,23,95,55,
28,20,18,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,27,49,67,9,
30,0,104,16,11,107,61,37,13,63,95,91,99,41,95,77,93,99,89,99,
89,14,5,23,65,9,49,41,93,19,59,47,103,20,31,17,97,51,33,23,
9,6,3,27,10,4,3,10,1,1,4,25,26,16,46,38,38,36,34,34,
58,24,20,58,42,11,73,55,59,39,47,37,23,33,31,31,39,13,17,15,
11,67,55,63,17,19,9,11,18,4,2,3,30,0,2,0,2,29,100,92,
68,76,92,74,42,78,62,38,50,32,10,2,1,38,24,32,30,24,18,32,
18,26,22,6,6,16,51,124,124,124,124,124,124,124,124,124,118,112,112,92,
82,46,106,90,54,118,96,100,90,80,74,80,56,40,16,22,15,21,69,11,
50,32,22,6,10,0,13,19,43,1,78,52,42,34,16,0,17,19,33,43,
34,18,10,2,5,15,25,37,73,53,17,17,11,15,29,49,53,85,19,66,
36,24,6,0,19,31,37,51,124,51,33,21,5,13,2,10,12,17,6,16,
6,29,15,11,28,10,38,32,54,56,38,32,42,38,30,7,16,11,67,53,
47,41,33,35,31,33,9,23,21,17,0,23,37,63,47,65,25,15,13,9,
9,3,3,0,1,7,7,4,5,25,98,82,88,86,80,90,82,78,68,66,
70,60,24,28,14,66,62,54,38,44,36,12,2,5,23,31,57,21,77,124,
124,124,124,124,124,118,112,104,98,90,80,64,32,3,100,98,42,106,118,94,
82,88,78,68,78,64,62,36,36,16,25,50,30,1,93,73,79,29,39,35,
14,17,17,9,2,42,16,54,7,124,124,112,100,72,64,10,17,57,19,82,
58,40,18,20,4,1,9,45,69,51,35,39,27,7,19,29,7,1,0,0,
10,16,6,124,122,112,98,88,76,48,22,21,0,0,0,0,124,16,23,124,
16,23,95,55,28,20,18,36,98,104,108,28,67,8,13,10,2,16,13,8,
21,30,94,35,71,91,75,57,7,13,10,2,37,43,12,26,7,27,51,10,
13,39,51,10,21,49,14,15,31,49,0,15,15,27,9,10,44,0,0,0,
27,49,67,9,30,0,36,23,61,93,37,45,18,5,37,21,67,31,55,43,
93,49,45,57,73,38,1,14,47,17,45,37,99,14,0,2,17,32,9,5,
39,39,21,21,19,16,22,5,26,36,29,0,7,7,10,21,44,5,4,44,
56,66,54,40,47,11,15,20,18,65,10,18,16,8,14,14,16,12,4,8,
3,8,34,20,23,3,4,9,20,30,34,18,18,12,10,8,36,34,26,27,
6,21,58,44,36,28,34,36,22,32,44,0,28,18,16,8,3,18,6,14,
16,10,24,40,12,35,10,25,18,40,39,84,108,90,88,90,90,82,82,72,
54,44,38,46,28,31,7,4,17,48,42,36,44,38,26,20,22,11,1,11,
59,47,77,17,42,36,22,2,12,7,17,27,57,15,76,42,30,16,16,7,
25,33,77,10,72,56,50,38,24,10,1,17,41,13,74,60,36,8,14,13,
31,53,10,108,88,76,58,44,10,9,23,33,124,69,67,35,77,71,53,67,
61,57,63,63,67,53,49,49,47,35,39,17,27,31,11,0,0,0,14,10,
8,0,34,28,26,22,14,34,26,14,30,28,20,16,14,3,7,7,12,19,
28,54,28,18,44,40,26,32,44,32,44,12,2,12,90,86,94,84,86,106,
120,120,124,124,124,124,124,108,46,124,124,124,124,116,104,76,54,50,12,21,
17,45,83,96,96,100,84,72,74,56,52,38,36,22,10,8,21,29,1,5,
21,56,62,52,32,50,48,22,36,38,18,7,3,19,57,34,12,5,25,7,
5,1,4,2,2,2,4,10,26,8,12,22,24,120,116,108,98,84,70,54,
22,31,2,64,50,46,36,28,14,8,4,15,37,27,15,27,13,2,15,27,
3,4,6,4,10,8,6,124,118,98,80,66,48,24,1,43,0,0,0,0,
124,16,23,124,16,23,91,51,28,20,16,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,27,49,67,7,28,0,104,16,11,105,59,37,11,59,93,87,
97,39,93,73,89,97,87,97,89,16,5,21,63,9,49,39,89,19,59,45,
101,20,29,15,95,49,33,23,7,6,3,25,12,6,5,8,1,1,4,25,
26,14,44,38,38,36,34,32,54,24,18,54,40,13,71,53,57,37,45,35,
21,31,29,29,37,13,17,13,13,67,53,63,17,19,9,11,16,6,2,3,
26,2,2,1,2,31,96,90,66,74,90,72,40,76,62,36,48,32,10,2,
3,36,24,30,30,22,16,30,16,22,20,4,4,14,51,124,124,124,124,124,
124,124,124,124,114,108,106,88,78,42,102,88,50,112,92,96,86,74,70,74,
52,34,14,20,19,23,69,11,50,34,22,6,10,0,13,19,43,0,80,52,
42,34,18,0,15,19,31,41,36,20,10,2,3,15,23,37,71,53,15,17,
11,15,27,47,53,83,19,68,36,24,6,2,17,29,35,49,124,51,33,21,
5,13,2,10,12,15,6,16,6,29,15,11,26,12,36,30,52,54,38,30,
40,36,30,9,14,11,65,53,45,39,33,33,31,31,9,23,21,17,1,23,
37,61,45,65,25,13,13,9,9,3,1,0,1,7,5,4,7,27,96,82,
86,84,78,88,80,76,66,64,68,58,22,26,12,62,58,52,34,42,34,10,
0,7,23,31,57,21,75,124,124,124,124,124,120,114,106,100,94,86,76,60,
28,5,96,94,40,102,114,90,78,84,74,64,74,60,56,32,32,12,27,46,
26,3,91,71,77,29,37,33,18,15,15,9,4,44,20,56,7,124,120,106,
94,66,58,4,21,59,19,82,58,40,18,20,4,1,9,45,67,49,33,37,
25,5,19,27,5,0,2,2,10,18,6,120,118,108,94,84,72,44,18,23,
0,0,0,0,124,16,23,124,16,23,91,51,28,20,16,32,94,100,108,28,
61,6,11,10,2,14,13,6,23,30,90,39,73,91,69,55,7,11,10,2,
37,41,12,26,7,27,51,10,15,37,51,10,21,47,12,15,31,49,2,13,
15,25,7,10,44,0,0,0,27,49,67,7,28,0,36,23,61,91,33,43,
22,1,35,19,65,27,53,41,89,47,43,55,71,38,1,14,47,17,45,37,
95,12,0,2,17,32,9,5,39,39,21,21,17,16,20,5,26,36,29,0,
7,7,10,21,44,5,4,44,54,64,52,38,45,9,15,18,18,63,10,18,
14,8,14,14,18,14,4,8,3,8,32,20,25,3,4,9,18,28,32,18,
18,14,10,8,34,32,24,27,6,21,58,44,36,28,34,36,22,32,44,0,
28,18,16,8,3,18,6,12,16,10,24,38,10,35,8,25,16,38,39,82,
104,86,84,86,86,78,78,68,50,40,34,40,24,33,7,2,17,46,40,34,
42,34,22,18,20,11,1,11,59,47,77,17,42,36,22,2,12,7,17,27,
55,15,76,42,30,16,16,5,23,33,73,10,72,56,50,38,24,10,1,17,
39,13,74,58,34,8,14,13,31,53,10,106,86,74,56,44,10,9,23,33,
124,67,65,33,73,69,51,65,57,55,59,59,63,51,47,47,47,33,37,17,
27,29,11,1,0,1,12,8,6,1,32,26,26,20,12,34,26,14,28,26,
20,14,12,3,7,7,12,19,26,54,26,18,42,38,26,30,42,30,42,10,
0,8,88,86,94,82,82,102,116,116,124,124,124,124,124,104,42,118,124,118,
124,112,98,72,52,48,12,19,15,43,79,94,92,96,82,68,70,52,48,36,
32,18,6,4,23,31,3,5,23,52,58,48,30,46,44,18,32,34,14,9,
5,21,57,32,12,7,25,5,3,1,4,4,4,4,6,12,28,10,14,24,
26,120,112,104,92,80,64,48,16,35,2,66,52,46,38,30,14,10,4,15,
35,27,13,25,11,4,15,25,3,4,6,4,12,8,6,124,114,92,74,60,
40,16,9,49,0,0,0,0,124,16,25,124,16,25,87,49,30,20,16,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,25,49,67,7,28,1,104,16,
11,103,59,37,11,57,89,83,93,37,89,71,85,95,85,95,87,18,5,19,
63,7,47,39,85,19,57,45,99,20,29,15,91,49,31,21,7,6,3,23,
12,6,5,8,1,1,4,25,26,14,44,38,36,36,34,32,50,24,18,50,
38,15,71,51,57,37,43,35,19,31,29,29,33,13,17,13,15,65,51,63,
17,19,7,9,14,6,2,3,24,4,0,3,2,33,94,88,66,74,88,72,
40,74,60,34,46,32,10,2,3,34,22,28,28,22,14,28,16,18,18,4,
2,12,51,124,124,124,124,124,124,124,124,124,108,104,102,82,72,36,98,84,
48,108,86,90,80,70,64,70,46,30,12,16,21,25,69,9,52,34,24,6,
10,0,13,19,41,0,80,54,42,34,20,2,15,17,31,39,38,20,12,2,
1,13,23,35,69,51,13,15,9,15,27,47,51,79,17,68,36,24,8,2,
17,27,35,47,124,49,31,19,5,13,2,10,12,15,8,16,8,29,15,13,
26,12,34,28,50,52,38,28,38,36,30,9,12,13,63,51,43,39,31,33,
29,31,9,21,19,15,1,23,37,61,43,65,25,13,13,7,9,3,0,1,
1,7,5,2,7,29,94,80,86,82,76,88,80,74,64,64,66,56,20,24,
10,60,56,48,30,38,30,8,0,7,23,31,55,23,73,124,124,124,124,124,
116,110,102,96,88,82,70,56,26,5,94,92,36,98,108,86,74,80,70,60,
68,56,52,28,28,10,31,42,22,7,89,69,75,27,35,31,20,13,13,9,
6,48,22,60,5,122,118,102,88,60,54,1,25,63,17,82,58,40,18,20,
4,1,9,43,65,49,31,35,23,5,17,25,5,0,2,2,12,18,6,118,
116,104,90,82,70,38,16,25,0,0,0,0,124,16,25,124,16,25,87,49,
30,20,16,30,92,98,108,28,57,6,11,12,2,12,13,4,25,28,88,41,
75,93,63,53,7,11,12,2,35,39,14,24,5,25,49,8,15,37,51,10,
19,47,12,15,29,49,2,13,15,25,7,10,44,0,0,0,25,49,67,7,
28,1,36,23,59,87,29,39,24,2,33,17,61,25,51,41,87,47,43,55,
71,40,1,14,45,15,43,35,93,12,1,0,19,32,9,5,37,39,19,21,
17,16,20,3,26,34,29,0,7,7,10,21,42,5,4,42,52,62,52,38,
45,9,15,18,16,63,8,18,14,8,14,14,18,14,4,8,1,8,30,20,
25,5,4,11,18,26,32,18,16,14,10,8,30,32,22,27,6,23,56,44,
34,28,34,36,22,32,44,0,26,18,14,8,3,16,4,12,14,8,22,36,
10,35,8,23,14,34,39,78,100,82,80,82,82,74,74,64,46,38,32,36,
20,35,7,2,19,44,38,32,38,32,20,16,18,13,3,13,59,47,75,15,
42,36,22,4,12,7,17,25,53,13,74,42,30,16,18,5,21,31,69,10,
74,56,50,38,26,10,1,15,39,13,74,58,34,8,14,11,29,51,10,106,
86,72,56,44,10,7,21,31,124,67,63,33,71,67,49,61,55,53,57,57,
61,51,45,47,45,29,37,19,27,29,11,1,1,1,10,6,4,3,32,26,
26,20,12,32,24,14,28,26,18,14,12,3,9,7,12,21,26,52,24,16,
40,38,28,30,40,30,42,10,0,6,86,84,92,80,80,100,112,112,122,120,
124,124,120,98,40,114,124,112,124,106,94,68,50,46,12,17,15,39,73,90,
88,92,78,64,66,50,44,32,30,16,4,2,25,33,3,7,25,50,56,46,
26,42,40,16,30,30,12,13,9,25,59,30,10,9,25,5,3,0,6,4,
8,6,8,14,30,14,16,28,28,118,110,100,88,74,60,42,12,39,4,66,
52,48,38,32,16,10,6,13,35,25,13,25,9,6,15,25,1,6,6,6,
14,8,6,124,110,88,68,52,32,10,15,53,0,0,0,0,124,16,25,124,
16,25,85,45,30,20,14,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
25,51,67,5,26,1,104,16,11,101,57,37,9,55,85,79,91,35,85,69,
81,93,85,93,85,18,5,17,61,7,47,37,81,19,57,43,97,20,29,13,
89,47,29,21,7,6,3,23,14,8,7,8,1,1,4,25,26,12,42,38,
34,36,34,32,46,24,16,46,36,17,69,49,55,35,43,33,17,29,27,27,
31,13,17,13,17,65,49,63,17,19,5,9,12,8,2,3,22,6,0,5,
2,35,90,86,64,72,86,70,38,72,60,30,44,30,10,2,5,32,20,26,
26,20,12,26,14,14,16,2,0,10,51,124,124,122,124,124,124,124,124,122,
104,100,96,78,68,32,94,80,44,104,82,86,76,66,60,64,42,24,10,12,
23,27,69,9,52,34,24,6,10,0,13,19,41,0,80,54,42,34,22,2,
13,17,29,39,40,22,12,2,1,13,21,35,67,49,11,13,9,15,25,45,
49,77,17,68,36,24,8,4,15,27,33,45,124,49,31,19,5,13,2,10,
12,15,8,16,8,29,15,13,24,14,32,26,48,50,38,24,36,36,30,11,
10,13,63,49,41,37,31,31,29,29,11,21,19,15,3,23,37,59,41,65,
25,13,13,5,9,3,2,1,3,7,3,0,7,31,92,80,84,80,74,86,
78,72,62,62,64,54,18,22,8,56,54,46,26,36,28,6,1,9,23,31,
55,23,73,124,124,124,124,124,112,106,96,92,84,78,66,52,22,7,90,88,
34,94,104,82,70,74,66,56,64,52,46,24,24,6,33,38,18,9,87,67,
73,25,33,29,24,11,11,9,8,50,26,62,3,118,114,96,82,54,48,7,
29,65,17,82,58,40,18,20,4,1,9,43,63,47,29,35,21,3,17,23,
3,2,4,2,12,18,6,116,112,100,86,78,66,34,12,27,0,0,0,0,
124,16,25,124,16,25,85,45,30,20,14,26,88,96,108,28,53,6,9,14,
2,10,13,2,27,28,84,45,77,93,57,51,7,9,14,2,35,37,14,24,
5,25,47,8,17,37,51,10,19,45,12,17,29,49,4,13,15,25,5,10,
44,0,0,0,25,51,67,5,26,1,36,23,59,83,27,37,28,4,31,15,
59,23,49,39,83,45,43,53,69,40,1,14,45,15,43,35,89,12,1,0,
19,32,9,5,37,39,19,21,15,16,20,3,26,34,29,0,7,7,10,21,
40,7,4,40,50,60,50,36,43,7,15,16,16,61,8,18,14,8,14,14,
20,14,4,6,1,6,28,18,27,5,4,11,16,24,32,16,14,14,10,8,
28,32,20,27,6,23,54,44,34,28,34,36,22,32,42,0,26,18,14,8,
5,16,4,10,14,8,20,34,8,35,6,23,12,32,39,76,96,78,76,78,
78,70,70,60,42,34,28,32,16,37,7,2,19,42,36,30,36,28,16,14,
14,15,3,13,59,47,75,15,42,36,22,4,12,7,17,25,51,13,74,42,
30,16,18,3,21,29,65,10,74,56,50,38,26,10,1,15,37,13,74,58,
32,8,14,11,29,49,10,104,84,70,54,44,10,7,21,31,124,65,61,31,
69,65,47,59,53,51,55,53,57,49,45,47,45,27,37,19,27,27,11,3,
1,1,8,4,2,5,30,24,26,18,10,32,24,14,26,24,18,14,10,5,
9,7,12,21,24,52,22,16,38,36,28,28,38,28,40,8,1,2,84,82,
92,78,78,96,108,108,118,114,124,124,114,94,38,108,124,106,116,100,88,64,
48,42,12,15,15,37,69,86,84,88,74,60,62,46,40,30,26,14,0,1,
27,35,5,7,27,48,52,42,22,38,36,12,26,26,8,15,11,27,61,28,
8,11,25,3,3,0,6,6,10,6,10,16,32,16,18,30,30,118,106,96,
82,70,54,36,6,45,4,68,54,48,38,32,16,10,6,13,35,25,11,23,
7,8,15,23,1,6,6,6,16,8,6,122,106,82,62,46,24,2,23,59,
0,0,0,0,124,16,25,124,16,25,81,43,30,20,14,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,23,51,67,5,24,1,104,16,11,99,55,37,
9,51,83,75,87,33,83,65,77,91,83,91,85,20,5,15,59,7,45,35,
77,19,57,43,93,22,27,13,87,47,29,21,5,8,1,21,14,8,7,6,
1,1,4,25,26,12,40,38,34,36,34,30,42,24,16,44,34,19,67,47,
53,33,41,31,15,27,27,25,29,13,17,11,19,63,47,63,15,19,5,9,
10,10,2,3,18,8,1,7,2,35,88,84,64,70,84,68,36,72,60,28,
42,30,10,2,5,32,20,24,26,18,10,26,12,10,14,0,1,8,51,122,
124,118,124,122,120,120,120,118,100,96,92,72,64,26,90,78,40,98,78,82,
72,60,56,58,38,20,8,10,27,27,69,9,52,36,24,6,10,0,13,19,
39,2,82,54,42,34,24,4,11,17,27,37,42,24,12,4,0,11,21,33,
65,49,7,13,9,13,23,43,49,75,15,70,38,24,8,6,13,25,31,43,
124,49,31,17,5,13,2,10,12,13,8,18,10,29,15,13,22,14,30,24,
46,50,38,22,34,34,30,13,8,15,61,49,39,37,29,31,27,27,11,21,
19,15,5,23,37,59,39,65,25,11,13,5,9,3,4,1,3,7,1,0,
9,31,90,80,84,80,72,84,76,70,62,60,62,52,16,20,6,54,50,42,
22,34,26,4,3,9,23,29,55,25,71,124,124,124,124,120,108,102,92,88,
80,74,62,48,20,9,86,84,32,90,100,78,66,70,62,52,60,48,42,20,
20,2,35,34,14,13,85,63,71,25,31,27,28,9,9,9,10,54,28,66,
3,116,110,92,76,50,42,11,33,67,17,82,58,40,18,20,4,1,9,41,
61,45,27,33,19,1,15,21,1,4,6,4,14,20,6,112,110,98,84,74,
62,30,8,29,0,0,0,0,124,16,25,124,16,25,81,43,30,20,14,24,
86,92,108,28,47,4,7,14,2,10,11,0,29,26,80,49,79,95,51,47,
7,7,14,2,35,35,14,22,5,25,47,8,17,35,51,10,19,43,10,17,
29,49,4,11,13,23,5,10,44,0,0,0,23,51,67,5,24,1,36,21,
59,81,23,33,30,8,27,13,57,19,47,37,79,45,41,53,67,40,1,14,
43,15,41,33,87,10,1,0,19,32,9,3,35,39,19,21,15,16,18,3,
26,34,27,0,5,7,10,21,40,7,4,40,48,60,48,34,41,7,15,14,
14,61,6,18,12,8,14,14,22,16,4,6,1,6,26,18,29,5,4,13,
16,22,30,16,14,16,10,8,26,30,18,27,6,25,54,44,34,28,34,36,
22,32,42,0,26,18,14,8,5,16,4,10,14,8,20,32,8,35,6,23,
10,30,39,72,92,76,74,74,74,66,66,56,38,30,24,26,14,39,7,0,
21,40,34,28,34,26,14,12,12,15,5,15,59,47,73,15,42,36,22,4,
12,5,15,23,49,11,74,42,30,16,18,3,19,29,61,10,74,56,50,38,
26,10,1,15,35,13,76,56,32,8,14,11,29,49,10,104,82,68,52,44,
10,7,21,29,124,63,59,29,65,63,45,57,49,49,51,51,53,47,43,45,
43,25,35,21,25,25,11,3,3,3,8,2,0,7,28,24,26,18,10,30,
24,14,24,22,18,12,8,5,9,7,12,21,22,50,22,16,36,34,28,26,
36,28,40,6,3,1,82,82,90,76,74,94,104,104,114,110,124,122,108,90,
34,102,124,100,108,96,84,60,46,40,12,13,13,35,65,84,82,84,72,56,
58,44,36,28,22,10,3,3,29,37,5,7,29,44,50,38,20,36,34,10,
24,24,6,17,13,29,61,28,8,13,23,3,1,2,8,8,12,8,12,18,
36,18,20,32,34,116,102,92,78,64,48,30,0,49,4,68,54,50,40,34,
16,12,8,11,33,25,9,23,5,10,13,21,0,8,6,8,18,8,6,118,
102,78,56,40,18,5,29,65,0,0,0,0,122,16,25,122,16,25,77,39,
32,20,12,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,23,51,67,3,
22,1,104,16,11,97,53,37,7,49,79,71,85,31,79,63,73,89,81,89,
83,22,5,13,57,7,45,35,73,19,55,41,91,22,27,11,83,45,27,21,
5,8,1,19,16,10,9,6,1,1,4,25,26,10,40,38,32,36,34,30,
38,24,14,40,32,21,65,45,51,31,39,31,13,27,25,23,27,13,17,11,
21,63,45,63,15,19,3,9,8,12,2,3,16,10,1,9,2,37,84,82,
62,68,82,66,36,70,58,26,40,30,10,2,7,30,18,22,24,16,8,24,
12,6,12,0,3,6,51,120,122,116,124,118,116,116,116,112,94,92,86,68,
58,22,86,74,38,94,74,76,66,56,50,54,34,14,6,6,29,29,69,9,
54,36,24,6,10,0,13,19,39,2,82,54,42,34,26,4,11,15,27,35,
44,24,14,4,2,11,19,33,63,47,5,11,7,13,21,41,47,73,15,70,
38,24,8,8,13,23,29,41,124,47,29,17,5,13,2,10,12,13,8,18,
10,29,15,13,22,16,28,22,44,48,38,20,32,34,30,13,6,15,59,47,
37,35,29,29,27,25,11,21,19,13,5,23,37,57,37,65,25,11,13,3,
9,3,6,1,3,7,0,1,9,33,88,78,82,78,70,82,74,68,60,58,
60,50,14,18,4,50,48,40,18,30,24,2,3,11,23,29,55,25,69,124,
124,122,122,114,104,98,86,84,76,70,56,44,16,11,82,82,28,86,96,74,
62,66,58,48,56,44,36,16,16,1,37,30,10,15,83,61,69,23,29,25,
30,7,7,9,12,56,32,68,1,112,108,86,70,44,36,17,37,69,17,82,
58,40,18,20,4,1,9,41,59,43,25,31,17,1,15,19,1,4,6,4,
14,20,6,110,106,94,80,70,58,26,4,31,0,0,0,0,122,16,25,122,
16,25,77,39,32,20,12,20,82,90,108,28,43,4,5,16,2,8,11,1,
31,26,76,51,81,95,45,45,7,5,16,2,33,33,16,22,5,23,45,6,
19,35,51,10,19,43,10,17,29,49,6,11,13,23,3,10,44,0,0,0,
23,51,67,3,22,1,36,21,59,77,19,31,34,12,25,11,53,17,45,35,
75,43,41,51,65,40,1,14,43,15,41,33,83,10,3,1,21,32,9,3,
35,39,17,21,13,16,18,3,26,32,27,0,5,7,10,21,38,7,4,38,
46,58,46,32,41,5,15,12,14,59,6,18,12,8,14,14,24,16,4,6,
0,6,24,18,31,5,4,13,14,20,30,16,12,16,10,8,22,30,16,27,
6,25,52,44,34,28,34,36,22,32,42,0,24,18,14,8,5,14,2,8,
12,6,18,30,6,35,4,23,8,26,39,70,88,72,70,70,70,62,62,52,
34,28,22,22,10,41,7,0,21,38,32,26,30,22,10,10,10,17,5,15,
59,47,73,13,42,36,22,4,12,5,15,23,47,11,74,42,30,16,20,1,
17,27,57,10,74,56,50,38,28,10,1,15,35,13,76,56,30,8,14,11,
29,47,10,102,82,66,50,44,10,7,19,29,124,61,57,29,63,61,43,53,
47,47,49,47,51,47,41,45,43,21,35,21,25,25,11,5,3,3,6,0,
1,9,28,22,26,16,8,30,22,14,22,22,16,12,6,5,11,7,12,23,
22,50,20,16,34,34,28,24,34,26,38,4,3,3,80,80,90,74,72,90,
100,100,110,104,120,118,102,84,32,96,124,94,100,90,78,56,44,38,12,11,
13,33,61,80,78,80,68,52,54,40,32,24,20,8,5,7,31,39,7,9,
31,42,46,36,16,32,30,6,20,20,2,19,17,33,63,26,6,15,23,1,
1,2,8,8,14,10,14,20,38,20,22,36,36,116,100,88,72,60,42,24,
5,53,6,70,56,50,40,36,18,12,8,11,33,23,9,21,3,12,13,21,
0,8,6,8,20,8,6,116,98,72,50,34,10,13,37,69,0,0,0,0,
120,16,25,120,16,25,73,37,32,20,12,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,21,51,67,3,20,1,104,16,11,95,51,37,7,47,75,67,
81,29,75,61,69,87,79,87,81,24,5,11,55,7,43,33,69,19,55,41,
89,22,27,11,81,45,25,21,5,8,1,17,16,10,9,6,1,1,4,25,
26,10,38,38,30,36,34,30,34,24,14,36,30,23,63,43,49,29,37,29,
11,25,25,21,25,13,17,11,23,61,43,63,15,19,1,9,6,14,2,3,
14,12,3,11,2,39,82,80,62,66,80,64,34,68,58,24,38,30,10,2,
7,28,16,20,22,14,6,22,10,2,10,1,5,4,51,116,120,112,120,114,
112,112,112,108,90,88,82,62,54,16,82,70,34,90,70,72,62,52,46,48,
30,10,4,2,31,31,69,9,54,36,24,6,10,0,13,19,37,2,82,54,
42,34,28,6,9,15,25,33,46,26,14,4,4,9,19,31,61,45,3,9,
7,13,19,39,45,71,13,70,38,24,8,10,11,21,27,39,124,47,29,15,
5,13,2,10,12,13,8,18,12,29,15,13,20,16,26,20,42,46,38,18,
30,34,30,15,4,17,57,45,35,35,27,29,25,23,11,21,19,13,7,23,
37,57,35,65,25,11,13,1,9,3,8,1,3,7,2,3,9,35,86,78,
82,76,68,80,72,66,58,56,58,48,12,16,2,48,46,36,14,28,22,0,
5,11,23,29,55,27,67,124,124,118,118,108,100,94,82,80,72,66,52,40,
14,13,78,78,26,82,92,70,58,62,54,44,52,40,32,12,12,5,39,26,
6,19,81,59,67,21,27,23,34,5,5,9,14,60,34,72,0,110,104,82,
64,38,30,23,41,71,17,82,58,40,18,20,4,1,9,39,57,41,23,29,
15,0,13,17,0,6,8,4,16,20,6,108,104,90,76,66,54,22,0,33,
0,0,0,0,120,16,25,120,16,25,73,37,32,20,12,18,80,88,108,28,
39,4,3,18,2,6,11,3,33,24,72,55,83,97,39,43,7,3,18,2,
33,31,16,20,5,23,43,6,19,35,51,10,19,41,10,17,29,49,6,11,
13,23,3,10,44,0,0,0,21,51,67,3,20,1,36,21,59,73,15,27,
36,16,23,9,51,15,43,33,71,43,41,51,63,40,1,14,41,15,39,31,
81,10,3,1,21,32,9,3,33,39,17,21,13,16,18,3,26,32,27,0,
5,7,10,21,36,7,4,36,44,56,44,30,39,5,15,10,12,59,4,18,
12,8,14,14,26,16,4,6,0,6,22,18,33,5,4,15,14,18,30,16,
10,16,10,8,20,30,14,27,6,27,50,44,34,28,34,36,22,32,42,0,
24,18,14,8,5,14,2,8,12,6,16,28,6,35,4,23,6,24,39,66,
84,68,66,66,66,58,58,48,30,24,18,18,6,43,7,0,23,36,30,24,
28,20,8,8,8,19,7,17,59,47,71,13,42,36,22,4,12,5,15,21,
45,9,74,42,30,16,20,1,15,25,53,10,74,56,50,38,28,10,1,15,
33,13,76,56,30,8,14,11,29,45,10,102,80,64,48,44,10,7,19,27,
124,59,55,27,61,59,41,51,45,45,47,45,47,45,39,45,41,19,35,23,
25,23,11,5,5,3,4,1,3,11,26,22,26,16,8,28,22,14,20,20,
16,12,4,5,11,7,12,23,20,48,18,16,32,32,28,22,32,26,38,2,
5,7,78,78,88,72,70,88,96,96,106,100,114,112,96,80,30,90,118,88,
92,84,74,52,42,36,12,9,13,31,57,76,74,76,64,48,50,38,28,22,
16,6,9,9,33,41,7,9,33,40,44,32,12,28,26,4,18,16,0,21,
19,35,65,24,4,17,23,1,1,4,10,10,16,12,16,22,40,22,24,38,
38,114,96,84,68,54,36,18,11,57,6,70,56,52,40,38,18,12,10,9,
33,23,7,21,1,14,13,19,2,10,6,10,22,8,6,114,94,68,44,28,
2,21,43,75,0,0,0,0,116,14,27,116,14,27,71,35,32,20,10,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,21,53,67,3,18,3,104,14,
11,93,51,37,7,45,73,65,79,27,73,59,67,85,79,85,81,24,5,11,
55,7,43,33,67,19,55,41,87,22,27,11,79,45,25,21,5,8,1,17,
16,10,11,4,1,3,4,25,24,8,36,38,28,34,34,28,30,22,12,32,
28,25,63,43,49,29,37,29,9,25,25,21,23,15,17,11,27,61,43,63,
15,21,1,9,4,14,2,3,10,12,5,13,2,41,78,78,60,64,78,62,
32,66,56,20,36,28,8,2,9,26,14,18,20,12,4,20,8,1,6,3,
9,0,51,112,116,108,116,110,106,106,106,102,84,82,76,56,48,10,78,66,
30,84,64,66,56,46,40,42,24,4,2,1,35,33,71,9,54,36,24,6,
10,1,13,19,37,2,82,54,42,34,30,6,9,15,25,33,46,26,14,4,
4,9,19,31,59,45,1,9,7,13,19,39,45,69,13,70,38,24,8,10,
11,21,27,39,124,47,29,15,5,13,2,10,12,13,8,18,12,29,15,15,
18,16,24,18,40,44,36,14,26,32,28,17,0,19,57,45,33,35,27,29,
25,23,13,21,19,13,9,23,37,57,35,67,25,11,13,1,11,3,8,3,
5,7,2,5,11,37,84,76,80,74,64,78,70,64,56,54,56,46,10,12,
1,44,42,32,10,24,18,1,7,13,23,29,55,29,67,124,122,114,112,102,
94,88,76,74,66,60,46,34,10,15,74,74,22,78,86,64,52,56,48,40,
46,34,26,8,6,9,43,22,2,23,79,57,65,21,27,23,36,5,5,9,
14,62,36,74,0,106,100,76,56,32,24,29,47,75,17,82,56,38,18,20,
4,3,9,39,57,41,23,29,13,0,13,17,0,6,8,4,16,20,4,104,
100,86,72,62,50,16,3,35,0,0,0,0,116,14,27,116,14,27,71,35,
32,20,10,14,76,84,106,28,35,2,3,18,0,4,11,7,37,22,68,59,
85,99,35,41,9,3,18,0,33,29,16,18,5,23,43,4,21,35,53,10,
19,41,8,19,29,49,6,11,13,23,3,8,44,0,0,0,21,53,67,3,
18,3,36,21,59,71,13,25,38,18,21,7,49,13,41,33,69,43,41,51,
63,40,1,14,41,15,39,31,79,8,5,3,23,32,9,3,33,39,17,21,
13,14,16,3,24,30,27,1,5,7,8,21,34,9,2,34,40,54,42,28,
39,5,15,8,10,59,2,16,10,8,14,14,26,16,4,4,0,4,20,16,
35,7,2,17,12,16,28,14,8,16,10,8,16,28,12,27,6,29,48,42,
32,28,34,34,20,32,40,1,22,18,12,6,7,12,0,6,10,4,14,26,
4,35,2,23,4,20,39,62,80,64,62,62,60,54,54,44,26,20,14,12,
2,47,9,1,25,34,26,20,24,16,4,4,4,21,9,19,59,47,71,13,
42,36,22,4,12,5,15,21,43,9,72,42,30,16,20,1,15,25,51,8,
74,56,48,36,28,10,1,15,33,13,76,54,28,6,14,11,29,45,10,100,
78,62,46,42,10,7,19,27,124,59,53,27,59,57,41,49,43,43,45,43,
45,45,39,45,41,17,35,25,25,23,11,7,7,5,2,3,7,15,24,20,
26,14,6,26,20,12,18,18,14,10,2,7,13,7,12,25,18,46,16,14,
30,30,28,20,28,24,36,0,7,11,76,76,86,68,66,84,92,92,100,94,
108,106,90,74,26,84,110,82,82,78,68,48,38,32,12,9,13,29,53,72,
70,72,60,42,46,34,22,18,12,2,13,13,35,43,9,11,37,36,40,28,
8,24,22,0,14,12,3,25,23,39,67,22,2,19,23,1,1,4,10,10,
18,12,18,22,42,24,26,40,40,112,92,78,62,48,30,10,17,63,6,70,
56,52,40,38,18,12,10,9,33,23,7,21,0,16,13,19,2,10,6,10,
22,8,4,110,88,62,38,20,5,29,51,81,0,0,0,0,114,14,27,114,
14,27,67,31,34,22,10,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
19,53,67,1,18,3,104,14,11,89,49,37,5,41,69,61,75,23,69,55,
63,81,77,83,79,26,3,9,53,5,41,31,63,17,53,39,83,24,25,9,
75,43,23,19,3,10,0,15,18,12,11,4,0,3,4,23,24,8,36,38,
28,34,34,28,28,22,12,30,26,25,61,41,47,27,35,27,7,23,23,19,
19,15,17,9,29,59,41,63,13,21,0,7,4,16,2,3,8,14,5,15,
2,41,76,78,60,64,78,62,32,66,56,18,36,28,8,2,9,26,14,18,
20,12,2,20,8,3,4,3,11,1,51,110,114,106,114,108,102,102,102,98,
80,78,72,52,44,6,76,64,28,80,60,62,52,42,36,38,20,0,2,3,
37,33,71,7,56,38,26,8,10,1,11,17,35,4,84,56,44,34,32,8,
7,13,23,31,48,28,16,6,6,7,17,29,55,43,2,7,5,11,17,37,
43,65,11,72,40,26,10,12,9,19,25,37,124,45,27,13,5,11,2,12,
14,11,10,20,14,27,15,15,18,18,24,18,38,44,36,12,24,32,28,17,
1,19,55,43,31,33,25,27,23,21,13,19,17,11,9,21,35,55,33,67,
25,9,13,0,11,3,10,3,5,5,4,5,11,37,84,76,80,74,62,78,
70,64,56,54,56,46,10,10,3,42,40,30,8,22,16,1,7,13,21,27,
53,29,65,120,118,110,108,98,90,84,72,70,62,56,42,30,8,15,72,72,
20,76,82,60,48,52,44,36,42,30,22,6,2,11,45,20,0,25,75,53,
61,19,25,21,40,3,3,9,16,66,40,78,2,104,98,72,50,28,20,33,
51,77,15,84,56,38,18,22,4,3,9,37,55,39,21,27,9,2,11,15,
2,8,10,6,18,22,4,102,98,84,70,60,48,12,5,35,0,0,0,0,
114,14,27,114,14,27,67,31,34,22,10,12,74,82,106,28,29,2,1,20,
0,4,9,9,39,22,66,61,87,99,29,37,9,1,20,0,31,25,18,18,
3,21,41,4,21,33,53,10,17,39,8,19,27,49,8,9,11,21,1,8,
44,0,0,0,19,53,67,1,18,3,36,19,57,67,9,21,42,22,17,5,
45,9,37,31,65,41,39,49,61,42,0,16,39,13,37,29,75,8,5,3,
23,34,9,1,31,37,15,19,11,14,16,1,24,30,25,1,3,7,8,19,
34,9,2,34,38,54,42,28,37,3,13,8,10,57,2,16,10,10,14,14,
28,18,6,4,2,4,20,16,35,7,2,17,12,14,28,14,8,18,12,8,
14,28,12,25,6,29,48,42,32,28,34,34,20,32,40,1,22,18,12,6,
7,12,0,6,10,4,14,26,4,33,2,21,4,18,37,60,78,62,60,58,
56,52,52,40,24,18,12,8,0,49,9,1,25,32,24,18,22,14,2,2,
2,21,9,19,57,45,69,11,44,36,22,6,14,3,13,19,39,7,72,42,
30,16,22,0,13,23,47,8,76,58,48,36,30,10,1,13,31,13,78,54,
28,6,16,9,27,43,10,100,78,62,46,42,10,5,17,25,124,57,51,25,
55,53,39,45,39,39,41,39,41,43,37,43,39,13,33,25,23,21,9,7,
7,5,2,3,9,17,24,20,28,14,6,26,20,12,18,18,14,10,2,7,
13,5,14,25,18,46,16,14,30,30,30,20,26,24,36,0,7,13,76,76,
86,66,64,82,88,88,96,90,104,102,86,70,24,80,104,76,74,74,64,46,
36,30,12,7,11,25,47,70,68,70,58,38,44,32,18,16,10,0,15,15,
37,43,9,11,39,34,38,26,6,22,20,1,12,10,5,27,25,41,67,22,
2,19,21,0,0,6,12,12,22,14,20,24,46,28,28,44,44,112,90,74,
58,44,26,4,21,67,8,72,58,54,42,40,20,14,12,7,31,21,5,19,
4,20,11,17,4,12,8,12,24,8,4,108,84,58,34,14,11,35,57,85,
0,0,0,0,112,14,27,112,14,27,63,29,34,22,10,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,17,53,67,1,16,3,104,14,11,87,47,37,
5,39,65,57,73,21,65,53,59,79,75,81,77,28,3,7,51,5,41,29,
59,17,53,39,81,24,25,9,73,43,21,19,3,10,0,13,18,12,13,4,
0,3,4,23,24,8,34,38,26,34,34,28,24,22,12,26,24,27,59,39,
45,25,33,25,5,21,23,17,17,15,17,9,31,59,39,63,13,21,2,7,
2,18,2,3,6,16,7,17,2,43,72,76,58,62,76,60,30,64,56,16,
34,28,8,2,9,24,12,16,18,10,0,18,6,7,2,5,13,3,51,106,
112,102,110,104,98,98,98,92,76,74,66,46,40,0,72,60,24,76,56,58,
48,38,32,32,16,3,0,7,39,35,71,7,56,38,26,8,10,1,11,17,
33,4,84,56,44,34,34,8,5,13,21,29,50,30,16,6,8,7,17,27,
53,41,4,5,5,11,15,35,41,63,11,72,40,26,10,14,7,17,23,35,
124,45,27,13,5,11,2,12,14,11,10,20,16,27,15,15,16,18,22,16,
36,42,36,10,22,32,28,19,3,21,53,41,29,33,25,27,21,19,13,19,
17,11,11,21,35,55,31,67,25,9,13,2,11,3,12,3,5,5,6,7,
11,39,82,76,80,72,60,76,68,62,54,52,54,44,8,8,5,38,38,26,
4,20,14,3,9,13,21,27,53,31,63,116,114,106,104,92,86,80,66,66,
58,52,38,26,6,17,68,68,18,72,78,56,44,48,40,32,38,26,18,2,
1,15,47,16,3,29,73,51,59,17,23,19,44,1,1,9,18,68,42,80,
4,102,94,66,44,22,14,39,55,79,15,84,56,38,18,22,4,3,9,35,
53,37,19,25,7,4,9,13,4,10,12,6,20,22,4,100,94,80,66,56,
44,8,9,37,0,0,0,0,112,14,27,112,14,27,63,29,34,22,10,10,
72,80,106,28,25,2,0,22,0,2,9,11,41,20,62,65,89,101,23,35,
9,0,22,0,31,23,18,16,3,21,39,4,21,33,53,10,17,37,8,19,
27,49,8,9,11,21,1,8,44,0,0,0,17,53,67,1,16,3,36,19,
57,63,5,17,44,26,15,3,43,7,35,29,61,41,39,49,59,42,0,16,
37,13,35,29,73,8,5,3,23,34,9,1,31,37,15,19,11,14,16,1,
24,30,25,1,3,7,8,19,32,9,2,32,36,52,40,26,35,3,13,6,
8,57,0,16,10,10,14,14,30,18,6,4,2,4,18,16,37,7,2,19,
12,12,28,14,6,18,12,8,12,28,10,25,6,31,46,42,32,28,34,34,
20,32,40,1,22,18,12,6,7,12,0,6,10,4,12,24,2,33,2,21,
2,16,37,56,74,58,56,54,52,48,48,36,20,14,8,4,3,51,9,1,
27,30,22,16,20,10,0,0,0,23,11,21,57,45,67,11,44,36,22,6,
14,3,13,19,37,5,72,42,30,16,22,0,11,21,43,8,76,58,48,36,
30,10,1,13,29,13,78,54,28,6,16,9,27,41,10,98,76,60,44,42,
10,5,17,25,124,55,49,23,53,51,37,43,37,37,39,37,37,41,35,43,
37,11,33,27,23,19,9,7,9,5,0,5,11,19,22,20,28,14,4,24,
20,12,16,16,14,10,0,7,13,5,14,25,16,44,14,14,28,28,30,18,
24,24,36,1,9,17,74,74,84,64,62,80,84,84,92,86,98,96,80,66,
22,74,98,70,66,68,60,42,34,28,12,5,11,23,43,66,64,66,54,34,
40,28,14,14,6,1,19,17,39,45,11,11,41,32,36,22,2,18,16,3,
8,6,7,29,27,43,69,20,0,21,21,0,0,8,12,14,24,16,22,26,
48,30,30,46,46,110,86,70,54,38,20,1,27,71,8,72,58,54,42,42,
20,14,12,7,31,21,3,19,6,22,11,15,6,14,8,12,26,8,4,106,
80,54,28,8,19,43,63,91,0,0,0,0,110,14,27,110,14,27,59,25,
36,22,8,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,17,53,67,0,
14,3,104,14,11,85,45,37,3,37,61,53,69,19,61,51,55,77,73,79,
75,30,3,5,49,5,39,29,55,17,51,37,79,24,25,7,69,41,19,19,
3,10,0,11,20,14,13,4,0,3,4,23,24,6,34,38,24,34,34,28,
20,22,10,22,22,29,57,37,43,23,31,25,3,21,21,15,15,15,17,9,
33,57,37,63,13,21,4,7,0,20,2,3,4,18,7,19,2,45,70,74,
58,60,74,58,30,62,54,14,32,28,8,2,11,22,10,14,16,8,1,16,
6,11,0,5,15,5,51,104,108,100,106,100,94,94,94,88,70,70,62,42,
34,3,68,56,22,72,52,52,42,34,26,28,12,9,1,11,41,37,71,7,
58,38,26,8,10,1,11,17,33,4,84,56,44,34,36,10,5,11,21,27,
52,30,18,6,10,5,15,27,51,39,6,3,3,11,13,33,39,61,9,72,
40,26,10,16,7,15,21,33,124,43,25,11,5,11,2,12,14,11,10,20,
16,27,15,15,16,20,20,14,34,40,36,8,20,32,28,19,5,21,51,39,
27,31,23,25,21,17,13,19,17,9,11,21,35,53,29,67,25,9,13,4,
11,3,14,3,5,5,8,9,11,41,80,74,78,70,58,74,66,60,52,50,
52,42,6,6,7,36,36,24,0,16,12,5,9,15,21,27,53,31,61,112,
110,102,100,86,82,76,62,62,54,48,32,22,2,19,64,66,14,68,74,52,
40,44,36,28,34,22,12,1,5,19,49,12,7,31,71,49,57,15,21,17,
46,0,0,9,20,72,46,84,6,98,92,62,38,16,8,45,59,81,15,84,
56,38,18,22,4,3,9,35,51,35,17,23,5,4,9,11,4,10,12,6,
20,22,4,98,92,76,62,52,40,4,13,39,0,0,0,0,110,14,27,110,
14,27,59,25,36,22,8,6,68,78,106,28,21,2,2,24,0,0,9,13,
43,20,58,67,91,101,17,33,9,2,24,0,29,21,20,16,3,19,37,2,
23,33,53,10,17,37,8,19,27,49,10,9,11,21,0,8,44,0,0,0,
17,53,67,0,14,3,36,19,57,59,1,15,48,30,13,1,39,5,33,27,
57,39,39,47,57,42,0,16,37,13,35,27,69,8,7,5,25,34,9,1,
29,37,13,19,9,14,16,1,24,28,25,1,3,7,8,19,30,9,2,30,
34,50,38,24,35,1,13,4,8,55,0,16,10,10,14,14,32,18,6,4,
4,4,16,16,39,7,2,19,10,10,28,14,4,18,12,8,8,28,8,25,
6,31,44,42,32,28,34,34,20,32,40,1,20,18,12,6,7,10,1,4,
8,2,10,22,2,33,0,21,0,12,37,54,70,54,52,50,48,44,44,32,
16,12,6,0,7,53,9,1,27,28,20,14,16,8,3,1,1,25,11,21,
57,45,67,9,44,36,22,6,14,3,13,17,35,5,72,42,30,16,24,2,
9,19,39,8,76,58,48,36,32,10,1,13,29,13,78,54,26,6,16,9,
27,39,10,98,76,58,42,42,10,5,15,23,124,53,47,23,51,49,35,39,
35,35,37,33,35,41,33,43,37,7,33,27,23,19,9,9,9,5,1,7,
13,21,22,18,28,12,4,24,18,12,14,16,12,10,1,7,15,5,14,27,
16,44,12,14,26,28,30,16,22,22,34,3,9,19,72,72,84,62,60,76,
80,80,88,80,94,92,74,60,20,68,92,64,58,62,54,38,32,26,12,3,
11,21,39,62,60,62,50,30,36,26,10,10,4,3,21,21,41,47,11,13,
43,30,32,20,1,14,12,7,6,2,11,31,31,47,71,18,1,23,21,2,
0,8,14,14,26,18,24,28,50,32,32,50,48,110,84,66,48,34,14,7,
33,75,10,74,60,56,42,44,22,14,14,5,31,19,3,17,8,24,11,15,
6,14,8,14,28,8,4,104,76,48,22,2,27,51,71,95,0,0,0,0,
106,14,27,106,14,27,57,23,36,22,8,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,15,55,67,0,12,3,104,14,11,83,43,37,3,33,59,49,
67,17,59,47,51,75,73,77,75,30,3,3,47,5,39,27,51,17,51,37,
77,24,23,7,67,41,19,19,1,10,0,11,20,14,15,2,0,3,4,23,
24,6,32,38,24,34,34,26,16,22,10,18,20,31,55,35,41,21,31,23,
1,19,21,13,13,15,17,7,35,57,35,63,13,21,4,7,1,22,2,3,
0,20,9,21,2,47,66,72,56,58,72,56,28,60,54,10,30,26,8,2,
11,20,10,12,16,6,3,14,4,15,1,7,17,7,51,100,106,96,102,96,
90,88,90,82,66,66,56,36,30,9,64,54,18,66,48,48,38,28,22,22,
8,13,3,13,45,39,71,7,58,40,26,8,10,1,11,17,31,6,86,56,
44,34,38,10,3,11,19,27,54,32,18,6,10,5,15,25,49,39,8,3,
3,11,11,31,39,59,9,74,40,26,10,18,5,15,19,31,124,43,25,11,
5,11,2,12,14,9,10,20,18,27,15,15,14,20,18,12,32,38,36,4,
18,30,28,21,7,23,51,39,25,31,23,25,19,15,15,19,17,9,13,21,
35,53,27,67,25,7,13,4,11,3,16,3,7,5,10,9,13,43,78,74,
78,68,56,72,64,58,50,48,50,40,4,4,9,32,32,20,3,14,10,7,
11,15,21,27,53,33,61,106,104,98,94,80,78,72,56,58,50,44,28,18,
0,21,60,62,12,64,70,48,36,38,32,24,30,18,8,5,9,23,51,8,
11,35,69,47,55,15,19,15,50,2,2,9,22,74,48,86,6,96,88,56,
32,10,2,51,63,83,15,84,56,38,18,22,4,3,9,33,49,33,15,23,
3,6,7,9,6,12,14,8,22,24,4,94,88,72,58,48,36,0,17,41,
0,0,0,0,106,14,27,106,14,27,57,23,36,22,8,4,66,74,106,28,
15,0,4,24,0,1,9,15,45,18,54,71,93,103,11,31,9,4,24,0,
29,19,20,14,3,19,37,2,23,31,53,10,17,35,6,21,27,49,10,7,
11,19,0,8,44,0,0,0,15,55,67,0,12,3,36,19,57,57,0,11,
50,32,11,0,37,1,31,25,53,39,37,47,55,42,0,16,35,13,33,27,
67,6,7,5,25,34,9,1,29,37,13,19,9,14,14,1,24,28,25,1,
3,7,8,19,30,11,2,30,32,48,36,22,33,1,13,2,6,55,1,16,
8,10,14,14,34,20,6,2,4,2,14,14,41,7,2,21,10,8,26,12,
4,20,12,8,6,26,6,25,6,33,44,42,32,28,34,34,20,32,38,1,
20,18,12,6,9,10,1,4,8,2,10,20,0,33,0,21,1,10,37,50,
66,50,48,46,44,40,40,28,12,8,2,5,11,55,9,3,29,26,18,12,
14,4,5,3,5,25,13,23,57,45,65,9,44,36,22,6,14,3,13,17,
33,3,72,42,30,16,24,2,9,19,35,8,76,58,48,36,32,10,1,13,
27,13,78,52,26,6,16,9,27,39,10,96,74,56,40,42,10,5,15,23,
124,51,45,21,47,47,33,37,31,33,33,31,31,39,33,41,35,5,31,29,
23,17,9,9,11,7,3,9,15,23,20,18,28,12,2,22,18,12,12,14,
12,8,3,9,15,5,14,27,14,42,10,14,24,26,30,14,20,22,34,5,
11,23,70,72,82,60,56,74,76,76,84,76,88,86,68,56,16,62,84,58,
50,58,50,34,30,22,12,1,9,19,35,60,56,58,48,26,32,22,6,8,
0,7,25,23,43,49,13,13,45,26,30,16,3,10,8,9,2,1,13,33,
33,49,71,16,1,25,21,2,2,10,14,16,28,18,26,30,52,34,34,52,
50,108,80,62,44,28,8,13,39,81,10,74,60,56,44,44,22,16,14,5,
29,19,1,17,10,26,11,13,8,16,8,14,30,8,4,100,72,44,16,3,
35,59,77,101,0,0,0,0,104,14,27,104,14,27,53,19,36,22,6,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,15,55,67,2,10,3,104,14,
11,81,41,37,1,31,55,45,63,15,55,45,47,73,71,75,73,32,3,1,
45,5,37,25,47,17,51,35,73,26,23,5,65,39,17,19,1,12,2,9,
22,16,15,2,0,3,4,23,24,4,30,38,22,34,34,26,12,22,8,16,
18,33,53,33,39,19,29,21,0,17,19,11,11,15,17,7,37,55,33,63,
11,21,6,7,3,24,2,3,1,22,9,23,2,47,64,70,56,56,70,54,
26,60,54,8,28,26,8,2,13,20,8,10,14,4,5,14,2,19,3,9,
19,9,51,96,104,92,98,94,86,84,86,78,62,62,52,32,26,13,60,50,
14,62,44,44,34,24,18,16,4,19,5,17,47,39,71,7,58,40,26,8,
10,1,11,17,31,6,86,56,44,34,40,12,1,11,17,25,56,34,18,8,
12,3,13,25,47,37,12,1,3,9,9,29,37,57,7,74,42,26,10,20,
3,13,17,29,124,43,25,9,5,11,2,12,14,9,10,22,18,27,15,15,
12,22,16,10,30,38,36,2,16,30,28,23,9,23,49,37,23,29,21,23,
19,13,15,19,17,9,15,21,35,51,25,67,25,7,13,6,11,3,18,3,
7,5,12,11,13,43,76,74,76,68,54,70,62,56,50,46,48,38,2,2,
11,30,30,18,7,12,8,9,13,17,21,25,53,33,59,102,100,94,90,76,
74,68,52,54,46,40,24,14,3,23,56,58,10,60,66,44,32,34,28,20,
26,14,2,9,13,27,53,4,15,37,67,43,53,13,17,13,54,4,4,9,
24,78,52,90,8,92,84,52,26,6,3,55,67,85,15,84,56,38,18,22,
4,3,9,33,47,31,13,21,1,8,7,7,8,14,16,8,22,24,4,92,
86,70,56,44,32,3,21,43,0,0,0,0,104,14,27,104,14,27,53,19,
36,22,6,0,62,72,106,28,11,0,6,26,0,1,7,17,47,18,50,75,
95,103,5,27,9,6,26,0,29,17,20,14,3,19,35,2,25,31,53,10,
17,33,6,21,27,49,12,7,9,19,2,8,44,0,0,0,15,55,67,2,
10,3,36,17,57,53,4,9,54,36,7,2,35,0,29,23,49,37,37,45,
53,42,0,16,35,13,33,25,63,6,7,5,25,34,9,0,27,37,13,19,
7,14,14,1,24,28,23,1,1,7,8,19,28,11,2,28,30,48,34,20,
31,0,13,0,6,53,1,16,8,10,14,14,36,20,6,2,4,2,12,14,
43,7,2,21,8,6,26,12,2,20,12,8,4,26,4,25,6,33,42,42,
32,28,34,34,20,32,38,1,20,18,12,6,9,10,1,2,8,2,8,18,
0,33,1,21,3,8,37,48,62,48,46,42,40,36,36,24,8,4,1,9,
13,57,9,3,29,24,16,10,12,2,9,5,7,27,13,23,57,45,65,9,
44,36,22,6,14,1,11,15,31,3,72,42,30,16,24,4,7,17,31,8,
76,58,48,36,32,10,1,13,25,13,80,52,24,6,16,9,27,37,10,96,
72,54,38,42,10,5,15,21,124,49,43,19,45,45,31,35,29,31,31,27,
27,37,31,41,35,3,31,29,21,15,9,11,11,7,3,11,17,25,18,16,
28,10,2,22,18,12,10,12,12,8,5,9,15,5,14,27,12,42,10,14,
22,24,30,12,18,20,32,7,13,27,68,70,82,58,54,70,72,72,80,70,
82,82,62,52,14,56,78,52,42,52,44,30,28,20,12,0,9,17,31,56,
54,54,44,22,28,20,2,6,3,9,29,27,45,51,13,13,47,24,26,12,
7,8,6,13,0,3,17,35,35,51,73,16,3,27,19,4,2,10,16,18,
30,20,28,32,56,36,36,54,54,108,76,58,38,24,2,19,45,85,10,76,
62,58,44,46,22,16,16,3,29,19,0,15,12,28,9,11,8,16,8,16,
32,8,4,98,68,38,10,9,41,67,85,107,0,0,0,0,102,14,29,102,
14,29,49,17,38,22,6,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
13,55,67,2,10,5,104,14,11,79,41,37,1,29,51,41,61,13,51,43,
43,71,69,73,71,34,3,0,45,3,37,25,43,17,49,35,71,26,23,5,
61,39,15,17,1,12,2,7,22,16,17,2,0,3,4,23,24,4,30,38,
20,34,34,26,8,22,8,12,16,35,53,31,39,19,27,21,2,17,19,11,
7,15,17,7,39,55,31,63,11,21,8,5,5,24,2,3,3,24,11,25,
2,49,60,68,54,56,68,54,26,58,52,6,26,26,8,2,13,18,6,8,
12,4,7,12,2,23,5,9,21,11,51,94,100,90,94,90,82,80,82,72,
56,58,46,26,20,19,56,46,12,58,38,38,28,20,12,12,1,23,7,21,
49,41,71,5,60,40,28,8,10,1,11,17,29,6,86,58,44,34,42,12,
1,9,17,23,58,34,20,8,14,3,13,23,45,35,14,0,1,9,9,29,
35,53,7,74,42,26,12,20,3,11,17,27,124,41,23,9,5,11,2,12,
14,9,12,22,20,27,15,17,12,22,14,8,28,36,36,0,14,30,28,23,
11,25,47,35,21,29,21,23,17,13,15,17,15,7,15,21,35,51,23,67,
25,7,13,8,11,3,20,5,7,5,12,13,13,45,74,72,76,66,52,70,
62,54,48,46,46,36,0,0,13,26,28,14,11,8,4,11,13,17,21,25,
51,35,57,98,96,90,86,70,70,64,46,50,40,36,18,10,5,23,54,56,
6,56,60,40,28,30,24,16,20,10,1,13,17,29,57,0,19,41,65,41,
51,11,15,11,56,6,6,9,26,80,54,92,10,90,82,46,20,0,7,61,
71,89,13,84,56,38,18,22,4,3,9,31,45,31,11,19,0,8,5,5,
8,14,16,8,24,24,4,90,82,66,52,42,30,9,23,45,0,0,0,0,
102,14,29,102,14,29,49,17,38,22,6,1,60,70,106,28,7,0,6,28,
0,3,7,19,49,16,48,77,97,105,0,25,9,6,28,0,27,15,22,12,
1,17,33,0,25,31,53,10,15,33,6,21,25,49,12,7,9,19,2,8,
44,0,0,0,13,55,67,2,10,5,36,17,55,49,8,5,56,40,5,4,
31,2,27,23,47,37,37,45,53,44,0,16,33,11,31,25,61,6,9,7,
27,34,9,0,27,37,11,19,7,14,14,0,24,26,23,1,1,7,8,19,
26,11,2,26,28,46,34,20,31,0,13,0,4,53,3,16,8,10,14,14,
36,20,6,2,6,2,10,14,43,9,2,23,8,4,26,12,0,20,12,8,
0,26,2,25,6,35,40,42,30,28,34,34,20,32,38,1,18,18,10,6,
9,8,3,2,6,0,6,16,1,33,1,19,5,4,37,44,58,44,42,38,
36,32,32,20,4,2,3,13,17,59,9,3,31,22,14,8,8,1,11,7,
9,29,15,25,57,45,63,7,44,36,22,8,14,1,11,15,29,1,70,42,
30,16,26,4,5,15,27,8,78,58,48,36,34,10,1,11,25,13,80,52,
24,6,16,7,25,35,10,94,72,52,38,42,10,3,13,21,124,49,41,19,
43,43,29,31,27,29,29,25,25,37,29,41,33,0,31,31,21,15,9,11,
13,7,5,13,19,27,18,16,28,10,0,20,16,12,10,12,10,8,5,9,
17,5,14,29,12,40,8,12,20,24,32,12,16,20,32,7,13,29,66,68,
80,56,52,68,68,68,76,66,78,76,56,46,12,52,72,46,34,46,40,26,
26,18,12,2,9,13,25,52,50,50,40,18,24,16,1,2,5,11,31,29,
47,53,15,15,49,22,24,10,11,4,2,15,3,7,19,39,39,55,75,14,
5,29,19,4,2,12,16,18,34,22,30,34,58,40,38,58,56,106,74,54,
34,18,1,25,49,89,12,76,62,58,44,48,24,16,16,3,29,17,0,15,
14,30,9,11,10,18,8,16,34,8,4,96,64,34,4,17,49,73,91,111,
0,0,0,0,100,14,29,100,14,29,45,13,38,22,4,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,13,55,67,4,8,5,104,14,11,77,39,37,
0,25,49,37,57,11,49,39,39,69,67,71,71,36,3,2,43,3,35,23,
39,17,49,33,69,26,21,3,59,37,15,17,0,12,2,5,24,18,17,0,
0,3,4,23,24,2,28,38,20,34,34,24,4,22,6,8,14,37,51,29,
37,17,25,19,4,15,17,9,5,15,17,5,41,53,29,63,11,21,8,5,
7,26,2,3,7,26,11,27,2,51,58,66,54,54,66,52,24,56,52,4,
24,26,8,2,15,16,6,6,12,2,9,10,0,27,7,11,23,13,51,90,
98,86,90,86,78,74,78,68,52,54,42,22,16,23,52,44,8,52,34,34,
24,14,8,6,5,29,9,23,53,43,71,5,60,42,28,8,10,1,11,17,
29,8,88,58,44,34,44,14,0,9,15,21,60,36,20,8,16,1,11,23,
43,35,16,0,1,9,7,27,35,51,5,76,42,26,12,22,1,9,15,25,
124,41,23,7,5,11,2,12,14,7,12,22,20,27,15,17,10,24,12,6,
26,34,36,1,12,28,28,25,13,25,45,35,19,27,19,21,17,11,15,17,
15,7,17,21,35,49,21,67,25,5,13,8,11,3,22,5,7,5,14,13,
15,47,72,72,74,64,50,68,60,52,46,44,44,34,1,1,15,24,24,12,
15,6,2,13,15,19,21,25,51,35,55,94,92,86,80,64,66,60,42,46,
36,32,14,6,9,25,50,52,4,52,56,36,24,26,20,12,16,6,7,17,
21,33,59,3,23,43,63,39,49,11,13,9,60,8,8,9,28,84,58,96,
10,86,78,42,14,5,13,67,75,91,13,84,56,38,18,22,4,3,9,31,
43,29,9,17,2,10,5,3,10,16,18,10,24,26,4,86,80,62,48,38,
26,13,27,47,0,0,0,0,100,14,29,100,14,29,45,13,38,22,4,5,
56,66,106,28,1,1,8,28,0,5,7,21,51,16,44,81,99,105,6,23,
9,8,28,0,27,13,22,12,1,17,33,0,27,29,53,10,15,31,4,21,
25,49,14,5,9,17,4,8,44,0,0,0,13,55,67,4,8,5,36,17,
55,47,12,3,60,44,3,6,29,6,25,21,43,35,35,43,51,44,0,16,
33,11,31,23,57,4,9,7,27,34,9,0,25,37,11,19,5,14,12,0,
24,26,23,1,1,7,8,19,26,11,2,26,26,44,32,18,29,2,13,1,
4,51,3,16,6,10,14,14,38,22,6,2,6,2,8,14,45,9,2,23,
6,2,24,12,0,22,12,8,1,24,0,25,6,35,40,42,30,28,34,34,
20,32,38,1,18,18,10,6,9,8,3,0,6,0,6,14,1,33,3,19,
7,2,37,42,54,40,38,34,32,28,28,16,0,1,7,19,21,61,9,5,
31,20,12,6,6,3,15,9,11,29,15,25,57,45,63,7,44,36,22,8,
14,1,11,13,27,1,70,42,30,16,26,6,3,15,23,8,78,58,48,36,
34,10,1,11,23,13,80,50,22,6,16,7,25,35,10,94,70,50,36,42,
10,3,13,19,124,47,39,17,39,41,27,29,23,27,25,21,21,35,27,39,
33,2,29,31,21,13,9,13,13,9,7,15,21,29,16,14,28,8,0,20,
16,12,8,10,10,6,7,9,17,5,14,29,10,40,6,12,18,22,32,10,
14,18,30,9,15,33,64,68,80,54,48,64,64,64,72,60,72,72,50,42,
8,46,64,40,26,42,34,22,24,16,12,4,7,11,21,50,46,46,38,14,
20,14,5,0,9,15,35,33,49,55,15,15,51,18,20,6,13,0,1,19,
5,11,23,41,41,57,75,12,5,31,19,6,4,12,18,20,36,24,32,36,
60,42,40,60,58,106,70,50,28,14,7,31,55,93,12,78,64,60,46,50,
24,18,18,1,27,17,2,13,16,32,9,9,10,18,8,18,36,8,4,92,
60,28,1,23,57,81,99,117,0,0,0,0,96,12,29,96,12,29,43,11,
38,22,4,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,11,57,67,4,
6,5,104,14,11,75,37,37,0,23,45,33,55,9,45,37,37,67,67,69,
69,36,3,4,41,3,35,23,37,17,49,33,67,26,21,3,57,37,13,17,
0,12,2,5,24,18,19,0,0,3,4,23,24,2,26,38,18,34,34,24,
0,22,6,4,12,39,49,27,35,15,25,19,6,15,17,7,3,15,17,5,
45,53,27,63,11,23,10,5,9,28,2,3,9,28,13,29,2,53,54,64,
52,52,64,50,22,54,50,0,22,24,8,2,15,14,4,4,10,0,11,8,
1,31,11,13,25,15,51,86,94,82,86,82,74,70,74,62,46,50,36,16,
10,29,48,40,4,48,30,28,18,10,2,0,9,33,11,27,55,45,73,5,
60,42,28,8,10,1,11,17,27,8,88,58,44,34,46,14,0,9,15,21,
62,36,20,8,16,1,11,21,41,33,18,2,1,9,5,25,33,49,5,76,
42,26,12,24,1,9,13,25,124,41,23,7,5,11,2,12,14,7,12,22,
22,27,15,17,8,24,10,4,24,32,36,5,8,28,28,27,15,27,45,33,
17,27,19,21,15,9,17,17,15,7,19,21,35,49,21,69,25,5,13,10,
11,3,22,5,9,5,16,15,15,49,70,70,74,62,46,66,58,50,44,42,
42,32,3,3,17,20,22,8,19,2,0,15,17,19,21,25,51,37,55,88,
86,82,76,58,60,54,36,42,32,28,8,2,11,27,46,48,0,48,52,30,
18,20,14,8,12,0,11,21,27,37,61,7,27,47,61,37,47,9,11,9,
62,10,8,9,28,86,60,98,12,84,74,36,8,11,19,73,79,93,13,84,
56,38,18,22,4,3,9,29,43,27,7,17,4,10,3,3,10,16,18,10,
26,26,2,84,76,58,44,34,22,17,31,49,0,0,0,0,96,12,29,96,
12,29,43,11,38,22,4,7,54,64,106,28,2,1,10,30,0,7,7,23,
55,14,40,85,101,107,10,21,9,10,30,0,27,11,22,10,1,17,31,1,
27,29,55,10,15,31,4,23,25,49,14,5,9,17,4,8,44,0,0,0,
11,57,67,4,6,5,36,17,55,43,14,0,62,46,1,8,27,8,23,19,
39,35,35,43,49,44,0,16,31,11,29,23,55,4,11,9,29,34,9,0,
25,37,11,19,5,12,12,0,24,24,23,1,1,7,6,19,24,13,2,24,
22,42,30,16,29,2,13,3,2,51,5,14,6,10,14,14,40,22,6,0,
6,0,6,12,47,9,2,25,6,0,24,10,1,22,12,8,5,24,1,25,
6,37,38,40,30,28,34,32,18,32,36,3,16,18,10,4,11,6,5,0,
4,1,4,12,3,33,3,19,9,1,37,38,50,36,34,30,26,24,24,12,
3,5,11,23,25,63,9,5,33,18,8,2,2,7,17,13,15,31,17,27,
57,45,61,7,44,36,22,8,14,1,11,13,25,0,70,42,30,16,26,6,
3,13,21,8,78,58,48,34,34,10,1,11,23,13,80,50,22,6,16,7,
25,33,10,92,68,48,34,40,10,3,13,19,124,45,37,17,37,39,27,27,
21,25,23,19,19,35,27,39,31,4,29,33,21,13,9,13,15,9,9,17,
25,31,14,14,28,8,1,18,14,10,6,8,8,6,9,11,19,5,14,31,
8,38,4,12,16,20,32,8,12,18,30,11,17,37,62,66,78,50,46,62,
60,60,66,56,66,66,44,36,6,40,58,34,18,36,30,18,20,12,12,4,
7,9,17,46,42,42,34,8,16,10,9,3,13,17,39,35,51,57,17,17,
53,16,18,2,17,3,5,21,9,15,25,43,45,61,77,10,7,33,19,6,
4,14,18,20,38,24,34,38,62,44,42,62,60,104,66,46,24,8,13,37,
61,99,12,78,64,60,46,50,24,18,18,1,27,17,2,13,18,34,9,9,
12,20,8,18,36,8,2,90,56,24,7,29,65,89,105,123,0,0,0,0,
94,12,29,94,12,29,39,9,40,22,4,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,9,57,67,4,4,5,104,14,11,73,35,37,0,21,41,29,
51,5,41,35,33,65,65,67,67,38,1,6,39,3,33,21,33,17,47,33,
63,28,21,3,53,37,11,17,0,14,4,3,24,18,19,0,2,3,4,21,
24,2,26,38,16,34,34,24,3,22,6,2,10,39,47,25,33,13,23,17,
8,13,17,5,1,15,17,5,47,51,25,63,9,23,12,5,11,30,2,3,
11,30,15,31,2,53,52,62,52,50,62,48,22,54,50,1,20,24,8,2,
15,14,2,2,8,1,13,8,1,33,13,13,27,17,51,84,92,80,84,80,
70,66,70,58,42,46,32,10,6,35,46,36,2,44,26,24,14,6,1,3,
13,37,11,31,57,45,73,5,62,42,28,10,10,1,9,17,25,8,88,58,
46,34,48,16,2,7,13,19,64,38,22,10,18,0,11,19,39,31,22,4,
0,7,3,23,31,47,3,76,44,28,12,26,0,7,11,23,124,39,21,5,
5,11,2,14,16,7,12,24,24,27,15,17,8,24,8,4,22,32,36,7,
6,28,28,27,17,29,43,31,15,27,17,21,13,7,17,17,15,5,19,21,
35,49,19,69,25,5,13,12,11,3,24,5,9,5,18,17,15,49,68,70,
74,62,44,64,56,48,44,40,40,32,3,5,19,18,20,4,23,0,1,15,
17,19,19,23,51,39,53,84,82,78,72,54,56,50,32,38,28,24,4,1,
13,29,42,46,1,44,48,26,14,16,10,4,8,3,15,23,31,41,63,11,
31,51,59,33,43,7,9,7,66,12,10,9,30,90,62,102,14,82,72,32,
2,15,25,77,83,95,13,84,56,38,18,24,4,3,9,27,41,25,5,15,
8,12,1,1,12,18,20,10,28,26,2,82,74,56,42,30,18,21,35,49,
0,0,0,0,94,12,29,94,12,29,39,9,40,22,4,9,52,62,106,28,
6,1,12,32,0,7,5,25,57,12,36,87,103,109,16,17,9,12,32,0,
25,9,24,8,1,15,29,1,27,29,55,10,15,29,4,23,25,49,14,5,
7,17,4,8,44,0,0,0,9,57,67,4,4,5,36,15,55,39,18,4,
64,50,2,10,23,10,19,17,35,35,35,43,47,44,0,16,29,11,27,21,
53,4,11,9,29,34,9,2,23,35,9,19,5,12,12,0,24,24,21,1,
0,7,6,17,22,13,2,22,20,42,28,14,27,2,11,5,0,51,7,14,
6,12,14,14,42,22,6,0,8,0,6,12,49,9,2,27,6,1,24,10,
3,22,12,8,7,24,1,25,6,39,36,40,30,28,34,32,18,32,36,3,
16,18,10,4,11,6,5,0,4,1,2,12,3,33,3,19,11,3,37,34,
48,34,32,26,22,22,22,8,7,7,13,27,27,65,9,5,35,16,6,0,
0,9,19,15,17,33,19,29,57,43,59,5,46,36,22,8,16,0,9,11,
23,2,70,42,30,16,28,6,1,11,17,8,78,58,48,34,36,10,1,11,
21,13,82,50,22,6,18,7,25,31,10,92,68,48,32,40,10,3,11,17,
124,43,35,15,35,35,25,23,19,21,21,17,15,33,25,39,29,8,29,35,
19,11,9,13,17,9,9,19,27,33,14,14,28,8,1,16,14,10,4,8,
8,6,11,11,19,3,16,31,8,36,4,12,16,20,32,6,10,18,30,13,
17,39,62,64,76,48,44,60,56,56,62,52,62,60,40,32,4,34,52,28,
10,30,26,16,18,10,12,6,7,7,13,42,40,38,30,4,14,8,13,5,
15,19,41,37,53,57,17,17,55,14,16,0,21,5,7,23,11,17,27,45,
47,63,79,10,9,33,17,6,4,16,20,22,40,26,36,40,66,46,44,66,
64,102,64,42,20,2,19,43,67,103,14,78,64,62,46,52,26,18,20,0,
27,15,4,13,20,38,7,7,14,22,8,20,38,8,2,88,52,20,11,35,
71,97,111,125,0,0,0,0,92,12,29,92,12,29,35,5,40,22,2,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,9,57,67,6,2,5,104,14,
11,71,33,37,2,17,39,25,49,3,39,31,29,63,63,65,67,40,1,8,
37,3,33,19,29,17,47,31,61,28,19,1,51,35,11,17,2,14,4,1,
26,20,21,1,2,3,4,21,24,0,24,38,16,34,34,22,7,22,4,1,
8,41,45,23,31,11,21,15,10,11,15,3,0,15,17,3,49,51,23,63,
9,23,12,5,13,32,2,3,15,32,15,33,2,55,48,60,50,48,60,46,
20,52,50,3,18,24,8,2,17,12,2,0,8,3,15,6,3,37,15,15,
29,19,51,80,90,76,80,76,66,60,66,52,38,42,26,6,2,39,42,34,
1,38,22,20,10,0,5,9,17,43,13,33,61,47,73,5,62,44,28,10,
10,1,9,17,25,10,90,58,46,34,50,16,4,7,11,17,66,40,22,10,
20,0,9,19,37,31,24,4,0,7,1,21,31,45,3,78,44,28,12,28,
2,5,9,21,124,39,21,5,5,11,2,14,16,5,12,24,24,27,15,17,
6,26,6,2,20,30,36,9,4,26,28,29,19,29,41,31,13,25,17,19,
13,5,17,17,15,5,21,21,35,47,17,69,25,3,13,12,11,3,26,5,
9,5,20,17,17,51,66,70,72,60,42,62,54,46,42,38,38,30,5,7,
21,14,16,2,27,1,3,17,19,21,19,23,51,39,51,80,78,74,66,48,
52,46,26,34,24,20,0,5,17,31,38,42,3,40,44,22,10,12,6,0,
4,7,21,27,35,45,65,15,35,53,57,31,41,7,7,5,70,14,12,9,
32,92,66,104,14,78,68,26,3,21,31,83,87,97,13,84,56,38,18,24,
4,3,9,27,39,23,3,13,10,14,1,0,14,20,22,12,28,28,2,78,
70,52,38,26,14,25,39,51,0,0,0,0,92,12,29,92,12,29,35,5,
40,22,2,13,48,58,106,28,12,3,14,32,0,9,5,27,59,12,32,91,
105,109,22,15,9,14,32,0,25,7,24,8,1,15,29,1,29,27,55,10,
15,27,2,23,25,49,16,3,7,15,6,8,44,0,0,0,9,57,67,6,
2,5,36,15,55,37,22,6,68,54,4,12,21,14,17,15,31,33,33,41,
45,44,0,16,29,11,27,21,49,2,11,9,29,34,9,2,23,35,9,19,
3,12,10,0,24,24,21,1,0,7,6,17,22,13,2,22,18,40,26,12,
25,4,11,7,0,49,7,14,4,12,14,14,44,24,6,0,8,0,4,12,
51,9,2,27,4,3,22,10,3,24,12,8,9,22,3,25,6,39,36,40,
30,28,34,32,18,32,36,3,16,18,10,4,11,6,5,1,4,1,2,10,
5,33,5,19,13,5,37,32,44,30,28,22,18,18,18,4,11,11,17,33,
31,67,9,7,35,14,4,1,1,13,23,17,19,33,19,29,57,43,59,5,
46,36,22,8,16,0,9,11,21,2,70,42,30,16,28,8,0,11,13,8,
78,58,48,34,36,10,1,11,19,13,82,48,20,6,18,7,25,31,10,90,
66,46,30,40,10,3,11,17,124,41,33,13,31,33,23,21,15,19,17,13,
11,31,23,37,29,10,27,35,19,9,9,15,17,11,11,21,29,35,12,12,
28,6,3,16,14,10,2,6,8,4,13,11,19,3,16,31,6,36,2,12,
14,18,32,4,8,16,28,15,19,43,60,64,76,46,40,56,52,52,58,46,
56,56,34,28,0,28,44,22,2,26,20,12,16,8,12,8,5,5,9,40,
36,34,28,0,10,4,17,7,19,23,45,41,55,59,19,17,57,10,12,3,
23,9,11,27,15,21,31,47,49,65,79,8,9,35,17,8,6,16,20,24,
42,28,38,42,68,48,46,68,66,102,60,38,14,1,25,49,73,107,14,80,
66,62,48,54,26,20,20,0,25,15,6,11,22,40,7,5,14,22,8,20,
40,8,2,84,48,14,17,41,79,105,119,125,0,0,0,0,90,12,31,90,
12,31,31,3,42,22,2,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
7,57,67,6,2,7,104,14,11,69,33,37,2,15,35,21,45,1,35,29,
25,61,61,63,65,42,1,10,37,1,31,19,25,17,45,31,59,28,19,1,
47,35,9,15,2,14,4,0,26,20,21,1,2,3,4,21,24,0,24,38,
14,34,34,22,11,22,4,5,6,43,45,21,31,11,19,15,12,11,15,3,
4,15,17,3,51,49,21,63,9,23,14,3,15,32,2,3,17,34,17,35,
2,57,46,58,50,48,58,46,20,50,48,5,16,24,8,2,17,10,0,1,
6,3,17,4,3,41,17,15,31,21,51,78,86,74,76,72,62,56,62,48,
32,38,22,0,3,45,38,30,3,34,16,14,4,3,11,13,23,47,15,37,
63,49,73,3,64,44,30,10,10,1,9,17,23,10,90,60,46,34,52,18,
4,5,11,15,68,40,24,10,22,2,9,17,35,29,26,6,2,7,1,21,
29,41,1,78,44,28,14,28,2,3,9,19,124,37,19,3,5,11,2,14,
16,5,14,24,26,27,15,19,6,26,4,0,18,28,36,11,2,26,28,29,
21,31,39,29,11,25,15,19,11,5,17,15,13,3,21,21,35,47,15,69,
25,3,13,14,11,3,28,7,9,5,20,19,17,53,64,68,72,58,40,62,
54,44,40,38,36,28,7,9,23,12,14,1,31,5,7,19,19,21,19,23,
49,41,49,76,74,70,62,42,48,42,22,30,18,16,5,9,19,31,36,40,
7,36,38,18,6,8,2,3,1,11,25,31,39,47,69,19,39,57,55,29,
39,5,5,3,72,16,14,9,34,96,68,108,16,76,66,22,9,27,35,89,
91,101,11,84,56,38,18,24,4,3,9,25,37,23,1,11,12,14,0,2,
14,20,22,12,30,28,2,76,68,48,34,24,12,31,41,53,0,0,0,0,
90,12,31,90,12,31,31,3,42,22,2,15,46,56,106,28,16,3,14,34,
0,11,5,29,61,10,30,93,107,111,28,13,9,14,34,0,23,5,26,6,
0,13,27,3,29,27,55,10,13,27,2,23,23,49,16,3,7,15,6,8,
44,0,0,0,7,57,67,6,2,7,36,15,53,33,26,10,70,58,6,14,
17,16,15,15,29,33,33,41,45,46,0,16,27,9,25,19,47,2,13,11,
31,34,9,2,21,35,7,19,3,12,10,2,24,22,21,1,0,7,6,17,
20,13,2,20,16,38,26,12,25,4,11,7,1,49,9,14,4,12,14,14,
44,24,6,0,10,0,2,12,51,11,2,29,4,5,22,10,5,24,12,8,
13,22,5,25,6,41,34,40,28,28,34,32,18,32,36,3,14,18,8,4,
11,4,7,1,2,3,0,8,5,33,5,17,15,9,37,28,40,26,24,18,
14,14,14,0,15,13,19,37,35,69,9,7,37,12,2,3,5,15,25,19,
21,35,21,31,57,43,57,3,46,36,22,10,16,0,9,9,19,4,68,42,
30,16,30,8,2,9,9,8,80,58,48,34,38,10,1,9,19,13,82,48,
20,6,18,5,23,29,10,90,66,44,30,40,10,1,9,15,124,41,31,13,
29,31,21,17,13,17,15,11,9,31,21,37,27,14,27,37,19,9,9,15,
19,11,13,23,31,37,12,12,28,6,3,14,12,10,2,6,6,4,13,11,
21,3,16,33,6,34,0,10,12,18,34,4,6,16,28,15,19,45,58,62,
74,44,38,54,48,48,54,42,52,50,28,22,1,24,38,16,5,20,16,8,
14,6,12,10,5,1,3,36,32,30,24,3,6,2,21,11,21,25,47,43,
57,61,19,19,59,8,10,5,27,13,15,29,17,25,33,51,53,69,81,6,
11,37,17,8,6,18,22,24,46,30,40,44,70,52,48,72,68,100,58,34,
10,7,29,55,77,111,16,80,66,64,48,56,28,20,22,2,25,13,6,11,
24,42,7,5,16,24,8,22,42,8,2,82,44,10,23,49,87,111,125,125,
0,0,0,0,86,12,31,86,12,31,29,0,42,22,0,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,7,59,67,8,0,7,104,14,11,67,31,37,
4,13,31,17,43,0,31,27,21,59,61,61,63,42,1,12,35,1,31,17,
21,17,45,29,57,28,19,0,45,33,7,15,2,14,4,0,28,22,23,1,
2,3,4,21,24,1,22,38,12,34,34,22,15,22,2,9,4,45,43,19,
29,9,19,13,14,9,13,1,6,15,17,3,53,49,19,63,9,23,16,3,
17,34,2,3,19,36,17,37,2,59,42,56,48,46,56,44,18,48,48,9,
14,22,8,2,19,8,1,3,4,5,19,2,5,45,19,17,33,23,51,74,
84,70,72,68,58,52,58,42,28,34,16,3,7,49,34,26,7,30,12,10,
0,7,15,19,27,53,17,41,65,51,73,3,64,44,30,10,10,1,9,17,
23,10,90,60,46,34,54,18,6,5,9,15,70,42,24,10,22,2,7,17,
33,27,28,8,2,7,0,19,27,39,1,78,44,28,14,30,4,3,7,17,
124,37,19,3,5,11,2,14,16,5,14,24,26,27,15,19,4,28,2,1,
16,26,36,15,0,26,28,31,23,31,39,27,9,23,15,17,11,3,19,15,
13,3,23,21,35,45,13,69,25,3,13,16,11,3,30,7,11,5,22,21,
17,55,62,68,70,56,38,60,52,42,38,36,34,26,9,11,25,8,12,3,
35,7,9,21,21,23,19,23,49,41,49,70,68,66,58,36,44,38,16,26,
14,12,9,13,23,33,32,36,9,32,34,14,2,2,1,7,5,15,31,35,
43,51,71,23,43,59,53,27,37,3,3,1,76,18,16,9,36,98,72,110,
18,72,62,16,15,33,41,95,95,103,11,84,56,38,18,24,4,3,9,25,
35,21,0,11,14,16,0,4,16,22,24,12,30,28,2,74,64,44,30,20,
8,35,45,55,0,0,0,0,86,12,31,86,12,31,29,0,42,22,0,19,
42,54,106,28,20,3,16,36,0,13,5,31,63,10,26,97,109,111,34,11,
9,16,36,0,23,3,26,6,0,13,25,3,31,27,55,10,13,25,2,25,
23,49,18,3,7,15,8,8,44,0,0,0,7,59,67,8,0,7,36,15,
53,29,28,12,74,60,8,16,15,18,13,13,25,31,33,39,43,46,0,16,
27,9,25,19,43,2,13,11,31,34,9,2,21,35,7,19,1,12,10,2,
24,22,21,1,0,7,6,17,18,15,2,18,14,36,24,10,23,6,11,9,
1,47,9,14,4,12,14,14,46,24,6,1,10,1,0,10,53,11,2,29,
2,7,22,8,7,24,12,8,15,22,7,25,6,41,32,40,28,28,34,32,
18,32,34,3,14,18,8,4,13,4,7,3,2,3,1,6,7,33,7,17,
17,11,37,26,36,22,20,14,10,10,10,3,19,17,23,41,39,71,9,7,
37,10,0,5,7,19,29,21,25,37,21,31,57,43,57,3,46,36,22,10,
16,0,9,9,17,4,68,42,30,16,30,10,2,7,5,8,80,58,48,34,
38,10,1,9,17,13,82,48,18,6,18,5,23,27,10,88,64,42,28,40,
10,1,9,15,124,39,29,11,27,29,19,15,11,15,13,7,5,29,21,37,
27,16,27,37,19,7,9,17,19,11,15,25,33,39,10,10,28,4,5,14,
12,10,0,4,6,4,15,13,21,3,16,33,4,34,1,10,10,16,34,2,
4,14,26,17,21,49,56,60,74,42,36,50,44,44,50,36,46,46,22,18,
3,18,32,10,13,14,10,4,12,2,12,12,5,0,0,32,28,26,20,7,
2,1,25,13,25,27,51,47,59,63,21,19,61,6,6,9,31,17,19,33,
21,29,37,53,55,71,83,4,13,39,17,10,6,18,22,26,48,30,42,46,
72,54,50,74,70,100,54,30,4,11,35,61,83,117,16,82,68,64,48,56,
28,20,22,2,25,13,8,9,26,44,7,3,16,24,8,22,44,8,2,80,
40,4,29,55,95,119,125,125,0,0,0,0,84,12,31,84,12,31,25,2,
42,22,0,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,5,59,67,8,
1,7,104,14,11,65,29,37,4,9,29,13,39,2,29,23,17,57,59,59,
63,44,1,14,33,1,29,15,17,17,45,29,53,30,17,0,43,33,7,15,
4,16,6,2,28,22,23,3,2,3,4,21,24,1,20,38,12,34,34,20,
19,22,2,11,2,47,41,17,27,7,17,11,16,7,13,0,8,15,17,1,
55,47,17,63,7,23,16,3,19,36,2,3,23,38,19,39,2,59,40,54,
48,44,54,42,16,48,48,11,12,22,8,2,19,8,1,5,4,7,21,2,
7,49,21,19,35,25,51,70,82,66,68,66,54,46,54,38,24,30,12,9,
11,55,30,24,11,24,8,6,3,13,19,25,31,57,19,43,69,51,73,3,
64,46,30,10,10,1,9,17,21,12,92,60,46,34,56,20,8,5,7,13,
72,44,24,12,24,4,7,15,31,27,32,8,2,5,2,17,27,37,0,80,
46,28,14,32,6,1,5,15,124,37,19,1,5,11,2,14,16,3,14,26,
28,27,15,19,2,28,0,3,14,26,36,17,1,24,28,33,25,33,37,27,
7,23,13,17,9,1,19,15,13,3,25,21,35,45,11,69,25,1,13,16,
11,3,32,7,11,5,24,21,19,55,60,68,70,56,36,58,50,40,38,34,
32,24,11,13,27,6,8,7,39,9,11,23,23,23,19,21,49,43,47,66,
64,62,52,32,40,34,12,22,10,8,13,17,25,35,28,32,11,28,30,10,
1,1,5,11,9,19,35,39,47,55,73,27,47,63,51,23,35,3,1,0,
80,20,18,9,38,102,74,114,18,70,58,12,21,37,47,99,99,105,11,84,
56,38,18,24,4,3,9,23,33,19,2,9,16,18,2,6,18,24,26,14,
32,30,2,70,62,42,28,16,4,39,49,57,0,0,0,0,84,12,31,84,
12,31,25,2,42,22,0,21,40,50,106,28,26,5,18,36,0,13,3,33,
65,8,22,101,111,113,40,7,9,18,36,0,23,1,26,4,0,13,25,3,
31,25,55,10,13,23,0,25,23,49,18,1,5,13,8,8,44,0,0,0,
5,59,67,8,1,7,36,13,53,27,32,16,76,64,12,18,13,22,11,11,
21,31,31,39,41,46,0,16,25,9,23,17,41,0,13,11,31,34,9,4,
19,35,7,19,1,12,8,2,24,22,19,1,2,7,6,17,18,15,2,18,
12,36,22,8,21,6,11,11,3,47,11,14,2,12,14,14,48,26,6,1,
10,1,1,10,55,11,2,31,2,9,20,8,7,26,12,8,17,20,9,25,
6,43,32,40,28,28,34,32,18,32,34,3,14,18,8,4,13,4,7,3,
2,3,1,4,7,33,7,17,19,13,37,22,32,20,18,10,6,6,6,7,
23,21,27,47,41,73,9,9,39,8,1,7,9,21,31,23,27,37,23,33,
57,43,55,3,46,36,22,10,16,2,7,7,15,6,68,42,30,16,30,10,
4,7,1,8,80,58,48,34,38,10,1,9,15,13,84,46,18,6,18,5,
23,27,10,88,62,40,26,40,10,1,9,13,124,37,27,9,23,27,17,13,
7,13,9,5,1,27,19,35,25,18,25,39,17,5,9,17,21,13,15,27,
35,41,8,10,28,4,5,12,12,10,1,2,6,2,17,13,21,3,16,33,
2,32,1,10,8,14,34,0,2,14,26,19,23,53,54,60,72,40,32,48,
40,40,46,32,40,40,16,14,7,12,24,4,21,10,6,0,10,0,12,14,
3,2,4,30,26,22,18,11,1,3,29,15,29,31,55,49,61,65,21,19,
63,2,4,13,33,19,21,35,23,31,39,55,57,73,83,4,13,41,15,10,
8,20,24,28,50,32,44,48,76,56,52,76,74,98,50,26,0,17,41,67,
89,121,16,82,68,66,50,58,28,22,24,4,23,13,10,9,28,46,5,1,
18,26,8,24,46,8,2,76,36,0,35,61,101,125,125,125,0,0,0,0,
82,12,31,82,12,31,21,6,44,22,1,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,5,59,67,10,3,7,104,14,11,63,27,37,6,7,25,9,
37,4,25,21,13,55,57,57,61,46,1,16,31,1,29,15,13,17,43,27,
51,30,17,2,39,31,5,15,4,16,6,4,30,24,25,3,2,3,4,21,
24,3,20,38,10,34,34,20,23,22,0,15,0,49,39,15,25,5,15,11,
18,7,11,2,10,15,17,1,57,47,15,63,7,23,18,3,21,38,2,3,
25,40,19,41,2,61,36,52,46,42,52,40,16,46,46,13,10,22,8,2,
21,6,3,7,2,9,23,0,7,53,23,19,37,27,51,68,78,64,64,62,
50,42,50,32,18,26,6,13,17,59,26,20,13,20,4,0,9,17,25,29,
35,63,21,47,71,53,73,3,66,46,30,10,10,1,9,17,21,12,92,60,
46,34,58,20,8,3,7,11,74,44,26,12,26,4,5,15,29,25,34,10,
4,5,4,15,25,35,0,80,46,28,14,34,6,0,3,13,124,35,17,1,
5,11,2,14,16,3,14,26,28,27,15,19,2,30,1,5,12,24,36,19,
3,24,28,33,27,33,35,25,5,21,13,15,9,0,19,15,13,1,25,21,
35,43,9,69,25,1,13,18,11,3,34,7,11,5,26,23,19,57,58,66,
68,54,34,56,48,38,36,32,30,22,13,15,29,2,6,9,43,13,13,25,
23,25,19,21,49,43,45,62,60,58,48,26,36,30,6,18,6,4,19,21,
29,37,24,30,15,24,26,6,5,5,9,15,13,23,41,43,51,59,75,31,
51,65,49,21,33,1,0,2,82,22,20,9,40,104,78,116,20,66,56,6,
27,43,53,105,103,107,11,84,56,38,18,24,4,3,9,23,31,17,4,7,
18,18,2,8,18,24,26,14,32,30,2,68,58,38,24,12,0,43,53,59,
0,0,0,0,82,12,31,82,12,31,21,6,44,22,1,25,36,48,106,28,
30,5,20,38,0,15,3,35,67,8,18,103,113,113,46,5,9,20,38,0,
21,0,28,4,0,11,23,5,33,25,55,10,13,23,0,25,23,49,20,1,
5,13,10,8,44,0,0,0,5,59,67,10,3,7,36,13,53,23,36,18,
80,68,14,20,9,24,9,9,17,29,31,37,39,46,0,16,25,9,23,17,
37,0,15,13,33,34,9,4,19,35,5,19,0,12,8,2,24,20,19,1,
2,7,6,17,16,15,2,16,10,34,20,6,21,8,11,13,3,45,11,14,
2,12,14,14,50,26,6,1,12,1,3,10,57,11,2,31,0,11,20,8,
9,26,12,8,21,20,11,25,6,43,30,40,28,28,34,32,18,32,34,3,
12,18,8,4,13,2,9,5,0,5,3,2,9,33,9,17,21,17,37,20,
28,16,14,6,2,2,2,11,27,23,29,51,45,75,9,9,39,6,3,9,
13,25,35,25,29,39,23,33,57,43,55,1,46,36,22,10,16,2,7,7,
13,6,68,42,30,16,32,12,6,5,2,8,80,58,48,34,40,10,1,9,
15,13,84,46,16,6,18,5,23,25,10,86,62,38,24,40,10,1,7,13,
124,35,25,9,21,25,15,9,5,11,7,1,0,27,17,35,25,22,25,39,
17,5,9,19,21,13,17,29,37,43,8,8,28,2,7,12,10,10,3,2,
4,2,19,13,23,3,16,35,2,32,3,10,6,14,34,1,0,12,24,21,
23,55,52,58,72,38,30,44,36,36,42,26,36,36,10,8,9,6,18,1,
29,4,0,3,8,1,12,16,3,4,8,26,22,18,14,15,5,7,33,19,
31,33,57,53,63,67,23,21,65,0,0,15,37,23,25,39,27,35,43,57,
61,77,85,2,15,43,15,12,8,20,24,28,52,34,46,50,78,58,54,80,
76,98,48,22,5,21,47,73,95,125,18,84,70,66,50,60,30,22,24,4,
23,11,10,7,30,48,5,1,18,26,8,24,48,8,2,74,32,5,41,67,
109,125,125,125,0,0,0,0,80,12,31,80,12,31,17,8,44,22,1,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,3,59,67,10,5,7,104,14,
11,61,25,37,6,5,21,5,33,6,21,19,9,53,55,55,59,48,1,18,
29,1,27,13,9,17,43,27,49,30,17,2,37,31,3,15,4,16,6,6,
30,24,25,3,2,3,4,21,24,3,18,38,8,34,34,20,27,22,0,19,
1,51,37,13,23,3,13,9,20,5,11,4,12,15,17,1,59,45,13,63,
7,23,20,3,23,40,2,3,27,42,21,43,2,63,34,50,46,40,50,38,
14,44,46,15,8,22,8,2,21,4,5,9,0,11,25,1,9,57,25,21,
39,29,51,64,76,60,60,58,46,38,46,28,14,22,2,19,21,65,22,16,
17,16,0,3,13,21,29,35,39,67,23,51,73,55,73,3,66,46,30,10,
10,1,9,17,19,12,92,60,46,34,60,22,10,3,5,9,76,46,26,12,
28,6,5,13,27,23,36,12,4,5,6,13,23,33,2,80,46,28,14,36,
8,2,1,11,124,35,17,0,5,11,2,14,16,3,14,26,30,27,15,19,
0,30,3,7,10,22,36,21,5,24,28,35,29,35,33,23,3,21,11,15,
7,2,19,15,13,1,27,21,35,43,7,69,25,1,13,20,11,3,36,7,
11,5,28,25,19,59,56,66,68,52,32,54,46,36,34,30,28,20,15,17,
31,0,4,13,47,15,15,27,25,25,19,21,49,45,43,58,56,54,44,20,
32,26,2,14,2,0,23,25,31,39,20,26,17,20,22,2,9,9,13,19,
17,27,45,47,55,63,77,35,55,69,47,19,31,0,2,4,86,24,22,9,
42,108,80,120,22,64,52,2,33,49,59,111,107,109,11,84,56,38,18,24,
4,3,9,21,29,15,6,5,20,20,4,10,20,26,28,14,34,30,2,66,
56,34,20,8,3,47,57,61,0,0,0,0,80,12,31,80,12,31,17,8,
44,22,1,27,34,46,106,28,34,5,22,40,0,17,3,37,69,6,14,107,
115,115,52,3,9,22,40,0,21,2,28,2,0,11,21,5,33,25,55,10,
13,21,0,25,23,49,20,1,5,13,10,8,44,0,0,0,3,59,67,10,
5,7,36,13,53,19,40,22,82,72,16,22,7,26,7,7,13,29,31,37,
37,46,0,16,23,9,21,15,35,0,15,13,33,34,9,4,17,35,5,19,
0,12,8,2,24,20,19,1,2,7,6,17,14,15,2,14,8,32,18,4,
19,8,11,15,5,45,13,14,2,12,14,14,52,26,6,1,12,1,5,10,
59,11,2,33,0,13,20,8,11,26,12,8,23,20,13,25,6,45,28,40,
28,28,34,32,18,32,34,3,12,18,8,4,13,2,9,5,0,5,5,0,
9,33,9,17,23,19,37,16,24,12,10,2,1,1,1,15,31,27,33,55,
49,77,9,9,41,4,5,11,15,27,37,27,31,41,25,35,57,43,53,1,
46,36,22,10,16,2,7,5,11,8,68,42,30,16,32,12,8,3,6,8,
80,58,48,34,40,10,1,9,13,13,84,46,16,6,18,5,23,23,10,86,
60,36,22,40,10,1,7,11,124,33,23,7,19,23,13,7,3,9,5,0,
4,25,15,35,23,24,25,41,17,3,9,19,23,13,19,31,39,45,6,8,
28,2,7,10,10,10,5,0,4,2,21,13,23,3,16,35,0,30,5,10,
4,12,34,3,1,12,24,23,25,59,50,56,70,36,28,42,32,32,38,22,
30,30,4,4,11,0,12,7,37,1,3,7,6,3,12,18,3,6,12,22,
18,14,10,19,9,9,37,21,35,35,61,55,65,69,23,21,67,1,1,19,
41,27,29,41,29,39,45,59,63,79,87,0,17,45,15,12,8,22,26,30,
54,36,48,52,80,60,56,82,78,96,44,18,9,27,53,79,101,125,18,84,
70,68,50,62,30,22,26,6,23,11,12,7,32,50,5,0,20,28,8,26,
50,8,2,72,28,9,47,73,117,125,125,125,0,0,0,0,76,10,33,76,
10,33,15,10,44,22,3,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
3,61,67,10,7,9,104,12,11,59,25,37,6,3,19,3,31,8,19,17,
7,51,55,53,59,48,1,18,29,1,27,13,7,17,43,27,47,30,17,2,
35,31,3,15,4,16,6,6,30,24,27,5,2,5,4,21,22,5,16,38,
6,32,34,18,31,20,1,23,3,53,37,13,23,3,13,9,22,5,11,4,
14,17,17,1,63,45,13,63,7,25,20,3,25,40,2,3,31,42,23,45,
2,65,30,48,44,38,48,36,12,42,44,19,6,20,6,2,23,2,7,11,
1,13,27,3,11,61,29,23,43,33,51,60,72,56,56,54,40,32,40,22,
8,16,3,25,27,71,18,12,21,10,5,9,19,27,35,41,45,73,25,55,
77,57,75,3,66,46,30,10,10,3,9,17,19,12,92,60,46,34,62,22,
10,3,5,9,76,46,26,12,28,6,5,13,25,23,38,12,4,5,6,13,
23,31,2,80,46,28,14,36,8,2,1,11,124,35,17,0,5,11,2,14,
16,3,14,26,30,27,15,21,1,30,5,9,8,20,34,25,9,22,26,37,
33,37,33,23,1,21,11,15,7,2,21,15,13,1,29,21,35,43,7,71,
25,1,13,20,13,3,36,9,13,5,28,27,21,61,54,64,66,50,28,52,
44,34,32,28,26,18,17,21,35,3,0,17,51,19,19,29,27,27,19,21,
49,47,43,52,50,50,38,14,26,20,3,8,3,5,29,31,35,41,16,22,
21,16,16,3,15,15,19,23,23,33,51,51,61,67,81,39,59,73,45,17,
29,0,2,4,88,24,22,9,42,110,82,122,22,60,48,3,41,55,65,117,
113,113,11,84,54,36,18,24,4,5,9,21,29,15,6,5,22,20,4,10,
20,26,28,14,34,30,0,62,52,30,16,4,7,53,61,63,0,0,0,0,
76,10,33,76,10,33,15,10,44,22,3,31,30,42,104,28,38,7,22,40,
1,19,3,41,73,4,10,111,117,117,56,1,11,22,40,1,21,4,28,0,
0,11,21,7,35,25,57,10,13,21,1,27,23,49,20,1,5,13,10,6,
44,0,0,0,3,61,67,10,7,9,36,13,53,17,42,24,84,74,18,24,
5,28,5,7,11,29,31,37,37,46,0,16,23,9,21,15,33,1,17,15,
35,34,9,4,17,35,5,19,0,10,6,2,22,18,19,3,2,7,4,17,
12,17,0,12,4,30,16,2,19,8,11,17,7,45,15,12,0,12,14,14,
52,26,6,3,12,3,7,8,61,13,0,35,1,15,18,6,13,26,12,8,
27,18,15,25,6,47,26,38,26,28,34,30,16,32,32,5,10,18,6,2,
15,0,11,7,1,7,7,1,11,33,11,17,25,23,37,12,20,8,6,1,
7,5,5,19,35,31,37,61,53,81,11,11,43,2,9,15,19,31,41,31,
35,43,27,37,57,43,53,1,46,36,22,10,16,2,7,5,9,8,66,42,
30,16,32,12,8,3,8,6,80,58,46,32,40,10,1,9,13,13,84,44,
14,4,18,5,23,23,10,84,58,34,20,38,10,1,7,11,124,33,21,7,
17,21,13,5,1,7,3,2,6,25,15,35,23,26,25,43,17,3,9,21,
25,15,21,33,43,49,4,6,28,0,9,8,8,8,7,1,2,0,23,15,
25,3,16,37,1,28,7,8,2,10,34,5,5,10,22,25,27,63,48,54,
68,32,24,38,28,28,32,16,24,24,1,1,15,5,4,13,47,7,9,11,
2,7,12,18,3,8,16,18,14,10,6,25,13,13,43,25,39,39,65,59,
67,71,25,23,71,5,5,23,45,31,33,45,33,43,49,63,67,83,89,1,
19,47,15,12,8,22,26,30,56,36,50,52,82,62,58,84,80,94,40,12,
15,33,59,87,107,125,18,84,70,68,50,62,30,22,26,6,23,11,12,7,
34,52,5,0,20,28,8,26,50,8,0,68,22,15,53,81,125,125,125,125,
0,0,0,0,74,10,33,74,10,33,11,14,46,24,3,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,1,61,67,12,7,9,104,12,11,55,23,37,
8,0,15,0,27,12,15,13,3,47,53,51,57,50,0,20,27,0,25,11,
3,15,41,25,43,32,15,4,31,29,1,13,6,18,8,8,32,26,27,5,
4,5,4,19,22,5,16,38,6,32,34,18,33,20,1,25,5,53,35,11,
21,1,11,7,24,3,9,6,18,17,17,0,65,43,11,63,5,25,22,1,
25,42,2,3,33,44,23,47,2,65,28,48,44,38,48,36,12,42,44,21,
6,20,6,2,23,2,7,11,1,13,29,3,11,63,31,23,45,35,51,58,
70,54,54,52,36,28,36,18,4,12,7,29,31,75,16,10,23,6,9,13,
23,31,39,45,49,77,25,57,79,57,75,1,68,48,32,12,10,3,7,15,
17,14,94,62,48,34,64,24,12,1,3,7,78,48,28,14,30,8,3,11,
21,21,42,14,6,3,8,11,21,27,4,82,48,30,16,38,10,4,0,9,
124,33,15,2,5,9,2,16,18,1,16,28,32,25,15,21,1,32,5,9,
6,20,34,27,11,22,26,37,35,37,31,21,0,19,9,13,5,4,21,13,
11,0,29,19,33,41,5,71,25,0,13,22,13,3,38,9,13,3,30,27,
21,61,54,64,66,50,26,52,44,34,32,28,26,18,17,23,37,5,1,19,
53,21,21,29,27,27,17,19,47,47,41,48,46,46,34,10,22,16,7,4,
7,9,33,35,37,41,14,20,23,14,12,7,19,19,23,27,27,37,55,53,
65,69,83,41,61,75,41,13,25,2,4,6,92,26,24,9,44,114,86,124,
24,58,46,7,47,59,69,121,117,115,9,86,54,36,18,26,4,5,9,19,
27,13,8,3,26,22,6,12,22,28,30,16,36,32,0,60,50,28,14,2,
9,57,63,63,0,0,0,0,74,10,33,74,10,33,11,14,46,24,3,33,
28,40,104,28,44,7,24,42,1,19,1,43,75,4,8,113,119,117,62,2,
11,24,42,1,19,8,30,0,2,9,19,7,35,23,57,10,11,19,1,27,
21,49,22,0,3,11,12,6,44,0,0,0,1,61,67,12,7,9,36,11,
51,13,46,28,88,78,22,26,1,32,1,5,7,27,29,35,35,48,2,18,
21,7,19,13,29,1,17,15,35,36,9,6,15,33,3,17,2,10,6,4,
22,18,17,3,4,7,4,15,12,17,0,12,2,30,16,2,17,10,9,17,
7,43,15,12,0,14,14,14,54,28,8,3,14,3,7,8,61,13,0,35,
1,17,18,6,13,28,14,8,29,18,15,23,6,47,26,38,26,28,34,30,
16,32,32,5,10,18,6,2,15,0,11,7,1,7,7,1,11,31,11,15,
25,25,35,10,18,6,4,5,11,7,7,23,37,33,39,65,55,83,11,11,
43,0,11,17,21,33,43,33,37,43,27,37,55,41,51,0,48,36,22,12,
18,4,5,3,5,10,66,42,30,16,34,14,10,1,12,6,82,60,46,32,
42,10,1,7,11,13,86,44,14,4,20,3,21,21,10,84,58,34,20,38,
10,0,5,9,124,31,19,5,13,17,11,1,2,3,0,6,10,23,13,33,
21,30,23,43,15,1,7,21,25,15,21,33,45,51,4,6,30,0,9,8,
8,8,7,1,2,0,23,15,25,1,18,37,1,28,7,8,2,10,36,5,
7,10,22,25,27,65,48,54,68,30,22,36,24,24,28,12,20,20,5,5,
17,9,1,19,55,11,13,13,0,9,12,20,1,12,22,16,12,8,4,29,
15,15,47,27,41,41,67,61,69,71,25,23,73,7,7,25,47,33,35,47,
35,45,51,65,69,85,89,1,19,47,13,14,10,24,28,32,60,38,52,54,
86,66,60,88,84,94,38,8,19,37,63,93,111,125,20,86,72,70,52,64,
32,24,28,8,21,9,14,5,38,56,3,2,22,30,10,28,52,8,0,66,
18,19,57,87,125,125,125,125,0,0,0,0,72,10,33,72,10,33,7,16,
46,24,3,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,0,61,67,12,
9,9,104,12,11,53,21,37,8,2,11,4,25,14,11,11,0,45,51,49,
55,52,0,22,25,0,25,9,0,15,41,25,41,32,15,4,29,29,0,13,
6,18,8,10,32,26,29,5,4,5,4,19,22,5,14,38,4,32,34,18,
37,20,1,29,7,55,33,9,19,0,9,5,26,1,9,8,20,17,17,0,
67,43,9,63,5,25,24,1,27,44,2,3,35,46,25,49,2,67,24,46,
42,36,46,34,10,40,44,23,4,20,6,2,23,0,9,13,3,15,31,5,
13,67,33,25,47,37,51,54,68,50,50,48,32,24,32,12,0,8,13,35,
35,81,12,6,27,2,13,17,27,35,43,51,53,81,27,61,81,59,75,1,
68,48,32,12,10,3,7,15,15,14,94,62,48,34,66,24,14,1,1,5,
80,50,28,14,32,8,3,9,19,19,44,16,6,3,10,9,19,25,4,82,
48,30,16,40,12,6,2,7,124,33,15,2,5,9,2,16,18,1,16,28,
34,25,15,21,3,32,7,11,4,18,34,29,13,22,26,39,37,39,29,19,
2,19,9,13,3,6,21,13,11,0,31,19,33,41,3,71,25,0,13,24,
13,3,40,9,13,3,32,29,21,63,52,64,66,48,24,50,42,32,30,26,
24,16,19,25,39,9,3,23,57,23,23,31,29,27,17,19,47,49,39,44,
42,42,30,4,18,12,13,0,11,13,37,39,39,43,10,16,25,10,8,11,
23,23,27,31,31,41,59,57,69,73,85,45,65,79,39,11,23,4,6,8,
96,28,26,9,46,116,88,124,26,56,42,13,53,65,75,125,121,117,9,86,
54,36,18,26,4,5,9,17,25,11,10,1,28,24,8,14,24,30,32,16,
38,32,0,58,46,24,10,1,13,61,67,65,0,0,0,0,72,10,33,72,
10,33,7,16,46,24,3,35,26,38,104,28,48,7,26,44,1,21,1,45,
77,2,4,117,121,119,68,4,11,26,44,1,19,10,30,1,2,9,17,7,
35,23,57,10,11,17,1,27,21,49,22,0,3,11,12,6,44,0,0,0,
0,61,67,12,9,9,36,11,51,9,50,32,90,82,24,28,0,34,0,3,
3,27,29,35,33,48,2,18,19,7,17,13,27,1,17,15,35,36,9,6,
15,33,3,17,2,10,6,4,22,18,17,3,4,7,4,15,10,17,0,10,
0,28,14,0,15,10,9,19,9,43,17,12,0,14,14,14,56,28,8,3,
14,3,9,8,63,13,0,37,1,19,18,6,15,28,14,8,31,18,17,23,
6,49,24,38,26,28,34,30,16,32,32,5,10,18,6,2,15,0,11,7,
1,7,9,3,13,31,11,15,27,27,35,6,14,2,0,9,15,11,11,27,
41,37,43,69,59,85,11,11,45,1,13,19,23,37,45,35,39,45,29,39,
55,41,49,0,48,36,22,12,18,4,5,3,3,12,66,42,30,16,34,14,
12,0,16,6,82,60,46,32,42,10,1,7,9,13,86,44,14,4,20,3,
21,19,10,82,56,32,18,38,10,0,5,9,124,29,17,3,11,15,9,0,
4,1,2,8,14,21,11,33,19,32,23,45,15,0,7,21,27,15,23,35,
47,53,2,6,30,0,11,6,8,8,9,3,2,0,25,15,25,1,18,37,
3,26,9,8,0,8,36,7,9,10,22,27,29,69,46,52,66,28,20,34,
20,20,24,8,14,14,11,9,19,15,7,25,63,17,17,17,1,11,12,22,
1,14,26,12,8,4,0,33,19,19,51,29,45,43,71,63,71,73,27,23,
75,9,9,29,51,37,39,49,39,49,53,67,71,87,91,3,21,49,13,14,
10,26,28,34,62,40,54,56,88,68,62,90,86,92,34,4,23,43,69,99,
117,125,20,86,72,70,52,66,32,24,28,8,21,9,16,5,40,58,3,4,
24,32,10,28,54,8,0,64,14,23,63,93,125,125,125,125,0,0,0,0,
70,10,33,70,10,33,3,20,48,24,5,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,0,61,67,14,11,9,104,12,11,51,19,37,10,4,7,8,
21,16,7,9,4,43,49,47,53,54,0,24,23,0,23,9,4,15,39,23,
39,32,15,6,25,27,2,13,6,18,8,12,34,28,29,5,4,5,4,19,
22,7,14,38,2,32,34,18,41,20,3,33,9,57,31,7,17,2,7,5,
28,1,7,10,22,17,17,0,69,41,7,63,5,25,26,1,29,46,2,3,
37,48,25,51,2,69,22,44,42,34,44,32,10,38,42,25,2,20,6,2,
25,1,11,15,5,17,33,7,13,71,35,25,49,39,51,52,64,48,46,44,
28,20,28,8,5,4,17,39,41,85,8,2,29,1,17,23,33,39,49,55,
57,87,29,65,83,61,75,1,70,48,32,12,10,3,7,15,15,14,94,62,
48,34,68,26,14,0,1,3,82,50,30,14,34,10,1,9,17,17,46,18,
8,3,12,7,17,23,6,82,48,30,16,42,12,8,4,5,124,31,13,4,
5,9,2,16,18,1,16,28,34,25,15,21,3,34,9,13,2,16,34,31,
15,22,26,39,39,39,27,17,4,17,7,11,3,8,21,13,11,2,31,19,
33,39,1,71,25,0,13,26,13,3,42,9,13,3,34,31,21,65,50,62,
64,46,22,48,40,30,28,24,22,14,21,27,41,11,5,25,61,27,25,33,
29,29,17,19,47,49,37,40,38,38,26,1,14,8,17,3,15,17,43,43,
43,45,6,14,29,6,4,15,27,27,31,35,35,45,65,61,73,77,87,49,
69,81,37,9,21,6,8,10,98,30,28,9,48,120,92,124,28,52,40,17,
59,71,81,125,125,119,9,86,54,36,18,26,4,5,9,17,23,9,12,0,
30,24,8,16,24,30,32,16,38,32,0,56,44,20,6,5,17,65,71,67,
0,0,0,0,70,10,33,70,10,33,3,20,48,24,5,39,22,36,104,28,
52,7,28,46,1,23,1,47,79,2,0,119,123,119,74,6,11,28,46,1,
17,12,32,1,2,7,15,9,37,23,57,10,11,17,1,27,21,49,24,0,
3,11,14,6,44,0,0,0,0,61,67,14,11,9,36,11,51,5,54,34,
94,86,26,30,4,36,2,1,0,25,29,33,31,48,2,18,19,7,17,11,
23,1,19,17,37,36,9,6,13,33,1,17,4,10,6,4,22,16,17,3,
4,7,4,15,8,17,0,8,1,26,12,1,15,12,9,21,9,41,17,12,
0,14,14,14,58,28,8,3,16,3,11,8,65,13,0,37,3,21,18,6,
17,28,14,8,35,18,19,23,6,49,22,38,26,28,34,30,16,32,32,5,
8,18,6,2,15,1,13,9,3,9,11,5,13,31,13,15,29,31,35,4,
10,1,3,13,19,15,15,31,45,39,45,73,63,87,11,11,45,3,15,21,
27,39,49,37,41,47,29,39,55,41,49,2,48,36,22,12,18,4,5,1,
1,12,66,42,30,16,36,16,14,2,20,6,82,60,46,32,44,10,1,7,
9,13,86,44,12,4,20,3,21,17,10,82,56,30,16,38,10,0,3,7,
124,27,15,3,9,13,7,4,6,0,4,12,16,21,9,33,19,36,23,45,
15,0,7,23,27,15,25,37,49,55,2,4,30,1,11,6,6,8,11,3,
0,0,27,15,27,1,18,39,3,26,11,8,1,8,36,9,11,8,20,29,
29,71,44,50,66,26,18,30,16,16,20,2,10,10,17,15,21,21,13,31,
71,23,23,21,3,13,12,24,1,16,30,8,4,0,3,37,23,21,55,33,
47,45,73,67,73,75,27,25,77,11,13,31,55,41,43,53,41,53,57,69,
75,91,93,5,23,51,13,16,10,26,30,34,64,42,56,58,90,70,64,94,
88,92,32,0,29,47,75,105,123,125,22,88,74,72,52,68,34,24,30,10,
21,7,16,3,42,60,3,4,24,32,10,30,56,8,0,62,10,29,69,99,
125,125,125,125,0,0,0,0,66,10,33,66,10,33,1,22,48,24,5,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,2,63,67,14,13,9,104,12,
11,49,17,37,10,8,5,12,19,18,5,5,8,41,49,45,53,54,0,26,
21,0,23,7,8,15,39,23,37,32,13,6,23,27,2,13,8,18,8,12,
34,28,31,7,4,5,4,19,22,7,12,38,2,32,34,16,45,20,3,37,
11,59,29,5,15,4,7,3,30,0,7,12,24,17,17,2,71,41,5,63,
5,25,26,1,31,48,2,3,41,50,27,53,2,71,18,42,40,32,42,30,
8,36,42,29,0,18,6,2,25,3,11,17,5,19,35,9,15,75,37,27,
51,41,51,48,62,44,42,40,24,14,24,2,9,0,23,45,45,91,4,0,
33,7,21,27,37,45,53,61,61,91,31,67,87,63,75,1,70,50,32,12,
10,3,7,15,13,16,96,62,48,34,70,26,16,0,0,3,84,52,30,14,
34,10,1,7,15,17,48,18,8,3,14,5,17,21,6,84,48,30,16,44,
14,8,6,3,124,31,13,4,5,9,2,16,18,0,16,28,36,25,15,21,
5,34,11,15,0,14,34,35,17,20,26,41,41,41,27,17,6,17,7,11,
1,10,23,13,11,2,33,19,33,39,0,71,25,2,13,26,13,3,44,9,
15,3,36,31,23,67,48,62,64,44,20,46,38,28,26,22,20,12,23,29,
43,15,9,29,65,29,27,35,31,29,17,19,47,51,37,34,32,34,20,7,
10,4,23,7,19,21,47,47,45,47,2,10,31,2,0,19,31,33,35,39,
39,49,69,65,77,81,89,53,73,85,35,7,19,6,10,12,102,32,30,9,
50,122,94,124,28,50,36,23,65,77,87,125,125,121,9,86,54,36,18,26,
4,5,9,15,21,7,14,0,32,26,10,18,26,32,34,18,40,34,0,52,
40,16,2,9,21,69,75,69,0,0,0,0,66,10,33,66,10,33,1,22,
48,24,5,41,20,32,104,28,58,9,30,46,1,25,1,49,81,0,3,123,
125,121,80,8,11,30,46,1,17,14,32,3,2,7,15,9,37,21,57,10,
11,15,3,29,21,49,24,2,3,9,14,6,44,0,0,0,2,63,67,14,
13,9,36,11,51,3,56,38,96,88,28,32,6,40,4,0,4,25,27,33,
29,48,2,18,17,7,15,11,21,3,19,17,37,36,9,6,13,33,1,17,
4,10,4,4,22,16,17,3,4,7,4,15,8,19,0,8,3,24,10,3,
13,12,9,23,11,41,19,12,1,14,14,14,60,30,8,5,16,5,13,6,
67,13,0,39,3,23,16,4,17,30,14,8,37,16,21,23,6,51,22,38,
26,28,34,30,16,32,30,5,8,18,6,2,17,1,13,9,3,9,11,7,
15,31,13,15,31,33,35,0,6,5,7,17,23,19,19,35,49,43,49,79,
67,89,11,13,47,5,17,23,29,43,51,39,45,47,31,41,55,41,47,2,
48,36,22,12,18,4,5,1,0,14,66,42,30,16,36,16,14,2,24,6,
82,60,46,32,44,10,1,7,7,13,86,42,12,4,20,3,21,17,10,80,
54,28,14,38,10,0,3,7,124,25,13,1,5,11,5,6,10,2,8,14,
20,19,9,31,17,38,21,47,15,2,7,23,29,17,27,39,51,57,0,4,
30,1,13,4,6,8,13,5,0,1,29,17,27,1,18,39,5,24,13,8,
3,6,36,11,13,8,20,31,31,75,42,50,64,24,14,28,12,12,16,1,
4,4,23,19,25,27,21,37,79,27,27,25,5,17,12,26,0,18,34,6,
0,3,5,41,27,25,59,35,51,49,77,69,75,77,29,25,79,15,15,35,
57,45,47,55,45,57,59,71,77,93,93,7,23,53,13,16,12,28,30,36,
66,42,58,60,92,72,66,96,90,90,28,3,33,53,81,111,125,125,22,88,
74,72,54,68,34,26,30,10,19,7,18,3,44,62,3,6,26,34,10,30,
58,8,0,58,6,33,75,105,125,125,125,125,0,0,0,0,64,10,33,64,
10,33,2,26,48,24,7,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
2,63,67,16,15,9,104,12,11,47,15,37,12,10,1,16,15,20,1,3,
12,39,47,43,51,56,0,28,19,0,21,5,12,15,39,21,33,34,13,8,
21,25,4,13,8,20,10,14,36,30,31,7,4,5,4,19,22,9,10,38,
0,32,34,16,49,20,5,39,13,61,27,3,13,6,5,1,32,2,5,14,
26,17,17,2,73,39,3,63,3,25,28,1,33,50,2,3,43,52,27,55,
2,71,16,40,40,30,40,28,6,36,42,31,1,18,6,2,27,3,13,19,
7,21,37,9,17,79,39,29,53,43,51,44,60,40,38,38,20,10,20,1,
13,3,27,49,49,95,0,3,37,11,25,31,41,49,57,67,65,97,33,71,
89,63,75,1,70,50,32,12,10,3,7,15,13,16,96,62,48,34,72,28,
18,0,2,1,86,54,30,16,36,12,0,7,13,15,52,20,8,1,16,3,
15,19,8,84,50,30,16,46,16,10,8,1,124,31,13,6,5,9,2,16,
18,0,16,30,36,25,15,21,7,36,13,17,1,14,34,37,19,20,26,43,
43,41,25,15,8,15,5,9,1,12,23,13,11,2,35,19,33,37,2,71,
25,2,13,28,13,3,46,9,15,3,38,33,23,67,46,62,62,44,18,44,
36,26,26,20,18,10,25,31,45,17,11,31,69,31,29,37,33,31,17,17,
47,51,35,30,28,30,16,11,6,0,27,11,23,25,51,51,49,49,1,6,
33,1,3,23,35,37,39,43,43,53,75,69,81,85,91,57,77,87,33,3,
17,8,12,14,106,34,32,9,52,124,98,124,30,46,32,27,71,81,93,125,
125,123,9,86,54,36,18,26,4,5,9,15,19,5,16,2,34,28,10,20,
28,34,36,18,40,34,0,50,38,14,0,13,25,73,79,71,0,0,0,0,
64,10,33,64,10,33,2,26,48,24,7,45,16,30,104,28,62,9,32,48,
1,25,0,51,83,0,7,125,125,121,86,12,11,32,48,1,17,16,32,3,
2,7,13,9,39,21,57,10,11,13,3,29,21,49,26,2,1,9,16,6,
44,0,0,0,2,63,67,16,15,9,36,9,51,0,60,40,100,92,32,34,
8,42,6,2,8,23,27,31,27,48,2,18,17,7,15,9,17,3,19,17,
37,36,9,8,11,33,1,17,6,10,4,4,22,16,15,3,6,7,4,15,
6,19,0,6,5,24,8,5,11,14,9,25,11,39,19,12,1,14,14,14,
62,30,8,5,16,5,15,6,69,13,0,39,5,25,16,4,19,30,14,8,
39,16,23,23,6,51,20,38,26,28,34,30,16,32,30,5,8,18,6,2,
17,1,13,11,3,9,13,9,15,31,15,15,33,35,35,1,2,7,9,21,
27,23,23,39,53,47,53,83,69,91,11,13,47,7,19,25,31,45,55,41,
47,49,31,41,55,41,47,2,48,36,22,12,18,6,3,0,2,14,66,42,
30,16,36,18,16,4,28,6,82,60,46,32,44,10,1,7,5,13,88,42,
10,4,20,3,21,15,10,80,52,26,12,38,10,0,3,5,124,23,11,0,
3,9,3,8,12,4,10,18,24,17,7,31,17,40,21,47,13,4,7,25,
29,17,27,41,53,59,1,2,30,3,13,4,6,8,15,7,0,1,31,17,
27,1,18,39,7,24,13,8,5,4,36,13,15,6,18,33,33,79,40,48,
64,22,12,24,8,8,12,7,1,0,29,23,27,33,27,43,87,33,33,29,
7,19,12,28,0,20,38,2,1,7,9,45,31,27,63,37,55,51,81,73,
77,79,29,25,81,17,19,39,61,47,49,59,47,59,63,73,79,95,95,7,
25,55,11,18,12,28,32,38,68,44,60,62,96,74,68,98,94,90,24,7,
39,57,87,117,125,125,22,90,76,74,54,70,34,26,32,12,19,7,20,1,
46,64,1,8,26,34,10,32,60,8,0,56,2,39,81,111,125,125,125,125,
0,0,0,0,62,10,35,62,10,35,6,28,50,24,7,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,4,63,67,16,15,11,104,12,11,45,15,37,
12,12,2,20,13,22,2,1,16,37,45,41,49,58,0,30,19,2,21,5,
16,15,37,21,31,34,13,8,17,25,6,11,8,20,10,16,36,30,33,7,
4,5,4,19,22,9,10,38,1,32,34,16,53,20,5,43,15,63,27,1,
13,6,3,1,34,2,5,14,30,17,17,2,75,39,1,63,3,25,30,0,
35,50,2,3,45,54,29,57,2,73,12,38,38,30,38,28,6,34,40,33,
3,18,6,2,27,5,15,21,9,21,39,11,17,83,41,29,55,45,51,42,
56,38,34,34,16,6,16,7,19,7,33,55,55,101,3,7,39,15,31,37,
47,53,63,71,71,101,35,75,91,65,75,0,72,50,34,12,10,3,7,15,
11,16,96,64,48,34,74,28,18,2,2,0,88,54,32,16,38,12,0,5,
11,13,54,22,10,1,16,3,13,15,8,84,50,30,18,46,16,12,8,0,
124,29,11,6,5,9,2,16,18,0,18,30,38,25,15,23,7,36,15,19,
3,12,34,39,21,20,26,43,45,43,23,13,10,15,5,9,0,12,23,11,
9,4,35,19,33,37,4,71,25,2,13,30,13,3,48,11,15,3,38,35,
23,69,44,60,62,42,16,44,36,24,24,20,16,8,27,33,47,21,13,35,
73,35,33,39,33,31,17,17,45,53,33,26,24,26,12,17,2,3,33,15,
29,29,57,55,51,49,3,4,37,5,9,27,39,41,43,47,49,57,79,73,
85,87,95,61,81,91,31,1,15,10,14,16,108,36,34,9,54,124,100,124,
32,44,30,33,77,87,97,125,125,125,7,86,54,36,18,26,4,5,9,13,
17,5,18,4,36,28,12,22,28,34,36,18,42,34,0,48,34,10,3,15,
27,79,81,73,0,0,0,0,62,10,35,62,10,35,6,28,50,24,7,47,
14,28,104,28,66,9,32,50,1,27,0,53,85,1,9,125,125,123,92,14,
11,32,50,1,15,18,34,5,4,5,11,11,39,21,57,10,9,13,3,29,
19,49,26,2,1,9,16,6,44,0,0,0,4,63,67,16,15,11,36,9,
49,4,64,44,102,96,34,36,12,44,8,2,10,23,27,31,27,50,2,18,
15,5,13,9,15,3,21,19,39,36,9,8,11,33,0,17,6,10,4,6,
22,14,15,3,6,7,4,15,4,19,0,4,7,22,8,5,11,14,9,25,
13,39,21,12,1,14,14,14,62,30,8,5,18,5,17,6,69,15,0,41,
5,27,16,4,21,30,14,8,43,16,25,23,6,53,18,38,24,28,34,30,
16,32,30,5,6,18,4,2,17,3,15,11,5,11,15,11,17,31,15,13,
35,39,35,5,1,11,13,25,31,27,27,43,57,49,55,87,73,93,11,13,
49,9,21,27,35,49,57,43,49,51,33,43,55,41,45,4,48,36,22,14,
18,6,3,0,4,16,64,42,30,16,38,18,18,6,32,6,84,60,46,32,
46,10,1,5,5,13,88,42,10,4,20,1,19,13,10,78,52,24,12,38,
10,2,1,5,124,23,9,0,1,7,1,12,14,6,12,20,26,17,5,31,
15,44,21,49,13,4,7,25,31,17,29,43,55,61,1,2,30,3,15,2,
4,8,15,7,1,1,31,17,29,1,18,41,7,22,15,6,7,4,38,13,
17,6,18,33,33,81,38,46,62,20,10,22,4,4,8,11,5,5,35,29,
29,37,33,49,95,39,37,33,9,21,12,30,0,24,44,1,5,11,13,49,
35,31,67,41,57,53,83,75,79,81,31,27,83,19,21,41,65,51,53,61,
51,63,65,77,83,99,97,9,27,57,11,18,12,30,32,38,72,46,62,64,
98,78,70,102,96,88,22,11,43,63,91,123,125,125,24,90,76,74,54,72,
36,26,32,12,19,5,20,1,48,66,1,8,28,36,10,32,62,8,0,54,
1,43,87,119,125,125,125,125,0,0,0,0,60,10,35,60,10,35,10,32,
50,24,9,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,4,63,67,18,
17,11,104,12,11,43,13,37,14,16,4,24,9,24,4,2,20,35,43,39,
49,60,0,32,17,2,19,3,20,15,37,19,29,34,11,10,15,23,6,11,
10,20,10,18,38,32,33,9,4,5,4,19,22,11,8,38,1,32,34,14,
57,20,7,47,17,65,25,0,11,8,1,0,36,4,3,16,32,17,17,4,
77,37,0,63,3,25,30,0,37,52,2,3,49,56,29,59,2,75,10,36,
38,28,36,26,4,32,40,35,5,18,6,2,29,7,15,23,9,23,41,13,
19,87,43,31,57,47,51,38,54,34,30,30,12,0,12,11,23,11,37,59,
59,105,7,9,43,21,35,41,51,59,67,77,75,107,37,77,95,67,75,0,
72,52,34,12,10,3,7,15,11,18,98,64,48,34,76,30,20,2,4,2,
90,56,32,16,40,14,2,5,9,13,56,22,10,1,18,1,13,13,10,86,
50,30,18,48,18,14,10,2,124,29,11,8,5,9,2,16,18,2,18,30,
38,25,15,23,9,38,17,21,5,10,34,41,23,18,26,45,47,43,21,13,
12,13,3,7,0,14,23,11,9,4,37,19,33,35,6,71,25,4,13,30,
13,3,50,11,15,3,40,35,25,71,42,60,60,40,14,42,34,22,22,18,
14,6,29,35,49,23,17,37,77,37,35,41,35,33,17,17,45,53,31,22,
20,22,6,23,1,7,37,19,33,33,61,59,55,51,7,0,39,9,13,31,
43,45,47,51,53,61,85,77,89,91,97,65,85,93,29,0,13,10,16,18,
112,38,36,9,56,124,104,124,32,40,26,37,83,93,103,125,125,125,7,86,
54,36,18,26,4,5,9,13,15,3,20,6,38,30,12,24,30,36,38,20,
42,36,0,44,32,6,7,19,31,83,85,75,0,0,0,0,60,10,35,60,
10,35,10,32,50,24,9,51,10,24,104,28,72,11,34,50,1,29,0,55,
87,1,13,125,125,123,98,16,11,34,50,1,15,20,34,5,4,5,11,11,
41,19,57,10,9,11,5,29,19,49,28,4,1,7,18,6,44,0,0,0,
4,63,67,18,17,11,36,9,49,6,68,46,106,100,36,38,14,48,10,4,
14,21,25,29,25,50,2,18,15,5,13,7,11,5,21,19,39,36,9,8,
9,33,0,17,8,10,2,6,22,14,15,3,6,7,4,15,4,19,0,4,
9,20,6,7,9,16,9,27,13,37,21,12,3,14,14,14,64,32,8,5,
18,5,19,6,71,15,0,41,7,29,14,4,21,32,14,8,45,14,27,23,
6,53,18,38,24,28,34,30,16,32,30,5,6,18,4,2,17,3,15,13,
5,11,15,13,17,31,17,13,37,41,35,7,5,15,17,29,35,31,31,47,
61,53,59,93,77,95,11,15,49,11,23,29,37,51,61,45,51,51,33,43,
55,41,45,4,48,36,22,14,18,6,3,2,6,16,64,42,30,16,38,20,
20,6,36,6,84,60,46,32,46,10,1,5,3,13,88,40,8,4,20,1,
19,13,10,78,50,22,10,38,10,2,1,3,124,21,7,2,2,5,0,14,
18,8,16,24,30,15,3,29,15,46,19,49,13,6,7,27,31,19,31,45,
57,63,3,0,30,5,15,2,4,8,17,9,1,3,33,17,29,1,18,41,
9,22,17,6,9,2,38,15,19,4,16,35,35,85,36,46,62,18,6,18,
0,0,4,17,11,9,41,33,33,43,41,55,103,43,43,37,11,23,12,32,
2,26,48,3,9,15,15,53,39,33,71,43,61,57,87,79,81,83,31,27,
85,23,25,45,67,55,57,65,53,67,69,79,85,101,97,11,27,59,11,20,
14,30,34,40,74,48,64,66,100,80,72,104,98,88,18,15,49,67,97,125,
125,125,24,92,78,76,56,74,36,28,34,14,17,5,22,0,50,68,1,10,
28,36,10,34,64,8,0,50,5,49,93,125,125,125,125,125,0,0,0,0,
56,8,35,56,8,35,12,34,50,24,9,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,6,65,67,18,19,11,104,12,11,41,11,37,14,18,8,28,
7,26,8,4,22,33,43,37,47,60,0,34,15,2,19,3,22,15,37,19,
27,34,11,10,13,23,8,11,10,20,10,18,38,32,35,9,4,5,4,19,
22,11,6,38,3,32,34,14,61,20,7,51,19,67,23,2,9,10,1,0,
38,4,3,18,34,17,17,4,81,37,2,63,3,27,32,0,39,54,2,3,
51,58,31,61,2,77,6,34,36,26,34,24,2,30,38,39,7,16,6,2,
29,9,17,25,11,25,43,15,21,91,47,33,59,49,51,34,50,30,26,26,
8,3,8,17,29,15,43,65,65,111,11,13,47,25,39,47,57,63,73,83,
79,111,39,81,97,69,77,0,72,52,34,12,10,3,7,15,9,18,98,64,
48,34,78,30,20,2,4,2,92,56,32,16,40,14,2,3,7,11,58,24,
10,1,20,0,11,11,10,86,50,30,18,50,18,14,12,2,124,29,11,8,
5,9,2,16,18,2,18,30,40,25,15,23,11,38,19,23,7,8,34,45,
27,18,26,47,49,45,21,11,14,13,3,7,2,16,25,11,9,4,39,19,
33,35,6,73,25,4,13,32,13,3,50,11,17,3,42,37,25,73,40,58,
60,38,10,40,32,20,20,16,12,4,31,37,51,27,19,41,81,41,37,43,
37,33,17,17,45,55,31,16,14,18,2,29,7,13,43,23,37,37,67,63,
57,53,11,3,43,13,17,37,49,51,53,55,57,67,89,81,95,95,99,69,
89,97,27,2,11,12,18,18,114,40,36,9,56,124,106,124,34,38,22,43,
89,99,109,125,125,125,7,86,54,36,18,26,4,5,9,11,15,1,22,6,
40,30,14,24,30,36,38,20,44,36,1,42,28,2,11,23,35,87,89,77,
0,0,0,0,56,8,35,56,8,35,12,34,50,24,9,53,8,22,104,28,
76,11,36,52,1,31,0,57,91,3,17,125,125,125,102,18,11,36,52,1,
15,22,34,7,4,5,9,13,41,19,59,10,9,11,5,31,19,49,28,4,
1,7,18,6,44,0,0,0,6,65,67,18,19,11,36,9,49,10,70,50,
108,102,38,40,16,50,12,6,18,21,25,29,23,50,2,18,13,5,11,7,
9,5,23,21,41,36,9,8,9,33,0,17,8,8,2,6,22,12,15,3,
6,7,2,15,2,21,0,2,13,18,4,9,9,16,9,29,15,37,23,10,
3,14,14,14,66,32,8,7,18,7,21,4,73,15,0,43,7,31,14,2,
23,32,14,8,49,14,29,23,6,55,16,36,24,28,34,28,14,32,28,7,
4,18,4,0,19,5,17,13,7,13,17,15,19,31,17,13,39,45,35,11,
9,19,21,33,41,35,35,51,65,57,63,97,81,97,11,15,51,13,27,33,
41,55,63,49,55,53,35,45,55,41,43,4,48,36,22,14,18,6,3,2,
8,18,64,42,30,16,38,20,20,8,38,6,84,60,46,30,46,10,1,5,
3,13,88,40,8,4,20,1,19,11,10,76,48,20,8,36,10,2,1,3,
124,19,5,2,4,3,0,16,20,10,18,26,32,15,3,29,13,48,19,51,
13,6,7,27,33,19,33,47,61,65,5,0,30,5,17,0,2,6,19,11,
3,3,35,19,31,1,18,43,11,20,19,6,11,0,38,17,21,4,16,37,
37,89,34,44,60,14,4,16,3,3,1,21,17,15,47,39,35,49,47,61,
111,49,47,41,15,27,12,32,2,28,52,7,13,19,19,59,43,37,75,47,
65,59,91,81,83,85,33,29,87,25,27,49,71,59,61,67,57,71,71,81,
89,105,99,13,29,61,11,20,14,32,34,40,76,48,66,68,102,82,74,106,
100,86,14,19,53,73,103,125,125,125,24,92,78,76,56,74,36,28,34,14,
17,5,22,0,52,70,1,10,30,38,10,34,64,8,1,48,9,53,99,125,
125,125,125,125,0,0,0,0,54,8,35,54,8,35,16,36,52,24,9,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,8,65,67,18,21,11,104,12,
11,39,9,37,14,20,12,32,3,30,12,6,26,31,41,35,45,62,2,36,
13,2,17,1,26,15,35,19,23,36,11,10,9,23,10,11,10,22,12,20,
38,32,35,9,6,5,4,17,22,11,6,38,5,32,34,14,65,20,7,53,
21,67,21,4,7,12,0,2,40,6,3,20,36,17,17,4,83,35,4,63,
1,27,34,0,41,56,2,3,53,60,33,63,2,77,4,32,36,24,32,22,
2,30,38,41,9,16,6,2,29,9,19,27,13,27,45,15,21,93,49,33,
61,51,51,32,48,28,24,24,4,7,4,21,33,19,47,71,69,117,13,17,
49,29,43,51,61,67,77,87,83,115,39,85,99,69,77,0,74,52,34,14,
10,3,5,15,7,18,98,64,50,34,80,32,22,4,6,4,94,58,34,18,
42,16,2,1,5,9,62,26,12,0,22,2,9,9,12,86,52,32,18,52,
20,16,14,4,124,27,9,10,5,9,2,18,20,2,18,32,42,25,15,23,
11,38,21,23,9,8,34,47,29,18,26,47,51,47,19,9,16,13,1,7,
4,18,25,11,9,6,39,19,33,35,8,73,25,4,13,34,13,3,52,11,
17,3,44,39,25,73,38,58,60,38,8,38,30,18,20,14,10,4,31,39,
53,29,21,45,85,43,39,43,37,33,15,15,45,57,29,12,10,14,1,33,
11,17,47,27,41,41,71,67,59,55,15,5,45,17,21,41,53,55,57,59,
61,71,93,83,99,99,101,73,93,101,25,6,7,14,20,20,118,42,38,9,
58,124,108,124,36,36,20,47,95,103,115,125,125,125,7,86,54,36,18,28,
4,5,9,9,13,0,24,8,44,32,16,26,32,38,40,20,46,36,1,40,
26,0,13,27,39,91,93,77,0,0,0,0,54,8,35,54,8,35,16,36,
52,24,9,55,6,20,104,28,80,11,38,54,1,31,2,59,93,5,21,125,
125,125,108,22,11,38,54,1,13,24,36,9,4,3,7,13,41,19,59,10,
9,9,5,31,19,49,28,4,0,7,18,6,44,0,0,0,8,65,67,18,
21,11,36,7,49,14,74,54,110,106,42,42,20,52,16,8,22,21,25,29,
21,50,2,18,11,5,9,5,7,5,23,21,41,36,9,10,7,31,2,17,
8,8,2,6,22,12,13,3,8,7,2,13,0,21,0,0,15,18,2,11,
7,16,7,31,17,37,25,10,3,16,14,14,68,32,8,7,20,7,21,4,
75,15,0,45,7,33,14,2,25,32,14,8,51,14,29,23,6,57,14,36,
24,28,34,28,14,32,28,7,4,18,4,0,19,5,17,13,7,13,19,15,
19,31,17,13,41,47,35,15,11,21,23,37,45,37,37,55,69,59,65,101,
83,99,11,15,53,15,29,35,43,57,65,51,57,55,37,47,55,39,41,6,
50,36,22,14,20,8,1,4,10,20,64,42,30,16,40,20,22,10,42,6,
84,60,46,30,48,10,1,5,1,13,90,40,8,4,22,1,19,9,10,76,
48,20,6,36,10,2,0,1,124,17,3,4,6,0,2,20,22,14,20,28,
36,13,1,29,11,52,19,53,11,8,7,27,35,19,33,49,63,67,5,0,
30,5,17,1,2,6,21,11,3,3,37,19,31,0,20,43,11,18,19,6,
11,0,38,19,23,4,16,39,37,91,34,42,58,12,2,14,7,7,5,25,
21,21,51,43,37,55,53,67,119,55,51,43,17,29,12,34,2,30,56,11,
15,23,23,63,45,39,79,49,67,61,93,83,85,85,33,29,89,27,29,51,
75,61,63,69,59,73,73,83,91,107,101,13,31,61,9,20,14,34,36,42,
78,50,68,70,106,84,76,110,104,84,12,23,57,79,109,125,125,125,26,92,
78,78,56,76,38,28,36,16,17,3,24,0,54,74,0,12,32,40,10,36,
66,8,1,46,13,57,103,125,125,125,125,125,0,0,0,0,52,8,35,52,
8,35,20,40,52,24,11,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
8,65,67,20,23,11,104,12,11,37,7,37,16,24,14,36,1,32,14,10,
30,29,39,33,45,64,2,38,11,2,17,0,30,15,35,17,21,36,9,12,
7,21,10,11,12,22,12,22,40,34,37,11,6,5,4,17,22,13,4,38,
5,32,34,12,69,20,9,57,23,69,19,6,5,14,2,4,42,8,1,22,
38,17,17,6,85,35,6,63,1,27,34,0,43,58,2,3,57,62,33,65,
2,79,0,30,34,22,30,20,0,28,38,43,11,16,6,2,31,11,19,29,
13,29,47,17,23,97,51,35,63,53,51,28,46,24,20,20,0,13,0,27,
37,23,53,75,73,121,17,19,53,35,47,55,65,73,81,93,87,121,41,87,
103,71,77,0,74,54,34,14,10,3,5,15,7,20,100,64,50,34,82,32,
24,4,8,6,96,60,34,18,44,16,4,1,3,9,64,26,12,0,24,4,
9,7,12,88,52,32,18,54,22,18,16,6,124,27,9,10,5,9,2,18,
20,4,18,32,42,25,15,23,13,40,23,25,11,6,34,49,31,16,26,49,
53,47,17,9,18,11,1,5,4,20,25,11,9,6,41,19,33,33,10,73,
25,6,13,34,13,3,54,11,17,3,46,39,27,75,36,58,58,36,6,36,
28,16,18,12,8,2,33,41,55,33,25,47,89,45,41,45,39,35,15,15,
45,57,27,8,6,10,7,39,15,21,53,31,45,45,75,71,63,57,19,9,
47,21,25,45,57,59,61,63,65,75,99,87,103,103,103,77,97,103,23,8,
5,14,22,22,122,44,40,9,60,124,112,124,36,32,16,53,101,109,121,125,
125,125,7,86,54,36,18,28,4,5,9,9,11,2,26,10,46,34,16,28,
34,40,42,22,46,38,1,36,22,3,17,31,43,95,97,79,0,0,0,0,
52,8,35,52,8,35,20,40,52,24,11,59,2,16,104,28,86,13,40,54,
1,33,2,61,95,5,25,125,125,125,114,24,11,40,54,1,13,26,36,9,
4,3,7,13,43,17,59,10,9,7,7,31,19,49,30,6,0,5,20,6,
44,0,0,0,8,65,67,20,23,11,36,7,49,16,78,56,114,110,44,44,
22,56,18,10,26,19,23,27,19,50,2,18,11,5,9,5,3,7,23,21,
41,36,9,10,7,31,2,17,10,8,0,6,22,12,13,3,8,7,2,13,
0,21,0,0,17,16,0,13,5,18,7,33,17,35,25,10,5,16,14,14,
70,34,8,7,20,7,23,4,77,15,0,45,9,35,12,2,25,34,14,8,
53,12,31,23,6,57,14,36,24,28,34,28,14,32,28,7,4,18,4,0,
19,5,17,15,7,13,19,17,21,31,19,13,43,49,35,17,15,25,27,41,
49,41,41,59,73,63,69,107,87,101,11,17,53,17,31,37,45,61,69,53,
59,55,37,47,55,39,41,6,50,36,22,14,20,8,1,4,12,20,64,42,
30,16,40,22,24,10,46,6,84,60,46,30,48,10,1,5,0,13,90,38,
6,4,22,1,19,9,10,74,46,18,4,36,10,2,0,1,124,15,1,6,
10,2,4,22,26,16,24,32,40,11,0,27,11,54,17,53,11,10,7,29,
35,21,35,51,65,69,7,1,30,7,19,1,2,6,23,13,3,5,39,19,
31,0,20,43,13,18,21,6,13,1,38,21,25,2,14,41,39,95,32,42,
58,10,1,10,11,11,9,31,27,25,57,47,41,61,61,73,125,59,57,47,
19,31,12,36,4,32,60,13,19,27,25,67,49,43,83,51,71,65,97,87,
87,87,35,29,91,31,33,55,77,65,67,73,63,77,77,85,93,109,101,15,
31,63,9,22,16,34,36,44,80,52,70,72,108,86,78,112,106,84,8,27,
63,83,115,125,125,125,26,94,80,78,58,78,38,30,36,16,15,3,26,2,
56,76,0,14,32,40,10,36,68,8,1,42,17,63,109,125,125,125,125,125,
0,0,0,0,50,8,37,50,8,37,24,42,54,24,11,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,10,65,67,20,23,13,104,12,11,35,7,37,
16,26,18,40,2,34,18,12,34,27,37,31,43,66,2,40,11,4,15,0,
34,15,33,17,19,36,9,12,3,21,12,9,12,22,12,24,40,34,37,11,
6,5,4,17,22,13,4,38,7,32,34,12,73,20,9,61,25,71,19,8,
5,14,4,4,44,8,1,22,42,17,17,6,87,33,8,63,1,27,36,2,
45,58,2,3,59,64,35,67,2,81,1,28,34,22,28,20,0,26,36,45,
13,16,6,2,31,13,21,31,15,29,49,19,23,101,53,35,65,55,51,26,
42,22,16,16,3,17,3,31,43,27,57,81,79,125,21,23,55,39,53,61,
71,77,87,97,93,125,43,91,105,73,77,2,76,54,36,14,10,3,5,15,
5,20,100,66,50,34,84,34,24,6,8,8,98,60,36,18,46,18,4,0,
1,7,66,28,14,0,24,4,7,3,14,88,52,32,20,54,22,20,16,8,
124,25,7,12,5,9,2,18,20,4,20,32,44,25,15,25,13,40,25,27,
13,4,34,51,33,16,26,49,55,49,15,7,20,11,0,5,6,20,25,9,
7,8,41,19,33,33,12,73,25,6,13,36,13,3,56,13,17,3,46,41,
27,77,34,56,58,34,4,36,28,14,16,12,6,0,35,43,57,35,27,51,
93,49,45,47,39,35,15,15,43,59,25,4,2,6,11,45,19,25,57,35,
51,49,81,75,65,57,21,11,51,25,31,49,61,63,65,67,71,79,103,91,
107,105,107,81,101,107,21,10,3,16,24,24,124,46,42,9,62,124,114,124,
38,30,14,57,107,115,125,125,125,125,5,86,54,36,18,28,4,5,9,7,
9,2,28,12,48,34,18,30,34,40,42,22,48,38,1,34,20,7,21,33,
45,101,99,81,0,0,0,0,50,8,37,50,8,37,24,42,54,24,11,61,
0,14,104,28,90,13,40,56,1,35,2,63,97,7,27,125,125,125,120,26,
11,40,56,1,11,28,38,11,6,1,5,15,43,17,59,10,7,7,7,31,
17,49,30,6,0,5,20,6,44,0,0,0,10,65,67,20,23,13,36,7,
47,20,82,60,116,114,46,46,26,58,20,10,28,19,23,27,19,52,2,18,
9,3,7,3,1,7,25,23,43,36,9,10,5,31,4,17,10,8,0,8,
22,10,13,3,8,7,2,13,1,21,0,1,19,14,0,13,5,18,7,33,
19,35,27,10,5,16,14,14,70,34,8,7,22,7,25,4,77,17,0,47,
9,37,12,2,27,34,14,8,57,12,33,23,6,59,12,36,22,28,34,28,
14,32,28,7,2,18,2,0,19,7,19,15,9,15,21,19,21,31,19,11,
45,53,35,21,19,29,31,45,53,45,45,63,77,65,71,111,91,103,11,17,
55,19,33,39,49,63,71,55,61,57,39,49,55,39,39,8,50,36,22,16,
20,8,1,6,14,22,62,42,30,16,42,22,26,12,50,6,86,60,46,30,
50,10,1,3,0,13,90,38,6,4,22,0,17,7,10,74,46,16,4,36,
10,4,2,0,124,15,0,6,12,4,6,26,28,18,26,34,42,11,2,27,
9,58,17,55,11,10,7,29,37,21,37,53,67,71,7,1,30,7,19,3,
0,6,23,13,5,5,39,19,33,0,20,45,13,16,23,4,15,1,40,21,
27,2,14,41,39,97,30,40,56,8,3,8,15,15,13,35,31,31,63,53,
43,65,67,79,125,65,61,51,21,33,12,38,4,36,66,17,23,31,29,71,
53,45,87,55,73,67,99,89,89,89,35,31,93,33,35,57,81,69,71,75,
65,81,79,89,97,113,103,17,33,65,9,22,16,36,38,44,84,54,72,74,
110,90,80,116,108,82,6,31,67,89,119,125,125,125,28,94,80,80,58,80,
40,30,38,18,15,1,26,2,58,78,0,14,34,42,10,38,70,8,1,40,
21,67,115,125,125,125,125,125,0,0,0,0,46,8,37,46,8,37,26,46,
54,24,13,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,10,67,67,22,
25,13,104,12,11,33,5,37,18,28,22,44,4,36,22,14,38,25,37,29,
41,66,2,42,9,4,15,2,38,15,33,15,17,36,9,14,1,19,14,9,
12,22,12,24,42,36,39,11,6,5,4,17,22,15,2,38,9,32,34,12,
77,20,11,65,27,73,17,10,3,16,4,6,46,10,0,24,44,17,17,6,
89,33,10,63,1,27,38,2,47,60,2,3,61,66,35,69,2,83,5,26,
32,20,26,18,1,24,36,49,15,14,6,2,33,15,23,33,17,31,51,21,
25,105,55,37,67,57,51,22,40,18,12,12,7,21,7,37,47,31,63,85,
83,125,25,27,59,43,57,65,75,81,91,103,97,125,45,95,107,75,77,2,
76,54,36,14,10,3,5,15,5,20,100,66,50,34,86,34,26,6,10,8,
100,62,36,18,46,18,6,0,0,5,68,30,14,0,26,6,5,1,14,88,
52,32,20,56,24,20,18,10,124,25,7,12,5,9,2,18,20,4,20,32,
44,25,15,25,15,42,27,29,15,2,34,55,35,16,26,51,57,49,15,5,
22,9,0,3,6,22,27,9,7,8,43,19,33,31,14,73,25,6,13,38,
13,3,58,13,19,3,48,43,27,79,32,56,56,32,2,34,26,12,14,10,
4,1,37,45,59,39,29,53,97,51,47,49,41,37,15,15,43,59,25,1,
3,2,15,51,23,29,63,39,55,53,85,79,69,59,25,15,53,29,35,53,
65,69,69,71,75,83,109,95,111,109,109,85,105,109,19,12,1,18,26,26,
124,48,44,9,64,124,118,124,40,26,10,63,113,121,125,125,125,125,5,86,
54,36,18,28,4,5,9,7,7,4,30,12,50,36,18,32,36,42,44,22,
48,38,1,32,16,11,25,37,49,105,103,83,0,0,0,0,46,8,37,46,
8,37,26,46,54,24,13,65,3,12,104,28,94,13,42,58,1,37,2,65,
99,7,31,125,125,125,124,28,11,42,58,1,11,30,38,11,6,1,3,15,
45,17,59,10,7,5,7,33,17,49,32,6,0,5,22,6,44,0,0,0,
10,67,67,22,25,13,36,7,47,24,84,62,120,116,48,48,28,60,22,12,
32,17,23,25,17,52,2,18,9,3,7,3,2,7,25,23,43,36,9,10,
5,31,4,17,12,8,0,8,22,10,13,3,8,7,2,13,3,23,0,3,
21,12,1,15,3,20,7,35,19,33,27,10,5,16,14,14,72,34,8,9,
22,9,27,2,79,17,0,47,11,39,12,0,29,34,14,8,59,12,35,23,
6,59,10,36,22,28,34,28,14,32,26,7,2,18,2,0,21,7,19,17,
9,15,23,21,23,31,21,11,47,55,35,23,23,33,35,49,57,49,49,67,
81,69,75,115,95,105,11,17,55,21,35,41,51,67,75,57,65,59,39,49,
55,39,39,8,50,36,22,16,20,8,1,6,16,22,62,42,30,16,42,24,
26,14,54,6,86,60,46,30,50,10,1,3,2,13,90,38,4,4,22,0,
17,5,10,72,44,14,2,36,10,4,2,0,124,13,2,8,14,6,8,28,
30,20,28,38,46,9,2,27,9,60,17,55,11,12,7,31,37,21,39,55,
69,73,9,3,30,9,21,3,0,6,25,15,5,5,41,21,33,0,20,45,
15,16,25,4,17,3,40,23,29,0,12,43,41,101,28,38,56,6,5,4,
19,19,17,41,37,35,69,57,45,71,73,85,125,71,67,55,23,37,12,40,
4,38,70,21,27,35,33,75,57,49,91,57,77,69,103,93,91,91,37,31,
95,35,39,61,85,73,75,79,69,85,83,91,99,115,105,19,35,67,9,24,
16,36,38,46,86,54,74,76,112,92,82,118,110,82,2,35,73,93,125,125,
125,125,28,96,82,80,58,80,40,30,38,18,15,1,28,4,60,80,0,16,
34,42,10,38,72,8,1,38,25,73,121,125,125,125,125,125,0,0,0,0,
44,8,37,44,8,37,30,48,54,24,13,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,12,67,67,22,27,13,104,12,11,31,3,37,18,32,24,48,
8,38,24,18,42,23,35,27,41,68,2,44,7,4,13,4,42,15,33,15,
13,38,7,14,0,19,14,9,14,24,14,26,42,36,39,13,6,5,4,17,
22,15,0,38,9,32,34,10,81,20,11,67,29,75,15,12,1,18,6,8,
48,12,0,26,46,17,17,8,91,31,12,63,0,27,38,2,49,62,2,3,
65,68,37,71,2,83,7,24,32,18,24,16,3,24,36,51,17,14,6,2,
33,15,23,35,17,33,53,21,27,109,57,39,69,59,51,18,38,14,8,10,
11,27,11,41,51,35,67,91,87,125,29,29,63,49,61,69,79,87,95,109,
101,125,47,97,111,75,77,2,76,56,36,14,10,3,5,15,3,22,102,66,
50,34,88,36,28,6,12,10,102,64,36,20,48,20,6,2,2,5,72,30,
14,2,28,8,5,0,16,90,54,32,20,58,26,22,20,12,124,25,7,14,
5,9,2,18,20,6,20,34,46,25,15,25,17,42,29,31,17,2,34,57,
37,14,26,53,59,51,13,5,24,9,2,3,8,24,27,9,7,8,45,19,
33,31,16,73,25,8,13,38,13,3,60,13,19,3,50,43,29,79,30,56,
56,32,0,32,24,10,14,8,2,3,39,47,61,41,33,57,101,53,49,51,
43,37,15,13,43,61,23,5,7,1,21,55,27,33,67,43,59,57,89,83,
71,61,29,19,55,33,39,57,69,73,73,75,79,87,113,99,115,113,111,89,
109,113,17,16,0,18,28,28,124,50,46,9,66,124,120,124,40,24,6,67,
119,125,125,125,125,125,5,86,54,36,18,28,4,5,9,5,5,6,32,14,
52,38,20,34,38,44,46,24,50,40,1,28,14,13,27,41,53,109,107,85,
0,0,0,0,44,8,37,44,8,37,30,48,54,24,13,67,5,8,104,28,
100,15,44,58,1,37,4,67,101,9,35,125,125,125,124,32,11,44,58,1,
11,32,38,13,6,1,3,15,45,15,59,10,7,3,9,33,17,49,32,8,
2,3,22,6,44,0,0,0,12,67,67,22,27,13,36,5,47,26,88,66,
122,120,52,50,30,64,24,14,36,17,21,25,15,52,2,18,7,3,5,1,
4,9,25,23,43,36,9,12,3,31,4,17,12,8,1,8,22,10,11,3,
10,7,2,13,3,23,0,3,23,12,3,17,1,20,7,37,21,33,29,10,
7,16,14,14,74,36,8,9,22,9,29,2,81,17,0,49,11,41,10,0,
29,36,14,8,61,10,37,23,6,61,10,36,22,28,34,28,14,32,26,7,
2,18,2,0,21,7,19,17,9,15,23,23,23,31,21,11,49,57,35,27,
27,35,37,53,61,53,53,71,85,73,79,121,97,107,11,19,57,23,37,43,
53,69,77,59,67,59,41,51,55,39,37,8,50,36,22,16,20,10,0,8,
18,24,62,42,30,16,42,24,28,14,58,6,86,60,46,30,50,10,1,3,
4,13,92,36,4,4,22,0,17,5,10,72,42,12,0,36,10,4,2,2,
124,11,4,10,18,8,10,30,34,22,32,40,50,7,4,25,7,62,15,57,
9,14,7,31,39,23,39,57,71,75,11,3,30,9,21,5,0,6,27,17,
5,7,43,21,33,0,20,45,17,14,25,4,19,5,40,25,31,0,12,45,
43,105,26,38,54,4,9,2,23,23,21,45,43,41,75,61,49,77,81,91,
125,75,71,59,25,39,12,42,6,40,74,23,29,39,35,79,61,51,95,59,
81,73,107,95,93,93,37,31,97,39,41,65,87,75,77,81,71,87,85,93,
101,117,105,19,35,69,7,24,18,38,40,48,88,56,76,78,116,94,84,120,
114,80,1,39,77,99,125,125,125,125,28,96,82,82,60,82,40,32,40,20,
13,1,30,4,62,82,2,18,36,44,10,40,74,8,1,34,29,77,125,125,
125,125,125,125,0,0,0,0,42,8,37,42,8,37,34,52,56,24,15,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,12,67,67,24,29,13,104,12,
11,29,1,37,20,34,28,52,10,40,28,20,46,21,33,25,39,70,2,46,
5,4,13,4,46,15,31,13,11,38,7,16,4,17,16,9,14,24,14,28,
44,38,41,13,6,5,4,17,22,17,0,38,11,32,34,10,85,20,13,71,
31,77,13,14,0,20,8,8,50,12,2,28,48,17,17,8,93,31,14,63,
0,27,40,2,51,64,2,3,67,70,37,73,2,85,11,22,30,16,22,14,
3,22,34,53,19,14,6,2,35,17,25,37,19,35,55,23,27,113,59,39,
71,61,51,16,34,12,4,6,15,31,15,47,57,39,73,95,93,125,33,33,
65,53,65,75,85,91,101,113,105,125,49,101,113,77,77,2,78,56,36,14,
10,3,5,15,3,22,102,66,50,34,90,36,28,8,12,12,104,64,38,20,
50,20,8,2,4,3,74,32,16,2,30,10,3,2,16,90,54,32,20,60,
26,24,22,14,124,23,5,14,5,9,2,18,20,6,20,34,46,25,15,25,
17,44,31,33,19,0,34,59,39,14,26,53,61,51,11,3,26,7,2,1,
8,26,27,9,7,10,45,19,33,29,18,73,25,8,13,40,13,3,62,13,
19,3,52,45,29,81,28,54,54,30,1,30,22,8,12,6,0,5,41,49,
63,45,35,59,105,57,51,53,43,39,15,13,43,61,21,9,11,5,25,61,
31,37,73,47,63,61,95,87,75,63,33,21,59,37,43,61,73,77,77,79,
83,91,119,103,119,117,113,93,113,115,15,18,2,20,30,30,124,52,48,9,
68,124,124,124,42,20,4,73,125,125,125,125,125,125,5,86,54,36,18,28,
4,5,9,5,3,8,34,16,54,38,20,36,38,44,46,24,50,40,1,26,
10,17,31,45,57,113,111,87,0,0,0,0,42,8,37,42,8,37,34,52,
56,24,15,71,9,6,104,28,104,15,46,60,1,39,4,69,103,9,39,125,
125,125,124,34,11,46,60,1,9,34,40,13,6,0,1,17,47,15,59,10,
7,3,9,33,17,49,34,8,2,3,24,6,44,0,0,0,12,67,67,24,
29,13,36,5,47,30,92,68,124,124,54,52,34,66,26,16,40,15,21,23,
13,52,2,18,7,3,5,1,8,9,27,25,45,36,9,12,3,31,6,17,
14,8,1,8,22,8,11,3,10,7,2,13,5,23,0,5,25,10,5,19,
1,22,7,39,21,31,29,10,7,16,14,14,76,36,8,9,24,9,31,2,
83,17,0,49,13,43,10,0,31,36,14,8,65,10,39,23,6,61,8,36,
22,28,34,28,14,32,26,7,0,18,2,0,21,9,21,19,11,17,25,25,
25,31,23,11,51,61,35,29,31,39,41,57,65,57,57,75,89,75,81,125,
101,109,11,19,57,25,39,45,57,73,81,61,69,61,41,51,55,39,37,10,
50,36,22,16,20,10,0,8,20,24,62,42,30,16,44,26,30,16,62,6,
86,60,46,30,52,10,1,3,4,13,92,36,2,4,22,0,17,3,10,70,
42,10,1,36,10,4,4,2,124,9,6,10,20,10,12,34,36,24,34,44,
52,7,6,25,7,66,15,57,9,14,7,33,39,23,41,59,73,77,11,5,
30,11,23,5,1,6,29,17,7,7,45,21,35,0,20,47,17,14,27,4,
21,5,40,27,33,1,10,47,43,107,24,36,54,2,11,1,27,27,25,51,
47,45,81,67,51,83,87,97,125,81,77,63,27,41,12,44,6,42,78,27,
33,43,39,83,65,55,99,63,83,75,109,99,95,95,39,33,99,41,45,67,
91,79,81,85,75,91,89,95,105,121,107,21,37,71,7,26,18,38,40,48,
90,58,78,80,118,96,86,124,116,80,3,43,83,103,125,125,125,125,30,98,
84,82,60,84,42,32,40,20,13,0,30,6,64,84,2,18,36,44,10,40,
76,8,1,32,33,83,125,125,125,125,125,125,0,0,0,0,40,8,37,40,
8,37,38,54,56,24,15,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
14,67,67,24,31,13,104,12,11,27,0,37,20,36,32,56,14,42,32,22,
50,19,31,23,37,72,2,48,3,4,11,6,50,15,31,13,9,38,7,16,
6,17,18,9,14,24,14,30,44,38,41,13,6,5,4,17,22,17,1,38,
13,32,34,10,89,20,13,75,33,79,11,16,2,22,10,10,52,14,2,30,
50,17,17,8,95,29,16,63,0,27,42,2,53,66,2,3,69,72,39,75,
2,87,13,20,30,14,20,12,5,20,34,55,21,14,6,2,35,19,27,39,
21,37,57,25,29,117,61,41,73,63,51,12,32,8,0,2,19,35,19,51,
61,43,77,101,97,125,37,37,69,57,69,79,89,95,105,119,109,125,51,105,
115,79,77,2,78,56,36,14,10,3,5,15,1,22,102,66,50,34,92,38,
30,8,14,14,106,66,38,20,52,22,8,4,6,1,76,34,16,2,32,12,
1,4,18,90,54,32,20,62,28,26,24,16,124,23,5,16,5,9,2,18,
20,6,20,34,48,25,15,25,19,44,33,35,21,1,34,61,41,14,26,55,
63,53,9,1,28,7,4,1,10,28,27,9,7,10,47,19,33,29,20,73,
25,8,13,42,13,3,64,13,19,3,54,47,29,83,26,54,54,28,3,28,
20,6,10,4,1,7,43,51,65,47,37,63,109,59,53,55,45,39,15,13,
43,63,19,13,15,9,29,67,35,41,77,51,67,65,99,91,77,65,37,25,
61,41,47,65,77,81,81,83,87,95,123,107,123,121,115,97,117,119,13,20,
4,22,32,32,124,54,50,9,70,124,124,124,44,18,0,77,125,125,125,125,
125,125,5,86,54,36,18,28,4,5,9,3,1,10,36,18,56,40,22,38,
40,46,48,24,52,40,1,24,8,21,35,49,61,117,115,89,0,0,0,0,
40,8,37,40,8,37,38,54,56,24,15,73,11,4,104,28,108,15,48,62,
1,41,4,71,105,11,43,125,125,125,124,36,11,48,62,1,9,36,40,15,
6,0,0,17,47,15,59,10,7,1,9,33,17,49,34,8,2,3,24,6,
44,0,0,0,14,67,67,24,31,13,36,5,47,34,96,72,124,124,56,54,
36,68,28,18,44,15,21,23,11,52,2,18,5,3,3,0,10,9,27,25,
45,36,9,12,1,31,6,17,14,8,1,8,22,8,11,3,10,7,2,13,
7,23,0,7,27,8,7,21,0,22,7,41,23,31,31,10,7,16,14,14,
78,36,8,9,24,9,33,2,85,17,0,51,13,45,10,0,33,36,14,8,
67,10,41,23,6,63,6,36,22,28,34,28,14,32,26,7,0,18,2,0,
21,9,21,19,11,17,27,27,25,31,23,11,53,63,35,33,35,43,45,61,
69,61,61,79,93,79,85,125,105,111,11,19,59,27,41,47,59,75,83,63,
71,63,43,53,55,39,35,10,50,36,22,16,20,10,0,10,22,26,62,42,
30,16,44,26,32,18,66,6,86,60,46,30,52,10,1,3,6,13,92,36,
2,4,22,0,17,1,10,70,40,8,3,36,10,4,4,4,124,7,8,12,
22,12,14,36,38,26,36,46,56,5,8,25,5,68,15,59,9,16,7,33,
41,23,43,61,75,79,13,5,30,11,23,7,1,6,31,19,7,7,47,21,
35,0,20,47,19,12,29,4,23,7,40,29,35,1,10,49,45,111,22,34,
52,0,13,3,31,31,29,55,53,51,87,71,53,89,93,103,125,87,81,67,
29,43,12,46,6,44,82,31,37,47,43,87,69,57,103,65,87,77,113,101,
97,97,39,33,101,43,47,71,95,83,85,87,77,95,91,97,107,123,109,23,
39,73,7,26,18,40,42,50,92,60,80,82,120,98,88,124,118,78,7,47,
87,109,125,125,125,125,30,98,84,84,60,86,42,32,42,22,13,0,32,6,
66,86,2,20,38,46,10,42,78,8,1,30,37,87,125,125,125,125,125,125,
0,0,0,0,36,6,39,36,6,39,40,56,56,24,17,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,14,69,67,24,33,15,104,10,11,25,0,37,
20,38,34,58,16,44,34,24,52,17,31,21,37,72,2,48,3,4,11,6,
52,15,31,13,7,38,7,16,8,17,18,9,14,24,14,30,44,38,43,15,
6,7,4,17,20,19,3,38,15,30,34,8,93,18,15,79,35,81,11,16,
2,22,10,10,54,14,2,30,52,19,17,8,99,29,16,63,0,29,42,2,
55,66,2,3,73,72,41,77,2,89,17,18,28,12,18,10,7,18,32,59,
23,12,4,2,37,21,29,41,23,39,59,27,31,121,65,43,77,67,51,8,
28,4,3,1,25,41,25,57,67,49,83,107,103,125,41,41,73,63,75,85,
95,101,111,125,115,125,53,109,119,81,79,2,78,56,36,14,10,5,5,15,
1,22,102,66,50,34,94,38,30,8,14,14,106,66,38,20,52,22,8,4,
8,1,78,34,16,2,32,12,1,6,18,90,54,32,20,62,28,26,24,16,
124,23,5,16,5,9,2,18,20,6,20,34,48,25,15,27,21,44,35,37,
23,3,32,65,45,12,24,57,67,55,9,1,30,7,4,1,10,28,29,9,
7,10,49,19,33,29,20,75,25,8,13,42,15,3,64,15,21,3,54,49,
31,85,24,52,52,26,7,26,18,4,8,2,3,9,45,55,69,51,41,67,
113,63,57,57,47,41,15,13,43,65,19,19,21,13,35,73,41,47,83,57,
73,71,105,97,81,67,41,29,65,45,53,71,83,87,87,87,93,101,125,111,
125,125,119,101,121,123,11,22,6,22,32,32,124,54,50,9,70,124,124,124,
44,14,3,83,125,125,125,125,125,125,5,86,52,34,18,28,4,7,9,3,
1,10,36,18,58,40,22,38,40,46,48,24,52,40,3,20,4,25,39,53,
65,123,119,91,0,0,0,0,36,6,39,36,6,39,40,56,56,24,17,77,
15,0,102,28,112,17,48,62,3,43,4,75,109,13,47,125,125,125,124,38,
13,48,62,3,9,38,40,17,6,0,0,19,49,15,61,10,7,1,11,35,
17,49,34,8,2,3,24,4,44,0,0,0,14,69,67,24,33,15,36,5,
47,36,98,74,124,124,58,56,38,70,30,18,46,15,21,23,11,52,2,18,
5,3,3,0,12,11,29,27,47,36,9,12,1,31,6,17,14,6,3,8,
20,6,11,5,10,7,0,13,9,25,1,9,31,6,9,23,0,22,7,43,
25,31,33,8,9,16,14,14,78,36,8,11,24,11,35,0,87,19,1,53,
15,47,8,1,35,36,14,8,71,8,43,23,6,65,4,34,20,28,34,26,
12,32,24,9,1,18,0,1,23,11,23,21,13,19,29,29,27,31,25,11,
55,67,35,37,39,47,49,65,75,65,65,83,97,83,89,125,109,115,13,21,
61,29,45,51,63,79,87,67,75,65,45,55,55,39,35,10,50,36,22,16,
20,10,0,10,24,26,60,42,30,16,44,26,32,18,68,4,86,60,44,28,
52,10,1,3,6,13,92,34,0,2,22,0,17,1,10,68,38,6,5,34,
10,4,4,4,124,7,10,12,24,14,14,38,40,28,38,48,58,5,8,25,
5,70,15,61,9,16,7,35,43,25,45,63,79,83,15,7,30,13,25,9,
3,4,33,21,9,9,49,23,37,0,20,49,21,10,31,2,25,9,40,31,
39,3,8,51,47,115,20,32,50,3,17,7,35,35,35,61,59,57,93,77,
57,95,101,109,125,93,87,71,33,47,12,46,6,46,86,35,41,51,47,93,
73,61,109,69,91,81,117,105,99,99,41,35,105,47,51,75,99,87,89,91,
81,99,95,101,111,125,111,25,41,75,7,26,18,40,42,50,94,60,82,82,
122,100,90,124,120,76,11,53,93,115,125,125,125,125,30,98,84,84,60,86,
42,32,42,22,13,0,32,6,68,88,2,20,38,46,10,42,78,8,3,26,
43,93,125,125,125,125,125,125,0,0,0,0,34,6,39,34,6,39,44,60,
58,26,17,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,16,69,67,26,
33,15,104,10,11,21,2,37,22,42,38,62,20,48,38,28,56,13,29,19,
35,74,4,50,1,6,9,8,56,13,29,11,3,40,5,18,12,15,20,7,
16,26,16,32,46,40,43,15,8,7,4,15,20,19,3,38,15,30,34,8,
95,18,15,81,37,81,9,18,4,24,12,12,56,16,4,32,56,19,17,10,
101,27,18,63,2,29,44,4,55,68,2,3,75,74,41,79,2,89,19,18,
28,12,18,10,7,18,32,61,23,12,4,2,37,21,29,41,23,39,61,27,
31,123,67,43,79,69,51,6,26,2,5,3,29,45,29,61,71,53,87,111,
107,125,43,43,75,67,79,89,99,105,115,125,119,125,53,111,121,81,79,4,
80,58,38,16,10,5,3,13,0,24,104,68,52,34,96,40,32,10,16,16,
108,68,40,22,54,24,10,6,12,0,82,36,18,4,34,14,0,10,20,92,
56,34,22,64,30,28,26,18,124,21,3,18,5,7,2,20,22,8,22,36,
50,23,15,27,21,46,35,37,25,3,32,67,47,12,24,57,69,55,7,0,
32,5,6,0,12,30,29,7,5,12,49,17,31,27,22,75,25,10,13,44,
15,3,66,15,21,1,56,49,31,85,24,52,52,26,9,26,18,4,8,2,
3,9,45,57,71,53,43,69,115,65,59,57,47,41,13,11,41,65,17,23,
25,17,39,77,45,51,87,61,77,75,109,101,83,67,43,31,67,47,57,75,
87,91,91,91,97,105,125,113,125,125,121,103,123,125,7,26,10,24,34,34,
124,56,52,9,72,124,124,124,46,12,5,87,125,125,125,125,125,125,3,88,
52,34,18,30,4,7,9,1,0,12,38,20,62,42,24,40,42,48,50,26,
54,42,3,18,2,27,41,55,67,125,121,91,0,0,0,0,34,6,39,34,
6,39,44,60,58,26,17,79,17,1,102,28,118,17,50,64,3,43,6,77,
111,13,49,125,125,125,124,42,13,50,64,3,7,42,42,17,8,2,2,19,
49,13,61,10,5,0,11,35,15,49,36,10,4,1,26,4,44,0,0,0,
16,69,67,26,33,15,36,3,45,40,102,78,124,124,62,58,42,74,34,20,
50,13,19,21,9,54,4,20,3,1,1,2,16,11,29,27,47,38,9,14,
0,29,8,15,16,6,3,10,20,6,9,5,12,7,0,11,9,25,1,9,
33,6,9,23,2,24,5,43,25,29,33,8,9,18,14,14,80,38,10,11,
26,11,35,0,87,19,1,53,15,49,8,1,35,38,16,8,73,8,43,21,
6,65,4,34,20,28,34,26,12,32,24,9,1,18,0,1,23,11,23,21,
13,19,29,29,27,29,25,9,55,69,33,39,41,49,51,69,79,67,67,87,
99,85,91,125,111,117,13,21,61,31,47,53,65,81,89,69,77,65,45,55,
53,37,33,12,52,36,22,18,22,12,2,12,28,28,60,42,30,16,46,28,
34,20,72,4,88,62,44,28,54,10,1,1,8,13,94,34,0,2,24,2,
15,0,10,68,38,6,5,34,10,6,6,6,124,5,12,14,28,18,16,42,
44,32,42,52,62,3,10,23,3,74,13,61,7,18,5,35,43,25,45,63,
81,85,15,7,32,13,25,9,3,4,33,21,9,9,49,23,37,2,22,49,
21,10,31,2,25,9,42,31,41,3,8,51,47,117,20,32,50,5,19,9,
39,39,39,65,63,61,97,81,59,99,107,115,125,97,91,73,35,49,12,48,
8,50,92,37,43,53,49,97,75,63,113,71,93,83,119,107,101,99,41,35,
107,49,53,77,101,89,91,93,83,101,97,103,113,125,111,25,41,75,5,28,
20,42,44,52,98,62,84,84,124,104,92,124,124,76,13,57,97,119,125,125,
125,125,32,100,86,86,62,88,44,34,44,24,11,2,34,8,72,92,4,22,
40,48,12,44,80,8,3,24,47,97,125,125,125,125,125,125,0,0,0,0,
32,6,39,32,6,39,48,62,58,26,17,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,18,69,67,26,35,15,104,10,11,19,4,37,22,44,42,66,
22,50,42,30,60,11,27,17,33,76,4,52,0,6,9,10,60,13,29,11,
1,40,5,18,14,15,22,7,16,26,16,34,46,40,45,15,8,7,4,15,
20,19,5,38,17,30,34,8,99,18,15,85,39,83,7,20,6,26,14,14,
58,18,4,34,58,19,17,10,103,27,20,63,2,29,46,4,57,70,2,3,
77,76,43,81,2,91,23,16,26,10,16,8,9,16,32,63,25,12,4,2,
37,23,31,43,25,41,63,29,33,125,69,45,81,71,51,2,24,1,9,7,
33,49,33,67,75,57,93,117,111,125,47,47,79,71,83,93,103,109,119,125,
123,125,55,115,123,83,79,4,80,58,38,16,10,5,3,13,2,24,104,68,
52,34,98,40,34,10,18,18,110,70,40,22,56,24,10,8,14,2,84,38,
18,4,36,16,2,12,20,92,56,34,22,66,32,30,28,20,124,21,3,18,
5,7,2,20,22,8,22,36,52,23,15,27,23,46,37,39,27,5,32,69,
49,12,24,59,71,57,5,2,34,5,6,0,14,32,29,7,5,12,51,17,
31,27,24,75,25,10,13,46,15,3,68,15,21,1,58,51,31,87,22,52,
52,24,11,24,16,2,6,0,5,11,47,59,73,57,45,73,119,67,61,59,
49,41,13,11,41,67,15,27,29,21,43,83,49,55,93,65,81,79,113,105,
85,69,47,35,69,51,61,79,91,95,95,95,101,109,125,117,125,125,123,107,
125,125,5,28,12,26,36,36,124,58,54,9,74,124,124,124,48,10,9,93,
125,125,125,125,125,125,3,88,52,34,18,30,4,7,9,0,2,14,40,22,
64,44,26,42,44,50,52,26,56,42,3,16,1,31,45,59,71,125,125,93,
0,0,0,0,32,6,39,32,6,39,48,62,58,26,17,81,19,3,102,28,
122,17,52,66,3,45,6,79,113,15,53,125,125,125,124,44,13,52,66,3,
7,44,42,19,8,2,4,19,49,13,61,10,5,2,11,35,15,49,36,10,
4,1,26,4,44,0,0,0,18,69,67,26,35,15,36,3,45,44,106,82,
124,124,64,60,44,76,36,22,54,13,19,21,7,54,4,20,1,1,0,2,
18,11,29,27,47,38,9,14,0,29,8,15,16,6,3,10,20,6,9,5,
12,7,0,11,11,25,1,11,35,4,11,25,4,24,5,45,27,29,35,8,
9,18,14,14,82,38,10,11,26,11,37,0,89,19,1,55,15,51,8,1,
37,38,16,8,75,8,45,21,6,67,2,34,20,28,34,26,12,32,24,9,
1,18,0,1,23,11,23,21,13,19,31,31,29,29,25,9,57,71,33,43,
45,53,55,73,83,71,71,91,103,89,95,125,115,119,13,21,63,33,49,55,
67,85,91,71,79,67,47,57,53,37,31,12,52,36,22,18,22,12,2,12,
30,30,60,42,30,16,46,28,36,22,76,4,88,62,44,28,54,10,1,1,
10,13,94,34,0,2,24,2,15,2,10,66,36,4,7,34,10,6,6,6,
124,3,14,16,30,20,18,44,46,34,44,54,66,1,12,23,1,76,13,63,
7,20,5,35,45,25,47,65,83,87,17,7,32,13,27,11,3,4,35,23,
9,9,51,23,37,2,22,49,23,8,33,2,27,11,42,33,43,3,8,53,
49,121,18,30,48,7,21,11,43,43,43,69,69,67,103,85,61,105,113,121,
125,103,95,77,37,51,12,50,8,52,96,41,47,57,53,101,79,67,117,73,
97,85,123,109,103,101,43,35,109,51,55,81,105,93,95,95,87,105,99,105,
115,125,113,27,43,77,5,28,20,44,44,54,100,64,86,86,124,106,94,124,
124,74,17,61,101,125,125,125,125,125,32,100,86,86,62,90,44,34,44,24,
11,2,36,8,74,94,4,24,42,50,12,44,82,8,3,22,51,101,125,125,
125,125,125,125,0,0,0,0,30,6,39,30,6,39,52,66,60,26,19,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,18,69,67,28,37,15,104,10,
11,17,6,37,24,46,46,70,26,52,46,32,64,9,25,15,31,78,4,54,
2,6,7,10,64,13,27,9,0,40,5,20,18,13,24,7,16,26,16,36,
48,42,45,15,8,7,4,15,20,21,5,38,19,30,34,8,103,18,17,89,
41,85,5,22,8,28,16,14,60,18,6,36,60,19,17,10,105,25,22,63,
2,29,48,4,59,72,2,3,79,78,43,83,2,93,25,14,26,8,14,6,
9,14,30,65,27,12,4,2,39,25,33,45,27,43,65,31,33,125,71,45,
83,73,51,0,20,3,13,11,37,53,37,71,81,61,97,121,117,125,51,51,
81,75,87,99,109,113,125,125,125,125,57,119,125,85,79,4,82,58,38,16,
10,5,3,13,2,24,104,68,52,34,100,42,34,12,18,20,112,70,42,22,
58,26,12,8,16,4,86,40,20,4,38,18,4,14,22,92,56,34,22,68,
32,32,30,22,124,19,1,20,5,7,2,20,22,8,22,36,52,23,15,27,
23,48,39,41,29,7,32,71,51,12,24,59,73,57,3,4,36,3,8,2,
14,34,29,7,5,14,51,17,31,25,26,75,25,10,13,48,15,3,70,15,
21,1,60,53,31,89,20,50,50,22,13,22,14,0,4,1,7,13,49,61,
75,59,47,75,123,71,63,61,49,43,13,11,41,67,13,31,33,25,47,89,
53,59,97,69,85,83,119,109,89,71,51,37,73,55,65,83,95,99,99,99,
105,113,125,121,125,125,125,111,125,125,3,30,14,28,38,38,124,60,56,9,
76,124,124,124,50,6,11,97,125,125,125,125,125,125,3,88,52,34,18,30,
4,7,9,0,4,16,42,24,66,44,26,44,44,50,52,26,56,42,3,14,
3,35,49,63,75,125,125,95,0,0,0,0,30,6,39,30,6,39,52,66,
60,26,19,85,23,5,102,28,124,17,54,68,3,47,6,81,115,15,57,125,
125,125,124,46,13,54,68,3,5,46,44,19,8,4,6,21,51,13,61,10,
5,2,11,35,15,49,38,10,4,1,28,4,44,0,0,0,18,69,67,28,
37,15,36,3,45,48,110,84,124,124,66,62,48,78,38,24,58,11,19,19,
5,54,4,20,1,1,0,4,22,11,31,29,49,38,9,14,2,29,10,15,
18,6,3,10,20,4,9,5,12,7,0,11,13,25,1,13,37,2,13,27,
4,26,5,47,27,27,35,8,9,18,14,14,84,38,10,11,28,11,39,0,
91,19,1,55,17,53,8,1,39,38,16,8,79,8,47,21,6,67,0,34,
20,28,34,26,12,32,24,9,3,18,0,1,23,13,25,23,15,21,33,33,
29,29,27,9,59,75,33,45,49,57,59,77,87,75,75,95,107,91,97,125,
119,121,13,21,63,35,51,57,71,87,95,73,81,69,47,57,53,37,31,14,
52,36,22,18,22,12,2,14,32,30,60,42,30,16,48,30,38,24,80,4,
88,62,44,28,56,10,1,1,10,13,94,34,1,2,24,2,15,4,10,66,
36,2,9,34,10,6,8,8,124,1,16,16,32,22,20,48,48,36,46,58,
68,1,14,23,1,80,13,63,7,20,5,37,45,25,49,67,85,89,17,9,
32,15,27,11,5,4,37,23,11,9,53,23,39,2,22,51,23,8,35,2,
29,11,42,35,45,5,6,55,49,123,16,28,48,9,23,15,47,47,47,75,
73,71,109,91,63,111,119,125,125,109,101,81,39,53,12,52,8,54,100,45,
51,61,57,105,83,69,121,77,99,87,125,113,105,103,43,37,111,53,59,83,
109,97,99,99,89,109,103,107,119,125,115,29,45,79,5,30,20,44,46,54,
102,66,88,88,124,108,96,124,124,74,19,65,107,125,125,125,125,125,34,102,
88,88,62,92,46,34,46,26,11,4,36,10,76,96,4,24,42,50,12,46,
84,8,3,20,55,107,125,125,125,125,125,125,0,0,0,0},
/*cabac_init_idc = 1*/
{124,18,21,124,18,21,125,81,20,18,24,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,39,45,67,17,44,2,104,16,11,125,77,37,21,87,125,125,
125,63,125,101,125,119,103,117,103,0,9,41,81,13,59,53,125,21,67,55,
125,14,37,25,123,59,47,27,15,0,9,41,2,3,4,14,5,1,4,29,
26,22,56,38,50,36,34,38,92,24,26,88,60,2,89,73,75,55,61,49,
41,45,39,47,61,13,17,21,8,77,73,63,23,17,23,15,34,11,2,3,
52,17,12,18,2,17,124,108,76,90,108,88,52,90,68,60,66,36,10,2,
4,50,36,48,42,38,36,44,28,58,42,16,24,34,51,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,92,124,120,82,124,124,124,124,120,116,124,
94,82,30,52,6,9,67,15,42,26,18,2,10,0,17,21,55,7,72,48,
38,34,1,9,29,27,45,57,16,6,2,3,19,25,33,49,93,67,41,31,
19,21,45,65,67,107,29,60,30,20,2,15,31,45,53,67,124,59,41,31,
5,15,2,6,8,23,2,10,5,31,15,9,38,2,54,46,72,68,38,54,
62,42,30,2,34,1,81,67,65,49,43,43,43,49,5,27,25,25,10,25,
39,71,63,63,25,21,13,23,9,3,19,2,2,9,23,16,1,13,114,88,
94,98,100,104,96,94,80,80,86,74,38,46,32,92,84,82,72,68,56,26,
12,0,27,37,61,11,91,124,124,124,124,124,124,124,124,124,124,124,122,100,
56,10,124,124,66,124,124,124,120,124,116,104,116,102,104,68,74,48,5,84,
64,26,113,97,101,43,57,51,15,35,33,9,13,14,9,26,21,124,124,124,
124,120,114,58,18,37,23,80,58,40,18,16,4,1,9,57,85,67,53,53,
49,19,31,45,19,13,11,5,1,10,8,124,124,124,124,120,108,86,54,7,
0,0,0,0,124,18,21,124,18,21,125,81,20,18,24,76,124,124,108,44,
109,3,15,31,22,26,13,18,58,82,124,122,54,11,125,75,25,15,31,22,
11,53,22,40,11,37,65,8,23,47,73,14,21,43,8,35,45,63,5,27,
13,45,17,4,44,0,0,0,39,45,67,17,44,2,96,24,33,125,55,65,
35,69,77,67,111,71,93,77,125,33,51,61,57,48,3,41,125,19,81,55,
125,16,14,16,4,20,9,21,49,79,55,51,57,25,47,93,83,29,97,71,
125,125,125,125,5,29,15,17,8,16,13,23,51,111,23,86,82,125,18,4,
10,6,4,7,41,21,3,22,12,4,11,13,16,15,10,4,44,76,62,40,
32,38,24,34,50,5,50,42,58,51,36,70,64,124,124,96,124,124,124,124,
124,124,124,124,124,124,106,124,124,124,124,124,124,124,112,124,124,124,54,124,
124,124,124,124,124,124,124,124,124,124,106,90,76,44,23,17,27,56,64,56,
66,36,42,36,74,18,5,14,19,7,105,97,15,4,20,5,27,33,41,47,
125,75,48,20,4,23,27,55,87,95,117,25,38,22,12,10,17,11,11,21,
45,5,58,62,64,22,16,7,19,51,22,118,110,110,88,52,4,19,13,29,
124,125,121,93,125,121,83,115,107,77,107,105,117,63,73,63,95,101,51,33,
37,43,35,17,1,7,14,11,11,11,11,7,27,1,4,7,1,12,3,5,
2,24,5,15,23,13,17,6,52,32,56,52,44,44,30,44,44,8,26,46,
5,26,124,124,124,124,124,124,124,124,124,124,124,124,124,124,108,124,124,124,
124,124,124,124,124,124,98,74,52,16,3,124,124,124,124,124,124,124,124,124,
124,124,124,86,66,38,30,28,36,82,82,84,86,70,78,58,42,48,26,13,
18,15,39,62,28,18,43,35,27,35,33,19,21,39,15,7,4,5,5,8,
8,124,124,124,124,124,120,106,72,12,15,78,54,42,22,12,0,3,7,37,
35,25,17,29,17,9,13,25,5,2,12,4,6,18,10,124,124,124,124,124,
120,106,72,12,0,0,0,0,124,18,21,124,18,21,123,77,22,20,24,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,37,45,67,15,44,2,104,16,
11,123,75,37,19,83,123,123,123,59,123,97,123,115,101,115,101,2,7,39,
79,11,57,51,123,19,65,53,123,16,35,23,119,57,45,25,13,2,7,39,
4,1,4,14,3,1,4,27,26,22,56,38,50,36,34,38,90,24,26,86,
58,2,87,71,73,53,59,47,39,43,37,45,57,13,17,19,6,75,71,63,
21,17,21,13,34,9,2,3,50,15,12,16,2,17,124,108,76,90,108,88,
52,90,68,58,66,36,10,2,4,50,36,48,42,38,34,44,28,56,40,16,
22,32,51,124,124,124,124,124,124,124,124,124,124,124,124,124,120,88,124,118,
80,124,124,124,124,116,112,122,90,78,30,50,4,9,67,13,44,28,20,4,
10,0,15,19,53,5,74,50,40,34,0,7,27,25,43,55,18,8,4,1,
17,23,31,47,89,65,37,29,17,19,43,63,65,103,27,62,32,22,4,13,
29,43,51,65,124,57,39,29,5,13,2,8,10,21,4,12,3,29,15,9,
38,4,54,46,70,68,38,52,60,42,30,2,32,1,79,65,63,47,41,41,
41,47,5,25,23,23,10,23,37,69,61,63,25,19,13,21,9,3,17,2,
2,7,21,16,1,13,114,88,94,98,98,104,96,94,80,80,86,74,38,44,
30,90,82,80,70,66,54,26,12,0,25,35,59,11,89,124,124,124,124,124,
124,124,124,124,124,122,118,96,54,10,124,124,64,124,124,124,116,124,112,100,
112,98,100,66,70,46,7,82,62,24,109,93,97,41,55,49,11,33,31,9,
11,18,5,30,19,124,124,124,124,116,110,54,14,39,21,82,58,40,18,18,
4,1,9,55,83,65,51,51,45,17,29,43,17,11,9,3,0,12,8,124,
124,124,124,118,106,82,52,7,0,0,0,0,124,18,21,124,18,21,123,77,
22,20,24,74,122,124,110,44,105,3,13,29,22,26,11,18,56,80,122,116,
50,13,121,73,23,13,29,22,11,51,22,40,9,35,63,8,23,45,71,14,
19,41,8,33,43,61,3,25,13,43,15,4,44,0,0,0,37,45,67,15,
44,2,96,24,33,121,51,61,31,63,73,63,107,67,89,73,121,33,49,59,
55,48,3,39,121,17,79,53,123,16,14,16,4,22,9,19,47,77,53,49,
55,23,45,89,79,27,93,67,117,117,119,121,3,27,13,15,8,18,11,21,
49,105,21,82,80,121,18,6,10,8,6,5,37,19,1,22,12,4,9,11,
14,13,10,4,44,74,62,40,32,38,24,34,48,3,50,42,58,51,36,70,
64,124,124,94,124,124,124,122,124,124,124,124,124,124,104,124,124,124,124,124,
124,124,108,124,120,124,52,124,124,124,124,124,124,124,124,124,124,122,104,88,
74,42,23,17,27,56,62,54,64,34,40,34,72,16,5,12,19,7,103,93,
13,6,20,3,25,31,39,45,121,71,50,22,6,21,25,51,83,91,113,23,
40,24,14,12,15,9,9,19,43,5,60,62,64,22,18,5,19,49,22,118,
110,108,86,52,6,17,11,27,124,121,117,89,121,117,79,111,103,73,103,101,
111,61,71,61,91,97,49,31,35,41,33,15,1,7,14,11,11,11,9,5,
25,0,4,5,0,12,1,3,2,24,3,13,21,11,15,6,50,32,54,52,
44,44,30,44,44,8,26,44,5,24,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,104,124,124,124,124,124,124,124,122,124,96,72,50,16,3,124,
124,124,124,124,124,124,124,124,124,124,124,84,64,36,30,28,34,80,80,82,
82,68,76,56,40,46,24,13,16,15,39,60,26,16,41,33,25,33,29,15,
19,37,13,5,6,3,3,8,8,124,124,124,124,120,112,98,64,8,13,78,
56,44,24,14,2,1,5,35,33,23,15,27,15,7,11,23,3,4,12,6,
8,18,10,124,124,124,124,120,112,98,64,8,0,0,0,0,124,18,21,124,
18,21,119,75,22,20,24,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
35,45,67,15,42,2,104,16,11,121,73,37,19,81,119,119,121,57,119,95,
119,113,99,113,99,4,7,37,77,11,57,49,119,19,65,53,121,16,35,23,
117,57,43,25,13,2,7,37,4,1,2,14,3,1,4,27,26,22,54,38,
48,36,34,38,86,24,26,82,56,0,85,69,71,51,57,45,37,41,37,43,
55,13,17,19,4,75,69,63,21,17,19,13,32,7,2,3,48,13,10,14,
2,19,120,106,74,88,106,86,50,88,68,56,64,36,10,2,4,48,34,46,
40,36,32,42,26,52,38,14,20,30,51,124,124,124,124,124,124,124,124,124,
124,124,124,124,116,82,124,114,76,124,124,124,124,112,108,116,86,74,28,46,
2,11,67,13,44,28,20,4,10,0,15,19,51,5,74,50,40,34,2,7,
25,25,41,53,20,10,4,1,15,23,31,45,87,63,35,27,17,19,41,61,
63,101,27,62,32,22,4,11,27,41,49,63,124,57,39,29,5,13,2,8,
10,21,4,12,1,29,15,9,36,4,52,44,68,66,38,50,58,42,30,0,
30,3,77,63,61,47,41,41,39,45,5,25,23,23,8,23,37,69,59,63,
25,19,13,19,9,3,15,2,2,7,19,14,1,15,112,88,94,96,96,102,
94,92,78,78,84,72,36,42,28,86,80,76,66,64,52,24,10,0,25,35,
59,13,87,124,124,124,124,124,124,124,124,124,124,118,114,92,52,8,124,120,
62,124,124,124,112,120,108,96,108,94,96,62,66,42,9,78,58,20,107,91,
95,39,53,47,7,31,29,9,9,20,3,32,17,124,124,124,124,110,104,48,
10,41,21,82,58,40,18,18,4,1,9,53,81,63,49,49,43,15,27,41,
15,9,7,3,2,12,8,124,124,124,122,114,102,78,48,9,0,0,0,0,
124,18,21,124,18,21,119,75,22,20,24,72,118,122,110,44,101,3,13,27,
22,24,11,16,52,78,116,108,44,17,115,71,23,13,27,22,11,49,22,38,
9,35,61,8,23,45,71,14,19,41,8,33,43,61,3,25,13,43,15,4,
44,0,0,0,35,45,67,15,42,2,94,24,33,117,49,59,27,59,71,61,
103,65,87,71,117,33,49,59,55,48,3,37,117,17,77,51,119,16,14,16,
2,22,9,19,45,75,51,47,53,23,43,87,77,25,91,65,107,109,113,115,
3,27,13,15,8,18,11,21,49,101,21,78,76,115,18,6,10,8,6,5,
33,17,1,22,12,4,7,9,12,13,10,4,42,72,60,40,30,38,24,34,
46,3,48,40,56,51,36,68,62,124,124,92,120,124,124,118,124,124,124,124,
124,124,100,124,124,124,124,124,124,124,104,124,116,124,48,124,124,124,124,124,
124,124,124,124,124,118,100,84,70,38,23,17,29,54,60,52,62,32,38,32,
68,14,5,10,21,9,101,91,11,6,20,3,23,29,37,43,117,69,50,22,
6,19,23,49,79,87,109,21,42,26,16,14,13,9,9,19,41,5,62,62,
62,22,18,5,19,49,22,118,108,106,84,52,6,17,11,27,124,119,115,87,
117,113,77,107,99,71,99,97,107,59,69,61,89,93,49,31,35,39,33,15,
1,7,12,11,11,11,9,5,23,0,4,5,0,12,1,3,2,22,3,13,
21,11,13,4,48,32,52,50,42,42,30,42,42,8,26,42,5,22,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,100,124,124,124,124,124,124,124,
118,118,92,68,48,14,5,124,124,124,124,124,124,124,124,124,124,124,124,80,
60,32,28,26,30,78,78,78,78,64,72,52,38,42,22,15,14,17,41,56,
24,14,41,33,23,33,27,13,19,35,11,3,6,3,1,8,8,124,124,124,
124,114,104,90,56,2,13,78,56,44,24,16,2,1,5,35,33,23,15,27,
13,5,11,23,3,4,12,6,10,18,10,124,124,124,124,114,104,90,56,2,
0,0,0,0,124,18,21,124,18,21,115,71,24,20,22,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,35,45,67,13,40,2,104,16,11,119,71,37,
17,79,115,115,117,55,115,93,115,111,97,111,97,6,7,35,75,11,55,49,
115,19,63,51,119,16,35,21,113,55,41,25,13,2,7,35,6,0,2,14,
3,1,4,27,26,20,54,38,46,36,34,38,82,24,24,78,54,1,83,67,
69,49,55,45,35,41,35,41,53,13,17,19,2,73,67,63,21,17,17,13,
30,5,2,3,46,11,10,12,2,21,118,104,74,86,104,84,50,86,66,54,
62,36,10,2,2,46,32,44,38,34,30,40,26,48,36,14,18,28,51,124,
124,124,124,124,124,124,124,124,124,124,124,124,110,78,124,110,74,124,122,124,
118,108,102,112,82,68,26,42,0,13,67,13,46,28,20,4,10,0,15,19,
51,5,74,50,40,34,4,5,25,23,41,51,22,10,6,1,13,21,29,45,
85,61,33,25,15,19,39,59,61,99,25,62,32,22,4,9,27,39,47,61,
124,55,37,27,5,13,2,8,10,21,4,12,1,29,15,9,36,6,50,42,
66,64,38,48,56,42,30,0,28,3,75,61,59,45,39,39,39,43,5,25,
23,21,8,23,37,67,57,63,25,19,13,17,9,3,13,2,2,7,17,12,
1,17,110,86,92,94,94,100,92,90,76,76,82,70,34,40,26,84,78,74,
62,60,50,22,10,1,25,35,59,13,85,124,124,124,124,124,124,124,124,124,
124,114,108,88,48,6,122,118,58,124,124,120,108,116,104,92,104,90,90,58,
62,38,11,74,54,18,105,89,93,37,51,45,5,29,27,9,7,24,0,36,
15,124,124,124,124,104,98,42,6,43,21,82,58,40,18,18,4,1,9,53,
79,61,47,47,41,15,27,39,15,9,7,3,2,12,8,124,124,124,118,110,
98,74,44,11,0,0,0,0,124,18,21,124,18,21,115,71,24,20,22,68,
114,120,110,44,97,3,11,25,22,24,11,16,50,76,112,102,40,19,109,69,
23,11,25,22,13,47,22,38,9,35,61,8,23,45,71,14,19,39,8,33,
41,61,3,25,13,43,15,4,44,0,0,0,35,45,67,13,40,2,92,22,
33,111,47,57,25,55,67,57,99,61,85,69,113,33,49,57,55,48,3,35,
113,17,75,51,115,16,12,14,2,22,9,17,45,73,49,47,51,21,41,83,
73,25,89,63,97,99,107,109,3,27,13,13,8,18,9,19,47,97,21,74,
72,109,18,6,10,8,6,3,31,15,1,22,12,4,7,7,10,13,10,2,
42,70,60,40,30,38,24,34,44,3,46,38,56,51,36,68,62,124,124,90,
116,124,124,114,124,124,124,124,124,122,96,124,124,124,124,124,124,120,100,124,
112,124,44,124,124,124,124,124,124,124,124,124,124,114,96,80,68,34,23,17,
29,52,58,50,60,30,36,30,64,12,7,8,23,9,101,87,9,8,20,3,
21,29,37,43,113,67,50,22,8,17,21,47,77,85,105,19,42,26,16,14,
11,7,9,19,41,5,62,62,60,22,18,5,19,47,22,116,108,104,82,52,
6,17,11,27,124,117,111,85,115,111,75,103,95,69,97,93,103,59,67,59,
87,89,47,31,35,39,31,15,1,7,12,11,11,13,7,3,21,0,4,3,
0,12,1,3,2,22,3,13,21,11,13,2,46,32,50,48,40,42,30,40,
40,8,26,40,5,20,124,124,122,124,124,124,124,124,124,124,124,124,124,124,
96,124,124,124,124,124,124,124,114,114,88,64,44,12,7,124,124,124,124,124,
124,124,124,124,124,118,120,76,56,30,26,24,28,74,74,74,74,62,68,48,
36,40,20,17,12,19,43,54,22,12,41,31,23,31,25,11,19,35,11,3,
6,1,0,8,8,124,124,124,118,108,96,82,48,3,13,78,56,44,24,16,
4,1,5,33,33,23,13,25,11,3,11,21,3,4,12,6,10,18,10,124,
124,124,118,108,96,82,48,3,0,0,0,0,124,18,21,124,18,21,113,69,
24,20,22,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,33,47,67,13,
38,2,104,16,11,117,69,37,17,75,113,111,115,53,113,89,111,109,97,109,
97,6,7,33,73,11,55,47,111,19,63,51,117,16,33,21,111,55,41,25,
11,2,7,35,6,0,0,12,3,1,4,27,26,20,52,38,46,36,34,36,
78,24,24,74,52,3,81,65,67,47,55,43,33,39,35,39,51,13,17,17,
0,73,65,63,21,17,17,13,28,3,2,3,42,9,8,10,2,23,114,102,
72,84,102,82,48,84,66,50,60,34,10,2,2,44,32,42,38,32,28,38,
24,44,34,12,16,26,51,124,124,124,124,124,124,124,124,124,124,124,124,118,
106,72,124,108,70,124,118,124,114,102,98,106,78,64,24,40,3,15,67,13,
46,30,20,4,10,0,15,19,49,3,76,50,40,34,6,5,23,23,39,51,
24,12,6,1,13,21,29,43,83,61,31,25,15,19,37,57,61,97,25,64,
32,22,4,7,25,39,45,59,124,55,37,27,5,13,2,8,10,19,4,12,
0,29,15,9,34,6,48,40,64,62,38,44,54,40,30,1,26,5,75,61,
57,45,39,39,37,41,7,25,23,21,6,23,37,67,55,63,25,17,13,17,
9,3,11,2,0,7,15,12,3,19,108,86,92,92,92,98,90,88,74,74,
80,68,32,38,24,80,74,70,58,58,48,20,8,1,25,35,59,15,85,124,
124,124,124,124,124,124,124,124,120,110,104,84,46,4,118,114,56,124,124,116,
104,110,100,88,100,86,86,54,58,34,13,70,50,14,103,87,91,37,49,43,
1,27,25,9,5,26,2,38,15,124,124,124,124,98,92,36,2,45,21,82,
58,40,18,18,4,1,9,51,77,59,45,47,39,13,25,37,13,7,5,1,
4,14,8,124,124,124,114,106,94,70,40,13,0,0,0,0,124,18,21,124,
18,21,113,69,24,20,22,66,110,118,110,42,93,3,11,23,20,22,11,14,
46,74,106,94,34,23,103,67,23,11,23,20,13,45,22,36,9,33,59,8,
23,45,71,14,19,39,8,33,41,59,3,25,13,43,13,4,44,0,0,0,
33,47,67,13,38,2,90,22,33,107,45,55,21,51,65,55,97,59,81,67,
109,33,47,57,55,48,3,33,109,17,75,49,111,16,12,14,0,22,9,17,
43,71,47,45,49,21,41,81,71,23,87,61,87,91,101,103,3,25,13,13,
8,18,9,19,47,93,21,70,68,105,18,8,10,8,6,3,27,13,0,20,
12,4,5,7,8,13,10,2,40,68,58,38,28,38,24,34,42,3,44,36,
54,51,34,66,60,124,124,88,112,124,124,110,124,124,124,124,124,118,92,118,
124,124,124,124,124,114,96,124,108,124,42,124,124,124,124,124,124,124,124,124,
120,110,92,76,64,30,23,17,31,50,56,48,56,28,32,28,62,10,7,6,
23,11,99,85,7,8,20,1,21,27,35,41,109,63,50,24,8,17,19,45,
73,81,103,19,44,28,18,16,9,7,9,17,39,5,64,62,60,20,18,5,
19,47,22,116,106,102,80,52,6,15,11,27,124,113,109,83,111,107,73,101,
93,67,93,91,99,57,65,59,85,87,47,31,35,37,31,15,3,7,10,11,
11,13,7,3,19,0,4,3,0,12,1,3,2,20,3,13,21,11,11,0,
44,32,48,48,38,40,30,38,38,8,26,38,5,18,124,124,120,124,124,124,
124,124,124,124,124,124,124,124,92,124,124,124,124,124,124,124,108,108,84,60,
42,10,7,124,124,124,124,124,124,124,124,124,124,114,114,72,52,26,24,24,
24,72,72,72,70,58,64,46,34,36,18,19,8,21,43,50,18,8,39,31,
21,31,23,9,19,33,9,1,6,1,2,8,8,124,124,124,112,100,88,72,
40,9,11,78,56,44,24,18,4,1,5,33,33,23,13,25,11,1,11,21,
1,6,12,6,12,18,10,124,124,124,112,100,88,72,40,9,0,0,0,0,
124,18,21,124,18,21,109,65,24,20,20,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,33,47,67,11,36,2,104,16,11,115,67,37,15,73,109,107,
111,51,109,87,107,107,95,107,95,8,7,31,71,11,53,45,107,19,63,49,
113,18,33,19,109,53,39,25,11,4,5,33,8,2,0,12,3,1,4,27,
26,18,50,38,44,36,34,36,74,24,22,72,50,5,79,63,65,45,53,41,
31,37,33,37,49,13,17,17,1,71,63,63,19,17,15,13,26,1,2,3,
40,7,8,8,2,23,112,100,72,82,100,80,46,84,66,48,58,34,10,2,
0,44,30,40,36,30,26,38,22,40,32,10,14,24,51,124,124,124,124,124,
124,124,124,124,124,124,124,114,102,68,120,104,66,124,114,120,110,98,94,100,
74,58,22,36,5,15,67,13,46,30,20,4,10,0,15,19,49,3,76,50,
40,34,8,3,21,23,37,49,26,14,6,0,11,19,27,43,81,59,27,23,
15,17,35,55,59,95,23,64,34,22,4,5,23,37,43,57,124,55,37,25,
5,13,2,8,10,19,4,14,0,29,15,9,32,8,46,38,62,62,38,42,
52,40,30,3,24,5,73,59,55,43,37,37,37,39,7,25,23,21,4,23,
37,65,53,63,25,17,13,15,9,3,9,2,0,7,13,10,3,19,106,86,
90,92,90,96,88,86,74,72,78,66,30,36,22,78,72,68,54,56,46,18,
6,3,25,33,59,15,83,124,124,124,124,124,124,124,124,120,116,106,100,80,
42,2,114,110,54,122,124,112,100,106,96,84,96,82,80,50,54,30,15,66,
46,12,101,83,89,35,47,41,2,25,23,9,3,30,6,42,13,124,124,124,
124,94,86,32,1,47,21,82,58,40,18,18,4,1,9,51,75,57,43,45,
37,11,25,35,11,5,3,1,4,14,8,124,124,124,112,102,90,66,36,15,
0,0,0,0,124,18,21,124,18,21,109,65,24,20,20,64,106,116,110,42,
89,3,11,21,20,22,11,12,42,72,102,88,30,27,97,65,21,11,21,20,
13,43,22,36,9,33,57,8,23,45,71,14,19,39,8,33,39,59,3,25,
13,43,13,4,44,0,0,0,33,47,67,11,36,2,88,20,33,101,43,53,
17,47,61,51,93,55,79,65,103,33,47,55,53,48,3,31,105,17,73,49,
107,16,10,12,0,22,9,15,43,69,45,45,47,19,39,77,67,21,83,59,
77,83,95,97,1,25,11,11,8,18,7,19,45,89,21,66,64,99,18,8,
10,8,6,1,25,11,0,20,12,4,5,5,6,11,10,0,40,66,58,38,
28,38,24,34,40,1,42,36,54,51,34,64,58,124,124,86,110,124,124,106,
124,124,124,124,122,114,88,114,124,120,124,124,124,110,92,124,104,124,38,124,
124,124,124,124,124,124,124,122,116,106,88,74,60,26,23,17,31,48,54,46,
54,26,30,26,58,8,9,4,25,13,97,81,5,10,20,1,19,27,35,39,
105,61,50,24,10,15,17,43,71,79,99,17,46,30,20,16,7,5,7,17,
39,5,64,62,58,20,18,5,19,45,22,114,104,100,78,52,6,15,11,25,
124,111,105,79,107,105,71,97,89,65,89,87,95,55,63,57,83,83,47,31,
33,37,29,15,3,7,10,11,11,15,5,3,17,0,4,3,0,12,1,3,
2,20,3,13,21,11,11,1,42,32,46,46,38,38,30,38,36,8,26,36,
5,16,124,124,118,124,124,124,124,124,124,124,124,124,124,124,88,124,124,124,
124,124,124,122,104,104,80,58,38,10,9,124,124,124,124,124,124,124,124,124,
122,110,108,68,48,24,24,22,20,70,68,68,66,54,60,42,32,34,16,19,
6,23,45,48,16,6,39,31,19,29,21,7,17,31,9,1,6,0,4,8,
8,124,124,118,106,94,80,64,32,15,11,78,56,44,24,18,4,0,3,31,
33,23,11,25,9,0,11,21,1,6,12,8,12,18,10,124,124,118,106,94,
80,64,32,15,0,0,0,0,124,18,23,124,18,23,105,63,26,20,20,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,31,47,67,11,36,0,104,16,
11,113,67,37,15,71,105,103,109,49,105,85,103,105,93,105,93,10,7,29,
71,9,53,45,103,19,61,49,111,18,33,19,105,53,37,23,11,4,5,31,
8,2,1,12,3,1,4,27,26,18,50,38,42,36,34,36,70,24,22,68,
48,7,79,61,65,45,51,41,29,37,33,37,45,13,17,17,3,71,61,63,
19,17,13,11,24,1,2,3,38,5,6,6,2,25,108,98,70,82,98,80,
46,82,64,46,56,34,10,2,0,42,28,38,34,30,24,36,22,36,30,10,
12,22,51,124,124,124,124,124,124,124,124,124,124,124,124,108,96,62,116,100,
64,124,108,114,104,94,88,96,68,54,20,32,7,17,67,11,48,30,22,4,
10,0,15,19,47,3,76,52,40,34,10,3,21,21,37,47,28,14,8,0,
9,19,27,41,79,57,25,21,13,17,35,55,57,91,23,64,34,22,6,5,
23,35,43,55,124,53,35,25,5,13,2,8,10,19,6,14,2,29,15,11,
32,8,44,36,60,60,38,40,50,40,30,3,22,7,71,57,53,43,37,37,
35,39,7,23,21,19,4,23,37,65,51,63,25,17,13,13,9,3,7,0,
0,7,13,8,3,21,104,84,90,90,88,96,88,84,72,72,76,64,28,34,
20,74,70,64,50,52,42,16,6,3,25,33,57,17,81,124,124,124,124,124,
124,124,124,116,110,102,94,76,40,2,112,108,50,118,124,108,96,102,92,80,
90,78,76,46,50,28,19,62,42,8,99,81,87,33,45,39,4,23,21,9,
1,32,8,44,11,124,124,124,118,88,82,26,5,51,19,82,58,40,18,18,
4,1,9,49,73,57,41,43,35,11,23,33,11,5,3,1,6,14,8,124,
124,122,108,100,88,60,34,17,0,0,0,0,124,18,23,124,18,23,105,63,
26,20,20,60,102,114,110,42,87,3,9,21,20,20,9,12,40,68,96,80,
24,29,93,63,21,9,21,20,15,43,22,34,9,33,57,8,23,43,69,14,
17,37,8,31,39,59,3,25,13,43,13,4,44,0,0,0,31,47,67,11,
36,0,88,20,33,97,41,51,15,41,59,49,89,53,77,63,99,33,47,55,
53,48,3,29,99,17,71,47,103,14,10,12,1,24,9,15,41,69,45,43,
45,19,37,75,65,21,81,57,67,73,89,91,1,25,11,11,8,18,7,17,
45,85,19,62,60,93,18,8,10,8,8,1,21,9,0,20,12,4,3,3,
4,11,10,0,38,64,56,38,26,38,24,34,36,1,40,34,52,51,34,64,
58,124,124,84,106,124,124,102,124,124,124,124,114,110,86,110,124,116,124,124,
124,104,88,124,100,124,34,124,124,124,124,124,124,124,124,118,112,100,84,70,
58,24,23,17,33,46,52,44,52,24,28,24,54,6,9,2,27,13,97,79,
3,10,20,1,17,25,33,39,101,59,52,24,10,13,15,41,67,75,95,15,
46,30,20,18,5,5,7,17,37,5,66,62,56,20,18,5,19,45,20,114,
104,98,76,50,6,15,11,25,124,109,103,77,105,101,69,93,85,63,87,83,
91,55,61,57,81,79,45,31,33,35,29,15,3,7,8,11,11,15,5,1,
15,0,4,1,2,12,0,1,2,18,3,13,21,11,9,3,40,32,44,44,
36,38,30,36,36,8,24,32,7,14,124,124,116,124,124,124,124,124,124,124,
124,124,124,124,84,124,124,124,124,124,124,116,100,98,76,54,36,8,11,124,
124,124,124,124,124,124,124,122,116,104,102,64,46,20,22,20,18,66,66,64,
62,52,56,38,30,30,14,21,4,25,47,44,14,4,39,29,19,29,19,5,
17,31,7,0,6,0,6,8,8,124,124,114,100,88,72,56,24,21,11,78,
56,44,24,20,6,0,3,31,31,21,11,23,7,2,9,19,1,6,12,8,
14,18,10,124,124,114,100,88,72,56,24,21,0,0,0,0,124,18,23,124,
18,23,101,59,26,20,18,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
31,47,67,9,34,0,104,16,11,111,65,37,13,67,103,99,105,47,103,81,
99,103,91,103,93,12,7,27,69,9,51,43,99,19,61,47,109,18,31,17,
103,51,37,23,9,4,5,29,10,4,1,10,3,1,4,27,26,16,48,38,
42,36,34,34,66,24,20,64,46,9,77,59,63,43,49,39,27,35,31,35,
43,13,17,15,5,69,59,63,19,17,13,11,22,0,2,3,34,3,6,4,
2,27,106,96,70,80,96,78,44,80,64,44,54,34,10,2,1,40,28,36,
34,28,22,34,20,32,28,8,10,20,51,124,124,124,124,124,124,124,124,124,
124,120,122,104,92,58,112,98,60,124,104,110,100,88,84,90,64,48,18,30,
11,19,67,11,48,32,22,4,10,0,15,19,47,1,78,52,40,34,12,1,
19,21,35,45,30,16,8,0,7,17,25,41,77,57,23,21,13,17,33,53,
57,89,21,66,34,22,6,3,21,33,41,53,124,53,35,23,5,13,2,8,
10,17,6,14,2,29,15,11,30,10,42,34,58,58,38,38,48,38,30,5,
20,7,69,57,51,41,35,35,35,37,7,23,21,19,2,23,37,63,49,63,
25,15,13,13,9,3,5,0,0,7,11,8,5,23,102,84,88,88,86,94,
86,82,70,70,74,62,26,32,18,72,66,62,46,50,40,14,4,5,25,33,
57,17,79,124,124,124,124,124,124,124,122,112,106,98,90,72,36,0,108,104,
48,114,124,104,92,98,88,76,86,74,70,42,46,24,21,58,38,6,97,79,
85,33,43,37,8,21,19,9,0,36,12,48,11,124,124,122,112,82,76,20,
9,53,19,82,58,40,18,18,4,1,9,49,71,55,39,41,33,9,23,31,
9,3,1,0,6,16,8,124,124,118,104,96,84,56,30,19,0,0,0,0,
124,18,23,124,18,23,101,59,26,20,18,58,98,112,110,42,83,3,9,19,
18,20,9,10,36,66,92,74,20,33,87,61,21,9,19,18,15,41,22,34,
9,31,55,8,23,43,69,14,17,37,8,31,37,57,3,25,13,43,11,4,
44,0,0,0,31,47,67,9,34,0,86,18,33,91,39,49,11,37,55,45,
87,49,73,61,95,33,45,53,53,48,3,27,95,17,69,47,99,14,8,10,
1,24,9,13,41,67,43,43,43,17,35,71,61,19,79,55,57,65,83,85,
1,23,11,9,8,18,5,17,43,81,19,58,56,87,18,10,10,8,8,0,
19,7,2,18,12,4,3,3,2,11,10,1,38,62,56,36,26,38,24,34,
34,1,38,32,52,51,34,62,56,120,124,82,102,124,124,98,124,122,124,124,
108,106,82,104,124,110,124,124,124,98,84,124,96,124,32,124,124,124,124,124,
124,124,124,114,106,96,80,66,54,20,23,17,33,44,50,42,48,22,26,22,
52,4,11,0,27,15,95,75,1,12,20,0,17,25,33,37,97,55,52,26,
12,13,13,39,65,73,91,15,48,32,22,18,3,3,7,15,37,5,66,62,
56,18,18,5,19,43,20,112,102,96,74,50,6,13,11,25,124,105,99,75,
101,99,67,91,83,61,83,81,87,53,59,55,79,75,45,31,33,35,27,15,
5,7,8,11,11,17,3,1,13,0,4,1,2,12,0,1,2,18,3,13,
21,11,9,5,38,32,42,44,34,36,30,34,34,8,24,30,7,12,122,124,
114,124,124,124,124,124,124,124,124,124,124,124,80,124,124,124,124,124,124,112,
96,94,72,50,32,6,11,124,124,124,124,124,124,124,124,118,112,100,96,60,
42,18,20,20,14,64,62,62,58,48,52,36,28,28,12,23,0,27,47,42,
10,0,37,29,17,27,17,3,17,29,7,0,6,2,8,8,8,124,124,108,
94,80,64,48,16,27,9,78,56,44,24,20,6,0,3,29,31,21,9,23,
5,4,9,19,0,8,12,8,14,18,10,124,124,108,94,80,64,48,16,27,
0,0,0,0,124,16,23,124,16,23,99,57,26,20,18,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,29,49,67,9,32,0,104,16,11,109,63,37,
13,65,99,95,103,45,99,79,97,101,91,101,91,12,7,25,67,9,51,43,
97,19,61,47,107,18,31,17,101,51,35,23,9,4,5,29,10,4,3,10,
3,1,4,27,26,16,46,38,40,36,34,34,62,24,20,60,44,11,75,57,
61,41,49,39,25,35,31,33,41,13,17,15,9,69,57,63,19,19,11,11,
20,2,2,3,32,1,4,2,2,29,102,94,68,78,94,76,42,78,62,40,
52,32,10,2,1,38,26,34,32,26,20,32,18,28,24,6,8,18,51,124,
124,124,124,124,124,124,124,124,122,116,116,98,86,52,108,94,56,122,100,104,
94,84,78,84,60,44,16,26,13,21,69,11,48,32,22,4,10,0,15,19,
45,1,78,52,40,34,14,1,19,21,35,45,32,16,8,0,7,17,25,39,
75,55,21,19,13,17,31,51,55,87,21,66,34,22,6,1,21,33,39,53,
124,53,35,23,5,13,2,8,10,17,6,14,4,29,15,11,28,10,40,32,
56,56,38,34,44,38,30,7,18,9,69,55,49,41,35,35,33,35,9,23,
21,19,0,23,37,63,49,65,25,15,13,11,9,3,5,0,1,7,9,6,
5,25,100,82,88,86,82,92,84,80,68,68,72,60,24,30,16,68,64,58,
42,46,38,12,2,5,25,33,57,19,79,124,124,124,124,124,124,122,116,108,
102,94,84,68,34,1,104,100,44,110,122,98,86,92,82,72,82,68,66,38,
40,20,23,54,34,2,95,77,83,31,41,37,10,19,19,9,0,38,14,50,
9,124,124,116,106,76,70,14,13,55,19,82,58,40,18,18,4,1,9,47,
71,53,37,41,31,9,21,31,9,3,1,0,8,16,6,124,124,114,100,92,
80,52,26,21,0,0,0,0,124,16,23,124,16,23,99,57,26,20,18,54,
92,110,110,40,79,5,9,17,18,18,9,8,32,64,86,66,14,37,81,59,
21,9,17,18,17,39,22,32,9,31,55,6,25,43,69,14,17,37,8,31,
37,57,3,25,13,43,11,4,44,0,0,0,29,49,67,9,32,0,84,18,
35,87,37,47,9,33,53,43,83,47,71,59,91,33,45,53,53,48,3,25,
91,17,69,45,95,14,8,10,3,24,9,13,39,65,41,41,43,17,35,69,
59,19,77,53,49,57,77,81,1,23,11,9,6,18,5,17,43,77,19,54,
52,83,18,10,10,8,8,0,15,7,2,18,10,4,1,1,1,11,10,1,
36,58,54,36,24,38,24,32,32,1,36,30,50,51,32,60,54,116,124,78,
98,124,124,92,124,118,124,124,100,102,78,100,124,106,124,124,124,92,80,124,
92,124,28,124,124,124,124,124,124,124,120,110,102,92,76,62,50,16,23,19,
35,42,46,40,46,20,22,18,48,2,11,1,29,17,95,73,0,12,20,0,
15,23,31,37,93,53,52,26,12,11,11,37,61,69,89,13,48,32,22,20,
1,3,7,15,35,7,68,62,54,18,18,5,19,43,20,112,100,94,72,50,
6,13,11,25,124,103,97,73,99,95,65,87,79,59,81,77,83,53,59,55,
77,73,45,31,33,33,27,15,5,7,6,11,11,17,3,1,11,0,2,1,
2,10,0,1,2,16,3,13,21,11,7,7,36,32,38,42,32,34,28,32,
32,8,24,28,7,8,120,120,112,124,124,124,124,124,124,124,124,124,124,120,
76,124,124,124,124,124,124,106,90,88,68,46,30,4,13,124,124,124,124,124,
124,124,124,112,106,94,90,56,38,14,18,18,10,60,60,58,54,44,48,32,
24,24,8,25,1,29,49,38,8,1,37,29,17,27,15,1,17,29,5,2,
6,2,8,8,6,124,120,102,88,74,56,38,6,33,9,78,56,44,24,22,
6,0,3,29,31,21,9,23,5,4,9,19,0,8,12,8,16,18,8,124,
120,102,88,74,56,38,6,33,0,0,0,0,124,16,23,124,16,23,95,55,
28,20,18,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,27,49,67,9,
30,0,104,16,11,107,61,37,13,63,95,91,99,41,95,77,93,99,89,99,
89,14,5,23,65,9,49,41,93,19,59,47,103,20,31,17,97,51,33,23,
9,6,3,27,10,4,3,10,1,1,4,25,26,16,46,38,38,36,34,34,
58,24,20,58,42,11,73,55,59,39,47,37,23,33,31,31,39,13,17,15,
11,67,55,63,17,19,9,11,18,4,2,3,30,0,2,0,2,29,100,92,
68,76,92,74,42,78,62,38,50,32,10,2,1,38,24,32,30,24,18,32,
18,26,22,6,6,16,51,124,124,124,124,124,124,124,124,124,118,112,112,92,
82,46,106,90,54,118,96,100,90,80,74,80,56,40,16,22,15,21,69,11,
50,32,22,6,10,0,13,19,43,1,78,52,42,34,16,0,17,19,33,43,
34,18,10,2,5,15,25,37,73,53,17,17,11,15,29,49,53,85,19,66,
36,24,6,0,19,31,37,51,124,51,33,21,5,13,2,10,12,17,6,16,
6,29,15,11,28,10,38,32,54,56,38,32,42,38,30,7,16,11,67,53,
47,41,33,35,31,33,9,23,21,17,0,23,37,63,47,65,25,15,13,9,
9,3,3,0,1,7,7,4,5,25,98,82,88,86,80,90,82,78,68,66,
70,60,24,28,14,66,62,54,38,44,36,12,2,5,23,31,57,21,77,124,
124,124,124,124,124,118,112,104,98,90,80,64,32,3,100,98,42,106,118,94,
82,88,78,68,78,64,62,36,36,16,25,50,30,1,93,73,79,29,39,35,
14,17,17,9,2,42,16,54,7,124,124,112,100,72,64,10,17,57,19,82,
58,40,18,20,4,1,9,45,69,51,35,39,27,7,19,29,7,1,0,0,
10,16,6,124,122,112,98,88,76,48,22,21,0,0,0,0,124,16,23,124,
16,23,95,55,28,20,18,52,88,108,112,40,75,5,7,15,18,16,9,8,
30,62,82,58,8,39,75,57,19,7,15,18,17,37,22,32,7,31,53,6,
25,43,69,14,17,35,8,31,37,57,3,25,13,41,11,4,44,0,0,0,
27,49,67,9,30,0,82,18,35,83,33,45,5,29,49,41,79,43,69,55,
85,33,45,53,51,48,3,23,87,15,67,43,91,14,8,10,3,24,9,13,
37,63,39,39,41,15,33,67,55,17,73,51,39,47,69,75,0,23,9,7,
6,18,5,15,41,71,19,50,50,77,18,10,10,8,8,2,11,5,2,18,
10,4,0,0,3,9,10,1,34,56,52,36,22,38,24,32,30,0,34,30,
48,51,32,60,54,112,124,76,96,124,124,88,120,114,124,124,94,98,74,96,
124,102,124,124,124,88,76,124,88,124,24,124,124,124,124,124,124,120,116,106,
98,88,74,60,48,12,23,19,35,42,44,38,44,18,20,16,44,0,11,3,
31,17,93,71,2,12,20,0,13,21,29,35,87,51,52,26,12,9,9,35,
57,65,85,11,50,34,24,22,0,3,5,15,33,7,70,62,52,18,20,3,
19,41,20,112,100,92,70,50,6,13,11,23,124,101,95,69,95,91,63,83,
75,57,77,73,79,51,57,53,75,69,43,29,31,31,25,15,5,7,4,11,
11,17,3,0,9,2,2,0,2,10,0,1,2,14,3,11,19,11,5,7,
34,32,36,40,32,34,28,32,30,8,24,26,7,6,118,118,112,122,124,124,
124,124,124,124,124,124,124,114,72,124,124,124,124,124,124,100,86,84,66,44,
28,4,15,124,124,124,124,124,124,124,124,108,102,90,86,52,34,10,18,16,
8,58,58,54,50,42,46,28,22,20,6,25,3,29,51,34,6,3,37,27,
15,27,13,2,15,27,3,4,6,4,10,8,6,124,116,98,82,68,48,30,
1,39,9,78,56,46,26,24,8,2,1,29,31,21,9,21,3,6,9,17,
0,8,12,10,18,18,8,124,116,98,82,68,48,30,1,39,0,0,0,0,
124,16,23,124,16,23,91,51,28,20,16,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,27,49,67,7,28,0,104,16,11,105,59,37,11,59,93,87,
97,39,93,73,89,97,87,97,89,16,5,21,63,9,49,39,89,19,59,45,
101,20,29,15,95,49,33,23,7,6,3,25,12,6,5,8,1,1,4,25,
26,14,44,38,38,36,34,32,54,24,18,54,40,13,71,53,57,37,45,35,
21,31,29,29,37,13,17,13,13,67,53,63,17,19,9,11,16,6,2,3,
26,2,2,1,2,31,96,90,66,74,90,72,40,76,62,36,48,32,10,2,
3,36,24,30,30,22,16,30,16,22,20,4,4,14,51,124,124,124,124,124,
124,124,124,124,114,108,106,88,78,42,102,88,50,112,92,96,86,74,70,74,
52,34,14,20,19,23,69,11,50,34,22,6,10,0,13,19,43,0,80,52,
42,34,18,0,15,19,31,41,36,20,10,2,3,15,23,37,71,53,15,17,
11,15,27,47,53,83,19,68,36,24,6,2,17,29,35,49,124,51,33,21,
5,13,2,10,12,15,6,16,6,29,15,11,26,12,36,30,52,54,38,30,
40,36,30,9,14,11,65,53,45,39,33,33,31,31,9,23,21,17,1,23,
37,61,45,65,25,13,13,9,9,3,1,0,1,7,5,4,7,27,96,82,
86,84,78,88,80,76,66,64,68,58,22,26,12,62,58,52,34,42,34,10,
0,7,23,31,57,21,75,124,124,124,124,124,120,114,106,100,94,86,76,60,
28,5,96,94,40,102,114,90,78,84,74,64,74,60,56,32,32,12,27,46,
26,3,91,71,77,29,37,33,18,15,15,9,4,44,20,56,7,124,120,106,
94,66,58,4,21,59,19,82,58,40,18,20,4,1,9,45,67,49,33,37,
25,5,19,27,5,0,2,2,10,18,6,120,118,108,94,84,72,44,18,23,
0,0,0,0,124,16,23,124,16,23,91,51,28,20,16,50,84,106,112,40,
71,5,7,13,16,16,9,6,26,60,76,52,4,43,69,55,19,7,13,16,
17,35,22,30,7,29,51,6,25,43,69,14,17,35,8,31,35,55,3,25,
13,41,9,4,44,0,0,0,27,49,67,7,28,0,80,16,35,77,31,43,
1,25,47,37,77,41,65,53,81,33,43,51,51,48,3,21,83,15,65,43,
87,14,6,8,5,24,9,11,37,61,37,39,39,15,31,63,53,15,71,49,
29,39,63,69,0,21,9,7,6,18,3,15,41,67,19,46,46,71,18,12,
10,8,8,2,9,3,4,16,10,4,0,0,5,9,10,3,34,54,52,34,
22,38,24,32,28,0,32,28,48,51,32,58,52,108,124,74,92,124,124,84,
114,110,124,124,86,94,70,90,122,96,124,124,124,82,72,116,84,124,22,124,
124,124,124,124,120,116,112,102,92,84,70,56,44,8,23,19,37,40,42,36,
40,16,18,14,42,1,13,5,31,19,91,67,4,14,20,2,13,21,29,33,
83,47,52,28,14,9,7,33,55,63,81,11,52,36,26,22,2,1,5,13,
33,7,70,62,52,16,20,3,19,41,20,110,98,90,68,50,6,11,11,23,
124,97,91,67,91,89,61,81,73,55,73,71,75,49,55,53,73,65,43,29,
31,31,25,15,7,7,4,11,11,19,1,0,7,2,2,0,2,10,0,1,
2,14,3,11,19,11,5,9,32,32,34,40,30,32,28,30,28,8,24,24,
7,4,116,116,110,118,120,124,124,124,124,124,124,124,124,110,68,124,124,124,
124,124,124,96,82,78,62,40,24,2,15,124,124,124,124,124,124,124,124,104,
96,86,80,48,30,8,16,16,4,56,54,52,46,38,42,26,20,18,4,27,
7,31,51,32,2,7,35,27,13,25,11,4,15,25,3,4,6,4,12,8,
6,124,112,92,76,60,40,22,9,45,7,78,56,46,26,24,8,2,1,27,
31,21,7,21,1,8,9,17,2,10,12,10,18,18,8,124,112,92,76,60,
40,22,9,45,0,0,0,0,124,16,25,124,16,25,87,49,30,20,16,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,25,49,67,7,28,1,104,16,
11,103,59,37,11,57,89,83,93,37,89,71,85,95,85,95,87,18,5,19,
63,7,47,39,85,19,57,45,99,20,29,15,91,49,31,21,7,6,3,23,
12,6,5,8,1,1,4,25,26,14,44,38,36,36,34,32,50,24,18,50,
38,15,71,51,57,37,43,35,19,31,29,29,33,13,17,13,15,65,51,63,
17,19,7,9,14,6,2,3,24,4,0,3,2,33,94,88,66,74,88,72,
40,74,60,34,46,32,10,2,3,34,22,28,28,22,14,28,16,18,18,4,
2,12,51,124,124,124,124,124,124,124,124,124,108,104,102,82,72,36,98,84,
48,108,86,90,80,70,64,70,46,30,12,16,21,25,69,9,52,34,24,6,
10,0,13,19,41,0,80,54,42,34,20,2,15,17,31,39,38,20,12,2,
1,13,23,35,69,51,13,15,9,15,27,47,51,79,17,68,36,24,8,2,
17,27,35,47,124,49,31,19,5,13,2,10,12,15,8,16,8,29,15,13,
26,12,34,28,50,52,38,28,38,36,30,9,12,13,63,51,43,39,31,33,
29,31,9,21,19,15,1,23,37,61,43,65,25,13,13,7,9,3,0,1,
1,7,5,2,7,29,94,80,86,82,76,88,80,74,64,64,66,56,20,24,
10,60,56,48,30,38,30,8,0,7,23,31,55,23,73,124,124,124,124,124,
116,110,102,96,88,82,70,56,26,5,94,92,36,98,108,86,74,80,70,60,
68,56,52,28,28,10,31,42,22,7,89,69,75,27,35,31,20,13,13,9,
6,48,22,60,5,122,118,102,88,60,54,1,25,63,17,82,58,40,18,20,
4,1,9,43,65,49,31,35,23,5,17,25,5,0,2,2,12,18,6,118,
116,104,90,82,70,38,16,25,0,0,0,0,124,16,25,124,16,25,87,49,
30,20,16,46,80,104,112,40,69,5,5,13,16,14,7,6,24,56,72,44,
1,45,65,53,19,5,13,16,19,35,22,30,7,29,51,6,25,41,67,14,
15,33,8,29,35,55,3,25,13,41,9,4,44,0,0,0,25,49,67,7,
28,1,80,16,35,73,29,41,0,19,43,35,73,37,63,51,77,33,43,51,
51,48,3,19,77,15,63,41,83,12,6,8,5,26,9,11,35,61,37,37,
37,13,29,61,49,15,69,47,19,29,57,63,0,21,9,5,6,18,3,13,
39,63,17,42,42,65,18,12,10,8,10,4,5,1,4,16,10,4,2,2,
7,9,10,3,32,52,50,34,20,38,24,32,24,0,30,26,46,51,32,58,
52,104,124,72,88,122,124,80,110,106,124,124,80,90,68,86,114,92,124,124,
124,76,68,110,80,124,18,124,124,124,124,124,116,110,108,98,88,78,66,52,
42,6,23,19,37,38,40,34,38,14,16,12,38,3,13,7,33,19,91,65,
6,14,20,2,11,19,27,33,79,45,54,28,14,7,5,31,51,59,77,9,
52,36,26,24,4,1,5,13,31,7,72,62,50,16,20,3,19,39,18,110,
98,88,66,48,6,11,11,23,124,95,89,65,89,85,59,77,69,53,71,67,
71,49,53,51,71,61,41,29,31,29,23,15,7,7,2,11,11,19,1,2,
5,2,2,2,4,10,2,0,2,12,3,11,19,11,3,11,30,32,32,38,
28,32,28,28,28,8,22,20,9,2,112,114,108,116,116,124,124,124,124,124,
124,124,124,104,64,124,124,124,124,124,124,90,78,74,58,36,22,0,17,124,
124,124,124,124,124,120,118,98,92,80,74,44,28,4,14,14,2,52,52,48,
42,36,38,22,18,14,2,29,9,33,53,28,0,9,35,25,13,25,9,6,
15,25,1,6,6,6,14,8,6,124,108,88,70,54,32,14,17,51,7,78,
56,46,26,26,10,2,1,27,29,19,7,19,0,10,7,15,2,10,12,10,
20,18,8,124,108,88,70,54,32,14,17,51,0,0,0,0,124,16,25,124,
16,25,85,45,30,20,14,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
25,51,67,5,26,1,104,16,11,101,57,37,9,55,85,79,91,35,85,69,
81,93,85,93,85,18,5,17,61,7,47,37,81,19,57,43,97,20,29,13,
89,47,29,21,7,6,3,23,14,8,7,8,1,1,4,25,26,12,42,38,
34,36,34,32,46,24,16,46,36,17,69,49,55,35,43,33,17,29,27,27,
31,13,17,13,17,65,49,63,17,19,5,9,12,8,2,3,22,6,0,5,
2,35,90,86,64,72,86,70,38,72,60,30,44,30,10,2,5,32,20,26,
26,20,12,26,14,14,16,2,0,10,51,124,124,122,124,124,124,124,124,122,
104,100,96,78,68,32,94,80,44,104,82,86,76,66,60,64,42,24,10,12,
23,27,69,9,52,34,24,6,10,0,13,19,41,0,80,54,42,34,22,2,
13,17,29,39,40,22,12,2,1,13,21,35,67,49,11,13,9,15,25,45,
49,77,17,68,36,24,8,4,15,27,33,45,124,49,31,19,5,13,2,10,
12,15,8,16,8,29,15,13,24,14,32,26,48,50,38,24,36,36,30,11,
10,13,63,49,41,37,31,31,29,29,11,21,19,15,3,23,37,59,41,65,
25,13,13,5,9,3,2,1,3,7,3,0,7,31,92,80,84,80,74,86,
78,72,62,62,64,54,18,22,8,56,54,46,26,36,28,6,1,9,23,31,
55,23,73,124,124,124,124,124,112,106,96,92,84,78,66,52,22,7,90,88,
34,94,104,82,70,74,66,56,64,52,46,24,24,6,33,38,18,9,87,67,
73,25,33,29,24,11,11,9,8,50,26,62,3,118,114,96,82,54,48,7,
29,65,17,82,58,40,18,20,4,1,9,43,63,47,29,35,21,3,17,23,
3,2,4,2,12,18,6,116,112,100,86,78,66,34,12,27,0,0,0,0,
124,16,25,124,16,25,85,45,30,20,14,44,76,102,112,38,65,5,5,11,
16,14,7,4,20,54,66,38,5,49,59,51,19,5,11,16,19,33,22,28,
7,29,49,6,25,41,67,14,15,33,8,29,33,55,3,25,13,41,9,4,
44,0,0,0,25,51,67,5,26,1,78,14,35,67,27,39,4,15,41,31,
69,35,61,49,73,33,43,49,51,48,3,17,73,15,63,41,79,12,4,6,
7,26,9,9,35,59,35,37,35,13,29,57,47,13,67,45,9,21,51,57,
0,21,9,5,6,18,1,13,39,59,17,38,38,61,18,12,10,8,10,4,
3,0,4,16,10,4,2,4,9,9,10,5,32,50,50,34,20,38,24,32,
22,0,28,24,46,51,30,56,50,100,124,70,84,118,120,76,104,102,124,124,
72,86,64,82,108,86,116,124,124,70,64,102,76,124,14,124,124,124,124,124,
112,106,104,94,84,74,62,48,38,2,23,19,39,36,38,32,36,12,12,10,
34,5,15,9,35,21,89,61,8,16,20,2,9,19,27,31,75,43,54,28,
16,5,3,29,49,57,75,7,54,38,28,24,6,0,5,13,31,7,72,62,
48,16,20,3,19,39,18,108,96,86,64,48,6,11,11,23,124,93,85,63,
85,83,57,73,65,51,67,63,67,47,51,51,69,59,41,29,31,29,23,15,
7,7,2,11,11,21,0,2,3,2,2,2,4,10,2,0,2,12,3,11,
19,11,3,13,28,32,30,36,26,30,28,26,26,8,22,18,9,0,110,112,
106,112,112,124,122,124,124,124,124,124,122,100,60,124,124,124,124,124,118,86,
72,68,54,32,18,1,19,124,124,124,124,124,124,114,112,94,86,76,68,40,
24,2,12,12,1,50,48,44,38,32,34,18,16,12,0,31,11,35,55,26,
1,11,35,25,11,23,7,8,15,23,1,6,6,6,16,8,6,122,104,82,
64,48,24,4,25,57,7,78,56,46,26,26,10,2,1,25,29,19,5,19,
0,12,7,15,2,10,12,10,20,18,8,122,104,82,64,48,24,4,25,57,
0,0,0,0,124,16,25,124,16,25,81,43,30,20,14,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,23,51,67,5,24,1,104,16,11,99,55,37,
9,51,83,75,87,33,83,65,77,91,83,91,85,20,5,15,59,7,45,35,
77,19,57,43,93,22,27,13,87,47,29,21,5,8,1,21,14,8,7,6,
1,1,4,25,26,12,40,38,34,36,34,30,42,24,16,44,34,19,67,47,
53,33,41,31,15,27,27,25,29,13,17,11,19,63,47,63,15,19,5,9,
10,10,2,3,18,8,1,7,2,35,88,84,64,70,84,68,36,72,60,28,
42,30,10,2,5,32,20,24,26,18,10,26,12,10,14,0,1,8,51,122,
124,118,124,122,120,120,120,118,100,96,92,72,64,26,90,78,40,98,78,82,
72,60,56,58,38,20,8,10,27,27,69,9,52,36,24,6,10,0,13,19,
39,2,82,54,42,34,24,4,11,17,27,37,42,24,12,4,0,11,21,33,
65,49,7,13,9,13,23,43,49,75,15,70,38,24,8,6,13,25,31,43,
124,49,31,17,5,13,2,10,12,13,8,18,10,29,15,13,22,14,30,24,
46,50,38,22,34,34,30,13,8,15,61,49,39,37,29,31,27,27,11,21,
19,15,5,23,37,59,39,65,25,11,13,5,9,3,4,1,3,7,1,0,
9,31,90,80,84,80,72,84,76,70,62,60,62,52,16,20,6,54,50,42,
22,34,26,4,3,9,23,29,55,25,71,124,124,124,124,120,108,102,92,88,
80,74,62,48,20,9,86,84,32,90,100,78,66,70,62,52,60,48,42,20,
20,2,35,34,14,13,85,63,71,25,31,27,28,9,9,9,10,54,28,66,
3,116,110,92,76,50,42,11,33,67,17,82,58,40,18,20,4,1,9,41,
61,45,27,33,19,1,15,21,1,4,6,4,14,20,6,112,110,98,84,74,
62,30,8,29,0,0,0,0,124,16,25,124,16,25,81,43,30,20,14,42,
72,100,112,38,61,5,5,9,14,12,7,2,16,52,62,30,11,53,53,49,
17,5,9,14,19,31,22,28,7,27,47,6,25,41,67,14,15,33,8,29,
33,53,3,25,13,41,7,4,44,0,0,0,23,51,67,5,24,1,76,14,
35,63,25,37,8,11,37,29,67,31,57,47,67,33,41,49,49,48,3,15,
69,15,61,39,75,12,4,6,7,26,9,9,33,57,33,35,33,11,27,55,
43,11,63,43,0,13,45,51,2,19,7,3,6,18,1,13,37,55,17,34,
34,55,18,14,10,8,10,6,0,2,6,14,10,4,4,4,11,7,10,5,
30,48,48,32,18,38,24,32,20,2,26,24,44,51,30,54,48,96,124,68,
82,114,116,72,100,98,124,124,66,82,60,76,102,82,110,124,124,66,60,96,
72,124,12,124,124,124,122,120,108,102,100,90,78,70,58,46,34,1,23,19,
39,34,36,30,32,10,10,8,32,7,15,11,35,23,87,59,10,16,20,4,
9,17,25,29,71,39,54,30,16,5,1,27,45,53,71,7,56,40,30,26,
8,0,3,11,29,7,74,62,48,14,20,3,19,37,18,108,94,84,62,48,
6,9,11,21,124,89,83,59,81,79,55,71,63,49,63,61,63,45,49,49,
67,55,41,29,29,27,21,15,9,7,0,11,11,21,0,2,1,2,2,2,
4,10,2,0,2,10,3,11,19,11,1,15,26,32,28,36,26,28,28,26,
24,8,22,16,9,1,108,110,104,108,108,124,118,122,124,118,124,124,116,94,
56,124,124,124,124,118,112,80,68,64,50,30,16,1,19,124,124,124,124,118,
118,110,106,90,82,72,62,36,20,1,12,12,5,48,46,42,34,28,30,16,
14,8,1,31,15,37,55,22,5,15,33,25,9,23,5,10,13,21,0,8,
6,8,18,8,6,120,100,76,58,40,16,3,33,63,5,78,56,46,26,28,
10,4,0,25,29,19,5,19,2,14,7,15,4,12,12,12,22,18,8,120,
100,76,58,40,16,3,33,63,0,0,0,0,122,16,25,122,16,25,77,39,
32,20,12,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,23,51,67,3,
22,1,104,16,11,97,53,37,7,49,79,71,85,31,79,63,73,89,81,89,
83,22,5,13,57,7,45,35,73,19,55,41,91,22,27,11,83,45,27,21,
5,8,1,19,16,10,9,6,1,1,4,25,26,10,40,38,32,36,34,30,
38,24,14,40,32,21,65,45,51,31,39,31,13,27,25,23,27,13,17,11,
21,63,45,63,15,19,3,9,8,12,2,3,16,10,1,9,2,37,84,82,
62,68,82,66,36,70,58,26,40,30,10,2,7,30,18,22,24,16,8,24,
12,6,12,0,3,6,51,120,122,116,124,118,116,116,116,112,94,92,86,68,
58,22,86,74,38,94,74,76,66,56,50,54,34,14,6,6,29,29,69,9,
54,36,24,6,10,0,13,19,39,2,82,54,42,34,26,4,11,15,27,35,
44,24,14,4,2,11,19,33,63,47,5,11,7,13,21,41,47,73,15,70,
38,24,8,8,13,23,29,41,124,47,29,17,5,13,2,10,12,13,8,18,
10,29,15,13,22,16,28,22,44,48,38,20,32,34,30,13,6,15,59,47,
37,35,29,29,27,25,11,21,19,13,5,23,37,57,37,65,25,11,13,3,
9,3,6,1,3,7,0,1,9,33,88,78,82,78,70,82,74,68,60,58,
60,50,14,18,4,50,48,40,18,30,24,2,3,11,23,29,55,25,69,124,
124,122,122,114,104,98,86,84,76,70,56,44,16,11,82,82,28,86,96,74,
62,66,58,48,56,44,36,16,16,1,37,30,10,15,83,61,69,23,29,25,
30,7,7,9,12,56,32,68,1,112,108,86,70,44,36,17,37,69,17,82,
58,40,18,20,4,1,9,41,59,43,25,31,17,1,15,19,1,4,6,4,
14,20,6,110,106,94,80,70,58,26,4,31,0,0,0,0,122,16,25,122,
16,25,77,39,32,20,12,38,68,98,112,38,57,5,3,7,14,12,7,2,
14,50,56,24,15,55,47,47,17,3,7,14,21,29,22,26,7,27,47,6,
25,41,67,14,15,31,8,29,31,53,3,25,13,41,7,4,44,0,0,0,
23,51,67,3,22,1,74,12,35,57,23,35,10,7,35,25,63,29,55,45,
63,33,41,47,49,48,3,13,65,15,59,39,71,12,2,4,9,26,9,7,
33,55,31,35,31,11,25,51,41,11,61,41,10,3,39,45,2,19,7,3,
6,18,0,11,37,51,17,30,30,49,18,14,10,8,10,6,2,4,6,14,
10,4,4,6,13,7,10,7,30,46,48,32,18,38,24,32,18,2,24,22,
44,51,30,54,48,92,122,66,78,110,110,68,94,94,124,124,58,78,56,72,
96,76,104,122,124,60,56,88,68,124,8,120,124,120,116,114,104,98,96,86,
74,66,54,42,32,5,23,19,41,32,34,28,30,8,8,6,28,9,17,13,
37,23,87,55,12,18,20,4,7,17,25,29,67,37,54,30,18,3,0,25,
43,51,67,5,56,40,30,26,10,2,3,11,29,7,74,62,46,14,20,3,
19,37,18,106,94,82,60,48,6,9,11,21,124,87,79,57,79,77,53,67,
59,47,61,57,59,45,47,49,65,51,39,29,29,27,21,15,9,7,0,11,
11,23,2,4,0,2,2,4,4,10,2,0,2,10,3,11,19,11,1,17,
24,32,26,34,24,28,28,24,22,8,22,14,9,3,106,108,102,106,104,120,
114,118,118,114,124,120,110,90,52,124,124,124,124,110,106,76,64,58,46,26,
12,3,21,124,124,124,120,112,114,104,100,84,76,66,56,32,16,3,10,10,
7,44,42,38,30,26,26,12,12,6,3,33,17,39,57,20,7,17,33,23,
9,21,3,12,13,21,0,8,6,8,20,8,6,118,96,72,52,34,8,11,
41,69,5,78,56,46,26,28,12,4,0,23,29,19,3,17,4,16,7,13,
4,12,12,12,22,18,8,118,96,72,52,34,8,11,41,69,0,0,0,0,
120,16,25,120,16,25,73,37,32,20,12,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,21,51,67,3,20,1,104,16,11,95,51,37,7,47,75,67,
81,29,75,61,69,87,79,87,81,24,5,11,55,7,43,33,69,19,55,41,
89,22,27,11,81,45,25,21,5,8,1,17,16,10,9,6,1,1,4,25,
26,10,38,38,30,36,34,30,34,24,14,36,30,23,63,43,49,29,37,29,
11,25,25,21,25,13,17,11,23,61,43,63,15,19,1,9,6,14,2,3,
14,12,3,11,2,39,82,80,62,66,80,64,34,68,58,24,38,30,10,2,
7,28,16,20,22,14,6,22,10,2,10,1,5,4,51,116,120,112,120,114,
112,112,112,108,90,88,82,62,54,16,82,70,34,90,70,72,62,52,46,48,
30,10,4,2,31,31,69,9,54,36,24,6,10,0,13,19,37,2,82,54,
42,34,28,6,9,15,25,33,46,26,14,4,4,9,19,31,61,45,3,9,
7,13,19,39,45,71,13,70,38,24,8,10,11,21,27,39,124,47,29,15,
5,13,2,10,12,13,8,18,12,29,15,13,20,16,26,20,42,46,38,18,
30,34,30,15,4,17,57,45,35,35,27,29,25,23,11,21,19,13,7,23,
37,57,35,65,25,11,13,1,9,3,8,1,3,7,2,3,9,35,86,78,
82,76,68,80,72,66,58,56,58,48,12,16,2,48,46,36,14,28,22,0,
5,11,23,29,55,27,67,124,124,118,118,108,100,94,82,80,72,66,52,40,
14,13,78,78,26,82,92,70,58,62,54,44,52,40,32,12,12,5,39,26,
6,19,81,59,67,21,27,23,34,5,5,9,14,60,34,72,0,110,104,82,
64,38,30,23,41,71,17,82,58,40,18,20,4,1,9,39,57,41,23,29,
15,0,13,17,0,6,8,4,16,20,6,108,104,90,76,66,54,22,0,33,
0,0,0,0,120,16,25,120,16,25,73,37,32,20,12,36,64,96,112,38,
53,5,3,5,14,10,7,0,10,48,52,16,21,59,41,45,17,3,5,14,
21,27,22,26,7,27,45,6,25,41,67,14,15,31,8,29,31,53,3,25,
13,41,7,4,44,0,0,0,21,51,67,3,20,1,72,12,35,53,21,33,
14,3,31,23,59,25,53,43,59,33,41,47,49,48,3,11,61,15,57,37,
67,12,2,4,9,26,9,7,31,53,29,33,29,9,23,49,37,9,59,39,
20,4,33,39,2,19,7,1,6,18,0,11,35,47,17,26,26,43,18,14,
10,8,10,8,6,6,6,14,10,4,6,8,15,7,10,7,28,44,46,32,
16,38,24,32,16,2,22,20,42,51,30,52,46,88,116,64,74,106,106,64,
90,90,124,124,52,74,52,68,90,72,98,114,124,54,52,82,64,124,4,116,
124,116,112,110,100,94,92,82,70,62,50,38,28,9,23,19,41,30,32,26,
28,6,6,4,24,11,17,15,39,25,85,53,14,18,20,4,5,15,23,27,
63,35,54,30,18,1,2,23,39,47,63,3,58,42,32,28,12,2,3,11,
27,7,76,62,44,14,20,3,19,35,18,106,92,80,58,48,6,9,11,21,
124,85,77,55,75,73,51,63,55,45,57,53,55,43,45,47,63,47,39,29,
29,25,19,15,9,7,1,11,11,23,2,4,2,2,2,4,4,10,2,0,
2,8,3,11,19,11,0,19,22,32,24,32,22,26,28,22,20,8,22,12,
9,5,104,106,100,102,100,116,110,114,114,108,122,114,104,84,48,124,124,124,
124,104,100,70,60,54,42,22,10,5,23,124,124,124,116,106,108,100,94,80,
72,62,50,28,12,7,8,8,11,42,40,34,26,22,22,8,10,2,5,35,
19,41,59,16,9,19,33,23,7,21,1,14,13,19,2,10,6,10,22,8,
6,116,92,66,46,28,0,19,49,75,5,78,56,46,26,30,12,4,0,23,
29,19,3,17,6,18,7,13,4,12,12,12,24,18,8,116,92,66,46,28,
0,19,49,75,0,0,0,0,116,14,27,116,14,27,71,35,32,20,10,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,21,53,67,3,18,3,104,14,
11,93,51,37,7,45,73,65,79,27,73,59,67,85,79,85,81,24,5,11,
55,7,43,33,67,19,55,41,87,22,27,11,79,45,25,21,5,8,1,17,
16,10,11,4,1,3,4,25,24,8,36,38,28,34,34,28,30,22,12,32,
28,25,63,43,49,29,37,29,9,25,25,21,23,15,17,11,27,61,43,63,
15,21,1,9,4,14,2,3,10,12,5,13,2,41,78,78,60,64,78,62,
32,66,56,20,36,28,8,2,9,26,14,18,20,12,4,20,8,1,6,3,
9,0,51,112,116,108,116,110,106,106,106,102,84,82,76,56,48,10,78,66,
30,84,64,66,56,46,40,42,24,4,2,1,35,33,71,9,54,36,24,6,
10,1,13,19,37,2,82,54,42,34,30,6,9,15,25,33,46,26,14,4,
4,9,19,31,59,45,1,9,7,13,19,39,45,69,13,70,38,24,8,10,
11,21,27,39,124,47,29,15,5,13,2,10,12,13,8,18,12,29,15,15,
18,16,24,18,40,44,36,14,26,32,28,17,0,19,57,45,33,35,27,29,
25,23,13,21,19,13,9,23,37,57,35,67,25,11,13,1,11,3,8,3,
5,7,2,5,11,37,84,76,80,74,64,78,70,64,56,54,56,46,10,12,
1,44,42,32,10,24,18,1,7,13,23,29,55,29,67,124,122,114,112,102,
94,88,76,74,66,60,46,34,10,15,74,74,22,78,86,64,52,56,48,40,
46,34,26,8,6,9,43,22,2,23,79,57,65,21,27,23,36,5,5,9,
14,62,36,74,0,106,100,76,56,32,24,29,47,75,17,82,56,38,18,20,
4,3,9,39,57,41,23,29,13,0,13,17,0,6,8,4,16,20,4,104,
100,86,72,62,50,16,3,35,0,0,0,0,116,14,27,116,14,27,71,35,
32,20,10,32,58,94,112,36,51,7,3,5,12,8,7,1,6,44,46,8,
27,63,37,45,17,3,5,12,23,27,22,24,7,27,45,4,27,41,67,12,
15,31,8,29,31,53,3,25,15,41,7,4,44,0,0,0,21,53,67,3,
18,3,70,10,37,49,19,31,16,0,29,21,57,23,51,41,55,33,41,47,
49,48,3,11,57,15,57,37,65,10,0,2,11,26,9,7,31,53,29,33,
29,9,23,47,35,9,57,37,28,12,27,35,2,19,7,1,4,18,0,11,
35,43,17,22,22,39,18,14,10,8,10,8,8,6,6,12,8,4,6,8,
19,7,10,9,26,40,44,30,14,38,24,30,12,2,20,18,40,51,28,50,
44,82,108,60,70,100,100,58,84,86,110,124,44,68,48,62,82,66,90,104,
118,48,48,74,60,124,0,110,118,110,106,104,94,88,86,78,64,56,46,34,
24,13,23,21,43,28,28,22,24,2,2,0,20,13,19,17,41,27,85,51,
14,18,20,4,5,15,23,27,59,33,54,30,18,1,2,21,37,45,61,3,
58,42,32,28,14,2,3,11,27,9,76,60,42,12,20,3,19,35,16,104,
90,76,56,46,6,9,11,21,124,83,75,53,73,71,49,61,53,43,55,51,
51,43,45,47,61,45,39,29,29,25,19,15,11,9,3,11,13,25,2,4,
4,2,0,4,4,8,2,0,2,6,3,11,19,11,0,21,20,32,20,30,
20,24,26,20,18,8,20,8,11,9,100,102,98,98,96,110,104,108,108,102,
116,108,96,78,44,124,124,122,120,96,92,64,54,48,38,18,6,7,25,118,
120,120,110,100,102,94,86,74,66,56,44,24,8,11,6,6,15,38,36,30,
20,18,18,4,6,1,9,37,23,43,61,12,13,23,33,23,7,21,0,16,
13,19,2,10,6,10,22,8,4,112,88,60,38,20,7,29,59,81,5,78,
56,46,26,30,12,4,0,23,29,19,3,17,6,18,7,13,4,12,12,12,
24,16,6,112,88,60,38,20,7,29,59,81,0,0,0,0,114,14,27,114,
14,27,67,31,34,22,10,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
19,53,67,1,18,3,104,14,11,89,49,37,5,41,69,61,75,23,69,55,
63,81,77,83,79,26,3,9,53,5,41,31,63,17,53,39,83,24,25,9,
75,43,23,19,3,10,0,15,18,12,11,4,0,3,4,23,24,8,36,38,
28,34,34,28,28,22,12,30,26,25,61,41,47,27,35,27,7,23,23,19,
19,15,17,9,29,59,41,63,13,21,0,7,4,16,2,3,8,14,5,15,
2,41,76,78,60,64,78,62,32,66,56,18,36,28,8,2,9,26,14,18,
20,12,2,20,8,3,4,3,11,1,51,110,114,106,114,108,102,102,102,98,
80,78,72,52,44,6,76,64,28,80,60,62,52,42,36,38,20,0,2,3,
37,33,71,7,56,38,26,8,10,1,11,17,35,4,84,56,44,34,32,8,
7,13,23,31,48,28,16,6,6,7,17,29,55,43,2,7,5,11,17,37,
43,65,11,72,40,26,10,12,9,19,25,37,124,45,27,13,5,11,2,12,
14,11,10,20,14,27,15,15,18,18,24,18,38,44,36,12,24,32,28,17,
1,19,55,43,31,33,25,27,23,21,13,19,17,11,9,21,35,55,33,67,
25,9,13,0,11,3,10,3,5,5,4,5,11,37,84,76,80,74,62,78,
70,64,56,54,56,46,10,10,3,42,40,30,8,22,16,1,7,13,21,27,
53,29,65,120,118,110,108,98,90,84,72,70,62,56,42,30,8,15,72,72,
20,76,82,60,48,52,44,36,42,30,22,6,2,11,45,20,0,25,75,53,
61,19,25,21,40,3,3,9,16,66,40,78,2,104,98,72,50,28,20,33,
51,77,15,84,56,38,18,22,4,3,9,37,55,39,21,27,9,2,11,15,
2,8,10,6,18,22,4,102,98,84,70,60,48,12,5,35,0,0,0,0,
114,14,27,114,14,27,67,31,34,22,10,30,54,92,114,36,47,7,1,3,
12,8,5,1,4,42,42,2,31,65,31,43,15,1,3,12,23,25,22,24,
5,25,43,4,27,39,65,12,13,29,8,27,29,51,1,23,15,39,5,4,
44,0,0,0,19,53,67,1,18,3,70,10,37,43,15,27,20,6,25,17,
53,19,47,37,49,33,39,45,47,48,3,9,51,13,55,35,61,10,0,2,
11,28,9,5,29,51,27,31,27,7,21,43,31,7,53,33,38,22,19,29,
4,17,5,0,4,20,2,9,33,37,15,18,20,33,18,16,10,10,12,10,
12,8,8,12,8,4,8,10,21,5,10,9,26,38,44,30,14,38,24,30,
10,4,20,18,40,51,28,50,44,78,102,58,68,96,96,54,80,82,98,124,
38,64,46,58,76,62,84,96,110,44,44,68,56,124,1,106,114,106,102,100,
90,84,82,74,60,52,44,32,22,15,23,21,43,28,26,20,22,0,0,1,
18,15,19,19,41,27,83,47,16,20,20,6,3,13,21,25,53,29,56,32,
20,0,4,17,33,41,57,1,60,44,34,30,16,4,1,9,25,9,78,60,
42,12,22,1,19,33,16,104,90,74,54,46,8,7,9,19,124,79,71,49,
69,67,45,57,49,39,51,47,45,41,43,45,57,41,37,27,27,23,17,13,
11,9,3,11,13,25,4,6,6,4,0,6,6,8,4,2,2,6,1,9,
17,9,2,21,18,32,18,30,20,24,26,20,18,8,20,6,11,11,98,100,
98,96,94,106,100,104,104,98,112,104,90,74,40,122,120,114,112,90,86,60,
50,44,36,16,4,7,25,114,116,116,106,96,98,90,80,70,62,52,40,22,
6,13,6,6,17,36,34,28,16,16,16,2,4,3,11,37,25,43,61,10,
15,25,31,21,5,19,4,20,11,17,4,12,8,12,24,8,4,110,84,56,
32,14,15,37,67,85,3,78,58,48,28,32,14,6,2,21,27,17,1,15,
8,20,5,11,6,14,12,14,26,16,6,110,84,56,32,14,15,37,67,85,
0,0,0,0,112,14,27,112,14,27,63,29,34,22,10,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,17,53,67,1,16,3,104,14,11,87,47,37,
5,39,65,57,73,21,65,53,59,79,75,81,77,28,3,7,51,5,41,29,
59,17,53,39,81,24,25,9,73,43,21,19,3,10,0,13,18,12,13,4,
0,3,4,23,24,8,34,38,26,34,34,28,24,22,12,26,24,27,59,39,
45,25,33,25,5,21,23,17,17,15,17,9,31,59,39,63,13,21,2,7,
2,18,2,3,6,16,7,17,2,43,72,76,58,62,76,60,30,64,56,16,
34,28,8,2,9,24,12,16,18,10,0,18,6,7,2,5,13,3,51,106,
112,102,110,104,98,98,98,92,76,74,66,46,40,0,72,60,24,76,56,58,
48,38,32,32,16,3,0,7,39,35,71,7,56,38,26,8,10,1,11,17,
33,4,84,56,44,34,34,8,5,13,21,29,50,30,16,6,8,7,17,27,
53,41,4,5,5,11,15,35,41,63,11,72,40,26,10,14,7,17,23,35,
124,45,27,13,5,11,2,12,14,11,10,20,16,27,15,15,16,18,22,16,
36,42,36,10,22,32,28,19,3,21,53,41,29,33,25,27,21,19,13,19,
17,11,11,21,35,55,31,67,25,9,13,2,11,3,12,3,5,5,6,7,
11,39,82,76,80,72,60,76,68,62,54,52,54,44,8,8,5,38,38,26,
4,20,14,3,9,13,21,27,53,31,63,116,114,106,104,92,86,80,66,66,
58,52,38,26,6,17,68,68,18,72,78,56,44,48,40,32,38,26,18,2,
1,15,47,16,3,29,73,51,59,17,23,19,44,1,1,9,18,68,42,80,
4,102,94,66,44,22,14,39,55,79,15,84,56,38,18,22,4,3,9,35,
53,37,19,25,7,4,9,13,4,10,12,6,20,22,4,100,94,80,66,56,
44,8,9,37,0,0,0,0,112,14,27,112,14,27,63,29,34,22,10,28,
50,90,114,36,43,7,1,1,12,6,5,3,0,40,36,5,37,69,25,41,
15,1,1,12,23,23,22,22,5,25,41,4,27,39,65,12,13,29,8,27,
29,51,1,23,15,39,5,4,44,0,0,0,17,53,67,1,16,3,68,10,
37,39,13,25,24,10,23,15,49,17,45,35,45,33,39,45,47,48,3,7,
47,13,53,33,57,10,0,2,13,28,9,5,27,49,25,29,25,7,19,41,
29,5,51,31,48,30,13,23,4,17,5,0,4,20,2,9,33,33,15,14,
16,27,18,16,10,10,12,10,16,10,8,12,8,4,10,12,23,5,10,9,
24,36,42,30,12,38,24,30,8,4,18,16,38,51,28,48,42,74,96,56,
64,92,92,50,76,78,86,124,30,60,42,54,70,58,78,88,102,38,40,62,
52,124,5,102,110,102,98,96,86,80,78,70,56,48,40,28,18,19,23,21,
45,26,24,18,20,1,1,3,14,17,19,21,43,29,81,45,18,20,20,6,
1,11,19,23,49,27,56,32,20,2,6,15,29,37,53,0,62,46,36,32,
18,4,1,9,23,9,80,60,40,12,22,1,19,33,16,104,88,72,52,46,
8,7,9,19,124,77,69,47,65,63,43,53,45,37,47,43,41,39,41,45,
55,37,37,27,27,21,17,13,11,9,5,11,13,25,4,6,8,4,0,6,
6,8,4,2,2,4,1,9,17,9,4,23,16,32,16,28,18,22,26,18,
16,8,20,4,11,13,96,98,96,92,90,102,96,100,100,92,106,98,84,68,
36,114,112,106,102,84,80,54,46,38,32,12,2,9,27,110,112,110,102,90,
92,84,74,66,56,48,34,18,2,17,4,4,21,34,32,24,12,12,12,1,
2,7,13,39,27,45,63,6,17,27,31,21,3,19,6,22,11,15,6,14,
8,12,26,8,4,108,80,50,26,8,23,45,75,91,3,78,58,48,28,34,
14,6,2,21,27,17,1,15,10,22,5,11,6,14,12,14,28,16,6,108,
80,50,26,8,23,45,75,91,0,0,0,0,110,14,27,110,14,27,59,25,
36,22,8,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,17,53,67,0,
14,3,104,14,11,85,45,37,3,37,61,53,69,19,61,51,55,77,73,79,
75,30,3,5,49,5,39,29,55,17,51,37,79,24,25,7,69,41,19,19,
3,10,0,11,20,14,13,4,0,3,4,23,24,6,34,38,24,34,34,28,
20,22,10,22,22,29,57,37,43,23,31,25,3,21,21,15,15,15,17,9,
33,57,37,63,13,21,4,7,0,20,2,3,4,18,7,19,2,45,70,74,
58,60,74,58,30,62,54,14,32,28,8,2,11,22,10,14,16,8,1,16,
6,11,0,5,15,5,51,104,108,100,106,100,94,94,94,88,70,70,62,42,
34,3,68,56,22,72,52,52,42,34,26,28,12,9,1,11,41,37,71,7,
58,38,26,8,10,1,11,17,33,4,84,56,44,34,36,10,5,11,21,27,
52,30,18,6,10,5,15,27,51,39,6,3,3,11,13,33,39,61,9,72,
40,26,10,16,7,15,21,33,124,43,25,11,5,11,2,12,14,11,10,20,
16,27,15,15,16,20,20,14,34,40,36,8,20,32,28,19,5,21,51,39,
27,31,23,25,21,17,13,19,17,9,11,21,35,53,29,67,25,9,13,4,
11,3,14,3,5,5,8,9,11,41,80,74,78,70,58,74,66,60,52,50,
52,42,6,6,7,36,36,24,0,16,12,5,9,15,21,27,53,31,61,112,
110,102,100,86,82,76,62,62,54,48,32,22,2,19,64,66,14,68,74,52,
40,44,36,28,34,22,12,1,5,19,49,12,7,31,71,49,57,15,21,17,
46,0,0,9,20,72,46,84,6,98,92,62,38,16,8,45,59,81,15,84,
56,38,18,22,4,3,9,35,51,35,17,23,5,4,9,11,4,10,12,6,
20,22,4,98,92,76,62,52,40,4,13,39,0,0,0,0,110,14,27,110,
14,27,59,25,36,22,8,24,46,88,114,36,39,7,0,0,12,6,5,3,
1,38,32,11,41,71,19,39,15,0,0,12,25,21,22,22,5,25,41,4,
27,39,65,12,13,27,8,27,27,51,1,23,15,39,5,4,44,0,0,0,
17,53,67,0,14,3,66,8,37,33,11,23,26,14,19,11,45,13,43,33,
41,33,39,43,47,48,3,5,43,13,51,33,53,10,1,0,13,28,9,3,
27,47,23,29,23,5,17,37,25,5,49,29,58,40,7,17,4,17,5,2,
4,20,4,7,31,29,15,10,12,21,18,16,10,10,12,12,18,12,8,12,
8,4,10,14,25,5,10,11,24,34,42,30,12,38,24,30,6,4,16,14,
38,51,28,48,42,70,90,54,60,88,86,46,70,74,72,124,24,56,38,50,
64,52,72,80,94,32,36,54,48,124,9,98,106,98,92,90,82,76,74,66,
52,44,36,24,16,23,23,21,45,24,22,16,18,3,3,5,10,19,21,23,
45,29,81,41,20,22,20,6,0,11,19,23,45,25,56,32,22,4,8,13,
27,35,49,2,62,46,36,32,20,6,1,9,23,9,80,60,38,12,22,1,
19,31,16,102,88,70,50,46,8,7,9,19,124,75,65,45,63,61,41,49,
41,35,45,39,37,39,39,43,53,33,35,27,27,21,15,13,11,9,5,11,
13,27,6,8,10,4,0,8,6,8,4,2,2,4,1,9,17,9,4,25,
14,32,14,26,16,22,26,16,14,8,20,2,11,15,94,96,94,90,86,98,
92,96,94,88,100,92,78,64,32,106,104,98,92,76,74,50,42,34,28,8,
1,11,29,106,106,106,96,84,88,80,68,60,52,42,28,14,1,19,2,2,
23,30,28,20,8,10,8,5,0,9,15,41,29,47,65,4,19,29,31,19,
3,17,8,24,11,15,6,14,8,14,28,8,4,106,76,46,20,2,31,53,
83,97,3,78,58,48,28,34,16,6,2,19,27,17,0,13,12,24,5,9,
6,14,12,14,28,16,6,106,76,46,20,2,31,53,83,97,0,0,0,0,
106,14,27,106,14,27,57,23,36,22,8,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,15,55,67,0,12,3,104,14,11,83,43,37,3,33,59,49,
67,17,59,47,51,75,73,77,75,30,3,3,47,5,39,27,51,17,51,37,
77,24,23,7,67,41,19,19,1,10,0,11,20,14,15,2,0,3,4,23,
24,6,32,38,24,34,34,26,16,22,10,18,20,31,55,35,41,21,31,23,
1,19,21,13,13,15,17,7,35,57,35,63,13,21,4,7,1,22,2,3,
0,20,9,21,2,47,66,72,56,58,72,56,28,60,54,10,30,26,8,2,
11,20,10,12,16,6,3,14,4,15,1,7,17,7,51,100,106,96,102,96,
90,88,90,82,66,66,56,36,30,9,64,54,18,66,48,48,38,28,22,22,
8,13,3,13,45,39,71,7,58,40,26,8,10,1,11,17,31,6,86,56,
44,34,38,10,3,11,19,27,54,32,18,6,10,5,15,25,49,39,8,3,
3,11,11,31,39,59,9,74,40,26,10,18,5,15,19,31,124,43,25,11,
5,11,2,12,14,9,10,20,18,27,15,15,14,20,18,12,32,38,36,4,
18,30,28,21,7,23,51,39,25,31,23,25,19,15,15,19,17,9,13,21,
35,53,27,67,25,7,13,4,11,3,16,3,7,5,10,9,13,43,78,74,
78,68,56,72,64,58,50,48,50,40,4,4,9,32,32,20,3,14,10,7,
11,15,21,27,53,33,61,106,104,98,94,80,78,72,56,58,50,44,28,18,
0,21,60,62,12,64,70,48,36,38,32,24,30,18,8,5,9,23,51,8,
11,35,69,47,55,15,19,15,50,2,2,9,22,74,48,86,6,96,88,56,
32,10,2,51,63,83,15,84,56,38,18,22,4,3,9,33,49,33,15,23,
3,6,7,9,6,12,14,8,22,24,4,94,88,72,58,48,36,0,17,41,
0,0,0,0,106,14,27,106,14,27,57,23,36,22,8,22,42,86,114,34,
35,7,0,2,10,4,5,5,5,36,26,19,47,75,13,37,15,0,2,10,
25,19,22,20,5,23,39,4,27,39,65,12,13,27,8,27,27,49,1,23,
15,39,3,4,44,0,0,0,15,55,67,0,12,3,64,8,37,29,9,21,
30,18,17,9,43,11,39,31,37,33,37,43,47,48,3,3,39,13,51,31,
49,10,1,0,15,28,9,3,25,45,21,27,21,5,17,35,23,3,47,27,
68,48,1,11,4,15,5,2,4,20,4,7,31,25,15,6,8,17,18,18,
10,10,12,12,22,14,10,10,8,4,12,14,27,5,10,11,22,32,40,28,
10,38,24,30,4,4,14,12,36,51,26,46,40,66,82,52,56,84,82,42,
66,70,60,124,16,52,34,44,58,48,64,70,86,26,32,48,44,124,11,94,
102,92,88,86,78,72,70,62,46,40,32,20,12,27,23,21,47,22,20,14,
14,5,7,7,8,21,21,25,45,31,79,39,22,22,20,8,0,9,17,21,
41,21,56,34,22,4,10,11,23,31,47,2,64,48,38,34,22,6,1,7,
21,9,82,60,38,10,22,1,19,31,16,102,86,68,48,46,8,5,9,19,
124,71,63,43,59,57,39,47,39,33,41,37,33,37,37,43,51,31,35,27,
27,19,15,13,13,9,7,11,13,27,6,8,12,4,0,8,6,8,4,2,
2,2,1,9,17,9,6,27,12,32,12,26,14,20,26,14,12,8,20,0,
11,17,92,94,92,86,82,94,88,90,90,82,94,86,72,58,28,96,96,90,
82,70,66,44,36,28,24,4,3,13,29,100,102,100,92,78,82,74,62,56,
46,38,22,10,5,23,0,2,27,28,26,18,4,6,4,7,1,13,17,43,
33,49,65,0,23,33,29,19,1,17,10,26,11,13,8,16,8,14,30,8,
4,104,72,40,14,5,39,63,91,103,1,78,58,48,28,36,16,6,2,19,
27,17,0,13,12,26,5,9,8,16,12,14,30,16,6,104,72,40,14,5,
39,63,91,103,0,0,0,0,104,14,27,104,14,27,53,19,36,22,6,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,15,55,67,2,10,3,104,14,
11,81,41,37,1,31,55,45,63,15,55,45,47,73,71,75,73,32,3,1,
45,5,37,25,47,17,51,35,73,26,23,5,65,39,17,19,1,12,2,9,
22,16,15,2,0,3,4,23,24,4,30,38,22,34,34,26,12,22,8,16,
18,33,53,33,39,19,29,21,0,17,19,11,11,15,17,7,37,55,33,63,
11,21,6,7,3,24,2,3,1,22,9,23,2,47,64,70,56,56,70,54,
26,60,54,8,28,26,8,2,13,20,8,10,14,4,5,14,2,19,3,9,
19,9,51,96,104,92,98,94,86,84,86,78,62,62,52,32,26,13,60,50,
14,62,44,44,34,24,18,16,4,19,5,17,47,39,71,7,58,40,26,8,
10,1,11,17,31,6,86,56,44,34,40,12,1,11,17,25,56,34,18,8,
12,3,13,25,47,37,12,1,3,9,9,29,37,57,7,74,42,26,10,20,
3,13,17,29,124,43,25,9,5,11,2,12,14,9,10,22,18,27,15,15,
12,22,16,10,30,38,36,2,16,30,28,23,9,23,49,37,23,29,21,23,
19,13,15,19,17,9,15,21,35,51,25,67,25,7,13,6,11,3,18,3,
7,5,12,11,13,43,76,74,76,68,54,70,62,56,50,46,48,38,2,2,
11,30,30,18,7,12,8,9,13,17,21,25,53,33,59,102,100,94,90,76,
74,68,52,54,46,40,24,14,3,23,56,58,10,60,66,44,32,34,28,20,
26,14,2,9,13,27,53,4,15,37,67,43,53,13,17,13,54,4,4,9,
24,78,52,90,8,92,84,52,26,6,3,55,67,85,15,84,56,38,18,22,
4,3,9,33,47,31,13,21,1,8,7,7,8,14,16,8,22,24,4,92,
86,70,56,44,32,3,21,43,0,0,0,0,104,14,27,104,14,27,53,19,
36,22,6,20,38,84,114,34,31,7,0,4,10,4,5,7,9,34,22,25,
51,79,7,35,13,0,4,10,25,17,22,20,5,23,37,4,27,39,65,12,
13,27,8,27,25,49,1,23,15,39,3,4,44,0,0,0,15,55,67,2,
10,3,62,6,37,23,7,19,34,22,13,5,39,7,37,29,31,33,37,41,
45,48,3,1,35,13,49,31,45,10,3,1,15,28,9,1,25,43,19,27,
19,3,15,31,19,1,43,25,78,56,4,5,6,15,3,4,4,20,6,7,
29,21,15,2,4,11,18,18,10,10,12,14,24,16,10,10,8,4,12,16,
29,3,10,13,22,30,40,28,10,38,24,30,2,6,12,12,36,51,26,44,
38,62,76,50,54,80,78,38,60,66,48,124,10,48,30,40,52,42,58,62,
78,22,28,40,40,124,15,90,98,88,84,82,74,68,66,58,42,36,28,18,
8,31,23,21,47,20,18,12,12,7,9,9,4,23,23,27,47,33,77,35,
24,24,20,8,2,9,17,19,37,19,56,34,24,6,12,9,21,29,43,4,
66,50,40,34,24,8,0,7,21,9,82,60,36,10,22,1,19,29,16,100,
84,66,46,46,8,5,9,17,124,69,59,39,55,55,37,43,35,31,37,33,
29,35,35,41,49,27,35,27,25,19,13,13,13,9,7,11,13,29,8,8,
14,4,0,8,6,8,4,2,2,2,1,9,17,9,6,29,10,32,10,24,
14,18,26,14,10,8,20,1,11,19,90,92,90,82,78,90,84,86,84,76,
88,80,66,54,24,88,88,82,72,64,60,40,32,24,20,2,7,13,31,96,
96,96,88,72,76,70,56,52,42,34,16,6,9,25,0,0,31,26,22,14,
0,2,0,11,3,15,19,43,35,51,67,1,25,35,29,19,0,15,12,28,
9,11,8,16,8,16,32,8,4,102,68,34,8,11,47,71,99,109,1,78,
58,48,28,36,16,8,4,17,27,17,2,13,14,28,5,9,8,16,12,16,
30,16,6,102,68,34,8,11,47,71,99,109,0,0,0,0,102,14,29,102,
14,29,49,17,38,22,6,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
13,55,67,2,10,5,104,14,11,79,41,37,1,29,51,41,61,13,51,43,
43,71,69,73,71,34,3,0,45,3,37,25,43,17,49,35,71,26,23,5,
61,39,15,17,1,12,2,7,22,16,17,2,0,3,4,23,24,4,30,38,
20,34,34,26,8,22,8,12,16,35,53,31,39,19,27,21,2,17,19,11,
7,15,17,7,39,55,31,63,11,21,8,5,5,24,2,3,3,24,11,25,
2,49,60,68,54,56,68,54,26,58,52,6,26,26,8,2,13,18,6,8,
12,4,7,12,2,23,5,9,21,11,51,94,100,90,94,90,82,80,82,72,
56,58,46,26,20,19,56,46,12,58,38,38,28,20,12,12,1,23,7,21,
49,41,71,5,60,40,28,8,10,1,11,17,29,6,86,58,44,34,42,12,
1,9,17,23,58,34,20,8,14,3,13,23,45,35,14,0,1,9,9,29,
35,53,7,74,42,26,12,20,3,11,17,27,124,41,23,9,5,11,2,12,
14,9,12,22,20,27,15,17,12,22,14,8,28,36,36,0,14,30,28,23,
11,25,47,35,21,29,21,23,17,13,15,17,15,7,15,21,35,51,23,67,
25,7,13,8,11,3,20,5,7,5,12,13,13,45,74,72,76,66,52,70,
62,54,48,46,46,36,0,0,13,26,28,14,11,8,4,11,13,17,21,25,
51,35,57,98,96,90,86,70,70,64,46,50,40,36,18,10,5,23,54,56,
6,56,60,40,28,30,24,16,20,10,1,13,17,29,57,0,19,41,65,41,
51,11,15,11,56,6,6,9,26,80,54,92,10,90,82,46,20,0,7,61,
71,89,13,84,56,38,18,22,4,3,9,31,45,31,11,19,0,8,5,5,
8,14,16,8,24,24,4,90,82,66,52,42,30,9,23,45,0,0,0,0,
102,14,29,102,14,29,49,17,38,22,6,16,34,82,114,34,29,7,2,4,
10,2,3,7,11,30,16,33,57,81,3,33,13,2,4,10,27,17,22,18,
5,23,37,4,27,37,63,12,11,25,8,25,25,49,1,23,15,39,3,4,
44,0,0,0,13,55,67,2,10,5,62,6,37,19,5,17,36,28,11,3,
35,5,35,27,27,33,37,41,45,48,3,0,29,13,47,29,41,8,3,1,
17,30,9,1,23,43,19,25,17,3,13,29,17,1,41,23,88,66,10,0,
6,15,3,4,4,20,6,5,29,17,13,1,0,5,18,18,10,10,14,14,
28,18,10,10,8,4,14,18,31,3,10,13,20,28,38,28,8,38,24,30,
1,6,10,10,34,51,26,44,38,58,70,48,50,74,72,34,56,62,34,124,
2,44,28,36,44,38,52,54,68,16,24,34,36,124,19,86,94,84,78,76,
70,62,62,54,38,30,24,14,6,33,23,21,49,18,16,10,10,9,11,11,
0,25,23,29,49,33,77,33,26,24,20,8,4,7,15,19,33,17,58,34,
24,8,14,7,17,25,39,6,66,50,40,36,26,8,0,7,19,9,84,60,
34,10,22,1,19,29,14,100,84,64,44,44,8,5,9,17,124,67,57,37,
53,51,35,39,31,29,35,29,25,35,33,41,47,23,33,27,25,17,13,13,
13,9,9,11,13,29,8,10,16,4,0,10,8,8,6,4,2,0,1,9,
17,9,8,31,8,32,8,22,12,18,26,12,10,8,18,5,13,21,86,90,
88,80,74,86,80,82,80,72,82,76,60,48,20,80,80,74,64,56,54,34,
28,18,16,1,9,15,33,92,92,90,82,66,72,64,50,46,36,28,10,2,
11,29,1,1,33,22,20,10,3,0,3,15,5,19,21,45,37,53,69,5,
27,37,29,17,0,15,14,30,9,11,10,18,8,16,34,8,4,100,64,30,
2,17,55,79,107,115,1,78,58,48,28,38,18,8,4,17,25,15,2,11,
16,30,3,7,8,16,12,16,32,16,6,100,64,30,2,17,55,79,107,115,
0,0,0,0,100,14,29,100,14,29,45,13,38,22,4,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,13,55,67,4,8,5,104,14,11,77,39,37,
0,25,49,37,57,11,49,39,39,69,67,71,71,36,3,2,43,3,35,23,
39,17,49,33,69,26,21,3,59,37,15,17,0,12,2,5,24,18,17,0,
0,3,4,23,24,2,28,38,20,34,34,24,4,22,6,8,14,37,51,29,
37,17,25,19,4,15,17,9,5,15,17,5,41,53,29,63,11,21,8,5,
7,26,2,3,7,26,11,27,2,51,58,66,54,54,66,52,24,56,52,4,
24,26,8,2,15,16,6,6,12,2,9,10,0,27,7,11,23,13,51,90,
98,86,90,86,78,74,78,68,52,54,42,22,16,23,52,44,8,52,34,34,
24,14,8,6,5,29,9,23,53,43,71,5,60,42,28,8,10,1,11,17,
29,8,88,58,44,34,44,14,0,9,15,21,60,36,20,8,16,1,11,23,
43,35,16,0,1,9,7,27,35,51,5,76,42,26,12,22,1,9,15,25,
124,41,23,7,5,11,2,12,14,7,12,22,20,27,15,17,10,24,12,6,
26,34,36,1,12,28,28,25,13,25,45,35,19,27,19,21,17,11,15,17,
15,7,17,21,35,49,21,67,25,5,13,8,11,3,22,5,7,5,14,13,
15,47,72,72,74,64,50,68,60,52,46,44,44,34,1,1,15,24,24,12,
15,6,2,13,15,19,21,25,51,35,55,94,92,86,80,64,66,60,42,46,
36,32,14,6,9,25,50,52,4,52,56,36,24,26,20,12,16,6,7,17,
21,33,59,3,23,43,63,39,49,11,13,9,60,8,8,9,28,84,58,96,
10,86,78,42,14,5,13,67,75,91,13,84,56,38,18,22,4,3,9,31,
43,29,9,17,2,10,5,3,10,16,18,10,24,26,4,86,80,62,48,38,
26,13,27,47,0,0,0,0,100,14,29,100,14,29,45,13,38,22,4,14,
30,80,114,34,25,7,2,6,8,2,3,9,15,28,12,39,61,85,2,31,
13,2,6,8,27,15,22,18,5,21,35,4,27,37,63,12,11,25,8,25,
23,47,1,23,15,39,1,4,44,0,0,0,13,55,67,4,8,5,60,4,
37,13,3,15,40,32,7,0,33,1,31,25,23,33,35,39,45,48,3,2,
25,13,45,29,37,8,5,3,17,30,9,0,23,41,17,25,15,1,11,25,
13,0,39,21,98,74,16,6,6,13,3,6,4,20,8,5,27,13,13,5,
3,0,18,20,10,10,14,16,30,20,12,8,8,4,14,18,33,3,10,15,
20,26,38,26,8,38,24,30,3,6,8,8,34,51,26,42,36,54,64,46,
46,70,68,30,50,58,22,124,3,40,24,30,38,32,46,44,60,10,20,26,
32,124,21,82,90,80,74,72,66,58,58,50,32,26,20,10,2,37,23,21,
49,16,14,8,6,11,13,13,1,27,25,31,49,35,75,29,28,26,20,10,
4,7,15,17,29,13,58,36,26,8,16,5,15,23,35,6,68,52,42,36,
28,10,0,5,19,9,84,60,34,8,22,1,19,27,14,98,82,62,42,44,
8,3,9,17,124,63,53,35,49,49,33,37,29,27,31,27,21,33,31,39,
45,19,33,27,25,17,11,13,15,9,9,11,13,31,10,10,18,4,0,10,
8,8,6,4,2,0,1,9,17,9,8,33,6,32,6,22,10,16,26,10,
8,8,18,7,13,23,84,88,86,76,70,82,76,76,74,66,76,70,54,44,
16,70,72,66,54,50,48,30,24,14,12,5,13,17,33,86,86,86,78,60,
66,60,44,42,32,24,4,1,15,31,3,1,37,20,16,8,7,3,7,17,
7,21,23,47,41,55,69,7,31,41,27,17,2,13,16,32,9,9,10,18,
8,18,36,8,4,98,60,24,3,25,63,87,115,121,0,78,58,48,28,38,
18,8,4,15,25,15,4,11,18,32,3,7,10,18,12,16,32,16,6,98,
60,24,3,25,63,87,115,121,0,0,0,0,96,12,29,96,12,29,43,11,
38,22,4,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,11,57,67,4,
6,5,104,14,11,75,37,37,0,23,45,33,55,9,45,37,37,67,67,69,
69,36,3,4,41,3,35,23,37,17,49,33,67,26,21,3,57,37,13,17,
0,12,2,5,24,18,19,0,0,3,4,23,24,2,26,38,18,34,34,24,
0,22,6,4,12,39,49,27,35,15,25,19,6,15,17,7,3,15,17,5,
45,53,27,63,11,23,10,5,9,28,2,3,9,28,13,29,2,53,54,64,
52,52,64,50,22,54,50,0,22,24,8,2,15,14,4,4,10,0,11,8,
1,31,11,13,25,15,51,86,94,82,86,82,74,70,74,62,46,50,36,16,
10,29,48,40,4,48,30,28,18,10,2,0,9,33,11,27,55,45,73,5,
60,42,28,8,10,1,11,17,27,8,88,58,44,34,46,14,0,9,15,21,
62,36,20,8,16,1,11,21,41,33,18,2,1,9,5,25,33,49,5,76,
42,26,12,24,1,9,13,25,124,41,23,7,5,11,2,12,14,7,12,22,
22,27,15,17,8,24,10,4,24,32,36,5,8,28,28,27,15,27,45,33,
17,27,19,21,15,9,17,17,15,7,19,21,35,49,21,69,25,5,13,10,
11,3,22,5,9,5,16,15,15,49,70,70,74,62,46,66,58,50,44,42,
42,32,3,3,17,20,22,8,19,2,0,15,17,19,21,25,51,37,55,88,
86,82,76,58,60,54,36,42,32,28,8,2,11,27,46,48,0,48,52,30,
18,20,14,8,12,0,11,21,27,37,61,7,27,47,61,37,47,9,11,9,
62,10,8,9,28,86,60,98,12,84,74,36,8,11,19,73,79,93,13,84,
56,38,18,22,4,3,9,29,43,27,7,17,4,10,3,3,10,16,18,10,
26,26,2,84,76,58,44,34,22,17,31,49,0,0,0,0,96,12,29,96,
12,29,43,11,38,22,4,10,24,78,114,32,21,9,2,8,8,0,3,11,
19,26,6,47,67,89,8,29,13,2,8,8,29,13,22,16,5,21,35,2,
29,37,63,12,11,25,8,25,23,47,1,23,15,39,1,4,44,0,0,0,
11,57,67,4,6,5,58,4,39,9,1,13,42,36,5,2,29,0,29,23,
19,33,35,39,45,48,3,4,21,13,45,27,33,8,5,3,19,30,9,0,
21,39,15,23,15,1,11,23,11,0,37,19,106,82,22,10,6,13,3,6,
2,20,8,5,27,9,13,9,7,4,18,20,10,10,14,16,34,20,12,8,
6,4,16,20,37,3,10,15,18,22,36,26,6,38,24,28,5,6,6,6,
32,51,24,40,34,50,56,42,42,66,62,24,46,54,8,124,11,36,20,26,
32,28,38,36,52,4,16,20,28,124,25,78,84,74,68,66,60,54,52,46,
28,22,16,6,1,41,23,23,51,14,10,6,4,13,17,17,5,29,25,33,
51,37,75,27,30,26,20,10,6,5,13,17,25,11,58,36,26,10,18,3,
11,19,33,8,68,52,42,38,30,10,0,5,17,11,86,60,32,8,22,1,
19,27,14,98,80,60,40,44,8,3,9,17,124,61,51,33,47,45,31,33,
25,25,29,23,17,33,31,39,43,17,33,27,25,15,11,13,15,9,11,11,
13,31,10,10,20,4,1,10,8,6,6,4,2,1,1,9,17,9,10,35,
4,32,2,20,8,14,24,8,6,8,18,9,13,27,82,84,84,72,66,78,
72,72,70,60,70,64,48,38,12,62,64,56,44,42,40,24,18,8,8,9,
15,19,35,82,82,80,72,54,60,54,38,36,26,18,1,5,19,35,5,3,
41,16,14,4,11,7,11,21,11,25,27,49,43,57,71,11,33,43,27,17,
2,13,18,34,9,9,12,20,8,18,36,8,2,96,56,18,9,31,71,97,
125,125,0,78,58,48,28,40,18,8,4,15,25,15,4,11,18,32,3,7,
10,18,12,16,34,16,4,96,56,18,9,31,71,97,125,125,0,0,0,0,
94,12,29,94,12,29,39,9,40,22,4,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,9,57,67,4,4,5,104,14,11,73,35,37,0,21,41,29,
51,5,41,35,33,65,65,67,67,38,1,6,39,3,33,21,33,17,47,33,
63,28,21,3,53,37,11,17,0,14,4,3,24,18,19,0,2,3,4,21,
24,2,26,38,16,34,34,24,3,22,6,2,10,39,47,25,33,13,23,17,
8,13,17,5,1,15,17,5,47,51,25,63,9,23,12,5,11,30,2,3,
11,30,15,31,2,53,52,62,52,50,62,48,22,54,50,1,20,24,8,2,
15,14,2,2,8,1,13,8,1,33,13,13,27,17,51,84,92,80,84,80,
70,66,70,58,42,46,32,10,6,35,46,36,2,44,26,24,14,6,1,3,
13,37,11,31,57,45,73,5,62,42,28,10,10,1,9,17,25,8,88,58,
46,34,48,16,2,7,13,19,64,38,22,10,18,0,11,19,39,31,22,4,
0,7,3,23,31,47,3,76,44,28,12,26,0,7,11,23,124,39,21,5,
5,11,2,14,16,7,12,24,24,27,15,17,8,24,8,4,22,32,36,7,
6,28,28,27,17,29,43,31,15,27,17,21,13,7,17,17,15,5,19,21,
35,49,19,69,25,5,13,12,11,3,24,5,9,5,18,17,15,49,68,70,
74,62,44,64,56,48,44,40,40,32,3,5,19,18,20,4,23,0,1,15,
17,19,19,23,51,39,53,84,82,78,72,54,56,50,32,38,28,24,4,1,
13,29,42,46,1,44,48,26,14,16,10,4,8,3,15,23,31,41,63,11,
31,51,59,33,43,7,9,7,66,12,10,9,30,90,62,102,14,82,72,32,
2,15,25,77,83,95,13,84,56,38,18,24,4,3,9,27,41,25,5,15,
8,12,1,1,12,18,20,10,28,26,2,82,74,56,42,30,18,21,35,49,
0,0,0,0,94,12,29,94,12,29,39,9,40,22,4,8,20,76,116,32,
17,9,4,10,8,1,3,11,21,24,2,55,73,91,14,27,11,4,10,8,
29,11,22,16,3,21,33,2,29,37,63,12,11,23,8,25,23,47,1,23,
15,37,1,4,44,0,0,0,9,57,67,4,4,5,56,4,39,5,2,11,
46,40,1,4,25,4,27,19,13,33,35,39,43,48,3,6,17,11,43,25,
29,8,5,3,19,30,9,0,19,37,13,21,13,0,9,21,7,2,33,17,
116,92,30,16,8,13,1,8,2,20,8,3,25,3,13,13,9,10,18,20,
10,10,14,18,38,22,12,8,6,4,18,22,39,1,10,15,16,20,34,26,
4,38,24,28,7,8,4,6,30,51,24,40,34,46,50,40,40,62,58,20,
42,50,3,124,17,32,16,22,26,24,32,28,44,0,12,14,24,124,29,74,
80,70,64,62,56,50,48,42,24,18,14,4,3,45,23,23,51,14,8,4,
2,15,19,19,9,31,25,35,53,37,73,25,32,26,20,10,8,3,11,15,
19,9,58,36,26,12,20,1,7,15,29,10,70,54,44,40,32,10,2,5,
15,11,88,60,30,8,24,0,19,25,14,98,80,58,38,44,8,3,9,15,
124,59,49,29,43,41,29,29,21,23,25,19,13,31,29,37,41,13,31,25,
23,13,9,13,15,9,13,11,13,31,10,12,22,6,1,12,8,6,6,4,
2,3,1,7,15,9,12,35,2,32,0,18,8,14,24,8,4,8,18,11,
13,29,80,82,84,70,62,74,68,68,66,56,64,58,42,32,8,54,56,48,
34,36,34,18,14,4,6,11,17,19,37,78,78,76,68,50,56,50,32,32,
22,14,5,9,23,39,5,5,43,14,12,0,15,9,13,25,13,29,29,49,
45,57,73,15,35,45,27,15,4,13,20,38,7,7,14,22,8,20,38,8,
2,94,52,14,15,37,79,105,125,125,0,78,58,50,30,42,20,10,6,15,
25,15,4,9,20,34,3,5,10,18,12,18,36,16,4,94,52,14,15,37,
79,105,125,125,0,0,0,0,92,12,29,92,12,29,35,5,40,22,2,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,9,57,67,6,2,5,104,14,
11,71,33,37,2,17,39,25,49,3,39,31,29,63,63,65,67,40,1,8,
37,3,33,19,29,17,47,31,61,28,19,1,51,35,11,17,2,14,4,1,
26,20,21,1,2,3,4,21,24,0,24,38,16,34,34,22,7,22,4,1,
8,41,45,23,31,11,21,15,10,11,15,3,0,15,17,3,49,51,23,63,
9,23,12,5,13,32,2,3,15,32,15,33,2,55,48,60,50,48,60,46,
20,52,50,3,18,24,8,2,17,12,2,0,8,3,15,6,3,37,15,15,
29,19,51,80,90,76,80,76,66,60,66,52,38,42,26,6,2,39,42,34,
1,38,22,20,10,0,5,9,17,43,13,33,61,47,73,5,62,44,28,10,
10,1,9,17,25,10,90,58,46,34,50,16,4,7,11,17,66,40,22,10,
20,0,9,19,37,31,24,4,0,7,1,21,31,45,3,78,44,28,12,28,
2,5,9,21,124,39,21,5,5,11,2,14,16,5,12,24,24,27,15,17,
6,26,6,2,20,30,36,9,4,26,28,29,19,29,41,31,13,25,17,19,
13,5,17,17,15,5,21,21,35,47,17,69,25,3,13,12,11,3,26,5,
9,5,20,17,17,51,66,70,72,60,42,62,54,46,42,38,38,30,5,7,
21,14,16,2,27,1,3,17,19,21,19,23,51,39,51,80,78,74,66,48,
52,46,26,34,24,20,0,5,17,31,38,42,3,40,44,22,10,12,6,0,
4,7,21,27,35,45,65,15,35,53,57,31,41,7,7,5,70,14,12,9,
32,92,66,104,14,78,68,26,3,21,31,83,87,97,13,84,56,38,18,24,
4,3,9,27,39,23,3,13,10,14,1,0,14,20,22,12,28,28,2,78,
70,52,38,26,14,25,39,51,0,0,0,0,92,12,29,92,12,29,35,5,
40,22,2,6,16,74,116,32,13,9,4,12,6,1,3,13,25,22,3,61,
77,95,20,25,11,4,12,6,29,9,22,14,3,19,31,2,29,37,63,12,
11,23,8,25,21,45,1,23,15,37,0,4,44,0,0,0,9,57,67,6,
2,5,54,2,39,0,4,9,50,44,0,8,23,6,23,17,9,33,33,37,
43,48,3,8,13,11,41,25,25,8,7,5,21,30,9,2,19,35,11,21,
11,0,7,17,5,4,31,15,124,100,36,22,8,11,1,8,2,20,10,3,
25,0,13,17,13,16,18,22,10,10,14,18,40,24,14,6,6,4,18,22,
41,1,10,17,16,18,34,24,4,38,24,28,9,8,2,4,30,51,24,38,
32,42,44,38,36,58,54,16,36,46,15,124,25,28,12,16,20,18,26,18,
36,5,8,6,20,124,31,70,76,66,60,58,52,46,44,38,18,14,10,0,
7,49,23,23,53,12,6,2,1,17,21,21,11,33,27,37,53,39,71,21,
34,28,20,12,8,3,11,13,15,5,58,38,28,12,22,0,5,13,25,10,
72,56,46,40,34,12,2,3,15,11,88,60,30,6,24,0,19,25,14,96,
78,56,36,44,8,1,9,15,124,55,45,27,39,39,27,27,19,21,21,17,
9,29,27,37,39,9,31,25,23,13,9,13,17,9,13,11,13,33,12,12,
24,6,1,12,8,6,6,4,2,3,1,7,15,9,12,37,0,32,1,18,
6,12,24,6,2,8,18,13,13,31,78,80,82,66,58,70,64,62,60,50,
58,52,36,28,4,44,48,40,24,30,28,14,10,1,2,15,21,21,37,72,
72,70,64,44,50,44,26,28,16,10,11,13,27,41,7,5,47,12,8,1,
19,13,17,27,15,31,31,51,49,59,73,17,39,49,25,15,6,11,22,40,
7,5,14,22,8,20,40,8,2,92,48,8,21,45,87,113,125,125,2,78,
58,50,30,42,20,10,6,13,25,15,6,9,22,36,3,5,12,20,12,18,
36,16,4,92,48,8,21,45,87,113,125,125,0,0,0,0,90,12,31,90,
12,31,31,3,42,22,2,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
7,57,67,6,2,7,104,14,11,69,33,37,2,15,35,21,45,1,35,29,
25,61,61,63,65,42,1,10,37,1,31,19,25,17,45,31,59,28,19,1,
47,35,9,15,2,14,4,0,26,20,21,1,2,3,4,21,24,0,24,38,
14,34,34,22,11,22,4,5,6,43,45,21,31,11,19,15,12,11,15,3,
4,15,17,3,51,49,21,63,9,23,14,3,15,32,2,3,17,34,17,35,
2,57,46,58,50,48,58,46,20,50,48,5,16,24,8,2,17,10,0,1,
6,3,17,4,3,41,17,15,31,21,51,78,86,74,76,72,62,56,62,48,
32,38,22,0,3,45,38,30,3,34,16,14,4,3,11,13,23,47,15,37,
63,49,73,3,64,44,30,10,10,1,9,17,23,10,90,60,46,34,52,18,
4,5,11,15,68,40,24,10,22,2,9,17,35,29,26,6,2,7,1,21,
29,41,1,78,44,28,14,28,2,3,9,19,124,37,19,3,5,11,2,14,
16,5,14,24,26,27,15,19,6,26,4,0,18,28,36,11,2,26,28,29,
21,31,39,29,11,25,15,19,11,5,17,15,13,3,21,21,35,47,15,69,
25,3,13,14,11,3,28,7,9,5,20,19,17,53,64,68,72,58,40,62,
54,44,40,38,36,28,7,9,23,12,14,1,31,5,7,19,19,21,19,23,
49,41,49,76,74,70,62,42,48,42,22,30,18,16,5,9,19,31,36,40,
7,36,38,18,6,8,2,3,1,11,25,31,39,47,69,19,39,57,55,29,
39,5,5,3,72,16,14,9,34,96,68,108,16,76,66,22,9,27,35,89,
91,101,11,84,56,38,18,24,4,3,9,25,37,23,1,11,12,14,0,2,
14,20,22,12,30,28,2,76,68,48,34,24,12,31,41,53,0,0,0,0,
90,12,31,90,12,31,31,3,42,22,2,2,12,72,116,32,11,9,6,12,
6,3,1,13,27,18,7,69,83,97,24,23,11,6,12,6,31,9,22,14,
3,19,31,2,29,35,61,12,9,21,8,23,21,45,1,23,15,37,0,4,
44,0,0,0,7,57,67,6,2,7,54,2,39,4,6,7,52,50,4,10,
19,10,21,15,5,33,33,37,43,48,3,10,7,11,39,23,21,6,7,5,
21,32,9,2,17,35,11,19,9,2,5,15,1,4,29,13,124,110,42,28,
8,11,1,10,2,20,10,1,23,4,11,21,17,22,18,22,10,10,16,20,
44,26,14,6,6,4,20,24,43,1,10,17,14,16,32,24,2,38,24,28,
13,8,0,2,28,51,24,38,32,38,38,36,32,52,48,12,32,42,29,124,
31,24,10,12,12,14,20,10,26,11,4,0,16,124,35,66,72,62,54,52,
48,40,40,34,14,8,6,3,9,51,23,23,53,10,4,0,3,19,23,23,
15,35,27,39,55,39,71,19,36,28,20,12,10,1,9,13,11,3,60,38,
28,14,24,2,1,9,21,12,72,56,46,42,36,12,2,3,13,11,90,60,
28,6,24,0,19,23,12,96,78,54,34,42,8,1,9,15,124,53,43,25,
37,35,25,23,15,19,19,13,5,29,25,35,37,5,29,25,23,11,7,13,
17,9,15,11,13,33,12,14,26,6,1,14,10,6,8,6,2,5,1,7,
15,9,14,39,1,32,3,16,4,12,24,4,2,8,16,17,15,33,74,78,
80,64,54,66,60,58,56,46,52,48,30,22,0,36,40,32,16,22,22,8,
6,5,1,19,23,23,39,68,68,66,58,38,46,40,20,22,12,4,17,17,
29,45,9,7,49,8,6,5,23,15,21,31,17,35,33,53,51,61,75,21,
41,51,25,13,6,11,24,42,7,5,16,24,8,22,42,8,2,90,44,4,
27,51,95,121,125,125,2,78,58,50,30,44,22,10,6,13,23,13,6,7,
24,38,1,3,12,20,12,18,38,16,4,90,44,4,27,51,95,121,125,125,
0,0,0,0,86,12,31,86,12,31,29,0,42,22,0,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,7,59,67,8,0,7,104,14,11,67,31,37,
4,13,31,17,43,0,31,27,21,59,61,61,63,42,1,12,35,1,31,17,
21,17,45,29,57,28,19,0,45,33,7,15,2,14,4,0,28,22,23,1,
2,3,4,21,24,1,22,38,12,34,34,22,15,22,2,9,4,45,43,19,
29,9,19,13,14,9,13,1,6,15,17,3,53,49,19,63,9,23,16,3,
17,34,2,3,19,36,17,37,2,59,42,56,48,46,56,44,18,48,48,9,
14,22,8,2,19,8,1,3,4,5,19,2,5,45,19,17,33,23,51,74,
84,70,72,68,58,52,58,42,28,34,16,3,7,49,34,26,7,30,12,10,
0,7,15,19,27,53,17,41,65,51,73,3,64,44,30,10,10,1,9,17,
23,10,90,60,46,34,54,18,6,5,9,15,70,42,24,10,22,2,7,17,
33,27,28,8,2,7,0,19,27,39,1,78,44,28,14,30,4,3,7,17,
124,37,19,3,5,11,2,14,16,5,14,24,26,27,15,19,4,28,2,1,
16,26,36,15,0,26,28,31,23,31,39,27,9,23,15,17,11,3,19,15,
13,3,23,21,35,45,13,69,25,3,13,16,11,3,30,7,11,5,22,21,
17,55,62,68,70,56,38,60,52,42,38,36,34,26,9,11,25,8,12,3,
35,7,9,21,21,23,19,23,49,41,49,70,68,66,58,36,44,38,16,26,
14,12,9,13,23,33,32,36,9,32,34,14,2,2,1,7,5,15,31,35,
43,51,71,23,43,59,53,27,37,3,3,1,76,18,16,9,36,98,72,110,
18,72,62,16,15,33,41,95,95,103,11,84,56,38,18,24,4,3,9,25,
35,21,0,11,14,16,0,4,16,22,24,12,30,28,2,74,64,44,30,20,
8,35,45,55,0,0,0,0,86,12,31,86,12,31,29,0,42,22,0,0,
8,70,116,30,7,9,6,14,6,3,1,15,31,16,13,75,87,101,30,21,
11,6,14,6,31,7,22,12,3,19,29,2,29,35,61,12,9,21,8,23,
19,45,1,23,15,37,0,4,44,0,0,0,7,59,67,8,0,7,52,0,
39,10,8,5,56,54,6,14,15,12,19,13,1,33,33,35,43,48,3,12,
3,11,39,23,17,6,9,7,23,32,9,4,17,33,9,19,7,2,5,11,
0,6,27,11,124,118,48,34,8,11,1,10,2,20,12,1,23,8,11,25,
21,26,18,22,10,10,16,20,46,28,14,6,6,4,20,26,45,1,10,19,
14,14,32,24,2,38,24,28,15,8,1,0,28,51,22,36,30,34,30,34,
28,48,44,8,26,38,41,124,39,20,6,8,6,8,12,2,18,17,0,7,
12,124,39,62,68,56,50,48,44,36,36,30,10,4,2,7,13,55,23,23,
55,8,2,1,5,21,27,25,19,37,29,41,57,41,69,15,38,30,20,12,
12,1,9,11,7,1,60,38,30,16,26,4,0,7,19,14,74,58,48,42,
38,14,2,3,13,11,90,60,26,6,24,0,19,23,12,94,76,52,32,42,
8,1,9,15,124,51,39,23,33,33,23,19,11,17,15,9,1,27,23,35,
35,3,29,25,23,11,7,13,17,9,15,11,13,35,14,14,28,6,1,14,
10,6,8,6,2,5,1,7,15,9,14,41,3,32,5,14,2,10,24,2,
0,8,16,19,15,35,72,76,78,60,50,62,56,54,50,40,46,42,24,18,
3,28,32,24,6,16,14,4,0,11,5,23,27,25,41,64,62,60,54,32,
40,34,14,18,6,0,23,21,33,47,11,9,53,6,2,9,27,19,25,35,
19,37,35,55,53,63,77,23,43,53,25,13,8,9,26,44,7,3,16,24,
8,22,44,8,2,88,40,1,33,57,103,125,125,125,2,78,58,50,30,44,
22,10,6,11,23,13,8,7,24,40,1,3,12,20,12,18,38,16,4,88,
40,1,33,57,103,125,125,125,0,0,0,0,84,12,31,84,12,31,25,2,
42,22,0,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,5,59,67,8,
1,7,104,14,11,65,29,37,4,9,29,13,39,2,29,23,17,57,59,59,
63,44,1,14,33,1,29,15,17,17,45,29,53,30,17,0,43,33,7,15,
4,16,6,2,28,22,23,3,2,3,4,21,24,1,20,38,12,34,34,20,
19,22,2,11,2,47,41,17,27,7,17,11,16,7,13,0,8,15,17,1,
55,47,17,63,7,23,16,3,19,36,2,3,23,38,19,39,2,59,40,54,
48,44,54,42,16,48,48,11,12,22,8,2,19,8,1,5,4,7,21,2,
7,49,21,19,35,25,51,70,82,66,68,66,54,46,54,38,24,30,12,9,
11,55,30,24,11,24,8,6,3,13,19,25,31,57,19,43,69,51,73,3,
64,46,30,10,10,1,9,17,21,12,92,60,46,34,56,20,8,5,7,13,
72,44,24,12,24,4,7,15,31,27,32,8,2,5,2,17,27,37,0,80,
46,28,14,32,6,1,5,15,124,37,19,1,5,11,2,14,16,3,14,26,
28,27,15,19,2,28,0,3,14,26,36,17,1,24,28,33,25,33,37,27,
7,23,13,17,9,1,19,15,13,3,25,21,35,45,11,69,25,1,13,16,
11,3,32,7,11,5,24,21,19,55,60,68,70,56,36,58,50,40,38,34,
32,24,11,13,27,6,8,7,39,9,11,23,23,23,19,21,49,43,47,66,
64,62,52,32,40,34,12,22,10,8,13,17,25,35,28,32,11,28,30,10,
1,1,5,11,9,19,35,39,47,55,73,27,47,63,51,23,35,3,1,0,
80,20,18,9,38,102,74,114,18,70,58,12,21,37,47,99,99,105,11,84,
56,38,18,24,4,3,9,23,33,19,2,9,16,18,2,6,18,24,26,14,
32,30,2,70,62,42,28,16,4,39,49,57,0,0,0,0,84,12,31,84,
12,31,25,2,42,22,0,1,4,68,116,30,3,9,6,16,4,5,1,17,
35,14,17,83,93,105,36,19,9,6,16,4,31,5,22,12,3,17,27,2,
29,35,61,12,9,21,8,23,19,43,1,23,15,37,2,4,44,0,0,0,
5,59,67,8,1,7,50,0,39,14,10,3,60,58,10,16,13,16,15,11,
4,33,31,35,41,48,3,14,0,11,37,21,13,6,9,7,23,32,9,4,
15,31,7,17,5,4,3,9,4,8,23,9,124,124,54,40,10,9,0,12,
2,20,12,1,21,12,11,29,25,32,18,24,10,10,16,22,50,30,16,4,
6,4,22,26,47,0,10,19,12,12,30,22,0,38,24,28,17,10,3,0,
26,51,22,34,28,30,24,32,26,44,40,4,22,34,53,124,45,16,2,2,
0,4,6,7,10,21,3,13,8,124,41,58,64,52,46,44,40,32,32,26,
4,0,1,9,17,59,23,23,55,6,0,3,9,23,29,27,21,39,29,43,
57,43,67,13,40,30,20,14,12,0,7,9,3,2,60,40,30,16,28,6,
4,3,15,14,76,60,50,44,40,14,4,1,11,11,92,60,26,4,24,0,
19,21,12,94,74,50,30,42,8,0,9,13,124,47,37,19,29,29,21,17,
9,15,11,7,2,25,21,33,33,0,29,25,21,9,5,13,19,9,17,11,
13,35,14,14,30,6,1,14,10,6,8,6,2,7,1,7,15,9,16,43,
5,32,7,14,2,8,24,2,1,8,16,21,15,37,70,74,76,56,46,58,
52,48,46,34,40,36,18,12,7,18,24,16,3,10,8,1,3,15,9,25,
29,25,41,58,58,56,50,26,34,30,8,14,2,3,29,25,37,51,11,9,
57,4,0,11,31,23,29,37,21,41,37,55,57,65,77,27,47,57,23,13,
10,9,28,46,5,1,18,26,8,24,46,8,2,86,36,7,39,65,111,125,
125,125,4,78,58,50,30,46,22,12,8,11,23,13,8,7,26,42,1,3,
14,22,12,20,40,16,4,86,36,7,39,65,111,125,125,125,0,0,0,0,
82,12,31,82,12,31,21,6,44,22,1,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,5,59,67,10,3,7,104,14,11,63,27,37,6,7,25,9,
37,4,25,21,13,55,57,57,61,46,1,16,31,1,29,15,13,17,43,27,
51,30,17,2,39,31,5,15,4,16,6,4,30,24,25,3,2,3,4,21,
24,3,20,38,10,34,34,20,23,22,0,15,0,49,39,15,25,5,15,11,
18,7,11,2,10,15,17,1,57,47,15,63,7,23,18,3,21,38,2,3,
25,40,19,41,2,61,36,52,46,42,52,40,16,46,46,13,10,22,8,2,
21,6,3,7,2,9,23,0,7,53,23,19,37,27,51,68,78,64,64,62,
50,42,50,32,18,26,6,13,17,59,26,20,13,20,4,0,9,17,25,29,
35,63,21,47,71,53,73,3,66,46,30,10,10,1,9,17,21,12,92,60,
46,34,58,20,8,3,7,11,74,44,26,12,26,4,5,15,29,25,34,10,
4,5,4,15,25,35,0,80,46,28,14,34,6,0,3,13,124,35,17,1,
5,11,2,14,16,3,14,26,28,27,15,19,2,30,1,5,12,24,36,19,
3,24,28,33,27,33,35,25,5,21,13,15,9,0,19,15,13,1,25,21,
35,43,9,69,25,1,13,18,11,3,34,7,11,5,26,23,19,57,58,66,
68,54,34,56,48,38,36,32,30,22,13,15,29,2,6,9,43,13,13,25,
23,25,19,21,49,43,45,62,60,58,48,26,36,30,6,18,6,4,19,21,
29,37,24,30,15,24,26,6,5,5,9,15,13,23,41,43,51,59,75,31,
51,65,49,21,33,1,0,2,82,22,20,9,40,104,78,116,20,66,56,6,
27,43,53,105,103,107,11,84,56,38,18,24,4,3,9,23,31,17,4,7,
18,18,2,8,18,24,26,14,32,30,2,68,58,38,24,12,0,43,53,59,
0,0,0,0,82,12,31,82,12,31,21,6,44,22,1,5,0,66,116,30,
0,9,8,18,4,5,1,17,37,12,23,89,97,107,42,17,9,8,18,4,
33,3,22,10,3,17,27,2,29,35,61,12,9,19,8,23,17,43,1,23,
15,37,2,4,44,0,0,0,5,59,67,10,3,7,48,1,39,20,12,1,
62,62,12,20,9,18,13,9,8,33,31,33,41,48,3,16,4,11,35,21,
9,6,11,9,25,32,9,6,15,29,5,17,3,4,1,5,6,8,21,7,
124,124,60,46,10,9,0,12,2,20,14,0,21,16,11,33,29,38,18,24,
10,10,16,22,52,32,16,4,6,4,22,28,49,0,10,21,12,10,30,22,
0,38,24,28,19,10,5,1,26,51,22,34,28,26,18,30,22,40,34,0,
16,30,67,124,53,12,1,1,5,1,0,15,2,27,7,21,4,124,45,54,
60,48,40,38,36,28,28,22,0,3,5,13,19,63,23,23,57,4,1,5,
11,25,31,29,25,41,31,45,59,43,67,9,42,32,20,14,14,0,7,9,
0,4,60,40,32,18,30,8,6,1,11,16,76,60,50,44,42,16,4,1,
11,11,92,60,24,4,24,0,19,21,12,92,74,48,28,42,8,0,9,13,
124,45,33,17,27,27,19,13,5,13,9,3,6,25,19,33,31,4,27,25,
21,9,5,13,19,9,17,11,13,37,16,16,32,6,1,16,10,6,8,6,
2,7,1,7,15,9,16,45,7,32,9,12,0,8,24,0,3,8,16,23,
15,39,68,72,74,54,42,54,48,44,40,30,34,30,12,8,11,10,16,8,
13,2,2,5,7,21,13,29,33,27,43,54,52,50,44,20,30,24,2,8,
3,9,35,29,41,53,13,11,59,0,3,15,35,25,33,41,23,43,39,57,
59,67,79,29,49,59,23,11,10,7,30,48,5,1,18,26,8,24,48,8,
2,84,32,11,45,71,119,125,125,125,4,78,58,50,30,46,24,12,8,9,
23,13,10,5,28,44,1,1,14,22,12,20,40,16,4,84,32,11,45,71,
119,125,125,125,0,0,0,0,80,12,31,80,12,31,17,8,44,22,1,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,3,59,67,10,5,7,104,14,
11,61,25,37,6,5,21,5,33,6,21,19,9,53,55,55,59,48,1,18,
29,1,27,13,9,17,43,27,49,30,17,2,37,31,3,15,4,16,6,6,
30,24,25,3,2,3,4,21,24,3,18,38,8,34,34,20,27,22,0,19,
1,51,37,13,23,3,13,9,20,5,11,4,12,15,17,1,59,45,13,63,
7,23,20,3,23,40,2,3,27,42,21,43,2,63,34,50,46,40,50,38,
14,44,46,15,8,22,8,2,21,4,5,9,0,11,25,1,9,57,25,21,
39,29,51,64,76,60,60,58,46,38,46,28,14,22,2,19,21,65,22,16,
17,16,0,3,13,21,29,35,39,67,23,51,73,55,73,3,66,46,30,10,
10,1,9,17,19,12,92,60,46,34,60,22,10,3,5,9,76,46,26,12,
28,6,5,13,27,23,36,12,4,5,6,13,23,33,2,80,46,28,14,36,
8,2,1,11,124,35,17,0,5,11,2,14,16,3,14,26,30,27,15,19,
0,30,3,7,10,22,36,21,5,24,28,35,29,35,33,23,3,21,11,15,
7,2,19,15,13,1,27,21,35,43,7,69,25,1,13,20,11,3,36,7,
11,5,28,25,19,59,56,66,68,52,32,54,46,36,34,30,28,20,15,17,
31,0,4,13,47,15,15,27,25,25,19,21,49,45,43,58,56,54,44,20,
32,26,2,14,2,0,23,25,31,39,20,26,17,20,22,2,9,9,13,19,
17,27,45,47,55,63,77,35,55,69,47,19,31,0,2,4,86,24,22,9,
42,108,80,120,22,64,52,2,33,49,59,111,107,109,11,84,56,38,18,24,
4,3,9,21,29,15,6,5,20,20,4,10,20,26,28,14,34,30,2,66,
56,34,20,8,3,47,57,61,0,0,0,0,80,12,31,80,12,31,17,8,
44,22,1,7,3,64,116,30,4,9,8,20,4,7,1,19,41,10,27,97,
103,111,48,15,9,8,20,4,33,1,22,10,3,17,25,2,29,35,61,12,
9,19,8,23,17,43,1,23,15,37,2,4,44,0,0,0,3,59,67,10,
5,7,46,1,39,24,14,0,66,66,16,22,5,22,11,7,12,33,31,33,
41,48,3,18,8,11,33,19,5,6,11,9,25,32,9,6,13,27,3,15,
1,6,0,3,10,10,19,5,124,124,66,52,10,9,0,14,2,20,14,0,
19,20,11,37,33,44,18,24,10,10,16,24,56,34,16,4,6,4,24,30,
51,0,10,21,10,8,28,22,1,38,24,28,21,10,7,3,24,51,22,32,
26,22,12,28,18,36,30,3,12,26,79,124,59,8,5,5,11,5,5,23,
5,33,11,27,0,124,49,50,56,44,36,34,32,24,24,18,3,7,9,17,
23,67,23,23,57,2,3,7,13,27,33,31,29,43,31,47,61,45,65,7,
44,32,20,14,16,2,5,7,4,6,60,40,32,20,32,10,10,2,7,18,
78,62,52,46,44,16,4,1,9,11,94,60,22,4,24,0,19,19,12,92,
72,46,26,42,8,0,9,13,124,43,31,15,23,23,17,9,1,11,5,0,
10,23,17,31,29,8,27,25,21,7,3,13,19,9,19,11,13,37,16,16,
34,6,1,16,10,6,8,6,2,9,1,7,15,9,18,47,9,32,11,10,
1,6,24,1,5,8,16,25,15,41,66,70,72,50,38,50,44,40,36,24,
28,24,6,2,15,2,8,0,23,3,3,11,11,25,17,33,35,29,45,50,
48,46,40,14,24,20,3,4,7,13,41,33,45,57,15,13,63,1,5,19,
39,29,37,45,25,47,41,59,61,69,81,33,51,61,23,11,12,7,32,50,
5,0,20,28,8,26,50,8,2,82,28,17,51,77,125,125,125,125,4,78,
58,50,30,48,24,12,8,9,23,13,10,5,30,46,1,1,14,22,12,20,
42,16,4,82,28,17,51,77,125,125,125,125,0,0,0,0,76,10,33,76,
10,33,15,10,44,22,3,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
3,61,67,10,7,9,104,12,11,59,25,37,6,3,19,3,31,8,19,17,
7,51,55,53,59,48,1,18,29,1,27,13,7,17,43,27,47,30,17,2,
35,31,3,15,4,16,6,6,30,24,27,5,2,5,4,21,22,5,16,38,
6,32,34,18,31,20,1,23,3,53,37,13,23,3,13,9,22,5,11,4,
14,17,17,1,63,45,13,63,7,25,20,3,25,40,2,3,31,42,23,45,
2,65,30,48,44,38,48,36,12,42,44,19,6,20,6,2,23,2,7,11,
1,13,27,3,11,61,29,23,43,33,51,60,72,56,56,54,40,32,40,22,
8,16,3,25,27,71,18,12,21,10,5,9,19,27,35,41,45,73,25,55,
77,57,75,3,66,46,30,10,10,3,9,17,19,12,92,60,46,34,62,22,
10,3,5,9,76,46,26,12,28,6,5,13,25,23,38,12,4,5,6,13,
23,31,2,80,46,28,14,36,8,2,1,11,124,35,17,0,5,11,2,14,
16,3,14,26,30,27,15,21,1,30,5,9,8,20,34,25,9,22,26,37,
33,37,33,23,1,21,11,15,7,2,21,15,13,1,29,21,35,43,7,71,
25,1,13,20,13,3,36,9,13,5,28,27,21,61,54,64,66,50,28,52,
44,34,32,28,26,18,17,21,35,3,0,17,51,19,19,29,27,27,19,21,
49,47,43,52,50,50,38,14,26,20,3,8,3,5,29,31,35,41,16,22,
21,16,16,3,15,15,19,23,23,33,51,51,61,67,81,39,59,73,45,17,
29,0,2,4,88,24,22,9,42,110,82,122,22,60,48,3,41,55,65,117,
113,113,11,84,54,36,18,24,4,5,9,21,29,15,6,5,22,20,4,10,
20,26,28,14,34,30,0,62,52,30,16,4,7,53,61,63,0,0,0,0,
76,10,33,76,10,33,15,10,44,22,3,11,9,62,116,28,6,11,8,20,
2,9,1,21,45,6,33,105,109,115,52,15,9,8,20,2,35,1,22,8,
3,17,25,0,31,35,61,10,9,19,8,23,17,43,1,23,17,37,2,4,
44,0,0,0,3,61,67,10,7,9,44,3,41,28,16,2,68,70,18,24,
3,24,9,5,16,33,31,33,41,48,3,18,12,11,33,19,3,4,13,11,
27,32,9,6,13,27,3,15,1,6,0,1,12,10,17,3,124,124,72,56,
10,9,0,14,0,20,14,0,19,24,11,41,37,48,18,24,10,10,16,24,
58,34,16,2,4,4,24,30,55,0,10,23,8,4,26,20,3,38,24,26,
25,10,9,5,22,51,20,30,24,16,4,24,14,30,24,9,6,22,93,124,
67,2,9,11,19,11,13,33,15,39,15,35,3,124,53,44,50,38,30,28,
26,18,18,14,9,13,13,21,27,71,23,25,59,0,7,11,17,31,37,35,
33,45,33,49,63,47,65,5,44,32,20,14,16,2,5,7,8,8,60,40,
32,20,32,12,12,4,5,18,78,62,52,46,46,16,4,1,9,13,94,58,
20,2,24,0,19,19,10,90,70,42,24,40,8,0,9,13,124,41,29,13,
21,21,15,7,0,9,3,2,14,23,17,31,27,10,27,25,21,7,3,13,
21,11,21,11,15,39,16,16,36,6,3,16,10,4,8,6,2,11,1,7,
15,9,18,49,11,32,15,8,3,4,22,3,7,8,14,29,17,45,62,66,
70,46,34,44,38,34,30,18,22,18,1,3,19,7,0,9,33,11,11,17,
17,31,21,37,39,31,47,44,42,40,34,8,18,14,11,1,13,19,47,37,
49,61,17,15,67,5,9,23,45,33,41,49,29,51,45,61,65,71,83,37,
55,65,23,11,12,7,34,52,5,0,20,28,8,26,50,8,0,78,24,23,
59,85,125,125,125,125,4,78,58,50,30,48,24,12,8,9,23,13,10,5,
30,46,1,1,14,22,12,20,42,14,2,78,24,23,59,85,125,125,125,125,
0,0,0,0,74,10,33,74,10,33,11,14,46,24,3,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,1,61,67,12,7,9,104,12,11,55,23,37,
8,0,15,0,27,12,15,13,3,47,53,51,57,50,0,20,27,0,25,11,
3,15,41,25,43,32,15,4,31,29,1,13,6,18,8,8,32,26,27,5,
4,5,4,19,22,5,16,38,6,32,34,18,33,20,1,25,5,53,35,11,
21,1,11,7,24,3,9,6,18,17,17,0,65,43,11,63,5,25,22,1,
25,42,2,3,33,44,23,47,2,65,28,48,44,38,48,36,12,42,44,21,
6,20,6,2,23,2,7,11,1,13,29,3,11,63,31,23,45,35,51,58,
70,54,54,52,36,28,36,18,4,12,7,29,31,75,16,10,23,6,9,13,
23,31,39,45,49,77,25,57,79,57,75,1,68,48,32,12,10,3,7,15,
17,14,94,62,48,34,64,24,12,1,3,7,78,48,28,14,30,8,3,11,
21,21,42,14,6,3,8,11,21,27,4,82,48,30,16,38,10,4,0,9,
124,33,15,2,5,9,2,16,18,1,16,28,32,25,15,21,1,32,5,9,
6,20,34,27,11,22,26,37,35,37,31,21,0,19,9,13,5,4,21,13,
11,0,29,19,33,41,5,71,25,0,13,22,13,3,38,9,13,3,30,27,
21,61,54,64,66,50,26,52,44,34,32,28,26,18,17,23,37,5,1,19,
53,21,21,29,27,27,17,19,47,47,41,48,46,46,34,10,22,16,7,4,
7,9,33,35,37,41,14,20,23,14,12,7,19,19,23,27,27,37,55,53,
65,69,83,41,61,75,41,13,25,2,4,6,92,26,24,9,44,114,86,124,
24,58,46,7,47,59,69,121,117,115,9,86,54,36,18,26,4,5,9,19,
27,13,8,3,26,22,6,12,22,28,30,16,36,32,0,60,50,28,14,2,
9,57,63,63,0,0,0,0,74,10,33,74,10,33,11,14,46,24,3,13,
13,60,118,28,10,11,10,22,2,9,0,21,47,4,37,111,113,117,58,13,
7,10,22,2,35,0,22,8,1,15,23,0,31,33,59,10,7,17,8,21,
15,41,0,21,17,35,4,4,44,0,0,0,1,61,67,12,7,9,44,3,
41,34,20,6,72,76,22,28,0,28,5,1,22,33,29,31,39,48,3,20,
18,9,31,17,0,4,13,11,27,34,9,8,11,25,1,13,0,8,2,2,
16,12,13,0,124,124,80,62,12,7,2,16,0,22,16,2,17,30,9,45,
39,54,18,26,10,12,18,26,62,36,18,2,4,4,26,32,57,2,10,23,
8,2,26,20,3,38,24,26,27,12,9,5,22,51,20,30,24,12,1,22,
12,26,20,13,2,18,105,124,73,1,11,15,25,15,19,41,23,43,19,41,
7,124,55,40,46,34,26,24,22,14,14,10,13,17,15,23,29,73,23,25,
59,0,9,13,19,33,39,37,35,47,33,51,63,47,63,1,46,34,20,16,
18,4,3,5,14,12,62,42,34,22,34,16,16,8,1,20,80,64,54,48,
48,18,6,0,7,13,96,58,20,2,26,2,19,17,10,90,70,40,22,40,
10,2,7,11,124,37,25,9,17,17,11,3,4,5,0,6,20,21,15,29,
23,14,25,23,19,5,1,11,21,11,21,11,15,39,18,18,38,8,3,18,
12,4,10,8,2,11,0,5,13,7,20,49,13,32,17,8,3,4,22,3,
7,8,14,31,17,47,60,64,70,44,32,40,34,30,26,14,18,14,7,7,
23,15,5,17,41,17,17,21,21,35,23,39,41,31,47,40,38,36,30,4,
14,10,17,5,17,23,51,39,51,63,17,15,69,7,11,25,49,35,43,51,
31,53,47,61,67,71,83,39,57,67,21,9,14,5,38,56,3,2,22,30,
10,28,52,8,0,76,20,27,65,91,125,125,125,125,6,78,60,52,32,50,
26,14,10,7,21,11,12,3,32,48,0,0,16,24,12,22,44,14,2,76,
20,27,65,91,125,125,125,125,0,0,0,0,72,10,33,72,10,33,7,16,
46,24,3,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,0,61,67,12,
9,9,104,12,11,53,21,37,8,2,11,4,25,14,11,11,0,45,51,49,
55,52,0,22,25,0,25,9,0,15,41,25,41,32,15,4,29,29,0,13,
6,18,8,10,32,26,29,5,4,5,4,19,22,5,14,38,4,32,34,18,
37,20,1,29,7,55,33,9,19,0,9,5,26,1,9,8,20,17,17,0,
67,43,9,63,5,25,24,1,27,44,2,3,35,46,25,49,2,67,24,46,
42,36,46,34,10,40,44,23,4,20,6,2,23,0,9,13,3,15,31,5,
13,67,33,25,47,37,51,54,68,50,50,48,32,24,32,12,0,8,13,35,
35,81,12,6,27,2,13,17,27,35,43,51,53,81,27,61,81,59,75,1,
68,48,32,12,10,3,7,15,15,14,94,62,48,34,66,24,14,1,1,5,
80,50,28,14,32,8,3,9,19,19,44,16,6,3,10,9,19,25,4,82,
48,30,16,40,12,6,2,7,124,33,15,2,5,9,2,16,18,1,16,28,
34,25,15,21,3,32,7,11,4,18,34,29,13,22,26,39,37,39,29,19,
2,19,9,13,3,6,21,13,11,0,31,19,33,41,3,71,25,0,13,24,
13,3,40,9,13,3,32,29,21,63,52,64,66,48,24,50,42,32,30,26,
24,16,19,25,39,9,3,23,57,23,23,31,29,27,17,19,47,49,39,44,
42,42,30,4,18,12,13,0,11,13,37,39,39,43,10,16,25,10,8,11,
23,23,27,31,31,41,59,57,69,73,85,45,65,79,39,11,23,4,6,8,
96,28,26,9,46,116,88,124,26,56,42,13,53,65,75,125,121,117,9,86,
54,36,18,26,4,5,9,17,25,11,10,1,28,24,8,14,24,30,32,16,
38,32,0,58,46,24,10,1,13,61,67,65,0,0,0,0,72,10,33,72,
10,33,7,16,46,24,3,15,17,58,118,28,14,11,10,24,2,11,0,23,
51,2,43,119,119,121,64,11,7,10,24,2,35,2,22,6,1,15,21,0,
31,33,59,10,7,17,8,21,15,41,0,21,17,35,4,4,44,0,0,0,
0,61,67,12,9,9,42,3,41,38,22,8,76,80,24,30,4,30,3,0,
26,33,29,31,39,48,3,22,22,9,29,15,4,4,13,11,29,34,9,8,
9,23,0,11,2,8,4,4,18,14,11,2,124,124,86,68,12,7,2,16,
0,22,16,2,17,34,9,49,43,60,18,26,10,12,18,26,66,38,18,2,
4,4,28,34,59,2,10,23,6,0,24,20,5,38,24,26,29,12,11,7,
20,51,20,28,22,8,7,20,8,22,16,17,1,14,117,124,81,5,15,19,
31,19,25,49,31,49,23,47,11,124,59,36,42,30,22,20,18,10,10,6,
17,21,19,27,33,77,23,25,61,1,11,15,21,35,41,39,39,49,33,53,
65,49,61,0,48,34,20,16,20,6,1,3,18,14,62,42,34,24,36,18,
20,12,2,22,82,66,56,50,50,18,6,0,5,13,98,58,18,2,26,2,
19,17,10,90,68,38,20,40,10,2,7,11,124,35,23,7,13,13,9,0,
8,3,4,10,24,19,13,29,21,18,25,23,19,3,1,11,21,11,23,11,
15,39,18,18,40,8,3,18,12,4,10,8,2,13,0,5,13,7,22,51,
15,32,19,6,5,2,22,5,9,8,14,33,17,49,58,62,68,40,28,36,
30,26,22,8,12,8,13,13,27,23,13,25,51,23,23,27,25,41,27,43,
43,33,49,36,34,30,26,1,8,4,23,9,23,27,57,43,55,67,19,17,
73,9,13,29,53,39,47,55,33,57,49,63,69,73,85,43,59,69,21,9,
16,5,40,58,3,4,24,32,10,28,54,8,0,74,16,33,71,97,125,125,
125,125,6,78,60,52,32,52,26,14,10,7,21,11,12,3,34,50,0,0,
16,24,12,22,46,14,2,74,16,33,71,97,125,125,125,125,0,0,0,0,
70,10,33,70,10,33,3,20,48,24,5,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,0,61,67,14,11,9,104,12,11,51,19,37,10,4,7,8,
21,16,7,9,4,43,49,47,53,54,0,24,23,0,23,9,4,15,39,23,
39,32,15,6,25,27,2,13,6,18,8,12,34,28,29,5,4,5,4,19,
22,7,14,38,2,32,34,18,41,20,3,33,9,57,31,7,17,2,7,5,
28,1,7,10,22,17,17,0,69,41,7,63,5,25,26,1,29,46,2,3,
37,48,25,51,2,69,22,44,42,34,44,32,10,38,42,25,2,20,6,2,
25,1,11,15,5,17,33,7,13,71,35,25,49,39,51,52,64,48,46,44,
28,20,28,8,5,4,17,39,41,85,8,2,29,1,17,23,33,39,49,55,
57,87,29,65,83,61,75,1,70,48,32,12,10,3,7,15,15,14,94,62,
48,34,68,26,14,0,1,3,82,50,30,14,34,10,1,9,17,17,46,18,
8,3,12,7,17,23,6,82,48,30,16,42,12,8,4,5,124,31,13,4,
5,9,2,16,18,1,16,28,34,25,15,21,3,34,9,13,2,16,34,31,
15,22,26,39,39,39,27,17,4,17,7,11,3,8,21,13,11,2,31,19,
33,39,1,71,25,0,13,26,13,3,42,9,13,3,34,31,21,65,50,62,
64,46,22,48,40,30,28,24,22,14,21,27,41,11,5,25,61,27,25,33,
29,29,17,19,47,49,37,40,38,38,26,1,14,8,17,3,15,17,43,43,
43,45,6,14,29,6,4,15,27,27,31,35,35,45,65,61,73,77,87,49,
69,81,37,9,21,6,8,10,98,30,28,9,48,120,92,124,28,52,40,17,
59,71,81,125,125,119,9,86,54,36,18,26,4,5,9,17,23,9,12,0,
30,24,8,16,24,30,32,16,38,32,0,56,44,20,6,5,17,65,71,67,
0,0,0,0,70,10,33,70,10,33,3,20,48,24,5,19,21,56,118,28,
18,11,12,26,2,11,0,23,53,0,47,125,123,123,70,9,7,12,26,2,
37,4,22,6,1,15,21,0,31,33,59,10,7,15,8,21,13,41,0,21,
17,35,4,4,44,0,0,0,0,61,67,14,11,9,40,5,41,44,24,10,
78,84,28,34,8,34,1,2,30,33,29,29,39,48,3,24,26,9,27,15,
8,4,15,13,29,34,9,10,9,21,2,11,4,10,6,8,22,14,9,4,
124,124,92,74,12,7,2,18,0,22,18,4,15,38,9,53,47,66,18,26,
10,12,18,28,68,40,18,2,4,4,28,36,61,2,10,25,6,1,24,20,
5,38,24,26,31,12,13,9,20,51,20,28,22,4,13,18,4,18,10,21,
7,10,125,124,87,9,19,23,37,25,31,57,39,55,27,55,15,124,63,32,
38,26,16,14,14,6,6,2,21,25,23,31,35,81,23,25,61,3,13,17,
23,37,43,41,43,51,35,55,67,49,61,4,50,36,20,16,22,6,1,3,
22,16,62,42,36,26,38,20,22,14,6,24,82,66,56,50,52,20,6,0,
5,13,98,58,16,2,26,2,19,15,10,88,68,36,18,40,10,2,7,11,
124,33,19,5,11,11,7,4,12,1,6,14,28,19,11,27,19,22,23,23,
19,3,0,11,21,11,23,11,15,41,20,20,42,8,3,20,12,4,10,8,
2,13,0,5,13,7,22,53,17,32,21,4,7,2,22,7,11,8,14,35,
17,51,56,60,66,38,24,32,26,22,16,4,6,2,19,17,31,31,21,33,
61,31,29,31,29,45,31,47,47,35,51,32,28,26,20,7,4,0,29,15,
27,33,63,47,59,69,21,19,75,13,17,33,57,41,51,59,35,59,51,65,
71,75,87,45,61,71,21,7,16,3,42,60,3,4,24,32,10,30,56,8,
0,72,12,37,77,103,125,125,125,125,6,78,60,52,32,52,28,14,10,5,
21,11,14,1,36,52,0,2,16,24,12,22,46,14,2,72,12,37,77,103,
125,125,125,125,0,0,0,0,66,10,33,66,10,33,1,22,48,24,5,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,2,63,67,14,13,9,104,12,
11,49,17,37,10,8,5,12,19,18,5,5,8,41,49,45,53,54,0,26,
21,0,23,7,8,15,39,23,37,32,13,6,23,27,2,13,8,18,8,12,
34,28,31,7,4,5,4,19,22,7,12,38,2,32,34,16,45,20,3,37,
11,59,29,5,15,4,7,3,30,0,7,12,24,17,17,2,71,41,5,63,
5,25,26,1,31,48,2,3,41,50,27,53,2,71,18,42,40,32,42,30,
8,36,42,29,0,18,6,2,25,3,11,17,5,19,35,9,15,75,37,27,
51,41,51,48,62,44,42,40,24,14,24,2,9,0,23,45,45,91,4,0,
33,7,21,27,37,45,53,61,61,91,31,67,87,63,75,1,70,50,32,12,
10,3,7,15,13,16,96,62,48,34,70,26,16,0,0,3,84,52,30,14,
34,10,1,7,15,17,48,18,8,3,14,5,17,21,6,84,48,30,16,44,
14,8,6,3,124,31,13,4,5,9,2,16,18,0,16,28,36,25,15,21,
5,34,11,15,0,14,34,35,17,20,26,41,41,41,27,17,6,17,7,11,
1,10,23,13,11,2,33,19,33,39,0,71,25,2,13,26,13,3,44,9,
15,3,36,31,23,67,48,62,64,44,20,46,38,28,26,22,20,12,23,29,
43,15,9,29,65,29,27,35,31,29,17,19,47,51,37,34,32,34,20,7,
10,4,23,7,19,21,47,47,45,47,2,10,31,2,0,19,31,33,35,39,
39,49,69,65,77,81,89,53,73,85,35,7,19,6,10,12,102,32,30,9,
50,122,94,124,28,50,36,23,65,77,87,125,125,121,9,86,54,36,18,26,
4,5,9,15,21,7,14,0,32,26,10,18,26,32,34,18,40,34,0,52,
40,16,2,9,21,69,75,69,0,0,0,0,66,10,33,66,10,33,1,22,
48,24,5,21,25,54,118,26,22,11,12,28,0,13,0,25,57,1,53,125,
125,125,76,7,7,12,28,0,37,6,22,4,1,13,19,0,31,33,59,10,
7,15,8,21,13,39,0,21,17,35,6,4,44,0,0,0,2,63,67,14,
13,9,38,5,41,48,26,12,82,88,30,36,10,36,2,4,34,33,27,29,
39,48,3,26,30,9,27,13,12,4,15,13,31,34,9,10,7,19,4,9,
6,10,6,10,24,16,7,6,124,124,98,80,12,5,2,18,0,22,18,4,
15,42,9,57,51,70,18,28,10,12,18,28,72,42,20,0,4,4,30,36,
63,2,10,25,4,3,22,18,7,38,24,26,33,12,15,11,18,51,18,26,
20,0,21,16,0,14,6,25,11,6,125,124,95,13,23,29,43,29,39,67,
47,61,31,61,19,124,65,28,34,20,12,10,10,2,2,1,27,29,27,35,
39,85,23,25,63,5,15,19,27,39,47,43,45,53,35,57,67,51,59,6,
52,36,20,18,22,8,0,1,26,20,62,44,36,26,40,22,26,18,8,24,
84,68,58,52,54,20,6,2,3,13,100,58,16,0,26,2,19,15,10,88,
66,34,16,40,10,4,7,11,124,29,17,3,7,7,5,6,14,0,10,16,
32,17,9,27,17,24,23,23,19,1,0,11,23,11,25,11,15,41,20,20,
44,8,3,20,12,4,10,8,2,15,0,5,13,7,24,55,19,32,23,4,
9,0,22,9,13,8,14,37,17,53,54,58,64,34,20,28,22,16,12,1,
0,3,25,23,35,41,29,41,71,37,37,37,35,51,35,51,49,37,51,26,
24,20,16,13,1,5,35,19,33,37,69,51,63,73,23,19,79,15,19,35,
61,45,55,61,37,63,53,67,75,77,87,49,65,75,19,7,18,3,44,62,
3,6,26,34,10,30,58,8,0,70,8,43,83,111,125,125,125,125,8,78,
60,52,32,54,28,14,10,5,21,11,14,1,36,54,0,2,18,26,12,22,
48,14,2,70,8,43,83,111,125,125,125,125,0,0,0,0,64,10,33,64,
10,33,2,26,48,24,7,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
2,63,67,16,15,9,104,12,11,47,15,37,12,10,1,16,15,20,1,3,
12,39,47,43,51,56,0,28,19,0,21,5,12,15,39,21,33,34,13,8,
21,25,4,13,8,20,10,14,36,30,31,7,4,5,4,19,22,9,10,38,
0,32,34,16,49,20,5,39,13,61,27,3,13,6,5,1,32,2,5,14,
26,17,17,2,73,39,3,63,3,25,28,1,33,50,2,3,43,52,27,55,
2,71,16,40,40,30,40,28,6,36,42,31,1,18,6,2,27,3,13,19,
7,21,37,9,17,79,39,29,53,43,51,44,60,40,38,38,20,10,20,1,
13,3,27,49,49,95,0,3,37,11,25,31,41,49,57,67,65,97,33,71,
89,63,75,1,70,50,32,12,10,3,7,15,13,16,96,62,48,34,72,28,
18,0,2,1,86,54,30,16,36,12,0,7,13,15,52,20,8,1,16,3,
15,19,8,84,50,30,16,46,16,10,8,1,124,31,13,6,5,9,2,16,
18,0,16,30,36,25,15,21,7,36,13,17,1,14,34,37,19,20,26,43,
43,41,25,15,8,15,5,9,1,12,23,13,11,2,35,19,33,37,2,71,
25,2,13,28,13,3,46,9,15,3,38,33,23,67,46,62,62,44,18,44,
36,26,26,20,18,10,25,31,45,17,11,31,69,31,29,37,33,31,17,17,
47,51,35,30,28,30,16,11,6,0,27,11,23,25,51,51,49,49,1,6,
33,1,3,23,35,37,39,43,43,53,75,69,81,85,91,57,77,87,33,3,
17,8,12,14,106,34,32,9,52,124,98,124,30,46,32,27,71,81,93,125,
125,123,9,86,54,36,18,26,4,5,9,15,19,5,16,2,34,28,10,20,
28,34,36,18,40,34,0,50,38,14,0,13,25,73,79,71,0,0,0,0,
64,10,33,64,10,33,2,26,48,24,7,23,29,52,118,26,26,11,12,30,
0,13,0,27,61,3,57,125,125,125,82,5,5,12,30,0,37,8,22,4,
1,13,17,0,31,33,59,10,7,15,8,21,11,39,0,21,17,35,6,4,
44,0,0,0,2,63,67,16,15,9,36,7,41,54,28,14,86,92,34,40,
14,40,4,6,40,33,27,27,37,48,3,28,34,9,25,13,16,4,17,15,
31,34,9,12,7,17,6,9,8,12,8,14,28,18,3,8,124,124,104,86,
14,5,4,20,0,22,20,4,13,46,9,61,55,76,18,28,10,12,18,30,
74,44,20,0,4,4,30,38,65,4,10,27,4,5,22,18,7,38,24,26,
35,14,17,11,18,51,18,24,18,3,27,14,1,10,2,29,17,2,125,124,
101,17,27,33,49,35,45,75,55,65,35,69,23,124,69,24,30,16,8,6,
6,1,1,5,31,33,31,37,43,89,23,25,63,7,17,21,29,41,49,45,
49,55,37,59,69,53,57,10,54,38,20,18,24,8,0,0,30,22,62,44,
38,28,42,24,28,20,12,26,86,70,60,52,56,22,8,2,3,13,100,58,
14,0,26,2,19,13,10,86,64,32,14,40,10,4,7,9,124,27,13,0,
3,5,3,10,18,2,14,20,36,15,7,25,15,28,23,23,17,1,2,11,
23,11,25,11,15,43,22,20,46,8,3,20,12,4,10,8,2,15,0,5,
13,7,24,57,21,32,25,2,9,1,22,9,15,8,14,39,17,55,52,56,
62,30,16,24,18,12,6,7,5,9,31,27,39,49,37,49,81,43,43,41,
39,55,39,53,53,37,53,22,18,16,12,19,7,9,41,23,37,41,75,55,
67,75,23,21,83,17,23,39,65,49,59,65,39,65,55,67,77,79,89,51,
67,77,19,7,20,1,46,64,1,8,26,34,10,32,60,8,0,68,4,49,
89,117,125,125,125,125,8,78,60,52,32,54,28,16,12,3,21,11,16,1,
38,56,0,2,18,26,12,24,48,14,2,68,4,49,89,117,125,125,125,125,
0,0,0,0,62,10,35,62,10,35,6,28,50,24,7,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,4,63,67,16,15,11,104,12,11,45,15,37,
12,12,2,20,13,22,2,1,16,37,45,41,49,58,0,30,19,2,21,5,
16,15,37,21,31,34,13,8,17,25,6,11,8,20,10,16,36,30,33,7,
4,5,4,19,22,9,10,38,1,32,34,16,53,20,5,43,15,63,27,1,
13,6,3,1,34,2,5,14,30,17,17,2,75,39,1,63,3,25,30,0,
35,50,2,3,45,54,29,57,2,73,12,38,38,30,38,28,6,34,40,33,
3,18,6,2,27,5,15,21,9,21,39,11,17,83,41,29,55,45,51,42,
56,38,34,34,16,6,16,7,19,7,33,55,55,101,3,7,39,15,31,37,
47,53,63,71,71,101,35,75,91,65,75,0,72,50,34,12,10,3,7,15,
11,16,96,64,48,34,74,28,18,2,2,0,88,54,32,16,38,12,0,5,
11,13,54,22,10,1,16,3,13,15,8,84,50,30,18,46,16,12,8,0,
124,29,11,6,5,9,2,16,18,0,18,30,38,25,15,23,7,36,15,19,
3,12,34,39,21,20,26,43,45,43,23,13,10,15,5,9,0,12,23,11,
9,4,35,19,33,37,4,71,25,2,13,30,13,3,48,11,15,3,38,35,
23,69,44,60,62,42,16,44,36,24,24,20,16,8,27,33,47,21,13,35,
73,35,33,39,33,31,17,17,45,53,33,26,24,26,12,17,2,3,33,15,
29,29,57,55,51,49,3,4,37,5,9,27,39,41,43,47,49,57,79,73,
85,87,95,61,81,91,31,1,15,10,14,16,108,36,34,9,54,124,100,124,
32,44,30,33,77,87,97,125,125,125,7,86,54,36,18,26,4,5,9,13,
17,5,18,4,36,28,12,22,28,34,36,18,42,34,0,48,34,10,3,15,
27,79,81,73,0,0,0,0,62,10,35,62,10,35,6,28,50,24,7,27,
33,50,118,26,28,11,14,30,0,15,2,27,63,7,63,125,125,125,86,3,
5,14,30,0,39,8,22,2,1,13,17,0,31,31,57,10,5,13,8,19,
11,39,0,21,17,35,6,4,44,0,0,0,4,63,67,16,15,11,36,7,
41,58,30,16,88,98,36,42,18,42,6,8,44,33,27,27,37,48,3,30,
40,9,23,11,20,2,17,15,33,36,9,12,5,17,6,7,10,12,10,16,
30,18,1,10,124,124,110,92,14,5,4,20,0,22,20,6,13,50,7,65,
59,82,18,28,10,12,20,30,78,46,20,0,4,4,32,40,67,4,10,27,
2,7,20,18,9,38,24,26,39,14,19,13,16,51,18,24,18,7,33,12,
5,4,3,33,21,1,125,124,109,21,29,37,57,39,51,83,65,71,39,75,
27,124,73,20,26,12,2,0,2,7,5,9,35,39,35,41,45,91,23,25,
65,9,19,23,31,43,51,47,53,57,37,61,71,53,57,12,56,38,20,18,
26,10,2,0,34,24,64,44,38,30,44,26,32,24,16,28,86,70,60,54,
58,22,8,2,1,13,102,58,12,0,26,2,19,13,8,86,64,30,12,38,
10,4,7,9,124,25,11,2,1,1,1,14,22,4,16,24,40,15,5,25,
13,32,21,23,17,0,2,11,23,11,27,11,15,43,22,22,48,8,3,22,
14,4,12,10,2,17,0,5,13,7,26,59,23,32,27,0,11,1,22,11,
15,8,12,43,19,57,48,54,60,28,12,20,14,8,2,11,11,13,37,33,
43,57,45,57,89,51,49,47,43,61,43,57,55,39,55,18,14,10,6,25,
11,15,47,29,43,47,81,59,69,79,25,23,85,21,25,43,69,51,63,69,
41,69,57,69,79,81,91,55,69,79,19,5,20,1,48,66,1,8,28,36,
10,32,62,8,0,66,0,53,95,123,125,125,125,125,8,78,60,52,32,56,
30,16,12,3,19,9,16,0,40,58,2,4,18,26,12,24,50,14,2,66,
0,53,95,123,125,125,125,125,0,0,0,0,60,10,35,60,10,35,10,32,
50,24,9,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,4,63,67,18,
17,11,104,12,11,43,13,37,14,16,4,24,9,24,4,2,20,35,43,39,
49,60,0,32,17,2,19,3,20,15,37,19,29,34,11,10,15,23,6,11,
10,20,10,18,38,32,33,9,4,5,4,19,22,11,8,38,1,32,34,14,
57,20,7,47,17,65,25,0,11,8,1,0,36,4,3,16,32,17,17,4,
77,37,0,63,3,25,30,0,37,52,2,3,49,56,29,59,2,75,10,36,
38,28,36,26,4,32,40,35,5,18,6,2,29,7,15,23,9,23,41,13,
19,87,43,31,57,47,51,38,54,34,30,30,12,0,12,11,23,11,37,59,
59,105,7,9,43,21,35,41,51,59,67,77,75,107,37,77,95,67,75,0,
72,52,34,12,10,3,7,15,11,18,98,64,48,34,76,30,20,2,4,2,
90,56,32,16,40,14,2,5,9,13,56,22,10,1,18,1,13,13,10,86,
50,30,18,48,18,14,10,2,124,29,11,8,5,9,2,16,18,2,18,30,
38,25,15,23,9,38,17,21,5,10,34,41,23,18,26,45,47,43,21,13,
12,13,3,7,0,14,23,11,9,4,37,19,33,35,6,71,25,4,13,30,
13,3,50,11,15,3,40,35,25,71,42,60,60,40,14,42,34,22,22,18,
14,6,29,35,49,23,17,37,77,37,35,41,35,33,17,17,45,53,31,22,
20,22,6,23,1,7,37,19,33,33,61,59,55,51,7,0,39,9,13,31,
43,45,47,51,53,61,85,77,89,91,97,65,85,93,29,0,13,10,16,18,
112,38,36,9,56,124,104,124,32,40,26,37,83,93,103,125,125,125,7,86,
54,36,18,26,4,5,9,13,15,3,20,6,38,30,12,24,30,36,38,20,
42,36,0,44,32,6,7,19,31,83,85,75,0,0,0,0,60,10,35,60,
10,35,10,32,50,24,9,29,37,48,118,26,32,11,14,32,1,15,2,29,
67,9,67,125,125,125,92,1,5,14,32,1,39,10,22,2,1,11,15,0,
31,31,57,10,5,13,8,19,9,37,0,21,17,35,8,4,44,0,0,0,
4,63,67,18,17,11,34,9,41,64,32,18,92,102,40,46,20,46,10,10,
48,33,25,25,37,48,3,32,44,9,21,11,24,2,19,17,33,36,9,14,
5,15,8,7,12,14,12,20,34,20,0,12,124,124,116,98,14,3,4,22,
0,22,22,6,11,54,7,69,63,88,18,30,10,12,20,32,80,48,22,1,
4,4,32,40,69,4,10,29,2,9,20,16,9,38,24,26,41,14,21,15,
16,51,18,22,16,11,39,10,9,0,7,37,27,5,125,124,115,25,33,43,
63,45,57,93,73,77,43,83,31,124,75,16,22,8,1,3,1,11,9,13,
41,43,39,45,49,95,23,25,65,11,21,25,35,45,53,49,55,59,39,63,
71,55,55,16,58,40,20,20,26,10,2,2,38,28,64,46,40,30,46,28,
34,26,20,28,88,72,62,54,60,24,8,4,1,13,102,58,12,1,26,2,
19,11,8,84,62,28,10,38,10,6,7,9,124,21,7,4,2,0,0,16,
24,6,20,26,44,13,3,23,11,36,21,23,17,0,4,11,25,11,27,11,
15,45,24,22,50,8,3,22,14,4,12,10,2,17,0,5,13,7,26,61,
25,32,29,0,13,3,22,13,17,8,12,45,19,59,46,52,58,24,8,16,
10,2,3,17,17,19,43,37,47,67,53,65,99,57,55,51,47,65,47,61,
59,41,55,12,8,6,2,31,17,19,53,33,47,51,87,63,73,81,27,23,
89,23,29,45,73,55,67,71,43,71,59,71,83,83,91,57,73,83,17,5,
22,0,50,68,1,10,28,36,10,34,64,8,0,64,3,59,101,125,125,125,
125,125,10,78,60,52,32,56,30,16,12,1,19,9,18,0,42,60,2,4,
20,28,12,24,50,14,2,64,3,59,101,125,125,125,125,125,0,0,0,0,
56,8,35,56,8,35,12,34,50,24,9,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,6,65,67,18,19,11,104,12,11,41,11,37,14,18,8,28,
7,26,8,4,22,33,43,37,47,60,0,34,15,2,19,3,22,15,37,19,
27,34,11,10,13,23,8,11,10,20,10,18,38,32,35,9,4,5,4,19,
22,11,6,38,3,32,34,14,61,20,7,51,19,67,23,2,9,10,1,0,
38,4,3,18,34,17,17,4,81,37,2,63,3,27,32,0,39,54,2,3,
51,58,31,61,2,77,6,34,36,26,34,24,2,30,38,39,7,16,6,2,
29,9,17,25,11,25,43,15,21,91,47,33,59,49,51,34,50,30,26,26,
8,3,8,17,29,15,43,65,65,111,11,13,47,25,39,47,57,63,73,83,
79,111,39,81,97,69,77,0,72,52,34,12,10,3,7,15,9,18,98,64,
48,34,78,30,20,2,4,2,92,56,32,16,40,14,2,3,7,11,58,24,
10,1,20,0,11,11,10,86,50,30,18,50,18,14,12,2,124,29,11,8,
5,9,2,16,18,2,18,30,40,25,15,23,11,38,19,23,7,8,34,45,
27,18,26,47,49,45,21,11,14,13,3,7,2,16,25,11,9,4,39,19,
33,35,6,73,25,4,13,32,13,3,50,11,17,3,42,37,25,73,40,58,
60,38,10,40,32,20,20,16,12,4,31,37,51,27,19,41,81,41,37,43,
37,33,17,17,45,55,31,16,14,18,2,29,7,13,43,23,37,37,67,63,
57,53,11,3,43,13,17,37,49,51,53,55,57,67,89,81,95,95,99,69,
89,97,27,2,11,12,18,18,114,40,36,9,56,124,106,124,34,38,22,43,
89,99,109,125,125,125,7,86,54,36,18,26,4,5,9,11,15,1,22,6,
40,30,14,24,30,36,38,20,44,36,1,42,28,2,11,23,35,87,89,77,
0,0,0,0,56,8,35,56,8,35,12,34,50,24,9,33,43,46,118,24,
36,13,14,34,1,17,2,31,71,11,73,125,125,125,98,0,5,14,34,1,
41,12,22,0,1,11,15,1,33,31,57,10,5,13,8,19,9,37,0,21,
17,35,8,4,44,0,0,0,6,65,67,18,19,11,32,9,43,68,34,20,
94,106,42,48,24,48,12,12,52,33,25,25,37,48,3,34,48,9,21,9,
28,2,19,17,35,36,9,14,3,13,10,5,12,14,12,22,36,20,2,14,
124,124,122,102,14,3,4,22,1,22,22,6,11,58,7,73,67,92,18,30,
10,12,20,32,84,48,22,1,2,4,34,42,73,4,10,29,0,13,18,16,
11,38,24,24,43,14,23,17,14,51,16,20,14,15,47,6,13,3,13,43,
31,9,125,124,123,29,37,47,69,49,65,101,81,83,47,89,35,124,79,12,
16,2,7,9,7,15,15,17,45,47,43,49,53,99,23,27,67,13,25,27,
37,47,57,53,59,61,39,65,73,57,55,18,60,40,20,20,28,12,4,2,
42,30,64,46,40,32,48,30,38,30,22,30,88,72,62,56,62,24,8,4,
0,15,104,58,10,1,26,2,19,11,8,84,60,26,8,38,10,6,7,9,
124,19,5,6,4,4,2,20,28,8,22,30,48,13,3,23,9,38,21,23,
17,2,4,11,25,11,29,11,15,45,24,22,52,8,5,22,14,2,12,10,
2,19,0,5,13,7,28,63,27,32,33,1,15,5,20,15,19,8,12,47,
19,63,44,48,56,20,4,12,6,1,7,23,23,25,49,43,51,75,61,75,
109,65,63,57,53,71,51,65,61,43,57,8,4,0,3,37,23,25,59,39,
53,57,93,67,77,85,29,25,93,27,31,49,77,59,71,75,47,75,63,73,
85,85,93,61,75,85,17,5,22,0,52,70,1,10,30,38,10,34,64,8,
1,62,7,65,107,125,125,125,125,125,10,78,60,52,32,58,30,16,12,1,
19,9,18,0,42,60,2,4,20,28,12,24,52,14,0,62,7,65,107,125,
125,125,125,125,0,0,0,0,54,8,35,54,8,35,16,36,52,24,9,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,8,65,67,18,21,11,104,12,
11,39,9,37,14,20,12,32,3,30,12,6,26,31,41,35,45,62,2,36,
13,2,17,1,26,15,35,19,23,36,11,10,9,23,10,11,10,22,12,20,
38,32,35,9,6,5,4,17,22,11,6,38,5,32,34,14,65,20,7,53,
21,67,21,4,7,12,0,2,40,6,3,20,36,17,17,4,83,35,4,63,
1,27,34,0,41,56,2,3,53,60,33,63,2,77,4,32,36,24,32,22,
2,30,38,41,9,16,6,2,29,9,19,27,13,27,45,15,21,93,49,33,
61,51,51,32,48,28,24,24,4,7,4,21,33,19,47,71,69,117,13,17,
49,29,43,51,61,67,77,87,83,115,39,85,99,69,77,0,74,52,34,14,
10,3,5,15,7,18,98,64,50,34,80,32,22,4,6,4,94,58,34,18,
42,16,2,1,5,9,62,26,12,0,22,2,9,9,12,86,52,32,18,52,
20,16,14,4,124,27,9,10,5,9,2,18,20,2,18,32,42,25,15,23,
11,38,21,23,9,8,34,47,29,18,26,47,51,47,19,9,16,13,1,7,
4,18,25,11,9,6,39,19,33,35,8,73,25,4,13,34,13,3,52,11,
17,3,44,39,25,73,38,58,60,38,8,38,30,18,20,14,10,4,31,39,
53,29,21,45,85,43,39,43,37,33,15,15,45,57,29,12,10,14,1,33,
11,17,47,27,41,41,71,67,59,55,15,5,45,17,21,41,53,55,57,59,
61,71,93,83,99,99,101,73,93,101,25,6,7,14,20,20,118,42,38,9,
58,124,108,124,36,36,20,47,95,103,115,125,125,125,7,86,54,36,18,28,
4,5,9,9,13,0,24,8,44,32,16,26,32,38,40,20,46,36,1,40,
26,0,13,27,39,91,93,77,0,0,0,0,54,8,35,54,8,35,16,36,
52,24,9,35,47,44,120,24,40,13,16,36,1,19,2,31,73,13,77,125,
125,125,104,2,3,16,36,1,41,14,22,0,0,11,13,1,33,31,57,10,
5,11,8,19,9,37,0,21,17,33,8,4,44,0,0,0,8,65,67,18,
21,11,30,9,43,72,38,22,98,110,46,50,28,52,14,16,58,33,25,25,
35,48,3,36,52,7,19,7,32,2,19,17,35,36,9,14,1,11,12,3,
14,16,14,24,40,22,6,16,124,124,124,108,16,3,6,24,1,22,22,8,
9,64,7,77,69,98,18,30,10,12,20,34,88,50,22,1,2,4,36,44,
75,6,10,29,1,15,16,16,13,38,24,24,45,16,25,17,12,51,16,20,
14,19,53,4,15,7,17,47,35,13,125,124,125,33,41,51,75,53,71,109,
89,87,51,95,39,124,83,8,12,1,11,13,11,19,19,21,49,51,45,51,
55,103,23,27,67,13,27,29,39,49,59,55,63,63,39,67,75,57,53,20,
62,40,20,20,30,14,6,4,48,32,64,46,40,34,50,32,42,34,26,32,
90,74,64,58,64,24,10,4,2,15,106,58,8,1,28,4,19,9,8,84,
60,24,6,38,10,6,7,7,124,17,3,10,8,8,4,24,32,10,26,34,
52,11,1,21,7,42,19,21,15,4,6,11,25,11,31,11,15,45,24,24,
54,10,5,24,14,2,12,10,2,21,0,3,11,7,30,63,29,32,35,3,
15,5,20,15,21,8,12,49,19,65,42,46,56,18,0,8,2,5,11,27,
29,31,55,49,55,83,69,83,119,71,69,63,57,75,53,67,63,43,59,4,
0,3,7,41,27,29,65,43,57,61,97,71,81,89,29,27,95,29,33,53,
81,61,73,79,49,79,65,73,87,85,95,65,77,87,17,3,24,0,54,74,
0,12,32,40,10,36,66,8,1,60,11,69,113,125,125,125,125,125,10,78,
60,54,34,60,32,18,14,1,19,9,18,2,44,62,2,6,20,28,12,26,
54,14,0,60,11,69,113,125,125,125,125,125,0,0,0,0,52,8,35,52,
8,35,20,40,52,24,11,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
8,65,67,20,23,11,104,12,11,37,7,37,16,24,14,36,1,32,14,10,
30,29,39,33,45,64,2,38,11,2,17,0,30,15,35,17,21,36,9,12,
7,21,10,11,12,22,12,22,40,34,37,11,6,5,4,17,22,13,4,38,
5,32,34,12,69,20,9,57,23,69,19,6,5,14,2,4,42,8,1,22,
38,17,17,6,85,35,6,63,1,27,34,0,43,58,2,3,57,62,33,65,
2,79,0,30,34,22,30,20,0,28,38,43,11,16,6,2,31,11,19,29,
13,29,47,17,23,97,51,35,63,53,51,28,46,24,20,20,0,13,0,27,
37,23,53,75,73,121,17,19,53,35,47,55,65,73,81,93,87,121,41,87,
103,71,77,0,74,54,34,14,10,3,5,15,7,20,100,64,50,34,82,32,
24,4,8,6,96,60,34,18,44,16,4,1,3,9,64,26,12,0,24,4,
9,7,12,88,52,32,18,54,22,18,16,6,124,27,9,10,5,9,2,18,
20,4,18,32,42,25,15,23,13,40,23,25,11,6,34,49,31,16,26,49,
53,47,17,9,18,11,1,5,4,20,25,11,9,6,41,19,33,33,10,73,
25,6,13,34,13,3,54,11,17,3,46,39,27,75,36,58,58,36,6,36,
28,16,18,12,8,2,33,41,55,33,25,47,89,45,41,45,39,35,15,15,
45,57,27,8,6,10,7,39,15,21,53,31,45,45,75,71,63,57,19,9,
47,21,25,45,57,59,61,63,65,75,99,87,103,103,103,77,97,103,23,8,
5,14,22,22,122,44,40,9,60,124,112,124,36,32,16,53,101,109,121,125,
125,125,7,86,54,36,18,28,4,5,9,9,11,2,26,10,46,34,16,28,
34,40,42,22,46,38,1,36,22,3,17,31,43,95,97,79,0,0,0,0,
52,8,35,52,8,35,20,40,52,24,11,37,51,42,120,24,44,13,16,38,
3,19,2,33,77,15,83,125,125,125,110,4,3,16,38,3,41,16,22,1,
0,9,11,1,33,31,57,10,5,11,8,19,7,35,0,21,17,33,10,4,
44,0,0,0,8,65,67,20,23,11,28,11,43,78,40,24,102,114,48,54,
30,54,18,18,62,33,23,23,35,48,3,38,56,7,17,7,36,2,21,19,
37,36,9,16,1,9,14,3,16,16,16,28,42,24,8,18,124,124,124,114,
16,1,6,24,1,22,24,8,9,68,7,81,73,104,18,32,10,12,20,34,
90,52,24,3,2,4,36,44,77,6,10,31,1,17,16,14,13,38,24,24,
47,16,27,19,12,51,16,18,12,23,59,2,19,11,21,51,41,17,125,124,
125,37,45,57,81,59,77,119,97,93,55,103,43,124,85,4,8,5,15,17,
15,23,23,25,55,55,49,55,59,107,23,27,69,15,29,31,43,51,61,57,
65,65,41,69,75,59,51,24,64,42,20,22,30,14,6,6,52,36,64,48,
42,34,52,34,44,36,30,32,92,76,66,58,66,26,10,6,2,15,106,58,
8,3,28,4,19,9,8,82,58,22,4,38,10,8,7,7,124,13,0,12,
12,10,6,26,34,12,30,36,56,9,0,21,5,46,19,21,15,4,6,11,
27,11,31,11,15,47,26,24,56,10,5,24,14,2,12,10,2,21,0,3,
11,7,30,65,31,32,37,3,17,7,20,17,23,8,12,51,19,67,40,44,
54,14,3,4,1,11,17,33,35,37,61,53,59,93,77,91,125,77,75,67,
61,81,57,71,67,45,59,1,5,9,11,47,33,35,71,47,63,65,103,75,
85,91,31,27,99,31,37,55,85,65,77,81,51,81,67,75,91,87,95,67,
81,91,15,3,26,2,56,76,0,14,32,40,10,36,68,8,1,58,15,75,
119,125,125,125,125,125,12,78,60,54,34,60,32,18,14,0,19,9,20,2,
46,64,2,6,22,30,12,26,54,14,0,58,15,75,119,125,125,125,125,125,
0,0,0,0,50,8,37,50,8,37,24,42,54,24,11,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,10,65,67,20,23,13,104,12,11,35,7,37,
16,26,18,40,2,34,18,12,34,27,37,31,43,66,2,40,11,4,15,0,
34,15,33,17,19,36,9,12,3,21,12,9,12,22,12,24,40,34,37,11,
6,5,4,17,22,13,4,38,7,32,34,12,73,20,9,61,25,71,19,8,
5,14,4,4,44,8,1,22,42,17,17,6,87,33,8,63,1,27,36,2,
45,58,2,3,59,64,35,67,2,81,1,28,34,22,28,20,0,26,36,45,
13,16,6,2,31,13,21,31,15,29,49,19,23,101,53,35,65,55,51,26,
42,22,16,16,3,17,3,31,43,27,57,81,79,125,21,23,55,39,53,61,
71,77,87,97,93,125,43,91,105,73,77,2,76,54,36,14,10,3,5,15,
5,20,100,66,50,34,84,34,24,6,8,8,98,60,36,18,46,18,4,0,
1,7,66,28,14,0,24,4,7,3,14,88,52,32,20,54,22,20,16,8,
124,25,7,12,5,9,2,18,20,4,20,32,44,25,15,25,13,40,25,27,
13,4,34,51,33,16,26,49,55,49,15,7,20,11,0,5,6,20,25,9,
7,8,41,19,33,33,12,73,25,6,13,36,13,3,56,13,17,3,46,41,
27,77,34,56,58,34,4,36,28,14,16,12,6,0,35,43,57,35,27,51,
93,49,45,47,39,35,15,15,43,59,25,4,2,6,11,45,19,25,57,35,
51,49,81,75,65,57,21,11,51,25,31,49,61,63,65,67,71,79,103,91,
107,105,107,81,101,107,21,10,3,16,24,24,124,46,42,9,62,124,114,124,
38,30,14,57,107,115,125,125,125,125,5,86,54,36,18,28,4,5,9,7,
9,2,28,12,48,34,18,30,34,40,42,22,48,38,1,34,20,7,21,33,
45,101,99,81,0,0,0,0,50,8,37,50,8,37,24,42,54,24,11,41,
55,40,120,24,46,13,18,38,3,21,4,33,79,19,87,125,125,125,114,6,
3,18,38,3,43,16,22,1,0,9,11,1,33,29,55,10,3,9,8,17,
7,35,0,21,17,33,10,4,44,0,0,0,10,65,67,20,23,13,28,11,
43,82,42,26,104,120,52,56,34,58,20,20,66,33,23,23,35,48,3,40,
62,7,15,5,40,0,21,19,37,38,9,16,0,9,14,1,18,18,18,30,
46,24,10,20,124,124,124,120,16,1,6,26,1,22,24,10,7,72,5,85,
77,110,18,32,10,12,22,36,94,54,24,3,2,4,38,46,79,6,10,31,
3,19,14,14,15,38,24,24,51,16,29,21,10,51,16,18,12,27,65,0,
23,17,27,55,45,21,125,124,125,41,47,61,89,63,83,125,107,99,59,109,
47,124,89,0,4,9,21,23,19,29,27,29,59,61,53,59,61,109,23,27,
69,17,31,33,45,53,63,59,69,67,41,71,77,59,51,26,66,42,20,22,
32,16,8,6,56,38,66,48,42,36,54,36,48,40,34,34,92,76,66,60,
68,26,10,6,4,15,108,58,6,3,28,4,19,7,6,82,58,20,2,36,
10,8,7,7,124,11,2,14,14,14,8,30,38,14,32,40,60,9,2,19,
3,50,17,21,15,6,8,11,27,11,33,11,15,47,26,26,58,10,5,26,
16,2,14,12,2,23,0,3,11,7,32,67,33,32,39,5,19,7,20,19,
23,8,10,55,21,69,36,42,52,12,7,0,5,15,21,37,41,41,67,59,
63,101,85,99,125,85,81,73,65,85,61,75,69,47,61,5,9,13,17,53,
37,39,77,53,67,71,109,79,87,95,33,29,101,35,39,59,89,67,81,85,
53,85,69,77,93,89,97,71,83,93,15,1,26,2,58,78,0,14,34,42,
10,38,70,8,1,56,19,79,125,125,125,125,125,125,12,78,60,54,34,62,
34,18,14,0,17,7,20,4,48,66,4,8,22,30,12,26,56,14,0,56,
19,79,125,125,125,125,125,125,0,0,0,0,46,8,37,46,8,37,26,46,
54,24,13,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,10,67,67,22,
25,13,104,12,11,33,5,37,18,28,22,44,4,36,22,14,38,25,37,29,
41,66,2,42,9,4,15,2,38,15,33,15,17,36,9,14,1,19,14,9,
12,22,12,24,42,36,39,11,6,5,4,17,22,15,2,38,9,32,34,12,
77,20,11,65,27,73,17,10,3,16,4,6,46,10,0,24,44,17,17,6,
89,33,10,63,1,27,38,2,47,60,2,3,61,66,35,69,2,83,5,26,
32,20,26,18,1,24,36,49,15,14,6,2,33,15,23,33,17,31,51,21,
25,105,55,37,67,57,51,22,40,18,12,12,7,21,7,37,47,31,63,85,
83,125,25,27,59,43,57,65,75,81,91,103,97,125,45,95,107,75,77,2,
76,54,36,14,10,3,5,15,5,20,100,66,50,34,86,34,26,6,10,8,
100,62,36,18,46,18,6,0,0,5,68,30,14,0,26,6,5,1,14,88,
52,32,20,56,24,20,18,10,124,25,7,12,5,9,2,18,20,4,20,32,
44,25,15,25,15,42,27,29,15,2,34,55,35,16,26,51,57,49,15,5,
22,9,0,3,6,22,27,9,7,8,43,19,33,31,14,73,25,6,13,38,
13,3,58,13,19,3,48,43,27,79,32,56,56,32,2,34,26,12,14,10,
4,1,37,45,59,39,29,53,97,51,47,49,41,37,15,15,43,59,25,1,
3,2,15,51,23,29,63,39,55,53,85,79,69,59,25,15,53,29,35,53,
65,69,69,71,75,83,109,95,111,109,109,85,105,109,19,12,1,18,26,26,
124,48,44,9,64,124,118,124,40,26,10,63,113,121,125,125,125,125,5,86,
54,36,18,28,4,5,9,7,7,4,30,12,50,36,18,32,36,42,44,22,
48,38,1,32,16,11,25,37,49,105,103,83,0,0,0,0,46,8,37,46,
8,37,26,46,54,24,13,43,59,38,120,22,50,13,18,40,3,21,4,35,
83,21,93,125,125,125,120,8,3,18,40,3,43,18,22,3,0,9,9,1,
33,29,55,10,3,9,8,17,5,35,0,21,17,33,10,4,44,0,0,0,
10,67,67,22,25,13,26,13,43,88,44,28,108,124,54,60,38,60,22,22,
70,33,23,21,35,48,3,42,66,7,15,5,44,0,23,21,39,38,9,18,
0,7,16,1,20,18,18,34,48,26,12,22,124,124,124,124,16,1,6,26,
1,22,26,10,7,76,5,89,81,114,18,32,10,12,22,36,96,56,24,3,
2,4,38,48,81,6,10,33,3,21,14,14,15,38,24,24,53,16,31,23,
10,51,14,16,10,31,73,1,27,21,31,59,51,25,125,124,125,45,51,65,
95,69,91,125,115,105,63,117,51,124,93,3,0,15,25,27,23,33,31,33,
63,65,57,63,65,113,23,27,71,19,33,35,47,55,67,61,73,69,43,73,
79,61,49,30,68,44,20,22,34,16,8,8,60,40,66,48,44,38,56,38,
50,42,36,36,94,78,68,60,70,28,10,6,4,15,108,58,4,3,28,4,
19,7,6,80,56,18,0,36,10,8,7,7,124,9,6,16,18,16,10,34,
42,16,36,44,64,7,4,19,1,52,17,21,15,6,8,11,27,11,33,11,
15,49,28,26,60,10,5,26,16,2,14,12,2,23,0,3,11,7,32,69,
35,32,41,7,21,9,20,21,25,8,10,57,21,71,34,40,50,8,11,3,
9,19,27,43,47,47,73,63,67,109,93,107,125,91,89,77,71,91,65,79,
73,49,63,9,15,19,21,59,43,45,83,57,73,75,115,83,91,97,35,31,
105,37,43,63,93,71,85,89,55,87,71,79,95,91,99,73,85,95,15,1,
28,4,60,80,0,16,34,42,10,38,72,8,1,54,23,85,125,125,125,125,
125,125,12,78,60,54,34,62,34,18,14,2,17,7,22,4,48,68,4,8,
22,30,12,26,56,14,0,54,23,85,125,125,125,125,125,125,0,0,0,0,
44,8,37,44,8,37,30,48,54,24,13,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,12,67,67,22,27,13,104,12,11,31,3,37,18,32,24,48,
8,38,24,18,42,23,35,27,41,68,2,44,7,4,13,4,42,15,33,15,
13,38,7,14,0,19,14,9,14,24,14,26,42,36,39,13,6,5,4,17,
22,15,0,38,9,32,34,10,81,20,11,67,29,75,15,12,1,18,6,8,
48,12,0,26,46,17,17,8,91,31,12,63,0,27,38,2,49,62,2,3,
65,68,37,71,2,83,7,24,32,18,24,16,3,24,36,51,17,14,6,2,
33,15,23,35,17,33,53,21,27,109,57,39,69,59,51,18,38,14,8,10,
11,27,11,41,51,35,67,91,87,125,29,29,63,49,61,69,79,87,95,109,
101,125,47,97,111,75,77,2,76,56,36,14,10,3,5,15,3,22,102,66,
50,34,88,36,28,6,12,10,102,64,36,20,48,20,6,2,2,5,72,30,
14,2,28,8,5,0,16,90,54,32,20,58,26,22,20,12,124,25,7,14,
5,9,2,18,20,6,20,34,46,25,15,25,17,42,29,31,17,2,34,57,
37,14,26,53,59,51,13,5,24,9,2,3,8,24,27,9,7,8,45,19,
33,31,16,73,25,8,13,38,13,3,60,13,19,3,50,43,29,79,30,56,
56,32,0,32,24,10,14,8,2,3,39,47,61,41,33,57,101,53,49,51,
43,37,15,13,43,61,23,5,7,1,21,55,27,33,67,43,59,57,89,83,
71,61,29,19,55,33,39,57,69,73,73,75,79,87,113,99,115,113,111,89,
109,113,17,16,0,18,28,28,124,50,46,9,66,124,120,124,40,24,6,67,
119,125,125,125,125,125,5,86,54,36,18,28,4,5,9,5,5,6,32,14,
52,38,20,34,38,44,46,24,50,40,1,28,14,13,27,41,53,109,107,85,
0,0,0,0,44,8,37,44,8,37,30,48,54,24,13,45,63,36,120,22,
54,13,18,42,5,23,4,37,87,23,97,125,125,125,124,10,1,18,42,5,
43,20,22,3,0,7,7,1,33,29,55,10,3,9,8,17,5,33,0,21,
17,33,12,4,44,0,0,0,12,67,67,22,27,13,24,13,43,92,46,30,
112,124,58,62,40,64,26,24,76,33,21,21,33,48,3,44,70,7,13,3,
48,0,23,21,39,38,9,18,2,5,18,0,22,20,20,36,52,28,16,24,
124,124,124,124,18,0,8,28,1,22,26,10,5,80,5,93,85,120,18,34,
10,12,22,38,100,58,26,5,2,4,40,48,83,8,10,33,5,23,12,12,
17,38,24,24,55,18,33,23,8,51,14,14,8,35,79,3,29,25,35,63,
55,29,125,124,125,49,55,71,101,73,97,125,123,109,67,123,55,124,95,7,
3,19,29,31,27,37,35,37,69,69,61,65,69,117,23,27,71,21,35,37,
51,57,69,63,75,71,43,75,79,63,47,32,70,44,20,24,34,18,10,10,
64,44,66,50,44,38,58,40,54,46,40,36,96,80,70,62,72,28,12,8,
6,15,110,58,4,5,28,4,19,5,6,80,54,16,1,36,10,10,7,5,
124,5,8,20,22,20,12,36,44,18,40,46,68,5,6,17,0,56,17,21,
13,8,10,11,29,11,35,11,15,49,28,26,62,10,5,26,16,2,14,12,
2,25,0,3,11,7,34,71,37,32,43,7,21,11,20,21,27,8,10,59,
21,73,32,38,48,4,15,7,13,25,31,49,53,53,79,69,71,119,101,115,
125,97,95,83,75,95,69,81,75,49,63,15,19,23,25,65,49,49,89,61,
77,79,121,87,95,101,35,31,109,39,45,65,97,75,89,91,57,91,73,79,
99,93,99,77,89,99,13,1,30,4,62,82,2,18,36,44,10,40,74,8,
1,52,27,91,125,125,125,125,125,125,14,78,60,54,34,64,34,20,16,2,
17,7,22,4,50,70,4,8,24,32,12,28,58,14,0,52,27,91,125,125,
125,125,125,125,0,0,0,0,42,8,37,42,8,37,34,52,56,24,15,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,12,67,67,24,29,13,104,12,
11,29,1,37,20,34,28,52,10,40,28,20,46,21,33,25,39,70,2,46,
5,4,13,4,46,15,31,13,11,38,7,16,4,17,16,9,14,24,14,28,
44,38,41,13,6,5,4,17,22,17,0,38,11,32,34,10,85,20,13,71,
31,77,13,14,0,20,8,8,50,12,2,28,48,17,17,8,93,31,14,63,
0,27,40,2,51,64,2,3,67,70,37,73,2,85,11,22,30,16,22,14,
3,22,34,53,19,14,6,2,35,17,25,37,19,35,55,23,27,113,59,39,
71,61,51,16,34,12,4,6,15,31,15,47,57,39,73,95,93,125,33,33,
65,53,65,75,85,91,101,113,105,125,49,101,113,77,77,2,78,56,36,14,
10,3,5,15,3,22,102,66,50,34,90,36,28,8,12,12,104,64,38,20,
50,20,8,2,4,3,74,32,16,2,30,10,3,2,16,90,54,32,20,60,
26,24,22,14,124,23,5,14,5,9,2,18,20,6,20,34,46,25,15,25,
17,44,31,33,19,0,34,59,39,14,26,53,61,51,11,3,26,7,2,1,
8,26,27,9,7,10,45,19,33,29,18,73,25,8,13,40,13,3,62,13,
19,3,52,45,29,81,28,54,54,30,1,30,22,8,12,6,0,5,41,49,
63,45,35,59,105,57,51,53,43,39,15,13,43,61,21,9,11,5,25,61,
31,37,73,47,63,61,95,87,75,63,33,21,59,37,43,61,73,77,77,79,
83,91,119,103,119,117,113,93,113,115,15,18,2,20,30,30,124,52,48,9,
68,124,124,124,42,20,4,73,125,125,125,125,125,125,5,86,54,36,18,28,
4,5,9,5,3,8,34,16,54,38,20,36,38,44,46,24,50,40,1,26,
10,17,31,45,57,113,111,87,0,0,0,0,42,8,37,42,8,37,34,52,
56,24,15,49,67,34,120,22,58,13,20,44,5,23,4,37,89,25,103,125,
125,125,124,12,1,20,44,5,45,22,22,5,0,7,7,1,33,29,55,10,
3,7,8,17,3,33,0,21,17,33,12,4,44,0,0,0,12,67,67,24,
29,13,22,15,43,98,48,32,114,124,60,66,44,66,28,26,80,33,21,19,
33,48,3,46,74,7,11,3,52,0,25,23,41,38,9,20,2,3,20,0,
24,20,22,40,54,28,18,26,124,124,124,124,18,0,8,28,1,22,28,12,
5,84,5,97,89,124,18,34,10,12,22,38,102,60,26,5,2,4,40,50,
85,8,10,35,5,25,12,12,17,38,24,24,57,18,35,25,8,51,14,14,
8,39,85,5,33,29,41,67,61,33,125,124,125,53,59,75,107,79,103,125,
125,115,71,125,59,124,99,11,7,23,35,37,31,41,39,41,73,73,65,69,
71,121,23,27,73,23,37,39,53,59,71,65,79,73,45,77,81,63,47,36,
72,46,20,24,36,18,10,10,68,46,66,50,46,40,60,42,56,48,44,38,
96,80,70,62,74,30,12,8,6,15,110,58,2,5,28,4,19,5,6,78,
54,14,3,36,10,10,7,5,124,3,12,22,24,22,14,40,48,20,42,50,
72,5,8,17,2,60,15,21,13,8,10,11,29,11,35,11,15,51,30,28,
64,10,5,28,16,2,14,12,2,25,0,3,11,7,34,73,39,32,45,9,
23,11,20,23,29,8,10,61,21,75,30,36,46,2,19,11,17,29,37,53,
59,59,85,73,75,125,109,123,125,105,101,87,79,101,73,85,79,51,65,19,
25,29,31,71,53,55,95,67,83,85,125,91,99,103,37,33,111,43,49,69,
101,77,93,95,59,93,75,81,101,95,101,79,91,101,13,0,30,6,64,84,
2,18,36,44,10,40,76,8,1,50,31,95,125,125,125,125,125,125,14,78,
60,54,34,64,36,20,16,4,17,7,24,6,52,72,4,10,24,32,12,28,
58,14,0,50,31,95,125,125,125,125,125,125,0,0,0,0,40,8,37,40,
8,37,38,54,56,24,15,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
14,67,67,24,31,13,104,12,11,27,0,37,20,36,32,56,14,42,32,22,
50,19,31,23,37,72,2,48,3,4,11,6,50,15,31,13,9,38,7,16,
6,17,18,9,14,24,14,30,44,38,41,13,6,5,4,17,22,17,1,38,
13,32,34,10,89,20,13,75,33,79,11,16,2,22,10,10,52,14,2,30,
50,17,17,8,95,29,16,63,0,27,42,2,53,66,2,3,69,72,39,75,
2,87,13,20,30,14,20,12,5,20,34,55,21,14,6,2,35,19,27,39,
21,37,57,25,29,117,61,41,73,63,51,12,32,8,0,2,19,35,19,51,
61,43,77,101,97,125,37,37,69,57,69,79,89,95,105,119,109,125,51,105,
115,79,77,2,78,56,36,14,10,3,5,15,1,22,102,66,50,34,92,38,
30,8,14,14,106,66,38,20,52,22,8,4,6,1,76,34,16,2,32,12,
1,4,18,90,54,32,20,62,28,26,24,16,124,23,5,16,5,9,2,18,
20,6,20,34,48,25,15,25,19,44,33,35,21,1,34,61,41,14,26,55,
63,53,9,1,28,7,4,1,10,28,27,9,7,10,47,19,33,29,20,73,
25,8,13,42,13,3,64,13,19,3,54,47,29,83,26,54,54,28,3,28,
20,6,10,4,1,7,43,51,65,47,37,63,109,59,53,55,45,39,15,13,
43,63,19,13,15,9,29,67,35,41,77,51,67,65,99,91,77,65,37,25,
61,41,47,65,77,81,81,83,87,95,123,107,123,121,115,97,117,119,13,20,
4,22,32,32,124,54,50,9,70,124,124,124,44,18,0,77,125,125,125,125,
125,125,5,86,54,36,18,28,4,5,9,3,1,10,36,18,56,40,22,38,
40,46,48,24,52,40,1,24,8,21,35,49,61,117,115,89,0,0,0,0,
40,8,37,40,8,37,38,54,56,24,15,51,71,32,120,22,62,13,20,46,
5,25,4,39,93,27,107,125,125,125,124,14,1,20,46,5,45,24,22,5,
0,7,5,1,33,29,55,10,3,7,8,17,3,33,0,21,17,33,12,4,
44,0,0,0,14,67,67,24,31,13,20,15,43,102,50,34,118,124,64,68,
48,70,30,28,84,33,21,19,33,48,3,48,78,7,9,1,56,0,25,23,
41,38,9,20,4,1,22,2,26,22,24,42,58,30,20,28,124,124,124,124,
18,0,8,30,1,22,28,12,3,88,5,101,93,124,18,34,10,12,22,40,
106,62,26,5,2,4,42,52,87,8,10,35,7,27,10,12,19,38,24,24,
59,18,37,27,6,51,14,12,6,43,91,7,37,33,45,71,65,37,125,124,
125,57,63,79,113,83,109,125,125,121,75,125,63,124,103,15,11,27,39,41,
35,45,43,45,77,77,69,73,75,125,23,27,73,25,39,41,55,61,73,67,
83,75,45,79,83,65,45,38,74,46,20,24,38,20,12,12,72,48,66,50,
46,42,62,44,60,52,48,40,98,82,72,64,76,30,12,8,8,15,112,58,
0,5,28,4,19,3,6,78,52,12,5,36,10,10,7,5,124,1,14,24,
28,26,16,44,52,22,46,54,76,3,10,15,4,64,15,21,13,10,12,11,
29,11,37,11,15,51,30,28,66,10,5,28,16,2,14,12,2,27,0,3,
11,7,36,75,41,32,47,11,25,13,20,25,31,8,10,63,21,77,28,34,
44,1,23,15,21,33,41,59,65,65,91,79,79,125,117,125,125,111,107,93,
83,105,77,89,81,53,67,23,29,33,35,77,59,59,101,71,87,89,125,95,
103,107,39,35,115,45,51,73,105,81,97,99,61,97,77,83,103,97,103,83,
93,103,13,0,32,6,66,86,2,20,38,46,10,42,78,8,1,48,35,101,
125,125,125,125,125,125,14,78,60,54,34,66,36,20,16,4,17,7,24,6,
54,74,4,10,24,32,12,28,60,14,0,48,35,101,125,125,125,125,125,125,
0,0,0,0,36,6,39,36,6,39,40,56,56,24,17,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,14,69,67,24,33,15,104,10,11,25,0,37,
20,38,34,58,16,44,34,24,52,17,31,21,37,72,2,48,3,4,11,6,
52,15,31,13,7,38,7,16,8,17,18,9,14,24,14,30,44,38,43,15,
6,7,4,17,20,19,3,38,15,30,34,8,93,18,15,79,35,81,11,16,
2,22,10,10,54,14,2,30,52,19,17,8,99,29,16,63,0,29,42,2,
55,66,2,3,73,72,41,77,2,89,17,18,28,12,18,10,7,18,32,59,
23,12,4,2,37,21,29,41,23,39,59,27,31,121,65,43,77,67,51,8,
28,4,3,1,25,41,25,57,67,49,83,107,103,125,41,41,73,63,75,85,
95,101,111,125,115,125,53,109,119,81,79,2,78,56,36,14,10,5,5,15,
1,22,102,66,50,34,94,38,30,8,14,14,106,66,38,20,52,22,8,4,
8,1,78,34,16,2,32,12,1,6,18,90,54,32,20,62,28,26,24,16,
124,23,5,16,5,9,2,18,20,6,20,34,48,25,15,27,21,44,35,37,
23,3,32,65,45,12,24,57,67,55,9,1,30,7,4,1,10,28,29,9,
7,10,49,19,33,29,20,75,25,8,13,42,15,3,64,15,21,3,54,49,
31,85,24,52,52,26,7,26,18,4,8,2,3,9,45,55,69,51,41,67,
113,63,57,57,47,41,15,13,43,65,19,19,21,13,35,73,41,47,83,57,
73,71,105,97,81,67,41,29,65,45,53,71,83,87,87,87,93,101,125,111,
125,125,119,101,121,123,11,22,6,22,32,32,124,54,50,9,70,124,124,124,
44,14,3,83,125,125,125,125,125,125,5,86,52,34,18,28,4,7,9,3,
1,10,36,18,58,40,22,38,40,46,48,24,52,40,3,20,4,25,39,53,
65,123,119,91,0,0,0,0,36,6,39,36,6,39,40,56,56,24,17,55,
77,30,120,20,64,15,20,46,7,27,4,41,97,31,113,125,125,125,124,14,
1,20,46,7,47,24,22,7,0,7,5,3,35,29,55,8,3,7,8,17,
3,33,0,21,19,33,12,4,44,0,0,0,14,69,67,24,33,15,18,17,
45,106,52,36,120,124,66,70,50,72,32,30,88,33,21,19,33,48,3,48,
82,7,9,1,58,1,27,25,43,38,9,20,4,1,22,2,26,22,24,44,
60,30,22,30,124,124,124,124,18,0,8,30,3,22,28,12,3,92,5,105,
97,124,18,34,10,12,22,40,108,62,26,7,0,4,42,52,91,8,10,37,
9,31,8,10,21,38,24,22,63,18,39,29,4,51,12,10,4,49,99,11,
41,39,51,77,71,41,125,124,125,63,67,85,121,89,117,125,125,125,79,125,
67,124,107,21,17,33,45,47,41,51,49,49,83,83,73,77,79,125,23,29,
75,27,43,45,59,65,77,71,87,77,47,81,85,67,45,40,74,46,20,24,
38,20,12,12,76,50,66,50,46,42,62,46,62,54,50,40,98,82,72,64,
78,30,12,8,8,17,112,56,1,7,28,4,19,3,4,76,50,8,7,34,
10,10,7,5,124,0,16,26,30,28,18,46,54,24,48,56,80,3,10,15,
6,66,15,21,13,10,12,11,31,13,39,11,17,53,30,28,68,10,7,28,
16,0,14,12,2,29,0,3,11,7,36,77,43,32,51,13,27,15,18,27,
33,8,8,67,23,81,24,30,42,5,27,21,27,39,47,65,71,71,99,85,
83,125,125,125,125,119,115,99,89,111,81,93,85,55,69,29,35,39,41,83,
65,65,109,77,93,95,125,99,107,111,41,37,119,49,55,77,111,85,101,103,
65,101,81,85,107,99,105,87,97,107,13,0,32,6,68,88,2,20,38,46,
10,42,78,8,3,44,39,107,125,125,125,125,125,125,14,78,60,54,34,66,
36,20,16,4,17,7,24,6,54,74,4,10,24,32,12,28,60,12,1,44,
39,107,125,125,125,125,125,125,0,0,0,0,34,6,39,34,6,39,44,60,
58,26,17,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,16,69,67,26,
33,15,104,10,11,21,2,37,22,42,38,62,20,48,38,28,56,13,29,19,
35,74,4,50,1,6,9,8,56,13,29,11,3,40,5,18,12,15,20,7,
16,26,16,32,46,40,43,15,8,7,4,15,20,19,3,38,15,30,34,8,
95,18,15,81,37,81,9,18,4,24,12,12,56,16,4,32,56,19,17,10,
101,27,18,63,2,29,44,4,55,68,2,3,75,74,41,79,2,89,19,18,
28,12,18,10,7,18,32,61,23,12,4,2,37,21,29,41,23,39,61,27,
31,123,67,43,79,69,51,6,26,2,5,3,29,45,29,61,71,53,87,111,
107,125,43,43,75,67,79,89,99,105,115,125,119,125,53,111,121,81,79,4,
80,58,38,16,10,5,3,13,0,24,104,68,52,34,96,40,32,10,16,16,
108,68,40,22,54,24,10,6,12,0,82,36,18,4,34,14,0,10,20,92,
56,34,22,64,30,28,26,18,124,21,3,18,5,7,2,20,22,8,22,36,
50,23,15,27,21,46,35,37,25,3,32,67,47,12,24,57,69,55,7,0,
32,5,6,0,12,30,29,7,5,12,49,17,31,27,22,75,25,10,13,44,
15,3,66,15,21,1,56,49,31,85,24,52,52,26,9,26,18,4,8,2,
3,9,45,57,71,53,43,69,115,65,59,57,47,41,13,11,41,65,17,23,
25,17,39,77,45,51,87,61,77,75,109,101,83,67,43,31,67,47,57,75,
87,91,91,91,97,105,125,113,125,125,121,103,123,125,7,26,10,24,34,34,
124,56,52,9,72,124,124,124,46,12,5,87,125,125,125,125,125,125,3,88,
52,34,18,30,4,7,9,1,0,12,38,20,62,42,24,40,42,48,50,26,
54,42,3,18,2,27,41,55,67,125,121,91,0,0,0,0,34,6,39,34,
6,39,44,60,58,26,17,57,81,28,122,20,68,15,22,48,7,27,6,41,
99,33,117,125,125,125,124,16,0,22,48,7,47,26,22,7,2,5,3,3,
35,27,53,8,1,5,8,15,1,31,2,19,19,31,14,4,44,0,0,0,
16,69,67,26,33,15,18,17,45,112,56,40,124,124,70,74,54,76,36,34,
94,33,19,17,31,48,3,50,88,5,7,0,62,1,27,25,43,40,9,22,
6,0,24,4,28,24,26,48,64,32,26,34,124,124,124,124,20,2,10,32,
3,24,30,14,1,98,3,109,99,124,18,36,10,14,24,42,112,64,28,7,
0,4,44,54,93,10,10,37,9,33,8,10,21,38,24,22,65,20,39,29,
4,51,12,10,4,53,105,13,43,43,55,81,75,45,125,124,125,67,69,89,
125,93,123,125,125,125,83,125,71,124,109,25,21,37,49,51,45,55,53,53,
87,87,75,79,81,125,23,29,75,27,45,47,61,67,79,73,89,79,47,83,
85,67,43,44,76,48,20,26,40,22,14,14,82,54,68,52,48,44,64,50,
66,58,54,42,100,84,74,66,80,32,14,10,10,17,114,56,1,7,30,6,
19,1,4,76,50,6,9,34,12,12,5,3,124,4,20,30,34,32,22,50,
58,28,52,60,86,1,12,13,10,70,13,19,11,12,14,9,31,13,39,11,
17,53,32,30,70,12,7,30,18,0,16,14,2,29,2,1,9,5,38,77,
45,32,53,13,27,15,18,27,33,8,8,69,23,83,22,28,42,7,29,25,
31,43,51,69,75,75,105,89,87,125,125,125,125,125,121,103,93,115,83,95,
87,55,69,33,39,43,45,87,69,69,115,81,97,99,125,101,109,113,41,37,
121,51,57,79,115,87,103,105,67,103,83,85,109,99,105,89,99,109,11,2,
34,8,72,92,4,22,40,48,12,44,80,8,3,42,43,111,125,125,125,125,
125,125,16,78,62,56,36,68,38,22,18,6,15,5,26,8,56,76,6,12,
26,34,12,30,62,12,1,42,43,111,125,125,125,125,125,125,0,0,0,0,
32,6,39,32,6,39,48,62,58,26,17,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,18,69,67,26,35,15,104,10,11,19,4,37,22,44,42,66,
22,50,42,30,60,11,27,17,33,76,4,52,0,6,9,10,60,13,29,11,
1,40,5,18,14,15,22,7,16,26,16,34,46,40,45,15,8,7,4,15,
20,19,5,38,17,30,34,8,99,18,15,85,39,83,7,20,6,26,14,14,
58,18,4,34,58,19,17,10,103,27,20,63,2,29,46,4,57,70,2,3,
77,76,43,81,2,91,23,16,26,10,16,8,9,16,32,63,25,12,4,2,
37,23,31,43,25,41,63,29,33,125,69,45,81,71,51,2,24,1,9,7,
33,49,33,67,75,57,93,117,111,125,47,47,79,71,83,93,103,109,119,125,
123,125,55,115,123,83,79,4,80,58,38,16,10,5,3,13,2,24,104,68,
52,34,98,40,34,10,18,18,110,70,40,22,56,24,10,8,14,2,84,38,
18,4,36,16,2,12,20,92,56,34,22,66,32,30,28,20,124,21,3,18,
5,7,2,20,22,8,22,36,52,23,15,27,23,46,37,39,27,5,32,69,
49,12,24,59,71,57,5,2,34,5,6,0,14,32,29,7,5,12,51,17,
31,27,24,75,25,10,13,46,15,3,68,15,21,1,58,51,31,87,22,52,
52,24,11,24,16,2,6,0,5,11,47,59,73,57,45,73,119,67,61,59,
49,41,13,11,41,67,15,27,29,21,43,83,49,55,93,65,81,79,113,105,
85,69,47,35,69,51,61,79,91,95,95,95,101,109,125,117,125,125,123,107,
125,125,5,28,12,26,36,36,124,58,54,9,74,124,124,124,48,10,9,93,
125,125,125,125,125,125,3,88,52,34,18,30,4,7,9,0,2,14,40,22,
64,44,26,42,44,50,52,26,56,42,3,16,1,31,45,59,71,125,125,93,
0,0,0,0,32,6,39,32,6,39,48,62,58,26,17,59,85,26,122,20,
72,15,22,50,7,29,6,43,103,35,123,125,125,125,124,18,0,22,50,7,
47,28,22,9,2,5,1,3,35,27,53,8,1,5,8,15,1,31,2,19,
19,31,14,4,44,0,0,0,18,69,67,26,35,15,16,17,45,116,58,42,
124,124,72,76,58,78,38,36,98,33,19,17,31,48,3,52,92,5,5,2,
66,1,27,25,45,40,9,22,8,2,26,6,30,24,28,50,66,34,28,36,
124,124,124,124,20,2,10,32,3,24,30,14,1,102,3,113,103,124,18,36,
10,14,24,42,116,66,28,7,0,4,46,56,95,10,10,37,11,35,6,10,
23,38,24,22,67,20,41,31,2,51,12,8,2,57,111,15,47,47,59,85,
79,49,125,124,125,71,73,93,125,97,125,125,125,125,87,125,75,124,113,29,
25,41,53,55,49,59,57,57,91,91,79,83,85,125,23,29,77,29,47,49,
63,69,81,75,93,81,47,85,87,69,41,46,78,48,20,26,42,24,16,16,
86,56,68,52,48,46,66,52,70,62,58,44,102,86,76,68,82,32,14,10,
12,17,116,56,3,7,30,6,19,1,4,76,48,4,11,34,12,12,5,3,
124,6,22,32,38,36,24,54,62,30,56,64,90,0,14,13,12,74,13,19,
11,14,14,9,31,13,41,11,17,53,32,30,72,12,7,30,18,0,16,14,
2,31,2,1,9,5,40,79,47,32,55,15,29,17,18,29,35,8,8,71,
23,85,20,26,40,11,33,29,35,47,55,75,81,81,111,95,91,125,125,125,
125,125,125,109,97,121,87,99,89,57,71,37,43,49,49,93,75,75,121,85,
103,103,125,105,113,117,43,39,125,53,59,83,119,91,107,109,69,107,85,87,
111,101,107,93,101,111,11,2,36,8,74,94,4,24,42,50,12,44,82,8,
3,40,47,117,125,125,125,125,125,125,16,78,62,56,36,70,38,22,18,6,
15,5,26,8,58,78,6,12,26,34,12,30,64,12,1,40,47,117,125,125,
125,125,125,125,0,0,0,0,30,6,39,30,6,39,52,66,60,26,19,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,18,69,67,28,37,15,104,10,
11,17,6,37,24,46,46,70,26,52,46,32,64,9,25,15,31,78,4,54,
2,6,7,10,64,13,27,9,0,40,5,20,18,13,24,7,16,26,16,36,
48,42,45,15,8,7,4,15,20,21,5,38,19,30,34,8,103,18,17,89,
41,85,5,22,8,28,16,14,60,18,6,36,60,19,17,10,105,25,22,63,
2,29,48,4,59,72,2,3,79,78,43,83,2,93,25,14,26,8,14,6,
9,14,30,65,27,12,4,2,39,25,33,45,27,43,65,31,33,125,71,45,
83,73,51,0,20,3,13,11,37,53,37,71,81,61,97,121,117,125,51,51,
81,75,87,99,109,113,125,125,125,125,57,119,125,85,79,4,82,58,38,16,
10,5,3,13,2,24,104,68,52,34,100,42,34,12,18,20,112,70,42,22,
58,26,12,8,16,4,86,40,20,4,38,18,4,14,22,92,56,34,22,68,
32,32,30,22,124,19,1,20,5,7,2,20,22,8,22,36,52,23,15,27,
23,48,39,41,29,7,32,71,51,12,24,59,73,57,3,4,36,3,8,2,
14,34,29,7,5,14,51,17,31,25,26,75,25,10,13,48,15,3,70,15,
21,1,60,53,31,89,20,50,50,22,13,22,14,0,4,1,7,13,49,61,
75,59,47,75,123,71,63,61,49,43,13,11,41,67,13,31,33,25,47,89,
53,59,97,69,85,83,119,109,89,71,51,37,73,55,65,83,95,99,99,99,
105,113,125,121,125,125,125,111,125,125,3,30,14,28,38,38,124,60,56,9,
76,124,124,124,50,6,11,97,125,125,125,125,125,125,3,88,52,34,18,30,
4,7,9,0,4,16,42,24,66,44,26,44,44,50,52,26,56,42,3,14,
3,35,49,63,75,125,125,95,0,0,0,0,30,6,39,30,6,39,52,66,
60,26,19,63,89,24,122,20,76,15,24,52,7,29,6,43,105,37,125,125,
125,125,124,20,0,24,52,7,49,30,22,9,2,5,1,3,35,27,53,8,
1,3,8,15,0,31,2,19,19,31,14,4,44,0,0,0,18,69,67,28,
37,15,14,19,45,122,60,44,124,124,76,80,62,82,40,38,102,33,19,15,
31,48,3,54,96,5,3,2,70,1,29,27,45,40,9,24,8,4,28,6,
32,26,30,54,70,34,30,38,124,124,124,124,20,2,10,34,3,24,32,16,
0,106,3,117,107,124,18,36,10,14,24,44,118,68,28,7,0,4,46,58,
97,10,10,39,11,37,6,10,23,38,24,22,69,20,43,33,2,51,12,8,
2,61,117,17,51,51,65,89,85,53,125,124,125,75,77,97,125,103,125,125,
125,125,91,125,79,124,117,33,29,45,59,61,53,63,61,61,95,95,83,87,
87,125,23,29,77,31,49,51,65,71,83,77,97,83,49,87,89,69,41,50,
80,50,20,26,44,24,16,16,90,58,68,52,50,48,68,54,72,64,62,46,
102,86,76,68,84,34,14,10,12,17,116,56,5,7,30,6,19,0,4,74,
48,2,13,34,12,12,5,3,124,8,26,34,40,38,26,58,66,32,58,68,
94,0,16,11,14,78,11,19,11,14,16,9,31,13,41,11,17,55,34,32,
74,12,7,32,18,0,16,14,2,31,2,1,9,5,40,81,49,32,57,17,
31,17,18,31,37,8,8,73,23,87,18,24,38,13,37,33,39,51,61,79,
87,87,117,99,95,125,125,125,125,125,125,113,101,125,91,103,93,59,73,41,
49,53,55,99,79,79,125,91,107,109,125,109,117,119,45,41,125,57,63,87,
123,93,111,113,71,109,87,89,113,103,109,95,103,113,11,4,36,10,76,96,
4,24,42,50,12,46,84,8,3,38,51,121,125,125,125,125,125,125,16,78,
62,56,36,70,40,22,18,8,15,5,28,10,60,80,6,14,26,34,12,30,
64,12,1,38,51,121,125,125,125,125,125,125,0,0,0,0},
/*cabac_init_idc = 2*/
{124,18,21,124,18,21,125,81,20,18,24,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,39,45,67,17,44,2,104,16,11,125,77,37,21,87,125,125,
125,63,125,101,125,119,103,117,103,0,9,41,81,13,59,53,125,21,67,55,
125,14,37,25,123,59,47,27,15,0,9,41,2,3,4,14,5,1,4,29,
26,22,56,38,50,36,34,38,92,24,26,88,60,2,89,73,75,55,61,49,
41,45,39,47,61,13,17,21,8,77,73,63,23,17,23,15,34,11,2,3,
52,17,12,18,2,17,124,108,76,90,108,88,52,90,68,60,66,36,10,2,
4,50,36,48,42,38,36,44,28,58,42,16,24,34,51,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,92,124,120,82,124,124,124,124,120,116,124,
94,82,30,52,6,9,67,15,42,26,18,2,10,0,17,21,55,7,72,48,
38,34,1,9,29,27,45,57,16,6,2,3,19,25,33,49,93,67,41,31,
19,21,45,65,67,107,29,60,30,20,2,15,31,45,53,67,124,59,41,31,
5,15,2,6,8,23,2,10,5,31,15,9,38,2,54,46,72,68,38,54,
62,42,30,2,34,1,81,67,65,49,43,43,43,49,5,27,25,25,10,25,
39,71,63,63,25,21,13,23,9,3,19,2,2,9,23,16,1,13,114,88,
94,98,100,104,96,94,80,80,86,74,38,46,32,92,84,82,72,68,56,26,
12,0,27,37,61,11,91,124,124,124,124,124,124,124,124,124,124,124,122,100,
56,10,124,124,66,124,124,124,120,124,116,104,116,102,104,68,74,48,5,84,
64,26,113,97,101,43,57,51,15,35,33,9,13,14,9,26,21,124,124,124,
124,120,114,58,18,37,23,80,58,40,18,16,4,1,9,57,85,67,53,53,
49,19,31,45,19,13,11,5,1,10,8,124,124,124,124,120,108,86,54,7,
0,0,0,0,124,18,21,124,18,21,125,81,20,18,24,94,124,124,24,2,
71,94,43,77,12,12,19,12,46,106,124,124,42,67,125,107,21,43,77,12,
59,49,38,16,51,79,105,12,10,41,65,0,43,85,0,23,53,75,16,31,
23,67,26,6,44,0,0,0,39,45,67,17,44,2,58,49,125,125,55,63,
41,45,51,55,125,25,79,53,125,33,25,41,29,16,4,39,125,31,81,55,
125,3,31,17,57,14,9,15,69,45,49,37,17,7,17,51,11,8,5,12,
15,15,10,21,38,11,2,24,32,42,44,20,25,29,39,22,7,53,7,17,
23,33,39,1,64,1,61,23,0,21,56,72,55,3,11,27,5,2,9,35,
66,112,80,21,5,121,52,124,124,125,48,42,58,68,64,52,42,46,60,40,
54,32,16,10,6,38,38,42,30,14,22,52,28,10,30,36,11,60,0,124,
124,124,106,124,124,124,124,92,76,68,60,96,86,19,58,64,38,94,54,54,
70,84,86,102,94,42,59,14,12,50,125,103,37,2,20,8,43,51,61,57,
125,73,12,7,15,27,43,49,81,69,125,37,30,4,5,13,23,31,39,57,
89,31,11,23,10,10,29,39,35,71,35,50,2,10,8,19,25,45,39,47,
124,125,125,113,125,101,107,109,107,99,109,113,121,61,77,71,85,125,57,12,
45,61,55,27,15,19,1,35,1,12,7,9,7,9,27,1,9,29,16,8,
3,18,38,6,13,25,45,13,1,13,16,14,11,3,21,18,18,25,37,27,
27,42,124,124,124,124,124,124,124,124,124,124,124,124,124,124,104,124,124,124,
124,124,124,96,124,124,92,50,36,18,31,124,124,124,124,96,96,76,82,94,
90,70,44,70,32,2,64,74,78,80,94,66,68,44,42,6,22,6,29,119,
20,14,4,60,26,4,29,21,17,17,23,15,0,13,23,17,7,20,8,22,
9,124,124,124,124,112,102,80,50,1,15,52,38,28,14,8,0,7,9,31,
29,21,17,17,23,15,0,13,23,17,7,20,8,22,9,124,124,124,124,112,
102,80,50,1,0,0,0,0,124,18,21,124,18,21,123,77,22,20,24,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,37,45,67,15,44,2,104,16,
11,123,75,37,19,83,123,123,123,59,123,97,123,115,101,115,101,2,7,39,
79,11,57,51,123,19,65,53,123,16,35,23,119,57,45,25,13,2,7,39,
4,1,4,14,3,1,4,27,26,22,56,38,50,36,34,38,90,24,26,86,
58,2,87,71,73,53,59,47,39,43,37,45,57,13,17,19,6,75,71,63,
21,17,21,13,34,9,2,3,50,15,12,16,2,17,124,108,76,90,108,88,
52,90,68,58,66,36,10,2,4,50,36,48,42,38,34,44,28,56,40,16,
22,32,51,124,124,124,124,124,124,124,124,124,124,124,124,124,120,88,124,118,
80,124,124,124,124,116,112,122,90,78,30,50,4,9,67,13,44,28,20,4,
10,0,15,19,53,5,74,50,40,34,0,7,27,25,43,55,18,8,4,1,
17,23,31,47,89,65,37,29,17,19,43,63,65,103,27,62,32,22,4,13,
29,43,51,65,124,57,39,29,5,13,2,8,10,21,4,12,3,29,15,9,
38,4,54,46,70,68,38,52,60,42,30,2,32,1,79,65,63,47,41,41,
41,47,5,25,23,23,10,23,37,69,61,63,25,19,13,21,9,3,17,2,
2,7,21,16,1,13,114,88,94,98,98,104,96,94,80,80,86,74,38,44,
30,90,82,80,70,66,54,26,12,0,25,35,59,11,89,124,124,124,124,124,
124,124,124,124,124,122,118,96,54,10,124,124,64,124,124,124,116,124,112,100,
112,98,100,66,70,46,7,82,62,24,109,93,97,41,55,49,11,33,31,9,
11,18,5,30,19,124,124,124,124,116,110,54,14,39,21,82,58,40,18,18,
4,1,9,55,83,65,51,51,45,17,29,43,17,11,9,3,0,12,8,124,
124,124,124,118,106,82,52,7,0,0,0,0,124,18,21,124,18,21,123,77,
22,20,24,92,124,124,26,4,67,92,41,73,12,12,15,12,44,104,124,120,
38,67,123,103,19,41,73,12,57,47,40,16,49,77,101,10,8,41,65,0,
41,83,0,23,51,73,16,29,21,65,28,6,44,0,0,0,37,45,67,15,
44,2,58,47,123,121,51,61,37,41,49,51,123,23,75,51,121,33,25,41,
29,18,4,37,121,29,79,53,123,3,29,17,55,16,9,13,67,43,47,35,
15,5,15,49,9,10,5,12,13,13,10,19,40,9,2,26,34,44,46,22,
25,27,37,22,7,51,7,15,21,31,35,2,66,2,57,23,1,19,58,74,
55,3,9,27,3,2,7,31,66,112,82,17,7,117,50,124,124,123,48,42,
58,68,64,52,42,46,60,40,54,32,16,10,6,38,38,42,30,14,22,52,
28,8,30,36,11,58,0,124,124,124,104,124,124,124,124,90,74,64,58,92,
84,21,56,62,36,92,54,54,68,82,84,100,92,40,59,14,12,48,123,99,
33,4,20,8,41,49,59,55,123,69,14,5,13,25,39,47,77,67,121,35,
32,6,3,11,21,29,37,55,85,29,7,21,12,10,27,37,33,69,33,52,
4,12,10,17,23,43,37,45,124,123,123,109,123,97,103,105,103,95,105,109,
115,59,75,69,83,119,55,10,43,59,53,25,15,17,1,33,1,12,7,9,
5,9,27,1,9,27,16,8,3,18,38,6,13,23,41,13,1,11,16,14,
11,3,19,18,18,23,35,25,25,40,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,100,124,124,124,124,124,124,94,120,120,90,48,34,18,31,124,
124,124,120,92,94,74,78,92,86,68,40,66,30,0,62,72,74,78,92,64,
66,42,40,4,22,6,29,117,18,12,2,58,24,2,27,19,15,15,19,13,
2,11,19,15,5,22,10,24,7,124,124,124,124,108,100,76,48,3,13,54,
40,30,16,10,2,5,7,29,27,19,15,15,19,13,2,11,19,15,5,22,
10,24,7,124,124,124,124,108,100,76,48,3,0,0,0,0,124,18,21,124,
18,21,119,75,22,20,24,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
35,45,67,15,42,2,104,16,11,121,73,37,19,81,119,119,121,57,119,95,
119,113,99,113,99,4,7,37,77,11,57,49,119,19,65,53,121,16,35,23,
117,57,43,25,13,2,7,37,4,1,2,14,3,1,4,27,26,22,54,38,
48,36,34,38,86,24,26,82,56,0,85,69,71,51,57,45,37,41,37,43,
55,13,17,19,4,75,69,63,21,17,19,13,32,7,2,3,48,13,10,14,
2,19,120,106,74,88,106,86,50,88,68,56,64,36,10,2,4,48,34,46,
40,36,32,42,26,52,38,14,20,30,51,124,124,124,124,124,124,124,124,124,
124,124,124,124,116,82,124,114,76,124,124,124,124,112,108,116,86,74,28,46,
2,11,67,13,44,28,20,4,10,0,15,19,51,5,74,50,40,34,2,7,
25,25,41,53,20,10,4,1,15,23,31,45,87,63,35,27,17,19,41,61,
63,101,27,62,32,22,4,11,27,41,49,63,124,57,39,29,5,13,2,8,
10,21,4,12,1,29,15,9,36,4,52,44,68,66,38,50,58,42,30,0,
30,3,77,63,61,47,41,41,39,45,5,25,23,23,8,23,37,69,59,63,
25,19,13,19,9,3,15,2,2,7,19,14,1,15,112,88,94,96,96,102,
94,92,78,78,84,72,36,42,28,86,80,76,66,64,52,24,10,0,25,35,
59,13,87,124,124,124,124,124,124,124,124,124,124,118,114,92,52,8,124,120,
62,124,124,124,112,120,108,96,108,94,96,62,66,42,9,78,58,20,107,91,
95,39,53,47,7,31,29,9,9,20,3,32,17,124,124,124,124,110,104,48,
10,41,21,82,58,40,18,18,4,1,9,53,81,63,49,49,43,15,27,41,
15,9,7,3,2,12,8,124,124,124,122,114,102,78,48,9,0,0,0,0,
124,18,21,124,18,21,119,75,22,20,24,88,120,124,28,4,63,88,41,71,
12,12,13,10,42,102,120,114,34,69,119,101,19,41,71,12,57,45,40,16,
47,75,99,8,6,41,65,0,41,81,0,23,51,73,16,29,21,63,28,6,
44,0,0,0,35,45,67,15,42,2,58,45,121,117,49,59,33,37,47,49,
119,21,73,49,117,35,25,41,29,18,4,35,117,29,77,51,119,3,29,17,
55,16,9,13,65,43,45,35,15,5,15,47,7,10,5,12,13,13,10,19,
40,9,2,26,34,44,46,22,27,25,35,20,7,51,7,13,21,31,33,4,
68,6,53,25,3,19,58,74,57,3,9,29,1,2,7,29,66,112,82,15,
9,115,48,124,124,121,48,42,58,66,62,52,42,46,58,38,52,32,16,10,
6,36,36,40,30,14,22,50,26,6,28,34,11,56,1,124,124,124,100,120,
124,124,124,88,70,60,54,88,80,23,54,60,32,90,52,52,66,78,80,96,
88,36,59,12,10,44,121,97,31,6,20,8,39,47,57,53,119,67,16,3,
11,23,37,45,75,65,117,33,32,6,3,11,19,27,35,53,83,29,5,19,
12,10,25,35,33,67,31,52,6,12,10,15,21,41,35,43,124,121,119,105,
119,95,101,101,99,93,101,105,111,57,73,67,81,113,55,8,43,57,51,25,
15,17,1,33,1,10,7,9,3,9,27,1,9,27,16,8,3,16,36,6,
13,23,39,15,1,9,14,14,11,3,19,18,18,23,33,25,25,36,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,96,124,124,124,124,124,122,90,
116,116,86,46,32,16,31,124,124,124,116,88,90,70,74,88,82,64,36,62,
26,1,60,70,70,74,88,60,62,40,38,2,20,4,29,115,16,10,1,56,
22,0,27,19,13,13,17,11,4,11,17,13,3,22,12,26,5,124,124,124,
120,104,96,72,44,5,11,54,40,32,18,12,2,3,7,27,27,19,13,13,
17,11,4,11,17,13,3,22,12,26,5,124,124,124,120,104,96,72,44,5,
0,0,0,0,124,18,21,124,18,21,115,71,24,20,22,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,35,45,67,13,40,2,104,16,11,119,71,37,
17,79,115,115,117,55,115,93,115,111,97,111,97,6,7,35,75,11,55,49,
115,19,63,51,119,16,35,21,113,55,41,25,13,2,7,35,6,0,2,14,
3,1,4,27,26,20,54,38,46,36,34,38,82,24,24,78,54,1,83,67,
69,49,55,45,35,41,35,41,53,13,17,19,2,73,67,63,21,17,17,13,
30,5,2,3,46,11,10,12,2,21,118,104,74,86,104,84,50,86,66,54,
62,36,10,2,2,46,32,44,38,34,30,40,26,48,36,14,18,28,51,124,
124,124,124,124,124,124,124,124,124,124,124,124,110,78,124,110,74,124,122,124,
118,108,102,112,82,68,26,42,0,13,67,13,46,28,20,4,10,0,15,19,
51,5,74,50,40,34,4,5,25,23,41,51,22,10,6,1,13,21,29,45,
85,61,33,25,15,19,39,59,61,99,25,62,32,22,4,9,27,39,47,61,
124,55,37,27,5,13,2,8,10,21,4,12,1,29,15,9,36,6,50,42,
66,64,38,48,56,42,30,0,28,3,75,61,59,45,39,39,39,43,5,25,
23,21,8,23,37,67,57,63,25,19,13,17,9,3,13,2,2,7,17,12,
1,17,110,86,92,94,94,100,92,90,76,76,82,70,34,40,26,84,78,74,
62,60,50,22,10,1,25,35,59,13,85,124,124,124,124,124,124,124,124,124,
124,114,108,88,48,6,122,118,58,124,124,120,108,116,104,92,104,90,90,58,
62,38,11,74,54,18,105,89,93,37,51,45,5,29,27,9,7,24,0,36,
15,124,124,124,124,104,98,42,6,43,21,82,58,40,18,18,4,1,9,53,
79,61,47,47,41,15,27,39,15,9,7,3,2,12,8,124,124,124,118,110,
98,74,44,11,0,0,0,0,124,18,21,124,18,21,115,71,24,20,22,84,
118,122,28,4,59,86,41,67,12,10,11,8,40,100,116,106,30,71,115,97,
19,41,67,12,55,43,42,16,45,73,97,6,4,41,67,0,41,79,0,25,
51,73,16,29,21,61,30,6,44,0,0,0,35,45,67,13,40,2,56,45,
119,113,47,57,31,35,45,47,115,19,71,47,113,37,25,41,29,20,4,33,
113,29,75,49,115,3,29,17,55,18,9,11,63,43,43,35,15,5,13,45,
7,10,5,12,13,13,10,19,40,9,2,28,34,46,46,24,27,25,33,20,
7,51,7,11,21,29,31,6,70,8,49,25,5,17,58,74,59,3,7,29,
1,2,7,27,66,112,82,13,11,111,46,124,124,117,48,42,56,64,62,50,
40,46,58,36,50,32,16,10,4,36,34,38,28,14,22,48,26,4,28,32,
11,54,1,124,124,122,98,116,124,124,124,86,66,56,52,84,76,27,52,58,
28,88,50,50,64,76,76,92,84,34,59,10,8,42,117,93,27,6,20,8,
37,45,55,51,115,65,18,1,9,23,35,43,71,63,113,33,34,8,1,9,
17,27,35,51,81,29,1,17,12,10,23,35,33,65,29,54,8,14,10,13,
21,39,35,43,124,117,117,103,115,93,97,99,97,89,97,101,107,57,71,67,
79,107,55,6,43,55,49,25,15,17,1,31,1,8,7,9,3,9,27,1,
9,27,14,8,3,14,34,6,13,23,37,17,1,7,12,14,11,3,17,18,
16,21,31,25,25,34,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
92,124,124,124,124,124,118,86,112,110,82,44,30,14,31,124,124,124,112,84,
86,68,70,84,78,60,32,58,22,3,58,68,66,72,84,58,58,36,34,0,
18,2,29,113,14,6,3,54,20,1,27,17,13,13,15,9,6,11,15,11,
1,24,14,26,3,124,124,124,116,100,92,68,40,7,11,56,42,34,18,14,
4,3,5,27,27,17,13,13,15,9,6,11,15,11,1,24,14,26,3,124,
124,124,116,100,92,68,40,7,0,0,0,0,124,18,21,124,18,21,113,69,
24,20,22,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,33,47,67,13,
38,2,104,16,11,117,69,37,17,75,113,111,115,53,113,89,111,109,97,109,
97,6,7,33,73,11,55,47,111,19,63,51,117,16,33,21,111,55,41,25,
11,2,7,35,6,0,0,12,3,1,4,27,26,20,52,38,46,36,34,36,
78,24,24,74,52,3,81,65,67,47,55,43,33,39,35,39,51,13,17,17,
0,73,65,63,21,17,17,13,28,3,2,3,42,9,8,10,2,23,114,102,
72,84,102,82,48,84,66,50,60,34,10,2,2,44,32,42,38,32,28,38,
24,44,34,12,16,26,51,124,124,124,124,124,124,124,124,124,124,124,124,118,
106,72,124,108,70,124,118,124,114,102,98,106,78,64,24,40,3,15,67,13,
46,30,20,4,10,0,15,19,49,3,76,50,40,34,6,5,23,23,39,51,
24,12,6,1,13,21,29,43,83,61,31,25,15,19,37,57,61,97,25,64,
32,22,4,7,25,39,45,59,124,55,37,27,5,13,2,8,10,19,4,12,
0,29,15,9,34,6,48,40,64,62,38,44,54,40,30,1,26,5,75,61,
57,45,39,39,37,41,7,25,23,21,6,23,37,67,55,63,25,17,13,17,
9,3,11,2,0,7,15,12,3,19,108,86,92,92,92,98,90,88,74,74,
80,68,32,38,24,80,74,70,58,58,48,20,8,1,25,35,59,15,85,124,
124,124,124,124,124,124,124,124,120,110,104,84,46,4,118,114,56,124,124,116,
104,110,100,88,100,86,86,54,58,34,13,70,50,14,103,87,91,37,49,43,
1,27,25,9,5,26,2,38,15,124,124,124,124,98,92,36,2,45,21,82,
58,40,18,18,4,1,9,51,77,59,45,47,39,13,25,37,13,7,5,1,
4,14,8,124,124,124,114,106,94,70,40,13,0,0,0,0,124,18,21,124,
18,21,113,69,24,20,22,80,114,120,30,4,57,82,41,65,10,10,9,6,
36,96,112,100,24,73,111,95,19,41,65,10,55,41,42,14,45,71,93,4,
0,43,67,0,39,77,1,25,51,73,16,29,21,61,30,6,44,0,0,0,
33,47,67,13,38,2,56,43,117,109,45,55,27,31,45,45,111,17,69,45,
107,37,27,41,31,20,2,31,107,27,75,49,111,3,29,17,55,18,9,11,
61,43,43,33,15,5,13,43,5,10,7,10,13,13,10,19,40,9,2,28,
34,46,46,24,29,23,33,18,7,49,7,9,19,29,27,10,72,12,45,27,
7,17,60,74,61,3,7,31,0,2,7,25,66,112,82,9,13,109,44,124,
124,115,46,42,56,64,60,50,40,46,56,34,48,30,16,10,4,34,34,36,
28,12,20,46,24,2,26,30,11,50,3,124,124,118,94,114,124,124,124,84,
62,50,48,80,72,29,48,56,26,86,48,48,60,72,72,88,82,30,59,8,
6,38,115,91,25,8,20,8,35,43,53,51,111,61,20,1,9,21,31,41,
69,61,107,31,34,8,1,9,15,25,33,51,79,29,0,15,12,10,21,33,
33,63,27,54,10,14,10,11,19,37,33,41,124,115,113,99,113,91,95,95,
93,87,95,97,101,55,69,65,77,101,53,4,41,53,49,25,15,17,3,31,
3,6,7,9,1,9,27,1,9,25,14,6,3,12,32,4,13,23,35,19,
3,7,12,12,11,3,17,16,16,21,31,25,25,30,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,88,124,124,124,124,124,114,82,108,106,78,40,
28,12,31,124,124,124,108,80,82,64,66,80,74,56,28,52,20,7,56,66,
60,68,82,54,54,34,32,1,16,0,29,111,10,4,7,50,18,3,27,17,
11,11,13,9,6,9,13,9,0,24,16,28,3,124,124,120,112,96,88,62,
36,11,9,56,42,34,20,14,4,1,5,25,27,17,11,11,13,9,6,9,
13,9,0,24,16,28,3,124,124,120,112,96,88,62,36,11,0,0,0,0,
124,18,21,124,18,21,109,65,24,20,20,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,33,47,67,11,36,2,104,16,11,115,67,37,15,73,109,107,
111,51,109,87,107,107,95,107,95,8,7,31,71,11,53,45,107,19,63,49,
113,18,33,19,109,53,39,25,11,4,5,33,8,2,0,12,3,1,4,27,
26,18,50,38,44,36,34,36,74,24,22,72,50,5,79,63,65,45,53,41,
31,37,33,37,49,13,17,17,1,71,63,63,19,17,15,13,26,1,2,3,
40,7,8,8,2,23,112,100,72,82,100,80,46,84,66,48,58,34,10,2,
0,44,30,40,36,30,26,38,22,40,32,10,14,24,51,124,124,124,124,124,
124,124,124,124,124,124,124,114,102,68,120,104,66,124,114,120,110,98,94,100,
74,58,22,36,5,15,67,13,46,30,20,4,10,0,15,19,49,3,76,50,
40,34,8,3,21,23,37,49,26,14,6,0,11,19,27,43,81,59,27,23,
15,17,35,55,59,95,23,64,34,22,4,5,23,37,43,57,124,55,37,25,
5,13,2,8,10,19,4,14,0,29,15,9,32,8,46,38,62,62,38,42,
52,40,30,3,24,5,73,59,55,43,37,37,37,39,7,25,23,21,4,23,
37,65,53,63,25,17,13,15,9,3,9,2,0,7,13,10,3,19,106,86,
90,92,90,96,88,86,74,72,78,66,30,36,22,78,72,68,54,56,46,18,
6,3,25,33,59,15,83,124,124,124,124,124,124,124,124,120,116,106,100,80,
42,2,114,110,54,122,124,112,100,106,96,84,96,82,80,50,54,30,15,66,
46,12,101,83,89,35,47,41,2,25,23,9,3,30,6,42,13,124,124,124,
124,94,86,32,1,47,21,82,58,40,18,18,4,1,9,51,75,57,43,45,
37,11,25,35,11,5,3,1,4,14,8,124,124,124,112,102,90,66,36,15,
0,0,0,0,124,18,21,124,18,21,109,65,24,20,20,76,112,118,32,4,
53,78,39,61,10,10,7,4,34,94,108,94,20,73,107,93,19,39,61,10,
55,39,42,14,43,69,91,2,1,43,67,0,39,75,1,25,51,73,16,27,
21,59,32,6,44,0,0,0,33,47,67,11,36,2,54,43,113,103,43,53,
25,29,43,43,107,15,67,43,103,39,27,41,31,20,2,29,103,27,73,47,
107,3,29,17,53,18,9,9,59,41,41,33,15,3,11,41,5,10,7,10,
11,13,10,19,42,9,2,30,36,46,46,24,29,23,31,18,7,49,7,7,
19,27,25,12,74,14,41,27,9,15,60,74,63,3,5,31,2,2,7,21,
66,112,82,7,15,105,42,124,124,113,46,42,54,62,60,50,38,46,56,32,
46,30,16,10,4,34,32,34,26,12,20,44,24,0,24,30,11,48,3,124,
124,116,92,110,124,124,124,82,58,46,46,76,68,31,46,54,22,84,46,46,
58,70,68,84,78,28,59,6,4,34,111,87,23,8,20,8,33,41,51,49,
107,59,22,0,7,19,29,39,65,59,103,29,36,10,0,7,13,23,33,49,
77,27,2,13,12,10,19,33,31,61,25,54,12,14,10,9,17,35,33,39,
124,113,111,97,109,89,91,93,89,83,91,93,97,53,67,63,75,95,53,2,
41,51,47,25,15,17,3,29,3,4,7,9,0,9,27,1,9,25,12,6,
3,10,30,4,13,23,33,19,3,5,10,12,11,3,17,16,14,21,29,25,
25,28,124,124,124,124,124,124,124,124,124,124,124,124,124,124,84,124,124,124,
124,124,110,80,104,100,74,38,26,10,31,124,124,124,104,76,78,62,62,76,
70,52,24,48,16,9,54,64,56,66,78,52,50,32,30,3,14,1,29,109,
8,2,9,48,16,5,27,15,11,9,11,7,8,9,11,7,2,26,18,28,
1,124,124,116,108,92,84,58,32,13,9,58,44,36,22,16,6,1,5,23,
27,15,11,9,11,7,8,9,11,7,2,26,18,28,1,124,124,116,108,92,
84,58,32,13,0,0,0,0,124,18,23,124,18,23,105,63,26,20,20,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,31,47,67,11,36,0,104,16,
11,113,67,37,15,71,105,103,109,49,105,85,103,105,93,105,93,10,7,29,
71,9,53,45,103,19,61,49,111,18,33,19,105,53,37,23,11,4,5,31,
8,2,1,12,3,1,4,27,26,18,50,38,42,36,34,36,70,24,22,68,
48,7,79,61,65,45,51,41,29,37,33,37,45,13,17,17,3,71,61,63,
19,17,13,11,24,1,2,3,38,5,6,6,2,25,108,98,70,82,98,80,
46,82,64,46,56,34,10,2,0,42,28,38,34,30,24,36,22,36,30,10,
12,22,51,124,124,124,124,124,124,124,124,124,124,124,124,108,96,62,116,100,
64,124,108,114,104,94,88,96,68,54,20,32,7,17,67,11,48,30,22,4,
10,0,15,19,47,3,76,52,40,34,10,3,21,21,37,47,28,14,8,0,
9,19,27,41,79,57,25,21,13,17,35,55,57,91,23,64,34,22,6,5,
23,35,43,55,124,53,35,25,5,13,2,8,10,19,6,14,2,29,15,11,
32,8,44,36,60,60,38,40,50,40,30,3,22,7,71,57,53,43,37,37,
35,39,7,23,21,19,4,23,37,65,51,63,25,17,13,13,9,3,7,0,
0,7,13,8,3,21,104,84,90,90,88,96,88,84,72,72,76,64,28,34,
20,74,70,64,50,52,42,16,6,3,25,33,57,17,81,124,124,124,124,124,
124,124,124,116,110,102,94,76,40,2,112,108,50,118,124,108,96,102,92,80,
90,78,76,46,50,28,19,62,42,8,99,81,87,33,45,39,4,23,21,9,
1,32,8,44,11,124,124,124,118,88,82,26,5,51,19,82,58,40,18,18,
4,1,9,49,73,57,41,43,35,11,23,33,11,5,3,1,6,14,8,124,
124,122,108,100,88,60,34,17,0,0,0,0,124,18,23,124,18,23,105,63,
26,20,20,74,108,116,32,6,49,76,39,59,10,8,5,2,32,92,106,86,
16,75,103,89,19,39,59,10,53,37,44,14,41,67,89,1,3,43,69,0,
39,75,1,27,49,73,14,27,21,57,32,6,44,0,0,0,31,47,67,11,
36,0,54,41,111,99,41,51,21,25,41,41,103,13,65,43,99,41,27,41,
31,22,2,27,99,27,71,45,103,3,29,17,53,20,11,9,59,41,39,33,
13,3,11,39,3,10,7,10,11,13,10,19,42,9,2,30,36,48,48,26,
31,21,29,16,7,49,7,5,19,27,23,14,74,18,39,29,11,15,60,74,
63,5,5,33,2,0,5,19,66,112,84,5,17,103,40,124,124,109,46,42,
54,60,58,48,38,44,54,32,46,30,14,10,2,32,30,32,26,12,20,44,
22,3,24,28,11,46,5,124,124,112,88,106,124,124,124,78,54,42,42,72,
64,35,44,50,18,80,44,44,56,66,64,80,74,24,59,4,2,32,109,85,
19,10,20,8,31,41,51,47,105,57,24,2,5,19,27,37,63,57,99,29,
36,10,0,7,11,23,31,47,75,27,6,11,12,10,19,31,31,61,25,56,
12,16,10,7,17,35,31,39,124,109,107,93,105,85,89,89,87,81,87,89,
93,53,65,63,75,89,53,0,41,51,45,25,15,17,3,29,3,2,7,9,
0,9,27,1,9,25,12,6,3,8,28,4,13,23,31,21,3,3,8,12,
11,3,15,16,14,19,27,25,25,24,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,80,124,124,124,124,124,104,76,100,96,70,36,24,8,31,124,
124,124,100,72,76,58,58,72,64,48,20,44,12,11,52,60,52,62,74,48,
46,28,26,5,12,3,31,107,6,1,13,46,12,7,25,15,9,9,9,5,
10,9,9,5,4,26,20,30,0,124,124,112,104,88,80,54,28,15,7,58,
44,38,22,18,6,0,3,23,25,15,9,9,9,5,10,9,9,5,4,26,
20,30,0,124,124,112,104,88,80,54,28,15,0,0,0,0,124,18,23,124,
18,23,101,59,26,20,18,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
31,47,67,9,34,0,104,16,11,111,65,37,13,67,103,99,105,47,103,81,
99,103,91,103,93,12,7,27,69,9,51,43,99,19,61,47,109,18,31,17,
103,51,37,23,9,4,5,29,10,4,1,10,3,1,4,27,26,16,48,38,
42,36,34,34,66,24,20,64,46,9,77,59,63,43,49,39,27,35,31,35,
43,13,17,15,5,69,59,63,19,17,13,11,22,0,2,3,34,3,6,4,
2,27,106,96,70,80,96,78,44,80,64,44,54,34,10,2,1,40,28,36,
34,28,22,34,20,32,28,8,10,20,51,124,124,124,124,124,124,124,124,124,
124,120,122,104,92,58,112,98,60,124,104,110,100,88,84,90,64,48,18,30,
11,19,67,11,48,32,22,4,10,0,15,19,47,1,78,52,40,34,12,1,
19,21,35,45,30,16,8,0,7,17,25,41,77,57,23,21,13,17,33,53,
57,89,21,66,34,22,6,3,21,33,41,53,124,53,35,23,5,13,2,8,
10,17,6,14,2,29,15,11,30,10,42,34,58,58,38,38,48,38,30,5,
20,7,69,57,51,41,35,35,35,37,7,23,21,19,2,23,37,63,49,63,
25,15,13,13,9,3,5,0,0,7,11,8,5,23,102,84,88,88,86,94,
86,82,70,70,74,62,26,32,18,72,66,62,46,50,40,14,4,5,25,33,
57,17,79,124,124,124,124,124,124,124,122,112,106,98,90,72,36,0,108,104,
48,114,124,104,92,98,88,76,86,74,70,42,46,24,21,58,38,6,97,79,
85,33,43,37,8,21,19,9,0,36,12,48,11,124,124,122,112,82,76,20,
9,53,19,82,58,40,18,18,4,1,9,49,71,55,39,41,33,9,23,31,
9,3,1,0,6,16,8,124,124,118,104,96,84,56,30,19,0,0,0,0,
124,18,23,124,18,23,101,59,26,20,18,70,106,114,34,6,47,72,39,55,
8,8,3,0,30,90,102,80,10,77,99,87,19,39,55,8,53,35,44,14,
41,65,85,3,5,43,69,0,37,73,3,27,49,73,14,27,21,55,34,6,
44,0,0,0,31,47,67,9,34,0,52,41,109,95,39,49,19,23,39,39,
99,11,63,41,93,41,29,41,33,22,2,25,93,25,71,45,99,3,29,17,
53,20,11,7,57,41,37,31,13,3,9,37,3,10,9,10,11,13,10,19,
42,9,2,32,36,48,48,26,31,21,29,16,7,47,7,3,17,25,19,18,
76,20,35,29,13,13,62,74,65,5,3,33,4,0,5,17,66,112,84,1,
19,99,38,124,124,107,46,42,52,60,58,48,36,44,54,30,44,30,14,10,
2,32,30,30,24,12,20,42,22,5,22,26,11,44,5,124,124,108,86,104,
124,124,124,76,50,38,40,68,60,37,42,48,16,78,42,42,52,64,60,76,
72,22,59,2,0,28,105,81,17,10,20,8,29,39,49,47,101,53,26,4,
5,17,23,35,59,55,93,27,38,12,2,5,9,21,31,45,73,27,8,9,
12,10,17,31,31,59,23,56,14,16,10,5,15,33,31,37,124,107,105,91,
103,83,85,87,83,77,83,85,87,51,63,61,73,83,51,1,39,49,43,25,
15,17,3,27,5,0,7,9,2,9,27,1,9,23,10,4,3,6,26,2,
13,23,29,23,5,1,8,10,11,3,15,14,12,19,27,25,25,22,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,76,124,124,124,124,124,100,72,
96,90,66,34,22,6,31,124,122,124,96,68,72,56,54,68,60,44,16,40,
10,15,50,58,48,60,72,46,42,26,24,7,10,5,31,105,2,3,15,42,
10,9,25,13,9,7,7,3,10,7,7,3,6,28,22,30,0,124,120,108,
100,84,76,48,24,17,7,60,46,38,24,20,8,0,3,21,25,13,9,7,
7,3,10,7,7,3,6,28,22,30,0,124,120,108,100,84,76,48,24,17,
0,0,0,0,124,16,23,124,16,23,99,57,26,20,18,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,29,49,67,9,32,0,104,16,11,109,63,37,
13,65,99,95,103,45,99,79,97,101,91,101,91,12,7,25,67,9,51,43,
97,19,61,47,107,18,31,17,101,51,35,23,9,4,5,29,10,4,3,10,
3,1,4,27,26,16,46,38,40,36,34,34,62,24,20,60,44,11,75,57,
61,41,49,39,25,35,31,33,41,13,17,15,9,69,57,63,19,19,11,11,
20,2,2,3,32,1,4,2,2,29,102,94,68,78,94,76,42,78,62,40,
52,32,10,2,1,38,26,34,32,26,20,32,18,28,24,6,8,18,51,124,
124,124,124,124,124,124,124,124,122,116,116,98,86,52,108,94,56,122,100,104,
94,84,78,84,60,44,16,26,13,21,69,11,48,32,22,4,10,0,15,19,
45,1,78,52,40,34,14,1,19,21,35,45,32,16,8,0,7,17,25,39,
75,55,21,19,13,17,31,51,55,87,21,66,34,22,6,1,21,33,39,53,
124,53,35,23,5,13,2,8,10,17,6,14,4,29,15,11,28,10,40,32,
56,56,38,34,44,38,30,7,18,9,69,55,49,41,35,35,33,35,9,23,
21,19,0,23,37,63,49,65,25,15,13,11,9,3,5,0,1,7,9,6,
5,25,100,82,88,86,82,92,84,80,68,68,72,60,24,30,16,68,64,58,
42,46,38,12,2,5,25,33,57,19,79,124,124,124,124,124,124,122,116,108,
102,94,84,68,34,1,104,100,44,110,122,98,86,92,82,72,82,68,66,38,
40,20,23,54,34,2,95,77,83,31,41,37,10,19,19,9,0,38,14,50,
9,124,124,116,106,76,70,14,13,55,19,82,58,40,18,18,4,1,9,47,
71,53,37,41,31,9,21,31,9,3,1,0,8,16,6,124,124,114,100,92,
80,52,26,21,0,0,0,0,124,16,23,124,16,23,99,57,26,20,18,66,
102,112,34,6,43,68,39,53,8,6,1,1,26,86,98,72,6,79,95,85,
19,39,53,8,53,35,44,12,39,63,83,5,9,45,71,0,37,71,3,29,
49,73,14,27,21,55,34,6,44,0,0,0,29,49,67,9,32,0,52,39,
107,91,37,49,15,19,39,37,95,11,61,39,89,43,29,43,33,22,0,25,
89,25,69,43,97,3,29,17,53,20,11,7,55,41,37,31,13,3,9,35,
1,10,9,8,11,13,8,19,42,9,2,32,36,48,48,26,33,19,27,14,
7,47,7,1,17,25,17,20,78,24,31,31,15,13,62,74,67,5,3,35,
4,0,5,15,66,112,84,0,21,97,36,118,124,105,44,42,52,58,56,46,
36,44,52,28,42,28,14,8,0,30,28,28,24,10,18,40,20,7,20,24,
11,40,7,124,124,104,82,100,120,124,124,74,46,32,36,62,56,41,38,46,
12,76,40,40,50,60,56,72,68,18,59,0,1,24,103,79,15,12,20,8,
29,37,47,45,97,51,26,4,3,17,21,33,57,53,89,27,38,12,2,5,
9,21,29,45,71,27,10,7,12,10,15,29,31,57,21,56,16,16,10,3,
15,31,29,37,124,105,101,87,99,81,83,83,81,75,81,81,83,51,61,61,
71,77,51,3,39,47,43,25,15,17,5,27,5,1,7,9,2,9,27,3,
9,23,10,4,5,4,24,2,15,23,27,25,5,1,6,10,11,5,15,14,
12,19,25,25,25,18,124,124,124,124,124,124,124,124,124,124,124,124,124,122,
72,124,124,124,124,122,96,68,90,86,62,30,18,4,31,122,118,124,92,62,
68,52,48,64,56,40,12,34,6,17,46,56,42,56,68,42,38,22,20,9,
8,7,31,103,0,7,19,40,8,11,25,13,7,7,5,3,12,7,5,3,
8,28,22,32,2,122,116,104,96,80,72,44,20,21,5,60,46,40,24,20,
8,2,3,21,25,13,7,7,5,3,12,7,5,3,8,28,22,32,2,122,
116,104,96,80,72,44,20,21,0,0,0,0,124,16,23,124,16,23,95,55,
28,20,18,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,27,49,67,9,
30,0,104,16,11,107,61,37,13,63,95,91,99,41,95,77,93,99,89,99,
89,14,5,23,65,9,49,41,93,19,59,47,103,20,31,17,97,51,33,23,
9,6,3,27,10,4,3,10,1,1,4,25,26,16,46,38,38,36,34,34,
58,24,20,58,42,11,73,55,59,39,47,37,23,33,31,31,39,13,17,15,
11,67,55,63,17,19,9,11,18,4,2,3,30,0,2,0,2,29,100,92,
68,76,92,74,42,78,62,38,50,32,10,2,1,38,24,32,30,24,18,32,
18,26,22,6,6,16,51,124,124,124,124,124,124,124,124,124,118,112,112,92,
82,46,106,90,54,118,96,100,90,80,74,80,56,40,16,22,15,21,69,11,
50,32,22,6,10,0,13,19,43,1,78,52,42,34,16,0,17,19,33,43,
34,18,10,2,5,15,25,37,73,53,17,17,11,15,29,49,53,85,19,66,
36,24,6,0,19,31,37,51,124,51,33,21,5,13,2,10,12,17,6,16,
6,29,15,11,28,10,38,32,54,56,38,32,42,38,30,7,16,11,67,53,
47,41,33,35,31,33,9,23,21,17,0,23,37,63,47,65,25,15,13,9,
9,3,3,0,1,7,7,4,5,25,98,82,88,86,80,90,82,78,68,66,
70,60,24,28,14,66,62,54,38,44,36,12,2,5,23,31,57,21,77,124,
124,124,124,124,124,118,112,104,98,90,80,64,32,3,100,98,42,106,118,94,
82,88,78,68,78,64,62,36,36,16,25,50,30,1,93,73,79,29,39,35,
14,17,17,9,2,42,16,54,7,124,124,112,100,72,64,10,17,57,19,82,
58,40,18,20,4,1,9,45,69,51,35,39,27,7,19,29,7,1,0,0,
10,16,6,124,122,112,98,88,76,48,22,21,0,0,0,0,124,16,23,124,
16,23,95,55,28,20,18,62,98,112,36,6,39,66,37,49,8,6,0,1,
24,84,94,66,2,79,91,81,17,37,49,8,51,33,46,12,37,61,81,7,
11,45,71,0,37,69,3,29,49,73,14,25,19,53,34,6,44,0,0,0,
27,49,67,9,30,0,52,37,103,85,35,47,11,15,37,35,91,9,57,37,
85,45,29,43,33,24,0,23,85,25,67,41,93,3,27,17,51,22,11,5,
53,39,35,31,13,1,7,33,0,10,9,8,9,11,8,19,44,9,2,32,
38,50,48,28,33,17,25,12,7,47,7,0,17,23,15,22,80,28,27,33,
17,11,62,76,69,5,3,35,6,0,5,11,66,112,84,2,23,95,34,114,
124,101,44,42,52,56,56,46,36,44,52,26,40,28,14,8,0,30,26,28,
24,10,18,38,18,9,20,24,11,38,7,124,124,102,80,96,116,124,124,72,
42,28,34,58,54,43,36,44,8,74,38,38,48,56,54,68,64,16,59,0,
3,22,99,75,11,14,20,8,27,35,45,43,93,49,28,6,1,15,19,31,
55,51,85,25,40,14,4,5,7,19,27,43,67,25,14,5,14,10,13,27,
29,55,19,58,18,18,12,1,13,29,27,35,124,101,97,83,95,79,81,79,
77,71,77,77,79,49,59,59,69,69,51,5,39,45,41,23,15,17,5,27,
5,3,7,9,4,9,27,3,9,23,10,4,5,4,22,2,15,21,23,25,
5,0,4,10,11,5,13,14,12,17,23,23,23,14,124,124,124,124,124,124,
124,124,124,124,124,124,124,116,68,124,124,124,124,116,92,66,86,82,60,28,
16,2,31,118,114,120,88,58,64,50,44,60,52,36,8,30,2,19,44,54,
38,54,64,40,34,20,18,11,6,7,31,101,1,9,23,38,6,13,25,11,
5,5,1,1,14,7,3,1,10,30,24,34,4,120,114,100,92,76,68,40,
16,23,3,60,48,42,26,22,10,4,1,19,25,11,5,5,1,1,14,7,
3,1,10,30,24,34,4,120,114,100,92,76,68,40,16,23,0,0,0,0,
124,16,23,124,16,23,91,51,28,20,16,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,27,49,67,7,28,0,104,16,11,105,59,37,11,59,93,87,
97,39,93,73,89,97,87,97,89,16,5,21,63,9,49,39,89,19,59,45,
101,20,29,15,95,49,33,23,7,6,3,25,12,6,5,8,1,1,4,25,
26,14,44,38,38,36,34,32,54,24,18,54,40,13,71,53,57,37,45,35,
21,31,29,29,37,13,17,13,13,67,53,63,17,19,9,11,16,6,2,3,
26,2,2,1,2,31,96,90,66,74,90,72,40,76,62,36,48,32,10,2,
3,36,24,30,30,22,16,30,16,22,20,4,4,14,51,124,124,124,124,124,
124,124,124,124,114,108,106,88,78,42,102,88,50,112,92,96,86,74,70,74,
52,34,14,20,19,23,69,11,50,34,22,6,10,0,13,19,43,0,80,52,
42,34,18,0,15,19,31,41,36,20,10,2,3,15,23,37,71,53,15,17,
11,15,27,47,53,83,19,68,36,24,6,2,17,29,35,49,124,51,33,21,
5,13,2,10,12,15,6,16,6,29,15,11,26,12,36,30,52,54,38,30,
40,36,30,9,14,11,65,53,45,39,33,33,31,31,9,23,21,17,1,23,
37,61,45,65,25,13,13,9,9,3,1,0,1,7,5,4,7,27,96,82,
86,84,78,88,80,76,66,64,68,58,22,26,12,62,58,52,34,42,34,10,
0,7,23,31,57,21,75,124,124,124,124,124,120,114,106,100,94,86,76,60,
28,5,96,94,40,102,114,90,78,84,74,64,74,60,56,32,32,12,27,46,
26,3,91,71,77,29,37,33,18,15,15,9,4,44,20,56,7,124,120,106,
94,66,58,4,21,59,19,82,58,40,18,20,4,1,9,45,67,49,33,37,
25,5,19,27,5,0,2,2,10,18,6,120,118,108,94,84,72,44,18,23,
0,0,0,0,124,16,23,124,16,23,91,51,28,20,16,58,96,110,38,6,
37,62,37,47,6,6,2,3,22,82,90,60,3,81,87,79,17,37,47,6,
51,31,46,12,37,59,77,9,13,45,71,0,35,67,5,29,49,73,14,25,
19,51,36,6,44,0,0,0,27,49,67,7,28,0,50,37,101,81,33,45,
9,13,35,33,87,7,55,35,79,45,31,43,35,24,0,21,79,23,67,41,
89,3,27,17,51,22,11,5,51,39,33,29,13,1,7,31,0,10,11,8,
9,11,8,19,44,9,2,34,38,50,48,28,35,17,25,12,7,45,7,2,
15,23,11,26,82,30,23,33,19,11,64,76,71,5,1,37,8,0,5,9,
66,112,84,6,25,91,32,108,124,99,44,42,50,56,54,46,34,44,50,24,
38,28,14,8,0,28,26,26,22,10,18,36,18,11,18,22,11,36,9,120,
124,98,76,94,112,124,124,70,38,24,30,54,50,45,34,42,6,72,36,36,
44,54,50,64,62,12,59,1,5,18,97,73,9,14,20,8,25,33,43,43,
89,45,30,8,1,13,15,29,51,49,79,23,40,14,4,3,5,17,27,41,
65,25,16,3,14,10,11,27,29,53,17,58,20,18,12,0,11,27,27,33,
124,99,95,81,93,77,77,77,73,69,73,73,73,47,57,57,67,63,49,7,
37,43,39,23,15,17,5,25,7,5,7,9,6,9,27,3,9,21,8,2,
5,2,20,0,15,21,21,27,7,2,4,8,11,5,13,12,10,17,23,23,
23,12,124,124,124,124,124,124,124,124,124,124,124,124,124,112,64,124,124,124,
124,110,88,62,82,76,56,26,14,0,31,114,108,114,84,54,60,46,40,56,
48,32,4,26,0,23,42,52,34,50,62,36,30,18,16,13,4,9,31,99,
5,11,25,34,4,15,25,11,5,3,0,0,14,5,1,0,12,30,26,34,
4,120,110,96,88,72,64,34,12,25,3,62,48,42,28,24,10,4,1,17,
25,11,5,3,0,0,14,5,1,0,12,30,26,34,4,120,110,96,88,72,
64,34,12,25,0,0,0,0,124,16,25,124,16,25,87,49,30,20,16,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,25,49,67,7,28,1,104,16,
11,103,59,37,11,57,89,83,93,37,89,71,85,95,85,95,87,18,5,19,
63,7,47,39,85,19,57,45,99,20,29,15,91,49,31,21,7,6,3,23,
12,6,5,8,1,1,4,25,26,14,44,38,36,36,34,32,50,24,18,50,
38,15,71,51,57,37,43,35,19,31,29,29,33,13,17,13,15,65,51,63,
17,19,7,9,14,6,2,3,24,4,0,3,2,33,94,88,66,74,88,72,
40,74,60,34,46,32,10,2,3,34,22,28,28,22,14,28,16,18,18,4,
2,12,51,124,124,124,124,124,124,124,124,124,108,104,102,82,72,36,98,84,
48,108,86,90,80,70,64,70,46,30,12,16,21,25,69,9,52,34,24,6,
10,0,13,19,41,0,80,54,42,34,20,2,15,17,31,39,38,20,12,2,
1,13,23,35,69,51,13,15,9,15,27,47,51,79,17,68,36,24,8,2,
17,27,35,47,124,49,31,19,5,13,2,10,12,15,8,16,8,29,15,13,
26,12,34,28,50,52,38,28,38,36,30,9,12,13,63,51,43,39,31,33,
29,31,9,21,19,15,1,23,37,61,43,65,25,13,13,7,9,3,0,1,
1,7,5,2,7,29,94,80,86,82,76,88,80,74,64,64,66,56,20,24,
10,60,56,48,30,38,30,8,0,7,23,31,55,23,73,124,124,124,124,124,
116,110,102,96,88,82,70,56,26,5,94,92,36,98,108,86,74,80,70,60,
68,56,52,28,28,10,31,42,22,7,89,69,75,27,35,31,20,13,13,9,
6,48,22,60,5,122,118,102,88,60,54,1,25,63,17,82,58,40,18,20,
4,1,9,43,65,49,31,35,23,5,17,25,5,0,2,2,12,18,6,118,
116,104,90,82,70,38,16,25,0,0,0,0,124,16,25,124,16,25,87,49,
30,20,16,56,92,108,38,8,33,60,37,43,6,4,4,5,20,80,88,52,
7,83,83,75,17,37,43,6,49,29,48,12,35,57,75,13,15,45,73,0,
35,67,5,31,47,73,12,25,19,49,36,6,44,0,0,0,25,49,67,7,
28,1,50,35,99,77,31,43,5,9,33,31,83,5,53,35,75,47,31,43,
35,26,0,19,75,23,65,39,85,3,27,17,51,24,13,3,51,39,31,29,
11,1,5,29,2,10,11,8,9,11,8,19,44,9,2,34,38,52,50,30,
35,15,23,10,7,45,7,4,15,21,9,28,82,34,21,35,21,9,64,76,
71,7,1,37,8,1,3,7,66,112,86,8,27,89,30,102,124,95,44,42,
50,54,54,44,34,42,50,24,38,28,12,8,1,28,24,24,22,10,18,36,
16,15,18,20,11,34,9,114,124,94,74,90,108,124,122,66,34,20,28,50,
46,49,32,38,2,68,34,34,42,50,46,60,58,10,59,3,7,16,93,69,
5,16,20,8,23,33,43,41,87,43,32,10,0,13,13,27,49,47,75,23,
42,16,6,3,3,17,25,39,63,25,20,1,14,10,11,25,29,53,17,60,
20,20,12,2,11,27,25,33,124,95,91,77,89,73,75,73,71,65,69,69,
69,47,55,57,67,57,49,9,37,43,37,23,15,17,5,25,7,7,7,9,
6,9,27,3,9,21,8,2,5,0,18,0,15,21,19,29,7,4,2,8,
11,5,11,12,10,15,21,23,23,8,124,122,124,124,124,124,124,124,124,124,
124,124,124,106,60,124,124,124,124,106,82,58,78,72,52,24,12,1,31,110,
104,110,80,50,58,44,36,52,42,28,0,22,3,25,40,48,30,48,58,34,
26,14,12,15,2,11,33,97,7,15,29,32,0,17,23,9,3,3,2,2,
16,5,0,2,14,32,28,36,6,118,106,92,84,68,60,30,8,27,1,62,
50,44,28,26,12,6,0,17,23,9,3,3,2,2,16,5,0,2,14,32,
28,36,6,118,106,92,84,68,60,30,8,27,0,0,0,0,124,16,25,124,
16,25,85,45,30,20,14,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
25,51,67,5,26,1,104,16,11,101,57,37,9,55,85,79,91,35,85,69,
81,93,85,93,85,18,5,17,61,7,47,37,81,19,57,43,97,20,29,13,
89,47,29,21,7,6,3,23,14,8,7,8,1,1,4,25,26,12,42,38,
34,36,34,32,46,24,16,46,36,17,69,49,55,35,43,33,17,29,27,27,
31,13,17,13,17,65,49,63,17,19,5,9,12,8,2,3,22,6,0,5,
2,35,90,86,64,72,86,70,38,72,60,30,44,30,10,2,5,32,20,26,
26,20,12,26,14,14,16,2,0,10,51,124,124,122,124,124,124,124,124,122,
104,100,96,78,68,32,94,80,44,104,82,86,76,66,60,64,42,24,10,12,
23,27,69,9,52,34,24,6,10,0,13,19,41,0,80,54,42,34,22,2,
13,17,29,39,40,22,12,2,1,13,21,35,67,49,11,13,9,15,25,45,
49,77,17,68,36,24,8,4,15,27,33,45,124,49,31,19,5,13,2,10,
12,15,8,16,8,29,15,13,24,14,32,26,48,50,38,24,36,36,30,11,
10,13,63,49,41,37,31,31,29,29,11,21,19,15,3,23,37,59,41,65,
25,13,13,5,9,3,2,1,3,7,3,0,7,31,92,80,84,80,74,86,
78,72,62,62,64,54,18,22,8,56,54,46,26,36,28,6,1,9,23,31,
55,23,73,124,124,124,124,124,112,106,96,92,84,78,66,52,22,7,90,88,
34,94,104,82,70,74,66,56,64,52,46,24,24,6,33,38,18,9,87,67,
73,25,33,29,24,11,11,9,8,50,26,62,3,118,114,96,82,54,48,7,
29,65,17,82,58,40,18,20,4,1,9,43,63,47,29,35,21,3,17,23,
3,2,4,2,12,18,6,116,112,100,86,78,66,34,12,27,0,0,0,0,
124,16,25,124,16,25,85,45,30,20,14,52,90,106,40,8,29,56,37,41,
6,4,6,7,16,76,84,46,11,85,79,73,17,37,41,6,49,27,48,10,
33,55,73,15,19,47,73,0,35,65,5,31,47,73,12,25,19,49,38,6,
44,0,0,0,25,51,67,5,26,1,48,35,97,73,29,41,3,7,33,29,
79,3,51,33,71,49,31,43,35,26,1,17,71,23,63,37,81,3,27,17,
51,24,13,3,49,39,31,29,11,1,5,27,2,10,11,6,9,11,8,19,
44,9,2,36,38,52,50,30,37,15,21,10,7,45,7,6,15,21,7,30,
84,36,17,35,23,9,64,76,73,7,0,39,10,1,3,5,66,112,86,10,
29,85,28,96,120,93,42,42,48,52,52,44,32,42,48,22,36,26,12,8,
1,26,22,22,20,8,16,34,16,17,16,18,11,30,11,110,124,90,70,86,
104,124,116,64,30,14,24,46,42,51,28,36,1,66,32,32,40,48,42,56,
54,6,59,5,9,12,91,67,3,16,20,8,21,31,41,39,83,41,34,10,
2,11,11,25,45,45,71,21,42,16,6,1,1,15,25,39,61,25,22,0,
14,10,9,25,29,51,15,60,22,20,12,4,9,25,25,31,124,93,89,75,
85,71,71,71,67,63,67,65,65,45,53,55,65,51,49,11,37,41,37,23,
15,17,7,23,7,9,7,9,8,9,27,3,9,21,6,2,5,1,16,0,
15,21,17,31,7,4,0,8,11,5,11,12,8,15,19,23,23,6,124,120,
124,124,124,124,124,124,124,124,124,124,124,100,56,124,124,124,124,100,78,54,
74,66,48,20,10,3,31,104,100,106,76,46,54,40,32,48,38,24,3,16,
7,27,38,46,24,44,54,30,22,12,10,17,0,13,33,95,9,17,31,30,
1,19,23,9,3,1,4,2,18,5,2,4,16,32,30,36,8,118,102,88,
80,64,56,26,4,31,1,64,50,46,30,26,12,6,0,15,23,9,3,1,
4,2,18,5,2,4,16,32,30,36,8,118,102,88,80,64,56,26,4,31,
0,0,0,0,124,16,25,124,16,25,81,43,30,20,14,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,23,51,67,5,24,1,104,16,11,99,55,37,
9,51,83,75,87,33,83,65,77,91,83,91,85,20,5,15,59,7,45,35,
77,19,57,43,93,22,27,13,87,47,29,21,5,8,1,21,14,8,7,6,
1,1,4,25,26,12,40,38,34,36,34,30,42,24,16,44,34,19,67,47,
53,33,41,31,15,27,27,25,29,13,17,11,19,63,47,63,15,19,5,9,
10,10,2,3,18,8,1,7,2,35,88,84,64,70,84,68,36,72,60,28,
42,30,10,2,5,32,20,24,26,18,10,26,12,10,14,0,1,8,51,122,
124,118,124,122,120,120,120,118,100,96,92,72,64,26,90,78,40,98,78,82,
72,60,56,58,38,20,8,10,27,27,69,9,52,36,24,6,10,0,13,19,
39,2,82,54,42,34,24,4,11,17,27,37,42,24,12,4,0,11,21,33,
65,49,7,13,9,13,23,43,49,75,15,70,38,24,8,6,13,25,31,43,
124,49,31,17,5,13,2,10,12,13,8,18,10,29,15,13,22,14,30,24,
46,50,38,22,34,34,30,13,8,15,61,49,39,37,29,31,27,27,11,21,
19,15,5,23,37,59,39,65,25,11,13,5,9,3,4,1,3,7,1,0,
9,31,90,80,84,80,72,84,76,70,62,60,62,52,16,20,6,54,50,42,
22,34,26,4,3,9,23,29,55,25,71,124,124,124,124,120,108,102,92,88,
80,74,62,48,20,9,86,84,32,90,100,78,66,70,62,52,60,48,42,20,
20,2,35,34,14,13,85,63,71,25,31,27,28,9,9,9,10,54,28,66,
3,116,110,92,76,50,42,11,33,67,17,82,58,40,18,20,4,1,9,41,
61,45,27,33,19,1,15,21,1,4,6,4,14,20,6,112,110,98,84,74,
62,30,8,29,0,0,0,0,124,16,25,124,16,25,81,43,30,20,14,48,
86,104,42,8,27,52,35,37,4,4,8,9,14,74,80,40,17,85,75,71,
17,35,37,4,49,25,48,10,33,53,69,17,21,47,73,0,33,63,7,31,
47,73,12,23,19,47,38,6,44,0,0,0,23,51,67,5,24,1,48,33,
93,67,27,39,0,3,31,27,75,1,49,31,65,49,33,43,37,26,1,15,
65,21,63,37,77,3,27,17,49,24,13,1,47,37,29,27,11,0,3,25,
4,10,13,6,7,11,8,19,46,9,2,36,40,52,50,30,37,13,21,8,
7,43,7,8,13,19,3,34,86,40,13,37,25,7,66,76,75,7,0,39,
12,1,3,1,66,112,86,14,31,83,26,92,114,91,42,42,48,52,52,44,
32,42,48,20,34,26,12,8,1,26,22,20,20,8,16,32,14,19,14,18,
11,28,11,106,124,88,68,84,100,124,112,62,26,10,22,42,38,53,26,34,
3,64,30,30,36,44,38,52,52,4,59,7,11,8,87,63,1,18,20,8,
19,29,39,39,79,37,36,12,2,9,7,23,43,43,65,19,44,18,8,1,
0,13,23,37,59,23,24,2,14,10,7,23,27,49,13,60,24,20,12,6,
7,23,23,29,124,91,85,71,83,69,69,67,63,59,63,61,59,43,51,53,
63,45,47,13,35,39,35,23,15,17,7,23,9,11,7,9,10,9,27,3,
9,19,6,0,5,3,14,1,15,21,15,31,9,6,0,6,11,5,11,10,
8,15,19,23,23,2,124,118,124,124,124,124,124,124,124,124,124,124,120,96,
52,124,124,124,124,94,74,52,70,62,44,18,8,5,31,100,94,100,72,42,
50,38,28,44,34,20,7,12,9,31,36,44,20,42,52,28,18,10,8,19,
1,15,33,93,13,19,35,26,3,21,23,7,1,0,6,4,18,3,4,6,
18,34,32,38,8,116,98,84,76,60,52,20,0,33,0,64,52,46,32,28,
14,8,0,13,23,7,1,0,6,4,18,3,4,6,18,34,32,38,8,116,
98,84,76,60,52,20,0,33,0,0,0,0,122,16,25,122,16,25,77,39,
32,20,12,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,23,51,67,3,
22,1,104,16,11,97,53,37,7,49,79,71,85,31,79,63,73,89,81,89,
83,22,5,13,57,7,45,35,73,19,55,41,91,22,27,11,83,45,27,21,
5,8,1,19,16,10,9,6,1,1,4,25,26,10,40,38,32,36,34,30,
38,24,14,40,32,21,65,45,51,31,39,31,13,27,25,23,27,13,17,11,
21,63,45,63,15,19,3,9,8,12,2,3,16,10,1,9,2,37,84,82,
62,68,82,66,36,70,58,26,40,30,10,2,7,30,18,22,24,16,8,24,
12,6,12,0,3,6,51,120,122,116,124,118,116,116,116,112,94,92,86,68,
58,22,86,74,38,94,74,76,66,56,50,54,34,14,6,6,29,29,69,9,
54,36,24,6,10,0,13,19,39,2,82,54,42,34,26,4,11,15,27,35,
44,24,14,4,2,11,19,33,63,47,5,11,7,13,21,41,47,73,15,70,
38,24,8,8,13,23,29,41,124,47,29,17,5,13,2,10,12,13,8,18,
10,29,15,13,22,16,28,22,44,48,38,20,32,34,30,13,6,15,59,47,
37,35,29,29,27,25,11,21,19,13,5,23,37,57,37,65,25,11,13,3,
9,3,6,1,3,7,0,1,9,33,88,78,82,78,70,82,74,68,60,58,
60,50,14,18,4,50,48,40,18,30,24,2,3,11,23,29,55,25,69,124,
124,122,122,114,104,98,86,84,76,70,56,44,16,11,82,82,28,86,96,74,
62,66,58,48,56,44,36,16,16,1,37,30,10,15,83,61,69,23,29,25,
30,7,7,9,12,56,32,68,1,112,108,86,70,44,36,17,37,69,17,82,
58,40,18,20,4,1,9,41,59,43,25,31,17,1,15,19,1,4,6,4,
14,20,6,110,106,94,80,70,58,26,4,31,0,0,0,0,122,16,25,122,
16,25,77,39,32,20,12,44,84,102,42,8,23,50,35,35,4,2,10,11,
12,72,76,32,21,87,71,67,17,35,35,4,47,23,50,10,31,51,67,19,
23,47,75,0,33,61,7,33,47,73,12,23,19,45,40,6,44,0,0,0,
23,51,67,3,22,1,46,33,91,63,25,37,2,1,29,25,71,0,47,29,
61,51,33,43,37,28,1,13,61,21,61,35,73,3,27,17,49,26,13,1,
45,37,27,27,11,0,3,23,4,10,13,6,7,11,8,19,46,9,2,38,
40,54,50,32,39,13,19,8,7,43,7,10,13,19,1,36,88,42,9,37,
27,7,66,76,77,7,2,41,12,1,3,0,66,112,86,16,33,79,24,86,
108,87,42,42,46,50,50,42,30,42,46,18,32,26,12,8,3,24,20,18,
18,8,16,30,14,21,14,16,11,26,13,102,120,84,64,80,96,124,106,60,
22,6,18,38,34,57,24,32,7,62,28,28,34,42,34,48,48,0,59,9,
13,6,85,61,2,18,20,8,17,27,37,37,75,35,38,14,4,9,5,21,
39,41,61,19,44,18,8,0,2,13,23,35,57,23,28,4,14,10,5,23,
27,47,11,62,26,22,12,8,7,21,23,29,124,87,83,69,79,67,65,65,
61,57,59,57,55,43,49,53,61,39,47,15,35,37,33,23,15,17,7,21,
9,13,7,9,10,9,27,3,9,19,4,0,5,5,12,1,15,21,13,33,
9,8,1,6,11,5,9,10,6,13,17,23,23,0,124,116,122,122,122,124,
124,124,122,124,124,124,114,90,48,124,120,118,120,88,70,48,66,56,40,16,
6,7,31,96,90,96,68,38,46,34,24,40,30,16,11,8,13,33,34,42,
16,38,48,24,14,6,4,21,3,17,33,91,15,23,37,24,5,23,23,7,
1,0,8,6,20,3,6,8,20,34,34,38,10,116,94,80,72,56,48,16,
3,35,0,66,52,48,32,30,14,8,2,13,23,7,1,0,8,6,20,3,
6,8,20,34,34,38,10,116,94,80,72,56,48,16,3,35,0,0,0,0,
120,16,25,120,16,25,73,37,32,20,12,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,21,51,67,3,20,1,104,16,11,95,51,37,7,47,75,67,
81,29,75,61,69,87,79,87,81,24,5,11,55,7,43,33,69,19,55,41,
89,22,27,11,81,45,25,21,5,8,1,17,16,10,9,6,1,1,4,25,
26,10,38,38,30,36,34,30,34,24,14,36,30,23,63,43,49,29,37,29,
11,25,25,21,25,13,17,11,23,61,43,63,15,19,1,9,6,14,2,3,
14,12,3,11,2,39,82,80,62,66,80,64,34,68,58,24,38,30,10,2,
7,28,16,20,22,14,6,22,10,2,10,1,5,4,51,116,120,112,120,114,
112,112,112,108,90,88,82,62,54,16,82,70,34,90,70,72,62,52,46,48,
30,10,4,2,31,31,69,9,54,36,24,6,10,0,13,19,37,2,82,54,
42,34,28,6,9,15,25,33,46,26,14,4,4,9,19,31,61,45,3,9,
7,13,19,39,45,71,13,70,38,24,8,10,11,21,27,39,124,47,29,15,
5,13,2,10,12,13,8,18,12,29,15,13,20,16,26,20,42,46,38,18,
30,34,30,15,4,17,57,45,35,35,27,29,25,23,11,21,19,13,7,23,
37,57,35,65,25,11,13,1,9,3,8,1,3,7,2,3,9,35,86,78,
82,76,68,80,72,66,58,56,58,48,12,16,2,48,46,36,14,28,22,0,
5,11,23,29,55,27,67,124,124,118,118,108,100,94,82,80,72,66,52,40,
14,13,78,78,26,82,92,70,58,62,54,44,52,40,32,12,12,5,39,26,
6,19,81,59,67,21,27,23,34,5,5,9,14,60,34,72,0,110,104,82,
64,38,30,23,41,71,17,82,58,40,18,20,4,1,9,39,57,41,23,29,
15,0,13,17,0,6,8,4,16,20,6,108,104,90,76,66,54,22,0,33,
0,0,0,0,120,16,25,120,16,25,73,37,32,20,12,40,80,100,44,8,
19,46,35,31,4,2,12,13,10,70,72,26,25,89,67,65,17,35,31,4,
47,21,50,10,29,49,65,21,25,47,75,0,33,59,7,33,47,73,12,23,
19,43,40,6,44,0,0,0,21,51,67,3,20,1,46,31,89,59,23,35,
6,2,27,23,67,2,45,27,57,53,33,43,37,28,1,11,57,21,59,33,
69,3,27,17,49,26,13,0,43,37,25,27,11,0,1,21,6,10,13,6,
7,11,8,19,46,9,2,38,40,54,50,32,39,11,17,6,7,43,7,12,
13,17,0,38,90,46,5,39,29,5,66,76,79,7,2,41,14,1,3,2,
66,112,86,18,35,77,22,80,102,85,42,42,46,48,50,42,30,42,46,16,
30,26,12,8,3,24,18,16,18,8,16,28,12,23,12,14,11,24,13,98,
116,80,62,76,92,118,102,58,18,2,16,34,30,59,22,30,11,60,26,26,
32,38,30,44,44,1,59,11,15,2,81,57,4,20,20,8,15,25,35,35,
71,33,40,16,6,7,3,19,37,39,57,17,46,20,10,0,4,11,21,33,
55,23,30,6,14,10,3,21,27,45,9,62,28,22,12,10,5,19,21,27,
124,85,79,65,75,65,63,61,57,53,55,53,51,41,47,51,59,33,47,17,
35,35,31,23,15,17,7,21,9,15,7,9,12,9,27,3,9,19,4,0,
5,7,10,1,15,21,11,35,9,10,3,6,11,5,9,10,6,13,15,23,
23,3,122,114,120,118,118,124,124,124,118,120,124,122,108,84,44,122,114,110,
110,82,66,44,62,52,36,14,4,9,31,92,86,92,64,34,42,32,20,36,
26,12,15,4,17,35,32,40,12,36,44,22,10,4,2,23,5,19,33,89,
17,25,41,22,7,25,23,5,0,2,10,8,22,3,8,10,22,36,36,40,
12,114,90,76,68,52,44,12,7,37,2,66,54,50,34,32,16,10,2,11,
23,5,0,2,10,8,22,3,8,10,22,36,36,40,12,114,90,76,68,52,
44,12,7,37,0,0,0,0,116,14,27,116,14,27,71,35,32,20,10,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,21,53,67,3,18,3,104,14,
11,93,51,37,7,45,73,65,79,27,73,59,67,85,79,85,81,24,5,11,
55,7,43,33,67,19,55,41,87,22,27,11,79,45,25,21,5,8,1,17,
16,10,11,4,1,3,4,25,24,8,36,38,28,34,34,28,30,22,12,32,
28,25,63,43,49,29,37,29,9,25,25,21,23,15,17,11,27,61,43,63,
15,21,1,9,4,14,2,3,10,12,5,13,2,41,78,78,60,64,78,62,
32,66,56,20,36,28,8,2,9,26,14,18,20,12,4,20,8,1,6,3,
9,0,51,112,116,108,116,110,106,106,106,102,84,82,76,56,48,10,78,66,
30,84,64,66,56,46,40,42,24,4,2,1,35,33,71,9,54,36,24,6,
10,1,13,19,37,2,82,54,42,34,30,6,9,15,25,33,46,26,14,4,
4,9,19,31,59,45,1,9,7,13,19,39,45,69,13,70,38,24,8,10,
11,21,27,39,124,47,29,15,5,13,2,10,12,13,8,18,12,29,15,15,
18,16,24,18,40,44,36,14,26,32,28,17,0,19,57,45,33,35,27,29,
25,23,13,21,19,13,9,23,37,57,35,67,25,11,13,1,11,3,8,3,
5,7,2,5,11,37,84,76,80,74,64,78,70,64,56,54,56,46,10,12,
1,44,42,32,10,24,18,1,7,13,23,29,55,29,67,124,122,114,112,102,
94,88,76,74,66,60,46,34,10,15,74,74,22,78,86,64,52,56,48,40,
46,34,26,8,6,9,43,22,2,23,79,57,65,21,27,23,36,5,5,9,
14,62,36,74,0,106,100,76,56,32,24,29,47,75,17,82,56,38,18,20,
4,3,9,39,57,41,23,29,13,0,13,17,0,6,8,4,16,20,4,104,
100,86,72,62,50,16,3,35,0,0,0,0,116,14,27,116,14,27,71,35,
32,20,10,36,76,98,44,8,17,42,35,29,2,0,14,15,6,66,68,18,
31,91,63,63,17,35,29,2,47,21,50,8,29,49,63,25,29,49,77,1,
33,59,9,35,47,73,10,23,19,43,40,4,44,0,0,0,21,53,67,3,
18,3,44,31,87,55,21,35,8,4,27,21,65,2,43,27,53,55,35,45,
39,28,3,11,53,21,59,33,67,3,27,17,49,26,15,0,43,37,25,27,
11,0,1,19,6,10,15,4,7,11,6,19,46,9,2,38,40,54,50,32,
41,11,17,4,7,43,9,12,13,17,2,40,90,48,3,41,33,5,66,76,
81,9,2,43,14,3,3,4,66,110,86,20,37,75,18,74,94,83,40,42,
44,46,48,40,28,40,44,14,28,24,10,6,5,22,16,14,16,6,14,26,
10,27,10,12,11,20,15,92,110,76,58,72,86,110,96,54,14,3,12,28,
26,63,18,26,15,56,24,24,28,34,26,40,40,5,59,13,17,1,79,55,
6,20,20,8,15,25,35,35,69,31,40,16,6,7,1,17,35,39,53,17,
46,20,10,0,4,11,21,33,53,23,32,8,14,8,3,21,27,45,9,62,
28,22,12,12,5,19,21,27,124,83,77,63,73,63,61,59,55,51,53,51,
47,41,47,51,59,27,47,21,35,35,31,23,15,17,9,21,11,17,9,9,
12,11,27,5,9,19,2,1,7,9,8,3,17,21,9,37,11,10,5,4,
11,7,9,8,4,13,15,23,23,7,118,112,116,114,112,124,124,124,112,114,
124,116,100,78,40,114,106,102,98,76,60,40,56,46,32,10,0,11,31,86,
80,86,60,28,38,28,14,32,20,8,21,1,21,39,28,36,6,32,40,18,
6,0,1,25,7,21,35,87,21,29,45,18,11,29,23,5,0,2,12,8,
22,3,10,10,24,36,36,40,12,112,86,72,62,46,40,6,11,41,2,66,
54,50,34,32,16,10,2,11,23,5,0,2,12,8,22,3,10,10,24,36,
36,40,12,112,86,72,62,46,40,6,11,41,0,0,0,0,114,14,27,114,
14,27,67,31,34,22,10,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
19,53,67,1,18,3,104,14,11,89,49,37,5,41,69,61,75,23,69,55,
63,81,77,83,79,26,3,9,53,5,41,31,63,17,53,39,83,24,25,9,
75,43,23,19,3,10,0,15,18,12,11,4,0,3,4,23,24,8,36,38,
28,34,34,28,28,22,12,30,26,25,61,41,47,27,35,27,7,23,23,19,
19,15,17,9,29,59,41,63,13,21,0,7,4,16,2,3,8,14,5,15,
2,41,76,78,60,64,78,62,32,66,56,18,36,28,8,2,9,26,14,18,
20,12,2,20,8,3,4,3,11,1,51,110,114,106,114,108,102,102,102,98,
80,78,72,52,44,6,76,64,28,80,60,62,52,42,36,38,20,0,2,3,
37,33,71,7,56,38,26,8,10,1,11,17,35,4,84,56,44,34,32,8,
7,13,23,31,48,28,16,6,6,7,17,29,55,43,2,7,5,11,17,37,
43,65,11,72,40,26,10,12,9,19,25,37,124,45,27,13,5,11,2,12,
14,11,10,20,14,27,15,15,18,18,24,18,38,44,36,12,24,32,28,17,
1,19,55,43,31,33,25,27,23,21,13,19,17,11,9,21,35,55,33,67,
25,9,13,0,11,3,10,3,5,5,4,5,11,37,84,76,80,74,62,78,
70,64,56,54,56,46,10,10,3,42,40,30,8,22,16,1,7,13,21,27,
53,29,65,120,118,110,108,98,90,84,72,70,62,56,42,30,8,15,72,72,
20,76,82,60,48,52,44,36,42,30,22,6,2,11,45,20,0,25,75,53,
61,19,25,21,40,3,3,9,16,66,40,78,2,104,98,72,50,28,20,33,
51,77,15,84,56,38,18,22,4,3,9,37,55,39,21,27,9,2,11,15,
2,8,10,6,18,22,4,102,98,84,70,60,48,12,5,35,0,0,0,0,
114,14,27,114,14,27,67,31,34,22,10,34,74,98,46,10,13,40,33,25,
2,0,18,15,4,64,66,12,35,91,59,59,15,33,25,2,45,19,52,8,
27,47,59,27,31,49,77,1,31,57,9,35,45,71,10,21,17,41,42,4,
44,0,0,0,19,53,67,1,18,3,44,29,83,49,17,33,12,8,25,17,
61,4,39,25,47,55,35,45,39,30,3,9,47,19,57,31,63,3,25,17,
47,28,15,2,41,35,23,25,9,2,0,17,8,12,15,4,5,9,6,17,
48,7,2,40,42,56,52,34,41,9,15,4,7,41,9,14,11,15,6,44,
92,52,0,41,35,3,68,78,81,9,4,43,16,3,1,8,66,110,88,24,
39,71,16,70,88,79,40,42,44,46,48,40,28,40,44,14,28,24,10,6,
5,22,16,14,16,6,14,26,10,29,10,12,11,18,15,88,106,74,56,70,
82,104,92,52,12,7,10,24,24,65,16,24,17,54,24,24,26,32,24,38,
38,7,59,13,17,3,75,51,10,22,20,8,13,23,33,33,65,27,42,18,
8,5,2,15,31,37,47,15,48,22,12,2,6,9,19,31,49,21,36,10,
16,8,1,19,25,43,7,64,30,24,14,14,3,17,19,25,124,79,73,59,
69,59,57,55,51,47,49,47,41,39,45,49,57,19,45,23,33,33,29,21,
15,15,9,19,11,17,9,9,14,11,27,5,9,17,2,1,7,9,8,3,
17,19,5,37,11,12,5,4,11,7,7,8,4,11,13,21,21,9,116,110,
114,112,108,120,120,118,108,110,118,112,94,74,36,108,100,96,88,72,56,38,
52,42,30,8,1,11,31,82,76,82,56,24,36,26,10,30,16,6,25,5,
23,41,26,34,2,30,38,16,4,1,3,27,7,21,35,85,23,31,47,16,
13,31,21,3,2,4,16,10,24,1,14,12,26,38,38,42,14,112,84,70,
58,42,38,2,13,43,4,68,56,52,36,34,18,12,4,9,21,3,2,4,
16,10,24,1,14,12,26,38,38,42,14,112,84,70,58,42,38,2,13,43,
0,0,0,0,112,14,27,112,14,27,63,29,34,22,10,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,17,53,67,1,16,3,104,14,11,87,47,37,
5,39,65,57,73,21,65,53,59,79,75,81,77,28,3,7,51,5,41,29,
59,17,53,39,81,24,25,9,73,43,21,19,3,10,0,13,18,12,13,4,
0,3,4,23,24,8,34,38,26,34,34,28,24,22,12,26,24,27,59,39,
45,25,33,25,5,21,23,17,17,15,17,9,31,59,39,63,13,21,2,7,
2,18,2,3,6,16,7,17,2,43,72,76,58,62,76,60,30,64,56,16,
34,28,8,2,9,24,12,16,18,10,0,18,6,7,2,5,13,3,51,106,
112,102,110,104,98,98,98,92,76,74,66,46,40,0,72,60,24,76,56,58,
48,38,32,32,16,3,0,7,39,35,71,7,56,38,26,8,10,1,11,17,
33,4,84,56,44,34,34,8,5,13,21,29,50,30,16,6,8,7,17,27,
53,41,4,5,5,11,15,35,41,63,11,72,40,26,10,14,7,17,23,35,
124,45,27,13,5,11,2,12,14,11,10,20,16,27,15,15,16,18,22,16,
36,42,36,10,22,32,28,19,3,21,53,41,29,33,25,27,21,19,13,19,
17,11,11,21,35,55,31,67,25,9,13,2,11,3,12,3,5,5,6,7,
11,39,82,76,80,72,60,76,68,62,54,52,54,44,8,8,5,38,38,26,
4,20,14,3,9,13,21,27,53,31,63,116,114,106,104,92,86,80,66,66,
58,52,38,26,6,17,68,68,18,72,78,56,44,48,40,32,38,26,18,2,
1,15,47,16,3,29,73,51,59,17,23,19,44,1,1,9,18,68,42,80,
4,102,94,66,44,22,14,39,55,79,15,84,56,38,18,22,4,3,9,35,
53,37,19,25,7,4,9,13,4,10,12,6,20,22,4,100,94,80,66,56,
44,8,9,37,0,0,0,0,112,14,27,112,14,27,63,29,34,22,10,30,
70,96,48,10,9,36,33,23,2,0,20,17,2,62,62,6,39,93,55,57,
15,33,23,2,45,17,52,8,25,45,57,29,33,49,77,1,31,55,9,35,
45,71,10,21,17,39,42,4,44,0,0,0,17,53,67,1,16,3,44,27,
81,45,15,31,16,12,23,15,57,6,37,23,43,57,35,45,39,30,3,7,
43,19,55,29,59,3,25,17,47,28,15,2,39,35,21,25,9,2,0,15,
10,12,15,4,5,9,6,17,48,7,2,40,42,56,52,34,43,7,13,2,
7,41,9,16,11,15,8,46,94,56,4,43,37,3,68,78,83,9,4,45,
18,3,1,10,66,110,88,26,41,69,14,64,82,77,40,42,44,44,46,40,
28,40,42,12,26,24,10,6,5,20,14,12,16,6,14,24,8,31,8,10,
11,16,17,84,102,70,52,66,78,98,88,50,8,11,6,20,20,67,14,22,
21,52,22,22,24,28,20,34,34,11,59,15,19,7,73,49,12,24,20,8,
11,21,31,31,61,25,44,20,10,3,4,13,29,35,43,13,48,22,12,2,
8,7,17,29,47,21,38,12,16,8,0,17,25,41,5,64,32,24,14,16,
1,15,17,23,124,77,69,55,65,57,55,51,47,45,45,43,37,37,43,47,
55,13,45,25,33,31,27,21,15,15,9,19,11,19,9,9,16,11,27,5,
9,17,2,1,7,11,6,3,17,19,3,39,11,14,7,4,11,7,7,8,
4,11,11,21,21,13,114,108,112,108,104,114,114,112,104,104,112,106,88,68,
32,100,92,88,78,66,52,34,48,38,26,6,3,13,31,78,72,78,52,20,
32,22,6,26,12,2,29,9,27,43,24,32,1,26,34,12,0,3,5,29,
9,23,35,83,25,33,51,14,15,33,21,3,4,6,18,12,26,1,16,14,
28,38,40,44,16,110,80,66,54,38,34,1,17,45,6,68,56,54,38,36,
18,14,4,7,21,3,4,6,18,12,26,1,16,14,28,38,40,44,16,110,
80,66,54,38,34,1,17,45,0,0,0,0,110,14,27,110,14,27,59,25,
36,22,8,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,17,53,67,0,
14,3,104,14,11,85,45,37,3,37,61,53,69,19,61,51,55,77,73,79,
75,30,3,5,49,5,39,29,55,17,51,37,79,24,25,7,69,41,19,19,
3,10,0,11,20,14,13,4,0,3,4,23,24,6,34,38,24,34,34,28,
20,22,10,22,22,29,57,37,43,23,31,25,3,21,21,15,15,15,17,9,
33,57,37,63,13,21,4,7,0,20,2,3,4,18,7,19,2,45,70,74,
58,60,74,58,30,62,54,14,32,28,8,2,11,22,10,14,16,8,1,16,
6,11,0,5,15,5,51,104,108,100,106,100,94,94,94,88,70,70,62,42,
34,3,68,56,22,72,52,52,42,34,26,28,12,9,1,11,41,37,71,7,
58,38,26,8,10,1,11,17,33,4,84,56,44,34,36,10,5,11,21,27,
52,30,18,6,10,5,15,27,51,39,6,3,3,11,13,33,39,61,9,72,
40,26,10,16,7,15,21,33,124,43,25,11,5,11,2,12,14,11,10,20,
16,27,15,15,16,20,20,14,34,40,36,8,20,32,28,19,5,21,51,39,
27,31,23,25,21,17,13,19,17,9,11,21,35,53,29,67,25,9,13,4,
11,3,14,3,5,5,8,9,11,41,80,74,78,70,58,74,66,60,52,50,
52,42,6,6,7,36,36,24,0,16,12,5,9,15,21,27,53,31,61,112,
110,102,100,86,82,76,62,62,54,48,32,22,2,19,64,66,14,68,74,52,
40,44,36,28,34,22,12,1,5,19,49,12,7,31,71,49,57,15,21,17,
46,0,0,9,20,72,46,84,6,98,92,62,38,16,8,45,59,81,15,84,
56,38,18,22,4,3,9,35,51,35,17,23,5,4,9,11,4,10,12,6,
20,22,4,98,92,76,62,52,40,4,13,39,0,0,0,0,110,14,27,110,
14,27,59,25,36,22,8,26,68,94,48,10,5,34,33,19,2,1,22,19,
0,60,58,1,43,95,51,53,15,33,19,2,43,15,54,8,23,43,55,31,
35,49,79,1,31,53,9,37,45,71,10,21,17,37,44,4,44,0,0,0,
17,53,67,0,14,3,42,27,79,41,13,29,18,14,21,13,53,8,35,21,
39,59,35,45,39,32,3,5,39,19,53,27,55,3,25,17,47,30,15,4,
37,35,19,25,9,2,2,13,10,12,15,4,5,9,6,17,48,7,2,42,
42,58,52,36,43,7,11,2,7,41,9,18,11,13,10,48,96,58,8,43,
39,1,68,78,85,9,6,45,18,3,1,12,66,110,88,28,43,65,12,58,
76,73,40,42,42,42,46,38,26,40,42,10,24,24,10,6,7,20,12,10,
14,6,14,22,8,33,8,8,11,14,17,80,98,66,50,62,74,92,82,48,
4,15,4,16,16,71,12,20,25,50,20,20,22,26,16,30,30,13,59,17,
21,9,69,45,16,24,20,8,9,19,29,29,57,23,46,22,12,3,6,11,
25,33,39,13,50,24,14,4,10,7,17,27,45,21,42,14,16,8,2,17,
25,39,3,66,34,26,14,18,1,13,17,23,124,73,67,53,61,55,51,49,
45,41,41,39,33,37,41,47,53,7,45,27,33,29,25,21,15,15,9,17,
11,21,9,9,16,11,27,5,9,17,0,1,7,13,4,3,17,19,1,41,
11,16,9,4,11,7,5,8,2,9,9,21,21,15,112,106,110,104,100,110,
110,106,98,98,106,100,82,62,28,92,86,80,68,60,48,30,44,32,22,4,
5,15,31,74,68,74,48,16,28,20,2,22,8,1,33,13,31,45,22,30,
5,24,30,10,3,7,9,31,11,25,35,81,27,37,53,12,17,35,21,1,
4,6,20,14,28,1,18,16,30,40,42,44,18,110,76,62,50,34,30,5,
21,47,6,70,58,56,38,38,20,14,6,7,21,1,4,6,20,14,28,1,
18,16,30,40,42,44,18,110,76,62,50,34,30,5,21,47,0,0,0,0,
106,14,27,106,14,27,57,23,36,22,8,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,15,55,67,0,12,3,104,14,11,83,43,37,3,33,59,49,
67,17,59,47,51,75,73,77,75,30,3,3,47,5,39,27,51,17,51,37,
77,24,23,7,67,41,19,19,1,10,0,11,20,14,15,2,0,3,4,23,
24,6,32,38,24,34,34,26,16,22,10,18,20,31,55,35,41,21,31,23,
1,19,21,13,13,15,17,7,35,57,35,63,13,21,4,7,1,22,2,3,
0,20,9,21,2,47,66,72,56,58,72,56,28,60,54,10,30,26,8,2,
11,20,10,12,16,6,3,14,4,15,1,7,17,7,51,100,106,96,102,96,
90,88,90,82,66,66,56,36,30,9,64,54,18,66,48,48,38,28,22,22,
8,13,3,13,45,39,71,7,58,40,26,8,10,1,11,17,31,6,86,56,
44,34,38,10,3,11,19,27,54,32,18,6,10,5,15,25,49,39,8,3,
3,11,11,31,39,59,9,74,40,26,10,18,5,15,19,31,124,43,25,11,
5,11,2,12,14,9,10,20,18,27,15,15,14,20,18,12,32,38,36,4,
18,30,28,21,7,23,51,39,25,31,23,25,19,15,15,19,17,9,13,21,
35,53,27,67,25,7,13,4,11,3,16,3,7,5,10,9,13,43,78,74,
78,68,56,72,64,58,50,48,50,40,4,4,9,32,32,20,3,14,10,7,
11,15,21,27,53,33,61,106,104,98,94,80,78,72,56,58,50,44,28,18,
0,21,60,62,12,64,70,48,36,38,32,24,30,18,8,5,9,23,51,8,
11,35,69,47,55,15,19,15,50,2,2,9,22,74,48,86,6,96,88,56,
32,10,2,51,63,83,15,84,56,38,18,22,4,3,9,33,49,33,15,23,
3,6,7,9,6,12,14,8,22,24,4,94,88,72,58,48,36,0,17,41,
0,0,0,0,106,14,27,106,14,27,57,23,36,22,8,22,64,92,50,10,
3,30,33,17,0,1,24,21,3,56,54,7,49,97,47,51,15,33,17,0,
43,13,54,6,23,41,51,33,39,51,79,1,29,51,11,37,45,71,10,21,
17,37,44,4,44,0,0,0,15,55,67,0,12,3,42,25,77,37,11,27,
22,18,21,11,49,10,33,19,33,59,37,45,41,32,5,3,33,17,53,27,
51,3,25,17,47,30,15,4,35,35,19,23,9,2,2,11,12,12,17,2,
5,9,6,17,48,7,2,42,42,58,52,36,45,5,11,0,7,39,9,20,
9,13,14,52,98,62,12,45,41,1,70,78,87,9,6,47,20,3,1,14,
66,110,88,32,45,63,10,52,70,71,38,42,42,42,44,38,26,40,40,8,
22,22,10,6,7,18,12,8,14,4,12,20,6,35,6,6,11,10,19,76,
94,62,46,60,70,84,78,46,0,21,0,12,12,73,8,18,27,48,18,18,
18,22,12,26,28,17,59,19,23,13,67,43,18,26,20,8,7,17,27,29,
53,19,48,22,12,1,10,9,23,31,33,11,50,24,14,4,12,5,15,27,
43,21,44,16,16,8,4,15,25,37,1,66,36,26,14,20,0,11,15,21,
124,71,63,49,59,53,49,45,41,39,39,35,27,35,39,45,51,1,43,29,
31,27,25,21,15,15,11,17,13,23,9,9,18,11,27,5,9,15,0,3,
7,15,2,5,17,19,0,43,13,16,9,2,11,7,5,6,2,9,9,21,
21,19,110,104,108,102,94,104,104,100,94,92,98,94,74,58,24,84,78,72,
58,54,44,26,40,28,18,0,7,17,31,68,62,68,44,12,24,16,1,18,
4,5,37,19,33,49,20,28,11,20,28,6,7,9,11,33,13,27,35,79,
31,39,57,8,19,37,21,1,6,8,22,14,28,0,20,18,32,40,44,46,
18,108,72,58,46,30,26,11,25,51,8,70,58,56,40,38,20,16,6,5,
21,1,6,8,22,14,28,0,20,18,32,40,44,46,18,108,72,58,46,30,
26,11,25,51,0,0,0,0,104,14,27,104,14,27,53,19,36,22,6,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,15,55,67,2,10,3,104,14,
11,81,41,37,1,31,55,45,63,15,55,45,47,73,71,75,73,32,3,1,
45,5,37,25,47,17,51,35,73,26,23,5,65,39,17,19,1,12,2,9,
22,16,15,2,0,3,4,23,24,4,30,38,22,34,34,26,12,22,8,16,
18,33,53,33,39,19,29,21,0,17,19,11,11,15,17,7,37,55,33,63,
11,21,6,7,3,24,2,3,1,22,9,23,2,47,64,70,56,56,70,54,
26,60,54,8,28,26,8,2,13,20,8,10,14,4,5,14,2,19,3,9,
19,9,51,96,104,92,98,94,86,84,86,78,62,62,52,32,26,13,60,50,
14,62,44,44,34,24,18,16,4,19,5,17,47,39,71,7,58,40,26,8,
10,1,11,17,31,6,86,56,44,34,40,12,1,11,17,25,56,34,18,8,
12,3,13,25,47,37,12,1,3,9,9,29,37,57,7,74,42,26,10,20,
3,13,17,29,124,43,25,9,5,11,2,12,14,9,10,22,18,27,15,15,
12,22,16,10,30,38,36,2,16,30,28,23,9,23,49,37,23,29,21,23,
19,13,15,19,17,9,15,21,35,51,25,67,25,7,13,6,11,3,18,3,
7,5,12,11,13,43,76,74,76,68,54,70,62,56,50,46,48,38,2,2,
11,30,30,18,7,12,8,9,13,17,21,25,53,33,59,102,100,94,90,76,
74,68,52,54,46,40,24,14,3,23,56,58,10,60,66,44,32,34,28,20,
26,14,2,9,13,27,53,4,15,37,67,43,53,13,17,13,54,4,4,9,
24,78,52,90,8,92,84,52,26,6,3,55,67,85,15,84,56,38,18,22,
4,3,9,33,47,31,13,21,1,8,7,7,8,14,16,8,22,24,4,92,
86,70,56,44,32,3,21,43,0,0,0,0,104,14,27,104,14,27,53,19,
36,22,6,18,62,90,52,10,0,26,31,13,0,1,26,23,5,54,50,13,
53,97,43,49,15,31,13,0,43,11,54,6,21,39,49,35,41,51,79,1,
29,49,11,37,45,71,10,19,17,35,46,4,44,0,0,0,15,55,67,2,
10,3,40,25,73,31,9,25,24,20,19,9,45,12,31,17,29,61,37,45,
41,32,5,1,29,17,51,25,47,3,25,17,45,30,15,6,33,33,17,23,
9,4,4,9,12,12,17,2,3,9,6,17,50,7,2,44,44,58,52,36,
45,5,9,0,7,39,9,22,9,11,16,54,100,64,16,45,43,0,70,78,
89,9,8,47,22,3,1,18,66,110,88,34,47,59,8,48,64,69,38,42,
40,40,44,38,24,40,40,6,20,22,10,6,7,18,10,6,12,4,12,18,
6,37,4,6,11,8,19,72,90,60,44,56,66,78,72,44,3,25,1,8,
8,75,6,16,31,46,16,16,16,20,8,22,24,19,59,21,25,17,63,39,
20,26,20,8,5,15,25,27,49,17,50,24,14,0,12,7,19,29,29,9,
52,26,16,6,14,3,15,25,41,19,46,18,16,8,6,15,23,35,0,66,
38,26,14,22,2,9,15,19,124,69,61,47,55,51,45,43,37,35,35,31,
23,33,37,43,49,4,43,31,31,25,23,21,15,15,11,15,13,25,9,9,
20,11,27,5,9,15,1,3,7,17,0,5,17,19,2,43,13,18,11,2,
11,7,5,6,0,9,7,21,21,21,108,102,106,98,90,100,98,94,88,86,
92,88,68,52,20,76,72,64,48,48,40,24,36,22,14,1,9,19,31,64,
58,64,40,8,20,14,5,14,0,9,41,23,37,51,18,26,15,18,24,4,
11,11,13,35,15,29,35,77,33,41,59,6,21,39,21,0,6,10,24,16,
30,0,22,20,34,42,46,46,20,108,68,54,42,26,22,15,29,53,8,72,
60,58,42,40,22,16,6,3,21,0,6,10,24,16,30,0,22,20,34,42,
46,46,20,108,68,54,42,26,22,15,29,53,0,0,0,0,102,14,29,102,
14,29,49,17,38,22,6,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
13,55,67,2,10,5,104,14,11,79,41,37,1,29,51,41,61,13,51,43,
43,71,69,73,71,34,3,0,45,3,37,25,43,17,49,35,71,26,23,5,
61,39,15,17,1,12,2,7,22,16,17,2,0,3,4,23,24,4,30,38,
20,34,34,26,8,22,8,12,16,35,53,31,39,19,27,21,2,17,19,11,
7,15,17,7,39,55,31,63,11,21,8,5,5,24,2,3,3,24,11,25,
2,49,60,68,54,56,68,54,26,58,52,6,26,26,8,2,13,18,6,8,
12,4,7,12,2,23,5,9,21,11,51,94,100,90,94,90,82,80,82,72,
56,58,46,26,20,19,56,46,12,58,38,38,28,20,12,12,1,23,7,21,
49,41,71,5,60,40,28,8,10,1,11,17,29,6,86,58,44,34,42,12,
1,9,17,23,58,34,20,8,14,3,13,23,45,35,14,0,1,9,9,29,
35,53,7,74,42,26,12,20,3,11,17,27,124,41,23,9,5,11,2,12,
14,9,12,22,20,27,15,17,12,22,14,8,28,36,36,0,14,30,28,23,
11,25,47,35,21,29,21,23,17,13,15,17,15,7,15,21,35,51,23,67,
25,7,13,8,11,3,20,5,7,5,12,13,13,45,74,72,76,66,52,70,
62,54,48,46,46,36,0,0,13,26,28,14,11,8,4,11,13,17,21,25,
51,35,57,98,96,90,86,70,70,64,46,50,40,36,18,10,5,23,54,56,
6,56,60,40,28,30,24,16,20,10,1,13,17,29,57,0,19,41,65,41,
51,11,15,11,56,6,6,9,26,80,54,92,10,90,82,46,20,0,7,61,
71,89,13,84,56,38,18,22,4,3,9,31,45,31,11,19,0,8,5,5,
8,14,16,8,24,24,4,90,82,66,52,42,30,9,23,45,0,0,0,0,
102,14,29,102,14,29,49,17,38,22,6,16,58,88,52,12,4,24,31,11,
0,3,28,25,7,52,48,21,57,99,39,45,15,31,11,0,41,9,56,6,
19,37,47,39,43,51,81,1,29,49,11,39,43,71,8,19,17,33,46,4,
44,0,0,0,13,55,67,2,10,5,40,23,71,27,7,23,28,24,17,7,
41,14,29,17,25,63,37,45,41,34,5,0,25,17,49,23,43,3,25,17,
45,32,17,6,33,33,15,23,7,4,4,7,14,12,17,2,3,9,6,17,
50,7,2,44,44,60,54,38,47,3,7,1,7,39,9,24,9,11,18,56,
100,68,18,47,45,0,70,78,89,11,8,49,22,5,0,20,66,110,90,36,
49,57,6,42,58,65,38,42,40,38,42,36,24,38,38,6,20,22,8,6,
9,16,8,4,12,4,12,18,4,41,4,4,11,6,21,66,86,56,40,52,
62,72,68,40,7,29,5,4,4,79,4,12,35,42,14,14,14,16,4,18,
20,23,59,23,27,19,61,37,24,28,20,8,3,15,25,25,47,15,52,26,
16,0,14,5,17,27,25,9,52,26,16,6,16,3,13,23,39,19,50,20,
16,8,6,13,23,35,0,68,38,28,14,24,2,9,13,19,124,65,57,43,
51,47,43,39,35,33,31,27,19,33,35,43,49,10,43,33,31,25,21,21,
15,15,11,15,13,27,9,9,20,11,27,5,9,15,1,3,7,19,1,5,
17,19,4,45,13,20,13,2,11,7,3,6,0,7,5,21,21,25,106,100,
104,94,86,94,94,88,84,80,86,82,62,46,16,70,64,56,38,44,34,20,
32,18,10,3,11,21,31,60,54,60,36,4,18,10,9,10,5,13,45,27,
41,53,16,22,19,14,20,0,15,15,17,37,17,31,37,75,35,45,63,4,
25,41,19,0,8,10,26,18,32,0,24,22,36,42,48,48,22,106,64,50,
38,22,18,19,33,55,10,72,60,60,42,42,22,18,8,3,19,0,8,10,
26,18,32,0,24,22,36,42,48,48,22,106,64,50,38,22,18,19,33,55,
0,0,0,0,100,14,29,100,14,29,45,13,38,22,4,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,13,55,67,4,8,5,104,14,11,77,39,37,
0,25,49,37,57,11,49,39,39,69,67,71,71,36,3,2,43,3,35,23,
39,17,49,33,69,26,21,3,59,37,15,17,0,12,2,5,24,18,17,0,
0,3,4,23,24,2,28,38,20,34,34,24,4,22,6,8,14,37,51,29,
37,17,25,19,4,15,17,9,5,15,17,5,41,53,29,63,11,21,8,5,
7,26,2,3,7,26,11,27,2,51,58,66,54,54,66,52,24,56,52,4,
24,26,8,2,15,16,6,6,12,2,9,10,0,27,7,11,23,13,51,90,
98,86,90,86,78,74,78,68,52,54,42,22,16,23,52,44,8,52,34,34,
24,14,8,6,5,29,9,23,53,43,71,5,60,42,28,8,10,1,11,17,
29,8,88,58,44,34,44,14,0,9,15,21,60,36,20,8,16,1,11,23,
43,35,16,0,1,9,7,27,35,51,5,76,42,26,12,22,1,9,15,25,
124,41,23,7,5,11,2,12,14,7,12,22,20,27,15,17,10,24,12,6,
26,34,36,1,12,28,28,25,13,25,45,35,19,27,19,21,17,11,15,17,
15,7,17,21,35,49,21,67,25,5,13,8,11,3,22,5,7,5,14,13,
15,47,72,72,74,64,50,68,60,52,46,44,44,34,1,1,15,24,24,12,
15,6,2,13,15,19,21,25,51,35,55,94,92,86,80,64,66,60,42,46,
36,32,14,6,9,25,50,52,4,52,56,36,24,26,20,12,16,6,7,17,
21,33,59,3,23,43,63,39,49,11,13,9,60,8,8,9,28,84,58,96,
10,86,78,42,14,5,13,67,75,91,13,84,56,38,18,22,4,3,9,31,
43,29,9,17,2,10,5,3,10,16,18,10,24,26,4,86,80,62,48,38,
26,13,27,47,0,0,0,0,100,14,29,100,14,29,45,13,38,22,4,12,
56,86,54,12,6,20,31,7,1,3,30,27,9,50,44,27,63,101,35,43,
15,31,7,1,41,7,56,6,19,35,43,41,45,51,81,1,27,47,13,39,
43,71,8,19,17,31,48,4,44,0,0,0,13,55,67,4,8,5,38,23,
69,23,5,21,30,26,15,5,37,16,27,15,19,63,39,45,43,34,5,2,
19,15,49,23,39,3,25,17,45,32,17,8,31,33,13,21,7,4,6,5,
14,12,19,2,3,9,6,17,50,7,2,46,44,60,54,38,47,3,7,1,
7,37,9,26,7,9,22,60,102,70,22,47,47,2,72,78,91,11,10,49,
24,5,0,22,66,110,90,40,51,53,4,36,52,63,38,42,38,38,42,36,
22,38,38,4,18,22,8,6,9,16,8,2,10,4,12,16,4,43,2,2,
11,4,21,62,82,52,38,50,58,66,62,38,11,33,7,0,0,81,2,10,
37,40,12,12,10,14,0,14,18,25,59,25,29,23,57,33,26,28,20,8,
1,13,23,25,43,11,54,28,16,2,18,3,13,25,19,7,54,28,18,8,
18,1,13,21,37,19,52,22,16,8,8,13,23,33,2,68,40,28,14,26,
4,7,13,17,124,63,55,41,49,45,39,37,31,29,27,23,13,31,33,41,
47,16,41,35,29,23,19,21,15,15,11,13,15,29,9,9,22,11,27,5,
9,13,3,5,7,21,3,7,17,19,6,47,15,22,13,0,11,7,3,4,
1,7,5,21,21,27,104,98,102,92,80,90,88,82,78,74,80,76,56,42,
12,62,58,48,28,38,30,16,28,12,6,5,13,23,31,56,48,54,32,0,
14,8,13,6,9,17,49,31,43,57,14,20,23,12,18,1,19,17,19,39,
19,33,37,73,39,47,65,0,27,43,19,2,8,12,28,20,32,2,26,24,
38,44,50,48,22,106,60,46,34,18,14,25,37,57,10,74,62,60,44,44,
24,18,8,1,19,2,8,12,28,20,32,2,26,24,38,44,50,48,22,106,
60,46,34,18,14,25,37,57,0,0,0,0,96,12,29,96,12,29,43,11,
38,22,4,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,11,57,67,4,
6,5,104,14,11,75,37,37,0,23,45,33,55,9,45,37,37,67,67,69,
69,36,3,4,41,3,35,23,37,17,49,33,67,26,21,3,57,37,13,17,
0,12,2,5,24,18,19,0,0,3,4,23,24,2,26,38,18,34,34,24,
0,22,6,4,12,39,49,27,35,15,25,19,6,15,17,7,3,15,17,5,
45,53,27,63,11,23,10,5,9,28,2,3,9,28,13,29,2,53,54,64,
52,52,64,50,22,54,50,0,22,24,8,2,15,14,4,4,10,0,11,8,
1,31,11,13,25,15,51,86,94,82,86,82,74,70,74,62,46,50,36,16,
10,29,48,40,4,48,30,28,18,10,2,0,9,33,11,27,55,45,73,5,
60,42,28,8,10,1,11,17,27,8,88,58,44,34,46,14,0,9,15,21,
62,36,20,8,16,1,11,21,41,33,18,2,1,9,5,25,33,49,5,76,
42,26,12,24,1,9,13,25,124,41,23,7,5,11,2,12,14,7,12,22,
22,27,15,17,8,24,10,4,24,32,36,5,8,28,28,27,15,27,45,33,
17,27,19,21,15,9,17,17,15,7,19,21,35,49,21,69,25,5,13,10,
11,3,22,5,9,5,16,15,15,49,70,70,74,62,46,66,58,50,44,42,
42,32,3,3,17,20,22,8,19,2,0,15,17,19,21,25,51,37,55,88,
86,82,76,58,60,54,36,42,32,28,8,2,11,27,46,48,0,48,52,30,
18,20,14,8,12,0,11,21,27,37,61,7,27,47,61,37,47,9,11,9,
62,10,8,9,28,86,60,98,12,84,74,36,8,11,19,73,79,93,13,84,
56,38,18,22,4,3,9,29,43,27,7,17,4,10,3,3,10,16,18,10,
26,26,2,84,76,58,44,34,22,17,31,49,0,0,0,0,96,12,29,96,
12,29,43,11,38,22,4,8,52,84,54,12,10,16,31,5,1,5,32,29,
13,46,40,35,67,103,31,41,15,31,5,1,41,7,56,4,17,33,41,43,
49,53,83,1,27,45,13,41,43,71,8,19,17,31,48,4,44,0,0,0,
11,57,67,4,6,5,38,21,67,19,3,21,34,30,15,3,33,16,25,13,
15,65,39,47,43,34,7,2,15,15,47,21,37,3,25,17,45,32,17,8,
29,33,13,21,7,4,6,3,16,12,19,0,3,9,4,17,50,7,2,46,
44,60,54,38,49,1,5,3,7,37,9,28,7,9,24,62,104,74,26,49,
49,2,72,78,93,11,10,51,24,5,0,24,66,110,90,42,53,51,2,30,
44,61,36,42,38,36,40,34,22,38,36,2,16,20,8,4,11,14,6,0,
10,2,10,14,2,45,0,0,11,0,23,58,78,48,34,46,52,58,58,36,
15,39,11,5,3,85,1,8,41,38,10,10,8,10,3,10,14,29,59,27,
31,27,55,31,28,30,20,8,1,11,21,23,39,9,54,28,18,2,20,1,
11,23,15,7,54,28,18,8,18,1,11,21,35,19,54,24,16,8,10,11,
23,31,4,68,42,28,14,28,4,5,11,17,124,61,51,37,45,43,37,33,
29,27,25,19,9,31,31,41,45,22,41,37,29,21,19,21,15,15,13,13,
15,31,9,9,22,11,27,7,9,13,3,5,9,23,5,7,19,19,8,49,
15,22,15,0,11,9,3,4,1,7,3,21,21,31,102,96,100,88,76,84,
82,76,74,68,72,70,48,36,8,54,50,40,18,32,26,12,22,8,2,9,
17,25,31,50,44,50,28,5,10,4,19,2,13,21,53,37,47,59,10,18,
29,8,14,5,23,21,23,41,21,35,37,71,41,51,69,1,29,45,19,2,
10,12,30,20,34,2,28,24,40,44,50,50,24,104,56,42,30,14,10,29,
41,61,12,74,62,62,44,44,24,20,8,1,19,2,10,12,30,20,34,2,
28,24,40,44,50,50,24,104,56,42,30,14,10,29,41,61,0,0,0,0,
94,12,29,94,12,29,39,9,40,22,4,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,9,57,67,4,4,5,104,14,11,73,35,37,0,21,41,29,
51,5,41,35,33,65,65,67,67,38,1,6,39,3,33,21,33,17,47,33,
63,28,21,3,53,37,11,17,0,14,4,3,24,18,19,0,2,3,4,21,
24,2,26,38,16,34,34,24,3,22,6,2,10,39,47,25,33,13,23,17,
8,13,17,5,1,15,17,5,47,51,25,63,9,23,12,5,11,30,2,3,
11,30,15,31,2,53,52,62,52,50,62,48,22,54,50,1,20,24,8,2,
15,14,2,2,8,1,13,8,1,33,13,13,27,17,51,84,92,80,84,80,
70,66,70,58,42,46,32,10,6,35,46,36,2,44,26,24,14,6,1,3,
13,37,11,31,57,45,73,5,62,42,28,10,10,1,9,17,25,8,88,58,
46,34,48,16,2,7,13,19,64,38,22,10,18,0,11,19,39,31,22,4,
0,7,3,23,31,47,3,76,44,28,12,26,0,7,11,23,124,39,21,5,
5,11,2,14,16,7,12,24,24,27,15,17,8,24,8,4,22,32,36,7,
6,28,28,27,17,29,43,31,15,27,17,21,13,7,17,17,15,5,19,21,
35,49,19,69,25,5,13,12,11,3,24,5,9,5,18,17,15,49,68,70,
74,62,44,64,56,48,44,40,40,32,3,5,19,18,20,4,23,0,1,15,
17,19,19,23,51,39,53,84,82,78,72,54,56,50,32,38,28,24,4,1,
13,29,42,46,1,44,48,26,14,16,10,4,8,3,15,23,31,41,63,11,
31,51,59,33,43,7,9,7,66,12,10,9,30,90,62,102,14,82,72,32,
2,15,25,77,83,95,13,84,56,38,18,24,4,3,9,27,41,25,5,15,
8,12,1,1,12,18,20,10,28,26,2,82,74,56,42,30,18,21,35,49,
0,0,0,0,94,12,29,94,12,29,39,9,40,22,4,4,48,84,56,12,
14,14,29,1,1,5,34,29,15,44,36,41,71,103,27,37,13,29,1,1,
39,5,58,4,15,31,39,45,51,53,83,1,27,43,13,41,43,71,8,17,
15,29,48,4,44,0,0,0,9,57,67,4,4,5,38,19,63,13,1,19,
38,34,13,1,29,18,21,11,11,67,39,47,43,36,7,4,11,15,45,19,
33,3,23,17,43,34,17,10,27,31,11,21,7,6,8,1,18,12,19,0,
1,7,4,17,52,7,2,46,46,62,54,40,49,0,3,5,7,37,9,30,
7,7,26,64,106,78,30,51,51,4,72,80,95,11,10,51,26,5,0,28,
66,110,90,44,55,49,0,26,38,57,36,42,38,34,40,34,22,38,36,0,
14,20,8,4,11,14,4,0,10,2,10,12,0,47,0,0,11,1,23,54,
74,46,32,42,48,52,54,34,19,43,13,9,5,87,3,6,45,36,8,8,
6,6,5,6,10,31,59,27,33,29,51,27,32,32,20,8,0,9,19,21,
35,7,56,30,20,4,22,0,9,21,11,5,56,30,20,8,20,0,9,19,
31,17,58,26,18,8,12,9,21,29,6,70,44,30,16,30,6,3,9,15,
124,57,47,33,41,41,35,29,25,23,21,15,5,29,29,39,43,30,41,39,
29,19,17,19,15,15,13,13,15,33,9,9,24,11,27,7,9,13,3,5,
9,23,7,7,19,17,12,49,15,24,17,0,11,9,1,4,1,5,1,19,
19,35,100,94,98,84,72,78,78,70,70,64,66,66,42,30,4,46,44,34,
8,26,22,10,18,4,0,11,19,27,31,46,40,46,24,9,6,2,23,1,
17,25,57,41,51,61,8,16,33,6,10,7,27,23,25,43,23,35,37,69,
43,53,73,3,31,47,19,4,12,14,34,22,36,2,30,26,42,46,52,52,
26,102,54,38,26,10,6,33,45,63,14,74,64,64,46,46,26,22,10,0,
19,4,12,14,34,22,36,2,30,26,42,46,52,52,26,102,54,38,26,10,
6,33,45,63,0,0,0,0,92,12,29,92,12,29,35,5,40,22,2,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,9,57,67,6,2,5,104,14,
11,71,33,37,2,17,39,25,49,3,39,31,29,63,63,65,67,40,1,8,
37,3,33,19,29,17,47,31,61,28,19,1,51,35,11,17,2,14,4,1,
26,20,21,1,2,3,4,21,24,0,24,38,16,34,34,22,7,22,4,1,
8,41,45,23,31,11,21,15,10,11,15,3,0,15,17,3,49,51,23,63,
9,23,12,5,13,32,2,3,15,32,15,33,2,55,48,60,50,48,60,46,
20,52,50,3,18,24,8,2,17,12,2,0,8,3,15,6,3,37,15,15,
29,19,51,80,90,76,80,76,66,60,66,52,38,42,26,6,2,39,42,34,
1,38,22,20,10,0,5,9,17,43,13,33,61,47,73,5,62,44,28,10,
10,1,9,17,25,10,90,58,46,34,50,16,4,7,11,17,66,40,22,10,
20,0,9,19,37,31,24,4,0,7,1,21,31,45,3,78,44,28,12,28,
2,5,9,21,124,39,21,5,5,11,2,14,16,5,12,24,24,27,15,17,
6,26,6,2,20,30,36,9,4,26,28,29,19,29,41,31,13,25,17,19,
13,5,17,17,15,5,21,21,35,47,17,69,25,3,13,12,11,3,26,5,
9,5,20,17,17,51,66,70,72,60,42,62,54,46,42,38,38,30,5,7,
21,14,16,2,27,1,3,17,19,21,19,23,51,39,51,80,78,74,66,48,
52,46,26,34,24,20,0,5,17,31,38,42,3,40,44,22,10,12,6,0,
4,7,21,27,35,45,65,15,35,53,57,31,41,7,7,5,70,14,12,9,
32,92,66,104,14,78,68,26,3,21,31,83,87,97,13,84,56,38,18,24,
4,3,9,27,39,23,3,13,10,14,1,0,14,20,22,12,28,28,2,78,
70,52,38,26,14,25,39,51,0,0,0,0,92,12,29,92,12,29,35,5,
40,22,2,0,46,82,58,12,16,10,29,0,3,5,36,31,17,42,32,47,
77,105,23,35,13,29,0,3,39,3,58,4,15,29,35,47,53,53,83,1,
25,41,15,41,43,71,8,17,15,27,50,4,44,0,0,0,9,57,67,6,
2,5,36,19,61,9,0,17,40,36,11,0,25,20,19,9,5,67,41,47,
45,36,7,6,5,13,45,19,29,3,23,17,43,34,17,10,25,31,9,19,
7,6,8,0,18,12,21,0,1,7,4,17,52,7,2,48,46,62,54,40,
51,0,3,5,7,35,9,32,5,7,30,68,108,80,34,51,53,4,74,80,
97,11,12,53,28,5,0,30,66,110,90,48,57,45,1,20,32,55,36,42,
36,34,38,34,20,38,34,1,12,20,8,4,11,12,4,1,8,2,10,10,
0,49,1,1,11,3,25,50,70,42,28,40,44,46,48,32,23,47,17,13,
9,89,5,4,47,34,6,6,2,4,9,2,8,35,59,29,35,33,49,25,
34,32,20,8,2,7,17,21,31,3,58,32,20,6,26,2,5,19,5,3,
56,30,20,10,22,2,9,17,29,17,60,28,18,8,14,9,21,27,8,70,
46,30,16,32,8,1,9,13,124,55,45,31,39,39,31,27,21,21,17,11,
0,27,27,37,41,36,39,41,27,17,15,19,15,15,13,11,17,35,9,9,
26,11,27,7,9,11,5,7,9,25,9,9,19,17,14,51,17,26,17,1,
11,9,1,2,3,5,1,19,19,37,98,92,96,82,66,74,72,64,64,58,
60,60,36,26,0,38,36,26,1,20,18,6,14,1,3,13,21,29,31,42,
34,40,20,13,2,1,27,5,21,29,61,45,53,65,6,14,37,2,8,11,
31,25,27,45,25,37,37,67,47,55,75,7,33,49,19,4,12,16,36,24,
36,4,32,28,44,46,54,52,26,102,50,34,22,6,2,39,49,65,14,76,
64,64,48,48,26,22,10,2,19,4,12,16,36,24,36,4,32,28,44,46,
54,52,26,102,50,34,22,6,2,39,49,65,0,0,0,0,90,12,31,90,
12,31,31,3,42,22,2,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
7,57,67,6,2,7,104,14,11,69,33,37,2,15,35,21,45,1,35,29,
25,61,61,63,65,42,1,10,37,1,31,19,25,17,45,31,59,28,19,1,
47,35,9,15,2,14,4,0,26,20,21,1,2,3,4,21,24,0,24,38,
14,34,34,22,11,22,4,5,6,43,45,21,31,11,19,15,12,11,15,3,
4,15,17,3,51,49,21,63,9,23,14,3,15,32,2,3,17,34,17,35,
2,57,46,58,50,48,58,46,20,50,48,5,16,24,8,2,17,10,0,1,
6,3,17,4,3,41,17,15,31,21,51,78,86,74,76,72,62,56,62,48,
32,38,22,0,3,45,38,30,3,34,16,14,4,3,11,13,23,47,15,37,
63,49,73,3,64,44,30,10,10,1,9,17,23,10,90,60,46,34,52,18,
4,5,11,15,68,40,24,10,22,2,9,17,35,29,26,6,2,7,1,21,
29,41,1,78,44,28,14,28,2,3,9,19,124,37,19,3,5,11,2,14,
16,5,14,24,26,27,15,19,6,26,4,0,18,28,36,11,2,26,28,29,
21,31,39,29,11,25,15,19,11,5,17,15,13,3,21,21,35,47,15,69,
25,3,13,14,11,3,28,7,9,5,20,19,17,53,64,68,72,58,40,62,
54,44,40,38,36,28,7,9,23,12,14,1,31,5,7,19,19,21,19,23,
49,41,49,76,74,70,62,42,48,42,22,30,18,16,5,9,19,31,36,40,
7,36,38,18,6,8,2,3,1,11,25,31,39,47,69,19,39,57,55,29,
39,5,5,3,72,16,14,9,34,96,68,108,16,76,66,22,9,27,35,89,
91,101,11,84,56,38,18,24,4,3,9,25,37,23,1,11,12,14,0,2,
14,20,22,12,30,28,2,76,68,48,34,24,12,31,41,53,0,0,0,0,
90,12,31,90,12,31,31,3,42,22,2,1,42,80,58,14,20,8,29,4,
3,7,38,33,19,40,30,55,81,107,19,31,13,29,4,3,37,1,60,4,
13,27,33,51,55,53,85,1,25,41,15,43,41,71,6,17,15,25,50,4,
44,0,0,0,7,57,67,6,2,7,36,17,59,5,2,15,44,40,9,2,
21,22,17,9,1,69,41,47,45,38,7,8,1,13,43,17,25,3,23,17,
43,36,19,12,25,31,7,19,5,6,10,2,20,12,21,0,1,7,4,17,
52,7,2,48,46,64,56,42,51,2,1,7,7,35,9,34,5,5,32,70,
108,84,36,53,55,6,74,80,97,13,12,53,28,7,2,32,66,110,92,50,
59,43,3,14,26,51,36,42,36,32,38,32,20,36,34,1,12,20,6,4,
13,12,2,3,8,2,10,10,1,53,1,3,11,5,25,44,66,38,26,36,
40,40,44,28,27,51,19,17,13,93,7,0,51,30,4,4,0,0,13,1,
4,37,59,31,37,35,45,21,38,34,20,8,4,7,17,19,29,1,60,34,
22,6,28,4,3,17,1,3,58,32,22,10,24,2,7,15,27,17,64,30,
18,8,14,7,21,27,8,72,46,32,16,34,8,1,7,13,124,51,41,27,
35,35,29,23,19,17,13,7,4,27,25,37,41,42,39,43,27,17,13,19,
15,15,13,11,17,37,9,9,26,11,27,7,9,11,5,7,9,27,11,9,
19,17,16,53,17,28,19,1,11,9,0,2,3,3,0,19,19,41,96,90,
94,78,62,68,68,58,60,52,54,54,30,20,3,32,30,18,11,16,12,2,
10,5,7,15,23,31,31,38,30,36,16,17,0,3,31,9,27,33,65,49,
57,67,4,10,41,0,4,13,35,29,31,47,27,39,39,65,49,59,79,9,
37,51,17,6,14,16,38,26,38,4,34,30,46,48,56,54,28,100,46,30,
18,2,1,43,53,67,16,76,66,66,48,50,28,24,12,2,17,6,14,16,
38,26,38,4,34,30,46,48,56,54,28,100,46,30,18,2,1,43,53,67,
0,0,0,0,86,12,31,86,12,31,29,0,42,22,0,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,7,59,67,8,0,7,104,14,11,67,31,37,
4,13,31,17,43,0,31,27,21,59,61,61,63,42,1,12,35,1,31,17,
21,17,45,29,57,28,19,0,45,33,7,15,2,14,4,0,28,22,23,1,
2,3,4,21,24,1,22,38,12,34,34,22,15,22,2,9,4,45,43,19,
29,9,19,13,14,9,13,1,6,15,17,3,53,49,19,63,9,23,16,3,
17,34,2,3,19,36,17,37,2,59,42,56,48,46,56,44,18,48,48,9,
14,22,8,2,19,8,1,3,4,5,19,2,5,45,19,17,33,23,51,74,
84,70,72,68,58,52,58,42,28,34,16,3,7,49,34,26,7,30,12,10,
0,7,15,19,27,53,17,41,65,51,73,3,64,44,30,10,10,1,9,17,
23,10,90,60,46,34,54,18,6,5,9,15,70,42,24,10,22,2,7,17,
33,27,28,8,2,7,0,19,27,39,1,78,44,28,14,30,4,3,7,17,
124,37,19,3,5,11,2,14,16,5,14,24,26,27,15,19,4,28,2,1,
16,26,36,15,0,26,28,31,23,31,39,27,9,23,15,17,11,3,19,15,
13,3,23,21,35,45,13,69,25,3,13,16,11,3,30,7,11,5,22,21,
17,55,62,68,70,56,38,60,52,42,38,36,34,26,9,11,25,8,12,3,
35,7,9,21,21,23,19,23,49,41,49,70,68,66,58,36,44,38,16,26,
14,12,9,13,23,33,32,36,9,32,34,14,2,2,1,7,5,15,31,35,
43,51,71,23,43,59,53,27,37,3,3,1,76,18,16,9,36,98,72,110,
18,72,62,16,15,33,41,95,95,103,11,84,56,38,18,24,4,3,9,25,
35,21,0,11,14,16,0,4,16,22,24,12,30,28,2,74,64,44,30,20,
8,35,45,55,0,0,0,0,86,12,31,86,12,31,29,0,42,22,0,5,
40,78,60,14,24,4,29,6,3,7,40,35,23,36,26,61,85,109,15,29,
13,29,6,3,37,0,60,2,11,25,31,53,59,55,85,1,25,39,15,43,
41,71,6,17,15,25,52,4,44,0,0,0,7,59,67,8,0,7,34,17,
57,1,4,13,46,42,9,4,17,24,15,7,2,71,41,47,45,38,9,10,
2,13,41,15,21,3,23,17,43,36,19,12,23,31,7,19,5,6,10,4,
20,12,21,1,1,7,4,17,52,7,2,50,46,64,56,42,53,2,0,7,
7,35,9,36,5,5,34,72,110,86,40,53,57,6,74,80,99,13,14,55,
30,7,2,34,66,110,92,52,61,39,5,8,20,49,34,42,34,30,36,32,
18,36,32,3,10,18,6,4,13,10,0,5,6,0,8,8,1,55,3,5,
11,9,27,40,62,34,22,32,36,32,38,26,31,57,23,21,17,95,11,1,
55,28,2,2,1,1,17,5,0,41,59,33,39,39,43,19,40,34,20,8,
6,5,15,17,25,0,62,34,24,8,30,6,0,15,2,1,58,32,22,12,
26,4,7,15,25,17,66,32,18,8,16,7,21,25,10,72,48,32,16,36,
10,0,7,11,124,49,39,25,31,33,25,21,15,15,11,3,8,25,23,35,
39,48,39,45,27,15,13,19,15,15,15,9,17,39,9,9,28,11,27,7,
9,11,7,7,9,29,13,9,19,17,18,55,17,28,21,1,11,9,0,2,
5,3,2,19,19,43,94,88,92,74,58,64,62,52,54,46,46,48,22,14,
7,24,22,10,21,10,8,1,6,11,11,19,25,33,31,32,26,32,12,21,
3,7,35,13,31,37,69,55,61,69,2,8,47,3,0,17,39,31,33,49,
29,41,39,63,51,61,81,11,39,53,17,6,14,18,40,26,40,4,36,32,
48,48,58,54,30,100,42,26,14,1,5,47,57,71,16,78,66,68,50,50,
28,24,12,4,17,6,14,18,40,26,40,4,36,32,48,48,58,54,30,100,
42,26,14,1,5,47,57,71,0,0,0,0,84,12,31,84,12,31,25,2,
42,22,0,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,5,59,67,8,
1,7,104,14,11,65,29,37,4,9,29,13,39,2,29,23,17,57,59,59,
63,44,1,14,33,1,29,15,17,17,45,29,53,30,17,0,43,33,7,15,
4,16,6,2,28,22,23,3,2,3,4,21,24,1,20,38,12,34,34,20,
19,22,2,11,2,47,41,17,27,7,17,11,16,7,13,0,8,15,17,1,
55,47,17,63,7,23,16,3,19,36,2,3,23,38,19,39,2,59,40,54,
48,44,54,42,16,48,48,11,12,22,8,2,19,8,1,5,4,7,21,2,
7,49,21,19,35,25,51,70,82,66,68,66,54,46,54,38,24,30,12,9,
11,55,30,24,11,24,8,6,3,13,19,25,31,57,19,43,69,51,73,3,
64,46,30,10,10,1,9,17,21,12,92,60,46,34,56,20,8,5,7,13,
72,44,24,12,24,4,7,15,31,27,32,8,2,5,2,17,27,37,0,80,
46,28,14,32,6,1,5,15,124,37,19,1,5,11,2,14,16,3,14,26,
28,27,15,19,2,28,0,3,14,26,36,17,1,24,28,33,25,33,37,27,
7,23,13,17,9,1,19,15,13,3,25,21,35,45,11,69,25,1,13,16,
11,3,32,7,11,5,24,21,19,55,60,68,70,56,36,58,50,40,38,34,
32,24,11,13,27,6,8,7,39,9,11,23,23,23,19,21,49,43,47,66,
64,62,52,32,40,34,12,22,10,8,13,17,25,35,28,32,11,28,30,10,
1,1,5,11,9,19,35,39,47,55,73,27,47,63,51,23,35,3,1,0,
80,20,18,9,38,102,74,114,18,70,58,12,21,37,47,99,99,105,11,84,
56,38,18,24,4,3,9,23,33,19,2,9,16,18,2,6,18,24,26,14,
32,30,2,70,62,42,28,16,4,39,49,57,0,0,0,0,84,12,31,84,
12,31,25,2,42,22,0,9,36,76,62,14,26,0,27,10,5,7,42,37,
25,34,22,67,91,109,11,27,13,27,10,5,37,2,60,2,11,23,27,55,
61,55,85,1,23,37,17,43,41,71,6,15,15,23,52,4,44,0,0,0,
5,59,67,8,1,7,34,15,53,4,6,11,50,46,7,6,13,26,13,5,
8,71,43,47,47,38,9,12,8,11,41,15,17,3,23,17,41,36,19,14,
21,29,5,17,5,8,12,6,22,12,23,1,0,7,4,17,54,7,2,50,
48,64,56,42,53,4,0,9,7,33,9,38,3,3,38,76,112,90,44,55,
59,8,76,80,101,13,14,55,32,7,2,38,66,110,92,56,63,37,7,4,
14,47,34,42,34,30,36,32,18,36,32,5,8,18,6,4,13,10,0,7,
6,0,8,6,3,57,5,5,11,11,27,36,58,32,20,30,32,26,34,24,
35,61,25,25,21,97,13,3,57,26,0,0,5,5,21,9,1,43,59,35,
41,43,39,15,42,36,20,8,8,3,13,17,21,4,64,36,24,10,34,8,
2,13,8,0,60,34,24,12,28,6,5,13,23,15,68,34,18,8,18,5,
19,23,12,72,50,32,16,38,12,2,5,9,124,47,35,21,29,31,23,17,
11,11,7,0,14,23,21,33,37,54,37,47,25,13,11,19,15,15,15,9,
19,41,9,9,30,11,27,7,9,9,7,9,9,31,15,11,19,17,20,55,
19,30,21,3,11,9,0,0,5,3,2,19,19,47,92,86,90,72,52,58,
56,46,50,40,40,42,16,10,11,16,16,2,31,4,4,3,2,15,15,21,
27,35,31,28,20,26,8,25,7,9,39,17,35,41,73,59,63,73,0,6,
51,5,1,19,43,33,35,51,31,43,39,61,55,63,85,15,41,55,17,8,
16,20,42,28,40,6,38,34,50,50,60,56,30,98,38,22,10,5,9,53,
61,73,18,78,68,68,52,52,30,26,12,6,17,8,16,20,42,28,40,6,
38,34,50,50,60,56,30,98,38,22,10,5,9,53,61,73,0,0,0,0,
82,12,31,82,12,31,21,6,44,22,1,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,5,59,67,10,3,7,104,14,11,63,27,37,6,7,25,9,
37,4,25,21,13,55,57,57,61,46,1,16,31,1,29,15,13,17,43,27,
51,30,17,2,39,31,5,15,4,16,6,4,30,24,25,3,2,3,4,21,
24,3,20,38,10,34,34,20,23,22,0,15,0,49,39,15,25,5,15,11,
18,7,11,2,10,15,17,1,57,47,15,63,7,23,18,3,21,38,2,3,
25,40,19,41,2,61,36,52,46,42,52,40,16,46,46,13,10,22,8,2,
21,6,3,7,2,9,23,0,7,53,23,19,37,27,51,68,78,64,64,62,
50,42,50,32,18,26,6,13,17,59,26,20,13,20,4,0,9,17,25,29,
35,63,21,47,71,53,73,3,66,46,30,10,10,1,9,17,21,12,92,60,
46,34,58,20,8,3,7,11,74,44,26,12,26,4,5,15,29,25,34,10,
4,5,4,15,25,35,0,80,46,28,14,34,6,0,3,13,124,35,17,1,
5,11,2,14,16,3,14,26,28,27,15,19,2,30,1,5,12,24,36,19,
3,24,28,33,27,33,35,25,5,21,13,15,9,0,19,15,13,1,25,21,
35,43,9,69,25,1,13,18,11,3,34,7,11,5,26,23,19,57,58,66,
68,54,34,56,48,38,36,32,30,22,13,15,29,2,6,9,43,13,13,25,
23,25,19,21,49,43,45,62,60,58,48,26,36,30,6,18,6,4,19,21,
29,37,24,30,15,24,26,6,5,5,9,15,13,23,41,43,51,59,75,31,
51,65,49,21,33,1,0,2,82,22,20,9,40,104,78,116,20,66,56,6,
27,43,53,105,103,107,11,84,56,38,18,24,4,3,9,23,31,17,4,7,
18,18,2,8,18,24,26,14,32,30,2,68,58,38,24,12,0,43,53,59,
0,0,0,0,82,12,31,82,12,31,21,6,44,22,1,13,34,74,62,14,
30,1,27,12,5,9,44,39,27,32,18,75,95,111,7,23,13,27,12,5,
35,4,62,2,9,21,25,57,63,55,87,1,23,35,17,45,41,71,6,15,
15,21,54,4,44,0,0,0,5,59,67,10,3,7,32,15,51,8,8,9,
52,48,5,8,9,28,11,3,12,73,43,47,47,40,9,14,12,11,39,13,
13,3,23,17,41,38,19,14,19,29,3,17,5,8,12,8,22,12,23,1,
0,7,4,17,54,7,2,52,48,66,56,44,55,4,2,9,7,33,9,40,
3,3,40,78,114,92,48,55,61,8,76,80,103,13,16,57,32,7,2,40,
66,110,92,58,65,33,9,1,8,43,34,42,32,28,34,30,16,36,30,7,
6,18,6,4,15,8,1,9,4,0,8,4,3,59,5,7,11,13,29,32,
54,28,16,26,28,20,28,22,39,65,29,29,25,101,15,5,61,24,1,1,
7,7,25,13,5,47,59,37,43,45,37,13,46,36,20,8,10,1,11,15,
17,6,66,38,26,10,36,10,6,11,12,0,60,34,24,14,30,6,5,11,
21,15,72,36,18,8,20,5,19,21,14,74,52,34,16,40,12,4,5,9,
124,43,33,19,25,29,19,15,9,9,3,4,18,23,19,33,35,60,37,49,
25,11,9,19,15,15,15,7,19,43,9,9,30,11,27,7,9,9,9,9,
9,33,17,11,19,17,22,57,19,32,23,3,11,9,2,0,7,1,4,19,
19,49,90,84,88,68,48,54,52,40,44,34,34,36,10,4,15,8,8,5,
41,1,0,7,1,21,19,23,29,37,31,24,16,22,4,29,11,13,43,21,
39,45,77,63,67,75,1,4,55,9,5,23,47,37,39,53,33,45,39,59,
57,67,87,17,43,57,17,8,16,20,44,30,42,6,40,36,52,50,62,56,
32,98,34,18,6,9,13,57,65,75,18,80,68,70,52,54,30,26,14,6,
17,8,16,20,44,30,42,6,40,36,52,50,62,56,32,98,34,18,6,9,
13,57,65,75,0,0,0,0,80,12,31,80,12,31,17,8,44,22,1,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,3,59,67,10,5,7,104,14,
11,61,25,37,6,5,21,5,33,6,21,19,9,53,55,55,59,48,1,18,
29,1,27,13,9,17,43,27,49,30,17,2,37,31,3,15,4,16,6,6,
30,24,25,3,2,3,4,21,24,3,18,38,8,34,34,20,27,22,0,19,
1,51,37,13,23,3,13,9,20,5,11,4,12,15,17,1,59,45,13,63,
7,23,20,3,23,40,2,3,27,42,21,43,2,63,34,50,46,40,50,38,
14,44,46,15,8,22,8,2,21,4,5,9,0,11,25,1,9,57,25,21,
39,29,51,64,76,60,60,58,46,38,46,28,14,22,2,19,21,65,22,16,
17,16,0,3,13,21,29,35,39,67,23,51,73,55,73,3,66,46,30,10,
10,1,9,17,19,12,92,60,46,34,60,22,10,3,5,9,76,46,26,12,
28,6,5,13,27,23,36,12,4,5,6,13,23,33,2,80,46,28,14,36,
8,2,1,11,124,35,17,0,5,11,2,14,16,3,14,26,30,27,15,19,
0,30,3,7,10,22,36,21,5,24,28,35,29,35,33,23,3,21,11,15,
7,2,19,15,13,1,27,21,35,43,7,69,25,1,13,20,11,3,36,7,
11,5,28,25,19,59,56,66,68,52,32,54,46,36,34,30,28,20,15,17,
31,0,4,13,47,15,15,27,25,25,19,21,49,45,43,58,56,54,44,20,
32,26,2,14,2,0,23,25,31,39,20,26,17,20,22,2,9,9,13,19,
17,27,45,47,55,63,77,35,55,69,47,19,31,0,2,4,86,24,22,9,
42,108,80,120,22,64,52,2,33,49,59,111,107,109,11,84,56,38,18,24,
4,3,9,21,29,15,6,5,20,20,4,10,20,26,28,14,34,30,2,66,
56,34,20,8,3,47,57,61,0,0,0,0,80,12,31,80,12,31,17,8,
44,22,1,17,30,72,64,14,34,5,27,16,5,9,46,41,29,30,14,81,
99,113,3,21,13,27,16,5,35,6,62,2,7,19,23,59,65,55,87,1,
23,33,17,45,41,71,6,15,15,19,54,4,44,0,0,0,3,59,67,10,
5,7,32,13,49,12,10,7,56,52,3,10,5,30,9,1,16,75,43,47,
47,40,9,16,16,11,37,11,9,3,23,17,41,38,19,16,17,29,1,17,
5,8,14,10,24,12,23,1,0,7,4,17,54,7,2,52,48,66,56,44,
55,6,4,11,7,33,9,42,3,1,42,80,116,96,52,57,63,10,76,80,
105,13,16,57,34,7,2,42,66,110,92,60,67,31,11,7,2,41,34,42,
32,26,34,30,16,36,30,9,4,18,6,4,15,8,3,11,4,0,8,2,
5,61,7,9,11,15,29,28,50,24,14,22,24,14,24,20,43,69,31,33,
29,103,17,7,65,22,3,3,9,11,29,17,9,49,59,39,45,49,33,9,
48,38,20,8,12,0,9,13,13,8,68,40,28,12,38,12,8,9,16,2,
62,36,26,14,32,8,3,9,19,15,74,38,18,8,22,3,19,19,16,74,
54,34,16,42,14,6,3,7,124,41,29,15,21,27,17,11,5,5,0,8,
22,21,17,31,33,66,37,51,25,9,7,19,15,15,15,7,19,45,9,9,
32,11,27,7,9,9,9,9,9,35,19,11,19,17,24,59,19,34,25,3,
11,9,2,0,7,1,6,19,19,53,88,82,86,64,44,48,46,34,40,28,
28,30,4,1,19,0,2,13,51,7,3,11,5,25,23,25,31,39,31,20,
12,18,0,33,15,15,47,25,43,49,81,67,71,77,3,2,59,11,9,25,
51,39,41,55,35,47,39,57,59,69,91,19,45,59,17,10,18,22,46,32,
44,6,42,38,54,52,64,58,34,96,30,14,2,13,17,61,69,77,20,80,
70,72,54,56,32,28,14,8,17,10,18,22,46,32,44,6,42,38,54,52,
64,58,34,96,30,14,2,13,17,61,69,77,0,0,0,0,76,10,33,76,
10,33,15,10,44,22,3,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
3,61,67,10,7,9,104,12,11,59,25,37,6,3,19,3,31,8,19,17,
7,51,55,53,59,48,1,18,29,1,27,13,7,17,43,27,47,30,17,2,
35,31,3,15,4,16,6,6,30,24,27,5,2,5,4,21,22,5,16,38,
6,32,34,18,31,20,1,23,3,53,37,13,23,3,13,9,22,5,11,4,
14,17,17,1,63,45,13,63,7,25,20,3,25,40,2,3,31,42,23,45,
2,65,30,48,44,38,48,36,12,42,44,19,6,20,6,2,23,2,7,11,
1,13,27,3,11,61,29,23,43,33,51,60,72,56,56,54,40,32,40,22,
8,16,3,25,27,71,18,12,21,10,5,9,19,27,35,41,45,73,25,55,
77,57,75,3,66,46,30,10,10,3,9,17,19,12,92,60,46,34,62,22,
10,3,5,9,76,46,26,12,28,6,5,13,25,23,38,12,4,5,6,13,
23,31,2,80,46,28,14,36,8,2,1,11,124,35,17,0,5,11,2,14,
16,3,14,26,30,27,15,21,1,30,5,9,8,20,34,25,9,22,26,37,
33,37,33,23,1,21,11,15,7,2,21,15,13,1,29,21,35,43,7,71,
25,1,13,20,13,3,36,9,13,5,28,27,21,61,54,64,66,50,28,52,
44,34,32,28,26,18,17,21,35,3,0,17,51,19,19,29,27,27,19,21,
49,47,43,52,50,50,38,14,26,20,3,8,3,5,29,31,35,41,16,22,
21,16,16,3,15,15,19,23,23,33,51,51,61,67,81,39,59,73,45,17,
29,0,2,4,88,24,22,9,42,110,82,122,22,60,48,3,41,55,65,117,
113,113,11,84,54,36,18,24,4,5,9,21,29,15,6,5,22,20,4,10,
20,26,28,14,34,30,0,62,52,30,16,4,7,53,61,63,0,0,0,0,
76,10,33,76,10,33,15,10,44,22,3,21,26,70,64,14,36,9,27,18,
7,11,48,43,33,26,10,89,105,115,0,19,13,27,18,7,35,6,62,0,
7,19,21,63,69,57,89,3,23,33,19,47,41,71,4,15,15,19,54,2,
44,0,0,0,3,61,67,10,7,9,30,13,47,16,12,7,58,54,3,12,
3,30,7,1,20,77,45,49,49,40,11,16,20,11,37,11,7,3,23,17,
41,38,21,16,17,29,1,17,5,8,14,12,24,12,25,3,0,7,2,17,
54,7,2,52,48,66,56,44,57,6,4,13,7,33,11,42,3,1,44,82,
116,98,54,59,67,10,76,80,107,15,16,59,34,9,2,44,66,108,92,62,
69,29,15,13,5,39,32,42,30,24,32,28,14,34,28,11,2,16,4,2,
17,6,5,13,2,1,6,0,7,65,9,11,11,19,31,22,44,20,10,18,
18,6,18,16,47,75,35,39,33,107,21,11,69,18,5,5,13,15,33,21,
13,53,59,41,47,53,31,7,50,38,20,8,12,0,9,13,11,10,68,40,
28,12,40,14,10,9,20,2,62,36,26,14,32,8,3,9,17,15,76,40,
18,6,22,3,19,19,16,74,54,34,16,44,14,6,3,7,124,39,27,13,
19,25,15,9,3,3,2,10,26,21,17,31,33,72,37,55,25,9,7,19,
15,15,17,7,21,47,11,9,32,13,27,9,9,9,11,11,11,37,21,13,
21,17,26,61,21,34,27,5,11,11,2,1,9,1,6,19,19,57,84,80,
82,60,38,42,40,28,34,22,20,24,3,7,23,7,5,21,63,13,9,15,
11,31,27,29,35,41,31,14,6,12,3,39,19,19,53,29,49,53,87,73,
75,81,7,1,65,15,13,29,55,43,45,57,37,49,41,55,63,73,95,23,
49,63,17,10,18,22,48,32,44,6,44,38,56,52,64,58,34,94,26,10,
3,19,21,67,73,81,20,80,70,72,54,56,32,28,14,8,17,10,18,22,
48,32,44,6,44,38,56,52,64,58,34,94,26,10,3,19,21,67,73,81,
0,0,0,0,74,10,33,74,10,33,11,14,46,24,3,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,1,61,67,12,7,9,104,12,11,55,23,37,
8,0,15,0,27,12,15,13,3,47,53,51,57,50,0,20,27,0,25,11,
3,15,41,25,43,32,15,4,31,29,1,13,6,18,8,8,32,26,27,5,
4,5,4,19,22,5,16,38,6,32,34,18,33,20,1,25,5,53,35,11,
21,1,11,7,24,3,9,6,18,17,17,0,65,43,11,63,5,25,22,1,
25,42,2,3,33,44,23,47,2,65,28,48,44,38,48,36,12,42,44,21,
6,20,6,2,23,2,7,11,1,13,29,3,11,63,31,23,45,35,51,58,
70,54,54,52,36,28,36,18,4,12,7,29,31,75,16,10,23,6,9,13,
23,31,39,45,49,77,25,57,79,57,75,1,68,48,32,12,10,3,7,15,
17,14,94,62,48,34,64,24,12,1,3,7,78,48,28,14,30,8,3,11,
21,21,42,14,6,3,8,11,21,27,4,82,48,30,16,38,10,4,0,9,
124,33,15,2,5,9,2,16,18,1,16,28,32,25,15,21,1,32,5,9,
6,20,34,27,11,22,26,37,35,37,31,21,0,19,9,13,5,4,21,13,
11,0,29,19,33,41,5,71,25,0,13,22,13,3,38,9,13,3,30,27,
21,61,54,64,66,50,26,52,44,34,32,28,26,18,17,23,37,5,1,19,
53,21,21,29,27,27,17,19,47,47,41,48,46,46,34,10,22,16,7,4,
7,9,33,35,37,41,14,20,23,14,12,7,19,19,23,27,27,37,55,53,
65,69,83,41,61,75,41,13,25,2,4,6,92,26,24,9,44,114,86,124,
24,58,46,7,47,59,69,121,117,115,9,86,54,36,18,26,4,5,9,19,
27,13,8,3,26,22,6,12,22,28,30,16,36,32,0,60,50,28,14,2,
9,57,63,63,0,0,0,0,74,10,33,74,10,33,11,14,46,24,3,23,
24,70,66,16,40,11,25,22,7,11,52,43,35,24,8,95,109,115,4,15,
11,25,22,7,33,8,64,0,5,17,17,65,71,57,89,3,21,31,19,47,
39,69,4,13,13,17,56,2,44,0,0,0,1,61,67,12,7,9,30,11,
43,22,16,5,62,58,1,16,0,32,3,0,26,77,45,49,49,42,11,18,
26,9,35,9,3,3,21,17,39,40,21,18,15,27,0,15,3,10,16,14,
26,14,25,3,2,5,2,15,56,5,2,54,50,68,58,46,57,8,6,13,
7,31,11,44,1,0,48,86,118,102,58,59,69,12,78,82,107,15,18,59,
36,9,4,48,66,108,94,66,71,25,17,17,11,35,32,42,30,24,32,28,
14,34,28,11,2,16,4,2,17,6,5,13,2,1,6,0,7,67,9,11,
11,21,31,18,40,18,8,16,14,0,14,14,49,79,37,43,35,109,23,13,
71,16,5,5,15,17,35,23,15,55,59,41,47,55,27,3,54,40,20,8,
14,2,7,11,7,14,70,42,30,14,44,16,14,7,26,4,64,38,28,16,
34,10,1,7,13,13,80,42,20,6,24,1,17,17,18,76,56,36,18,46,
16,8,1,5,124,35,23,9,15,21,11,5,0,0,6,14,32,19,15,29,
31,80,35,57,23,7,5,17,15,13,17,5,21,47,11,9,34,13,27,9,
9,7,11,11,11,37,21,13,21,15,30,61,21,36,27,5,11,11,4,1,
9,0,8,17,17,59,82,78,80,58,34,38,36,22,30,18,14,20,9,11,
27,13,11,27,73,17,13,17,15,35,29,31,37,41,31,10,2,8,7,43,
21,21,57,31,53,55,91,77,77,83,9,3,69,17,15,31,57,45,47,59,
37,49,41,53,65,75,97,25,51,65,15,12,20,24,52,34,46,8,48,40,
58,54,66,60,36,94,24,8,7,23,23,71,75,83,22,82,72,74,56,58,
34,30,16,10,15,12,20,24,52,34,46,8,48,40,58,54,66,60,36,94,
24,8,7,23,23,71,75,83,0,0,0,0,72,10,33,72,10,33,7,16,
46,24,3,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,0,61,67,12,
9,9,104,12,11,53,21,37,8,2,11,4,25,14,11,11,0,45,51,49,
55,52,0,22,25,0,25,9,0,15,41,25,41,32,15,4,29,29,0,13,
6,18,8,10,32,26,29,5,4,5,4,19,22,5,14,38,4,32,34,18,
37,20,1,29,7,55,33,9,19,0,9,5,26,1,9,8,20,17,17,0,
67,43,9,63,5,25,24,1,27,44,2,3,35,46,25,49,2,67,24,46,
42,36,46,34,10,40,44,23,4,20,6,2,23,0,9,13,3,15,31,5,
13,67,33,25,47,37,51,54,68,50,50,48,32,24,32,12,0,8,13,35,
35,81,12,6,27,2,13,17,27,35,43,51,53,81,27,61,81,59,75,1,
68,48,32,12,10,3,7,15,15,14,94,62,48,34,66,24,14,1,1,5,
80,50,28,14,32,8,3,9,19,19,44,16,6,3,10,9,19,25,4,82,
48,30,16,40,12,6,2,7,124,33,15,2,5,9,2,16,18,1,16,28,
34,25,15,21,3,32,7,11,4,18,34,29,13,22,26,39,37,39,29,19,
2,19,9,13,3,6,21,13,11,0,31,19,33,41,3,71,25,0,13,24,
13,3,40,9,13,3,32,29,21,63,52,64,66,48,24,50,42,32,30,26,
24,16,19,25,39,9,3,23,57,23,23,31,29,27,17,19,47,49,39,44,
42,42,30,4,18,12,13,0,11,13,37,39,39,43,10,16,25,10,8,11,
23,23,27,31,31,41,59,57,69,73,85,45,65,79,39,11,23,4,6,8,
96,28,26,9,46,116,88,124,26,56,42,13,53,65,75,125,121,117,9,86,
54,36,18,26,4,5,9,17,25,11,10,1,28,24,8,14,24,30,32,16,
38,32,0,58,46,24,10,1,13,61,67,65,0,0,0,0,72,10,33,72,
10,33,7,16,46,24,3,27,20,68,68,16,44,15,25,24,7,11,54,45,
37,22,4,101,113,117,8,13,11,25,24,7,33,10,64,0,3,15,15,67,
73,57,89,3,21,29,19,47,39,69,4,13,13,15,56,2,44,0,0,0,
0,61,67,12,9,9,30,9,41,26,18,3,66,62,0,18,4,34,1,2,
30,79,45,49,49,42,11,20,30,9,33,7,0,3,21,17,39,40,21,18,
13,27,2,15,3,10,16,16,28,14,25,3,2,5,2,15,56,5,2,54,
50,68,58,46,59,10,8,15,7,31,11,46,1,0,50,88,120,106,62,61,
71,12,78,82,109,15,18,61,38,9,4,50,66,108,94,68,73,23,19,23,
17,33,32,42,30,22,30,28,14,34,26,13,0,16,4,2,17,4,7,15,
2,1,6,1,9,69,11,13,11,23,33,14,36,14,4,12,10,5,10,12,
53,83,41,47,39,111,25,15,75,14,7,7,17,21,39,27,19,59,59,43,
49,59,25,1,56,42,20,8,16,4,5,9,3,16,72,44,32,16,46,18,
16,5,30,6,64,38,28,16,36,12,0,5,11,13,82,44,20,6,26,0,
17,15,20,76,58,36,18,48,18,10,0,3,124,33,19,5,11,19,9,1,
4,2,10,18,36,17,13,27,29,86,35,59,23,5,3,17,15,13,17,5,
21,49,11,9,36,13,27,9,9,7,11,11,11,39,23,13,21,15,32,63,
21,38,29,5,11,11,4,1,9,0,10,17,17,63,80,76,78,54,30,32,
30,16,26,12,8,14,15,17,31,21,19,35,83,23,17,21,19,39,33,33,
39,43,31,6,1,4,11,47,25,25,61,35,57,59,95,81,81,85,11,5,
73,21,19,35,61,47,49,61,39,51,41,51,67,77,101,27,53,67,15,12,
22,26,54,36,48,8,50,42,60,54,68,62,38,92,20,4,11,27,27,75,
79,85,24,82,72,76,58,60,34,32,16,12,15,12,22,26,54,36,48,8,
50,42,60,54,68,62,38,92,20,4,11,27,27,75,79,85,0,0,0,0,
70,10,33,70,10,33,3,20,48,24,5,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,0,61,67,14,11,9,104,12,11,51,19,37,10,4,7,8,
21,16,7,9,4,43,49,47,53,54,0,24,23,0,23,9,4,15,39,23,
39,32,15,6,25,27,2,13,6,18,8,12,34,28,29,5,4,5,4,19,
22,7,14,38,2,32,34,18,41,20,3,33,9,57,31,7,17,2,7,5,
28,1,7,10,22,17,17,0,69,41,7,63,5,25,26,1,29,46,2,3,
37,48,25,51,2,69,22,44,42,34,44,32,10,38,42,25,2,20,6,2,
25,1,11,15,5,17,33,7,13,71,35,25,49,39,51,52,64,48,46,44,
28,20,28,8,5,4,17,39,41,85,8,2,29,1,17,23,33,39,49,55,
57,87,29,65,83,61,75,1,70,48,32,12,10,3,7,15,15,14,94,62,
48,34,68,26,14,0,1,3,82,50,30,14,34,10,1,9,17,17,46,18,
8,3,12,7,17,23,6,82,48,30,16,42,12,8,4,5,124,31,13,4,
5,9,2,16,18,1,16,28,34,25,15,21,3,34,9,13,2,16,34,31,
15,22,26,39,39,39,27,17,4,17,7,11,3,8,21,13,11,2,31,19,
33,39,1,71,25,0,13,26,13,3,42,9,13,3,34,31,21,65,50,62,
64,46,22,48,40,30,28,24,22,14,21,27,41,11,5,25,61,27,25,33,
29,29,17,19,47,49,37,40,38,38,26,1,14,8,17,3,15,17,43,43,
43,45,6,14,29,6,4,15,27,27,31,35,35,45,65,61,73,77,87,49,
69,81,37,9,21,6,8,10,98,30,28,9,48,120,92,124,28,52,40,17,
59,71,81,125,125,119,9,86,54,36,18,26,4,5,9,17,23,9,12,0,
30,24,8,16,24,30,32,16,38,32,0,56,44,20,6,5,17,65,71,67,
0,0,0,0,70,10,33,70,10,33,3,20,48,24,5,31,18,66,68,16,
48,17,25,28,7,13,56,47,39,20,0,109,117,119,12,9,11,25,28,7,
31,12,66,0,1,13,13,69,75,57,91,3,21,27,19,49,39,69,4,13,
13,13,58,2,44,0,0,0,0,61,67,14,11,9,28,9,39,30,20,1,
68,64,2,20,8,36,0,4,34,81,45,49,49,44,11,22,34,9,31,5,
4,3,21,17,39,42,21,20,11,27,4,15,3,10,18,18,28,14,25,3,
2,5,2,15,56,5,2,56,50,70,58,48,59,10,10,15,7,31,11,48,
1,2,52,90,122,108,66,61,73,14,78,82,111,15,20,61,38,9,4,52,
66,108,94,70,75,19,21,29,23,29,32,42,28,20,30,26,12,34,26,15,
1,16,4,2,19,4,9,17,0,1,6,3,9,71,11,15,11,25,33,10,
32,10,2,8,6,11,4,10,57,87,43,51,43,115,27,17,79,12,9,9,
19,23,43,31,23,61,59,45,51,61,21,2,60,42,20,8,18,6,3,7,
0,18,74,46,34,16,48,20,20,3,34,6,66,40,30,18,38,12,0,3,
9,13,86,46,20,6,28,0,17,13,22,78,60,38,18,50,18,12,0,3,
124,29,17,3,7,17,5,0,6,6,14,22,40,17,11,27,27,92,35,61,
23,3,1,17,15,13,17,3,21,51,11,9,36,13,27,9,9,7,13,11,
11,41,25,13,21,15,34,65,21,40,31,5,11,11,6,1,11,2,12,17,
17,65,78,74,76,50,26,28,26,10,20,6,2,8,21,23,35,29,25,43,
93,29,21,25,23,45,37,35,41,45,31,2,5,0,15,51,29,27,65,39,
61,63,99,85,85,87,13,7,77,23,23,37,65,51,53,63,41,53,41,49,
69,81,103,29,55,69,15,14,22,26,56,38,50,8,52,44,62,56,70,62,
40,92,16,0,15,31,31,79,83,87,24,84,74,78,58,62,36,32,18,12,
15,14,22,26,56,38,50,8,52,44,62,56,70,62,40,92,16,0,15,31,
31,79,83,87,0,0,0,0,66,10,33,66,10,33,1,22,48,24,5,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,2,63,67,14,13,9,104,12,
11,49,17,37,10,8,5,12,19,18,5,5,8,41,49,45,53,54,0,26,
21,0,23,7,8,15,39,23,37,32,13,6,23,27,2,13,8,18,8,12,
34,28,31,7,4,5,4,19,22,7,12,38,2,32,34,16,45,20,3,37,
11,59,29,5,15,4,7,3,30,0,7,12,24,17,17,2,71,41,5,63,
5,25,26,1,31,48,2,3,41,50,27,53,2,71,18,42,40,32,42,30,
8,36,42,29,0,18,6,2,25,3,11,17,5,19,35,9,15,75,37,27,
51,41,51,48,62,44,42,40,24,14,24,2,9,0,23,45,45,91,4,0,
33,7,21,27,37,45,53,61,61,91,31,67,87,63,75,1,70,50,32,12,
10,3,7,15,13,16,96,62,48,34,70,26,16,0,0,3,84,52,30,14,
34,10,1,7,15,17,48,18,8,3,14,5,17,21,6,84,48,30,16,44,
14,8,6,3,124,31,13,4,5,9,2,16,18,0,16,28,36,25,15,21,
5,34,11,15,0,14,34,35,17,20,26,41,41,41,27,17,6,17,7,11,
1,10,23,13,11,2,33,19,33,39,0,71,25,2,13,26,13,3,44,9,
15,3,36,31,23,67,48,62,64,44,20,46,38,28,26,22,20,12,23,29,
43,15,9,29,65,29,27,35,31,29,17,19,47,51,37,34,32,34,20,7,
10,4,23,7,19,21,47,47,45,47,2,10,31,2,0,19,31,33,35,39,
39,49,69,65,77,81,89,53,73,85,35,7,19,6,10,12,102,32,30,9,
50,122,94,124,28,50,36,23,65,77,87,125,125,121,9,86,54,36,18,26,
4,5,9,15,21,7,14,0,32,26,10,18,26,32,34,18,40,34,0,52,
40,16,2,9,21,69,75,69,0,0,0,0,66,10,33,66,10,33,1,22,
48,24,5,35,14,64,70,16,50,21,25,30,9,13,58,49,43,16,3,115,
123,121,16,7,11,25,30,9,31,14,66,1,1,11,9,71,79,59,91,3,
19,25,21,49,39,69,4,13,13,13,58,2,44,0,0,0,2,63,67,14,
13,9,28,7,37,34,22,0,72,68,2,22,12,38,2,6,40,81,47,49,
51,44,13,24,40,7,31,5,8,3,21,17,39,42,21,20,9,27,4,13,
3,10,18,20,30,14,27,5,2,5,2,15,56,5,2,56,50,70,58,48,
61,12,10,17,7,29,11,50,0,2,56,94,124,112,70,63,75,14,80,82,
113,15,20,63,40,9,4,54,66,108,94,74,77,17,23,35,29,27,30,42,
28,20,28,26,12,34,24,17,3,14,4,2,19,2,9,19,0,3,4,5,
11,73,13,17,11,29,35,6,28,6,1,6,2,19,0,8,61,93,47,55,
47,117,31,19,81,10,11,11,23,27,47,35,25,65,59,47,53,65,19,4,
62,44,20,8,20,8,1,7,4,22,76,46,34,18,52,22,22,1,40,8,
66,40,30,18,40,14,2,3,7,13,88,48,20,6,30,2,17,11,24,78,
62,38,18,52,20,14,2,1,124,27,13,0,5,15,3,4,10,8,16,26,
46,15,9,25,25,98,33,63,21,1,1,17,15,13,19,3,23,53,11,9,
38,13,27,9,9,5,13,13,11,43,27,15,21,15,36,67,23,40,31,7,
11,11,6,3,11,2,12,17,17,69,76,72,74,48,20,22,20,4,16,0,
5,2,29,27,39,37,33,51,103,35,25,29,27,49,41,39,43,47,31,3,
11,5,19,55,33,31,69,43,65,67,103,91,87,91,15,9,83,27,25,41,
69,53,55,65,43,55,41,47,73,83,107,33,57,71,15,14,24,28,58,38,
50,10,54,46,64,56,72,64,40,90,12,3,19,35,35,85,87,91,26,84,
74,78,60,62,36,34,18,14,15,14,24,28,58,38,50,10,54,46,64,56,
72,64,40,90,12,3,19,35,35,85,87,91,0,0,0,0,64,10,33,64,
10,33,2,26,48,24,7,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
2,63,67,16,15,9,104,12,11,47,15,37,12,10,1,16,15,20,1,3,
12,39,47,43,51,56,0,28,19,0,21,5,12,15,39,21,33,34,13,8,
21,25,4,13,8,20,10,14,36,30,31,7,4,5,4,19,22,9,10,38,
0,32,34,16,49,20,5,39,13,61,27,3,13,6,5,1,32,2,5,14,
26,17,17,2,73,39,3,63,3,25,28,1,33,50,2,3,43,52,27,55,
2,71,16,40,40,30,40,28,6,36,42,31,1,18,6,2,27,3,13,19,
7,21,37,9,17,79,39,29,53,43,51,44,60,40,38,38,20,10,20,1,
13,3,27,49,49,95,0,3,37,11,25,31,41,49,57,67,65,97,33,71,
89,63,75,1,70,50,32,12,10,3,7,15,13,16,96,62,48,34,72,28,
18,0,2,1,86,54,30,16,36,12,0,7,13,15,52,20,8,1,16,3,
15,19,8,84,50,30,16,46,16,10,8,1,124,31,13,6,5,9,2,16,
18,0,16,30,36,25,15,21,7,36,13,17,1,14,34,37,19,20,26,43,
43,41,25,15,8,15,5,9,1,12,23,13,11,2,35,19,33,37,2,71,
25,2,13,28,13,3,46,9,15,3,38,33,23,67,46,62,62,44,18,44,
36,26,26,20,18,10,25,31,45,17,11,31,69,31,29,37,33,31,17,17,
47,51,35,30,28,30,16,11,6,0,27,11,23,25,51,51,49,49,1,6,
33,1,3,23,35,37,39,43,43,53,75,69,81,85,91,57,77,87,33,3,
17,8,12,14,106,34,32,9,52,124,98,124,30,46,32,27,71,81,93,125,
125,123,9,86,54,36,18,26,4,5,9,15,19,5,16,2,34,28,10,20,
28,34,36,18,40,34,0,50,38,14,0,13,25,73,79,71,0,0,0,0,
64,10,33,64,10,33,2,26,48,24,7,39,12,62,72,16,54,25,23,34,
9,13,60,51,45,14,7,121,125,121,20,5,11,23,34,9,31,16,66,1,
0,9,7,73,81,59,91,3,19,23,21,49,39,69,4,11,13,11,60,2,
44,0,0,0,2,63,67,16,15,9,26,7,33,40,24,2,74,70,4,24,
16,40,4,8,44,83,47,49,51,44,13,26,44,7,29,3,12,3,21,17,
37,42,21,22,7,25,6,13,3,12,20,22,30,14,27,5,4,5,2,15,
58,5,2,58,52,70,58,48,61,12,12,17,7,29,11,52,0,4,58,96,
124,114,74,63,77,16,80,82,115,15,22,63,42,9,4,58,66,108,94,76,
79,13,25,39,35,25,30,42,26,18,28,26,10,34,24,19,5,14,4,2,
19,2,11,21,1,3,4,7,11,75,15,17,11,31,35,2,24,4,3,2,
1,25,5,6,65,97,49,59,51,119,33,21,85,8,13,13,25,29,51,39,
29,67,59,49,55,69,15,8,64,44,20,8,22,10,0,5,8,24,78,48,
36,20,54,24,26,0,44,10,68,42,32,20,42,16,2,1,5,11,90,50,
20,6,32,2,15,9,26,78,64,38,18,54,22,16,2,0,124,25,11,2,
1,13,0,6,14,12,20,30,50,13,7,23,23,104,33,65,21,0,0,17,
15,13,19,1,23,55,11,9,40,13,27,9,9,5,15,13,11,45,29,15,
21,15,38,67,23,42,33,7,11,11,6,3,13,2,14,17,17,71,74,70,
72,44,16,18,14,1,10,5,11,3,35,33,43,45,39,59,113,41,29,31,
31,55,45,41,45,49,31,7,15,9,23,59,37,33,73,47,69,71,107,95,
91,93,17,11,87,29,29,43,73,55,57,67,45,57,41,45,75,85,109,35,
59,73,15,16,24,30,60,40,52,10,56,48,66,58,74,64,42,90,8,7,
23,39,39,89,91,93,26,86,76,80,62,64,38,34,18,16,15,16,24,30,
60,40,52,10,56,48,66,58,74,64,42,90,8,7,23,39,39,89,91,93,
0,0,0,0,62,10,35,62,10,35,6,28,50,24,7,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,4,63,67,16,15,11,104,12,11,45,15,37,
12,12,2,20,13,22,2,1,16,37,45,41,49,58,0,30,19,2,21,5,
16,15,37,21,31,34,13,8,17,25,6,11,8,20,10,16,36,30,33,7,
4,5,4,19,22,9,10,38,1,32,34,16,53,20,5,43,15,63,27,1,
13,6,3,1,34,2,5,14,30,17,17,2,75,39,1,63,3,25,30,0,
35,50,2,3,45,54,29,57,2,73,12,38,38,30,38,28,6,34,40,33,
3,18,6,2,27,5,15,21,9,21,39,11,17,83,41,29,55,45,51,42,
56,38,34,34,16,6,16,7,19,7,33,55,55,101,3,7,39,15,31,37,
47,53,63,71,71,101,35,75,91,65,75,0,72,50,34,12,10,3,7,15,
11,16,96,64,48,34,74,28,18,2,2,0,88,54,32,16,38,12,0,5,
11,13,54,22,10,1,16,3,13,15,8,84,50,30,18,46,16,12,8,0,
124,29,11,6,5,9,2,16,18,0,18,30,38,25,15,23,7,36,15,19,
3,12,34,39,21,20,26,43,45,43,23,13,10,15,5,9,0,12,23,11,
9,4,35,19,33,37,4,71,25,2,13,30,13,3,48,11,15,3,38,35,
23,69,44,60,62,42,16,44,36,24,24,20,16,8,27,33,47,21,13,35,
73,35,33,39,33,31,17,17,45,53,33,26,24,26,12,17,2,3,33,15,
29,29,57,55,51,49,3,4,37,5,9,27,39,41,43,47,49,57,79,73,
85,87,95,61,81,91,31,1,15,10,14,16,108,36,34,9,54,124,100,124,
32,44,30,33,77,87,97,125,125,125,7,86,54,36,18,26,4,5,9,13,
17,5,18,4,36,28,12,22,28,34,36,18,42,34,0,48,34,10,3,15,
27,79,81,73,0,0,0,0,62,10,35,62,10,35,6,28,50,24,7,41,
8,60,72,18,58,27,23,36,9,15,62,53,47,12,9,125,125,123,24,1,
11,23,36,9,29,18,68,1,2,7,5,77,83,59,93,3,19,23,21,51,
37,69,2,11,13,9,60,2,44,0,0,0,4,63,67,16,15,11,26,5,
31,44,26,4,78,74,6,26,20,42,6,8,48,85,47,49,51,46,13,28,
48,7,27,1,16,3,21,17,37,44,23,22,7,25,8,13,1,12,20,24,
32,14,27,5,4,5,2,15,58,5,2,58,52,72,60,50,63,14,14,19,
7,29,11,54,0,4,60,98,124,118,76,65,79,16,80,82,115,17,22,65,
42,11,6,60,66,108,96,78,81,11,27,45,41,21,30,42,26,16,26,24,
10,32,22,19,5,14,2,2,21,0,13,23,1,3,4,7,13,79,15,19,
11,33,37,3,20,0,7,1,5,31,9,2,69,101,53,63,55,123,35,25,
89,4,15,15,27,33,55,43,33,71,59,51,57,71,13,10,68,46,20,8,
24,10,0,3,10,26,80,50,38,20,56,26,28,2,48,10,68,42,32,20,
44,16,4,0,3,11,94,52,20,6,32,4,15,9,26,80,64,40,18,56,
22,16,4,0,124,21,7,6,2,9,2,10,16,14,24,34,54,13,5,23,
23,110,33,67,21,0,2,17,15,13,19,1,23,57,11,9,40,13,27,9,
9,5,15,13,11,47,31,15,21,15,40,69,23,44,35,7,11,11,8,3,
13,4,16,17,17,75,72,68,70,40,12,12,10,7,6,11,17,9,41,39,
47,51,47,67,123,45,35,35,35,59,49,43,47,51,31,11,19,13,27,63,
39,37,77,51,75,75,111,99,95,95,19,15,91,33,33,47,77,59,61,69,
47,59,43,43,77,89,113,37,63,75,13,16,26,30,62,42,54,10,58,50,
68,58,76,66,44,88,4,11,27,43,43,93,95,95,28,86,76,82,62,66,
38,36,20,16,13,16,26,30,62,42,54,10,58,50,68,58,76,66,44,88,
4,11,27,43,43,93,95,95,0,0,0,0,60,10,35,60,10,35,10,32,
50,24,9,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,4,63,67,18,
17,11,104,12,11,43,13,37,14,16,4,24,9,24,4,2,20,35,43,39,
49,60,0,32,17,2,19,3,20,15,37,19,29,34,11,10,15,23,6,11,
10,20,10,18,38,32,33,9,4,5,4,19,22,11,8,38,1,32,34,14,
57,20,7,47,17,65,25,0,11,8,1,0,36,4,3,16,32,17,17,4,
77,37,0,63,3,25,30,0,37,52,2,3,49,56,29,59,2,75,10,36,
38,28,36,26,4,32,40,35,5,18,6,2,29,7,15,23,9,23,41,13,
19,87,43,31,57,47,51,38,54,34,30,30,12,0,12,11,23,11,37,59,
59,105,7,9,43,21,35,41,51,59,67,77,75,107,37,77,95,67,75,0,
72,52,34,12,10,3,7,15,11,18,98,64,48,34,76,30,20,2,4,2,
90,56,32,16,40,14,2,5,9,13,56,22,10,1,18,1,13,13,10,86,
50,30,18,48,18,14,10,2,124,29,11,8,5,9,2,16,18,2,18,30,
38,25,15,23,9,38,17,21,5,10,34,41,23,18,26,45,47,43,21,13,
12,13,3,7,0,14,23,11,9,4,37,19,33,35,6,71,25,4,13,30,
13,3,50,11,15,3,40,35,25,71,42,60,60,40,14,42,34,22,22,18,
14,6,29,35,49,23,17,37,77,37,35,41,35,33,17,17,45,53,31,22,
20,22,6,23,1,7,37,19,33,33,61,59,55,51,7,0,39,9,13,31,
43,45,47,51,53,61,85,77,89,91,97,65,85,93,29,0,13,10,16,18,
112,38,36,9,56,124,104,124,32,40,26,37,83,93,103,125,125,125,7,86,
54,36,18,26,4,5,9,13,15,3,20,6,38,30,12,24,30,36,38,20,
42,36,0,44,32,6,7,19,31,83,85,75,0,0,0,0,60,10,35,60,
10,35,10,32,50,24,9,45,6,58,74,18,60,31,23,40,11,15,64,55,
49,10,13,125,125,125,28,0,11,23,40,11,29,20,68,1,2,5,1,79,
85,59,93,3,17,21,23,51,37,69,2,11,13,7,62,2,44,0,0,0,
4,63,67,18,17,11,24,5,29,48,28,6,80,76,8,28,24,44,8,10,
54,85,49,49,53,46,13,30,54,5,27,1,20,3,21,17,37,44,23,24,
5,25,10,11,1,12,22,26,32,14,29,5,4,5,2,15,58,5,2,60,
52,72,60,50,63,14,14,19,7,27,11,56,2,6,64,102,124,120,80,65,
81,18,82,82,117,17,24,65,44,11,6,62,66,108,96,82,83,7,29,51,
47,19,30,42,24,16,26,24,8,32,22,21,7,14,2,2,21,0,13,25,
3,3,4,9,13,81,17,21,11,35,37,7,16,3,9,3,9,37,15,0,
73,105,55,67,59,125,37,27,91,2,17,17,31,35,59,47,35,73,59,53,
59,75,9,14,70,46,20,8,26,12,2,3,14,30,82,52,38,22,60,28,
32,4,54,12,70,44,34,22,46,18,4,2,1,11,96,54,20,6,34,4,
15,7,28,80,66,40,18,58,24,18,4,2,124,19,5,8,4,7,6,12,
20,18,28,38,60,11,3,21,21,116,31,69,19,2,4,17,15,13,19,0,
25,59,11,9,42,13,27,9,9,3,17,15,11,49,33,17,21,15,42,71,
25,46,35,9,11,11,8,5,15,4,16,17,17,77,70,66,68,38,6,8,
4,13,0,17,23,15,47,43,51,59,53,75,125,51,39,39,39,65,53,45,
49,53,31,15,25,19,31,67,43,39,81,55,79,79,115,103,97,99,21,17,
95,35,35,49,81,61,63,71,49,61,43,41,81,91,115,41,65,77,13,18,
26,32,64,44,54,12,60,52,70,60,78,66,44,88,0,15,31,47,47,99,
99,97,28,88,78,82,64,68,40,36,20,18,13,18,26,32,64,44,54,12,
60,52,70,60,78,66,44,88,0,15,31,47,47,99,99,97,0,0,0,0,
56,8,35,56,8,35,12,34,50,24,9,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,6,65,67,18,19,11,104,12,11,41,11,37,14,18,8,28,
7,26,8,4,22,33,43,37,47,60,0,34,15,2,19,3,22,15,37,19,
27,34,11,10,13,23,8,11,10,20,10,18,38,32,35,9,4,5,4,19,
22,11,6,38,3,32,34,14,61,20,7,51,19,67,23,2,9,10,1,0,
38,4,3,18,34,17,17,4,81,37,2,63,3,27,32,0,39,54,2,3,
51,58,31,61,2,77,6,34,36,26,34,24,2,30,38,39,7,16,6,2,
29,9,17,25,11,25,43,15,21,91,47,33,59,49,51,34,50,30,26,26,
8,3,8,17,29,15,43,65,65,111,11,13,47,25,39,47,57,63,73,83,
79,111,39,81,97,69,77,0,72,52,34,12,10,3,7,15,9,18,98,64,
48,34,78,30,20,2,4,2,92,56,32,16,40,14,2,3,7,11,58,24,
10,1,20,0,11,11,10,86,50,30,18,50,18,14,12,2,124,29,11,8,
5,9,2,16,18,2,18,30,40,25,15,23,11,38,19,23,7,8,34,45,
27,18,26,47,49,45,21,11,14,13,3,7,2,16,25,11,9,4,39,19,
33,35,6,73,25,4,13,32,13,3,50,11,17,3,42,37,25,73,40,58,
60,38,10,40,32,20,20,16,12,4,31,37,51,27,19,41,81,41,37,43,
37,33,17,17,45,55,31,16,14,18,2,29,7,13,43,23,37,37,67,63,
57,53,11,3,43,13,17,37,49,51,53,55,57,67,89,81,95,95,99,69,
89,97,27,2,11,12,18,18,114,40,36,9,56,124,106,124,34,38,22,43,
89,99,109,125,125,125,7,86,54,36,18,26,4,5,9,11,15,1,22,6,
40,30,14,24,30,36,38,20,44,36,1,42,28,2,11,23,35,87,89,77,
0,0,0,0,56,8,35,56,8,35,12,34,50,24,9,49,2,56,74,18,
64,35,23,42,11,17,66,57,53,6,17,125,125,125,32,2,11,23,42,11,
29,20,68,3,4,3,0,81,89,61,95,3,17,19,23,53,37,69,2,11,
13,7,62,2,44,0,0,0,6,65,67,18,19,11,24,3,27,52,30,6,
84,80,8,30,28,44,10,12,58,87,49,51,53,46,15,30,58,5,25,0,
22,3,21,17,37,44,23,24,3,25,10,11,1,12,22,28,34,14,29,7,
4,5,0,15,58,5,2,60,52,72,60,50,65,16,16,21,7,27,11,58,
2,6,66,104,124,124,84,67,83,18,82,82,119,17,24,67,44,11,6,64,
66,108,96,84,85,5,31,57,55,17,28,42,24,14,24,22,8,32,20,23,
9,12,2,0,23,1,15,27,3,5,2,11,15,83,19,23,11,39,39,11,
12,7,13,7,15,45,19,1,77,111,59,73,63,125,41,29,95,0,19,19,
33,39,63,51,39,77,59,55,61,79,7,16,72,48,20,8,26,14,4,1,
18,32,82,52,40,22,62,30,34,6,58,12,70,44,34,22,46,18,6,2,
0,11,98,56,20,6,36,6,15,5,30,80,68,40,18,60,24,20,6,2,
124,17,1,12,8,5,8,16,22,20,30,42,64,11,1,21,19,122,31,71,
19,4,4,17,15,13,21,0,25,61,11,9,42,13,27,11,9,3,17,15,
13,51,35,17,23,15,44,73,25,46,37,9,11,13,8,5,15,4,18,17,
17,81,68,64,66,34,2,2,1,19,3,23,31,21,55,49,55,67,61,83,
125,57,43,43,45,69,57,49,53,55,31,21,29,23,35,73,47,43,87,59,
83,83,119,109,101,101,25,19,101,39,39,53,85,65,67,73,51,63,43,39,
83,95,119,43,67,79,13,18,28,32,66,44,56,12,62,52,72,60,78,68,
46,86,3,19,35,51,51,103,103,101,30,88,78,84,64,68,40,38,20,18,
13,18,28,32,66,44,56,12,62,52,72,60,78,68,46,86,3,19,35,51,
51,103,103,101,0,0,0,0,54,8,35,54,8,35,16,36,52,24,9,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,8,65,67,18,21,11,104,12,
11,39,9,37,14,20,12,32,3,30,12,6,26,31,41,35,45,62,2,36,
13,2,17,1,26,15,35,19,23,36,11,10,9,23,10,11,10,22,12,20,
38,32,35,9,6,5,4,17,22,11,6,38,5,32,34,14,65,20,7,53,
21,67,21,4,7,12,0,2,40,6,3,20,36,17,17,4,83,35,4,63,
1,27,34,0,41,56,2,3,53,60,33,63,2,77,4,32,36,24,32,22,
2,30,38,41,9,16,6,2,29,9,19,27,13,27,45,15,21,93,49,33,
61,51,51,32,48,28,24,24,4,7,4,21,33,19,47,71,69,117,13,17,
49,29,43,51,61,67,77,87,83,115,39,85,99,69,77,0,74,52,34,14,
10,3,5,15,7,18,98,64,50,34,80,32,22,4,6,4,94,58,34,18,
42,16,2,1,5,9,62,26,12,0,22,2,9,9,12,86,52,32,18,52,
20,16,14,4,124,27,9,10,5,9,2,18,20,2,18,32,42,25,15,23,
11,38,21,23,9,8,34,47,29,18,26,47,51,47,19,9,16,13,1,7,
4,18,25,11,9,6,39,19,33,35,8,73,25,4,13,34,13,3,52,11,
17,3,44,39,25,73,38,58,60,38,8,38,30,18,20,14,10,4,31,39,
53,29,21,45,85,43,39,43,37,33,15,15,45,57,29,12,10,14,1,33,
11,17,47,27,41,41,71,67,59,55,15,5,45,17,21,41,53,55,57,59,
61,71,93,83,99,99,101,73,93,101,25,6,7,14,20,20,118,42,38,9,
58,124,108,124,36,36,20,47,95,103,115,125,125,125,7,86,54,36,18,28,
4,5,9,9,13,0,24,8,44,32,16,26,32,38,40,20,46,36,1,40,
26,0,13,27,39,91,93,77,0,0,0,0,54,8,35,54,8,35,16,36,
52,24,9,53,1,56,76,18,68,37,21,46,11,17,68,57,55,4,21,125,
125,125,36,6,9,21,46,11,27,22,70,3,6,1,2,83,91,61,95,3,
17,17,23,53,37,69,2,9,11,5,62,2,44,0,0,0,8,65,67,18,
21,11,24,1,23,58,32,8,88,84,10,32,32,46,14,14,62,89,49,51,
53,48,15,32,62,5,23,2,26,3,19,17,35,46,23,26,1,23,12,11,
1,14,24,30,36,14,29,7,6,3,0,15,60,5,2,60,54,74,60,52,
65,18,18,23,7,27,11,60,2,8,68,106,124,124,88,69,85,20,82,84,
121,17,24,67,46,11,6,68,66,108,96,86,87,3,33,61,61,13,28,42,
24,12,24,22,8,32,20,25,11,12,2,0,23,1,17,27,3,5,2,13,
17,85,19,23,11,41,39,15,8,9,15,11,19,51,23,3,81,115,61,77,
65,125,43,31,99,1,21,21,35,43,65,55,43,79,59,55,63,81,3,20,
76,50,20,8,28,16,6,0,22,34,84,54,42,24,64,32,36,8,62,14,
72,46,36,22,48,20,8,4,4,9,102,58,22,6,38,8,13,3,32,82,
70,42,20,62,26,22,8,4,124,13,2,16,12,3,10,20,26,24,34,46,
68,9,0,19,17,124,31,73,19,6,6,15,15,13,21,0,25,63,11,9,
44,13,27,11,9,3,17,15,13,51,37,17,23,13,48,73,25,48,39,9,
11,13,10,5,15,6,20,15,15,85,66,62,64,30,1,3,5,25,7,27,
37,25,61,55,59,75,67,89,125,63,47,45,49,73,59,51,55,57,31,25,
33,27,39,77,51,45,91,63,87,87,123,113,105,103,27,21,105,41,43,55,
89,67,69,75,53,63,43,37,85,97,123,45,69,81,13,20,30,34,70,46,
58,12,64,54,74,62,80,70,48,84,5,23,39,55,55,107,107,103,32,88,
80,86,66,70,42,40,22,20,13,20,30,34,70,46,58,12,64,54,74,62,
80,70,48,84,5,23,39,55,55,107,107,103,0,0,0,0,52,8,35,52,
8,35,20,40,52,24,11,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
8,65,67,20,23,11,104,12,11,37,7,37,16,24,14,36,1,32,14,10,
30,29,39,33,45,64,2,38,11,2,17,0,30,15,35,17,21,36,9,12,
7,21,10,11,12,22,12,22,40,34,37,11,6,5,4,17,22,13,4,38,
5,32,34,12,69,20,9,57,23,69,19,6,5,14,2,4,42,8,1,22,
38,17,17,6,85,35,6,63,1,27,34,0,43,58,2,3,57,62,33,65,
2,79,0,30,34,22,30,20,0,28,38,43,11,16,6,2,31,11,19,29,
13,29,47,17,23,97,51,35,63,53,51,28,46,24,20,20,0,13,0,27,
37,23,53,75,73,121,17,19,53,35,47,55,65,73,81,93,87,121,41,87,
103,71,77,0,74,54,34,14,10,3,5,15,7,20,100,64,50,34,82,32,
24,4,8,6,96,60,34,18,44,16,4,1,3,9,64,26,12,0,24,4,
9,7,12,88,52,32,18,54,22,18,16,6,124,27,9,10,5,9,2,18,
20,4,18,32,42,25,15,23,13,40,23,25,11,6,34,49,31,16,26,49,
53,47,17,9,18,11,1,5,4,20,25,11,9,6,41,19,33,33,10,73,
25,6,13,34,13,3,54,11,17,3,46,39,27,75,36,58,58,36,6,36,
28,16,18,12,8,2,33,41,55,33,25,47,89,45,41,45,39,35,15,15,
45,57,27,8,6,10,7,39,15,21,53,31,45,45,75,71,63,57,19,9,
47,21,25,45,57,59,61,63,65,75,99,87,103,103,103,77,97,103,23,8,
5,14,22,22,122,44,40,9,60,124,112,124,36,32,16,53,101,109,121,125,
125,125,7,86,54,36,18,28,4,5,9,9,11,2,26,10,46,34,16,28,
34,40,42,22,46,38,1,36,22,3,17,31,43,95,97,79,0,0,0,0,
52,8,35,52,8,35,20,40,52,24,11,57,3,54,78,18,70,41,21,48,
13,17,70,59,57,2,25,125,125,125,40,8,9,21,48,13,27,24,70,3,
6,0,6,85,93,61,95,3,15,15,25,53,37,69,2,9,11,3,64,2,
44,0,0,0,8,65,67,20,23,11,22,1,21,62,34,10,90,86,12,34,
36,48,16,16,68,89,51,51,55,48,15,34,68,3,23,2,30,3,19,17,
35,46,23,26,0,23,14,9,1,14,24,32,36,14,31,7,6,3,0,15,
60,5,2,62,54,74,60,52,67,18,18,23,7,25,11,62,4,8,72,110,
124,124,92,69,87,20,84,84,123,17,26,69,48,11,6,70,66,108,96,90,
89,0,35,67,67,11,28,42,22,12,22,22,6,32,18,27,13,12,2,0,
23,3,17,29,5,5,2,15,17,87,21,25,11,43,41,19,4,13,19,13,
23,57,29,5,85,119,65,81,69,125,45,33,101,3,23,23,39,45,69,59,
45,83,59,57,65,85,1,22,78,50,20,8,30,18,8,0,26,38,86,56,
42,26,68,34,40,10,68,16,72,46,36,24,50,22,8,6,6,9,104,60,
22,6,40,8,13,1,34,82,72,42,20,64,28,24,8,6,124,11,4,18,
14,1,14,22,30,26,38,50,74,7,2,17,15,124,29,75,17,8,8,15,
15,13,21,2,27,65,11,9,46,13,27,11,9,1,19,17,13,53,39,19,
23,13,50,75,27,50,39,11,11,13,10,7,17,6,20,15,15,87,64,60,
62,28,7,7,11,31,13,33,43,31,67,59,63,83,75,97,125,69,51,49,
53,79,63,53,57,59,31,29,39,33,43,81,55,49,95,67,91,91,125,117,
107,107,29,23,109,45,45,59,93,69,71,77,55,65,43,35,89,99,125,49,
71,83,13,20,30,36,72,48,58,14,66,56,76,62,82,70,48,84,9,27,
43,59,59,113,111,105,32,90,80,86,68,72,42,40,22,22,13,20,30,36,
72,48,58,14,66,56,76,62,82,70,48,84,9,27,43,59,59,113,111,105,
0,0,0,0,50,8,37,50,8,37,24,42,54,24,11,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,10,65,67,20,23,13,104,12,11,35,7,37,
16,26,18,40,2,34,18,12,34,27,37,31,43,66,2,40,11,4,15,0,
34,15,33,17,19,36,9,12,3,21,12,9,12,22,12,24,40,34,37,11,
6,5,4,17,22,13,4,38,7,32,34,12,73,20,9,61,25,71,19,8,
5,14,4,4,44,8,1,22,42,17,17,6,87,33,8,63,1,27,36,2,
45,58,2,3,59,64,35,67,2,81,1,28,34,22,28,20,0,26,36,45,
13,16,6,2,31,13,21,31,15,29,49,19,23,101,53,35,65,55,51,26,
42,22,16,16,3,17,3,31,43,27,57,81,79,125,21,23,55,39,53,61,
71,77,87,97,93,125,43,91,105,73,77,2,76,54,36,14,10,3,5,15,
5,20,100,66,50,34,84,34,24,6,8,8,98,60,36,18,46,18,4,0,
1,7,66,28,14,0,24,4,7,3,14,88,52,32,20,54,22,20,16,8,
124,25,7,12,5,9,2,18,20,4,20,32,44,25,15,25,13,40,25,27,
13,4,34,51,33,16,26,49,55,49,15,7,20,11,0,5,6,20,25,9,
7,8,41,19,33,33,12,73,25,6,13,36,13,3,56,13,17,3,46,41,
27,77,34,56,58,34,4,36,28,14,16,12,6,0,35,43,57,35,27,51,
93,49,45,47,39,35,15,15,43,59,25,4,2,6,11,45,19,25,57,35,
51,49,81,75,65,57,21,11,51,25,31,49,61,63,65,67,71,79,103,91,
107,105,107,81,101,107,21,10,3,16,24,24,124,46,42,9,62,124,114,124,
38,30,14,57,107,115,125,125,125,125,5,86,54,36,18,28,4,5,9,7,
9,2,28,12,48,34,18,30,34,40,42,22,48,38,1,34,20,7,21,33,
45,101,99,81,0,0,0,0,50,8,37,50,8,37,24,42,54,24,11,59,
7,52,78,20,74,43,21,52,13,19,72,61,59,0,27,125,125,125,44,12,
9,21,52,13,25,26,72,3,8,2,8,89,95,61,97,3,15,15,25,55,
35,69,0,9,11,1,64,2,44,0,0,0,10,65,67,20,23,13,22,0,
19,66,36,12,94,90,14,36,40,50,18,16,72,91,51,51,55,50,15,36,
72,3,21,4,34,3,19,17,35,48,25,28,0,23,16,9,0,14,26,34,
38,14,31,7,6,3,0,15,60,5,2,62,54,76,62,54,67,20,20,25,
7,25,11,64,4,10,74,112,124,124,94,71,89,22,84,84,123,19,26,69,
48,13,8,72,66,108,98,92,91,2,37,73,73,7,28,42,22,10,22,20,
6,30,18,27,13,12,0,0,25,3,19,31,5,5,2,15,19,91,21,27,
11,45,41,25,0,17,21,17,27,63,33,9,89,123,67,85,73,125,47,37,
105,7,25,25,41,49,73,63,49,85,59,59,67,87,2,26,82,52,20,8,
32,18,8,2,28,40,88,58,44,26,70,36,42,12,72,16,74,48,38,24,
52,22,10,8,8,9,108,62,22,6,40,10,13,1,34,84,72,44,20,66,
28,24,10,6,124,7,8,22,18,2,16,26,32,30,42,54,78,7,4,17,
15,124,29,77,17,8,10,15,15,13,21,2,27,67,11,9,46,13,27,11,
9,1,19,17,13,55,41,19,23,13,52,77,27,52,41,11,11,13,12,7,
17,8,22,15,15,91,62,58,60,24,11,13,15,37,17,39,49,37,73,65,
67,89,81,105,125,73,57,53,57,83,67,55,59,61,31,33,43,37,47,85,
57,51,99,71,97,95,125,121,111,109,31,27,113,47,49,61,97,73,75,79,
57,67,45,33,91,103,125,51,75,85,11,22,32,36,74,50,60,14,68,58,
78,64,84,72,50,82,13,31,47,63,63,117,115,107,34,90,82,88,68,74,
44,42,24,22,11,22,32,36,74,50,60,14,68,58,78,64,84,72,50,82,
13,31,47,63,63,117,115,107,0,0,0,0,46,8,37,46,8,37,26,46,
54,24,13,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,10,67,67,22,
25,13,104,12,11,33,5,37,18,28,22,44,4,36,22,14,38,25,37,29,
41,66,2,42,9,4,15,2,38,15,33,15,17,36,9,14,1,19,14,9,
12,22,12,24,42,36,39,11,6,5,4,17,22,15,2,38,9,32,34,12,
77,20,11,65,27,73,17,10,3,16,4,6,46,10,0,24,44,17,17,6,
89,33,10,63,1,27,38,2,47,60,2,3,61,66,35,69,2,83,5,26,
32,20,26,18,1,24,36,49,15,14,6,2,33,15,23,33,17,31,51,21,
25,105,55,37,67,57,51,22,40,18,12,12,7,21,7,37,47,31,63,85,
83,125,25,27,59,43,57,65,75,81,91,103,97,125,45,95,107,75,77,2,
76,54,36,14,10,3,5,15,5,20,100,66,50,34,86,34,26,6,10,8,
100,62,36,18,46,18,6,0,0,5,68,30,14,0,26,6,5,1,14,88,
52,32,20,56,24,20,18,10,124,25,7,12,5,9,2,18,20,4,20,32,
44,25,15,25,15,42,27,29,15,2,34,55,35,16,26,51,57,49,15,5,
22,9,0,3,6,22,27,9,7,8,43,19,33,31,14,73,25,6,13,38,
13,3,58,13,19,3,48,43,27,79,32,56,56,32,2,34,26,12,14,10,
4,1,37,45,59,39,29,53,97,51,47,49,41,37,15,15,43,59,25,1,
3,2,15,51,23,29,63,39,55,53,85,79,69,59,25,15,53,29,35,53,
65,69,69,71,75,83,109,95,111,109,109,85,105,109,19,12,1,18,26,26,
124,48,44,9,64,124,118,124,40,26,10,63,113,121,125,125,125,125,5,86,
54,36,18,28,4,5,9,7,7,4,30,12,50,36,18,32,36,42,44,22,
48,38,1,32,16,11,25,37,49,105,103,83,0,0,0,0,46,8,37,46,
8,37,26,46,54,24,13,63,9,50,80,20,78,47,21,54,13,19,74,63,
63,3,31,125,125,125,48,14,9,21,54,13,25,28,72,5,10,4,10,91,
99,63,97,3,15,13,25,55,35,69,0,9,11,1,66,2,44,0,0,0,
10,67,67,22,25,13,20,0,17,70,38,14,96,92,14,38,44,52,20,18,
76,93,51,51,55,50,17,38,76,3,19,6,38,3,19,17,35,48,25,28,
2,23,16,9,0,14,26,36,38,14,31,9,6,3,0,15,60,5,2,64,
54,76,62,54,69,20,22,25,7,25,11,66,4,10,76,114,124,124,98,71,
91,22,84,84,125,19,28,71,50,13,8,74,66,108,98,94,93,6,39,79,
79,5,26,42,20,8,20,20,4,30,16,29,15,10,0,0,25,5,21,33,
7,7,0,17,19,93,23,29,11,49,43,29,3,21,25,21,31,71,39,11,
93,125,71,89,77,125,51,39,109,9,27,27,43,51,77,67,53,89,59,61,
69,91,4,28,84,52,20,8,34,20,10,4,32,42,90,58,46,28,72,38,
46,14,76,18,74,48,38,26,54,24,10,8,10,9,110,64,22,6,42,10,
13,0,36,84,74,44,20,68,30,26,10,8,124,5,10,24,22,4,20,28,
36,32,44,58,82,5,6,15,13,124,29,79,17,10,10,15,15,13,23,4,
27,69,11,9,48,13,27,11,9,1,21,17,13,57,43,19,23,13,54,79,
27,52,43,11,11,13,12,7,19,8,24,15,15,93,60,56,58,20,15,17,
21,43,23,45,57,43,81,71,71,97,89,113,125,79,61,57,61,89,71,59,
61,63,31,39,47,41,51,89,61,55,103,75,101,99,125,125,115,111,33,29,
119,51,53,65,101,75,77,81,59,69,45,31,93,105,125,53,77,87,11,22,
32,38,76,50,62,14,70,60,80,64,86,72,52,82,17,35,51,67,67,121,
119,111,34,92,82,90,70,74,44,42,24,24,11,22,32,38,76,50,62,14,
70,60,80,64,86,72,52,82,17,35,51,67,67,121,119,111,0,0,0,0,
44,8,37,44,8,37,30,48,54,24,13,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,12,67,67,22,27,13,104,12,11,31,3,37,18,32,24,48,
8,38,24,18,42,23,35,27,41,68,2,44,7,4,13,4,42,15,33,15,
13,38,7,14,0,19,14,9,14,24,14,26,42,36,39,13,6,5,4,17,
22,15,0,38,9,32,34,10,81,20,11,67,29,75,15,12,1,18,6,8,
48,12,0,26,46,17,17,8,91,31,12,63,0,27,38,2,49,62,2,3,
65,68,37,71,2,83,7,24,32,18,24,16,3,24,36,51,17,14,6,2,
33,15,23,35,17,33,53,21,27,109,57,39,69,59,51,18,38,14,8,10,
11,27,11,41,51,35,67,91,87,125,29,29,63,49,61,69,79,87,95,109,
101,125,47,97,111,75,77,2,76,56,36,14,10,3,5,15,3,22,102,66,
50,34,88,36,28,6,12,10,102,64,36,20,48,20,6,2,2,5,72,30,
14,2,28,8,5,0,16,90,54,32,20,58,26,22,20,12,124,25,7,14,
5,9,2,18,20,6,20,34,46,25,15,25,17,42,29,31,17,2,34,57,
37,14,26,53,59,51,13,5,24,9,2,3,8,24,27,9,7,8,45,19,
33,31,16,73,25,8,13,38,13,3,60,13,19,3,50,43,29,79,30,56,
56,32,0,32,24,10,14,8,2,3,39,47,61,41,33,57,101,53,49,51,
43,37,15,13,43,61,23,5,7,1,21,55,27,33,67,43,59,57,89,83,
71,61,29,19,55,33,39,57,69,73,73,75,79,87,113,99,115,113,111,89,
109,113,17,16,0,18,28,28,124,50,46,9,66,124,120,124,40,24,6,67,
119,125,125,125,125,125,5,86,54,36,18,28,4,5,9,5,5,6,32,14,
52,38,20,34,38,44,46,24,50,40,1,28,14,13,27,41,53,109,107,85,
0,0,0,0,44,8,37,44,8,37,30,48,54,24,13,67,13,48,82,20,
80,51,19,58,15,19,76,65,65,5,35,125,125,125,52,16,9,19,58,15,
25,30,72,5,10,6,14,93,101,63,97,3,13,11,27,55,35,69,0,7,
11,0,66,2,44,0,0,0,12,67,67,22,27,13,20,2,13,76,40,16,
100,96,16,40,48,54,22,20,82,93,53,51,57,50,17,40,82,1,19,6,
42,3,19,17,33,48,25,30,4,21,18,7,0,16,28,38,40,14,33,9,
8,3,0,15,62,5,2,64,56,76,62,54,69,22,22,27,7,23,11,68,
6,12,80,118,124,124,102,73,93,24,86,84,125,19,28,71,52,13,8,78,
66,108,98,98,95,8,41,83,85,3,26,42,20,8,20,20,4,30,16,31,
17,10,0,0,25,5,21,35,7,7,0,19,21,95,25,29,11,51,43,33,
7,23,27,23,35,77,43,13,97,125,73,93,81,125,53,41,111,11,29,29,
47,55,81,71,55,91,59,63,71,95,8,32,86,54,20,8,36,22,12,4,
36,46,92,60,46,30,76,40,48,16,82,20,76,50,40,26,56,26,12,10,
12,7,112,66,22,6,44,12,11,2,38,84,76,44,20,70,32,28,12,10,
124,3,14,28,24,6,22,32,40,36,48,62,88,3,8,13,11,124,27,81,
15,12,12,15,15,13,23,4,29,71,11,9,50,13,27,11,9,0,21,19,
13,59,45,21,23,13,56,79,29,54,43,13,11,13,12,9,19,8,24,15,
15,97,58,54,56,18,21,23,27,49,27,51,63,49,87,75,75,105,95,121,
125,85,65,59,65,93,75,61,63,65,31,43,53,47,55,93,65,57,107,79,
105,103,125,125,117,115,35,31,123,53,55,67,105,77,79,83,61,71,45,29,
97,107,125,57,79,89,11,24,34,40,78,52,62,16,72,62,82,66,88,74,
52,80,21,39,55,71,71,125,123,113,36,92,84,90,72,76,46,44,24,26,
11,24,34,40,78,52,62,16,72,62,82,66,88,74,52,80,21,39,55,71,
71,125,123,113,0,0,0,0,42,8,37,42,8,37,34,52,56,24,15,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,12,67,67,24,29,13,104,12,
11,29,1,37,20,34,28,52,10,40,28,20,46,21,33,25,39,70,2,46,
5,4,13,4,46,15,31,13,11,38,7,16,4,17,16,9,14,24,14,28,
44,38,41,13,6,5,4,17,22,17,0,38,11,32,34,10,85,20,13,71,
31,77,13,14,0,20,8,8,50,12,2,28,48,17,17,8,93,31,14,63,
0,27,40,2,51,64,2,3,67,70,37,73,2,85,11,22,30,16,22,14,
3,22,34,53,19,14,6,2,35,17,25,37,19,35,55,23,27,113,59,39,
71,61,51,16,34,12,4,6,15,31,15,47,57,39,73,95,93,125,33,33,
65,53,65,75,85,91,101,113,105,125,49,101,113,77,77,2,78,56,36,14,
10,3,5,15,3,22,102,66,50,34,90,36,28,8,12,12,104,64,38,20,
50,20,8,2,4,3,74,32,16,2,30,10,3,2,16,90,54,32,20,60,
26,24,22,14,124,23,5,14,5,9,2,18,20,6,20,34,46,25,15,25,
17,44,31,33,19,0,34,59,39,14,26,53,61,51,11,3,26,7,2,1,
8,26,27,9,7,10,45,19,33,29,18,73,25,8,13,40,13,3,62,13,
19,3,52,45,29,81,28,54,54,30,1,30,22,8,12,6,0,5,41,49,
63,45,35,59,105,57,51,53,43,39,15,13,43,61,21,9,11,5,25,61,
31,37,73,47,63,61,95,87,75,63,33,21,59,37,43,61,73,77,77,79,
83,91,119,103,119,117,113,93,113,115,15,18,2,20,30,30,124,52,48,9,
68,124,124,124,42,20,4,73,125,125,125,125,125,125,5,86,54,36,18,28,
4,5,9,5,3,8,34,16,54,38,20,36,38,44,46,24,50,40,1,26,
10,17,31,45,57,113,111,87,0,0,0,0,42,8,37,42,8,37,34,52,
56,24,15,71,15,46,82,20,84,53,19,60,15,21,78,67,67,7,39,125,
125,125,56,20,9,19,60,15,23,32,74,5,12,8,16,95,103,63,99,3,
13,9,27,57,35,69,0,7,11,2,68,2,44,0,0,0,12,67,67,24,
29,13,18,2,11,80,42,18,102,98,18,42,52,56,24,22,86,95,53,51,
57,52,17,42,86,1,17,8,46,3,19,17,33,50,25,30,6,21,20,7,
0,16,28,40,40,14,33,9,8,3,0,15,62,5,2,66,56,78,62,56,
71,22,24,27,7,23,11,70,6,12,82,120,124,124,106,73,95,24,86,84,
125,19,30,73,52,13,8,80,66,108,98,100,97,12,43,89,91,0,26,42,
18,6,18,18,2,30,14,33,19,10,0,0,27,7,23,37,9,7,0,21,
21,97,25,31,11,53,45,37,11,27,31,27,39,83,49,15,101,125,77,97,
85,125,55,43,115,13,31,31,49,57,85,75,59,95,59,65,73,97,10,34,
90,54,20,8,38,24,14,6,40,48,94,62,48,30,78,42,52,18,86,20,
76,50,40,28,58,26,12,12,14,7,116,68,22,6,46,12,11,4,40,86,
78,46,20,72,32,30,12,10,124,0,16,30,28,8,26,34,42,38,52,66,
92,3,10,13,9,124,27,83,15,14,14,15,15,13,23,6,29,73,11,9,
50,13,27,11,9,0,23,19,13,61,47,21,23,13,58,81,29,56,45,13,
11,13,14,9,21,10,26,15,15,99,56,52,54,14,25,27,31,55,33,57,
69,55,93,81,79,113,103,125,125,91,69,63,69,99,79,63,65,67,31,47,
57,51,59,97,69,61,111,83,109,107,125,125,121,117,37,33,125,57,59,71,
109,81,83,85,63,73,45,27,99,111,125,59,81,91,11,24,34,40,80,54,
64,16,74,64,84,66,90,74,54,80,25,43,59,75,75,125,125,115,36,94,
84,92,72,78,46,44,26,26,11,24,34,40,80,54,64,16,74,64,84,66,
90,74,54,80,25,43,59,75,75,125,125,115,0,0,0,0,40,8,37,40,
8,37,38,54,56,24,15,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,
14,67,67,24,31,13,104,12,11,27,0,37,20,36,32,56,14,42,32,22,
50,19,31,23,37,72,2,48,3,4,11,6,50,15,31,13,9,38,7,16,
6,17,18,9,14,24,14,30,44,38,41,13,6,5,4,17,22,17,1,38,
13,32,34,10,89,20,13,75,33,79,11,16,2,22,10,10,52,14,2,30,
50,17,17,8,95,29,16,63,0,27,42,2,53,66,2,3,69,72,39,75,
2,87,13,20,30,14,20,12,5,20,34,55,21,14,6,2,35,19,27,39,
21,37,57,25,29,117,61,41,73,63,51,12,32,8,0,2,19,35,19,51,
61,43,77,101,97,125,37,37,69,57,69,79,89,95,105,119,109,125,51,105,
115,79,77,2,78,56,36,14,10,3,5,15,1,22,102,66,50,34,92,38,
30,8,14,14,106,66,38,20,52,22,8,4,6,1,76,34,16,2,32,12,
1,4,18,90,54,32,20,62,28,26,24,16,124,23,5,16,5,9,2,18,
20,6,20,34,48,25,15,25,19,44,33,35,21,1,34,61,41,14,26,55,
63,53,9,1,28,7,4,1,10,28,27,9,7,10,47,19,33,29,20,73,
25,8,13,42,13,3,64,13,19,3,54,47,29,83,26,54,54,28,3,28,
20,6,10,4,1,7,43,51,65,47,37,63,109,59,53,55,45,39,15,13,
43,63,19,13,15,9,29,67,35,41,77,51,67,65,99,91,77,65,37,25,
61,41,47,65,77,81,81,83,87,95,123,107,123,121,115,97,117,119,13,20,
4,22,32,32,124,54,50,9,70,124,124,124,44,18,0,77,125,125,125,125,
125,125,5,86,54,36,18,28,4,5,9,3,1,10,36,18,56,40,22,38,
40,46,48,24,52,40,1,24,8,21,35,49,61,117,115,89,0,0,0,0,
40,8,37,40,8,37,38,54,56,24,15,75,19,44,84,20,88,57,19,64,
15,21,80,69,69,9,43,125,125,125,60,22,9,19,64,15,23,34,74,5,
14,10,18,97,105,63,99,3,13,7,27,57,35,69,0,7,11,4,68,2,
44,0,0,0,14,67,67,24,31,13,18,4,9,84,44,20,106,102,20,44,
56,58,26,24,90,97,53,51,57,52,17,44,90,1,15,10,50,3,19,17,
33,50,25,32,8,21,22,7,0,16,30,42,42,14,33,9,8,3,0,15,
62,5,2,66,56,78,62,56,71,24,26,29,7,23,11,72,6,14,84,122,
124,124,110,75,97,26,86,84,125,19,30,73,54,13,8,82,66,108,98,102,
99,14,45,95,97,2,26,42,18,4,18,18,2,30,14,35,21,10,0,0,
27,7,25,39,9,7,0,23,23,99,27,33,11,55,45,41,15,31,33,31,
43,89,53,17,105,125,79,101,89,125,57,45,119,15,33,33,51,61,89,79,
63,97,59,67,75,101,14,38,92,56,20,8,40,26,16,8,44,50,96,64,
50,32,80,44,54,20,90,22,78,52,42,28,60,28,14,14,16,7,118,70,
22,6,48,14,11,6,42,86,80,46,20,74,34,32,14,12,124,2,20,34,
32,10,28,38,46,42,56,70,96,1,12,11,7,124,27,85,15,16,16,15,
15,13,23,6,29,75,11,9,52,13,27,11,9,0,23,19,13,63,49,21,
23,13,60,83,29,58,47,13,11,13,14,9,21,10,28,15,15,103,54,50,
52,10,29,33,37,61,37,63,75,61,99,87,83,121,109,125,125,97,73,67,
73,103,83,65,67,69,31,51,61,55,63,101,73,63,115,87,113,111,125,125,
125,119,39,35,125,59,63,73,113,83,85,87,65,75,45,25,101,113,125,61,
83,93,11,26,36,42,82,56,66,16,76,66,86,68,92,76,56,78,29,47,
63,79,79,125,125,117,38,94,86,94,74,80,48,46,26,28,11,26,36,42,
82,56,66,16,76,66,86,68,92,76,56,78,29,47,63,79,79,125,125,117,
0,0,0,0,36,6,39,36,6,39,40,56,56,24,17,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,44,0,0,0,14,69,67,24,33,15,104,10,11,25,0,37,
20,38,34,58,16,44,34,24,52,17,31,21,37,72,2,48,3,4,11,6,
52,15,31,13,7,38,7,16,8,17,18,9,14,24,14,30,44,38,43,15,
6,7,4,17,20,19,3,38,15,30,34,8,93,18,15,79,35,81,11,16,
2,22,10,10,54,14,2,30,52,19,17,8,99,29,16,63,0,29,42,2,
55,66,2,3,73,72,41,77,2,89,17,18,28,12,18,10,7,18,32,59,
23,12,4,2,37,21,29,41,23,39,59,27,31,121,65,43,77,67,51,8,
28,4,3,1,25,41,25,57,67,49,83,107,103,125,41,41,73,63,75,85,
95,101,111,125,115,125,53,109,119,81,79,2,78,56,36,14,10,5,5,15,
1,22,102,66,50,34,94,38,30,8,14,14,106,66,38,20,52,22,8,4,
8,1,78,34,16,2,32,12,1,6,18,90,54,32,20,62,28,26,24,16,
124,23,5,16,5,9,2,18,20,6,20,34,48,25,15,27,21,44,35,37,
23,3,32,65,45,12,24,57,67,55,9,1,30,7,4,1,10,28,29,9,
7,10,49,19,33,29,20,75,25,8,13,42,15,3,64,15,21,3,54,49,
31,85,24,52,52,26,7,26,18,4,8,2,3,9,45,55,69,51,41,67,
113,63,57,57,47,41,15,13,43,65,19,19,21,13,35,73,41,47,83,57,
73,71,105,97,81,67,41,29,65,45,53,71,83,87,87,87,93,101,125,111,
125,125,119,101,121,123,11,22,6,22,32,32,124,54,50,9,70,124,124,124,
44,14,3,83,125,125,125,125,125,125,5,86,52,34,18,28,4,7,9,3,
1,10,36,18,58,40,22,38,40,46,48,24,52,40,3,20,4,25,39,53,
65,123,119,91,0,0,0,0,36,6,39,36,6,39,40,56,56,24,17,79,
23,42,84,20,90,61,19,66,17,23,82,71,73,13,47,125,125,125,64,24,
9,19,66,17,23,34,74,7,14,10,20,101,109,65,101,5,13,7,29,59,
35,69,1,7,11,4,68,0,44,0,0,0,14,69,67,24,33,15,16,4,
7,88,46,20,108,104,20,46,58,58,28,24,94,99,55,53,59,52,19,44,
94,1,15,10,52,3,19,17,33,50,27,32,8,21,22,7,0,16,30,44,
42,14,35,11,8,3,1,15,62,5,2,66,56,78,62,56,73,24,26,31,
7,23,13,72,6,14,86,124,124,124,112,77,101,26,86,84,125,21,30,75,
54,15,8,84,66,106,98,104,101,16,49,101,105,4,24,42,16,2,16,16,
0,28,12,37,23,8,1,1,29,9,27,41,11,9,1,25,25,103,29,35,
11,59,47,47,21,35,37,35,49,97,59,21,109,125,83,107,93,125,61,49,
123,19,35,35,55,65,93,83,67,101,59,69,77,105,16,40,94,56,20,8,
40,26,16,8,46,52,96,64,50,32,82,46,56,20,94,22,78,52,42,28,
60,28,14,14,18,7,120,72,22,4,48,14,11,6,42,86,80,46,20,76,
34,32,14,12,124,4,22,36,34,12,30,40,48,44,58,72,100,1,12,11,
7,124,27,89,15,16,16,15,15,13,25,6,31,77,13,9,52,15,27,13,
9,0,25,21,15,65,51,23,25,13,62,85,31,58,49,15,11,15,14,11,
23,10,28,15,15,107,50,48,48,6,35,39,43,67,43,69,83,67,107,93,
87,125,117,125,125,103,79,71,79,109,87,69,71,71,31,57,67,61,67,107,
77,67,121,91,119,115,125,125,125,123,43,39,125,63,67,77,117,87,89,89,
67,77,47,23,105,117,125,65,87,97,11,26,36,42,84,56,66,16,78,66,
88,68,92,76,56,76,33,51,69,85,83,125,125,121,38,94,86,94,74,80,
48,46,26,28,11,26,36,42,84,56,66,16,78,66,88,68,92,76,56,76,
33,51,69,85,83,125,125,121,0,0,0,0,34,6,39,34,6,39,44,60,
58,26,17,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,44,0,0,0,16,69,67,26,
33,15,104,10,11,21,2,37,22,42,38,62,20,48,38,28,56,13,29,19,
35,74,4,50,1,6,9,8,56,13,29,11,3,40,5,18,12,15,20,7,
16,26,16,32,46,40,43,15,8,7,4,15,20,19,3,38,15,30,34,8,
95,18,15,81,37,81,9,18,4,24,12,12,56,16,4,32,56,19,17,10,
101,27,18,63,2,29,44,4,55,68,2,3,75,74,41,79,2,89,19,18,
28,12,18,10,7,18,32,61,23,12,4,2,37,21,29,41,23,39,61,27,
31,123,67,43,79,69,51,6,26,2,5,3,29,45,29,61,71,53,87,111,
107,125,43,43,75,67,79,89,99,105,115,125,119,125,53,111,121,81,79,4,
80,58,38,16,10,5,3,13,0,24,104,68,52,34,96,40,32,10,16,16,
108,68,40,22,54,24,10,6,12,0,82,36,18,4,34,14,0,10,20,92,
56,34,22,64,30,28,26,18,124,21,3,18,5,7,2,20,22,8,22,36,
50,23,15,27,21,46,35,37,25,3,32,67,47,12,24,57,69,55,7,0,
32,5,6,0,12,30,29,7,5,12,49,17,31,27,22,75,25,10,13,44,
15,3,66,15,21,1,56,49,31,85,24,52,52,26,9,26,18,4,8,2,
3,9,45,57,71,53,43,69,115,65,59,57,47,41,13,11,41,65,17,23,
25,17,39,77,45,51,87,61,77,75,109,101,83,67,43,31,67,47,57,75,
87,91,91,91,97,105,125,113,125,125,121,103,123,125,7,26,10,24,34,34,
124,56,52,9,72,124,124,124,46,12,5,87,125,125,125,125,125,125,3,88,
52,34,18,30,4,7,9,1,0,12,38,20,62,42,24,40,42,48,50,26,
54,42,3,18,2,27,41,55,67,125,121,91,0,0,0,0,34,6,39,34,
6,39,44,60,58,26,17,81,25,42,86,22,94,63,17,70,17,23,86,71,
75,15,49,125,125,125,68,28,7,17,70,17,21,36,76,7,16,12,24,103,
111,65,101,5,11,5,29,59,33,67,1,5,9,6,70,0,44,0,0,0,
16,69,67,26,33,15,16,6,3,94,50,22,112,108,22,50,62,60,32,26,
100,99,55,53,59,54,19,46,100,0,13,12,56,3,17,17,31,52,27,34,
10,19,24,5,2,18,32,46,44,16,35,11,10,1,1,13,64,3,2,68,
58,80,64,58,73,26,28,31,7,21,13,74,8,16,90,124,124,124,116,77,
103,28,88,86,125,21,32,75,56,15,10,88,66,106,100,108,103,20,51,105,
111,8,24,42,16,2,16,16,0,28,12,37,23,8,1,1,29,9,27,41,
11,9,1,25,25,105,29,35,11,61,47,51,25,37,39,37,53,103,63,23,
111,125,85,111,95,125,63,51,125,21,35,35,57,67,95,85,69,103,59,69,
77,107,20,44,98,58,20,8,42,28,18,10,50,56,98,66,52,34,86,48,
60,22,100,24,80,54,44,30,62,30,16,16,22,5,124,74,24,4,50,16,
9,8,44,88,82,48,22,78,36,34,16,14,124,8,26,40,38,16,34,44,
52,48,62,76,106,0,14,9,5,124,25,91,13,18,18,13,15,11,25,8,
31,77,13,9,54,15,27,13,9,2,25,21,15,65,51,23,25,11,66,85,
31,60,49,15,11,15,16,11,23,12,30,13,13,109,48,46,46,4,39,43,
47,73,47,73,89,71,113,97,91,125,123,125,125,107,83,73,83,113,89,71,
73,71,31,61,71,65,71,111,79,69,125,93,123,117,125,125,125,125,45,41,
125,65,69,79,119,89,91,91,67,77,47,21,107,119,125,67,89,99,9,28,
38,44,88,58,68,18,82,68,90,70,94,78,58,76,35,53,73,89,85,125,
125,123,40,96,88,96,76,82,50,48,28,30,9,28,38,44,88,58,68,18,
82,68,90,70,94,78,58,76,35,53,73,89,85,125,125,123,0,0,0,0,
32,6,39,32,6,39,48,62,58,26,17,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
44,0,0,0,18,69,67,26,35,15,104,10,11,19,4,37,22,44,42,66,
22,50,42,30,60,11,27,17,33,76,4,52,0,6,9,10,60,13,29,11,
1,40,5,18,14,15,22,7,16,26,16,34,46,40,45,15,8,7,4,15,
20,19,5,38,17,30,34,8,99,18,15,85,39,83,7,20,6,26,14,14,
58,18,4,34,58,19,17,10,103,27,20,63,2,29,46,4,57,70,2,3,
77,76,43,81,2,91,23,16,26,10,16,8,9,16,32,63,25,12,4,2,
37,23,31,43,25,41,63,29,33,125,69,45,81,71,51,2,24,1,9,7,
33,49,33,67,75,57,93,117,111,125,47,47,79,71,83,93,103,109,119,125,
123,125,55,115,123,83,79,4,80,58,38,16,10,5,3,13,2,24,104,68,
52,34,98,40,34,10,18,18,110,70,40,22,56,24,10,8,14,2,84,38,
18,4,36,16,2,12,20,92,56,34,22,66,32,30,28,20,124,21,3,18,
5,7,2,20,22,8,22,36,52,23,15,27,23,46,37,39,27,5,32,69,
49,12,24,59,71,57,5,2,34,5,6,0,14,32,29,7,5,12,51,17,
31,27,24,75,25,10,13,46,15,3,68,15,21,1,58,51,31,87,22,52,
52,24,11,24,16,2,6,0,5,11,47,59,73,57,45,73,119,67,61,59,
49,41,13,11,41,67,15,27,29,21,43,83,49,55,93,65,81,79,113,105,
85,69,47,35,69,51,61,79,91,95,95,95,101,109,125,117,125,125,123,107,
125,125,5,28,12,26,36,36,124,58,54,9,74,124,124,124,48,10,9,93,
125,125,125,125,125,125,3,88,52,34,18,30,4,7,9,0,2,14,40,22,
64,44,26,42,44,50,52,26,56,42,3,16,1,31,45,59,71,125,125,93,
0,0,0,0,32,6,39,32,6,39,48,62,58,26,17,85,29,40,88,22,
98,67,17,72,17,23,88,73,77,17,53,125,125,125,72,30,7,17,72,17,
21,38,76,7,18,14,26,105,113,65,101,5,11,3,29,59,33,67,1,5,
9,8,70,0,44,0,0,0,18,69,67,26,35,15,16,8,1,98,52,24,
116,112,24,52,66,62,34,28,104,101,55,53,59,54,19,48,104,0,11,14,
60,3,17,17,31,52,27,34,12,19,26,5,2,18,32,48,46,16,35,11,
10,1,1,13,64,3,2,68,58,80,64,58,75,28,30,33,7,21,13,76,
8,16,92,124,124,124,120,79,105,28,88,86,125,21,32,77,58,15,10,90,
66,106,100,110,105,22,53,111,117,10,24,42,16,0,14,16,0,28,10,39,
25,8,1,1,29,11,29,43,11,9,1,27,27,107,31,37,11,63,49,55,
29,41,43,41,57,109,67,25,115,125,89,115,99,125,65,53,125,23,37,37,
59,71,99,89,73,107,59,71,79,111,22,46,100,60,20,8,44,30,20,12,
54,58,100,68,54,36,88,50,62,24,104,26,80,54,44,30,64,32,18,18,
24,5,124,76,24,4,52,18,9,10,46,88,84,48,22,80,38,36,18,16,
124,10,30,44,42,18,36,48,56,50,66,80,110,2,16,7,3,124,25,93,
13,20,20,13,15,11,25,8,31,79,13,9,56,15,27,13,9,2,25,21,
15,67,53,23,25,11,68,87,31,62,51,15,11,15,16,11,23,12,32,13,
13,113,46,44,44,0,43,49,53,79,51,79,95,77,119,103,95,125,125,125,
125,113,87,77,87,117,93,73,75,73,31,65,75,69,75,115,83,73,125,97,
125,121,125,125,125,125,47,43,125,69,73,83,123,91,93,93,69,79,47,19,
109,121,125,69,91,101,9,28,40,46,90,60,70,18,84,70,92,70,96,80,
60,74,39,57,77,93,89,125,125,125,42,96,88,98,78,84,50,50,28,32,
9,28,40,46,90,60,70,18,84,70,92,70,96,80,60,74,39,57,77,93,
89,125,125,125,0,0,0,0,30,6,39,30,6,39,52,66,60,26,19,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,44,0,0,0,18,69,67,28,37,15,104,10,
11,17,6,37,24,46,46,70,26,52,46,32,64,9,25,15,31,78,4,54,
2,6,7,10,64,13,27,9,0,40,5,20,18,13,24,7,16,26,16,36,
48,42,45,15,8,7,4,15,20,21,5,38,19,30,34,8,103,18,17,89,
41,85,5,22,8,28,16,14,60,18,6,36,60,19,17,10,105,25,22,63,
2,29,48,4,59,72,2,3,79,78,43,83,2,93,25,14,26,8,14,6,
9,14,30,65,27,12,4,2,39,25,33,45,27,43,65,31,33,125,71,45,
83,73,51,0,20,3,13,11,37,53,37,71,81,61,97,121,117,125,51,51,
81,75,87,99,109,113,125,125,125,125,57,119,125,85,79,4,82,58,38,16,
10,5,3,13,2,24,104,68,52,34,100,42,34,12,18,20,112,70,42,22,
58,26,12,8,16,4,86,40,20,4,38,18,4,14,22,92,56,34,22,68,
32,32,30,22,124,19,1,20,5,7,2,20,22,8,22,36,52,23,15,27,
23,48,39,41,29,7,32,71,51,12,24,59,73,57,3,4,36,3,8,2,
14,34,29,7,5,14,51,17,31,25,26,75,25,10,13,48,15,3,70,15,
21,1,60,53,31,89,20,50,50,22,13,22,14,0,4,1,7,13,49,61,
75,59,47,75,123,71,63,61,49,43,13,11,41,67,13,31,33,25,47,89,
53,59,97,69,85,83,119,109,89,71,51,37,73,55,65,83,95,99,99,99,
105,113,125,121,125,125,125,111,125,125,3,30,14,28,38,38,124,60,56,9,
76,124,124,124,50,6,11,97,125,125,125,125,125,125,3,88,52,34,18,30,
4,7,9,0,4,16,42,24,66,44,26,44,44,50,52,26,56,42,3,14,
3,35,49,63,75,125,125,95,0,0,0,0,30,6,39,30,6,39,52,66,
60,26,19,89,31,38,88,22,102,69,17,76,17,25,90,75,79,19,57,125,
125,125,76,34,7,17,76,17,19,40,78,7,20,16,28,107,115,65,103,5,
11,1,29,61,33,67,1,5,9,10,72,0,44,0,0,0,18,69,67,28,
37,15,14,8,0,102,54,26,118,114,26,54,70,64,36,30,108,103,55,53,
59,56,19,50,108,0,9,16,64,3,17,17,31,54,27,36,14,19,28,5,
2,18,34,50,46,16,35,11,10,1,1,13,64,3,2,70,58,82,64,60,
75,28,32,33,7,21,13,78,8,18,94,124,124,124,124,79,107,30,88,86,
125,21,34,77,58,15,10,92,66,106,100,112,107,26,55,117,123,14,24,42,
14,1,14,14,1,28,10,41,27,8,1,1,31,11,31,45,13,9,1,29,
27,109,31,39,11,65,49,59,33,45,45,45,61,115,73,27,119,125,91,119,
103,125,67,55,125,25,39,39,61,73,103,93,77,109,59,73,81,113,26,50,
104,60,20,8,46,32,22,14,58,60,102,70,56,36,90,52,66,26,108,26,
82,56,46,32,66,32,18,20,26,5,124,78,24,4,54,18,9,12,48,90,
86,50,22,82,38,38,18,16,124,14,32,46,46,20,40,50,58,54,70,84,
114,2,18,7,1,124,25,95,13,22,22,13,15,11,25,10,31,81,13,9,
56,15,27,13,9,2,27,21,15,69,55,23,25,11,70,89,31,64,53,15,
11,15,18,11,25,14,34,13,13,115,44,42,42,3,47,53,57,85,57,85,
101,83,125,109,99,125,125,125,125,119,91,81,91,123,97,75,77,75,31,69,
79,73,79,119,87,75,125,101,125,125,125,125,125,125,49,45,125,71,77,85,
125,95,97,95,71,81,47,17,111,125,125,71,93,103,9,30,40,46,92,62,
72,18,86,72,94,72,98,80,62,74,43,61,81,97,93,125,125,125,42,98,
90,100,78,86,52,50,30,32,9,30,40,46,92,62,72,18,86,72,94,72,
98,80,62,74,43,61,81,97,93,125,125,125,0,0,0,0}
};

#endif


#endif /* __H264CABACCONTEXT_H__ */
