#!/bin/bash

#Imports

.  ./f_run.sh
.  ./f_check.sh

importFiles



# This script runs a single test case or all test cases
# The tests can be run with ARM simulator or executable binary
# For simulator, the input is ASIC reference data generated by system model

mount_point=/export # this is for versatile
if [ ! -e $mount_point ]; then
    mount_point=/mnt/export # this is for integrator
fi

# Enable this if you want case rerun to write over previous run
# When disabled, cases run earlier are skipped
OVERWRITE_CASE=0

#SET THIS
# HW burst size 0..63
burst=16

# Output file when running all cases
resultfile=results_h264

# Current date
#date=`date +"%d.%m.%y %k:%M"`

# Check parameter
if [ $# -eq 0 ]; then
    echo "Usage: $0 <test_case_number>"
    echo "   or: $0 <all>"
    echo "   or: $0 <first_case> <last_case>"
    exit
fi

nice_bin=""
enc_bin=./h264_testenc
if [ ! -e $enc_bin ]; then
    echo "Executable $enc_bin not found. Compile with 'make'"
    exit
fi

if [ ! -e $test_case_list_dir/test_data_parameter_h264.sh ]; then
    echo "$test_case_list_dir/test_data_parameter_h264.sh not found"
    exit -1
fi

# Encode command
. $test_case_list_dir/encode_h264.sh

test_set() {
    # Test data dir
    let "set_nro=${case_nro}-${case_nro}/5*5"
    case_dir=$test_data_home/case_$case_nro

    # Do nothing if test case is not valid
    if [ ${valid[${set_nro}]} -eq -1 ]; then
        echo "case_$case_nro is not valid."
    else
        if [ ${width[${set_nro}]} -gt $min_width ] && [ $max_width -ge ${width[${set_nro}]} ] ;
        then
            # Invoke new shell
            (
            echo "========================================================="
            echo "Run case $case_nro"

            if [ ! -e $TESTDIR/case_${case_nro} ]
            then
                mkdir $TESTDIR/case_${case_nro}
                chmod 777 $TESTDIR/case_${case_nro}
            else
                if [ $OVERWRITE_CASE -eq 0 ]
                then
                    echo "Case dir exists, don't overwrite."
                    return
                fi
                rm -f $TESTDIR/case_${case_nro}/status
            fi

            rm -f stream.h264

            startTimeCounter $TESTDIR/case_${case_nro}

            # Run encoder
            encode > $TESTDIR/case_${case_nro}/case_${case_nro}.log
            echo "$?" > status

            cat $TESTDIR/case_${case_nro}/case_${case_nro}.log

            endTimeCounter $TESTDIR/case_${case_nro}

            if [ -e stream.h264 ]
            then
                mv -f stream.h264 ${TESTDIR}/case_${case_nro}/case_${case_nro}.h264
                mv -f mv.txt ${TESTDIR}/case_${case_nro}
            else
                # No output stream created, something went wrong
                # Make script run.sh for this testcase
                nice_bin="echo"
                encode > ${TESTDIR}/case_${case_nro}/run_${case_nro}.sh
                chmod 777 ${TESTDIR}/case_${case_nro}/run_${case_nro}.sh
            fi

            if ( [ "$TRACE_SW_REGISTER" == "y" ] ) && [ -e sw_reg.trc ]
            then
                mv -f sw_reg.trc $TESTDIR/case_$case_nro
            fi
            if ( [ "$TRACE_EWL" == "y" ] ) && [ -e ewl.trc ]
            then
                mv -f ewl.trc $TESTDIR/case_$case_nro
            fi

            mv status $TESTDIR/case_${case_nro}/status

            )
        fi
    fi
}

random_case() {
    # Test data dir
    case_dir=$test_data_home/case_$case_nro

    # Do nothing if test case is not valid
    if [ ! -e $test_case_list_dir/run_${case_nro}.sh ]; then
        echo "case_$case_nro is not valid."
    else
        # Invoke new shell
        (
        echo "========================================================="
        echo "Run case $case_nro"

        if [ ! -e $TESTDIR/case_${case_nro} ]
        then
            mkdir $TESTDIR/case_${case_nro}
            chmod 777 $TESTDIR/case_${case_nro}
        else
            if [ $OVERWRITE_CASE -eq 0 ]
            then
                echo "Case dir exists, don't overwrite."
                return
            fi
            rm -f $TESTDIR/case_${case_nro}/status
        fi

        rm -f stream.h264

        # Get the run script with random parameters
        cp $test_case_list_dir/run_${case_nro}.sh $TESTDIR/case_${case_nro}/run.sh
        chmod u+x $TESTDIR/case_${case_nro}/run.sh

        startTimeCounter "case_$case_nro"

        # Run encoder
        $TESTDIR/case_${case_nro}/run.sh > $TESTDIR/case_${case_nro}/case_${case_nro}.log
        echo "$?" > $TESTDIR/case_${case_nro}/status

        endTimeCounter "case_$case_nro"

        cat $TESTDIR/case_${case_nro}/case_${case_nro}.log

        if [ -e stream.h264 ]
        then
            mv -f stream.h264 ${TESTDIR}/case_${case_nro}/case_${case_nro}.h264
            mv -f mv.txt ${TESTDIR}/case_${case_nro}
        fi

        if ( [ "$TRACE_SW_REGISTER" == "y" ] ) && [ -e sw_reg.trc ]
        then
            mv -f sw_reg.trc $TESTDIR/case_$case_nro
        fi
        if ( [ "$TRACE_EWL" == "y" ] ) && [ -e ewl.trc ]
        then
            mv -f ewl.trc $TESTDIR/case_$case_nro
        fi

        )
    fi
}

run_cases() {
    
    echo "Running test cases $first_case..$last_case"
    echo "This will take several minutes"
    echo "Output is stored in $resultfile.log"
    rm -f $resultfile.log
    for ((case_nro=$first_case; case_nro<=$last_case; case_nro++))
    do
        . $test_case_list_dir/test_data_parameter_h264.sh "$case_nro"
        echo -en "\rCase $case_nro\t"
        test_set >> $resultfile.log
    done
    echo -e "\nAll done!"
}

run_case() {

    . $test_case_list_dir/test_data_parameter_h264.sh "$case_nro"
    test_set
}


# Encoder test set.
trigger=-1 # NO Logic analyzer trigger by default
min_width=0;    # No limits for resolution
max_width=4096;

case "$1" in
    all)
    first_case=1000;
    last_case=1999;
    run_cases
    ;;

    size)
    first_case=1000;
    last_case=1999;
    min_width=0;
    max_width=352;
    run_cases
    min_width=352;
    max_width=720;
    run_cases
    min_width=720;
    max_width=4096;
    run_cases
    ;;

    -list)
    echo "Running failed cases from file 'list':"
    list=`cat list`
    echo "$list"
    for case_nro in $list
    do
        echo -en "\rCase $case_nro\t"
        run_case >> $resultfile.log
    done
    ;;

    *)
    if [ $# -eq 3 ]; then trigger=$3; fi
    if [ $# -eq 1 ]; then
        case_nro=$1;
        if [ $1 -lt 5000 ]; then
            run_case;
        else
            random_case;
        fi
    else
        first_case=$1;
        last_case=$2;
        run_cases;
    fi
    ;;
esac


