/*------------------------------------------------------------------------------
--       Copyright (c) 2015-2017, VeriSilicon Inc. All rights reserved        --
--         Copyright (c) 2011-2014, Google Inc. All rights reserved.          --
--         Copyright (c) 2007-2010, Hantro OY. All rights reserved.           --
--                                                                            --
-- This software is confidential and proprietary and may be used only as      --
--   expressly authorized by VeriSilicon in a written licensing agreement.    --
--                                                                            --
--         This entire notice must be reproduced on all copies                --
--                       and may not be removed.                              --
--                                                                            --
--------------------------------------------------------------------------------
-- Redistribution and use in source and binary forms, with or without         --
-- modification, are permitted provided that the following conditions are met:--
--   * Redistributions of source code must retain the above copyright notice, --
--       this list of conditions and the following disclaimer.                --
--   * Redistributions in binary form must reproduce the above copyright      --
--       notice, this list of conditions and the following disclaimer in the  --
--       documentation and/or other materials provided with the distribution. --
--   * Neither the names of Google nor the names of its contributors may be   --
--       used to endorse or promote products derived from this software       --
--       without specific prior written permission.                           --
--------------------------------------------------------------------------------
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"--
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  --
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE --
-- ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE  --
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR        --
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF       --
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS   --
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN    --
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)    --
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE --
-- POSSIBILITY OF SUCH DAMAGE.                                                --
--------------------------------------------------------------------------------
--                                                                            --
--  Abstract : Register table auto generated.                                 --
--                                                                            --
------------------------------------------------------------------------------*/

/* IRQ Source Map. */
    H1REG(HEncIRQRfcBufOverflow, 0x4, 0x00000800, 11, 1, RW, "IRQ Compressed reference buffer overflow status bit."),
    H1REG(HEncIRQLowLatency, 0x4, 0x00000400, 10, 0, RW, "IRQ line buffer status bit. One line buffer reading has been done."),


/* HW synthesis config register 2, read-only */
    H1REG(HEncHWAddress64Bits, 0x4a0, 0x80000000, 31, 0, RO, "HW Address bit width. 0=32 bits. 1=64 bits."),
    H1REG(HEncHWDnfSupport, 0x4a0, 0x40000000, 30, 0, RO, "HW Denoise Support."),
    H1REG(HEncHWRfcSupport, 0x4a0, 0x30000000, 28, 0, RO, "HW Reference Compression Support for Luma and Chroma."),
    H1REG(HEncHWQEnhanceSupport, 0x4a0, 0x08000000, 27, 0, RO, "HW Enhancement for Quality."),
    H1REG(HEncHWInstantSupport, 0x4a0, 0x04000000, 26, 0, RO, "HW Low Latency Control."),
    H1REG(HEncHWSvctSupport, 0x4a0, 0x02000000, 25, 0, RO, "HW SVCT Support."),
    H1REG(HEncHWAxiIdInSupport, 0x4a0, 0x01000000, 24, 0, RO, "HW AXI Read ID for Input Support."),
    H1REG(HEncHWWriteOneClrIrqSupport, 0x4a0, 0x00800000, 23, 0, RO, "HW IRQ is clear in write-one way."),
    H1REG(HEncHWInputLoopbackSupport, 0x4a0, 0x00400000, 22, 0, RO, "HW Input Loopback Support. not support now"),

/* HEncMBRC Control */
    H1REG(HEncMBRCQpDeltaRange , 0x4a4, 0x07800000, 23, 0, RW, "Segment 4: Intra 16x16 mode 2 penalty"),
    H1REG(HEncMBRcSliceQpOffset , 0x4a4, 0x007e0000, 17, 0, RW, "Segment 4: Intra 16x16 mode 1 penalty"),

/* Segment 4 */
    H1REG(HEncSeg4I4PrevModeFavor , 0x4a8, 0xff000000, 24, 0, RW, "Segment 4: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg4I16Favor        , 0x4a8, 0x00ffff00, 8, 0, RW, "Segment 4: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg4GoldenPenalty   , 0x4a8, 0x000000ff, 0, 0, RW, "Segment 4: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg4SkipPenalty     , 0x4ac, 0xff000000, 24, 0, RW, "Segment 4: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg4InterFavor      , 0x4ac, 0x00ffff00, 8, 0, RW, "Segment 4: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg4SplitPenalty16x8, 0x4b0, 0x3ff00000, 20, 0, RW, "Segment 4: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg4SplitPenalty8x8 , 0x4b0, 0x000ffc00, 10, 0, RW, "Segment 4: Penalty for using 8x8 MV."),
    H1REG(HEncSeg4SplitPenalty8x4 , 0x4b0, 0x000003ff, 0, 0, RW, "Segment 4: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg4DMVPenaltyQp    , 0x4b4, 0x3ff00000, 20, 0, RW, "Segment 4: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg4SplitPenalty4x4 , 0x4b4, 0x000001ff, 0, 0, RW, "Segment 4: Penalty for using 4x4 MV."),

/* Segment 5 */
    H1REG(HEncSeg5I4PrevModeFavor , 0x4b8, 0xff000000, 24, 0, RW, "Segment 5: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg5I16Favor        , 0x4b8, 0x00ffff00, 8, 0, RW, "Segment 5: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg5GoldenPenalty   , 0x4b8, 0x000000ff, 0, 0, RW, "Segment 5: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg5SkipPenalty     , 0x4bc, 0xff000000, 24, 0, RW, "Segment 5: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg5InterFavor      , 0x4bc, 0x00ffff00, 8, 0, RW, "Segment 5: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg5SplitPenalty16x8, 0x4c0, 0x3ff00000, 20, 0, RW, "Segment 5: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg5SplitPenalty8x8 , 0x4c0, 0x000ffc00, 10, 0, RW, "Segment 5: Penalty for using 8x8 MV."),
    H1REG(HEncSeg5SplitPenalty8x4 , 0x4c0, 0x000003ff, 0, 0, RW, "Segment 5: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg5DMVPenaltyQp    , 0x4c4, 0x3ff00000, 20, 0, RW, "Segment 5: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg5SplitPenalty4x4 , 0x4c4, 0x000001ff, 0, 0, RW, "Segment 5: Penalty for using 4x4 MV."),

/* Segment 6 */
    H1REG(HEncSeg6I4PrevModeFavor , 0x4c8, 0xff000000, 24, 0, RW, "Segment 6: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg6I16Favor        , 0x4c8, 0x00ffff00, 8, 0, RW, "Segment 6: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg6GoldenPenalty   , 0x4c8, 0x000000ff, 0, 0, RW, "Segment 6: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg6SkipPenalty     , 0x4cc, 0xff000000, 24, 0, RW, "Segment 6: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg6InterFavor      , 0x4cc, 0x00ffff00, 8, 0, RW, "Segment 6: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg6SplitPenalty16x8, 0x4d0, 0x3ff00000, 20, 0, RW, "Segment 6: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg6SplitPenalty8x8 , 0x4d0, 0x000ffc00, 10, 0, RW, "Segment 6: Penalty for using 8x8 MV."),
    H1REG(HEncSeg6SplitPenalty8x4 , 0x4d0, 0x000003ff, 0, 0, RW, "Segment 6: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg6DMVPenaltyQp    , 0x4d4, 0x3ff00000, 20, 0, RW, "Segment 6: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg6SplitPenalty4x4 , 0x4d4, 0x000001ff, 0, 0, RW, "Segment 6: Penalty for using 4x4 MV."),

/* Segment 7 */
    H1REG(HEncSeg7I4PrevModeFavor , 0x4d8, 0xff000000, 24, 0, RW, "Segment 7: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg7I16Favor        , 0x4d8, 0x00ffff00, 8, 0, RW, "Segment 7: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg7GoldenPenalty   , 0x4d8, 0x000000ff, 0, 0, RW, "Segment 7: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg7SkipPenalty     , 0x4dc, 0xff000000, 24, 0, RW, "Segment 7: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg7InterFavor      , 0x4dc, 0x00ffff00, 8, 0, RW, "Segment 7: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg7SplitPenalty16x8, 0x4e0, 0x3ff00000, 20, 0, RW, "Segment 7: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg7SplitPenalty8x8 , 0x4e0, 0x000ffc00, 10, 0, RW, "Segment 7: Penalty for using 8x8 MV."),
    H1REG(HEncSeg7SplitPenalty8x4 , 0x4e0, 0x000003ff, 0, 0, RW, "Segment 7: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg7DMVPenaltyQp    , 0x4e4, 0x3ff00000, 20, 0, RW, "Segment 7: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg7SplitPenalty4x4 , 0x4e4, 0x000001ff, 0, 0, RW, "Segment 7: Penalty for using 4x4 MV."),

/* Segment 8 */
    H1REG(HEncSeg8I4PrevModeFavor , 0x4e8, 0xff000000, 24, 0, RW, "Segment 8: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg8I16Favor        , 0x4e8, 0x00ffff00, 8, 0, RW, "Segment 8: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg8GoldenPenalty   , 0x4e8, 0x000000ff, 0, 0, RW, "Segment 8: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg8SkipPenalty     , 0x4ec, 0xff000000, 24, 0, RW, "Segment 8: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg8InterFavor      , 0x4ec, 0x00ffff00, 8, 0, RW, "Segment 8: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg8SplitPenalty16x8, 0x4f0, 0x3ff00000, 20, 0, RW, "Segment 8: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg8SplitPenalty8x8 , 0x4f0, 0x000ffc00, 10, 0, RW, "Segment 8: Penalty for using 8x8 MV."),
    H1REG(HEncSeg8SplitPenalty8x4 , 0x4f0, 0x000003ff, 0, 0, RW, "Segment 8: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg8DMVPenaltyQp    , 0x4f4, 0x3ff00000, 20, 0, RW, "Segment 8: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg8SplitPenalty4x4 , 0x4f4, 0x000001ff, 0, 0, RW, "Segment 8: Penalty for using 4x4 MV."),

/* Segment 9 */
    H1REG(HEncSeg9I4PrevModeFavor , 0x4f8, 0xff000000, 24, 0, RW, "Segment 9: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg9I16Favor        , 0x4f8, 0x00ffff00, 8, 0, RW, "Segment 9: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg9GoldenPenalty   , 0x4f8, 0x000000ff, 0, 0, RW, "Segment 9: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg9SkipPenalty     , 0x4fc, 0xff000000, 24, 0, RW, "Segment 9: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg9InterFavor      , 0x4fc, 0x00ffff00, 8, 0, RW, "Segment 9: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg9SplitPenalty16x8, 0x500, 0x3ff00000, 20, 0, RW, "Segment 9: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg9SplitPenalty8x8 , 0x500, 0x000ffc00, 10, 0, RW, "Segment 9: Penalty for using 8x8 MV."),
    H1REG(HEncSeg9SplitPenalty8x4 , 0x500, 0x000003ff, 0, 0, RW, "Segment 9: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg9DMVPenaltyQp    , 0x504, 0x3ff00000, 20, 0, RW, "Segment 9: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg9SplitPenalty4x4 , 0x504, 0x000001ff, 0, 0, RW, "Segment 9: Penalty for using 4x4 MV."),

/* Segment 10 */
    H1REG(HEncSeg10I4PrevModeFavor , 0x508, 0xff000000, 24, 0, RW, "Segment 10: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg10I16Favor        , 0x508, 0x00ffff00, 8, 0, RW, "Segment 10: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg10GoldenPenalty   , 0x508, 0x000000ff, 0, 0, RW, "Segment 10: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg10SkipPenalty     , 0x50c, 0xff000000, 24, 0, RW, "Segment 10: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg10InterFavor      , 0x50c, 0x00ffff00, 8, 0, RW, "Segment 10: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg10SplitPenalty16x8, 0x510, 0x3ff00000, 20, 0, RW, "Segment 10: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg10SplitPenalty8x8 , 0x510, 0x000ffc00, 10, 0, RW, "Segment 10: Penalty for using 8x8 MV."),
    H1REG(HEncSeg10SplitPenalty8x4 , 0x510, 0x000003ff, 0, 0, RW, "Segment 10: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg10DMVPenaltyQp    , 0x514, 0x3ff00000, 20, 0, RW, "Segment 10: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg10SplitPenalty4x4 , 0x514, 0x000001ff, 0, 0, RW, "Segment 10: Penalty for using 4x4 MV."),

/* Segment 11 */
    H1REG(HEncSeg11I4PrevModeFavor , 0x518, 0xff000000, 24, 0, RW, "Segment 11: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg11I16Favor        , 0x518, 0x00ffff00, 8, 0, RW, "Segment 11: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg11GoldenPenalty   , 0x518, 0x000000ff, 0, 0, RW, "Segment 11: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg11SkipPenalty     , 0x51c, 0xff000000, 24, 0, RW, "Segment 11: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg11InterFavor      , 0x51c, 0x00ffff00, 8, 0, RW, "Segment 11: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg11SplitPenalty16x8, 0x520, 0x3ff00000, 20, 0, RW, "Segment 11: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg11SplitPenalty8x8 , 0x520, 0x000ffc00, 10, 0, RW, "Segment 11: Penalty for using 8x8 MV."),
    H1REG(HEncSeg11SplitPenalty8x4 , 0x520, 0x000003ff, 0, 0, RW, "Segment 11: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg11DMVPenaltyQp    , 0x524, 0x3ff00000, 20, 0, RW, "Segment 11: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg11SplitPenalty4x4 , 0x524, 0x000001ff, 0, 0, RW, "Segment 11: Penalty for using 4x4 MV."),

/* Segment 12 */
    H1REG(HEncSeg12I4PrevModeFavor , 0x528, 0xff000000, 24, 0, RW, "Segment 12: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg12I16Favor        , 0x528, 0x00ffff00, 8, 0, RW, "Segment 12: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg12GoldenPenalty   , 0x528, 0x000000ff, 0, 0, RW, "Segment 12: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg12SkipPenalty     , 0x52c, 0xff000000, 24, 0, RW, "Segment 12: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg12InterFavor      , 0x52c, 0x00ffff00, 8, 0, RW, "Segment 12: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg12SplitPenalty16x8, 0x530, 0x3ff00000, 20, 0, RW, "Segment 12: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg12SplitPenalty8x8 , 0x530, 0x000ffc00, 10, 0, RW, "Segment 12: Penalty for using 8x8 MV."),
    H1REG(HEncSeg12SplitPenalty8x4 , 0x530, 0x000003ff, 0, 0, RW, "Segment 12: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg12DMVPenaltyQp    , 0x534, 0x3ff00000, 20, 0, RW, "Segment 12: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg12SplitPenalty4x4 , 0x534, 0x000001ff, 0, 0, RW, "Segment 12: Penalty for using 4x4 MV."),

/* Segment 13 */
    H1REG(HEncSeg13I4PrevModeFavor , 0x538, 0xff000000, 24, 0, RW, "Segment 13: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg13I16Favor        , 0x538, 0x00ffff00, 8, 0, RW, "Segment 13: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg13GoldenPenalty   , 0x538, 0x000000ff, 0, 0, RW, "Segment 13: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg13SkipPenalty     , 0x53c, 0xff000000, 24, 0, RW, "Segment 13: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg13InterFavor      , 0x53c, 0x00ffff00, 8, 0, RW, "Segment 13: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg13SplitPenalty16x8, 0x540, 0x3ff00000, 20, 0, RW, "Segment 13: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg13SplitPenalty8x8 , 0x540, 0x000ffc00, 10, 0, RW, "Segment 13: Penalty for using 8x8 MV."),
    H1REG(HEncSeg13SplitPenalty8x4 , 0x540, 0x000003ff, 0, 0, RW, "Segment 13: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg13DMVPenaltyQp    , 0x544, 0x3ff00000, 20, 0, RW, "Segment 13: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg13SplitPenalty4x4 , 0x544, 0x000001ff, 0, 0, RW, "Segment 13: Penalty for using 4x4 MV."),

/* Segment 14 */
    H1REG(HEncSeg14I4PrevModeFavor , 0x548, 0xff000000, 24, 0, RW, "Segment 14: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg14I16Favor        , 0x548, 0x00ffff00, 8, 0, RW, "Segment 14: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg14GoldenPenalty   , 0x548, 0x000000ff, 0, 0, RW, "Segment 14: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg14SkipPenalty     , 0x54c, 0xff000000, 24, 0, RW, "Segment 14: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg14InterFavor      , 0x54c, 0x00ffff00, 8, 0, RW, "Segment 14: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg14SplitPenalty16x8, 0x550, 0x3ff00000, 20, 0, RW, "Segment 14: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg14SplitPenalty8x8 , 0x550, 0x000ffc00, 10, 0, RW, "Segment 14: Penalty for using 8x8 MV."),
    H1REG(HEncSeg14SplitPenalty8x4 , 0x550, 0x000003ff, 0, 0, RW, "Segment 14: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg14DMVPenaltyQp    , 0x554, 0x3ff00000, 20, 0, RW, "Segment 14: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg14SplitPenalty4x4 , 0x554, 0x000001ff, 0, 0, RW, "Segment 14: Penalty for using 4x4 MV."),

/* Segment 15 */
    H1REG(HEncSeg15I4PrevModeFavor , 0x558, 0xff000000, 24, 0, RW, "Segment 15: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg15I16Favor        , 0x558, 0x00ffff00, 8, 0, RW, "Segment 15: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg15GoldenPenalty   , 0x558, 0x000000ff, 0, 0, RW, "Segment 15: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg15SkipPenalty     , 0x55c, 0xff000000, 24, 0, RW, "Segment 15: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg15InterFavor      , 0x55c, 0x00ffff00, 8, 0, RW, "Segment 15: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg15SplitPenalty16x8, 0x560, 0x3ff00000, 20, 0, RW, "Segment 15: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg15SplitPenalty8x8 , 0x560, 0x000ffc00, 10, 0, RW, "Segment 15: Penalty for using 8x8 MV."),
    H1REG(HEncSeg15SplitPenalty8x4 , 0x560, 0x000003ff, 0, 0, RW, "Segment 15: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg15DMVPenaltyQp    , 0x564, 0x3ff00000, 20, 0, RW, "Segment 15: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg15SplitPenalty4x4 , 0x564, 0x000001ff, 0, 0, RW, "Segment 15: Penalty for using 4x4 MV."),

/* Segment 16 */
    H1REG(HEncSeg16I4PrevModeFavor , 0x568, 0xff000000, 24, 0, RW, "Segment 16: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg16I16Favor        , 0x568, 0x00ffff00, 8, 0, RW, "Segment 16: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg16GoldenPenalty   , 0x568, 0x000000ff, 0, 0, RW, "Segment 16: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg16SkipPenalty     , 0x56c, 0xff000000, 24, 0, RW, "Segment 16: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg16InterFavor      , 0x56c, 0x00ffff00, 8, 0, RW, "Segment 16: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg16SplitPenalty16x8, 0x570, 0x3ff00000, 20, 0, RW, "Segment 16: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg16SplitPenalty8x8 , 0x570, 0x000ffc00, 10, 0, RW, "Segment 16: Penalty for using 8x8 MV."),
    H1REG(HEncSeg16SplitPenalty8x4 , 0x570, 0x000003ff, 0, 0, RW, "Segment 16: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg16DMVPenaltyQp    , 0x574, 0x3ff00000, 20, 0, RW, "Segment 16: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg16SplitPenalty4x4 , 0x574, 0x000001ff, 0, 0, RW, "Segment 16: Penalty for using 4x4 MV."),

/* Segment 17 */
    H1REG(HEncSeg17I4PrevModeFavor , 0x578, 0xff000000, 24, 0, RW, "Segment 17: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg17I16Favor        , 0x578, 0x00ffff00, 8, 0, RW, "Segment 17: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg17GoldenPenalty   , 0x578, 0x000000ff, 0, 0, RW, "Segment 17: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg17SkipPenalty     , 0x57c, 0xff000000, 24, 0, RW, "Segment 17: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg17InterFavor      , 0x57c, 0x00ffff00, 8, 0, RW, "Segment 17: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg17SplitPenalty16x8, 0x580, 0x3ff00000, 20, 0, RW, "Segment 17: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg17SplitPenalty8x8 , 0x580, 0x000ffc00, 10, 0, RW, "Segment 17: Penalty for using 8x8 MV."),
    H1REG(HEncSeg17SplitPenalty8x4 , 0x580, 0x000003ff, 0, 0, RW, "Segment 17: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg17DMVPenaltyQp    , 0x584, 0x3ff00000, 20, 0, RW, "Segment 17: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg17SplitPenalty4x4 , 0x584, 0x000001ff, 0, 0, RW, "Segment 17: Penalty for using 4x4 MV."),

/* Segment 18 */
    H1REG(HEncSeg18I4PrevModeFavor , 0x588, 0xff000000, 24, 0, RW, "Segment 18: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg18I16Favor        , 0x588, 0x00ffff00, 8, 0, RW, "Segment 18: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg18GoldenPenalty   , 0x588, 0x000000ff, 0, 0, RW, "Segment 18: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg18SkipPenalty     , 0x58c, 0xff000000, 24, 0, RW, "Segment 18: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg18InterFavor      , 0x58c, 0x00ffff00, 8, 0, RW, "Segment 18: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg18SplitPenalty16x8, 0x590, 0x3ff00000, 20, 0, RW, "Segment 18: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg18SplitPenalty8x8 , 0x590, 0x000ffc00, 10, 0, RW, "Segment 18: Penalty for using 8x8 MV."),
    H1REG(HEncSeg18SplitPenalty8x4 , 0x590, 0x000003ff, 0, 0, RW, "Segment 18: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg18DMVPenaltyQp    , 0x594, 0x3ff00000, 20, 0, RW, "Segment 18: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg18SplitPenalty4x4 , 0x594, 0x000001ff, 0, 0, RW, "Segment 18: Penalty for using 4x4 MV."),

/* Segment 19 */
    H1REG(HEncSeg19I4PrevModeFavor , 0x598, 0xff000000, 24, 0, RW, "Segment 19: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg19I16Favor        , 0x598, 0x00ffff00, 8, 0, RW, "Segment 19: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg19GoldenPenalty   , 0x598, 0x000000ff, 0, 0, RW, "Segment 19: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg19SkipPenalty     , 0x59c, 0xff000000, 24, 0, RW, "Segment 19: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg19InterFavor      , 0x59c, 0x00ffff00, 8, 0, RW, "Segment 19: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg19SplitPenalty16x8, 0x5a0, 0x3ff00000, 20, 0, RW, "Segment 19: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg19SplitPenalty8x8 , 0x5a0, 0x000ffc00, 10, 0, RW, "Segment 19: Penalty for using 8x8 MV."),
    H1REG(HEncSeg19SplitPenalty8x4 , 0x5a0, 0x000003ff, 0, 0, RW, "Segment 19: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg19DMVPenaltyQp    , 0x5a4, 0x3ff00000, 20, 0, RW, "Segment 19: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg19SplitPenalty4x4 , 0x5a4, 0x000001ff, 0, 0, RW, "Segment 19: Penalty for using 4x4 MV."),

/* Segment 20 */
    H1REG(HEncSeg20I4PrevModeFavor , 0x5a8, 0xff000000, 24, 0, RW, "Segment 20: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg20I16Favor        , 0x5a8, 0x00ffff00, 8, 0, RW, "Segment 20: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg20GoldenPenalty   , 0x5a8, 0x000000ff, 0, 0, RW, "Segment 20: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg20SkipPenalty     , 0x5ac, 0xff000000, 24, 0, RW, "Segment 20: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg20InterFavor      , 0x5ac, 0x00ffff00, 8, 0, RW, "Segment 20: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg20SplitPenalty16x8, 0x5b0, 0x3ff00000, 20, 0, RW, "Segment 20: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg20SplitPenalty8x8 , 0x5b0, 0x000ffc00, 10, 0, RW, "Segment 20: Penalty for using 8x8 MV."),
    H1REG(HEncSeg20SplitPenalty8x4 , 0x5b0, 0x000003ff, 0, 0, RW, "Segment 20: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg20DMVPenaltyQp    , 0x5b4, 0x3ff00000, 20, 0, RW, "Segment 20: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg20SplitPenalty4x4 , 0x5b4, 0x000001ff, 0, 0, RW, "Segment 20: Penalty for using 4x4 MV."),

/* Segment 21 */
    H1REG(HEncSeg21I4PrevModeFavor , 0x5b8, 0xff000000, 24, 0, RW, "Segment 21: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg21I16Favor        , 0x5b8, 0x00ffff00, 8, 0, RW, "Segment 21: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg21GoldenPenalty   , 0x5b8, 0x000000ff, 0, 0, RW, "Segment 21: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg21SkipPenalty     , 0x5bc, 0xff000000, 24, 0, RW, "Segment 21: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg21InterFavor      , 0x5bc, 0x00ffff00, 8, 0, RW, "Segment 21: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg21SplitPenalty16x8, 0x5c0, 0x3ff00000, 20, 0, RW, "Segment 21: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg21SplitPenalty8x8 , 0x5c0, 0x000ffc00, 10, 0, RW, "Segment 21: Penalty for using 8x8 MV."),
    H1REG(HEncSeg21SplitPenalty8x4 , 0x5c0, 0x000003ff, 0, 0, RW, "Segment 21: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg21DMVPenaltyQp    , 0x5c4, 0x3ff00000, 20, 0, RW, "Segment 21: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg21SplitPenalty4x4 , 0x5c4, 0x000001ff, 0, 0, RW, "Segment 21: Penalty for using 4x4 MV."),

/* Segment 22 */
    H1REG(HEncSeg22I4PrevModeFavor , 0x5c8, 0xff000000, 24, 0, RW, "Segment 22: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg22I16Favor        , 0x5c8, 0x00ffff00, 8, 0, RW, "Segment 22: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg22GoldenPenalty   , 0x5c8, 0x000000ff, 0, 0, RW, "Segment 22: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg22SkipPenalty     , 0x5cc, 0xff000000, 24, 0, RW, "Segment 22: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg22InterFavor      , 0x5cc, 0x00ffff00, 8, 0, RW, "Segment 22: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg22SplitPenalty16x8, 0x5d0, 0x3ff00000, 20, 0, RW, "Segment 22: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg22SplitPenalty8x8 , 0x5d0, 0x000ffc00, 10, 0, RW, "Segment 22: Penalty for using 8x8 MV."),
    H1REG(HEncSeg22SplitPenalty8x4 , 0x5d0, 0x000003ff, 0, 0, RW, "Segment 22: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg22DMVPenaltyQp    , 0x5d4, 0x3ff00000, 20, 0, RW, "Segment 22: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg22SplitPenalty4x4 , 0x5d4, 0x000001ff, 0, 0, RW, "Segment 22: Penalty for using 4x4 MV."),

/* Segment 23 */
    H1REG(HEncSeg23I4PrevModeFavor , 0x5d8, 0xff000000, 24, 0, RW, "Segment 23: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg23I16Favor        , 0x5d8, 0x00ffff00, 8, 0, RW, "Segment 23: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg23GoldenPenalty   , 0x5d8, 0x000000ff, 0, 0, RW, "Segment 23: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg23SkipPenalty     , 0x5dc, 0xff000000, 24, 0, RW, "Segment 23: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg23InterFavor      , 0x5dc, 0x00ffff00, 8, 0, RW, "Segment 23: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg23SplitPenalty16x8, 0x5e0, 0x3ff00000, 20, 0, RW, "Segment 23: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg23SplitPenalty8x8 , 0x5e0, 0x000ffc00, 10, 0, RW, "Segment 23: Penalty for using 8x8 MV."),
    H1REG(HEncSeg23SplitPenalty8x4 , 0x5e0, 0x000003ff, 0, 0, RW, "Segment 23: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg23DMVPenaltyQp    , 0x5e4, 0x3ff00000, 20, 0, RW, "Segment 23: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg23SplitPenalty4x4 , 0x5e4, 0x000001ff, 0, 0, RW, "Segment 23: Penalty for using 4x4 MV."),

/* Segment 24 */
    H1REG(HEncSeg24I4PrevModeFavor , 0x5e8, 0xff000000, 24, 0, RW, "Segment 24: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg24I16Favor        , 0x5e8, 0x00ffff00, 8, 0, RW, "Segment 24: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg24GoldenPenalty   , 0x5e8, 0x000000ff, 0, 0, RW, "Segment 24: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg24SkipPenalty     , 0x5ec, 0xff000000, 24, 0, RW, "Segment 24: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg24InterFavor      , 0x5ec, 0x00ffff00, 8, 0, RW, "Segment 24: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg24SplitPenalty16x8, 0x5f0, 0x3ff00000, 20, 0, RW, "Segment 24: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg24SplitPenalty8x8 , 0x5f0, 0x000ffc00, 10, 0, RW, "Segment 24: Penalty for using 8x8 MV."),
    H1REG(HEncSeg24SplitPenalty8x4 , 0x5f0, 0x000003ff, 0, 0, RW, "Segment 24: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg24DMVPenaltyQp    , 0x5f4, 0x3ff00000, 20, 0, RW, "Segment 24: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg24SplitPenalty4x4 , 0x5f4, 0x000001ff, 0, 0, RW, "Segment 24: Penalty for using 4x4 MV."),

/* Segment 25 */
    H1REG(HEncSeg25I4PrevModeFavor , 0x5f8, 0xff000000, 24, 0, RW, "Segment 25: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg25I16Favor        , 0x5f8, 0x00ffff00, 8, 0, RW, "Segment 25: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg25GoldenPenalty   , 0x5f8, 0x000000ff, 0, 0, RW, "Segment 25: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg25SkipPenalty     , 0x5fc, 0xff000000, 24, 0, RW, "Segment 25: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg25InterFavor      , 0x5fc, 0x00ffff00, 8, 0, RW, "Segment 25: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg25SplitPenalty16x8, 0x600, 0x3ff00000, 20, 0, RW, "Segment 25: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg25SplitPenalty8x8 , 0x600, 0x000ffc00, 10, 0, RW, "Segment 25: Penalty for using 8x8 MV."),
    H1REG(HEncSeg25SplitPenalty8x4 , 0x600, 0x000003ff, 0, 0, RW, "Segment 25: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg25DMVPenaltyQp    , 0x604, 0x3ff00000, 20, 0, RW, "Segment 25: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg25SplitPenalty4x4 , 0x604, 0x000001ff, 0, 0, RW, "Segment 25: Penalty for using 4x4 MV."),

/* Segment 26 */
    H1REG(HEncSeg26I4PrevModeFavor , 0x608, 0xff000000, 24, 0, RW, "Segment 26: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg26I16Favor        , 0x608, 0x00ffff00, 8, 0, RW, "Segment 26: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg26GoldenPenalty   , 0x608, 0x000000ff, 0, 0, RW, "Segment 26: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg26SkipPenalty     , 0x60c, 0xff000000, 24, 0, RW, "Segment 26: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg26InterFavor      , 0x60c, 0x00ffff00, 8, 0, RW, "Segment 26: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg26SplitPenalty16x8, 0x610, 0x3ff00000, 20, 0, RW, "Segment 26: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg26SplitPenalty8x8 , 0x610, 0x000ffc00, 10, 0, RW, "Segment 26: Penalty for using 8x8 MV."),
    H1REG(HEncSeg26SplitPenalty8x4 , 0x610, 0x000003ff, 0, 0, RW, "Segment 26: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg26DMVPenaltyQp    , 0x614, 0x3ff00000, 20, 0, RW, "Segment 26: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg26SplitPenalty4x4 , 0x614, 0x000001ff, 0, 0, RW, "Segment 26: Penalty for using 4x4 MV."),

/* Segment 27 */
    H1REG(HEncSeg27I4PrevModeFavor , 0x618, 0xff000000, 24, 0, RW, "Segment 27: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg27I16Favor        , 0x618, 0x00ffff00, 8, 0, RW, "Segment 27: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg27GoldenPenalty   , 0x618, 0x000000ff, 0, 0, RW, "Segment 27: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg27SkipPenalty     , 0x61c, 0xff000000, 24, 0, RW, "Segment 27: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg27InterFavor      , 0x61c, 0x00ffff00, 8, 0, RW, "Segment 27: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg27SplitPenalty16x8, 0x620, 0x3ff00000, 20, 0, RW, "Segment 27: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg27SplitPenalty8x8 , 0x620, 0x000ffc00, 10, 0, RW, "Segment 27: Penalty for using 8x8 MV."),
    H1REG(HEncSeg27SplitPenalty8x4 , 0x620, 0x000003ff, 0, 0, RW, "Segment 27: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg27DMVPenaltyQp    , 0x624, 0x3ff00000, 20, 0, RW, "Segment 27: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg27SplitPenalty4x4 , 0x624, 0x000001ff, 0, 0, RW, "Segment 27: Penalty for using 4x4 MV."),

/* Segment 28 */
    H1REG(HEncSeg28I4PrevModeFavor , 0x628, 0xff000000, 24, 0, RW, "Segment 28: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg28I16Favor        , 0x628, 0x00ffff00, 8, 0, RW, "Segment 28: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg28GoldenPenalty   , 0x628, 0x000000ff, 0, 0, RW, "Segment 28: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg28SkipPenalty     , 0x62c, 0xff000000, 24, 0, RW, "Segment 28: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg28InterFavor      , 0x62c, 0x00ffff00, 8, 0, RW, "Segment 28: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg28SplitPenalty16x8, 0x630, 0x3ff00000, 20, 0, RW, "Segment 28: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg28SplitPenalty8x8 , 0x630, 0x000ffc00, 10, 0, RW, "Segment 28: Penalty for using 8x8 MV."),
    H1REG(HEncSeg28SplitPenalty8x4 , 0x630, 0x000003ff, 0, 0, RW, "Segment 28: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg28DMVPenaltyQp    , 0x634, 0x3ff00000, 20, 0, RW, "Segment 28: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg28SplitPenalty4x4 , 0x634, 0x000001ff, 0, 0, RW, "Segment 28: Penalty for using 4x4 MV."),

/* Segment 29 */
    H1REG(HEncSeg29I4PrevModeFavor , 0x638, 0xff000000, 24, 0, RW, "Segment 29: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg29I16Favor        , 0x638, 0x00ffff00, 8, 0, RW, "Segment 29: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg29GoldenPenalty   , 0x638, 0x000000ff, 0, 0, RW, "Segment 29: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg29SkipPenalty     , 0x63c, 0xff000000, 24, 0, RW, "Segment 29: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg29InterFavor      , 0x63c, 0x00ffff00, 8, 0, RW, "Segment 29: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg29SplitPenalty16x8, 0x640, 0x3ff00000, 20, 0, RW, "Segment 29: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg29SplitPenalty8x8 , 0x640, 0x000ffc00, 10, 0, RW, "Segment 29: Penalty for using 8x8 MV."),
    H1REG(HEncSeg29SplitPenalty8x4 , 0x640, 0x000003ff, 0, 0, RW, "Segment 29: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg29DMVPenaltyQp    , 0x644, 0x3ff00000, 20, 0, RW, "Segment 29: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg29SplitPenalty4x4 , 0x644, 0x000001ff, 0, 0, RW, "Segment 29: Penalty for using 4x4 MV."),

/* Segment 30 */
    H1REG(HEncSeg30I4PrevModeFavor , 0x648, 0xff000000, 24, 0, RW, "Segment 30: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg30I16Favor        , 0x648, 0x00ffff00, 8, 0, RW, "Segment 30: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg30GoldenPenalty   , 0x648, 0x000000ff, 0, 0, RW, "Segment 30: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg30SkipPenalty     , 0x64c, 0xff000000, 24, 0, RW, "Segment 30: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg30InterFavor      , 0x64c, 0x00ffff00, 8, 0, RW, "Segment 30: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg30SplitPenalty16x8, 0x650, 0x3ff00000, 20, 0, RW, "Segment 30: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg30SplitPenalty8x8 , 0x650, 0x000ffc00, 10, 0, RW, "Segment 30: Penalty for using 8x8 MV."),
    H1REG(HEncSeg30SplitPenalty8x4 , 0x650, 0x000003ff, 0, 0, RW, "Segment 30: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg30DMVPenaltyQp    , 0x654, 0x3ff00000, 20, 0, RW, "Segment 30: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg30SplitPenalty4x4 , 0x654, 0x000001ff, 0, 0, RW, "Segment 30: Penalty for using 4x4 MV."),

/* Segment 31 */
    H1REG(HEncSeg31I4PrevModeFavor , 0x658, 0xff000000, 24, 0, RW, "Segment 31: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg31I16Favor        , 0x658, 0x00ffff00, 8, 0, RW, "Segment 31: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg31GoldenPenalty   , 0x658, 0x000000ff, 0, 0, RW, "Segment 31: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg31SkipPenalty     , 0x65c, 0xff000000, 24, 0, RW, "Segment 31: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg31InterFavor      , 0x65c, 0x00ffff00, 8, 0, RW, "Segment 31: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg31SplitPenalty16x8, 0x660, 0x3ff00000, 20, 0, RW, "Segment 31: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg31SplitPenalty8x8 , 0x660, 0x000ffc00, 10, 0, RW, "Segment 31: Penalty for using 8x8 MV."),
    H1REG(HEncSeg31SplitPenalty8x4 , 0x660, 0x000003ff, 0, 0, RW, "Segment 31: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg31DMVPenaltyQp    , 0x664, 0x3ff00000, 20, 0, RW, "Segment 31: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg31SplitPenalty4x4 , 0x664, 0x000001ff, 0, 0, RW, "Segment 31: Penalty for using 4x4 MV."),

/* MBRC Control registers */
    H1REG(HEncMBRCQpFrac            , 0x668, 0xffff0000, 16, 0, RW, "fractional part of frame qp. .16 format"),
    H1REG(HEncMBComplexityOffset    , 0x668, 0x00000f80, 7, 0, RW, "offset of MB complexity"),
    H1REG(HEncMBRCEnable            , 0x668, 0x00000003, 0, 0, RW, "MB RC Enable 0 = disable 1 = enable"),
    H1REG(HEncMBQpDeltaGain         , 0x66c, 0x0000ffff, 0, 0, RW, "gain of MB qp delta. 8.8 format"),

/* HEncMBComplexity */
    H1REG(HEncMBComplexityAverage   , 0x670, 0xffffffff, 0, 0, RW, "average of MB complexity"),

/* Reference Frame Compression */
    H1REG(HEncRfcLumBufLimit      , 0x674, 0xfffff800, 11, 1, RW, "Limit of luma RFC buffer in unit of 64-bit. 0 indicating no limit. Send an IRQ if overflow."),
    H1REG(HEncRfcIntEn            , 0x674, 0x00000008, 3, 1, RW, "RFC overflow IRQ Enable. 0=Disable. 1=Enable"),
    H1REG(HEncRfcLumDiscreteMode  , 0x674, 0x00000004, 2, 0, RW, "Reference Compression in discrete storage mode. 0=OFF. 1=ON"),
    H1REG(HEncRefChrCompress      , 0x674, 0x00000002, 1, 0, RW, "Reference Frame Chroma Compression. 0=OFF. 1=ON"),
    H1REG(HEncRefLumCompress      , 0x674, 0x00000001, 0, 0, RW, "Reference Frame Luma Compression. 0=OFF. 1=ON"),
    H1REG(HEncBaseRefLumTbl       , 0x678, 0xffffffff, 0, 0, RW, "Base address for reference luma compression table"),
    H1REG(HEncBaseRefChrTbl       , 0x67c, 0xffffffff, 0, 0, RW, "Base address for reference chroma compression table"),
    H1REG(HEncBaseRecLumTbl       , 0x680, 0xffffffff, 0, 0, RW, "Base address for reconstructed luma compression table"),
    H1REG(HEncBaseRecChrTbl       , 0x684, 0xffffffff, 0, 0, RW, "Base address for reconstructed chroma compression table"),
    H1REG(HEncBaseRefLumTbl2      , 0x688, 0xffffffff, 0, 0, RW, "Base address for second reference luma compression table"),
    H1REG(HEncBaseRefChrTbl2      , 0x68c, 0xffffffff, 0, 0, RW, "Base address for second reference chroma compression table"),
    H1REG(HEncRfcChrBufLimit      , 0x690, 0xfffff000, 12, 1, RW, "Limit of chroma RFC buffer in unit of 64-bit. 0 indicating no limit. Send an IRQ if overflow."),

/* Reference Management Commands */
    H1REG(HEncRefReorderFlag       , 0x694, 0x80000000, 31, 1, RW, "Modification Flag of Pic Nums."),
    H1REG(HEncRefReorderDiffPicNum, 0x694, 0x7c000000, 26, 1, RW, "Modification Absolute Diff Pic Nums."),

/* AXI Read ID for Input */
    H1REG(HEncAXIReadIDInC0, 0x698, 0xff000000, 24, 1, RW, "AXI Read ID for Input Channel 0."),
    H1REG(HEncAXIReadIDInC1, 0x698, 0x00ff0000, 16, 1, RW, "AXI Read ID for Input Channel 1."),
    H1REG(HEncAXIReadIDInC2, 0x698, 0x0000ff00, 8, 1, RW, "AXI Read ID for Input Channel 2."),
    H1REG(HEncAXIReadIDEnable, 0x698, 0x00000001, 0, 1, RW, "Enable AXI Read ID and different burst."),

/* MSB for 64bit address access. */
    H1REG(HEncBaseRefLumTbl_MSB, 0x69c, 0xffffffff, 0, 0, RW, "Base address MSB for reference luma compression table."),
    H1REG(HEncBaseRefChrTbl_MSB, 0x6a0, 0xffffffff, 0, 0, RW, "Base address MSB for reference chroma compression table"),
    H1REG(HEncBaseRecLumTbl_MSB, 0x6a4, 0xffffffff, 0, 0, RW, "Base address MSB for reconstructed luma compression table"),
    H1REG(HEncBaseRecChrTbl_MSB, 0x6a8, 0xffffffff, 0, 0, RW, "Base address for reconstructed chroma compression table"),
    H1REG(HEncBaseRefLumTbl2_MSB, 0x6ac, 0xffffffff, 0, 0, RW, "Base address MSB for second reference luma compression table"),
    H1REG(HEncBaseRefChrTbl2_MSB, 0x6b0, 0xffffffff, 0, 0, RW, "Base address MSB for second reference chroma compression table"),
    H1REG(HEncBaseStream_MSB, 0x6b4, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for output stream data"),
    H1REG(HEncBaseControl_MSB, 0x6b8, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for output control data"),
    H1REG(HEncBaseRefLum_MSB, 0x6bc, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for reference luma"),
    H1REG(HEncBaseRefChr_MSB, 0x6c0, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for reference chroma"),
    H1REG(HEncBaseRecLum_MSB, 0x6c4, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for reconstructed luma"),
    H1REG(HEncBaseRecChr_MSB, 0x6c8, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for reconstructed chroma"),
    H1REG(HEncBaseInLum_MSB, 0x6cc, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for input picture luma"),
    H1REG(HEncBaseInCb_MSB, 0x6d0, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for input picture cb"),
    H1REG(HEncBaseInCr_MSB, 0x6d4, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for input picture cr"),
    H1REG(HEncBaseRefLum2_MSB, 0x6d8, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for second reference luma"),
    H1REG(HEncBaseRefChr2_MSB, 0x6dc, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for second reference chroma"),
    H1REG(HEncH264BaseRefLum2_MSB, 0x6e0, 0xffffffff, 0, 0, RW, "high 32 bits of H264 secondary ref pic base"),
    H1REG(HEncH264BaseRefChr2_MSB, 0x6e4, 0xffffffff, 0, 0, RW, "high 32 bits of H264 secondary ref pic base"),
    H1REG(HEncBaseNextLum_MSB, 0x6e8, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for next pic luminance"),
    H1REG(HEncBaseCabacCtx_MSB, 0x6ec, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for cabac context tables (H264) or probability tables (VP8)"),
    H1REG(HEncBaseMvWrite_MSB, 0x6f0, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for MV output writing"),
    H1REG(HEncBasePartition1_MSB, 0x6f4, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for VP8 1st DCT partition"),
    H1REG(HEncBasePartition2_MSB, 0x6f8, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for VP8 2nd DCT partition"),
    H1REG(HEncBaseVp8ProbCount_MSB, 0x6fc, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for VP8 counters for probability updates"),
    H1REG(HEncBaseVp8SegmentMap_MSB, 0x700, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for VP8 segmentation map. segmentId 2-bits/macroblock"),
    H1REG(HEncBaseScaledOutLum_MSB, 0x704, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for output of down-scaled encoder image in YUYV 4:2:2 format"),
    H1REG(HEncBasePartition3_MSB, 0x708, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for VP8 3rd DCT partition"),
    H1REG(HEncBasePartition4_MSB, 0x70c, 0xffffffff, 0, 0, RW, "high 32 bits of Base address for VP8 4th DCT partition"),

/* Denoise Filter Control. */
    H1REG(HEncDnfEnable, 0x710, 0x80000000, 31, 0, RW, "Enable/disable the de-noise function"),
    H1REG(HEncDnfStregth, 0x710, 0x07ff0000, 16, 0, RW, "Denoise filter strength"),
    H1REG(HEncDnfMbNum, 0x710, 0x0000ffff, 0, 0, RW, "Number of Noisy MB"),
    H1REG(HEncDnfNoiseMax, 0x714, 0x0000ffff, 0, 0, RW, "Max noise level"),
    H1REG(HEncDnfNoiseLevelInvC, 0x718, 0x0fff0000, 16, 0, RW, "Noise level inverted for chroma"),
    H1REG(HEncDnfNoiseLevelInvY, 0x718, 0x00000fff, 0, 0, RW, "Noise level inverted for luma"),
    H1REG(HEncDnfNoisePred, 0x71c, 0xffffffff, 0, 0, RW, "calculated sigma of coding frame"),
    H1REG(HEncDnfThresholdPred, 0x720, 0xffffffff, 0, 0, RW, "noise sigma for current frame"),

/* Denoise Filter Parameters. */
    H1REG(HEncDnfParaS1_0, 0x724, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 1, No.0."),
    H1REG(HEncDnfParaS1_1, 0x724, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 1, No.1."),
    H1REG(HEncDnfParaS1_2, 0x724, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 1, No.2."),
    H1REG(HEncDnfParaS1_3, 0x724, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 1, No.3."),
    H1REG(HEncDnfParaS1_4, 0x728, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 1, No.4."),
    H1REG(HEncDnfParaS1_5, 0x728, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 1, No.5."),
    H1REG(HEncDnfParaS1_6, 0x728, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 1, No.6."),
    H1REG(HEncDnfParaS1_7, 0x728, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 1, No.7."),
    H1REG(HEncDnfParaS1_8, 0x72c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 1, No.8."),
    H1REG(HEncDnfParaS1_9, 0x72c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 1, No.9."),
    H1REG(HEncDnfParaS1_10, 0x72c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 1, No.10."),
    H1REG(HEncDnfParaS1_11, 0x72c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 1, No.11."),
    H1REG(HEncDnfParaS1_12, 0x730, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 1, No.12."),
    H1REG(HEncDnfParaS1_13, 0x730, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 1, No.13."),
    H1REG(HEncDnfParaS1_14, 0x730, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 1, No.14."),
    H1REG(HEncDnfParaS1_15, 0x730, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 1, No.15."),
    H1REG(HEncDnfParaS2_0, 0x734, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 2, No.0."),
    H1REG(HEncDnfParaS2_1, 0x734, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 2, No.1."),
    H1REG(HEncDnfParaS2_2, 0x734, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 2, No.2."),
    H1REG(HEncDnfParaS2_3, 0x734, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 2, No.3."),
    H1REG(HEncDnfParaS2_4, 0x738, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 2, No.4."),
    H1REG(HEncDnfParaS2_5, 0x738, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 2, No.5."),
    H1REG(HEncDnfParaS2_6, 0x738, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 2, No.6."),
    H1REG(HEncDnfParaS2_7, 0x738, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 2, No.7."),
    H1REG(HEncDnfParaS2_8, 0x73c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 2, No.8."),
    H1REG(HEncDnfParaS2_9, 0x73c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 2, No.9."),
    H1REG(HEncDnfParaS2_10, 0x73c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 2, No.10."),
    H1REG(HEncDnfParaS2_11, 0x73c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 2, No.11."),
    H1REG(HEncDnfParaS2_12, 0x740, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 2, No.12."),
    H1REG(HEncDnfParaS2_13, 0x740, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 2, No.13."),
    H1REG(HEncDnfParaS2_14, 0x740, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 2, No.14."),
    H1REG(HEncDnfParaS2_15, 0x740, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 2, No.15."),
    H1REG(HEncDnfParaS3_0, 0x744, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.0."),
    H1REG(HEncDnfParaS3_1, 0x744, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.1."),
    H1REG(HEncDnfParaS3_2, 0x744, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.2."),
    H1REG(HEncDnfParaS3_3, 0x744, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.3."),
    H1REG(HEncDnfParaS3_4, 0x748, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.4."),
    H1REG(HEncDnfParaS3_5, 0x748, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.5."),
    H1REG(HEncDnfParaS3_6, 0x748, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.6."),
    H1REG(HEncDnfParaS3_7, 0x748, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.7."),
    H1REG(HEncDnfParaS3_8, 0x74c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.8."),
    H1REG(HEncDnfParaS3_9, 0x74c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.9."),
    H1REG(HEncDnfParaS3_10, 0x74c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.10."),
    H1REG(HEncDnfParaS3_11, 0x74c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.11."),
    H1REG(HEncDnfParaS3_12, 0x750, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.12."),
    H1REG(HEncDnfParaS3_13, 0x750, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.13."),
    H1REG(HEncDnfParaS3_14, 0x750, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.14."),
    H1REG(HEncDnfParaS3_15, 0x750, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.15."),
    H1REG(HEncDnfParaS3_16, 0x754, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.16."),
    H1REG(HEncDnfParaS3_17, 0x754, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.17."),
    H1REG(HEncDnfParaS3_18, 0x754, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.18."),
    H1REG(HEncDnfParaS3_19, 0x754, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.19."),
    H1REG(HEncDnfParaS3_20, 0x758, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.20."),
    H1REG(HEncDnfParaS3_21, 0x758, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.21."),
    H1REG(HEncDnfParaS3_22, 0x758, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.22."),
    H1REG(HEncDnfParaS3_23, 0x758, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.23."),
    H1REG(HEncDnfParaS3_24, 0x75c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.24."),
    H1REG(HEncDnfParaS3_25, 0x75c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.25."),
    H1REG(HEncDnfParaS3_26, 0x75c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.26."),
    H1REG(HEncDnfParaS3_27, 0x75c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.27."),
    H1REG(HEncDnfParaS3_28, 0x760, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.28."),
    H1REG(HEncDnfParaS3_29, 0x760, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.29."),
    H1REG(HEncDnfParaS3_30, 0x760, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.30."),
    H1REG(HEncDnfParaS3_31, 0x760, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.31."),
    H1REG(HEncDnfParaS3_32, 0x764, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.32."),
    H1REG(HEncDnfParaS3_33, 0x764, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.33."),
    H1REG(HEncDnfParaS3_34, 0x764, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.34."),
    H1REG(HEncDnfParaS3_35, 0x764, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.35."),
    H1REG(HEncDnfParaS3_36, 0x768, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.36."),
    H1REG(HEncDnfParaS3_37, 0x768, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.37."),
    H1REG(HEncDnfParaS3_38, 0x768, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.38."),
    H1REG(HEncDnfParaS3_39, 0x768, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.39."),
    H1REG(HEncDnfParaS3_40, 0x76c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.40."),
    H1REG(HEncDnfParaS3_41, 0x76c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.41."),
    H1REG(HEncDnfParaS3_42, 0x76c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.42."),
    H1REG(HEncDnfParaS3_43, 0x76c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.43."),
    H1REG(HEncDnfParaS3_44, 0x770, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.44."),
    H1REG(HEncDnfParaS3_45, 0x770, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.45."),
    H1REG(HEncDnfParaS3_46, 0x770, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.46."),
    H1REG(HEncDnfParaS3_47, 0x770, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.47."),
    H1REG(HEncDnfParaS3_48, 0x774, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.48."),
    H1REG(HEncDnfParaS3_49, 0x774, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.49."),
    H1REG(HEncDnfParaS3_50, 0x774, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.50."),
    H1REG(HEncDnfParaS3_51, 0x774, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.51."),
    H1REG(HEncDnfParaS3_52, 0x778, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.52."),
    H1REG(HEncDnfParaS3_53, 0x778, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.53."),
    H1REG(HEncDnfParaS3_54, 0x778, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.54."),
    H1REG(HEncDnfParaS3_55, 0x778, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.55."),
    H1REG(HEncDnfParaS3_56, 0x77c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.56."),
    H1REG(HEncDnfParaS3_57, 0x77c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.57."),
    H1REG(HEncDnfParaS3_58, 0x77c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.58."),
    H1REG(HEncDnfParaS3_59, 0x77c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.59."),
    H1REG(HEncDnfParaS3_60, 0x780, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 3, No.60."),
    H1REG(HEncDnfParaS3_61, 0x780, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 3, No.61."),
    H1REG(HEncDnfParaS3_62, 0x780, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 3, No.62."),
    H1REG(HEncDnfParaS3_63, 0x780, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 3, No.63."),
    H1REG(HEncDnfParaS4_0, 0x784, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.0."),
    H1REG(HEncDnfParaS4_1, 0x784, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.1."),
    H1REG(HEncDnfParaS4_2, 0x784, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.2."),
    H1REG(HEncDnfParaS4_3, 0x784, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.3."),
    H1REG(HEncDnfParaS4_4, 0x788, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.4."),
    H1REG(HEncDnfParaS4_5, 0x788, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.5."),
    H1REG(HEncDnfParaS4_6, 0x788, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.6."),
    H1REG(HEncDnfParaS4_7, 0x788, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.7."),
    H1REG(HEncDnfParaS4_8, 0x78c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.8."),
    H1REG(HEncDnfParaS4_9, 0x78c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.9."),
    H1REG(HEncDnfParaS4_10, 0x78c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.10."),
    H1REG(HEncDnfParaS4_11, 0x78c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.11."),
    H1REG(HEncDnfParaS4_12, 0x790, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.12."),
    H1REG(HEncDnfParaS4_13, 0x790, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.13."),
    H1REG(HEncDnfParaS4_14, 0x790, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.14."),
    H1REG(HEncDnfParaS4_15, 0x790, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.15."),
    H1REG(HEncDnfParaS4_16, 0x794, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.16."),
    H1REG(HEncDnfParaS4_17, 0x794, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.17."),
    H1REG(HEncDnfParaS4_18, 0x794, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.18."),
    H1REG(HEncDnfParaS4_19, 0x794, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.19."),
    H1REG(HEncDnfParaS4_20, 0x798, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.20."),
    H1REG(HEncDnfParaS4_21, 0x798, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.21."),
    H1REG(HEncDnfParaS4_22, 0x798, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.22."),
    H1REG(HEncDnfParaS4_23, 0x798, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.23."),
    H1REG(HEncDnfParaS4_24, 0x79c, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.24."),
    H1REG(HEncDnfParaS4_25, 0x79c, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.25."),
    H1REG(HEncDnfParaS4_26, 0x79c, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.26."),
    H1REG(HEncDnfParaS4_27, 0x79c, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.27."),
    H1REG(HEncDnfParaS4_28, 0x7a0, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.28."),
    H1REG(HEncDnfParaS4_29, 0x7a0, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.29."),
    H1REG(HEncDnfParaS4_30, 0x7a0, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.30."),
    H1REG(HEncDnfParaS4_31, 0x7a0, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.31."),
    H1REG(HEncDnfParaS4_32, 0x7a4, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.32."),
    H1REG(HEncDnfParaS4_33, 0x7a4, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.33."),
    H1REG(HEncDnfParaS4_34, 0x7a4, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.34."),
    H1REG(HEncDnfParaS4_35, 0x7a4, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.35."),
    H1REG(HEncDnfParaS4_36, 0x7a8, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.36."),
    H1REG(HEncDnfParaS4_37, 0x7a8, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.37."),
    H1REG(HEncDnfParaS4_38, 0x7a8, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.38."),
    H1REG(HEncDnfParaS4_39, 0x7a8, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.39."),
    H1REG(HEncDnfParaS4_40, 0x7ac, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.40."),
    H1REG(HEncDnfParaS4_41, 0x7ac, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.41."),
    H1REG(HEncDnfParaS4_42, 0x7ac, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.42."),
    H1REG(HEncDnfParaS4_43, 0x7ac, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.43."),
    H1REG(HEncDnfParaS4_44, 0x7b0, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.44."),
    H1REG(HEncDnfParaS4_45, 0x7b0, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.45."),
    H1REG(HEncDnfParaS4_46, 0x7b0, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.46."),
    H1REG(HEncDnfParaS4_47, 0x7b0, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.47."),
    H1REG(HEncDnfParaS4_48, 0x7b4, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.48."),
    H1REG(HEncDnfParaS4_49, 0x7b4, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.49."),
    H1REG(HEncDnfParaS4_50, 0x7b4, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.50."),
    H1REG(HEncDnfParaS4_51, 0x7b4, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.51."),
    H1REG(HEncDnfParaS4_52, 0x7b8, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.52."),
    H1REG(HEncDnfParaS4_53, 0x7b8, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.53."),
    H1REG(HEncDnfParaS4_54, 0x7b8, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.54."),
    H1REG(HEncDnfParaS4_55, 0x7b8, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.55."),
    H1REG(HEncDnfParaS4_56, 0x7bc, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.56."),
    H1REG(HEncDnfParaS4_57, 0x7bc, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.57."),
    H1REG(HEncDnfParaS4_58, 0x7bc, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.58."),
    H1REG(HEncDnfParaS4_59, 0x7bc, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.59."),
    H1REG(HEncDnfParaS4_60, 0x7c0, 0x000000ff, 0, 0, WO, "Denoise Filter Parameters Set 4, No.60."),
    H1REG(HEncDnfParaS4_61, 0x7c0, 0x0000ff00, 8, 0, WO, "Denoise Filter Parameters Set 4, No.61."),
    H1REG(HEncDnfParaS4_62, 0x7c0, 0x00ff0000, 16, 0, WO, "Denoise Filter Parameters Set 4, No.62."),
    H1REG(HEncDnfParaS4_63, 0x7c0, 0xff000000, 24, 0, WO, "Denoise Filter Parameters Set 4, No.63."),

/* Low latency and Input Line buffer. */
    H1REG(HEncMbWrPtr, 0x7c4, 0x000001ff, 0, 0, RW, "The number of MB rows that is already filled in the  input buffer"),
    H1REG(HEncMbRdPtr, 0x7c4, 0x0003fe00, 9, 0, RO, "The number of MB rows that is already read out from the input buffer"),
    H1REG(HEncLowLatencyHwSyncMbRows, 0x7c4, 0x07fc0000, 18, 0, RW, "The number of MB rows featched by encoder which will introduce HW shakehand happens."),
    H1REG(HEncLowLatencyEn, 0x7c4, 0x08000000, 27, 1, RW, "Line Buffer Enable"),
    H1REG(HEncInputBufferLoopBackEn, 0x7c4, 0x10000000, 28, 1, RW, "Input Buffer Loop Back Enable. valid only when sw_num_mb_rows_per_sync is smaller than frame size."),
    H1REG(HEncLowLatencyHwIntfEn, 0x7c4, 0x20000000, 29, 1, RW, "Low Latency Hardware Interface Enable. Use hardware handshaking."),
    H1REG(HEncLowLatencyIrqEn, 0x7c4, 0x40000000, 30, 1, RW, "Enable input Buffer underflow interrupt."),

/* Last Fake Register for Register Counting. */
    H1REG(HEncRegisterAmount, 0x7c8, 0xffffffff, 0, 0, RW, "Last Fake Register for Register Counting."),



