/*------------------------------------------------------------------------------
--       Copyright (c) 2015-2017, VeriSilicon Inc. All rights reserved        --
--         Copyright (c) 2011-2014, Google Inc. All rights reserved.          --
--         Copyright (c) 2007-2010, Hantro OY. All rights reserved.           --
--                                                                            --
-- This software is confidential and proprietary and may be used only as      --
--   expressly authorized by VeriSilicon in a written licensing agreement.    --
--                                                                            --
--         This entire notice must be reproduced on all copies                --
--                       and may not be removed.                              --
--                                                                            --
--------------------------------------------------------------------------------
-- Redistribution and use in source and binary forms, with or without         --
-- modification, are permitted provided that the following conditions are met:--
--   * Redistributions of source code must retain the above copyright notice, --
--       this list of conditions and the following disclaimer.                --
--   * Redistributions in binary form must reproduce the above copyright      --
--       notice, this list of conditions and the following disclaimer in the  --
--       documentation and/or other materials provided with the distribution. --
--   * Neither the names of Google nor the names of its contributors may be   --
--       used to endorse or promote products derived from this software       --
--       without specific prior written permission.                           --
--------------------------------------------------------------------------------
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"--
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  --
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE --
-- ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE  --
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR        --
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF       --
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS   --
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN    --
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)    --
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE --
-- POSSIBILITY OF SUCH DAMAGE.                                                --
--------------------------------------------------------------------------------
--                                                                            --
--  Description :  Encoder SW/HW interface register definitions
--
------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------

    Table of contents

    1. Include headers
    2. External compiler flags
    3. Module defines

------------------------------------------------------------------------------*/
#ifndef ENC_SWHWREGISTERS_H
#define ENC_SWHWREGISTERS_H

/*------------------------------------------------------------------------------
    1. Include headers
------------------------------------------------------------------------------*/

#include "basetype.h"

/*------------------------------------------------------------------------------
    2. External compiler flags
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
    3. Module defines
------------------------------------------------------------------------------*/

#define ASIC_ID_BLUEBERRY               0x48311220
#define ASIC_ID_CLOUDBERRY              0x48311480
#define ASIC_ID_DRAGONFLY               0x48312170
#define ASIC_ID_EVERGREEN               0x48313590
#define ASIC_ID_EVERGREEN_PLUS          0x48314470
#define ASIC_ID_FOXTAIL                 0x48314780
#define ASIC_ID_V7BASE                  0x48317000

#define ASIC_INPUT_YUV420PLANAR         0x00
#define ASIC_INPUT_YUV420SEMIPLANAR     0x01
#define ASIC_INPUT_YUYV422INTERLEAVED   0x02
#define ASIC_INPUT_UYVY422INTERLEAVED   0x03
#define ASIC_INPUT_RGB565               0x04
#define ASIC_INPUT_RGB555               0x05
#define ASIC_INPUT_RGB444               0x06
#define ASIC_INPUT_RGB888               0x07
#define ASIC_INPUT_RGB101010            0x08

/* Bytes of external memory for VP8 counters for probability updates,
 * 252 counters for dct coeff probs, 1 for skipped, 1 for intra type and
 * 2 * 11 for mv probs, each counter 2 bytes */
#define ASIC_VP8_PROB_COUNT_SIZE            244*2
#define ASIC_VP8_PROB_COUNT_MODE_OFFSET     220
#define ASIC_VP8_PROB_COUNT_MV_OFFSET       222

/* HW Register field names */
typedef enum {
    HEncProductID,
    HEncProductMajor,
    HEncProductMinor,
    HEncProductBuild,

    HEncIRQFuse,
    HEncIRQSliceReady,
    HEncIRQTimeout,
    HEncIRQBuffer,
    HEncIRQReset,
    HEncIRQBusError,
    HEncIRQFrameReady,
    HEncIRQDisable,
    HEncIRQ,

    HEncAXIWriteID,
    HEncAXIReadID,
    HEncOutputSwap16,
    HEncInputSwap16,
    HEncBurstLength,
    HEncBurstDisable,
    HEncBurstIncr,
    HEncDataDiscard,
    HEncClockGating,
    HEncOutputSwap32,
    HEncInputSwap32,
    HEncOutputSwap8,
    HEncInputSwap8,

    HEncScaleOutputSwap8,
    HEncScaleOutputSwap16,
    HEncScaleOutputSwap32,
    HEncMvOutputSwap8,
    HEncMvOutputSwap16,
    HEncMvOutputSwap32,
    HEncInputReadChunk,
    HEncAXIDualCh,
    HEncTestIrq,

    HEncBaseStream,
    HEncBaseControl,
    HEncBaseRefLum,
    HEncBaseRefChr,
    HEncBaseRecLum,
    HEncBaseRecChr,
    HEncBaseInLum,
    HEncBaseInCb,
    HEncBaseInCr,

    HEncIntTimeout,
    HEncMvWrite,
    HEncNalSizeWrite,
    HEncIntSliceReady,
    HEncWidth,
    HEncHeight,
    HEncRecWriteBuffer,
    HEncRecWriteDisable,
    HEncPictureType,
    HEncEncodingMode,
    HEncEnable,

    HEncChrOffset,
    HEncLumOffset,
    HEncRowLength,
    HEncXFill,
    HEncYFill,
    HEncInputFormat,
    HEncInputRot,

    HEncBaseRefLum2,
    HEncBaseRefChr2,
    HEncPicInitQp,
    HEncSliceAlpha,
    HEncSliceBeta,
    HEncChromaQp,
    HEncIdrPicId,
    HEncConstrIP,
    HEncPPSID,
    HEncIPPrevModeFavor,
    HEncFrameNum,

    HEncDeblocking,
    HEncSliceSize,
    HEncDisableQPMV,
    HEncTransform8x8,
    HEncCabacInitIdc,
    HEncCabacEnable,
    HEncInter4Restrict,
    HEncStreamMode,
    HEncIPIntra16Favor,

    HEncChromaSwap,
    HEncSplitMv,
    HEncDMVPenalty1p,
    HEncDMVPenalty4p,
    HEncDMVPenaltyQp,

    HEncJpegMode,
    HEncJpegSlice,
    HEncJpegRSTInt,
    HEncJpegRST,
    HEncSplitPenalty16x8,
    HEncSplitPenalty8x8,
    HEncSplitPenalty8x4,

    HEncSkipPenalty,
    HEncNumSlicesReady,
    HEncInterFavor,

    HEncStrmHdrRem1,
    HEncStrmHdrRem2,

    HEncStrmBufLimit,

    HEncMadQpDelta,
    HEncMadThreshold,
    HEncQpSum,

    HEncQp,
    HEncMaxQp,
    HEncMinQp,
    HEncCPDist,

    HEncCP1WordTarget,
    HEncCP2WordTarget,
    HEncCP3WordTarget,
    HEncCP4WordTarget,
    HEncCP5WordTarget,
    HEncCP6WordTarget,
    HEncCP7WordTarget,
    HEncCP8WordTarget,
    HEncCP9WordTarget,
    HEncCP10WordTarget,

    HEncCPWordError1,
    HEncCPWordError2,
    HEncCPWordError3,
    HEncCPWordError4,
    HEncCPWordError5,
    HEncCPWordError6,

    HEncCPDeltaQp1,
    HEncCPDeltaQp2,
    HEncCPDeltaQp3,
    HEncCPDeltaQp4,
    HEncCPDeltaQp5,
    HEncCPDeltaQp6,
    HEncCPDeltaQp7,

    HEncH264BaseRefLum2,
    HEncH264BaseRefChr2,
    HEncH264MvRefIdx,
    HEncH264MarkCurrentLongTerm,
    HEncH264Ref2Enable,
    HEncH264LongTermPenalty,

    HEncVp8Y1QuantDc,
    HEncVp8Y1ZbinDc,
    HEncVp8Y1RoundDc,
    HEncVp8Y1QuantAc,
    HEncVp8Y1ZbinAc,
    HEncVp8Y1RoundAc,
    HEncVp8Y2QuantDc,
    HEncVp8Y2ZbinDc,
    HEncVp8Y2RoundDc,
    HEncVp8Y2QuantAc,
    HEncVp8Y2ZbinAc,
    HEncVp8Y2RoundAc,
    HEncVp8ChQuantDc,
    HEncVp8ChZbinDc,
    HEncVp8ChRoundDc,
    HEncVp8ChQuantAc,
    HEncVp8ChZbinAc,
    HEncVp8ChRoundAc,

    HEncVp8Y1DequantDc,
    HEncVp8Y1DequantAc,
    HEncVp8Y2DequantDc,
    HEncVp8MvRefIdx,
    HEncVp8Y2DequantAc,
    HEncVp8ChDequantDc,
    HEncVp8ChDequantAc,
    HEncVp8MvRefIdx2,
    HEncVp8Ref2Enable,
    HEncVp8SegmentEnable,
    HEncVp8SegmentMapUpdate,
    HEncVp8DeadzoneEnable,
    HEncVp8BoolEncValue,
    HEncVp8GoldenPenalty,
    HEncVp8FilterSharpness,
    HEncVp8FilterLevel,
    HEncVp8DctPartitionCount,
    HEncVp8BoolEncValueBits,
    HEncVp8BoolEncRange,

    HEncIpolFilterMode,
    HEncStartOffset,
    HEncRlcSum,
    HEncMadCount,
    HEncMbCount,

    HEncBaseNextLum,

    HEncStabMode,
    HEncStabMinimum,
    HEncStabMotionSum,
    HEncStabGmvX,
    HEncStabMatrix1,
    HEncStabGmvY,
    HEncStabMatrix2,
    HEncStabMatrix3,
    HEncStabMatrix4,
    HEncStabMatrix5,
    HEncStabMatrix6,
    HEncStabMatrix7,
    HEncStabMatrix8,
    HEncStabMatrix9,

    HEncBaseCabacCtx,
    HEncBaseMvWrite,

    HEncRGBCoeffA,
    HEncRGBCoeffB,
    HEncRGBCoeffC,
    HEncRGBCoeffE,
    HEncRGBCoeffF,

    HEncRMaskMSB,
    HEncGMaskMSB,
    HEncBMaskMSB,

    HEncIntraAreaLeft,
    HEncIntraAreaRight,
    HEncIntraAreaTop,
    HEncIntraAreaBottom,

    HEncCirStart,
    HEncCirInterval,

    HEncIntraSliceMap1,
    HEncIntraSliceMap2,
    HEncIntraSliceMap3,
    HEncBasePartition1,
    HEncBasePartition2,
    HEncBaseVp8ProbCount,

    HEncRoi1Left,
    HEncRoi1Right,
    HEncRoi1Top,
    HEncRoi1Bottom,

    HEncRoi2Left,
    HEncRoi2Right,
    HEncRoi2Top,
    HEncRoi2Bottom,

    HEncRoi1DeltaQp,
    HEncRoi2DeltaQp,
    HEncZeroMvFavor,
    HEncSplitPenalty4x4,

    HEncMvcPriorityId,
    HEncMvcViewId,
    HEncMvcTemporalId,
    HEncMvcAnchorPicFlag,
    HEncMvcInterViewFlag,

    HEncHWChSearchArea,
    HEncHWScalingSupport,
    HEncHWSearchArea,
    HEncHWRgbSupport,
    HEncHWH264Support,
    HEncHWVp8Support,
    HEncHWJpegSupport,
    HEncHWStabSupport,
    HEncHWBus,
    HEncHWSynthesisLan,
    HEncHWBusWidth,
    HEncHWMaxVideoWidth,

    HEncJpegQuantLuma1,
    HEncJpegQuantLuma2,
    HEncJpegQuantLuma3,
    HEncJpegQuantLuma4,
    HEncJpegQuantLuma5,
    HEncJpegQuantLuma6,
    HEncJpegQuantLuma7,
    HEncJpegQuantLuma8,
    HEncJpegQuantLuma9,
    HEncJpegQuantLuma10,
    HEncJpegQuantLuma11,
    HEncJpegQuantLuma12,
    HEncJpegQuantLuma13,
    HEncJpegQuantLuma14,
    HEncJpegQuantLuma15,
    HEncJpegQuantLuma16,

    HEncJpegQuantChroma1,
    HEncJpegQuantChroma2,
    HEncJpegQuantChroma3,
    HEncJpegQuantChroma4,
    HEncJpegQuantChroma5,
    HEncJpegQuantChroma6,
    HEncJpegQuantChroma7,
    HEncJpegQuantChroma8,
    HEncJpegQuantChroma9,
    HEncJpegQuantChroma10,
    HEncJpegQuantChroma11,
    HEncJpegQuantChroma12,
    HEncJpegQuantChroma13,
    HEncJpegQuantChroma14,
    HEncJpegQuantChroma15,
    HEncJpegQuantChroma16,

    /* VP8 penalty registers */
    HEncVp8Mode0Penalty,
    HEncVp8Mode1Penalty,
    HEncVp8Mode2Penalty,
    HEncVp8Mode3Penalty,
    HEncVp8Bmode0Penalty,
    HEncVp8Bmode1Penalty,
    HEncVp8Bmode2Penalty,
    HEncVp8Bmode3Penalty,
    HEncVp8Bmode4Penalty,
    HEncVp8Bmode5Penalty,
    HEncVp8Bmode6Penalty,
    HEncVp8Bmode7Penalty,
    HEncVp8Bmode8Penalty,
    HEncVp8Bmode9Penalty,
    HEncBaseVp8SegmentMap,
    HEncVp8Seg1Y1QuantDc,
    HEncVp8Seg1Y1ZbinDc,
    HEncVp8Seg1Y1RoundDc,
    HEncVp8Seg1Y1QuantAc,
    HEncVp8Seg1Y1ZbinAc,
    HEncVp8Seg1Y1RoundAc,
    HEncVp8Seg1Y2QuantDc,
    HEncVp8Seg1Y2ZbinDc,
    HEncVp8Seg1Y2RoundDc,
    HEncVp8Seg1Y2QuantAc,
    HEncVp8Seg1Y2ZbinAc,
    HEncVp8Seg1Y2RoundAc,
    HEncVp8Seg1ChQuantDc,
    HEncVp8Seg1ChZbinDc,
    HEncVp8Seg1ChRoundDc,
    HEncVp8Seg1ChQuantAc,
    HEncVp8Seg1ChZbinAc,
    HEncVp8Seg1ChRoundAc,
    HEncVp8Seg1Y1DequantDc,
    HEncVp8Seg1Y1DequantAc,
    HEncVp8Seg1Y2DequantDc,
    HEncVp8Seg1Y2DequantAc,
    HEncVp8Seg1ChDequantDc,
    HEncVp8Seg1ChDequantAc,
    HEncVp8Seg1FilterLevel,
    HEncVp8Seg2Y1QuantDc,
    HEncVp8Seg2Y1ZbinDc,
    HEncVp8Seg2Y1RoundDc,
    HEncVp8Seg2Y1QuantAc,
    HEncVp8Seg2Y1ZbinAc,
    HEncVp8Seg2Y1RoundAc,
    HEncVp8Seg2Y2QuantDc,
    HEncVp8Seg2Y2ZbinDc,
    HEncVp8Seg2Y2RoundDc,
    HEncVp8Seg2Y2QuantAc,
    HEncVp8Seg2Y2ZbinAc,
    HEncVp8Seg2Y2RoundAc,
    HEncVp8Seg2ChQuantDc,
    HEncVp8Seg2ChZbinDc,
    HEncVp8Seg2ChRoundDc,
    HEncVp8Seg2ChQuantAc,
    HEncVp8Seg2ChZbinAc,
    HEncVp8Seg2ChRoundAc,
    HEncVp8Seg2Y1DequantDc,
    HEncVp8Seg2Y1DequantAc,
    HEncVp8Seg2Y2DequantDc,
    HEncVp8Seg2Y2DequantAc,
    HEncVp8Seg2ChDequantDc,
    HEncVp8Seg2ChDequantAc,
    HEncVp8Seg2FilterLevel,
    HEncVp8Seg3Y1QuantDc,
    HEncVp8Seg3Y1ZbinDc,
    HEncVp8Seg3Y1RoundDc,
    HEncVp8Seg3Y1QuantAc,
    HEncVp8Seg3Y1ZbinAc,
    HEncVp8Seg3Y1RoundAc,
    HEncVp8Seg3Y2QuantDc,
    HEncVp8Seg3Y2ZbinDc,
    HEncVp8Seg3Y2RoundDc,
    HEncVp8Seg3Y2QuantAc,
    HEncVp8Seg3Y2ZbinAc,
    HEncVp8Seg3Y2RoundAc,
    HEncVp8Seg3ChQuantDc,
    HEncVp8Seg3ChZbinDc,
    HEncVp8Seg3ChRoundDc,
    HEncVp8Seg3ChQuantAc,
    HEncVp8Seg3ChZbinAc,
    HEncVp8Seg3ChRoundAc,
    HEncVp8Seg3Y1DequantDc,
    HEncVp8Seg3Y1DequantAc,
    HEncVp8Seg3Y2DequantDc,
    HEncVp8Seg3Y2DequantAc,
    HEncVp8Seg3ChDequantDc,
    HEncVp8Seg3ChDequantAc,
    HEncVp8Seg3FilterLevel,

    HEncDmvPenalty1,
    HEncDmvPenalty2,
    HEncDmvPenalty3,
    HEncDmvPenalty4,
    HEncDmvPenalty5,
    HEncDmvPenalty6,
    HEncDmvPenalty7,
    HEncDmvPenalty8,
    HEncDmvPenalty9,
    HEncDmvPenalty10,
    HEncDmvPenalty11,
    HEncDmvPenalty12,
    HEncDmvPenalty13,
    HEncDmvPenalty14,
    HEncDmvPenalty15,
    HEncDmvPenalty16,
    HEncDmvPenalty17,
    HEncDmvPenalty18,
    HEncDmvPenalty19,
    HEncDmvPenalty20,
    HEncDmvPenalty21,
    HEncDmvPenalty22,
    HEncDmvPenalty23,
    HEncDmvPenalty24,
    HEncDmvPenalty25,
    HEncDmvPenalty26,
    HEncDmvPenalty27,
    HEncDmvPenalty28,
    HEncDmvPenalty29,
    HEncDmvPenalty30,
    HEncDmvPenalty31,
    HEncDmvPenalty32,

    HEncDmvQpelPenalty1,
    HEncDmvQpelPenalty2,
    HEncDmvQpelPenalty3,
    HEncDmvQpelPenalty4,
    HEncDmvQpelPenalty5,
    HEncDmvQpelPenalty6,
    HEncDmvQpelPenalty7,
    HEncDmvQpelPenalty8,
    HEncDmvQpelPenalty9,
    HEncDmvQpelPenalty10,
    HEncDmvQpelPenalty11,
    HEncDmvQpelPenalty12,
    HEncDmvQpelPenalty13,
    HEncDmvQpelPenalty14,
    HEncDmvQpelPenalty15,
    HEncDmvQpelPenalty16,
    HEncDmvQpelPenalty17,
    HEncDmvQpelPenalty18,
    HEncDmvQpelPenalty19,
    HEncDmvQpelPenalty20,
    HEncDmvQpelPenalty21,
    HEncDmvQpelPenalty22,
    HEncDmvQpelPenalty23,
    HEncDmvQpelPenalty24,
    HEncDmvQpelPenalty25,
    HEncDmvQpelPenalty26,
    HEncDmvQpelPenalty27,
    HEncDmvQpelPenalty28,
    HEncDmvQpelPenalty29,
    HEncDmvQpelPenalty30,
    HEncDmvQpelPenalty31,
    HEncDmvQpelPenalty32,
    HEncVp8CostInter,
    HEncVp8DmvCostConst,
    HEncSplitZeroPenalty,
    HEncVp8CostGoldenRef,
    /* VP8 loop filter deltas */
    HEncVp8LfRefDelta0,
    HEncVp8LfRefDelta1,
    HEncVp8LfRefDelta2,
    HEncVp8LfRefDelta3,
    HEncVp8LfModeDelta0,
    HEncVp8LfModeDelta1,
    HEncVp8LfModeDelta2,
    HEncVp8LfModeDelta3,

    HEncVp8DzCoeffRate0,
    HEncVp8DzCoeffRate1,
    HEncVp8DzCoeffRate2,
    HEncVp8DzCoeffRate3,
    HEncVp8DzCoeffRate4,
    HEncVp8DzCoeffRate5,
    HEncVp8DzCoeffRate6,
    HEncVp8DzCoeffRate7,
    HEncVp8DzCoeffRate8,
    HEncVp8DzCoeffRate9,
    HEncVp8DzCoeffRate10,
    HEncVp8DzCoeffRate11,
    HEncVp8DzCoeffRate12,
    HEncVp8DzCoeffRate13,
    HEncVp8DzCoeffRate14,
    HEncVp8DzCoeffRate15,
    HEncVp8DzCoeffRate16,
    HEncVp8DzCoeffRate17,
    HEncVp8DzCoeffRate18,
    HEncVp8DzCoeffRate19,
    HEncVp8DzCoeffRate20,
    HEncVp8DzCoeffRate21,
    HEncVp8DzCoeffRate22,
    HEncVp8DzCoeffRate23,
    HEncVp8DzCoeffRate24,
    HEncVp8DzCoeffRate25,
    HEncVp8DzCoeffRate26,
    HEncVp8DzCoeffRate27,
    HEncVp8DzCoeffRate28,
    HEncVp8DzCoeffRate29,
    HEncVp8DzCoeffRate30,
    HEncVp8DzCoeffRate31,
    HEncVp8DzCoeffRate32,
    HEncVp8DzCoeffRate33,
    HEncVp8DzCoeffRate34,
    HEncVp8DzCoeffRate35,
    HEncVp8DzCoeffRate36,
    HEncVp8DzCoeffRate37,
    HEncVp8DzCoeffRate38,
    HEncVp8DzCoeffRate39,
    HEncVp8DzCoeffRate40,
    HEncVp8DzCoeffRate41,
    HEncVp8DzCoeffRate42,
    HEncVp8DzCoeffRate43,
    HEncVp8DzCoeffRate44,
    HEncVp8DzCoeffRate45,
    HEncVp8DzCoeffRate46,
    HEncVp8DzCoeffRate47,

    HEncVp8DzEobRate0,
    HEncVp8DzEobRate1,
    HEncVp8DzEobRate2,
    HEncVp8DzEobRate3,
    HEncVp8DzEobRate4,
    HEncVp8DzEobRate5,
    HEncVp8DzEobRate6,
    HEncVp8DzEobRate7,
    HEncVp8DzEobRate8,
    HEncVp8DzEobRate9,
    HEncVp8DzEobRate10,
    HEncVp8DzEobRate11,
    HEncVp8DzEobRate12,
    HEncVp8DzEobRate13,
    HEncVp8DzEobRate14,
    HEncVp8DzEobRate15,

    HEncVp8DzRateM0,
    HEncVp8DzRateM1,
    HEncVp8DzRateM2,
    HEncVp8DzRateM3,

    HEncVp8DzSkipRate0,
    HEncVp8DzSkipRate1,

    HEncBaseScaledOutLum,
    HEncScaleMode,
    HEncScaledOutWidth,
    HEncScaledOutWidthRatio,
    HEncScaledOutHeight,
    HEncScaledOutHeightRatio,

    HEncSquaredError,

    HEncMadThreshold2,
    HEncMadQpDelta2,
    HEncMadCount2,

    HEncMadThreshold3,
    HEncMadQpDelta3,
    HEncMadCount3,

    HEncVp8IpolCoeff01,
    HEncVp8IpolCoeff02,
    HEncVp8IpolCoeff03,
    HEncVp8IpolCoeff04,
    HEncVp8IpolCoeff05,
    HEncVp8IpolCoeff06,
    HEncVp8IpolCoeff11,
    HEncVp8IpolCoeff12,
    HEncVp8IpolCoeff13,
    HEncVp8IpolCoeff14,
    HEncVp8IpolCoeff15,
    HEncVp8IpolCoeff16,
    HEncVp8IpolCoeff21,
    HEncVp8IpolCoeff22,
    HEncVp8IpolCoeff23,
    HEncVp8IpolCoeff24,
    HEncVp8IpolCoeff25,
    HEncVp8IpolCoeff26,
    HEncVp8IpolCoeff31,
    HEncVp8IpolCoeff32,
    HEncVp8IpolCoeff33,
    HEncVp8IpolCoeff34,
    HEncVp8IpolCoeff35,
    HEncVp8IpolCoeff36,
    HEncVp8IpolCoeff41,
    HEncVp8IpolCoeff42,
    HEncVp8IpolCoeff43,
    HEncVp8IpolCoeff44,
    HEncVp8IpolCoeff45,
    HEncVp8IpolCoeff46,

    HEncBasePartition3,
    HEncBasePartition4,

    HEncSeg1I16Mode0Penalty,
    HEncSeg1I16Mode1Penalty,
    HEncSeg1I16Mode2Penalty,
    HEncSeg1I16Mode3Penalty,
    HEncSeg1I4Mode0Penalty,
    HEncSeg1I4Mode1Penalty,
    HEncSeg1I4Mode2Penalty,
    HEncSeg1I4Mode3Penalty,
    HEncSeg1I4Mode4Penalty,
    HEncSeg1I4Mode5Penalty,
    HEncSeg1I4Mode6Penalty,
    HEncSeg1I4Mode7Penalty,
    HEncSeg1I4Mode8Penalty,
    HEncSeg1I4Mode9Penalty,
    HEncSeg1I4PrevModeFavor,
    HEncSeg1CostInter,
    HEncSeg1I16Favor,
    HEncSeg1InterFavor,
    HEncSeg1SkipPenalty,
    HEncSeg1GoldenPenalty,
    HEncSeg1SplitPenalty8x4,
    HEncSeg1SplitPenalty8x8,
    HEncSeg1SplitPenalty16x8,
    HEncSeg1SplitPenalty4x4,
    HEncSeg1SplitZeroPenalty,
    HEncSeg1DMVPenaltyQp,
    HEncSeg1DzRateM0,
    HEncSeg1DzRateM1,
    HEncSeg1DzRateM2,
    HEncSeg1DzRateM3,
    HEncSeg1DzSkipRate0,
    HEncSeg1DzSkipRate1,
    HEncSeg1DmvCostConst,

    HEncSeg2I16Mode0Penalty,
    HEncSeg2I16Mode1Penalty,
    HEncSeg2I16Mode2Penalty,
    HEncSeg2I16Mode3Penalty,
    HEncSeg2I4Mode0Penalty,
    HEncSeg2I4Mode1Penalty,
    HEncSeg2I4Mode2Penalty,
    HEncSeg2I4Mode3Penalty,
    HEncSeg2I4Mode4Penalty,
    HEncSeg2I4Mode5Penalty,
    HEncSeg2I4Mode6Penalty,
    HEncSeg2I4Mode7Penalty,
    HEncSeg2I4Mode8Penalty,
    HEncSeg2I4Mode9Penalty,
    HEncSeg2I4PrevModeFavor,
    HEncSeg2CostInter,
    HEncSeg2I16Favor,
    HEncSeg2InterFavor,
    HEncSeg2SkipPenalty,
    HEncSeg2GoldenPenalty,
    HEncSeg2SplitPenalty8x4,
    HEncSeg2SplitPenalty8x8,
    HEncSeg2SplitPenalty16x8,
    HEncSeg2SplitPenalty4x4,
    HEncSeg2SplitZeroPenalty,
    HEncSeg2DMVPenaltyQp,
    HEncSeg2DzRateM0,
    HEncSeg2DzRateM1,
    HEncSeg2DzRateM2,
    HEncSeg2DzRateM3,
    HEncSeg2DzSkipRate0,
    HEncSeg2DzSkipRate1,
    HEncSeg2DmvCostConst,

    HEncSeg3I16Mode0Penalty,
    HEncSeg3I16Mode1Penalty,
    HEncSeg3I16Mode2Penalty,
    HEncSeg3I16Mode3Penalty,
    HEncSeg3I4Mode0Penalty,
    HEncSeg3I4Mode1Penalty,
    HEncSeg3I4Mode2Penalty,
    HEncSeg3I4Mode3Penalty,
    HEncSeg3I4Mode4Penalty,
    HEncSeg3I4Mode5Penalty,
    HEncSeg3I4Mode6Penalty,
    HEncSeg3I4Mode7Penalty,
    HEncSeg3I4Mode8Penalty,
    HEncSeg3I4Mode9Penalty,
    HEncSeg3I4PrevModeFavor,
    HEncSeg3CostInter,
    HEncSeg3I16Favor,
    HEncSeg3InterFavor,
    HEncSeg3SkipPenalty,
    HEncSeg3GoldenPenalty,
    HEncSeg3SplitPenalty8x4,
    HEncSeg3SplitPenalty8x8,
    HEncSeg3SplitPenalty16x8,
    HEncSeg3SplitPenalty4x4,
    HEncSeg3SplitZeroPenalty,
    HEncSeg3DMVPenaltyQp,
    HEncSeg3DzRateM0,
    HEncSeg3DzRateM1,
    HEncSeg3DzRateM2,
    HEncSeg3DzRateM3,
    HEncSeg3DzSkipRate0,
    HEncSeg3DzSkipRate1,
    HEncSeg3DmvCostConst,

    HEncVp8AvgVar,
    HEncVp8InvAvgVar,
    HEncFieldPicFlag,
    HEncBottomFieldFlag,
    HEncFieldParity,

    HEncBoostQp,
    HEncBoostVar1,
    HEncBoostVar2,

    HEncVarLimit,
    HEncVarInterFavor,
    HEncVarMultiplier,
    HEncVarAdd,
    HEncPskipMode,

    
#include "reg_enum_v7.h"

    HEncRegisterAmount

} regName;

/* HW Register field descriptions */
typedef struct {
    u32 name;               /* Register name and index  */
    i32 base;               /* Register base address  */
    u32 mask;               /* Bitmask for this field */
    i32 lsb;                /* LSB for this field [31..0] */
    i32 trace;              /* Enable/disable writing in swreg_params.trc */
    i32 rw;                 /* 1=Read-only 2=Write-only 3=Read-Write */
    char *description;      /* Field description */
} regField_s;

/* Flags for read-only, write-only and read-write */
#define RO 1
#define WO 2
#define RW 3

/* Description field only needed for system model build. */
#ifdef TEST_DATA
    #define H1REG(name, base, mask, lsb, trace, rw, desc) \
        {name, base, mask, lsb, trace, rw, desc}
#else
    #define H1REG(name, base, mask, lsb, trace, rw, desc) \
        {name, base, mask, lsb, trace, rw, ""}
#endif

/* NOTE: Don't use ',' in descriptions, because it is used as separator in csv
 * parsing. */
static const regField_s asicRegisterDesc[] = {
/* HW ID register, read-only */
    H1REG(HEncProductID        , 0x000, 0xffff0000, 16, 0, RO, "Product ID"),
    H1REG(HEncProductMajor     , 0x000, 0x0000f000, 12, 0, RO, "Major number"),
    H1REG(HEncProductMinor     , 0x000, 0x00000ff0,  4, 0, RO, "Minor number"),
    H1REG(HEncProductBuild     , 0x000, 0x0000000f,  0, 0, RO, "Build number defined in synthesis."),
/* Encoder interrupt register */
    H1REG(HEncIRQFuse          , 0x004, 0x00000200,  9, 0, RW, "IRQ stream format fuse status bit. Format disabled by fuse."),
    H1REG(HEncIRQSliceReady    , 0x004, 0x00000100,  8, 0, RW, "IRQ slice ready status bit. Slice is ready but frame encoding continues."),
    H1REG(HEncIRQTimeout       , 0x004, 0x00000040,  6, 0, RW, "IRQ HW timeout status bit. HW encoding failed."),
    H1REG(HEncIRQBuffer        , 0x004, 0x00000020,  5, 1, RW, "IRQ buffer full status bit. bufferFullInterrupt"),
    H1REG(HEncIRQReset         , 0x004, 0x00000010,  4, 0, RW, "IRQ SW reset status bit."),
    H1REG(HEncIRQBusError      , 0x004, 0x00000008,  3, 0, RW, "IRQ bus error status bit."),
    H1REG(HEncIRQFrameReady    , 0x004, 0x00000004,  2, 0, RW, "IRQ frame ready status bit. Encoder has finished a frame."),
    H1REG(HEncIRQDisable       , 0x004, 0x00000002,  1, 0, RW, "IRQ disable. No interrupts from HW. SW must use polling."),
    H1REG(HEncIRQ              , 0x004, 0x00000001,  0, 0, RW, "HINTenc Interrupt from HW. SW resets at IRQ handler."),
/* Encoder configuration register */
    H1REG(HEncAXIWriteID       , 0x008, 0xff000000, 24, 0, RW, "AXI Write ID"),
    H1REG(HEncAXIReadID        , 0x008, 0x00ff0000, 16, 0, RW, "AXI Read ID"),
    H1REG(HEncOutputSwap16     , 0x008, 0x00008000, 15, 0, RW, "Enable output stream swap 16-bits"),
    H1REG(HEncInputSwap16      , 0x008, 0x00004000, 14, 0, RW, "Enable input swap 16-bits"),
    H1REG(HEncBurstLength      , 0x008, 0x00003f00,  8, 0, RW, "Burst length. 0=incremental. 4=max BURST4.8=max BURST8. 16=max BURST16"),
    H1REG(HEncBurstDisable     , 0x008, 0x00000080,  7, 0, RW, "Disable burst mode for AXI"),
    H1REG(HEncBurstIncr        , 0x008, 0x00000040,  6, 0, RW, "Burst incremental. 1=INCR burst allowed. 0=use SINGLE burst"),
    H1REG(HEncDataDiscard      , 0x008, 0x00000020,  5, 0, RW, "Enable burst data discard. 2 or 3 long reads are using BURST4"),
    H1REG(HEncClockGating      , 0x008, 0x00000010,  4, 0, RW, "Enable clock gating"),
    H1REG(HEncOutputSwap32     , 0x008, 0x00000008,  3, 0, RW, "Enable output stream swap 32-bits"),
    H1REG(HEncInputSwap32      , 0x008, 0x00000004,  2, 0, RW, "Enable input swap 32-bits"),
    H1REG(HEncOutputSwap8      , 0x008, 0x00000002,  1, 0, RW, "Enable output stream swap 8-bits"),
    H1REG(HEncInputSwap8       , 0x008, 0x00000001,  0, 0, RW, "Enable input swap 8-bits"),
    H1REG(HEncScaleOutputSwap8 , 0x00c, 0x08000000, 27, 0, RW, "Enable output scaled image swap for 8-bits"),
    H1REG(HEncScaleOutputSwap16, 0x00c, 0x04000000, 26, 0, RW, "Enable output scaled image swap for 16-bits"),
    H1REG(HEncScaleOutputSwap32, 0x00c, 0x02000000, 25, 0, RW, "Enable output scaled image swap for 32-bits"),
    H1REG(HEncMvOutputSwap8    , 0x00c, 0x01000000, 24, 0, RW, "Enable output MV (MB info) swap for 8-bits"),
    H1REG(HEncMvOutputSwap16   , 0x00c, 0x00800000, 23, 0, RW, "Enable output MV (MB info) swap for 16-bits"),
    H1REG(HEncMvOutputSwap32   , 0x00c, 0x00400000, 22, 0, RW, "Enable output MV (MB info) swap for 32-bits"),
    H1REG(HEncInputReadChunk   , 0x00c, 0x00200000, 21, 0, RW, "Chunk size for input picture read 0=4 MBs. 1=1 MB"),
    H1REG(HEncAXIDualCh        , 0x00c, 0x00100000, 20, 0, RW, "Disable dual channel AXI. 0=use two channels. 1=use single channel."),
    H1REG(HEncTestIrq          , 0x00c, 0x00000001,  0, 0, RW, "Enable MB bus timing info output."),
/* External memory base addresses for encoder input/outputput */
    H1REG(HEncBaseStream       , 0x014, 0xffffffff,  0, 0, RW, "Base address for output stream data"),
    H1REG(HEncBaseControl      , 0x018, 0xffffffff,  0, 0, RW, "Base address for output control data"),
    H1REG(HEncBaseRefLum       , 0x01c, 0xffffffff,  0, 0, RW, "Base address for reference luma"),
    H1REG(HEncBaseRefChr       , 0x020, 0xffffffff,  0, 0, RW, "Base address for reference chroma"),
    H1REG(HEncBaseRecLum       , 0x024, 0xffffffff,  0, 0, RW, "Base address for reconstructed luma"),
    H1REG(HEncBaseRecChr       , 0x028, 0xffffffff,  0, 0, RW, "Base address for reconstructed chroma"),
    H1REG(HEncBaseInLum        , 0x02c, 0xffffffff,  0, 0, RW, "Base address for input picture luma"),
    H1REG(HEncBaseInCb         , 0x030, 0xffffffff,  0, 0, RW, "Base address for input picture cb"),
    H1REG(HEncBaseInCr         , 0x034, 0xffffffff,  0, 0, RW, "Base address for input picture cr"),
    H1REG(HEncIntTimeout       , 0x038, 0x80000000, 31, 0, RW, "Enable interrupt for timeout"),
    H1REG(HEncMvWrite          , 0x038, 0x40000000, 30, 1, RW, "Enable writing MV and SAD of each MB to BaseMvWrite"),
    H1REG(HEncNalSizeWrite     , 0x038, 0x20000000, 29, 1, RW, "Enable writing size of each NAL unit to BaseControl, nalSizeWriteOut"),
    H1REG(HEncIntSliceReady    , 0x038, 0x10000000, 28, 0, RW, "Enable interrupt for slice ready"),
    H1REG(HEncWidth            , 0x038, 0x0ff80000, 19, 1, RW, "Encoded width. lumWidth (macroblocks) H264:[9..255] JPEG:[6..511]"),
    H1REG(HEncHeight           , 0x038, 0x0007fc00, 10, 1, RW, "Encoded height. lumHeight (macroblocks) H264:[6..255] JPEG:[2..511]"),
    H1REG(HEncRecWriteBuffer   , 0x038, 0x00000080,  7, 1, RW, "Size of buffer used when writing reconstructed image. 0=1 MB buffered (write burst for every MB). 1=4 MBs buffered (write burst for every fourth MB)"),
    H1REG(HEncRecWriteDisable  , 0x038, 0x00000040,  6, 1, RW, "Disable writing of reconstructed image. recWriteDisable"),
    H1REG(HEncPictureType      , 0x038, 0x00000018,  3, 1, RW, "Encoded picture type. frameType. 0=INTER. 1=INTRA(IDR). 2=MVC-INTER. 3=MVC-INTER(ref mod)."),
    H1REG(HEncEncodingMode     , 0x038, 0x00000006,  1, 1, RW, "Encoding mode. streamType. 1=VP8. 2=JPEG. 3=H264"),
    H1REG(HEncEnable           , 0x038, 0x00000001,  0, 0, RW, "Encoder enable"),
    H1REG(HEncChrOffset        , 0x03c, 0xe0000000, 29, 0, RW, "Input chrominance offset (bytes) [0..7]"),
    H1REG(HEncLumOffset        , 0x03c, 0x1c000000, 26, 0, RW, "Input luminance offset (bytes) [0..7]"),
    H1REG(HEncRowLength        , 0x03c, 0x03fff000, 12, 1, RW, "Input luminance row length. lumWidthSrc (bytes) [96..8192]"),
    H1REG(HEncXFill            , 0x03c, 0x00000c00, 10, 0, RW, "Overfill pixels on right edge of image div4 [0..3]"),
    H1REG(HEncYFill            , 0x03c, 0x000003c0,  6, 1, RW, "Overfill pixels on bottom edge of image. YFill. [0..15]"),
    H1REG(HEncInputFormat      , 0x03c, 0x0000003c,  2, 1, RW, "Input image format. inputFormat. YUV420P/YUV420SP/YUYV422/UYVY422/RGB565/RGB555/RGB444/RGB888/RGB101010"),
    H1REG(HEncInputRot         , 0x03c, 0x00000003,  0, 1, RW, "Input image rotation. 0=disabled. 1=90 degrees right. 2=90 degrees left"),

/* VP8 / H.264 mixed definitions */
    H1REG(HEncBaseRefLum2      , 0x040, 0xffffffff,  0, 0, RW, "Base address for second reference luma"),
    H1REG(HEncBaseRefChr2      , 0x044, 0xffffffff,  0, 0, RW, "Base address for second reference chroma"),
    H1REG(HEncPicInitQp        , 0x040, 0xfc000000, 26, 0, RW, "H.264 Pic init qp in PPS [0..51]"),
    H1REG(HEncSliceAlpha       , 0x040, 0x03c00000, 22, 0, RW, "H.264 Slice filter alpha c0 offset div2 [-6..6]"),
    H1REG(HEncSliceBeta        , 0x040, 0x003c0000, 18, 0, RW, "H.264 Slice filter beta offset div2 [-6..6]"),
    H1REG(HEncChromaQp         , 0x040, 0x0003e000, 13, 0, RW, "H.264 Chroma qp index offset [-12..12]"),
    H1REG(HEncIdrPicId         , 0x040, 0x0000001e,  1, 0, RW, "H.264 IDR picture ID"),
    H1REG(HEncConstrIP         , 0x040, 0x00000001,  0, 1, RW, "H.264 Constrained intra prediction enable. constIntraPred"),
    H1REG(HEncPPSID            , 0x044, 0xff000000, 24, 0, RW, "H.264 pic_parameter_set_id"),
    H1REG(HEncIPPrevModeFavor  , 0x044, 0x00ff0000, 16, 0, RW, "H.264 Intra prediction previous 4x4 mode favor"),
    H1REG(HEncFrameNum         , 0x044, 0x0000ffff,  0, 0, RW, "H.264 Frame num"),

    H1REG(HEncDeblocking       , 0x048, 0xc0000000, 30, 0, RW, "Deblocking filter mode. 0=enabled. 1=disabled (vp8=simple). 2=disabled on slice borders"),
    H1REG(HEncSliceSize        , 0x048, 0x3f800000, 23, 1, RW, "H.264 Slice size. mbRowPerSlice (mb rows) [0..127] 0=one slice per picture"),
    H1REG(HEncDisableQPMV      , 0x048, 0x00400000, 22, 1, RW, "H.264 Disable quarter pixel MVs. disableQuarterPixelMv"),
    H1REG(HEncTransform8x8     , 0x048, 0x00200000, 21, 1, RW, "H.264 Transform 8x8 enable. High Profile H.264. transform8x8Mode"),
    H1REG(HEncCabacInitIdc     , 0x048, 0x00180000, 19, 0, RW, "H.264 CABAC initial IDC. [0..2]"),
    H1REG(HEncCabacEnable      , 0x048, 0x00040000, 18, 1, RW, "H.264 CABAC / VP8 boolenc enable. entropyCodingMode. 0=CAVLC (Baseline Profile H.264). 1=CABAC (Main Profile H.264)"),
    H1REG(HEncInter4Restrict   , 0x048, 0x00020000, 17, 1, RW, "H.264 Inter 4x4 mode restriction. restricted4x4Mode"),
    H1REG(HEncStreamMode       , 0x048, 0x00010000, 16, 1, RW, "H.264 Stream mode. byteStream. 0=NAL unit stream. 1=Byte stream"),
    H1REG(HEncIPIntra16Favor   , 0x048, 0x0000ffff,  0, 0, RW, "Intra prediction intra 16x16 mode favor"),
    H1REG(HEncChromaSwap       , 0x04c, 0x80000000, 31, 1, RW, "Swap order of chroma bytes in semiplanar input format."),
    H1REG(HEncSplitMv          , 0x04c, 0x40000000, 30, 1, RW, "Enable using more than 1 MV per macroblock."),
    H1REG(HEncDMVPenalty1p     , 0x04c, 0x000003ff,  0, 1, RW, "Differential MV penalty for 1p ME. DMVPenalty1p"),
    H1REG(HEncDMVPenalty4p     , 0x04c, 0x000ffc00, 10, 1, RW, "Differential MV penalty for 4p ME. DMVPenalty4p"),
    H1REG(HEncDMVPenaltyQp     , 0x04c, 0x3ff00000, 20, 1, RW, "Differential MV penalty for 1/4p ME. DMVPenaltyQp"),

/* Mixed definitions JPEG / video */
    H1REG(HEncJpegMode         , 0x050, 0x02000000, 25, 0, RW, "JPEG mode. 0=4:2:0 (4lum+2chr blocks/MCU). 1=4:2:2 (2lum+2chr blocks/MCU)"),
    H1REG(HEncJpegSlice        , 0x050, 0x01000000, 24, 0, RW, "JPEG slice enable. 0=picture ends with EOI. 1=slice ends with RST"),
    H1REG(HEncJpegRSTInt       , 0x050, 0x00ff0000, 16, 0, RW, "JPEG restart marker interval when slices are disabled (mb rows) [0..255]"),
    H1REG(HEncJpegRST          , 0x050, 0x0000ffff,  0, 0, RW, "JPEG restart marker for first RST. incremented by HW for next RST"),
    H1REG(HEncSplitPenalty16x8 , 0x050, 0x3ff00000, 20, 0, RW, "Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSplitPenalty8x8  , 0x050, 0x000ffc00, 10, 0, RW, "Penalty for using 8x8 MV."),
    H1REG(HEncSplitPenalty8x4  , 0x050, 0x000003ff,  0, 0, RW, "Penalty for using 8x4 or 4x8 MV."),

    H1REG(HEncSkipPenalty      , 0x054, 0xff000000, 24, 0, RW, "H.264 SKIP macroblock mode / VP8 zero/nearest/near mode penalty"),
    H1REG(HEncNumSlicesReady   , 0x054, 0x00ff0000, 16, 0, RW, "H.264 amount of completed slices."),
    H1REG(HEncInterFavor       , 0x054, 0x0000ffff,  0, 0, RW, "Inter MB mode favor in intra/inter selection"),
    H1REG(HEncStrmHdrRem1      , 0x058, 0xffffffff,  0, 0, RW, "Stream header remainder bits MSB (MSB aligned)"),
    H1REG(HEncStrmHdrRem2      , 0x05c, 0xffffffff,  0, 0, RW, "Stream header remainder bits LSB (MSB aligned)"),
    H1REG(HEncStrmBufLimit     , 0x060, 0xffffffff,  0, 1, RW, "Stream buffer limit (64bit addresses) / output stream size (bits). HWStreamDataCount. If limit is reached buffer full IRQ is given."),
    H1REG(HEncMadQpDelta       , 0x064, 0xf0000000, 28, 1, RW, "MAD based QP adjustment. madQpChange [-8..7]"),
    H1REG(HEncMadThreshold     , 0x064, 0x0fc00000, 22, 0, RW, "MAD threshold div256"),
    H1REG(HEncQpSum            , 0x064, 0x003fffff,  0, 0, RW, "QP Sum div2 output"),

/* H.264 Rate control registers */
    H1REG(HEncQp               , 0x06c, 0xfc000000, 26, 1, RW, "H.264 Initial QP. qpLum [0..51]"),
    H1REG(HEncMaxQp            , 0x06c, 0x03f00000, 20, 1, RW, "H.264 Maximum QP. qpMax [0..51]"),
    H1REG(HEncMinQp            , 0x06c, 0x000fc000, 14, 1, RW, "H.264 Minimum QP. qpMin [0..51]"),
    H1REG(HEncCPDist           , 0x06c, 0x00001fff,  0, 0, RW, "H.264 Checkpoint distance (mb) 0=disabled [0..8191]"),
    H1REG(HEncCP1WordTarget    , 0x070, 0xffff0000, 16, 0, RW, "H.264 Checkpoint 1 word target/usage div32 [0..65535]"),
    H1REG(HEncCP2WordTarget    , 0x070, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint 2 word target/usage div32 [0..65535]"),
    H1REG(HEncCP3WordTarget    , 0x074, 0xffff0000, 16, 0, RW, "H.264 Checkpoint 3 word target/usage div32 [0..65535]"),
    H1REG(HEncCP4WordTarget    , 0x074, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint 4 word target/usage div32 [0..65535]"),
    H1REG(HEncCP5WordTarget    , 0x078, 0xffff0000, 16, 0, RW, "H.264 Checkpoint 5 word target/usage div32 [0..65535]"),
    H1REG(HEncCP6WordTarget    , 0x078, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint 6 word target/usage div32 [0..65535]"),
    H1REG(HEncCP7WordTarget    , 0x07c, 0xffff0000, 16, 0, RW, "H.264 Checkpoint 7 word target/usage div32 [0..65535]"),
    H1REG(HEncCP8WordTarget    , 0x07c, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint 8 word target/usage div32 [0..65535]"),
    H1REG(HEncCP9WordTarget    , 0x080, 0xffff0000, 16, 0, RW, "H.264 Checkpoint 9 word target/usage div32 [0..65535]"),
    H1REG(HEncCP10WordTarget   , 0x080, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint 10 word target/usage div32 [0..65535]"),
    H1REG(HEncCPWordError1     , 0x084, 0xffff0000, 16, 0, RW, "H.264 Checkpoint word error 1 div4 [-32768..32767]"),
    H1REG(HEncCPWordError2     , 0x084, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint word error 2 div4 [-32768..32767]"),
    H1REG(HEncCPWordError3     , 0x088, 0xffff0000, 16, 0, RW, "H.264 Checkpoint word error 3 div4 [-32768..32767]"),
    H1REG(HEncCPWordError4     , 0x088, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint word error 4 div4 [-32768..32767]"),
    H1REG(HEncCPWordError5     , 0x08c, 0xffff0000, 16, 0, RW, "H.264 Checkpoint word error 5 div4 [-32768..32767]"),
    H1REG(HEncCPWordError6     , 0x08c, 0x0000ffff,  0, 0, RW, "H.264 Checkpoint word error 6 div4 [-32768..32767]"),
    H1REG(HEncCPDeltaQp1       , 0x090, 0x0f000000, 24, 0, RW, "H.264 Checkpoint delta QP 1 [-8..7]"),
    H1REG(HEncCPDeltaQp2       , 0x090, 0x00f00000, 20, 0, RW, "H.264 Checkpoint delta QP 2 [-8..7]"),
    H1REG(HEncCPDeltaQp3       , 0x090, 0x000f0000, 16, 0, RW, "H.264 Checkpoint delta QP 3 [-8..7]"),
    H1REG(HEncCPDeltaQp4       , 0x090, 0x0000f000, 12, 0, RW, "H.264 Checkpoint delta QP 4 [-8..7]"),
    H1REG(HEncCPDeltaQp5       , 0x090, 0x00000f00,  8, 0, RW, "H.264 Checkpoint delta QP 5 [-8..7]"),
    H1REG(HEncCPDeltaQp6       , 0x090, 0x000000f0,  4, 0, RW, "H.264 Checkpoint delta QP 6 [-8..7]"),
    H1REG(HEncCPDeltaQp7       , 0x090, 0x0000000f,  0, 0, RW, "H.264 Checkpoint delta QP 7 [-8..7]"),

/* H264 long-term ref bases */
    H1REG(HEncH264BaseRefLum2     , 0x070, 0xffffffff,  0, 0, RW, "H264 secondary ref pic base"),
    H1REG(HEncH264BaseRefChr2     , 0x074, 0xffffffff,  0, 0, RW, "H264 secondary ref pic base"),
    H1REG(HEncH264MvRefIdx        , 0x084, 0x0c000000, 26, 0, RW, "H264 mvRefIdx for first reference frame. 0=ipf. 1=ltr."),
    H1REG(HEncH264MarkCurrentLongTerm, 0x088, 0x04000000, 26, 0, RW, "H264 flag to mark current pic as long term ref"),
    H1REG(HEncH264Ref2Enable      , 0x088, 0x10000000, 28, 1, RW, "H264 enable for second reference frame."),
    H1REG(HEncH264LongTermPenalty , 0x090, 0xff000000, 24, 0, RW, "H264 Penalty value for second reference frame zero-mv [0..255]"),

/* VP8 Rate control registers, register 0x6C redefined for VP8 */
    H1REG(HEncVp8Y1QuantDc        , 0x06C, 0x00003fff,  0, 1, RW, "VP8 qpY1QuantDc 14b"),
    H1REG(HEncVp8Y1ZbinDc         , 0x06C, 0x007fc000, 14, 1, RW, "VP8 qpY1ZbinDc 9b"),
    H1REG(HEncVp8Y1RoundDc        , 0x06C, 0x7f800000, 23, 1, RW, "VP8 qpY1RoundDc 8b"),
    H1REG(HEncVp8Y1QuantAc        , 0x070, 0x00003fff,  0, 1, RW, "VP8 qpY1QuantAc 14b"),
    H1REG(HEncVp8Y1ZbinAc         , 0x070, 0x007fc000, 14, 1, RW, "VP8 qpY1ZbinAc 9b"),
    H1REG(HEncVp8Y1RoundAc        , 0x070, 0x7f800000, 23, 1, RW, "VP8 qpY1RoundAc 8b"),
    H1REG(HEncVp8Y2QuantDc        , 0x074, 0x00003fff,  0, 1, RW, "VP8 qpY2QuantDc 14b"),
    H1REG(HEncVp8Y2ZbinDc         , 0x074, 0x007fc000, 14, 1, RW, "VP8 qpY2ZbinDc 9b"),
    H1REG(HEncVp8Y2RoundDc        , 0x074, 0x7f800000, 23, 1, RW, "VP8 qpY2RoundDc 8b"),
    H1REG(HEncVp8Y2QuantAc        , 0x078, 0x00003fff,  0, 1, RW, "VP8 qpY2QuantAc 14b"),
    H1REG(HEncVp8Y2ZbinAc         , 0x078, 0x007fc000, 14, 1, RW, "VP8 qpY2ZbinAc 9b"),
    H1REG(HEncVp8Y2RoundAc        , 0x078, 0x7f800000, 23, 1, RW, "VP8 qpY2RoundAc 8b"),
    H1REG(HEncVp8ChQuantDc        , 0x07C, 0x00003fff,  0, 1, RW, "VP8 qpChQuantDc 14b"),
    H1REG(HEncVp8ChZbinDc         , 0x07C, 0x007fc000, 14, 1, RW, "VP8 qpChZbinDc 9b"),
    H1REG(HEncVp8ChRoundDc        , 0x07C, 0x7f800000, 23, 1, RW, "VP8 qpChRoundDc 8b"),
    H1REG(HEncVp8ChQuantAc        , 0x080, 0x00003fff,  0, 1, RW, "VP8 qpChQuantAc 14b"),
    H1REG(HEncVp8ChZbinAc         , 0x080, 0x007fc000, 14, 1, RW, "VP8 qpChZbinAc 9b"),
    H1REG(HEncVp8ChRoundAc        , 0x080, 0x7f800000, 23, 1, RW, "VP8 qpChRoundAc 8b"),
    H1REG(HEncVp8Y1DequantDc      , 0x084, 0x000000ff,  0, 1, RW, "VP8 qpY1DequantDc 8b"),
    H1REG(HEncVp8Y1DequantAc      , 0x084, 0x0001ff00,  8, 1, RW, "VP8 qpY1DequantAc 9b"),
    H1REG(HEncVp8Y2DequantDc      , 0x084, 0x03fe0000, 17, 1, RW, "VP8 qpY2DequantDc 9b"),
    H1REG(HEncVp8MvRefIdx         , 0x084, 0x0c000000, 26, 0, RW, "VP8 mvRefIdx for first reference frame. 0=ipf. 1=grf. 2=arf."),
    H1REG(HEncVp8Y2DequantAc      , 0x088, 0x000001ff,  0, 1, RW, "VP8 qpY2DequantAc 9b"),
    H1REG(HEncVp8ChDequantDc      , 0x088, 0x0001fe00,  9, 1, RW, "VP8 qpChDequantDc 8b"),
    H1REG(HEncVp8ChDequantAc      , 0x088, 0x03fe0000, 17, 1, RW, "VP8 qpChDequantAc 9b"),
    H1REG(HEncVp8MvRefIdx2        , 0x088, 0x0c000000, 26, 0, RW, "VP8 mvRefIdx for second reference frame. 0=ipf. 1=grf. 2=arf."),
    H1REG(HEncVp8Ref2Enable       , 0x088, 0x10000000, 28, 0, RW, "VP8 enable for second reference frame."),
    H1REG(HEncVp8SegmentEnable    , 0x088, 0x20000000, 29, 1, RW, "VP8 enable for segmentation. Segmentation map is stored in BaseSegmentMap."),
    H1REG(HEncVp8SegmentMapUpdate , 0x088, 0x40000000, 30, 0, RW, "VP8 enable for segmentation map update. Map is different from previous frame and is written in stream. "),
    H1REG(HEncVp8DeadzoneEnable   , 0x088, 0x80000000, 31, 0, RW, "VP8 enable for deadzone."),
    H1REG(HEncVp8BoolEncValue     , 0x08C, 0xffffffff,  0, 1, RW, "VP8 boolEncValue"),
    H1REG(HEncVp8GoldenPenalty    , 0x090, 0xff000000, 24, 0, RW, "VP8 Penalty value for second reference frame zero-mv [0..255]"),
    H1REG(HEncVp8FilterSharpness  , 0x090, 0x00e00000, 21, 0, RW, "VP8 Deblocking filter sharpness [0..7]"),
    H1REG(HEncVp8FilterLevel      , 0x090, 0x001f8000, 15, 0, RW, "VP8 Deblocking filter level [0..63]"),
    H1REG(HEncVp8DctPartitionCount, 0x090, 0x00006000, 13, 0, RW, "VP8 DCT partition count. 0=1. 1=2. 2=4 [0..2]"),
    H1REG(HEncVp8BoolEncValueBits , 0x090, 0x00001f00,  8, 1, RW, "VP8 boolEncValueBitsMinus8 [0..23]"),
    H1REG(HEncVp8BoolEncRange     , 0x090, 0x000000ff,  0, 1, RW, "VP8 boolEncRange [0..255]"),

    H1REG(HEncIpolFilterMode   , 0x094, 0x80000000, 31, 0, RW, "Mode for VP8 interpolation filter. 0=bicubic. 1=bilinear."),
    H1REG(HEncStartOffset      , 0x094, 0x1f800000, 23, 0, RW, "Stream start offset = amount of StrmHdrRem (bits) [0..63]"),
    H1REG(HEncRlcSum           , 0x094, 0x007fffff,  0, 0, RW, "RLC codeword count div4 output. max 255*255*384/4"),
    H1REG(HEncMadCount         , 0x098, 0xffff0000, 16, 0, RW, "Macroblock count with MAD value under threshold output"),
    H1REG(HEncMbCount          , 0x098, 0x0000ffff,  0, 0, RW, "MB count output. max 255*255"),
/* Stabilization parameters and outputs */
    H1REG(HEncBaseNextLum      , 0x09c, 0xffffffff,  0, 0, RW, "Base address for next pic luminance"),
    H1REG(HEncStabMode         , 0x0a0, 0xc0000000, 30, 1, RW, "Stabilization mode. 0=disabled. 1=stab only. 2=stab+encode"),
    H1REG(HEncStabMinimum      , 0x0a0, 0x00ffffff,  0, 0, RW, "Stabilization minimum value output. max 253*253*255"),
    H1REG(HEncStabMotionSum    , 0x0a4, 0xffffffff,  0, 0, RW, "Stabilization motion sum div8 output. max 253*253*255*1089/8"),
    H1REG(HEncStabGmvX         , 0x0a8, 0xfc000000, 26, 0, RW, "Stabilization GMV horizontal output [-16..16]"),
    H1REG(HEncStabMatrix1      , 0x0a8, 0x00ffffff,  0, 0, RW, "Stabilization matrix 1 (up-left position) output"),
    H1REG(HEncStabGmvY         , 0x0ac, 0xfc000000, 26, 0, RW, "Stabilization GMV vertical output [-16..16]"),
    H1REG(HEncStabMatrix2      , 0x0ac, 0x00ffffff,  0, 0, RW, "Stabilization matrix 2 (up position) output"),
    H1REG(HEncStabMatrix3      , 0x0b0, 0x00ffffff,  0, 0, RW, "Stabilization matrix 3 (up-right position) output"),
    H1REG(HEncStabMatrix4      , 0x0b4, 0x00ffffff,  0, 0, RW, "Stabilization matrix 4 (left position) output"),
    H1REG(HEncStabMatrix5      , 0x0b8, 0x00ffffff,  0, 0, RW, "Stabilization matrix 5 (GMV position) output"),
    H1REG(HEncStabMatrix6      , 0x0bc, 0x00ffffff,  0, 0, RW, "Stabilization matrix 6 (right position) output"),
    H1REG(HEncStabMatrix7      , 0x0c0, 0x00ffffff,  0, 0, RW, "Stabilization matrix 7 (down-left position) output"),
    H1REG(HEncStabMatrix8      , 0x0c4, 0x00ffffff,  0, 0, RW, "Stabilization matrix 8 (down position) output"),
    H1REG(HEncStabMatrix9      , 0x0c8, 0x00ffffff,  0, 0, RW, "Stabilization matrix 9 (down-right position) output"),
    H1REG(HEncBaseCabacCtx     , 0x0cc, 0xffffffff,  0, 0, RW, "Base address for cabac context tables (H264) or probability tables (VP8)"),
    H1REG(HEncBaseMvWrite      , 0x0d0, 0xffffffff,  0, 0, RW, "Base address for MV output writing"),
/* Pre-processor color conversion parameters */
    H1REG(HEncRGBCoeffA        , 0x0d4, 0x0000ffff,  0, 0, RW, "RGB to YUV conversion coefficient A"),
    H1REG(HEncRGBCoeffB        , 0x0d4, 0xffff0000, 16, 0, RW, "RGB to YUV conversion coefficient B"),
    H1REG(HEncRGBCoeffC        , 0x0d8, 0x0000ffff,  0, 0, RW, "RGB to YUV conversion coefficient C"),
    H1REG(HEncRGBCoeffE        , 0x0d8, 0xffff0000, 16, 0, RW, "RGB to YUV conversion coefficient E"),
    H1REG(HEncRGBCoeffF        , 0x0dc, 0x0000ffff,  0, 0, RW, "RGB to YUV conversion coefficient F"),
    H1REG(HEncRMaskMSB         , 0x0dc, 0x001f0000, 16, 0, RW, "RGB R-component mask MSB bit position [0..31]"),
    H1REG(HEncGMaskMSB         , 0x0dc, 0x03e00000, 21, 0, RW, "RGB G-component mask MSB bit position [0..31]"),
    H1REG(HEncBMaskMSB         , 0x0dc, 0x7c000000, 26, 0, RW, "RGB B-component mask MSB bit position [0..31]"),
    H1REG(HEncIntraAreaLeft    , 0x0e0, 0xff000000, 24, 0, RW, "Intra area left mb column (inside area) [0..255]"),
    H1REG(HEncIntraAreaRight   , 0x0e0, 0x00ff0000, 16, 0, RW, "Intra area right mb column (outside area) [0..255]"),
    H1REG(HEncIntraAreaTop     , 0x0e0, 0x0000ff00,  8, 0, RW, "Intra area top mb row (inside area) [0..255]"),
    H1REG(HEncIntraAreaBottom  , 0x0e0, 0x000000ff,  0, 0, RW, "Intra area bottom mb row (outside area) [0..255]"),
    H1REG(HEncCirStart         , 0x0e4, 0xffff0000, 16, 0, RW, "CIR first intra mb. 0=disabled [0..65535]"),
    H1REG(HEncCirInterval      , 0x0e4, 0x0000ffff,  0, 0, RW, "CIR intra mb interval. 0=disabled [0..65535]"),

/* H264 / VP8 mixed definitions */
    H1REG(HEncIntraSliceMap1   , 0x0e8, 0xffffffff,  0, 0, RW, "Intra slice bitmap for slices 0..31. LSB=slice0. MSB=slice31. 1=intra."),
    H1REG(HEncIntraSliceMap2   , 0x0ec, 0xffffffff,  0, 0, RW, "Intra slice bitmap for slices 32..63. LSB=slice32. MSB=slice63. 1=intra."),
    H1REG(HEncIntraSliceMap3   , 0x068, 0xffffffff,  0, 0, RW, "Intra slice bitmap for slices 64..95. LSB=slice64. MSB=slice95. 1=intra."),
    H1REG(HEncBasePartition1   , 0x0e8, 0xffffffff,  0, 0, RW, "Base address for VP8 1st DCT partition"),
    H1REG(HEncBasePartition2   , 0x0ec, 0xffffffff,  0, 0, RW, "Base address for VP8 2nd DCT partition"),
    H1REG(HEncBaseVp8ProbCount , 0x068, 0xffffffff,  0, 0, RW, "Base address for VP8 counters for probability updates"),

    H1REG(HEncRoi1Left         , 0x0f0, 0xff000000, 24, 0, RW, "1st ROI area left mb column (inside area) qp+=Roi1DeltaQp"),
    H1REG(HEncRoi1Right        , 0x0f0, 0x00ff0000, 16, 0, RW, "1st ROI area right mb column (outside area) qp-=Roi1DeltaQp"),
    H1REG(HEncRoi1Top          , 0x0f0, 0x0000ff00,  8, 0, RW, "1st ROI area top mb row (inside area)"),
    H1REG(HEncRoi1Bottom       , 0x0f0, 0x000000ff,  0, 0, RW, "1st ROI area bottom mb row (outside area)"),
    H1REG(HEncRoi2Left         , 0x0f4, 0xff000000, 24, 0, RW, "2nd ROI area left mb column (inside area) qp+=Roi2DeltaQp"),
    H1REG(HEncRoi2Right        , 0x0f4, 0x00ff0000, 16, 0, RW, "2nd ROI area right mb column (outside area) qp-=Roi2DeltaQp"),
    H1REG(HEncRoi2Top          , 0x0f4, 0x0000ff00,  8, 0, RW, "2nd ROI area top mb row (inside area)"),
    H1REG(HEncRoi2Bottom       , 0x0f4, 0x000000ff,  0, 0, RW, "2nd ROI area bottom mb row (outside area)"),
    H1REG(HEncRoi1DeltaQp      , 0x0f8, 0x000000f0,  4, 0, RW, "1st ROI area delta QP. qp = Qp - Roi1DeltaQp [0..15]"),
    H1REG(HEncRoi2DeltaQp      , 0x0f8, 0x0000000f,  0, 0, RW, "2nd ROI area delta QP. qp = Qp - Roi2DeltaQp [0..15]"),
    H1REG(HEncZeroMvFavor      , 0x0f8, 0xf0000000, 28, 0, RW, "Zero 16x16 MV favor div2."),
    H1REG(HEncSplitPenalty4x4  , 0x0f8, 0x0ff80000, 19, 0, RW, "Penalty for using 4x4 MV."),
    H1REG(HEncMvcPriorityId    , 0x0f8, 0x00070000, 16, 0, RW, "MVC priority_id [0..7]"),
    H1REG(HEncMvcViewId        , 0x0f8, 0x0000e000, 13, 0, RW, "MVC view_id [0..7]"),
    H1REG(HEncMvcTemporalId    , 0x0f8, 0x00001c00, 10, 0, RW, "MVC temporal_id [0..7]"),
    H1REG(HEncMvcAnchorPicFlag , 0x0f8, 0x00000200,  9, 0, RW, "MVC anchor_pic_flag. Specifies that the picture is part of an anchor access unit."),
    H1REG(HEncMvcInterViewFlag , 0x0f8, 0x00000100,  8, 0, RW, "MVC inter_view_flag. Specifies that the picture is used for inter-view prediction."),

/* HW synthesis config register, read-only */
    H1REG(HEncHWChSearchArea   , 0x0fc, 0x80000000, 31, 0, RO, "HW Chrominance search area internal buffer. 0=not supported. 1=supported."),
    H1REG(HEncHWScalingSupport , 0x0fc, 0x40000000, 30, 0, RO, "Down-scaling supported by HW. 0=not supported. 1=supported"),
    H1REG(HEncHWSearchArea     , 0x0fc, 0x20000000, 29, 0, RO, "HW search area height. 0=5 MB rows. 1=3 MB rows"),
    H1REG(HEncHWRgbSupport     , 0x0fc, 0x10000000, 28, 0, RO, "RGB to YUV conversion supported by HW. 0=not supported. 1=supported"),
    H1REG(HEncHWH264Support    , 0x0fc, 0x08000000, 27, 0, RO, "H.264 encoding supported by HW. 0=not supported. 1=supported"),
    H1REG(HEncHWVp8Support     , 0x0fc, 0x04000000, 26, 0, RO, "VP8 encoding supported by HW. 0=not supported. 1=supported"),
    H1REG(HEncHWJpegSupport    , 0x0fc, 0x02000000, 25, 0, RO, "JPEG encoding supported by HW. 0=not supported. 1=supported"),
    H1REG(HEncHWStabSupport    , 0x0fc, 0x01000000, 24, 0, RO, "Stabilization supported by HW. 0=not supported. 1=supported"),
    H1REG(HEncHWBus            , 0x0fc, 0x00f00000, 20, 0, RO, "Bus connection of HW. 1=AHB. 2=OCP. 3=AXI. 4=PCI. 5=AXIAHB. 6=AXIAPB."),
    H1REG(HEncHWSynthesisLan   , 0x0fc, 0x000f0000, 16, 0, RO, "Synthesis language. 1=vhdl. 2=verilog"),
    H1REG(HEncHWBusWidth       , 0x0fc, 0x0000f000, 12, 0, RO, "Bus width of HW. 0=32b. 1=64b. 2=128b"),
    H1REG(HEncHWMaxVideoWidth  , 0x0fc, 0x00000fff,  0, 0, RO, "Maximum video width supported by HW (pixels)"),

/* JPEG / VP8 mixed definitions regs 0x100-0x17C */
    H1REG(HEncJpegQuantLuma1   , 0x100, 0xffffffff,  0, 0, RW, "JPEG luma quantization 1"),
    H1REG(HEncJpegQuantLuma2   , 0x104, 0xffffffff,  0, 0, RW, "JPEG luma quantization 2"),
    H1REG(HEncJpegQuantLuma3   , 0x108, 0xffffffff,  0, 0, RW, "JPEG luma quantization 3"),
    H1REG(HEncJpegQuantLuma4   , 0x10c, 0xffffffff,  0, 0, RW, "JPEG luma quantization 4"),
    H1REG(HEncJpegQuantLuma5   , 0x110, 0xffffffff,  0, 0, RW, "JPEG luma quantization 5"),
    H1REG(HEncJpegQuantLuma6   , 0x114, 0xffffffff,  0, 0, RW, "JPEG luma quantization 6"),
    H1REG(HEncJpegQuantLuma7   , 0x118, 0xffffffff,  0, 0, RW, "JPEG luma quantization 7"),
    H1REG(HEncJpegQuantLuma8   , 0x11c, 0xffffffff,  0, 0, RW, "JPEG luma quantization 8"),
    H1REG(HEncJpegQuantLuma9   , 0x120, 0xffffffff,  0, 0, RW, "JPEG luma quantization 9"),
    H1REG(HEncJpegQuantLuma10  , 0x124, 0xffffffff,  0, 0, RW, "JPEG luma quantization 10"),
    H1REG(HEncJpegQuantLuma11  , 0x128, 0xffffffff,  0, 0, RW, "JPEG luma quantization 11"),
    H1REG(HEncJpegQuantLuma12  , 0x12c, 0xffffffff,  0, 0, RW, "JPEG luma quantization 12"),
    H1REG(HEncJpegQuantLuma13  , 0x130, 0xffffffff,  0, 0, RW, "JPEG luma quantization 13"),
    H1REG(HEncJpegQuantLuma14  , 0x134, 0xffffffff,  0, 0, RW, "JPEG luma quantization 14"),
    H1REG(HEncJpegQuantLuma15  , 0x138, 0xffffffff,  0, 0, RW, "JPEG luma quantization 15"),
    H1REG(HEncJpegQuantLuma16  , 0x13c, 0xffffffff,  0, 0, RW, "JPEG luma quantization 16"),
    H1REG(HEncJpegQuantChroma1 , 0x140, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 1"),
    H1REG(HEncJpegQuantChroma2 , 0x144, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 2"),
    H1REG(HEncJpegQuantChroma3 , 0x148, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 3"),
    H1REG(HEncJpegQuantChroma4 , 0x14c, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 4"),
    H1REG(HEncJpegQuantChroma5 , 0x150, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 5"),
    H1REG(HEncJpegQuantChroma6 , 0x154, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 6"),
    H1REG(HEncJpegQuantChroma7 , 0x158, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 7"),
    H1REG(HEncJpegQuantChroma8 , 0x15c, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 8"),
    H1REG(HEncJpegQuantChroma9 , 0x160, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 9"),
    H1REG(HEncJpegQuantChroma10, 0x164, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 10"),
    H1REG(HEncJpegQuantChroma11, 0x168, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 11"),
    H1REG(HEncJpegQuantChroma12, 0x16c, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 12"),
    H1REG(HEncJpegQuantChroma13, 0x170, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 13"),
    H1REG(HEncJpegQuantChroma14, 0x174, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 14"),
    H1REG(HEncJpegQuantChroma15, 0x178, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 15"),
    H1REG(HEncJpegQuantChroma16, 0x17C, 0xffffffff,  0, 0, RW, "JPEG chroma quantization 16"),
    H1REG(HEncVp8Mode0Penalty     , 0x100, 0x000003ff,  0, 0, RW, "VP8 intra 16x16 mode 0 penalty"),
    H1REG(HEncVp8Mode1Penalty     , 0x100, 0x003ff000, 12, 0, RW, "VP8 intra 16x16 mode 1 penalty"),
    H1REG(HEncVp8Mode2Penalty     , 0x104, 0x000003ff,  0, 0, RW, "VP8 intra 16x16 mode 2 penalty"),
    H1REG(HEncVp8Mode3Penalty     , 0x104, 0x003ff000, 12, 0, RW, "VP8 intra 16x16 mode 3 penalty"),
    H1REG(HEncVp8Bmode0Penalty    , 0x108, 0x000003ff,  0, 0, RW, "VP8 intra 4x4 mode 0 penalty"),
    H1REG(HEncVp8Bmode1Penalty    , 0x108, 0x003ff000, 12, 0, RW, "VP8 intra 4x4 mode 1 penalty"),
    H1REG(HEncVp8Bmode2Penalty    , 0x10C, 0x000003ff,  0, 0, RW, "VP8 intra 4x4 mode 2 penalty"),
    H1REG(HEncVp8Bmode3Penalty    , 0x10C, 0x003ff000, 12, 0, RW, "VP8 intra 4x4 mode 3 penalty"),
    H1REG(HEncVp8Bmode4Penalty    , 0x110, 0x000003ff,  0, 0, RW, "VP8 intra 4x4 mode 4 penalty"),
    H1REG(HEncVp8Bmode5Penalty    , 0x110, 0x003ff000, 12, 0, RW, "VP8 intra 4x4 mode 5 penalty"),
    H1REG(HEncVp8Bmode6Penalty    , 0x114, 0x000003ff,  0, 0, RW, "VP8 intra 4x4 mode 6 penalty"),
    H1REG(HEncVp8Bmode7Penalty    , 0x114, 0x003ff000, 12, 0, RW, "VP8 intra 4x4 mode 7 penalty"),
    H1REG(HEncVp8Bmode8Penalty    , 0x118, 0x000003ff,  0, 0, RW, "VP8 intra 4x4 mode 8 penalty"),
    H1REG(HEncVp8Bmode9Penalty    , 0x118, 0x003ff000, 12, 0, RW, "VP8 intra 4x4 mode 9 penalty"),
    H1REG(HEncBaseVp8SegmentMap   , 0x11C, 0xffffffff,  0, 0, RW, "Base address for VP8 segmentation map, segmentId 2-bits/macroblock"),
    H1REG(HEncVp8Seg1Y1QuantDc    , 0x120, 0x00003fff,  0, 1, RW, "VP8 segment1 qpY1QuantDc 14b"),
    H1REG(HEncVp8Seg1Y1ZbinDc     , 0x120, 0x007fc000, 14, 1, RW, "VP8 segment1 qpY1ZbinDc 9b"),
    H1REG(HEncVp8Seg1Y1RoundDc    , 0x120, 0x7f800000, 23, 1, RW, "VP8 segment1 qpY1RoundDc 8b"),
    H1REG(HEncVp8Seg1Y1QuantAc    , 0x124, 0x00003fff,  0, 1, RW, "VP8 segment1 qpY1QuantAc 14b"),
    H1REG(HEncVp8Seg1Y1ZbinAc     , 0x124, 0x007fc000, 14, 1, RW, "VP8 segment1 qpY1ZbinAc 9b"),
    H1REG(HEncVp8Seg1Y1RoundAc    , 0x124, 0x7f800000, 23, 1, RW, "VP8 segment1 qpY1RoundAc 8b"),
    H1REG(HEncVp8Seg1Y2QuantDc    , 0x128, 0x00003fff,  0, 1, RW, "VP8 segment1 qpY2QuantDc 14b"),
    H1REG(HEncVp8Seg1Y2ZbinDc     , 0x128, 0x007fc000, 14, 1, RW, "VP8 segment1 qpY2ZbinDc 9b"),
    H1REG(HEncVp8Seg1Y2RoundDc    , 0x128, 0x7f800000, 23, 1, RW, "VP8 segment1 qpY2RoundDc 8b"),
    H1REG(HEncVp8Seg1Y2QuantAc    , 0x12C, 0x00003fff,  0, 1, RW, "VP8 segment1 qpY2QuantAc 14b"),
    H1REG(HEncVp8Seg1Y2ZbinAc     , 0x12C, 0x007fc000, 14, 1, RW, "VP8 segment1 qpY2ZbinAc 9b"),
    H1REG(HEncVp8Seg1Y2RoundAc    , 0x12C, 0x7f800000, 23, 1, RW, "VP8 segment1 qpY2RoundAc 8b"),
    H1REG(HEncVp8Seg1ChQuantDc    , 0x130, 0x00003fff,  0, 1, RW, "VP8 segment1 qpChQuantDc 14b"),
    H1REG(HEncVp8Seg1ChZbinDc     , 0x130, 0x007fc000, 14, 1, RW, "VP8 segment1 qpChZbinDc 9b"),
    H1REG(HEncVp8Seg1ChRoundDc    , 0x130, 0x7f800000, 23, 1, RW, "VP8 segment1 qpChRoundDc 8b"),
    H1REG(HEncVp8Seg1ChQuantAc    , 0x134, 0x00003fff,  0, 1, RW, "VP8 segment1 qpChQuantAc 14b"),
    H1REG(HEncVp8Seg1ChZbinAc     , 0x134, 0x007fc000, 14, 1, RW, "VP8 segment1 qpChZbinAc 9b"),
    H1REG(HEncVp8Seg1ChRoundAc    , 0x134, 0x7f800000, 23, 1, RW, "VP8 segment1 qpChRoundAc 8b"),
    H1REG(HEncVp8Seg1Y1DequantDc  , 0x138, 0x000000ff,  0, 1, RW, "VP8 segment1 qpY1DequantDc 8b"),
    H1REG(HEncVp8Seg1Y1DequantAc  , 0x138, 0x0001ff00,  8, 1, RW, "VP8 segment1 qpY1DequantAc 9b"),
    H1REG(HEncVp8Seg1Y2DequantDc  , 0x138, 0x03fe0000, 17, 1, RW, "VP8 segment1 qpY2DequantDc 9b"),
    H1REG(HEncVp8Seg1Y2DequantAc  , 0x13C, 0x000001ff,  0, 1, RW, "VP8 segment1 qpY2DequantAc 9b"),
    H1REG(HEncVp8Seg1ChDequantDc  , 0x13C, 0x0001fe00,  9, 1, RW, "VP8 segment1 qpChDequantDc 8b"),
    H1REG(HEncVp8Seg1ChDequantAc  , 0x13C, 0x03fe0000, 17, 1, RW, "VP8 segment1 qpChDequantAc 9b"),
    H1REG(HEncVp8Seg1FilterLevel  , 0x13C, 0xfc000000, 26, 1, RW, "VP8 segment1 filter level 6b"),
    H1REG(HEncVp8Seg2Y1QuantDc    , 0x140, 0x00003fff,  0, 1, RW, "VP8 segment2 qpY1QuantDc 14b"),
    H1REG(HEncVp8Seg2Y1ZbinDc     , 0x140, 0x007fc000, 14, 1, RW, "VP8 segment2 qpY1ZbinDc 9b"),
    H1REG(HEncVp8Seg2Y1RoundDc    , 0x140, 0x7f800000, 23, 1, RW, "VP8 segment2 qpY1RoundDc 8b"),
    H1REG(HEncVp8Seg2Y1QuantAc    , 0x144, 0x00003fff,  0, 1, RW, "VP8 segment2 qpY1QuantAc 14b"),
    H1REG(HEncVp8Seg2Y1ZbinAc     , 0x144, 0x007fc000, 14, 1, RW, "VP8 segment2 qpY1ZbinAc 9b"),
    H1REG(HEncVp8Seg2Y1RoundAc    , 0x144, 0x7f800000, 23, 1, RW, "VP8 segment2 qpY1RoundAc 8b"),
    H1REG(HEncVp8Seg2Y2QuantDc    , 0x148, 0x00003fff,  0, 1, RW, "VP8 segment2 qpY2QuantDc 14b"),
    H1REG(HEncVp8Seg2Y2ZbinDc     , 0x148, 0x007fc000, 14, 1, RW, "VP8 segment2 qpY2ZbinDc 9b"),
    H1REG(HEncVp8Seg2Y2RoundDc    , 0x148, 0x7f800000, 23, 1, RW, "VP8 segment2 qpY2RoundDc 8b"),
    H1REG(HEncVp8Seg2Y2QuantAc    , 0x14C, 0x00003fff,  0, 1, RW, "VP8 segment2 qpY2QuantAc 14b"),
    H1REG(HEncVp8Seg2Y2ZbinAc     , 0x14C, 0x007fc000, 14, 1, RW, "VP8 segment2 qpY2ZbinAc 9b"),
    H1REG(HEncVp8Seg2Y2RoundAc    , 0x14C, 0x7f800000, 23, 1, RW, "VP8 segment2 qpY2RoundAc 8b"),
    H1REG(HEncVp8Seg2ChQuantDc    , 0x150, 0x00003fff,  0, 1, RW, "VP8 segment2 qpChQuantDc 14b"),
    H1REG(HEncVp8Seg2ChZbinDc     , 0x150, 0x007fc000, 14, 1, RW, "VP8 segment2 qpChZbinDc 9b"),
    H1REG(HEncVp8Seg2ChRoundDc    , 0x150, 0x7f800000, 23, 1, RW, "VP8 segment2 qpChRoundDc 8b"),
    H1REG(HEncVp8Seg2ChQuantAc    , 0x154, 0x00003fff,  0, 1, RW, "VP8 segment2 qpChQuantAc 14b"),
    H1REG(HEncVp8Seg2ChZbinAc     , 0x154, 0x007fc000, 14, 1, RW, "VP8 segment2 qpChZbinAc 9b"),
    H1REG(HEncVp8Seg2ChRoundAc    , 0x154, 0x7f800000, 23, 1, RW, "VP8 segment2 qpChRoundAc 8b"),
    H1REG(HEncVp8Seg2Y1DequantDc  , 0x158, 0x000000ff,  0, 1, RW, "VP8 segment2 qpY1DequantDc 8b"),
    H1REG(HEncVp8Seg2Y1DequantAc  , 0x158, 0x0001ff00,  8, 1, RW, "VP8 segment2 qpY1DequantAc 9b"),
    H1REG(HEncVp8Seg2Y2DequantDc  , 0x158, 0x03fe0000, 17, 1, RW, "VP8 segment2 qpY2DequantDc 9b"),
    H1REG(HEncVp8Seg2Y2DequantAc  , 0x15C, 0x000001ff,  0, 1, RW, "VP8 segment2 qpY2DequantAc 9b"),
    H1REG(HEncVp8Seg2ChDequantDc  , 0x15C, 0x0001fe00,  9, 1, RW, "VP8 segment2 qpChDequantDc 8b"),
    H1REG(HEncVp8Seg2ChDequantAc  , 0x15C, 0x03fe0000, 17, 1, RW, "VP8 segment2 qpChDequantAc 9b"),
    H1REG(HEncVp8Seg2FilterLevel  , 0x15C, 0xfc000000, 26, 1, RW, "VP8 segment2 filter level 6b"),
    H1REG(HEncVp8Seg3Y1QuantDc    , 0x160, 0x00003fff,  0, 1, RW, "VP8 segment3 qpY1QuantDc 14b"),
    H1REG(HEncVp8Seg3Y1ZbinDc     , 0x160, 0x007fc000, 14, 1, RW, "VP8 segment3 qpY1ZbinDc 9b"),
    H1REG(HEncVp8Seg3Y1RoundDc    , 0x160, 0x7f800000, 23, 1, RW, "VP8 segment3 qpY1RoundDc 8b"),
    H1REG(HEncVp8Seg3Y1QuantAc    , 0x164, 0x00003fff,  0, 1, RW, "VP8 segment3 qpY1QuantAc 14b"),
    H1REG(HEncVp8Seg3Y1ZbinAc     , 0x164, 0x007fc000, 14, 1, RW, "VP8 segment3 qpY1ZbinAc 9b"),
    H1REG(HEncVp8Seg3Y1RoundAc    , 0x164, 0x7f800000, 23, 1, RW, "VP8 segment3 qpY1RoundAc 8b"),
    H1REG(HEncVp8Seg3Y2QuantDc    , 0x168, 0x00003fff,  0, 1, RW, "VP8 segment3 qpY2QuantDc 14b"),
    H1REG(HEncVp8Seg3Y2ZbinDc     , 0x168, 0x007fc000, 14, 1, RW, "VP8 segment3 qpY2ZbinDc 9b"),
    H1REG(HEncVp8Seg3Y2RoundDc    , 0x168, 0x7f800000, 23, 1, RW, "VP8 segment3 qpY2RoundDc 8b"),
    H1REG(HEncVp8Seg3Y2QuantAc    , 0x16C, 0x00003fff,  0, 1, RW, "VP8 segment3 qpY2QuantAc 14b"),
    H1REG(HEncVp8Seg3Y2ZbinAc     , 0x16C, 0x007fc000, 14, 1, RW, "VP8 segment3 qpY2ZbinAc 9b"),
    H1REG(HEncVp8Seg3Y2RoundAc    , 0x16C, 0x7f800000, 23, 1, RW, "VP8 segment3 qpY2RoundAc 8b"),
    H1REG(HEncVp8Seg3ChQuantDc    , 0x170, 0x00003fff,  0, 1, RW, "VP8 segment3 qpChQuantDc 14b"),
    H1REG(HEncVp8Seg3ChZbinDc     , 0x170, 0x007fc000, 14, 1, RW, "VP8 segment3 qpChZbinDc 9b"),
    H1REG(HEncVp8Seg3ChRoundDc    , 0x170, 0x7f800000, 23, 1, RW, "VP8 segment3 qpChRoundDc 8b"),
    H1REG(HEncVp8Seg3ChQuantAc    , 0x174, 0x00003fff,  0, 1, RW, "VP8 segment3 qpChQuantAc 14b"),
    H1REG(HEncVp8Seg3ChZbinAc     , 0x174, 0x007fc000, 14, 1, RW, "VP8 segment3 qpChZbinAc 9b"),
    H1REG(HEncVp8Seg3ChRoundAc    , 0x174, 0x7f800000, 23, 1, RW, "VP8 segment3 qpChRoundAc 8b"),
    H1REG(HEncVp8Seg3Y1DequantDc  , 0x178, 0x000000ff,  0, 1, RW, "VP8 segment3 qpY1DequantDc 8b"),
    H1REG(HEncVp8Seg3Y1DequantAc  , 0x178, 0x0001ff00,  8, 1, RW, "VP8 segment3 qpY1DequantAc 9b"),
    H1REG(HEncVp8Seg3Y2DequantDc  , 0x178, 0x03fe0000, 17, 1, RW, "VP8 segment3 qpY2DequantDc 9b"),
    H1REG(HEncVp8Seg3Y2DequantAc  , 0x17C, 0x000001ff,  0, 1, RW, "VP8 segment3 qpY2DequantAc 9b"),
    H1REG(HEncVp8Seg3ChDequantDc  , 0x17C, 0x0001fe00,  9, 1, RW, "VP8 segment3 qpChDequantDc 8b"),
    H1REG(HEncVp8Seg3ChDequantAc  , 0x17C, 0x03fe0000, 17, 1, RW, "VP8 segment3 qpChDequantAc 9b"),
    H1REG(HEncVp8Seg3FilterLevel  , 0x17C, 0xfc000000, 26, 1, RW, "VP8 segment3 filter level 6b"),

    H1REG(HEncDmvPenalty1         , 0x180, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values 0-3"),
    H1REG(HEncDmvPenalty2         , 0x184, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values 4-7"),
    H1REG(HEncDmvPenalty3         , 0x188, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty4         , 0x18C, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty5         , 0x190, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty6         , 0x194, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty7         , 0x198, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty8         , 0x19C, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty9         , 0x1A0, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty10        , 0x1A4, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty11        , 0x1A8, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty12        , 0x1AC, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty13        , 0x1B0, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty14        , 0x1B4, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty15        , 0x1B8, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty16        , 0x1BC, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty17        , 0x1C0, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty18        , 0x1C4, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty19        , 0x1C8, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty20        , 0x1CC, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty21        , 0x1D0, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty22        , 0x1D4, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty23        , 0x1D8, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty24        , 0x1DC, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty25        , 0x1E0, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty26        , 0x1E4, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty27        , 0x1E8, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty28        , 0x1EC, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty29        , 0x1F0, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty30        , 0x1F4, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty31        , 0x1F8, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values"),
    H1REG(HEncDmvPenalty32        , 0x1FC, 0xffffffff,  0, 0, WO, "DMV 4p/1p penalty values 124-127"),

    H1REG(HEncDmvQpelPenalty1     , 0x200, 0xffffffff,  0, 0, WO, "DMV qpel penalty values 0-3"),
    H1REG(HEncDmvQpelPenalty2     , 0x204, 0xffffffff,  0, 0, WO, "DMV qpel penalty values 4-7"),
    H1REG(HEncDmvQpelPenalty3     , 0x208, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty4     , 0x20C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty5     , 0x210, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty6     , 0x214, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty7     , 0x218, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty8     , 0x21C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty9     , 0x220, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty10    , 0x224, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty11    , 0x228, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty12    , 0x22C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty13    , 0x230, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty14    , 0x234, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty15    , 0x238, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty16    , 0x23C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty17    , 0x240, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty18    , 0x244, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty19    , 0x248, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty20    , 0x24C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty21    , 0x250, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty22    , 0x254, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty23    , 0x258, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty24    , 0x25C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty25    , 0x260, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty26    , 0x264, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty27    , 0x268, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty28    , 0x26C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty29    , 0x270, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty30    , 0x274, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty31    , 0x278, 0xffffffff,  0, 0, WO, "DMV qpel penalty values"),
    H1REG(HEncDmvQpelPenalty32    , 0x27C, 0xffffffff,  0, 0, WO, "DMV qpel penalty values 124-127"),

    H1REG(HEncVp8CostInter        , 0x280, 0x00000fff,  0, 1, RW, "VP8 bit cost of inter type"),
    H1REG(HEncVp8DmvCostConst     , 0x280, 0x00fff000, 12, 1, RW, "VP8 coeff for dmv penalty for intra/inter selection"),
    H1REG(HEncSplitZeroPenalty    , 0x280, 0xff000000, 24, 1, RW, "Penalty for using zero-MV in 16x8/8x16/8x8 split"),
    H1REG(HEncVp8CostGoldenRef    , 0x284, 0x00000fff,  0, 1, RW, "VP8 bit cost of golden ref frame (not used)"),

    H1REG(HEncVp8LfRefDelta0      , 0x288, 0x0000007f,  0, 1, RW, "VP8 loop filter delta for intra mb"),
    H1REG(HEncVp8LfRefDelta1      , 0x288, 0x00003f80,  7, 1, RW, "VP8 loop filter delta for last ref"),
    H1REG(HEncVp8LfRefDelta2      , 0x288, 0x001fc000, 14, 1, RW, "VP8 loop filter delta for golden ref"),
    H1REG(HEncVp8LfRefDelta3      , 0x288, 0x0fe00000, 21, 1, RW, "VP8 loop filter delta for alt ref"),
    H1REG(HEncVp8LfModeDelta0     , 0x28C, 0x0000007f,  0, 1, RW, "VP8 loop filter delta for BPRED"),
    H1REG(HEncVp8LfModeDelta1     , 0x28C, 0x00003f80,  7, 1, RW, "VP8 loop filter delta for ZEROMV"),
    H1REG(HEncVp8LfModeDelta2     , 0x28C, 0x001fc000, 14, 1, RW, "VP8 loop filter delta for NEWMV"),
    H1REG(HEncVp8LfModeDelta3     , 0x28C, 0x0fe00000, 21, 1, RW, "VP8 loop filter delta for SPLITMV"),

    H1REG(HEncVp8DzCoeffRate0     , 0x290, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate1     , 0x294, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate2     , 0x298, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate3     , 0x29C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate4     , 0x2A0, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate5     , 0x2A4, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate6     , 0x2A8, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate7     , 0x2AC, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate8     , 0x2B0, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate9     , 0x2B4, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate10    , 0x2B8, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate11    , 0x2BC, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate12    , 0x2C0, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate13    , 0x2C4, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate14    , 0x2C8, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate15    , 0x2CC, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate16    , 0x2D0, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate17    , 0x2D4, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate18    , 0x2D8, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate19    , 0x2DC, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate20    , 0x2E0, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate21    , 0x2E4, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate22    , 0x2E8, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate23    , 0x2EC, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate24    , 0x2F0, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate25    , 0x2F4, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate26    , 0x2F8, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate27    , 0x2FC, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate28    , 0x300, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate29    , 0x304, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate30    , 0x308, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate31    , 0x30C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate32    , 0x310, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate33    , 0x314, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate34    , 0x318, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate35    , 0x31C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate36    , 0x320, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate37    , 0x324, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate38    , 0x328, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate39    , 0x32C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate40    , 0x330, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate41    , 0x334, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate42    , 0x338, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate43    , 0x33C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate44    , 0x340, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate45    , 0x344, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate46    , 0x348, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzCoeffRate47    , 0x34C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),

    H1REG(HEncVp8DzEobRate0       , 0x350, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate1       , 0x354, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate2       , 0x358, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate3       , 0x35C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate4       , 0x360, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate5       , 0x364, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate6       , 0x368, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate7       , 0x36C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate8       , 0x370, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate9       , 0x374, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate10      , 0x378, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate11      , 0x37C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate12      , 0x380, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate13      , 0x384, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate14      , 0x388, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),
    H1REG(HEncVp8DzEobRate15      , 0x38C, 0xffffffff,  0, 0, RW, "VP8 deadzone lookup table"),

    H1REG(HEncVp8DzRateM0         , 0x390, 0x3fff0000, 16, 0, RW, "VP8 deadzone rate multiplier for plane 0"),
    H1REG(HEncVp8DzRateM1         , 0x390, 0x00003fff,  0, 0, RW, "VP8 deadzone rate multiplier for plane 1"),
    H1REG(HEncVp8DzRateM2         , 0x394, 0x3fff0000, 16, 0, RW, "VP8 deadzone rate multiplier for plane 2"),
    H1REG(HEncVp8DzRateM3         , 0x394, 0x00003fff,  0, 0, RW, "VP8 deadzone rate multiplier for plane 3"),

    H1REG(HEncVp8DzSkipRate0      , 0x398, 0x003ff000, 12, 0, RW, "VP8 deadzone rate for macroblock skip token 0"),
    H1REG(HEncVp8DzSkipRate1      , 0x398, 0x000003ff,  0, 0, RW, "VP8 deadzone rate for macroblock skip token 1"),

    H1REG(HEncBaseScaledOutLum    , 0x39C, 0xffffffff,  0, 0, RW, "Base address for output of down-scaled encoder image in YUYV 4:2:2 format"),
    H1REG(HEncScaleMode           , 0x3A0, 0xc0000000, 30, 1, RW, "Scaling mode. ScalingMode. 0=disabled. 1=scaling only. 2=scale+encode"),
    H1REG(HEncScaledOutWidth      , 0x3A0, 0x1ffe0000, 17, 1, RW, "Scaling width of down-scaled image. ScaledWidth. [96..4076]"),
    H1REG(HEncScaledOutWidthRatio , 0x3A0, 0x0001ffff,  0, 0, RW, "Scaling ratio for width of down-scaled image. Fixed point integer 1.16."),
    H1REG(HEncScaledOutHeight     , 0x3A4, 0x1ffe0000, 17, 1, RW, "Scaling width of down-scaled image. ScaledHeight. [2..4078]"),
    H1REG(HEncScaledOutHeightRatio, 0x3A4, 0x0001ffff,  0, 0, RW, "Scaling ratio for height of down-scaled image. Fixed point integer 1.16."),

    H1REG(HEncSquaredError        , 0x3B0, 0xffffffff,  0, 0, RW, "Squared error output calculated for 13x13 pixels per macroblock. 32-bit max"),

    H1REG(HEncMadThreshold2       , 0x3B4, 0x3f000000, 24, 0, RW, "MAD threshold div256. MadThreshold2 < MadThreshold"),
    H1REG(HEncMadQpDelta2         , 0x3B4, 0x00ff0000, 16, 0, RW, "MAD based QP adjustment. madQpChange [-127..127]"),
    H1REG(HEncMadCount2           , 0x3B4, 0x0000ffff,  0, 0, RW, "Macroblock count with MAD value under threshold output"),

    H1REG(HEncMadThreshold3       , 0x3B8, 0x3f000000, 24, 0, RW, "MAD threshold div256. MadThreshold3 < MadThreshold2"),
    H1REG(HEncMadQpDelta3         , 0x3B8, 0x00ff0000, 16, 0, RW, "MAD based QP adjustment. madQpChange [-127..127]"),
    H1REG(HEncMadCount3           , 0x3B8, 0x0000ffff,  0, 0, RW, "Macroblock count with MAD value under threshold output"),

    H1REG(HEncVp8IpolCoeff01      , 0x3BC, 0xe0000000, 29, 0, RW, "VP8 predictor interpolation coefficient for full pixel position tap=1"),
    H1REG(HEncVp8IpolCoeff02      , 0x3BC, 0x1f000000, 24, 0, RW, "VP8 predictor interpolation coefficient for full pixel position tap=2"),
    H1REG(HEncVp8IpolCoeff03      , 0x3BC, 0x00ff0000, 16, 0, RW, "VP8 predictor interpolation coefficient for full pixel position tap=3"),
    H1REG(HEncVp8IpolCoeff04      , 0x3BC, 0x0000ff00,  8, 0, RW, "VP8 predictor interpolation coefficient for full pixel position tap=4"),
    H1REG(HEncVp8IpolCoeff05      , 0x3BC, 0x000000f8,  3, 0, RW, "VP8 predictor interpolation coefficient for full pixel position tap=5"),
    H1REG(HEncVp8IpolCoeff06      , 0x3BC, 0x00000007,  0, 0, RW, "VP8 predictor interpolation coefficient for full pixel position tap=6"),
    H1REG(HEncVp8IpolCoeff11      , 0x3C0, 0xe0000000, 29, 0, RW, "VP8 predictor interpolation coefficient for 1/8 pixel position tap=1"),
    H1REG(HEncVp8IpolCoeff12      , 0x3C0, 0x1f000000, 24, 0, RW, "VP8 predictor interpolation coefficient for 1/8 pixel position tap=2"),
    H1REG(HEncVp8IpolCoeff13      , 0x3C0, 0x00ff0000, 16, 0, RW, "VP8 predictor interpolation coefficient for 1/8 pixel position tap=3"),
    H1REG(HEncVp8IpolCoeff14      , 0x3C0, 0x0000ff00,  8, 0, RW, "VP8 predictor interpolation coefficient for 1/8 pixel position tap=4"),
    H1REG(HEncVp8IpolCoeff15      , 0x3C0, 0x000000f8,  3, 0, RW, "VP8 predictor interpolation coefficient for 1/8 pixel position tap=5"),
    H1REG(HEncVp8IpolCoeff16      , 0x3C0, 0x00000007,  0, 0, RW, "VP8 predictor interpolation coefficient for 1/8 pixel position tap=6"),
    H1REG(HEncVp8IpolCoeff21      , 0x3C4, 0xe0000000, 29, 0, RW, "VP8 predictor interpolation coefficient for 2/8 pixel position tap=1"),
    H1REG(HEncVp8IpolCoeff22      , 0x3C4, 0x1f000000, 24, 0, RW, "VP8 predictor interpolation coefficient for 2/8 pixel position tap=2"),
    H1REG(HEncVp8IpolCoeff23      , 0x3C4, 0x00ff0000, 16, 0, RW, "VP8 predictor interpolation coefficient for 2/8 pixel position tap=3"),
    H1REG(HEncVp8IpolCoeff24      , 0x3C4, 0x0000ff00,  8, 0, RW, "VP8 predictor interpolation coefficient for 2/8 pixel position tap=4"),
    H1REG(HEncVp8IpolCoeff25      , 0x3C4, 0x000000f8,  3, 0, RW, "VP8 predictor interpolation coefficient for 2/8 pixel position tap=5"),
    H1REG(HEncVp8IpolCoeff26      , 0x3C4, 0x00000007,  0, 0, RW, "VP8 predictor interpolation coefficient for 2/8 pixel position tap=6"),
    H1REG(HEncVp8IpolCoeff31      , 0x3C8, 0xe0000000, 29, 0, RW, "VP8 predictor interpolation coefficient for 3/8 pixel position tap=1"),
    H1REG(HEncVp8IpolCoeff32      , 0x3C8, 0x1f000000, 24, 0, RW, "VP8 predictor interpolation coefficient for 3/8 pixel position tap=2"),
    H1REG(HEncVp8IpolCoeff33      , 0x3C8, 0x00ff0000, 16, 0, RW, "VP8 predictor interpolation coefficient for 3/8 pixel position tap=3"),
    H1REG(HEncVp8IpolCoeff34      , 0x3C8, 0x0000ff00,  8, 0, RW, "VP8 predictor interpolation coefficient for 3/8 pixel position tap=4"),
    H1REG(HEncVp8IpolCoeff35      , 0x3C8, 0x000000f8,  3, 0, RW, "VP8 predictor interpolation coefficient for 3/8 pixel position tap=5"),
    H1REG(HEncVp8IpolCoeff36      , 0x3C8, 0x00000007,  0, 0, RW, "VP8 predictor interpolation coefficient for 3/8 pixel position tap=6"),
    H1REG(HEncVp8IpolCoeff41      , 0x3CC, 0xe0000000, 29, 0, RW, "VP8 predictor interpolation coefficient for 4/8 pixel position tap=1"),
    H1REG(HEncVp8IpolCoeff42      , 0x3CC, 0x1f000000, 24, 0, RW, "VP8 predictor interpolation coefficient for 4/8 pixel position tap=2"),
    H1REG(HEncVp8IpolCoeff43      , 0x3CC, 0x00ff0000, 16, 0, RW, "VP8 predictor interpolation coefficient for 4/8 pixel position tap=3"),
    H1REG(HEncVp8IpolCoeff44      , 0x3CC, 0x0000ff00,  8, 0, RW, "VP8 predictor interpolation coefficient for 4/8 pixel position tap=4"),
    H1REG(HEncVp8IpolCoeff45      , 0x3CC, 0x000000f8,  3, 0, RW, "VP8 predictor interpolation coefficient for 4/8 pixel position tap=5"),
    H1REG(HEncVp8IpolCoeff46      , 0x3CC, 0x00000007,  0, 0, RW, "VP8 predictor interpolation coefficient for 4/8 pixel position tap=6"),

    H1REG(HEncBasePartition3      , 0x3D0, 0xffffffff,  0, 0, RW, "Base address for VP8 3rd DCT partition"),
    H1REG(HEncBasePartition4      , 0x3D4, 0xffffffff,  0, 0, RW, "Base address for VP8 4th DCT partition"),

    H1REG(HEncSeg1I16Mode0Penalty , 0x400, 0x000003ff,  0, 0, RW, "Segment 1: Intra 16x16 mode 0 penalty"),
    H1REG(HEncSeg1I16Mode1Penalty , 0x400, 0x000ffc00, 10, 0, RW, "Segment 1: Intra 16x16 mode 1 penalty"),
    H1REG(HEncSeg1I16Mode2Penalty , 0x400, 0x3ff00000, 20, 0, RW, "Segment 1: Intra 16x16 mode 2 penalty"),
    H1REG(HEncSeg1I16Mode3Penalty , 0x404, 0x000003ff,  0, 0, RW, "Segment 1: Intra 16x16 mode 3 penalty"),
    H1REG(HEncSeg1I4Mode0Penalty  , 0x404, 0x000ffc00, 10, 0, RW, "Segment 1: Intra 4x4 mode 0 penalty"),
    H1REG(HEncSeg1I4Mode1Penalty  , 0x404, 0x3ff00000, 20, 0, RW, "Segment 1: Intra 4x4 mode 1 penalty"),
    H1REG(HEncSeg1I4Mode2Penalty  , 0x408, 0x000003ff,  0, 0, RW, "Segment 1: Intra 4x4 mode 2 penalty"),
    H1REG(HEncSeg1I4Mode3Penalty  , 0x408, 0x000ffc00, 10, 0, RW, "Segment 1: Intra 4x4 mode 3 penalty"),
    H1REG(HEncSeg1I4Mode4Penalty  , 0x408, 0x3ff00000, 20, 0, RW, "Segment 1: Intra 4x4 mode 4 penalty"),
    H1REG(HEncSeg1I4Mode5Penalty  , 0x40C, 0x000003ff,  0, 0, RW, "Segment 1: Intra 4x4 mode 5 penalty"),
    H1REG(HEncSeg1I4Mode6Penalty  , 0x40C, 0x000ffc00, 10, 0, RW, "Segment 1: Intra 4x4 mode 6 penalty"),
    H1REG(HEncSeg1I4Mode7Penalty  , 0x40C, 0x3ff00000, 20, 0, RW, "Segment 1: Intra 4x4 mode 7 penalty"),
    H1REG(HEncSeg1I4Mode8Penalty  , 0x410, 0x000003ff,  0, 0, RW, "Segment 1: Intra 4x4 mode 8 penalty"),
    H1REG(HEncSeg1I4Mode9Penalty  , 0x410, 0x000ffc00, 10, 0, RW, "Segment 1: Intra 4x4 mode 9 penalty"),
    H1REG(HEncSeg1I4PrevModeFavor , 0x410, 0x0ff00000, 20, 0, RW, "Segment 1: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg1CostInter       , 0x414, 0x00000fff,  0, 0, RW, "Segment 1: Bit cost of inter type"),
    H1REG(HEncSeg1I16Favor        , 0x414, 0x0ffff000, 12, 0, RW, "Segment 1: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg1InterFavor      , 0x418, 0x0000ffff,  0, 0, RW, "Segment 1: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg1SkipPenalty     , 0x418, 0x00ff0000, 16, 0, RW, "Segment 1: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg1GoldenPenalty   , 0x418, 0xff000000, 24, 0, RW, "Segment 1: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg1SplitPenalty8x4 , 0x41C, 0x000003ff,  0, 0, RW, "Segment 1: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg1SplitPenalty8x8 , 0x41C, 0x000ffc00, 10, 0, RW, "Segment 1: Penalty for using 8x8 MV."),
    H1REG(HEncSeg1SplitPenalty16x8, 0x41C, 0x3ff00000, 20, 0, RW, "Segment 1: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg1SplitPenalty4x4 , 0x420, 0x000001ff,  0, 0, RW, "Segment 1: Penalty for using 4x4 MV."),
    H1REG(HEncSeg1SplitZeroPenalty, 0x420, 0x000ffc00, 10, 0, RW, "Segment 1: Penalty for using zero-MV in 16x8/8x16/8x8 split"),
    H1REG(HEncSeg1DMVPenaltyQp    , 0x420, 0x3ff00000, 20, 0, RW, "Segment 1: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg1DzRateM0        , 0x424, 0x00003fff,  0, 0, RW, "Segment 1: Deadzone rate multiplier for plane 0"),
    H1REG(HEncSeg1DzRateM1        , 0x424, 0x0fffc000, 14, 0, RW, "Segment 1: Deadzone rate multiplier for plane 1"),
    H1REG(HEncSeg1DzRateM2        , 0x428, 0x00003fff,  0, 0, RW, "Segment 1: Deadzone rate multiplier for plane 2"),
    H1REG(HEncSeg1DzRateM3        , 0x428, 0x0fffc000, 14, 0, RW, "Segment 1: Deadzone rate multiplier for plane 3"),
    H1REG(HEncSeg1DzSkipRate0     , 0x42C, 0x000003ff,  0, 0, RW, "Segment 1: Deadzone rate for macroblock skip token 0"),
    H1REG(HEncSeg1DzSkipRate1     , 0x42C, 0x000ffc00, 10, 0, RW, "Segment 1: Deadzone rate for macroblock skip token 1"),
    H1REG(HEncSeg1DmvCostConst    , 0x42C, 0xfff00000, 20, 0, RW, "Segment 1: Coeff for dmv penalty for intra/inter selection"),

    H1REG(HEncSeg2I16Mode0Penalty , 0x430, 0x000003ff,  0, 0, RW, "Segment 2: Intra 16x16 mode 0 penalty"),
    H1REG(HEncSeg2I16Mode1Penalty , 0x430, 0x000ffc00, 10, 0, RW, "Segment 2: Intra 16x16 mode 1 penalty"),
    H1REG(HEncSeg2I16Mode2Penalty , 0x430, 0x3ff00000, 20, 0, RW, "Segment 2: Intra 16x16 mode 2 penalty"),
    H1REG(HEncSeg2I16Mode3Penalty , 0x434, 0x000003ff,  0, 0, RW, "Segment 2: Intra 16x16 mode 3 penalty"),
    H1REG(HEncSeg2I4Mode0Penalty  , 0x434, 0x000ffc00, 10, 0, RW, "Segment 2: Intra 4x4 mode 0 penalty"),
    H1REG(HEncSeg2I4Mode1Penalty  , 0x434, 0x3ff00000, 20, 0, RW, "Segment 2: Intra 4x4 mode 1 penalty"),
    H1REG(HEncSeg2I4Mode2Penalty  , 0x438, 0x000003ff,  0, 0, RW, "Segment 2: Intra 4x4 mode 2 penalty"),
    H1REG(HEncSeg2I4Mode3Penalty  , 0x438, 0x000ffc00, 10, 0, RW, "Segment 2: Intra 4x4 mode 3 penalty"),
    H1REG(HEncSeg2I4Mode4Penalty  , 0x438, 0x3ff00000, 20, 0, RW, "Segment 2: Intra 4x4 mode 4 penalty"),
    H1REG(HEncSeg2I4Mode5Penalty  , 0x43C, 0x000003ff,  0, 0, RW, "Segment 2: Intra 4x4 mode 5 penalty"),
    H1REG(HEncSeg2I4Mode6Penalty  , 0x43C, 0x000ffc00, 10, 0, RW, "Segment 2: Intra 4x4 mode 6 penalty"),
    H1REG(HEncSeg2I4Mode7Penalty  , 0x43C, 0x3ff00000, 20, 0, RW, "Segment 2: Intra 4x4 mode 7 penalty"),
    H1REG(HEncSeg2I4Mode8Penalty  , 0x440, 0x000003ff,  0, 0, RW, "Segment 2: Intra 4x4 mode 8 penalty"),
    H1REG(HEncSeg2I4Mode9Penalty  , 0x440, 0x000ffc00, 10, 0, RW, "Segment 2: Intra 4x4 mode 9 penalty"),
    H1REG(HEncSeg2I4PrevModeFavor , 0x440, 0x0ff00000, 20, 0, RW, "Segment 2: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg2CostInter       , 0x444, 0x00000fff,  0, 0, RW, "Segment 2: Bit cost of inter type"),
    H1REG(HEncSeg2I16Favor        , 0x444, 0x0ffff000, 12, 0, RW, "Segment 2: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg2InterFavor      , 0x448, 0x0000ffff,  0, 0, RW, "Segment 2: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg2SkipPenalty     , 0x448, 0x00ff0000, 16, 0, RW, "Segment 2: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg2GoldenPenalty   , 0x448, 0xff000000, 24, 0, RW, "Segment 2: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg2SplitPenalty8x4 , 0x44C, 0x000003ff,  0, 0, RW, "Segment 2: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg2SplitPenalty8x8 , 0x44C, 0x000ffc00, 10, 0, RW, "Segment 2: Penalty for using 8x8 MV."),
    H1REG(HEncSeg2SplitPenalty16x8, 0x44C, 0x3ff00000, 20, 0, RW, "Segment 2: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg2SplitPenalty4x4 , 0x450, 0x000001ff,  0, 0, RW, "Segment 2: Penalty for using 4x4 MV."),
    H1REG(HEncSeg2SplitZeroPenalty, 0x450, 0x000ffc00, 10, 0, RW, "Segment 2: Penalty for using zero-MV in 16x8/8x16/8x8 split"),
    H1REG(HEncSeg2DMVPenaltyQp    , 0x450, 0x3ff00000, 20, 0, RW, "Segment 2: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg2DzRateM0        , 0x454, 0x00003fff,  0, 0, RW, "Segment 2: Deadzone rate multiplier for plane 0"),
    H1REG(HEncSeg2DzRateM1        , 0x454, 0x0fffc000, 14, 0, RW, "Segment 2: Deadzone rate multiplier for plane 1"),
    H1REG(HEncSeg2DzRateM2        , 0x458, 0x00003fff,  0, 0, RW, "Segment 2: Deadzone rate multiplier for plane 2"),
    H1REG(HEncSeg2DzRateM3        , 0x458, 0x0fffc000, 14, 0, RW, "Segment 2: Deadzone rate multiplier for plane 3"),
    H1REG(HEncSeg2DzSkipRate0     , 0x45C, 0x000003ff,  0, 0, RW, "Segment 2: Deadzone rate for macroblock skip token 0"),
    H1REG(HEncSeg2DzSkipRate1     , 0x45C, 0x000ffc00, 10, 0, RW, "Segment 2: Deadzone rate for macroblock skip token 1"),
    H1REG(HEncSeg2DmvCostConst    , 0x45C, 0xfff00000, 20, 0, RW, "Segment 2: Coeff for dmv penalty for intra/inter selection"),

    H1REG(HEncSeg3I16Mode0Penalty , 0x460, 0x000003ff,  0, 0, RW, "Segment 3: Intra 16x16 mode 0 penalty"),
    H1REG(HEncSeg3I16Mode1Penalty , 0x460, 0x000ffc00, 10, 0, RW, "Segment 3: Intra 16x16 mode 1 penalty"),
    H1REG(HEncSeg3I16Mode2Penalty , 0x460, 0x3ff00000, 20, 0, RW, "Segment 3: Intra 16x16 mode 2 penalty"),
    H1REG(HEncSeg3I16Mode3Penalty , 0x464, 0x000003ff,  0, 0, RW, "Segment 3: Intra 16x16 mode 3 penalty"),
    H1REG(HEncSeg3I4Mode0Penalty  , 0x464, 0x000ffc00, 10, 0, RW, "Segment 3: Intra 4x4 mode 0 penalty"),
    H1REG(HEncSeg3I4Mode1Penalty  , 0x464, 0x3ff00000, 20, 0, RW, "Segment 3: Intra 4x4 mode 1 penalty"),
    H1REG(HEncSeg3I4Mode2Penalty  , 0x468, 0x000003ff,  0, 0, RW, "Segment 3: Intra 4x4 mode 2 penalty"),
    H1REG(HEncSeg3I4Mode3Penalty  , 0x468, 0x000ffc00, 10, 0, RW, "Segment 3: Intra 4x4 mode 3 penalty"),
    H1REG(HEncSeg3I4Mode4Penalty  , 0x468, 0x3ff00000, 20, 0, RW, "Segment 3: Intra 4x4 mode 4 penalty"),
    H1REG(HEncSeg3I4Mode5Penalty  , 0x46C, 0x000003ff,  0, 0, RW, "Segment 3: Intra 4x4 mode 5 penalty"),
    H1REG(HEncSeg3I4Mode6Penalty  , 0x46C, 0x000ffc00, 10, 0, RW, "Segment 3: Intra 4x4 mode 6 penalty"),
    H1REG(HEncSeg3I4Mode7Penalty  , 0x46C, 0x3ff00000, 20, 0, RW, "Segment 3: Intra 4x4 mode 7 penalty"),
    H1REG(HEncSeg3I4Mode8Penalty  , 0x470, 0x000003ff,  0, 0, RW, "Segment 3: Intra 4x4 mode 8 penalty"),
    H1REG(HEncSeg3I4Mode9Penalty  , 0x470, 0x000ffc00, 10, 0, RW, "Segment 3: Intra 4x4 mode 9 penalty"),
    H1REG(HEncSeg3I4PrevModeFavor , 0x470, 0x0ff00000, 20, 0, RW, "Segment 3: Intra 4x4 previous mode favor for H.264"),
    H1REG(HEncSeg3CostInter       , 0x474, 0x00000fff,  0, 0, RW, "Segment 3: Bit cost of inter type"),
    H1REG(HEncSeg3I16Favor        , 0x474, 0x0ffff000, 12, 0, RW, "Segment 3: Intra 16x16 mode favor in intra 16x16/4x4 selection"),
    H1REG(HEncSeg3InterFavor      , 0x478, 0x0000ffff,  0, 0, RW, "Segment 3: Inter MB mode favor in intra/inter selection"),
    H1REG(HEncSeg3SkipPenalty     , 0x478, 0x00ff0000, 16, 0, RW, "Segment 3: Skip mode (zero/nearest/near) penalty"),
    H1REG(HEncSeg3GoldenPenalty   , 0x478, 0xff000000, 24, 0, RW, "Segment 3: Penalty value for second reference frame zero-mv. VP8 golden / H.264 LTR. [0..255]"),
    H1REG(HEncSeg3SplitPenalty8x4 , 0x47C, 0x000003ff,  0, 0, RW, "Segment 3: Penalty for using 8x4 or 4x8 MV."),
    H1REG(HEncSeg3SplitPenalty8x8 , 0x47C, 0x000ffc00, 10, 0, RW, "Segment 3: Penalty for using 8x8 MV."),
    H1REG(HEncSeg3SplitPenalty16x8, 0x47C, 0x3ff00000, 20, 0, RW, "Segment 3: Penalty for using 16x8 or 8x16 MV."),
    H1REG(HEncSeg3SplitPenalty4x4 , 0x480, 0x000001ff,  0, 0, RW, "Segment 3: Penalty for using 4x4 MV."),
    H1REG(HEncSeg3SplitZeroPenalty, 0x480, 0x000ffc00, 10, 0, RW, "Segment 3: Penalty for using zero-MV in 16x8/8x16/8x8 split"),
    H1REG(HEncSeg3DMVPenaltyQp    , 0x480, 0x3ff00000, 20, 0, RW, "Segment 3: Differential MV penalty for 1/4p ME. DMVPenaltyQp"),
    H1REG(HEncSeg3DzRateM0        , 0x484, 0x00003fff,  0, 0, RW, "Segment 3: Deadzone rate multiplier for plane 0"),
    H1REG(HEncSeg3DzRateM1        , 0x484, 0x0fffc000, 14, 0, RW, "Segment 3: Deadzone rate multiplier for plane 1"),
    H1REG(HEncSeg3DzRateM2        , 0x488, 0x00003fff,  0, 0, RW, "Segment 3: Deadzone rate multiplier for plane 2"),
    H1REG(HEncSeg3DzRateM3        , 0x488, 0x0fffc000, 14, 0, RW, "Segment 3: Deadzone rate multiplier for plane 3"),
    H1REG(HEncSeg3DzSkipRate0     , 0x48C, 0x000003ff,  0, 0, RW, "Segment 3: Deadzone rate for macroblock skip token 0"),
    H1REG(HEncSeg3DzSkipRate1     , 0x48C, 0x000ffc00, 10, 0, RW, "Segment 3: Deadzone rate for macroblock skip token 1"),
    H1REG(HEncSeg3DmvCostConst    , 0x48C, 0xfff00000, 20, 0, RW, "Segment 3: Coeff for dmv penalty for intra/inter selection"),
    H1REG(HEncVp8AvgVar           , 0x490, 0xffffffff,  0, 0, RW, "VP8 average variance in prev frame"),
    H1REG(HEncVp8InvAvgVar        , 0x494, 0x0000ffff,  0, 0, RW, "VP8 16384/avgVar in prev frame"),
    H1REG(HEncFieldPicFlag        , 0x494, 0x00010000, 16, 0, RW, "H.264 FieldPicFlag. 0=frame 1=field"),
    H1REG(HEncBottomFieldFlag     , 0x494, 0x00020000, 17, 0, RW, "H.264 BottomFieldFlag. 0=top 1=bottom field"),
    H1REG(HEncFieldParity         , 0x494, 0x000c0000, 18, 0, RW, "H.264 Field parity conditions for chroma MV. 0=same parity 1=top/bottom 2=bottom/top"),
    H1REG(HEncBoostQp             , 0x498, 0x0000003f,  0, 0, RW, "Mb boost qp"),
    H1REG(HEncBoostVar1           , 0x498, 0x0007ffc0,  6, 0, RW, "Mb boost variance1"),
    H1REG(HEncBoostVar2           , 0x498, 0xfff80000, 19, 0, RW, "Mb boost variance2"),

    H1REG(HEncVarLimit            , 0x49c, 0x0000000f,  0, 0, RW, "Variance limit"),
    H1REG(HEncVarInterFavor       , 0x49c, 0x000000f0,  4, 0, RW, "Variance interFavor"),
    H1REG(HEncVarMultiplier       , 0x49c, 0x00001f00,  8, 0, RW, "Variance multiplier"),
    H1REG(HEncVarAdd              , 0x49c, 0x0000e000, 13, 0, RW, "Variance add"),
    H1REG(HEncPskipMode           , 0x49c, 0x00010000, 16, 0, RW, "Pskip coding mode"),
#include "reg_table_v7.h"
};

#include "reg_offset_v7.h"

#define ASIC_SWREG_AMOUNT               (BASE_HEncRegisterMax/4)

/*------------------------------------------------------------------------------
    4. Function prototypes
------------------------------------------------------------------------------*/

void EncAsicSetRegisterValue(u32 *regMirror, regName name, u32 value);
u32 EncAsicGetRegisterValue(const void *ewl, u32 *regMirror, regName name);
void EncAsicWriteRegisterValue(const void *ewl, u32 *regMirror, regName name, u32 value);

#ifdef ADDRESS_WIDTH_64

#define SET_ADDR_REG(reg_base, name, value) do {\
    EncAsicSetRegisterValue((reg_base), name, (u32)(value));  \
    EncAsicSetRegisterValue((reg_base), name##_MSB, (u32)((value) >> 32)); \
  } while (0)

#define GET_ADDR_REG(ewl, reg_base, name)  \
  (((ptr_t)EncAsicGetRegisterValue((ewl), (reg_base), name)) |  \
  (((ptr_t)EncAsicGetRegisterValue((ewl), (reg_base), name##_MSB)) << 32))

#else

#define SET_ADDR_REG(reg_base, name, value) do {\
    EncAsicSetRegisterValue((reg_base), name, (u32)(value));  \
  } while (0)

#define GET_ADDR_REG(ewl, reg_base, name)  \
  ((ptr_t)EncAsicGetRegisterValue((ewl), (reg_base), (name)))

#endif

#endif
