/*------------------------------------------------------------------------------
--       Copyright (c) 2015-2017, VeriSilicon Inc. All rights reserved        --
--         Copyright (c) 2011-2014, Google Inc. All rights reserved.          --
--         Copyright (c) 2007-2010, Hantro OY. All rights reserved.           --
--                                                                            --
-- This software is confidential and proprietary and may be used only as      --
--   expressly authorized by VeriSilicon in a written licensing agreement.    --
--                                                                            --
--         This entire notice must be reproduced on all copies                --
--                       and may not be removed.                              --
--                                                                            --
--------------------------------------------------------------------------------
-- Redistribution and use in source and binary forms, with or without         --
-- modification, are permitted provided that the following conditions are met:--
--   * Redistributions of source code must retain the above copyright notice, --
--       this list of conditions and the following disclaimer.                --
--   * Redistributions in binary form must reproduce the above copyright      --
--       notice, this list of conditions and the following disclaimer in the  --
--       documentation and/or other materials provided with the distribution. --
--   * Neither the names of Google nor the names of its contributors may be   --
--       used to endorse or promote products derived from this software       --
--       without specific prior written permission.                           --
--------------------------------------------------------------------------------
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"--
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  --
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE --
-- ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE  --
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR        --
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF       --
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS   --
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN    --
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)    --
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE --
-- POSSIBILITY OF SUCH DAMAGE.                                                --
--------------------------------------------------------------------------------
------------------------------------------------------------------------------*/

#include "vp6decodemode.h"

/* BOOL VP6HWModeUsesMC[MAX_MODES] = { FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, TRUE }; */

/* ***************************************************************************** */
/*  ModeVQ: This structure holds a table of probability vectors for encoding modes */
/*  To build this table a number of clips were run through and allowed to  */
/*  select each of the probabilities that were best for them on each frame.  These  */
/*  choices were output and a vector quantizer was used to optimize the selection  */
/*  of 16 vectors for each MODETYPE (allmodes available, nonearest, and no near) */
/* ***************************************************************************** */
const u8 VP6HWModeVq[MODETYPES][MODEVECTORS][MAX_MODES*2] = {
  { {9, 15, 32, 25,  7, 19,  9, 21,  1, 12, 14, 12,  3, 18, 14, 23,  3, 10,  0,  4},
    {48, 39,  1,  2, 11, 27, 29, 44,  7, 27,  1,  4,  0,  3,  1,  6,  1,  2,  0,  0},
    {21, 32,  1,  2,  4, 10, 32, 43,  6, 23,  2,  3,  1, 19,  1,  6, 12, 21,  0,  7},
    {69, 83,  0,  0,  0,  2, 10, 29,  3, 12,  0,  1,  0,  3,  0,  3,  2,  2,  0,  0},
    {11, 20,  1,  4, 18, 36, 43, 48, 13, 35,  0,  2,  0,  5,  3, 12,  1,  2,  0,  0},
    {70, 44,  0,  1,  2, 10, 37, 46,  8, 26,  0,  2,  0,  2,  0,  2,  0,  1,  0,  0},
    {8, 15,  0,  1,  8, 21, 74, 53, 22, 42,  0,  1,  0,  2,  0,  3,  1,  2,  0,  0},
    {141, 42,  0,  0,  1,  4, 11, 24,  1, 11,  0,  1,  0,  1,  0,  2,  0,  0,  0,  0},
    {8, 19,  4, 10, 24, 45, 21, 37,  9, 29,  0,  3,  1,  7, 11, 25,  0,  2,  0,  1},
    {46, 42,  0,  1,  2, 10, 54, 51, 10, 30,  0,  2,  0,  2,  0,  1,  0,  1,  0,  0},
    {28, 32,  0,  0,  3, 10, 75, 51, 14, 33,  0,  1,  0,  2,  0,  1,  1,  2,  0,  0},
    {100, 46,  0,  1,  3,  9, 21, 37,  5, 20,  0,  1,  0,  2,  1,  2,  0,  1,  0,  0},
    {27, 29,  0,  1,  9, 25, 53, 51, 12, 34,  0,  1,  0,  3,  1,  5,  0,  2,  0,  0},
    {80, 38,  0,  0,  1,  4, 69, 33,  5, 16,  0,  1,  0,  1,  0,  0,  0,  1,  0,  0},
    {16, 20,  0,  0,  2,  8,104, 49, 15, 33,  0,  1,  0,  1,  0,  1,  1,  1,  0,  0},
    {194, 16,  0,  0,  1,  1,  1,  9,  1,  3,  0,  0,  0,  1,  0,  1,  0,  0,  0,  0}
  },

  { {41, 22,  1,  0,  1, 31,  0,  0,  0,  0,  0,  1,  1,  7,  0,  1, 98, 25,  4, 10},
    {123, 37,  6,  4,  1, 27,  0,  0,  0,  0,  5,  8,  1,  7,  0,  1, 12, 10,  0,  2},
    {26, 14, 14, 12,  0, 24,  0,  0,  0,  0, 55, 17,  1,  9,  0, 36,  5,  7,  1,  3},
    {209,  5,  0,  0,  0, 27,  0,  0,  0,  0,  0,  1,  0,  1,  0,  1,  0,  0,  0,  0},
    {2,  5,  4,  5,  0,121,  0,  0,  0,  0,  0,  3,  2,  4,  1,  4,  2,  2,  0,  1},
    {175,  5,  0,  1,  0, 48,  0,  0,  0,  0,  0,  2,  0,  1,  0,  2,  0,  1,  0,  0},
    {83,  5,  2,  3,  0,102,  0,  0,  0,  0,  1,  3,  0,  2,  0,  1,  0,  0,  0,  0},
    {233,  6,  0,  0,  0,  8,  0,  0,  0,  0,  0,  1,  0,  1,  0,  0,  0,  1,  0,  0},
    {34, 16,112, 21,  1, 28,  0,  0,  0,  0,  6,  8,  1,  7,  0,  3,  2,  5,  0,  2},
    {159, 35,  2,  2,  0, 25,  0,  0,  0,  0,  3,  6,  0,  5,  0,  1,  4,  4,  0,  1},
    {75, 39,  5,  7,  2, 48,  0,  0,  0,  0,  3, 11,  2, 16,  1,  4,  7, 10,  0,  2},
    {212, 21,  0,  1,  0,  9,  0,  0,  0,  0,  1,  2,  0,  2,  0,  0,  2,  2,  0,  0},
    {4,  2,  0,  0,  0,172,  0,  0,  0,  0,  0,  1,  0,  2,  0,  0,  2,  0,  0,  0},
    {187, 22,  1,  1,  0, 17,  0,  0,  0,  0,  3,  6,  0,  4,  0,  1,  4,  4,  0,  1},
    {133,  6,  1,  2,  1, 70,  0,  0,  0,  0,  0,  2,  0,  4,  0,  3,  1,  1,  0,  0},
    {251,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}
  },

  { {2,  3,  2,  3,  0,  2,  0,  2,  0,  0, 11,  4,  1,  4,  0,  2,  3,  2,  0,  4},
    {49, 46,  3,  4,  7, 31, 42, 41,  0,  0,  2,  6,  1,  7,  1,  4,  2,  4,  0,  1},
    {26, 25,  1,  1,  2, 10, 67, 39,  0,  0,  1,  1,  0, 14,  0,  2, 31, 26,  1,  6},
    {103, 46,  1,  2,  2, 10, 33, 42,  0,  0,  1,  4,  0,  3,  0,  1,  1,  3,  0,  0},
    {14, 31,  9, 13, 14, 54, 22, 29,  0,  0,  2,  6,  4, 18,  6, 13,  1,  5,  0,  1},
    {85, 39,  0,  0,  1,  9, 69, 40,  0,  0,  0,  1,  0,  3,  0,  1,  2,  3,  0,  0},
    {31, 28,  0,  0,  3, 14,130, 34,  0,  0,  0,  1,  0,  3,  0,  1,  3,  3,  0,  1},
    {171, 25,  0,  0,  1,  5, 25, 21,  0,  0,  0,  1,  0,  1,  0,  0,  0,  0,  0,  0},
    {17, 21, 68, 29,  6, 15, 13, 22,  0,  0,  6, 12,  3, 14,  4, 10,  1,  7,  0,  3},
    {51, 39,  0,  1,  2, 12, 91, 44,  0,  0,  0,  2,  0,  3,  0,  1,  2,  3,  0,  1},
    {81, 25,  0,  0,  2,  9,106, 26,  0,  0,  0,  1,  0,  1,  0,  1,  1,  1,  0,  0},
    {140, 37,  0,  1,  1,  8, 24, 33,  0,  0,  1,  2,  0,  2,  0,  1,  1,  2,  0,  0},
    {14, 23,  1,  3, 11, 53, 90, 31,  0,  0,  0,  3,  1,  5,  2,  6,  1,  2,  0,  0},
    {123, 29,  0,  0,  1,  7, 57, 30,  0,  0,  0,  1,  0,  1,  0,  1,  0,  1,  0,  0},
    {13, 14,  0,  0,  4, 20,175, 20,  0,  0,  0,  1,  0,  1,  0,  1,  1,  1,  0,  0},
    {202, 23,  0,  0,  1,  3,  2,  9,  0,  0,  0,  1,  0,  1,  0,  1,  0,  0,  0,  0}
  }
};

const u8 VP6HWBaselineXmittedProbs[4][2][10] = {
  {{42,  2,  7, 42, 22,  3,  2,  5,  1,  0},   {69,  1,  1, 44,  6,  1,  0,  1,  0,  0}},
  {{8,  1,  8,  0,  0,  2,  1,  0,  1,  0},  {229,  1,  0,  0,  0,  1,  0,  0,  1,  0}},
  {{35,  1,  6, 34,  0,  2,  1,  1,  1,  0},  {122,  1,  1, 46,  0,  1,  0,  0,  1,  0}},
  {{64,  0, 64, 64, 64,  0,  0,  0,  0,  0},   {64,  0, 64, 64, 64,  0,  0,  0,  0,  0}}
};


const u8 VP6HWMvUpdateProbs[2][MV_NODES] = {
  { 237, 246, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 250, 250, 252 },
  { 231, 243, 245, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 251, 251, 254 }
};

const u8 VP6HW_DefaultMvShortProbs[2][7] = {
  { 225, 146, 172, 147, 214,  39, 156 },
  { 204, 170, 119, 235, 140, 230, 228 }
};

const u8 VP6HW_DefaultMvLongProbs[2][LONG_MV_BITS] = {
  { 247, 210, 135,  68, 138, 220, 239, 246 },
  { 244, 184, 201,  44, 173, 221, 239, 253 }
};

const u8 VP6HW_DefaultIsShortProbs[2] = { 162, 164 };
const u8 VP6HW_DefaultSignProbs[2]    = { 128, 128 };

const u8 VP6HW_DefaultScanBands[BLOCK_SIZE] = {
  0, 0, 1, 1, 1, 2, 2, 2,
  2, 2, 2, 3, 3, 4, 4, 4,
  5, 5, 5, 5, 6, 6, 7, 7,
  7, 7, 7, 8, 8, 9, 9, 9,
  9, 9, 9,10,10,11,11,11,
  11,11,11,12,12,12,12,12,
  12,13,13,13,13,13,14,14,
  14,14,15,15,15,15,15,15
};


/* Definition of AC coefficient banding */
const i8 VP6HWCoeffToBand[65] = {
  -1,0,1,1,1,2,2,2,
  2,2,2,3,3,3,3,3,
  3,3,3,3,3,3,4,4,
  4,4,4,4,4,4,4,4,
  4,4,4,4,4,5,5,5,
  5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,7
};

/*  AWG Should export this in decodembs.h rather than pbdll.h */

const
u32 VP6HWMode2Frame[] = {
  1,  /*  CODE_INTER_NO_MV    0 => Encoded diff from same MB last frame  */
  0,  /*  CODE_INTRA      1 => DCT Encoded Block */
  1,  /*  CODE_INTER_PLUS_MV  2 => Encoded diff from included MV MB last frame */
  1,  /*  CODE_INTER_LAST_MV  3 => Encoded diff from MRU MV MB last frame */
  1,  /*  CODE_INTER_PRIOR_MV 4 => Encoded diff from included 4 separate MV blocks */
  2,  /*  CODE_USING_GOLDEN 5 => Encoded diff from same MB golden frame */
  2,  /*  CODE_GOLDEN_MV    6 => Encoded diff from included MV MB golden frame */
  1,  /*  CODE_INTER_FOUR_MV  7 => Encoded diff from included 4 separate MV blocks */
  2,  /*  CODE_GOLD_NEAREST_MV 8 => Encoded diff from MRU MV MB last frame */
  2,  /*  CODE_GOLD_NEAR_MV 9 => Encoded diff from included 4 separate MV blocks */
};
const
i32 VP6HW_BilinearFilters[8][2] = {
  { 128,   0 },
  { 112,  16 },
  {  96,  32 },
  {  80,  48 },
  {  64,  64 },
  {  48,  80 },
  {  32,  96 },
  {  16, 112 }
};

/*  VP6.2 Bicubic filter taps calculated for 32 values of 'A' from -0.25 to -1.00 in steps of -0.05 */
/*  For each 'A' there are 8 sets of data corresponding to 1/8 pel offsets 0 to 7/8. */
/*  These are only used in VP6.2 and upwards */
/*  The last entry is a dummy entry used for backwards compatibility with VP61 */
const
i32 VP6HW_BicubicFilterSet[17][8][4] = {
  { { 0, 128, 0, 0 },
    { -3, 122, 9, 0 },
    { -4, 109, 24, -1 },
    { -5, 91, 45, -3 },
    { -4, 68, 68, -4 },
    { -3, 45, 91, -5 },
    { -1, 24, 109, -4 },
    { 0, 9, 122, -3 },
  },
  { { 0, 128, 0, 0 },
    { -4, 124, 9, -1 },
    { -5, 110, 25, -2 },
    { -6, 91, 46, -3 },
    { -5, 69, 69, -5 },
    { -3, 46, 91, -6 },
    { -2, 25, 110, -5 },
    { -1, 9, 124, -4 },
  },
  { { 0, 128, 0, 0 },
    { -4, 123, 10, -1 },
    { -6, 110, 26, -2 },
    { -7, 92, 47, -4 },
    { -6, 70, 70, -6 },
    { -4, 47, 92, -7 },
    { -2, 26, 110, -6 },
    { -1, 10, 123, -4 },
  },
  { { 0, 128, 0, 0 },     /*  Approx A=-0.4 */
    { -5, 124, 10, -1 },
    { -7, 110, 27, -2 },
    { -7, 91, 48, -4 },
    { -6, 70, 70, -6 },
    { -4, 48, 92, -8 },
    { -2, 27, 110, -7 },
    { -1, 10, 124, -5 },
  },
  { { 0, 128, 0, 0 },
    { -6, 124, 11, -1 },
    { -8, 111, 28, -3 },
    { -8, 92, 49, -5 },
    { -7, 71, 71, -7 },
    { -5, 49, 92, -8 },
    { -3, 28, 111, -8 },
    { -1, 11, 124, -6 },
  },
  { { 0, 128, 0, 0 },     /*  Corresponds approximately to VDub bicubic A=-0.50 */
    { -6, 123, 12, -1 },
    { -9, 111, 29, -3 },
    { -9, 93, 50, -6 },
    { -8, 72, 72, -8 },
    { -6, 50, 93, -9 },
    { -3, 29, 111, -9 },
    { -1, 12, 123, -6 },
  },
  { { 0, 128, 0, 0 },
    { -7, 124, 12, -1 },
    { -10, 111, 30, -3 },
    { -10, 93, 51, -6 },
    { -9, 73, 73, -9 },
    { -6, 51, 93, -10 },
    { -3, 30, 111, -10 },
    { -1, 12, 124, -7 },
  },
  { { 0, 128, 0, 0 },
    { -7, 123, 13, -1 },
    { -11, 112, 31, -4 },
    { -11, 94, 52, -7 },
    { -10, 74, 74, -10 },
    { -7, 52, 94, -11 },
    { -4, 31, 112, -11 },
    { -1, 13, 123, -7 },
  },
  { { 0, 128, 0, 0 },
    { -8, 124, 13, -1 },
    { -12, 112, 32, -4 },
    { -12, 94, 53, -7 },
    { -10, 74, 74, -10 },
    { -7, 53, 94, -12 },
    { -4, 32, 112, -12 },
    { -1, 13, 124, -8 },
  },
  { { 0, 128, 0, 0 },
    { -9, 124, 14, -1 },
    { -13, 112, 33, -4 },
    { -13, 95, 54, -8 },
    { -11, 75, 75, -11 },
    { -8, 54, 95, -13 },
    { -4, 33, 112, -13 },
    { -1, 14, 124, -9 },
  },
  { { 0, 128, 0, 0 },     /*  Corresponds approximately to VDub bicubic A=-0.75 */
    { -9, 123, 15, -1 },
    { -14, 113, 34, -5 },
    { -14, 95, 55, -8 },
    { -12, 76, 76, -12 },
    { -8, 55, 95, -14 },
    { -5, 34, 112, -13 },
    { -1, 15, 123, -9 },
  },
  { { 0, 128, 0, 0 },
    { -10, 124, 15, -1 },
    { -14, 113, 34, -5 },
    { -15, 96, 56, -9 },
    { -13, 77, 77, -13 },
    { -9, 56, 96, -15 },
    { -5, 34, 113, -14 },
    { -1, 15, 124, -10 },
  },
  { { 0, 128, 0, 0 },
    { -10, 123, 16, -1 },
    { -15, 113, 35, -5 },
    { -16, 98, 56, -10 },
    { -14, 78, 78, -14 },
    { -10, 56, 98, -16 },
    { -5, 35, 113, -15 },
    { -1, 16, 123, -10 },
  },
  { { 0, 128, 0, 0 },
    { -11, 124, 17, -2 },
    { -16, 113, 36, -5 },
    { -17, 98, 57, -10 },
    { -14, 78, 78, -14 },
    { -10, 57, 98, -17 },
    { -5, 36, 113, -16 },
    { -2, 17, 124, -11 },
  },
  { { 0, 128, 0, 0 },
    { -12, 125, 17, -2 },
    { -17, 114, 37, -6 },
    { -18, 99, 58, -11 },
    { -15, 79, 79, -15 },
    { -11, 58, 99, -18 },
    { -6, 37, 114, -17 },
    { -2, 17, 125, -12 },
  },
  { { 0, 128, 0, 0 },
    { -12, 124, 18, -2 },
    { -18, 114, 38, -6 },
    { -19, 99, 59, -11 },
    { -16, 80, 80, -16 },
    { -11, 59, 99, -19 },
    { -6, 38, 114, -18 },
    { -2, 18, 124, -12 },
  },

  /*  Dummy entry for backwards VP61 compatibility */
  {
    {  0, 128,   0,  0 },
    { -4, 118,  16, -2 },
    { -7, 106,  34, -5 },
    { -8,  90,  53, -7 },
    { -8,  72,  72, -8 },
    { -7,  53,  90, -8 },
    { -5,  34, 106, -7 },
    { -2,  16, 118, -4 }
  }
};

const u8 VP6HWDcUpdateProbs[2][MAX_ENTROPY_TOKENS-1] = {
  { 146, 255, 181, 207, 232, 243, 238, 251, 244, 250, 249 },
  { 179, 255, 214, 240, 250, 255, 244, 255, 255, 255, 255 }
};

const u8 VP6HW_ScanBandUpdateProbs[BLOCK_SIZE] = {
  255, 132, 132, 159, 153, 151, 161, 170,
  164, 162, 136, 110, 103, 114, 129, 118,
  124, 125, 132, 136, 114, 110, 142, 135,
  134, 123, 143, 126, 153, 183, 166, 161,
  171, 180, 179, 164, 203, 218, 225, 217,
  215, 206, 203, 217, 229, 241, 248, 243,
  253, 255, 253, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255
};

const u8 VP6HW_ZrlUpdateProbs[ZRL_BANDS][ZERO_RUN_PROB_CASES] = {
  { 219, 246, 238, 249, 232, 239, 249, 255, 248, 253, 239, 244, 241, 248 },
  { 198, 232, 251, 253, 219, 241, 253, 255, 248, 249, 244, 238, 251, 255 },
};

/*  Zero run probs  */
const u8 VP6HW_ZeroRunProbDefaults[ZRL_BANDS][ZERO_RUN_PROB_CASES] = {
  { 198, 197, 196, 146, 198, 204, 169, 142, 130, 136, 149, 149, 191, 249 },
  { 135, 201, 181, 154,  98, 117, 132, 126, 146, 169, 184, 240, 246, 254 },
};

const u8 VP6HWAcUpdateProbs[PREC_CASES][2][VP6HWAC_BANDS][MAX_ENTROPY_TOKENS-1] = {
  {
    /*  preceded by 0 */
    {
      { 227, 246, 230, 247, 244, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 209, 231, 231, 249, 249, 253, 255, 255, 255 },
      { 255, 255, 225, 242, 241, 251, 253, 255, 255, 255, 255 },
      { 255, 255, 241, 253, 252, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 248, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
    },
    {
      { 240, 255, 248, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 240, 253, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
    },
  },
  {
    /*  preceded by 1 */
    {
      { 206, 203, 227, 239, 247, 255, 253, 255, 255, 255, 255 },
      { 207, 199, 220, 236, 243, 252, 252, 255, 255, 255, 255 },
      { 212, 219, 230, 243, 244, 253, 252, 255, 255, 255, 255 },
      { 236, 237, 247, 252, 253, 255, 255, 255, 255, 255, 255 },
      { 240, 240, 248, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
    },
    {
      { 230, 233, 249, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 238, 238, 250, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 248, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
    },
  },
  {
    /*  preceded by > 1 */
    {
      { 225, 239, 227, 231, 244, 253, 243, 255, 255, 253, 255 },
      { 232, 234, 224, 228, 242, 249, 242, 252, 251, 251, 255 },
      { 235, 249, 238, 240, 251, 255, 249, 255, 253, 253, 255 },
      { 249, 253, 251, 250, 255, 255, 255, 255, 255, 255, 255 },
      { 251, 250, 249, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
    },
    {
      { 243, 244, 250, 250, 255, 255, 255, 255, 255, 255, 255 },
      { 249, 248, 250, 253, 255, 255, 255, 255, 255, 255, 255 },
      { 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
      { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 },
    },
  },
};


/*  Dc context equations: Dc Token contexts are 00 0!0 and !0!0 */
const LINE_EQ VP6HWDcNodeEqs[CONTEXT_NODES][DC_TOKEN_CONTEXTS] = {
  { { 122, 133 },{ 133,  51 },{ 142, -16 } },   /*  Zero Node  */
  { {   0,   1 },{   0,   1 },{   0,   1 } },   /*  EOB Node    Dummy as no EOBs in DC */
  { {  78, 171 },{ 169,  71 },{ 221, -30 } },   /*  One Node */
  { { 139, 117 },{ 214,  44 },{ 246,  -3 } },   /*  Low Val Node */
  { { 168,  79 },{ 210,  38 },{ 203,  17 } },   /*  Two Node (2 vs 3 or 4) */
};

const u8 VP6HWDeblockLimitValues[Q_TABLE_SIZE] = {
  14, 14, 13, 13, 12, 12, 10, 10,
  10, 10,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  7,  7,  7,  7,
  7,  7,  6,  6,  6,  6,  6,  6,
  5,  5,  5,  5,  4,  4,  4,  4,
  4,  4,  4,  3,  3,  3,  3,  2
};

const i8 VP6HWCoeffToHuffBand[65] = {
  -1,0,1,1,1,2,2,2,
  2,2,2,3,3,3,3,3,
  3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3
};

/* This contains the offsets used by the token decoder(s) inorder to convert
zigzag order into idct input order. */

const u8 VP6HWtransIndexC[64] = {
  0,  1,  8,  16,  9,  2,  3, 10,
  17, 24, 32, 25, 18, 11,  4,  5,
  12, 19, 26, 33, 40, 48, 41, 34,
  27, 20, 13,  6,  7, 14, 21, 28,

  35, 42, 49, 56, 57, 50, 43, 36,
  29, 22, 15, 23, 30, 37, 44, 51,
  58, 59, 52, 45, 38, 31, 39, 46,
  53, 60, 61, 54, 47, 55, 62, 63
};
