/*------------------------------------------------------------------------------
--       Copyright (c) 2015-2017, VeriSilicon Inc. All rights reserved        --
--         Copyright (c) 2011-2014, Google Inc. All rights reserved.          --
--         Copyright (c) 2007-2010, Hantro OY. All rights reserved.           --
--                                                                            --
-- This software is confidential and proprietary and may be used only as      --
--   expressly authorized by VeriSilicon in a written licensing agreement.    --
--                                                                            --
--         This entire notice must be reproduced on all copies                --
--                       and may not be removed.                              --
--                                                                            --
--------------------------------------------------------------------------------
-- Redistribution and use in source and binary forms, with or without         --
-- modification, are permitted provided that the following conditions are met:--
--   * Redistributions of source code must retain the above copyright notice, --
--       this list of conditions and the following disclaimer.                --
--   * Redistributions in binary form must reproduce the above copyright      --
--       notice, this list of conditions and the following disclaimer in the  --
--       documentation and/or other materials provided with the distribution. --
--   * Neither the names of Google nor the names of its contributors may be   --
--       used to endorse or promote products derived from this software       --
--       without specific prior written permission.                           --
--------------------------------------------------------------------------------
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"--
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  --
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE --
-- ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE  --
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR        --
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF       --
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS   --
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN    --
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)    --
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE --
-- POSSIBILITY OF SUCH DAMAGE.                                                --
--------------------------------------------------------------------------------
------------------------------------------------------------------------------*/

#define MAX_CBP     (16*3*3*3*3)    /* 1296 */
#define MAX_DEPTH   16
#define MAX_8x8_DSC 16
#define MAX_QP  30
#define MAX_INTRA_QP_REGIONS 5
#define MAX_INTER_QP_REGIONS 7
#define MAX_0_LEVEL     4
#define MAX_123_LEVEL   3
#define MAX_456_LEVEL   2
#define MAX_EXTRA_LEVEL 23
#define MAX_EXTRA_BITS  8
#define MAX_4x4_DSC (MAX_0_LEVEL * MAX_123_LEVEL * MAX_123_LEVEL * MAX_123_LEVEL * MAX_456_LEVEL * MAX_456_LEVEL * MAX_456_LEVEL)            /* 864 */
#define MAX_2x2_DSC (MAX_0_LEVEL * MAX_123_LEVEL * MAX_123_LEVEL * MAX_123_LEVEL)   /* 108 */
#define MAX_LEVEL_DSC   (MAX_EXTRA_LEVEL+MAX_EXTRA_BITS+1)

typedef struct {
  unsigned long intra_cbp[MAX_INTRA_QP_REGIONS][2][(MAX_CBP+7)/8];
  unsigned long intra_8x8_dsc[MAX_INTRA_QP_REGIONS][2][4][(MAX_8x8_DSC+7)/8];
  unsigned long intra_luma_4x4_dsc[MAX_INTRA_QP_REGIONS][3][(MAX_4x4_DSC+7)/8];
  unsigned long intra_luma_2x2_dsc[MAX_INTRA_QP_REGIONS][2][(MAX_2x2_DSC+7)/8];
  unsigned long intra_chroma_4x4_dsc[MAX_INTRA_QP_REGIONS][(MAX_4x4_DSC+7)/8];
  unsigned long intra_chroma_2x2_dsc[MAX_INTRA_QP_REGIONS][2][(MAX_2x2_DSC+7)/8];
  unsigned long intra_level_dsc[MAX_INTRA_QP_REGIONS][(MAX_LEVEL_DSC+7)/8];
  unsigned long inter_cbp[MAX_INTER_QP_REGIONS][(MAX_CBP+7)/8];
  unsigned long inter_8x8_dsc[MAX_INTER_QP_REGIONS][4][(MAX_8x8_DSC+7)/8];
  unsigned long inter_luma_4x4_dsc[MAX_INTER_QP_REGIONS][(MAX_4x4_DSC+7)/8];
  unsigned long inter_luma_2x2_dsc[MAX_INTER_QP_REGIONS][2][(MAX_2x2_DSC+7)/8];
  unsigned long inter_chroma_4x4_dsc[MAX_INTER_QP_REGIONS][(MAX_4x4_DSC+7)/8];
  unsigned long inter_chroma_2x2_dsc[MAX_INTER_QP_REGIONS][2][(MAX_2x2_DSC+7)/8];
  unsigned long inter_level_dsc[MAX_INTER_QP_REGIONS][(MAX_LEVEL_DSC+7)/8];
} CBP_TABLE;

CBP_TABLE _x = {
  /* Intra CBP descriptor: */
  {
    {
      {
        0x799999a9,0x9a999995,0xbbcbcbca,0xcccbcbb7,0xdcfcecfb,0xfffdfcd9,0xbcbbcccb,
        0xccbbcbb7,0xcddbdddb,0xdedbdcc7,0xfffbfffc,0xfffcfdd8,0xdfccfffd,0xefdceed9,
        0xffdcfffc,0xfffcfed9,0xfffafffb,0xfffbffe8,0xbcccbbdb,0xbdcbbbb7,0xddfdcbdb,
        0xdedccbc7,0xfffefcfc,0xfffefce9,0xdfddddec,0xdfdcccc8,0xfffdfdfb,0xffdcdcc7,
        0xfffdfdfc,0xfffdfdd8,0xffffffff,0xfffdffd9,0xfffdfffc,0xfffdfed8,0xfffcfffb,
        0xfffcfee7,0xdfffddfd,0xfffeccd9,0xffffecfc,0xfffffcd9,0xfffffafb,0xfffffbf8,
        0xfffffffe,0xfffffdd9,0xfffffefc,0xfffefcd8,0xfffffcfb,0xfffffcd7,0xffffffff,
        0xffffffea,0xfffffffd,0xffffffd8,0xfffdfefa,0xfffdfdd7,0xbcccccdb,0xbcbbbbb7,
        0xddfdedfc,0xdedcdcc8,0xfffefffd,0xfffdfdf9,0xdeddedec,0xddcbccc8,0xefedfffc,
        0xefdbdcc7,0xfffdfffc,0xfffcfdd8,0xfffffffe,0xffccffd9,0xfffdfffd,0xffecfdd8,
        0xfffbfffc,0xfffbffe7,0xcdddddfc,0xcddcbbb7,0xfffdedfc,0xefdccbc7,0xfffffdfd,
        0xfffdfcd8,0xeffefefc,0xdfdcccb7,0xfffdfdeb,0xeedbcbb6,0xfffdfdfb,0xfffcfcc6,
        0xfffffffd,0xffddfdc8,0xfffdfffc,0xffdbfcb6,0xfffbfffa,0xffebfcc5,0xfffffffe,
        0xfffeccd9,0xfffffdfd,0xffffdcd8,0xfffffcfc,0xfffffbd7,0xfffffffd,0xfffddcc8,
        0xfffffdfc,0xfffcdbb6,0xfffffcfb,0xfffcdbc5,0xffffffff,0xfffffed8,0xfffffffc,
        0xfffcecb6,0xfffcfdfa,0xfffbfbb4,0xdfeffffe,0xdeddcdc9,0xffffffff,0xfffdfdf9,
        0xffffffff,0xfffffffa,0xffffffff,0xdfddedc9,0xfffffffe,0xffdcfdd8,0xffffffff,
        0xfffdffe8,0xffffffff,0xffbcffc9,0xffffffff,0xffccffc8,0xfffdfffd,0xffebffd7,
        0xffffffff,0xdfedccc8,0xfffffffd,0xfffddcc8,0xffffffff,0xfffffde8,0xfffffffe,
        0xefdddcc8,0xfffffffc,0xffdbcbb6,0xfffffffc,0xfffcfcc6,0xffffffff,0xffccfdc8,
        0xfffefffc,0xffcbdcb5,0xfffcfffb,0xffd9ebb4,0xffffffff,0xffffbcc8,0xfffffffd,
        0xfffecbc7,0xfffffdfd,0xffffebd7,0xffffffff,0xfffdccc7,0xfffffffc,0xffecbab5,
        0xfffefdfb,0xfffbc9b4,0xffffffff,0xffddcdb7,0xfffffffc,0xffcbcb94,0xfffcfcf9,
        0xffc9c990
      },
      {
        0x16676787,0x68777786,0x589999a9,0x9aaa9aa8,0x8abbbcdc,0xcddcccda,0x59899aaa,
        0x9a9aaaa8,0x58999aba,0x9baaaaa7,0x8abbbccc,0xbddcccc9,0x8caccddc,0xcdccdddb,
        0x8bbbbddc,0xcdcccdca,0x7bbabddb,0xcddcccda,0x599a89ba,0x9baa9aa8,0x699a9aba,
        0xabaaaaa8,0x8bccbbdc,0xcddcdcda,0x7aababbb,0xacbbbbb9,0x699a9aba,0x9baaaaa7,
        0x8abbbbcb,0xbccbcbc9,0x9ccddded,0xdededddb,0x8bbcbcdc,0xbccbccc9,0x8bbbbcdb,
        0xbdcbccc9,0x8bccacdc,0xcdddbcca,0x9bccbbdc,0xcdddccda,0x9cddcbec,0xddddecda,
        0xadddcded,0xdeedcddb,0x9cbcbbdc,0xcdccccc9,0x9bcccbdb,0xcddcccc9,0xceffeeff,
        0xefeffffd,0xaddddded,0xdeedddea,0x9cccccdb,0xcddcccc9,0x599a9aba,0x9b9a9aa8,
        0x7aababcb,0xabbbbbb9,0xacddcded,0xceedddeb,0x6a9babbb,0xabababb9,0x699a9aba,
        0xabaaaaa8,0x9bccbcdc,0xcdccccc9,0x9cbdcddd,0xcdbdedda,0x9bbbbcdc,0xcdcbccc9,
        0x8bcccddc,0xcddcccc9,0x699a9aba,0x9bba8aa8,0x69aa9aba,0x9bbaaaa8,0x9bccccec,
        0xcdccccc9,0x7aaaaaba,0xabbaaba8,0x58898999,0x8a998996,0x79aaaaba,0xabbaaaa7,
        0x9ccccddc,0xcdccccca,0x7aaaabba,0xabaaaaa7,0x7aaaabb9,0xabbaaaa7,0x9cccbcdc,
        0xbddd9cca,0x9bbcbcdb,0xbcccbbc9,0xacddccdc,0xcedcccc9,0x9bccbcdc,0xcddcbcca,
        0x7aaaaaba,0xabbaaaa7,0x8abbaaba,0xbbbabaa7,0xbedddeed,0xdeedddeb,0x9bbbbbcb,
        0xbccbbbb8,0x8aaaaab9,0xabbaaaa6,0x9ccccded,0xcdddbdeb,0xaddddeed,0xdeeedeeb,
        0xcfffefff,0xeffffffd,0x9ccdcedd,0xcecddddb,0x9cccccdc,0xcdccccda,0xbddddeed,
        0xdeededdb,0xaddedeed,0xdebdefeb,0xaccdcddd,0xddccddda,0xaddddeed,0xdfdcddda,
        0x9cccbddd,0xbeddaccb,0x9bcdbcdc,0xcddcbcca,0xbddedefe,0xeeeeddeb,0x9cccbcdc,
        0xcdccbcca,0x8aababba,0xabbaaaa8,0x9bbbbbcb,0xbccbcbb8,0xaccedded,0xdeddddda,
        0x9bbbbbcb,0xbcaabbb7,0x8bbabbca,0xbbbabaa7,0x9ccdbded,0xceed9cca,0xacdccddc,
        0xcdddacca,0xbddddded,0xefedccda,0xadcdcded,0xceddacca,0x8bbbabca,0xbcba9aa7,
        0x9bbbbbca,0xbbbaaaa7,0xbededefe,0xeeeddddb,0x9bbbbbca,0xbcbaaaa7,0x799999a8,
        0x9a989884
      }
    },
    {
      {
        0xbba8a9a8,0xaa988784,0xdcdadac9,0xdcb9b9a5,0xfcfbfbfa,0xfdfbebc7,0xddbadbc9,
        0xcca9ba95,0xfedafcd9,0xedc9caa6,0xfffafdfa,0xffebecc7,0xffcbffeb,0xffbaecb7,
        0xffdafffa,0xffdaedc7,0xffe9fff9,0xffeafdd7,0xdddbcac9,0xccbaa995,0xfefccada,
        0xedcab9a6,0xfefdfafa,0xfffcfbc7,0xffdcecda,0xdecacaa6,0xffececda,0xfedacaa6,
        0xfffcfcfa,0xfffbfbc7,0xfffdfffc,0xffdcedc8,0xfffcfffb,0xffdbecc7,0xfffbfffa,
        0xffebfcc6,0xffffcbfb,0xffdcbab7,0xfffedafa,0xfffcdac7,0xffffe9fa,0xfffdeac7,
        0xfffffdfc,0xffdddbc8,0xfffefcfb,0xfffcdbc7,0xfffdfbfa,0xfffcebc6,0xfffffffd,
        0xfffefdc8,0xfffffffb,0xfffdfcc7,0xfffdfdf9,0xfffcfcc6,0xddcbcbca,0xbca9a995,
        0xffecfcea,0xddcacaa6,0xfffdfdfb,0xfffcfcd8,0xffccedda,0xcdaabaa6,0xffebfdea,
        0xddbacaa6,0xfffcfdfb,0xffdbfcc7,0xffddfffc,0xffbaecb7,0xffecfffb,0xffcafcb7,
        0xfffafffa,0xffdafdc6,0xffecdcda,0xddbaa9a6,0xfffcdbea,0xedcabaa6,0xfffdfcfb,
        0xfffcdbc7,0xffeceddb,0xddbabaa6,0xffdbecda,0xedcabaa5,0xfffcfcfa,0xfedadab5,
        0xfffdfffc,0xffcbdcb7,0xffecfdea,0xffcadba5,0xfffbfdea,0xffc9dbb5,0xfffffdfc,
        0xffdcbab7,0xfffffcfb,0xffeccab7,0xfffefbfb,0xfffddac6,0xfffffefc,0xffdccbb7,
        0xfffdecea,0xfedbcaa5,0xfffdfbea,0xffebdab5,0xfffffffc,0xffecdcb7,0xfffdfdfb,
        0xffdbcba5,0xfffcfce9,0xffdadaa4,0xffedfffc,0xddbbbbb7,0xfffefffd,0xffdcdcc8,
        0xfffffffd,0xfffdfce8,0xffdefffd,0xdfbbccb7,0xfffdfffc,0xfecbdbb7,0xfffffffc,
        0xffdbfcc7,0xfffefffd,0xffaaedb7,0xfffdfffc,0xffbaecb7,0xfffcfffb,0xffc9fcb6,
        0xfffffefc,0xdfccbbb7,0xfffefdfc,0xffdccbb7,0xfffffefc,0xfffcebd7,0xfffefffc,
        0xdfcbbba7,0xfffdfdfb,0xddcacaa5,0xfffdfdfb,0xfedadab5,0xfffefffd,0xffbbdca7,
        0xffedfffb,0xfebacba5,0xfffcfdfa,0xfdc9daa4,0xfffffffd,0xdfecaaa7,0xfffffefc,
        0xfffcbab6,0xfffffcfb,0xfffccac6,0xfffffffc,0xffdcbba6,0xfffefdeb,0xfdcbbaa5,
        0xfffdfcea,0xfddac9a4,0xfffffffc,0xffcbbba6,0xfffdfdeb,0xfebaba94,0xfffcfcd9,
        0xfdb8b982
      },
      {
        0x15565676,0x67676774,0x478888b9,0x9a999aa7,0x89cbcbec,0xcdcdccda,0x498999b9,
        0x9b9aaaa7,0x58989ab9,0x9baa9aa7,0x8ababcdb,0xcddbccca,0x9cabddec,0xcebcdddb,
        0x8bbbccec,0xcdccdcea,0x7ab9bcdb,0xcddcccda,0x489989ba,0x9baa8aa8,0x599a99ba,
        0xabaaaaa8,0x8accbadb,0xceccdcda,0x7aababcb,0xbcbcbbb9,0x699a9aba,0xabaaaab8,
        0x8bbbbbdb,0xcdccccca,0xadceeffe,0xefeeffec,0x9bcccdec,0xcdccddda,0x8bbbccdb,
        0xcddcccda,0x8cccabec,0xceddacda,0x9cccbbec,0xceddccda,0x9bccbadb,0xceccccda,
        0xadeecdfd,0xdffddeec,0x9cccbcdc,0xcdddccda,0x9bcccbdc,0xcddcccca,0xceffffff,
        0xfffffffe,0xbeeedefd,0xeffefeec,0x9bbbccdb,0xcdccccca,0x599a9aba,0x9baa9aa8,
        0x7abbbbcb,0xbcbcbcc9,0xacededfd,0xeffdeeec,0x6a9baaca,0xac9abbb9,0x6aaaaaca,
        0xacabbbb8,0x9bccccec,0xdeddddea,0x9cbdddec,0xcebceedb,0x9cbbcced,0xceccddda,
        0x9ccbcdec,0xceccddda,0x69aa9aba,0x9bbb8ab8,0x6aaaaaca,0xacbbabb8,0x9bdcccfc,
        0xdfddccda,0x7aababcb,0xbcbbbbb9,0x588989a9,0x9a999997,0x7aaabaca,0xbcbbbbb9,
        0xadcdddfd,0xdfddeedb,0x8babbbcb,0xbcbbbbb9,0x7aaaaaca,0xbbbbbbb8,0x9cdcacdd,
        0xceed9cda,0x9cccbcdc,0xcdddccca,0x9cdccbec,0xdedddcdb,0xadddcced,0xdedecddb,
        0x8abbaacb,0xbcbbbbb9,0x8abbbaca,0xbcbbbbb9,0xceefeffe,0xfffeeefd,0x9cccccdc,
        0xcdccccca,0x7aaaaaba,0xabbabab8,0xaddedeed,0xcedebdec,0xbeeeeefe,0xefffefec,
        0xdfffffff,0xfffffffe,0xadceddfd,0xdfcdedeb,0xadcdddfe,0xdfddeeeb,0xceeeeffe,
        0xfffefffc,0xadcddded,0xdfbdffdb,0xaddddefe,0xdfcdfedb,0xbdddddfd,0xefdddeeb,
        0xadddcdfe,0xcfeeaddb,0xaddeddfd,0xdeddceeb,0xcefeeefe,0xffffeefc,0xaddddded,
        0xdfdddedb,0x8bbbbbcb,0xbcbcbbb9,0xacccccdc,0xcdcdccda,0xbedeeefe,0xdfddffdc,
        0x9bbbbbdb,0xccbbccc9,0x9bbbbbdb,0xbcbbbbb9,0x9dddbdfd,0xcfff9cdb,0xadddcdfd,
        0xdfedbcdb,0xbdddddfd,0xdfeeddeb,0xbdeedefd,0xeeeecedb,0x8bbbbccb,0xbccbabb9,
        0x9bbbbbcb,0xbcbbbbb9,0xceeeefff,0xffffefec,0x9bbcbccb,0xcdccbcc9,0x699999a9,
        0x9a999996
      }
    },
    {
      {
        0x99878786,0x88767663,0xcab8b8b8,0xbaa89885,0xebead9d9,0xdccacab6,0xcba8bab8,
        0xbb989985,0xdcb9cbc8,0xcba9ba95,0xfdd9ecd9,0xeedadbb7,0xedbaedca,0xdda9cba7,
        0xefcafdda,0xeeb9dcb7,0xfed9fdd9,0xfed9dcb6,0xcbbaa8b8,0xbba99885,0xccdbb9b9,
        0xdcbaa996,0xfdfcdae9,0xfedbdab7,0xddcbcbc9,0xccbaa996,0xeddbdbc9,0xdcbabaa6,
        0xfefcece9,0xfedbdbb6,0xefdcfddb,0xeebbcbb7,0xffdcfdda,0xeedadbb7,0xffebfde9,
        0xffcbdcb6,0xdddccaca,0xddcba9a7,0xfefccada,0xeddcbab7,0xeefdd9d9,0xfeecd9b7,
        0xfffdecdb,0xeecccbb7,0xfffdecda,0xffdccbb7,0xfffdfbea,0xfeecdbb7,0xfffffeec,
        0xffdcdcb8,0xfffdfeea,0xffdcecb7,0xfffdfdd9,0xffecdbb6,0xbbbabab9,0xaa988885,
        0xdcdbcbc9,0xccb9b9a6,0xfdfcecfb,0xeddbdbc7,0xddcadbca,0xbb99a996,0xddcbdbca,
        0xccb9ba96,0xfeebfdea,0xfdcadbb7,0xffccfedb,0xddaacba7,0xffdbfddb,0xedbadbb7,
        0xfedafeea,0xfecadcb7,0xdccbcac9,0xbca99996,0xeddccbca,0xdcbab9a6,0xfefdebea,
        0xfddbdab7,0xdecbdcca,0xccaaa996,0xdddbdcc9,0xdcb9b995,0xfeecfcea,0xedcacaa6,
        0xffdcfedb,0xeebacba7,0xffdcfdda,0xedbacba6,0xffebfdda,0xeecadba5,0xfeeddbdb,
        0xcdcbaaa7,0xfffddbeb,0xeddbbab7,0xfffedbeb,0xfedccab7,0xfffeedeb,0xddcbbaa7,
        0xffeddbda,0xddcbbaa6,0xfffdebda,0xeedbcab6,0xfffffefc,0xeedbcba7,0xfffdeddb,
        0xfecbcba6,0xfffcfcd9,0xfedacaa5,0xdeccdcdb,0xbcaaaa97,0xffecfdfc,0xddcbcbb7,
        0xfffdfdfc,0xfdececc8,0xeeddeddb,0xcdaabba7,0xefeceddb,0xddbacbb7,0xfffcfeec,
        0xfedaebc7,0xffdcfeec,0xdd9adba7,0xffecffec,0xedbadcb7,0xffecfefb,0xfdc9ecb6,
        0xeeedddeb,0xcdbbaaa7,0xfefdeceb,0xddcbbab7,0xfffefdfc,0xfedbdac7,0xffedfdec,
        0xddbabaa7,0xefededdb,0xdcbabaa6,0xfffdfcfb,0xedcacab6,0xffedfeec,0xdeaacba7,
        0xffecfdeb,0xedbacaa6,0xffecfdfb,0xedc9caa5,0xfffdddec,0xdddbaaa7,0xfffdedfc,
        0xeddcbaa6,0xffffecfb,0xeedbc9b6,0xfffdeedc,0xddcbbaa7,0xfefdfceb,0xddcbb995,
        0xfefdfcfa,0xfdcac9a5,0xfffeffec,0xdfbbbb96,0xfffdfddb,0xeebaba95,0xfffcfce9,
        0xedc9c993
      },
      {
        0x5565687,0x68676775,0x589999ba,0x9baaaab8,0x89cacbdc,0xdddddddb,0x59899aca,
        0xac9babb8,0x59999aca,0xacbbabb8,0x8acbcdec,0xdfddddeb,0x9cacddfd,0xdecdeefb,
        0x8cbbddfd,0xdeddeeeb,0x7abacdec,0xceddceea,0x599a89ca,0x9cab9bb8,0x599aa9ca,
        0xacabbbc9,0x8bcccbfc,0xdeddedeb,0x7bbcbced,0xcecdccda,0x6aababcb,0xbcbcbcc9,
        0x8bccccfc,0xcedddeeb,0xaedeefff,0xefeffffd,0x9ccdddfe,0xdfeeeefc,0x8bcccdfd,
        0xcedddfeb,0x9cddacfd,0xdfeebdeb,0x9cddbbfe,0xdfeeddfb,0x8bcdcafc,0xdecdddeb,
        0xaeffdfff,0xfffffffd,0x9cddcdfe,0xdfffdefc,0x9ccdccfc,0xcddeedec,0xceffffff,
        0xfffffffe,0xbfffefff,0xfffffffd,0x9bcdccdc,0xcdcdddeb,0x59aa9acb,0xacababb9,
        0x7bccbcdd,0xceddddeb,0xbdfeeefe,0xfffffffd,0x6aabbbdc,0xbdabccca,0x7abbbbdc,
        0xbdbccdda,0xacddddfe,0xefeefffc,0x9dbddefe,0xcfbdffec,0x9ccddefe,0xdfdeeffb,
        0x9cdcddfe,0xdfeedffc,0x6aaa9bdc,0xadcc9bc9,0x7abbabdc,0xbeccbcda,0xacddddfe,
        0xdfeffffd,0x7bbcbced,0xbecccdda,0x599a9acb,0xacababb8,0x8bccccdc,0xcedddddb,
        0xaededeff,0xffeffffd,0x8cbccced,0xcdcddedb,0x8bbbbcdc,0xcdccccda,0x9cedbdfd,
        0xdfeebdfb,0x9dddcdfe,0xdfffcdfc,0xacdddcfd,0xdfeeeefc,0xaeeedeff,0xefffdffc,
        0x8cccbced,0xceddcdea,0x8bbcbbdc,0xcdcdddda,0xcfffffff,0xfffffffe,0xaddeedff,
        0xdfdeeffb,0x8bbcbbdb,0xbdccccda,0xaddfdfff,0xcfdfdffc,0xbfffffff,0xfffffffd,
        0xdfffffff,0xffffffff,0xaedfdeff,0xefdefffc,0xaedfefff,0xefeffffd,0xcfffffff,
        0xfffffffd,0xadcdedfe,0xdfbdffec,0xaddfdeff,0xefdefffd,0xbddedffe,0xdfeeeffc,
        0xadeeceff,0xdfffbeec,0xaeffefff,0xefffdffd,0xcfffffff,0xfffffffe,0xaedfefff,
        0xfffffffc,0x9ccdddfe,0xdfdeddeb,0xbedfdefe,0xefeefefc,0xbfdfefff,0xffdefffd,
        0x9ccddcfd,0xcfcdeeeb,0x9ccdccfd,0xdeddddeb,0x9dedcefe,0xdfffadfb,0xaddfdefe,
        0xefffcefc,0xbeeeeeff,0xfffffefc,0xbfffefff,0xffffdffc,0x9cddcdfd,0xcfedbdfa,
        0x9ccdcdfd,0xdeddcdda,0xcfefffff,0xfffffffd,0xacdeddfe,0xdfdedefb,0x7aaaabcb,
        0xacababb8
      }
    },
    {
      {
        0x77767675,0x77656553,0xa9a8a8a7,0xa9989785,0xcac9b9c8,0xcbc9b9a6,0xaa98a9a8,
        0x9a879885,0xbba8bab8,0xbba8a996,0xdcc9ebc9,0xecc9cbb7,0xcca9dcb9,0xcc99ba97,
        0xedc9dcc9,0xdcb9cba7,0xddc9fcc9,0xedc9cbb7,0xaaa99898,0x99988785,0xbbbaa8b8,
        0xbba9a896,0xdcdbc9c9,0xecdbb9b7,0xccbabab9,0xbba9a996,0xdccacbb9,0xccbab996,
        0xfeebdbc9,0xedcbcbb7,0xeeccdddb,0xddbacba7,0xefdbedca,0xeecbcba7,0xfeebfdd9,
        0xeedbdbb7,0xcccca9b9,0xbcba9997,0xdcdcb9c9,0xddcbb9a7,0xedfdc9d9,0xfddcc9b7,
        0xeedddccb,0xddcbbaa8,0xeeeddbda,0xedcccaa7,0xfefdebda,0xffecdbb7,0xfffdeddb,
        0xeedccba8,0xffeefdda,0xffdcdbb7,0xfffcecd9,0xffecdbb7,0xaaa9a9a8,0x99878885,
        0xbbcabab9,0xbba9a996,0xecebdcda,0xdccacab7,0xbcbacab9,0xab98a996,0xdccadbca,
        0xbba9ba96,0xedebecea,0xedcacbb7,0xddcbedcb,0xcca9cba7,0xfecbeddb,0xddbadba7,
        0xfedbfeea,0xedcadcb7,0xbbbabab9,0xaaa99886,0xccdbcaca,0xcbbaa996,0xedfcdbda,
        0xdddbcab7,0xcccbcbca,0xbba9a996,0xddcbcbc9,0xcca9b996,0xfeecebda,0xedcacaa6,
        0xefdceddb,0xddbacba7,0xfedcedda,0xddbacba6,0xfeebfdda,0xedcadba6,0xdeddcbcb,
        0xccbba9a7,0xeeedcbdb,0xddcbbaa7,0xfefddbeb,0xfddccab7,0xeeeddcdb,0xddcbbaa7,
        0xeeeddcdb,0xddcbbaa6,0xfefdebea,0xeddbcab6,0xfffefedc,0xeecbcba8,0xfffdeddb,
        0xeecbdba7,0xfffdfdda,0xeedbdba6,0xcccbcbca,0xaba99997,0xeddcdcdb,0xccbacaa7,
        0xfefdfdfc,0xeddbdbc8,0xdeccdcdb,0xbcaabaa7,0xeedceddb,0xccbacba7,0xfffcfefc,
        0xeddbdcc8,0xdeccfeec,0xcdaacba8,0xffdcfefc,0xddbadcb7,0xffebfeeb,0xedcadcb7,
        0xdddcdcdb,0xbcbaaaa7,0xeeeddceb,0xdccbbaa7,0xfffeedfc,0xeddbdbb8,0xeedddddc,
        0xcdbabaa7,0xeeeceddb,0xccbabaa6,0xfefdfdeb,0xeddbcbb7,0xffedfeec,0xddbacba7,
        0xffecfddb,0xdebacba6,0xfffcfeeb,0xedcadba6,0xeeedccdc,0xcdcbaaa7,0xfffdeceb,
        0xdddcbab7,0xfffdeceb,0xeddbcab7,0xeffdedec,0xddbbaaa7,0xfeededdb,0xddcbbaa6,
        0xfffceceb,0xeddbcaa6,0xfffeefec,0xddbbbba7,0xfffdfddb,0xeecaba96,0xffecfdda,
        0xedc9ca94
      },
      {
        0x5565686,0x58676774,0x479999ba,0xabaaabb8,0x89bacbec,0xdeeddeeb,0x59899acb,
        0xacabbbb9,0x5999aaca,0xacbbabb9,0x8bcbccfc,0xdfeddefb,0x8cacddfe,0xdfceeeeb,
        0x8cbcdefe,0xdfeeeefb,0x7bbacdec,0xcedddddb,0x599a89ca,0xacbb9bb8,0x59aaa9cb,
        0xacbbbbc9,0x8bcccbfc,0xdfdefdeb,0x7bccccfd,0xcfcddddb,0x6aababdc,0xbdccbcca,
        0x8bcccced,0xdffeeefb,0xafdfffff,0xfffffffd,0x9ddeefff,0xdfdffffc,0x8cccddfd,
        0xdfeddffc,0x8cddacfd,0xcfefcdeb,0x9cdecbfd,0xdfeeddfc,0x8bcdbaec,0xcecdedfb,
        0xaeffdfff,0xeffffffc,0xaddecdfe,0xeffffffc,0x9bcdccfd,0xdddfedfc,0xcfffffff,
        0xfffffffe,0xbfffffff,0xfffffffd,0x8bcdccfc,0xceefeefb,0x5aab9bcb,0xacababc9,
        0x8bccccfd,0xdedddddb,0xbdffffff,0xfffffffd,0x6aabbbdc,0xbdacccca,0x7bbcbcdc,
        0xcdcccdda,0xaddefeff,0xeffffffc,0x9dbdeeff,0xdfbefffc,0xadceeeff,0xdfddfffc,
        0xadddefff,0xfffefffc,0x6aba9bdc,0xbdcc9bc9,0x7bbcbbec,0xcdccccda,0xacefdeff,
        0xfffffffc,0x8bcccced,0xcecdcddb,0x6aaaaacb,0xacababb9,0x8bccccfc,0xdfedddfb,
        0xbddfffff,0xffeffffd,0x9ccdddfe,0xdfddfeeb,0x8bcccefd,0xcfdccdda,0x9dedbdfe,
        0xcfffbdfb,0xadddddfe,0xefffdefc,0xaddfdcfe,0xdfefeefc,0xbfffdfff,0xffffeffd,
        0x9cddcdfd,0xcfeecddb,0x8bcdcbfd,0xcfddddeb,0xdfffffff,0xffffffff,0xbeefffff,
        0xfffffffc,0x8bccccdc,0xbeddddda,0xaddfdfff,0xcfdfdffc,0xcfffffff,0xfffffffd,
        0xdfffffff,0xffffffff,0xaddffeff,0xefdffffd,0xbeefffff,0xfffffffd,0xdfffffff,
        0xfffffffd,0x9dbeeeff,0xdfbdffed,0xbedfffff,0xefdffffd,0xbeeeefff,0xfffefffd,
        0xaeefdfff,0xdfffcffc,0xbfffffff,0xfffffffd,0xdfffffff,0xffffffff,0xbfffffff,
        0xfffffffd,0xaedfddfe,0xdfefeffb,0xbfffffff,0xfffffffc,0xbfefffff,0xffeffffd,
        0x9dcdedfe,0xdfcfffec,0x9dddcdfe,0xefdddffb,0x9dedcffe,0xcfffbdfb,0xafffdeff,
        0xffffdffc,0xbedfefff,0xfffffdfd,0xcfffffff,0xffffeffd,0xaddddefd,0xdfffceeb,
        0x9dcdddfe,0xdfeeddfb,0xcfffffff,0xfffffffd,0xbddfffff,0xffeffffc,0x7aabbbcb,
        0xacbbbcb9
      }
    },
    {
      {
        0x45555565,0x56555553,0x88878797,0x99888785,0xa9b9a9b8,0xbaa9a9a7,0x89879998,
        0x89778876,0x9a98aaa8,0xaa989996,0xcbb9cbc9,0xcbbacba8,0xab99bba9,0xab99aa97,
        0xbba9ccc9,0xccbacba8,0xbbb9ccc9,0xccb9cbb8,0x88998798,0x89887785,0x9aaa98a8,
        0xaaa99896,0xbbcbb9c9,0xcccbbaa8,0xabaaaaa9,0xab999997,0xbbbabaa9,0xbbaaaa97,
        0xdccbcbc9,0xddcbcbb8,0xcdcbcccb,0xccbbbba8,0xddcbccca,0xddcbcbb8,0xdedbecca,
        0xeddbdcb8,0xaabb99ba,0xabaa9997,0xbbdca9ba,0xcccbb9a8,0xccddb9ca,0xdddcbab8,
        0xccccbccb,0xcdbbbba8,0xcddccbca,0xddcbcbb8,0xdddddbca,0xeeecdbb8,0xdeecddcb,
        0xcdccbba9,0xffededca,0xeedcccb8,0xeeecdcca,0xeeecdcb8,0x78888898,0x79887786,
        0xaaaaaab9,0xaaa99997,0xccdbcbda,0xcccbcab8,0x9a9aaab9,0x9a999997,0xbbbabbba,
        0xaba9aa97,0xdcdbdcdb,0xdccacbb8,0xbcbbcccb,0xbcaabba8,0xcdcbdddb,0xdcbacbb8,
        0xddcbedeb,0xddcaccb8,0x9aaa99b9,0x9a998896,0xbbcbbaba,0xbbbaa997,0xdcdcdbcb,
        0xdcdbcab8,0xbcbbbbba,0xaba99997,0xbbbbbbba,0xbba9a996,0xdddbdbda,0xdccacaa7,
        0xceccdddb,0xcdbbbba8,0xdecbdcca,0xccbacba7,0xeeebedda,0xddcacbb7,0xbcccbbcb,
        0xbcbbaaa8,0xcdedcbdb,0xccdbbab8,0xddeddbdb,0xdddccab8,0xcdddccdc,0xccbbbba8,
        0xdddccccb,0xcdcbbaa7,0xededdcda,0xeddbcab7,0xdeddeddc,0xdeccbba9,0xfeddddcb,
        0xddcbcba8,0xeeedfdda,0xeedbcba7,0xababbbba,0x9a999997,0xccccccdb,0xbbbbbab8,
        0xdddcecec,0xdddbdbc9,0xbcbccccb,0xabaabaa8,0xddccdddb,0xbcbacbb8,0xddeceeec,
        0xeccbdbc9,0xcebcdddc,0xbcaacba9,0xdedcedec,0xddbaccb8,0xdedcedec,0xddcadcb8,
        0xbcccbccb,0xabbaaaa8,0xcddcdcdb,0xcccbbaa8,0xeefdeddc,0xeddccbc9,0xcddccddc,
        0xbcbbaaa8,0xdddcdcdb,0xccbabaa7,0xeeeceddb,0xdccbcbb8,0xdeddeedc,0xcdbbcbb8,
        0xeedceddc,0xddbacba7,0xefdceeeb,0xddcadbb7,0xbdccccdb,0xbcbb9aa8,0xdeedccec,
        0xcddbbab8,0xeefddcec,0xdddccab8,0xdedddddc,0xcdcbbba8,0xdeeddddb,0xcdcbbaa7,
        0xeeeddceb,0xeddbcaa7,0xdfdddedc,0xcdbbbba8,0xeeededdb,0xddcbbaa7,0xeedcecdb,
        0xddcacaa6
      },
      {
        0x4565687,0x58776775,0x47999acb,0xacbbbbc9,0x79cbccfd,0xdffdfffb,0x498aabcb,
        0xacabbbc9,0x59aaabdb,0xacccbcca,0x7bcbddfd,0xdffffffc,0x8caddfff,0xdfdffffc,
        0x8cccdfff,0xfdfffffd,0x7bcbcdfd,0xdfffdffc,0x49ab8acb,0xacccabc9,0x59abaadc,
        0xbdbcccca,0x8bdeccff,0xdffffffc,0x7ccdcdff,0xdfdfdfdc,0x6abcbbdc,0xbdcdcddb,
        0x8cddddff,0xfffffffc,0xafffffff,0xffffffff,0x9edfffff,0xfffffffd,0x8cdddfff,
        0xdffffffd,0x8cdeacfd,0xdfffcdfc,0x8cdfccff,0xdffffefd,0x7bcfcbfd,0xcfdffffc,
        0xafffffff,0xffffffff,0x9dffdfff,0xfffffffd,0x8cffddff,0xdffffffd,0xbfffffff,
        0xffffffff,0xbfffffff,0xffffffff,0x8cdeddfd,0xcfffdffd,0x5aababdc,0xadbcbcca,
        0x8ccdcdff,0xdfffeffc,0xadffffff,0xffffffff,0x6aacbcfd,0xbfbddddb,0x7bbcbdfd,
        0xcfdddddb,0xaeefffff,0xfffffffd,0x9dcfffff,0xdfdfffff,0x9fdfffff,0xfffffffd,
        0x9fdfffff,0xfffffffd,0x6abbacfd,0xbeddaccb,0x7bbcccfd,0xcfcecddb,0xadffffff,
        0xfffffffd,0x7bcdcdff,0xdfdfdfec,0x5aababcc,0xacbcbcca,0x8cddddfd,0xdfffffdc,
        0xafffffff,0xffffffff,0x9dcddfff,0xdfdffffc,0x8cdccffd,0xcfffcfdc,0x9ddfcfff,
        0xffffcdfd,0xafffdfff,0xfffffffd,0x9dffddff,0xfffffffd,0xbfffffff,0xffffffff,
        0x9ddddfff,0xdfffdffc,0x8ccfddff,0xdfdffffc,0xcfffffff,0xffffffff,0xbfffffff,
        0xffffffff,0x8cddcffd,0xcfdfddfb,0x9ddfffff,0xcfffdffd,0xbfffffff,0xffffffff,
        0xdfffffff,0xffffffff,0xafdfffff,0xfffffffd,0xbfffffff,0xffffffff,0xcfffffff,
        0xffffffff,0x9dcfffff,0xdfbffffd,0xafffffff,0xffefffff,0xafffffff,0xffffffff,
        0xafffffff,0xdfffdffd,0xbfffffff,0xfffffffd,0xcfffffff,0xffffffff,0xbfffffff,
        0xfffffffe,0xafffffff,0xdffffffc,0xcfffffff,0xffffffff,0xbfffffff,0xffffffff,
        0x9edfffff,0xffdffffd,0x9ddddfff,0xfffffffc,0x9dffcfff,0xdfffbffd,0xafffffff,
        0xffffefff,0xafffffff,0xffffffff,0xbfffffff,0xffffffff,0x9edfdfff,0xffffdffc,
        0x9edfefff,0xfffffffc,0xcfffffff,0xffffffff,0xaddfffff,0xfffffffd,0x7bbcbddd,
        0xbfcdbdda
      }
    }
  },
  /* Intra 8x8 descriptor: */
  {
    {
      {
        {
          0x2232444,0x14353555
        },
        {
          0x2332344,0x24343442
        },
        {
          0x3333443,0x34343331
        },
        {
          0x5545453,0x55433330
        }
      },
      {
        {
          0x1231456,0x25463677
        },
        {
          0x2232344,0x24352454
        },
        {
          0x2232344,0x24343443
        },
        {
          0x3333443,0x34433331
        }
      }
    },
    {
      {
        {
          0x3232343,0x24342444
        },
        {
          0x3333343,0x34332332
        },
        {
          0x3333343,0x34443331
        },
        {
          0x4544453,0x55434330
        }
      },
      {
        {
          0x1231456,0x25463677
        },
        {
          0x2232344,0x24352454
        },
        {
          0x2232344,0x24343443
        },
        {
          0x3333343,0x34433341
        }
      }
    },
    {
      {
        {
          0x2232334,0x24343444
        },
        {
          0x3333343,0x24333332
        },
        {
          0x3332343,0x34333332
        },
        {
          0x4444453,0x45444330
        }
      },
      {
        {
          0x1231356,0x25464677
        },
        {
          0x2232255,0x25352554
        },
        {
          0x2232344,0x24343443
        },
        {
          0x3333353,0x35433331
        }
      }
    },
    {
      {
        {
          0x2232334,0x24343444
        },
        {
          0x2232344,0x24343443
        },
        {
          0x2332343,0x34343432
        },
        {
          0x3433343,0x34433331
        }
      },
      {
        {
          0x1231365,0x26464666
        },
        {
          0x2222355,0x25352554
        },
        {
          0x2232344,0x24343443
        },
        {
          0x3333443,0x34433331
        }
      }
    },
    {
      {
        {
          0x2232345,0x14363556
        },
        {
          0x2232344,0x24343443
        },
        {
          0x2232344,0x24343443
        },
        {
          0x3333443,0x34433331
        }
      },
      {
        {
          0x1231356,0x26464666
        },
        {
          0x1232354,0x25353555
        },
        {
          0x2232344,0x24343443
        },
        {
          0x2333343,0x34333332
        }
      }
    }
  },
  /* Intra luma 4x4 descriptor: */
  {
    {
      {
        0x8585978,0x6a7a8a89,0xdfcdcdba,0x4a697978,0x7b7a8b89,0xdfbccdaa,0x9d8aac99,
        0xae8abc99,0xefbbcda8,0x5a696978,0x7b8a8a89,0xdfcccdaa,0x6b7a7a88,0x8c8a8b89,
        0xdfbcbda9,0xad9bac99,0xbe9bbc99,0xefbbcd98,0x9dac8b99,0xaebc9b99,0xdfcdbca9,
        0xadac9b99,0xbeac9b99,0xefccbca8,0xcfbcbc98,0xdfbcbc98,0xffbbcc96,0x39586978,
        0x7b8a8a88,0xdfcccdaa,0x5a697a78,0x8b8a8b88,0xdfbccda9,0x9d8aac88,0xad8aac98,
        0xdfabcd98,0x5a796978,0x8b8a8a88,0xdfccbca9,0x7b797a88,0x8b8a8a88,0xdfbcbca9,
        0xad9aac88,0xad9aac88,0xdfabcd97,0x9dab8b99,0xadac9b99,0xdfcdbca8,0xadab9b99,
        0xadab9b98,0xdfccab98,0xcfbcbc98,0xcfabac97,0xefbbbb86,0x7b7a8b89,0x9d9bac99,
        0xffddddba,0x7c7a8b99,0xad9bac99,0xffcdddba,0xad8bac99,0xbe9bbd99,0xefbbdda8,
        0x8c8a8b99,0xad9b9b99,0xefddcdba,0x8c8a9b99,0x9d9b9b99,0xefcccda9,0xae9bac99,
        0xae9bbc98,0xefabcd98,0xaeac9b99,0xbfbcac99,0xffddbca8,0xaeac9c99,0xbebc9b99,
        0xdfccbc98,0xcfbcbc98,0xcfabac98,0xdfabbb86,0x9e9bac99,0xbfbcbca9,0xffdddeb9,
        0x9d9b9c99,0xbeabac99,0xffdcdda8,0xad9aab88,0xbe9aac87,0xffbbcc96,0x9e9b9c99,
        0xbeabac99,0xffdcdda8,0x9d9b9b99,0xbeabac99,0xffcccda8,0xad9a9b87,0xad8aab87,
        0xdf9abc86,0xaeab9b98,0xcfabab98,0xffccbc96,0xae9b9b87,0xbeab9b87,0xdfbbab86,
        0xad9a9b76,0xad899a75,0xbe888963
      },
      {
        0x5262656,0x48586877,0xfffffffa,0x27475766,0x6a697978,0xffffffd9,0x7f6a9f88,
        0xaf8dff98,0xfffffff9,0x27474766,0x6a797978,0xfffffffa,0x59686977,0x7a797a77,
        0xffffffa9,0x9f8caf98,0xaf8aff98,0xffafffa8,0x8f9a7a88,0xafbf9f99,0xfffffff9,
        0x9faf9f99,0xafaf9f98,0xffffffa8,0xffffffa8,0xffffffa8,0xffafff86,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff
      },
      {
        0x17485877,0x7b8a8a99,0xffdfdfdb,0x49587978,0x8b8a9b99,0xffdeefcb,0x9c8bab99,
        0xbeabbca9,0xffedefcb,0x59796978,0x8c9a9b99,0xffdfdfcb,0x6a7a8a88,0x9c9a9b98,
        0xffdddeba,0xadabac99,0xbeacbca9,0xffdfeeca,0x9cab9b99,0xbebcacaa,0xffefdeca,
        0xadacaba9,0xbfbcbca9,0xffefceba,0xcebccdaa,0xdfcccdaa,0xffedeeb9,0x27586877,
        0x7b8a8a88,0xffeeefcb,0x59687977,0x8b8a9b98,0xffdddeca,0x9c8aab99,0xbdabbca9,
        0xffddeeca,0x59796978,0x9b9a9a98,0xffdedeca,0x7a798a88,0x8c8a9a88,0xffcdddb9,
        0xad9bab99,0xbdabbc99,0xffcdeeb9,0x9cab9b99,0xbdbcaca9,0xffedddba,0xadab9b99,
        0xbebbac99,0xffdecdb9,0xcebcbca9,0xcfbcbca9,0xffcdcea8,0x59797a89,0xacabaca9,
        0xffffffcb,0x7a8a8a99,0xadababa9,0xffeeffcb,0xad9bbca9,0xcfbccdaa,0xffefffcb,
        0x7b8a8a99,0xadababa9,0xffffffcb,0x8b9a9b99,0xadabac99,0xffedeeca,0xbdacbca9,
        0xbeabcca9,0xffdefeca,0xaebcaca9,0xcfcdbdaa,0xffffeecb,0xbdbcaca9,0xcebcaca9,
        0xffeececa,0xcfccccba,0xcfcccca9,0xffceddb8,0x8c9bacaa,0xcfcdcdba,0xffffffdb,
        0x9dacaca9,0xcfcccdba,0xffffffdb,0xaeacbca9,0xdfbccdb9,0xffefffca,0x9dabaca9,
        0xcfbcbdba,0xffffffdb,0xadabaca9,0xcebcbca9,0xffeeffca,0xbebcbca9,0xcfbccca9,
        0xffddfec9,0xbebcbca9,0xdfcdcdba,0xffffefca,0xbfbcbca9,0xcfccbda9,0xffefdec9,
        0xbebdbca9,0xcfbcbca9,0xffcdcda7
      }
    },
    {
      {
        0x9495a79,0x6b7a8b89,0xdfcccdba,0x4b597b89,0x7c7a8b89,0xdfbccdaa,0x8e7bad99,
        0xaf8bbd99,0xdfabcda9,0x4b7a6a89,0x7c8a8b89,0xdfbccdaa,0x6c7a8b89,0x8c8a8b89,
        0xdfbcbca9,0xae9bbd99,0xbf9bbd99,0xdfabcd98,0x9eac8c99,0xaebc9b99,0xdfcdbca9,
        0xafac9c99,0xafac9c99,0xdfcdbca8,0xcfbcbda9,0xdfbcbd98,0xffbccc97,0x2a596a89,
        0x7b7a8b89,0xdfcccdaa,0x4b597b89,0x7c7a8b89,0xdfbccda9,0x8d7aad99,0xae8abd99,
        0xdfabcda8,0x5b7a6a89,0x7c8a8b89,0xdfbccca9,0x6c7a7b89,0x8c8a8b88,0xdfbcbca9,
        0x9e8bad99,0xae8aac98,0xdfabcd98,0x8eac8b99,0xaeac8b99,0xdfcdbca9,0x9eac9c99,
        0xaeac9b99,0xdfbcab98,0xcfbcbd98,0xcfabbc98,0xdfabbc87,0x6c7b8c9a,0x9d9bacaa,
        0xffcdddba,0x7d7b8c99,0x9d9bac99,0xffccddba,0x9e8bad99,0xbf9bbd99,0xffbcdea9,
        0x7d8b8c9a,0x9e9b9c9a,0xffcdddba,0x7d8b8c99,0x9d9b9c99,0xefcccda9,0x9e9bbd99,
        0xaf8bbd99,0xdfabcd98,0xafac9c99,0xbfbc9ca9,0xefddbca9,0xafac9c99,0xafbc9b99,
        0xdfcdaca8,0xcfbcbd99,0xbfabbc98,0xdfabab87,0x9f9cadaa,0xbfacbdaa,0xffdcddb9,
        0x9e9c9c9a,0xbfacaca9,0xffdcddb9,0xae8bac98,0xbf9bbc98,0xffbbcd97,0x9f9c9daa,
        0xbfacbda9,0xffdcddb9,0x8e8b9c99,0xaf9bac99,0xffcccda8,0x9e8aac88,0xae8aac87,
        0xdf9acc97,0xafac9c98,0xcfacac98,0xffcccc97,0xaf9b9c98,0xafab9b88,0xefbcab97,
        0xaf9bab87,0xae8a9b86,0xce889964
      },
      {
        0x6273867,0x49697a78,0xffffffa9,0x19386967,0x6f698f78,0xffffffa9,0x7f699f87,
        0x9f8aff88,0xffffffa8,0x29585a77,0x6f798f88,0xffffffa9,0x4f697a77,0x7f798f77,
        0xffafff98,0x8f8aaf88,0xaf8aaf87,0xff9fff98,0x7f9f7f98,0xbfaf9f98,0xffffffb9,
        0x9faf9f98,0xafaf9f98,0xffffffa8,0xffffff98,0xffafff98,0xff9aaf86,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff
      },
      {
        0x18585978,0x7b8a8b99,0xffddeecb,0x4a697a88,0x8c8a9b99,0xefdddfba,0x9d8aac99,
        0xbe9bbca9,0xffdedeba,0x4a796a88,0x8c8b8b99,0xefcdcfba,0x6b7a8a89,0x8c8a9b88,
        0xffcdcdaa,0x9d9bac99,0xafabbc99,0xffcdcdba,0x9dac9c9a,0xbfbc9baa,0xffdecdba,
        0xaeacac99,0xbebcaca9,0xefdeceba,0xbfbcbdaa,0xcfbcbda9,0xffcdcda9,0x29586978,
        0x8b8a9b89,0xefddddba,0x5a697988,0x8c8a9b88,0xefcddeba,0x9d8aab99,0xbd9bac99,
        0xefcddfba,0x5a796a88,0x8c8a8b88,0xefddcdba,0x6a7a7a88,0x8b8a8b88,0xefcccda9,
        0x9c9bac99,0xae9bac99,0xdfbccda9,0x9dab8b99,0xaeac9c99,0xefddcdba,0x9d9b9b99,
        0xaeab9b99,0xefcdbda9,0xbfacbda9,0xbfbcac99,0xefbdbda8,0x6b8a8b99,0xadabacaa,
        0xffefefcb,0x7b8a8b99,0xadabac99,0xffdeefcb,0xad9bac99,0xbfacbda9,0xffdedfba,
        0x7c8a8b99,0xadabac99,0xffeedecb,0x8c8b8b99,0xad9b9b99,0xffdeddba,0xaeabaca9,
        0xbfabbca9,0xffcedeaa,0xafac9caa,0xbfbdacaa,0xffdedeca,0xafacaca9,0xbfbc9ca9,
        0xffddbdb9,0xbfbdbdaa,0xcfbdbda9,0xefbdbda8,0x8dacacaa,0xcfbdcdba,0xffffffdb,
        0x8d9b9caa,0xbfbccdaa,0xfffffdcb,0x9eacada9,0xcfbcbea9,0xffdfefca,0x9d9cadaa,
        0xcfbcbdaa,0xffffefcb,0x9d9b9c9a,0xbebcbca9,0xffddeeca,0xafacada9,0xbfacbda9,
        0xffcddeb9,0xafbcada9,0xcfcdbdaa,0xffefeeba,0xafbcada9,0xcfbcada9,0xffdecdb9,
        0xbfbdbd99,0xbfacad99,0xdfacbc97
      }
    },
    {
      {
        0x9495a79,0x6b7a7b89,0xdfcccdba,0x3b597b89,0x7c7a8b89,0xdfbccdaa,0x8e7bbd9a,
        0xaf8bbd99,0xdfacceaa,0x3b7a5a89,0x7c8a7b89,0xdfbccdaa,0x6c7a8b89,0x7c8a8b89,
        0xdfbcbca9,0xaf9bbd9a,0xaf9bbd99,0xefaccda9,0x9fac8c9a,0xaebc9b9a,0xefcdbcaa,
        0xafac9c9a,0xbfac9c99,0xefcdbca9,0xcfbccdaa,0xdfbcbda9,0xffcccda8,0x2a595a89,
        0x7b7a8b89,0xdfccccba,0x4b597b89,0x7c7a8b89,0xdfbccdaa,0x8e7aad99,0xae8abd99,
        0xdfabcda9,0x4b7a6a89,0x7c8a8b89,0xdfbcccaa,0x6c7a7b89,0x7c7a8b88,0xcfacbca9,
        0x9e8bad99,0xae8aac99,0xdfabcd99,0x8fac8b99,0xafac8b99,0xefcdbca9,0xafac9c99,
        0xaeac8b99,0xdfbcac99,0xcfbcbda9,0xcfacbc99,0xdfabbc98,0x6d7b8c9a,0x9d9bacaa,
        0xffddddbb,0x6d7b8c9a,0x9d9bac9a,0xffccddba,0x9e8bbd99,0xbf8bbd99,0xffbcdeba,
        0x7d8b8c9a,0x9e9b9c9a,0xffddddba,0x7d8b8c9a,0x9d9b9c99,0xefcccdba,0x9e9bbd99,
        0xaf8bbd99,0xdfabcda9,0xafad8c9a,0xbfbd9caa,0xffdecdba,0xafbd9caa,0xafac9c99,
        0xefcdbca9,0xcfbdcda9,0xbfacbc99,0xdfabac98,0x9f9cadaa,0xbfacbdaa,0xffdcdeba,
        0x9f9c9daa,0xbfacadaa,0xffdcddba,0xae8bad99,0xcf9bbd99,0xffccdda9,0x9f9cadaa,
        0xbfacbdaa,0xffddddba,0x8f9c9daa,0xaeabacaa,0xffccddb9,0x9e8bad99,0xaf8aac98,
        0xefabcd98,0xafac9c99,0xcfbcac99,0xffddcca9,0xafac9c99,0xbfac9c99,0xefccbca8,
        0xafabac98,0xae9aab87,0xce999a76
      },
      {
        0x8274867,0x4a587a78,0xffffffa9,0x19386967,0x6f698a78,0xffafffa9,0x6f699f78,
        0x9f79af88,0xffffffa9,0x2a585a77,0x6f797a78,0xffefffa9,0x4a687a77,0x6f697a77,
        0xffafff98,0x8f7aaf88,0x9f7aaf88,0xff9fff98,0x7f9a7f88,0xafaf9f98,0xffffffa9,
        0x8f9f9f88,0x9f9f8f88,0xffffef98,0xffafff99,0xcfafaf98,0xff9aaf87,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff
      },
      {
        0x9596a89,0x7b8b8b99,0xffdfdecb,0x4b698a89,0x8c8b9c99,0xffdeddcb,0x9e9bbdaa,
        0xbfacbdaa,0xffdfefcb,0x5b7a7a99,0x8c9b9b99,0xefcecdbb,0x6c8a8b99,0x8d9b9c99,
        0xefcecdba,0xaeacbdaa,0xbfacbdaa,0xffcedfba,0x9fbd9caa,0xbfbdacaa,0xffefdfcb,
        0xafbdadaa,0xbfbdadaa,0xffdecebb,0xcfcecebb,0xcfbebeaa,0xffcfceba,0x3a696a89,
        0x8c8b9b99,0xefdedecb,0x5b6a8a89,0x8c8b9b99,0xefdedebb,0x9e8bbcaa,0xbeacbdaa,
        0xffcedfbb,0x5b7a7a89,0x8d9b9b99,0xdfcdcdbb,0x7c8a8b99,0x8c8b8b89,0xdfcdcdba,
        0xaeacadaa,0xbf9cbca9,0xefbecfba,0x9eac9caa,0xbfbdacaa,0xffdecfcb,0xafadacaa,
        0xbfbd9caa,0xefcfbdba,0xbfbdbeaa,0xcfbdbdaa,0xefcecea9,0x6c8b9caa,0xaebcbcaa,
        0xffefffdc,0x7c8b9caa,0xbeacbcaa,0xffdeefcb,0xafacbdaa,0xcfbdceba,0xffdfefcb,
        0x8e9c9caa,0xbeacacaa,0xffdfffcb,0x8d9c9caa,0xadacacaa,0xffdfdfbb,0xafadbdba,
        0xbfaccdaa,0xffcedfba,0xbfbdadaa,0xcfcdbeba,0xffffdfcb,0xbfbdadba,0xbfbeadaa,
        0xffdfcebb,0xcfcfcfbb,0xcfbebfaa,0xdfbebea9,0x8fadbdbb,0xcfcedfbb,0xffffffdc,
        0x9fadbdbb,0xcfcdcfbb,0xffefffcb,0xafadbeba,0xcfbdcfba,0xffdfffcb,0xafadbdbb,
        0xcfbecfbb,0xffffffdc,0x9fadaeaa,0xcfbdbdba,0xffdfffcb,0xafaebeba,0xcfadceba,
        0xffcfdfba,0xbfbeaeba,0xdfcebfba,0xffefdfcb,0xafbeaeaa,0xcfcfaeaa,0xffdfceba,
        0xbfbebfaa,0xbfaebdaa,0xcfbcac98
      }
    },
    {
      {
        0x9494979,0x5a7a7a89,0xdfcdcdbb,0x3b497b89,0x6b7a8b89,0xdfbccdbb,0x8f7bbd9a,
        0xaf8bbdaa,0xdfbcdebb,0x3b6a5a89,0x7b8a7a89,0xdfbdcdbb,0x6c7a7b89,0x7c7a8b89,
        0xdfbcbcaa,0xaf9bbdaa,0xbf9bbdaa,0xffbcdeba,0x9fad8c9a,0xafbd9caa,0xefcdcdbb,
        0xafbd9caa,0xbfbdacaa,0xefcdcdba,0xdfcdcebb,0xdfbdceaa,0xffcddeba,0x2a495a89,
        0x6b7a8a89,0xdfcccdbb,0x4b597b89,0x7c7a8b89,0xdfbccdbb,0x8f7aad9a,0xaf8bbd9a,
        0xefbcdeba,0x4b6a5a89,0x7c8a7a89,0xdfbdccbb,0x6c7a7b89,0x7b7a8b89,0xcfbcbcaa,
        0x9f8bbd9a,0xae8bbd9a,0xdfaccdaa,0x8fad7c9a,0xafbc9c9a,0xffcecdbb,0xafad9c9a,
        0xafac9c9a,0xdfcdbcaa,0xdfbdceaa,0xcfbcbdaa,0xdfbcbca9,0x5d7b8c9a,0x9d9bacab,
        0xffddddcb,0x6d7b8c9a,0x9d9bacaa,0xffcddecb,0x9f7bbd9a,0xbf9bceaa,0xffcdefbb,
        0x7e8c8c9a,0x9e9c9caa,0xffddddcb,0x7e8b9c9a,0x9d9b9c9a,0xffcdcdbb,0x9f9cbeaa,
        0xaf8bbdaa,0xdfacdfba,0x9fbd8caa,0xbfbdacaa,0xffefddcb,0xafbdadaa,0xafbd9caa,
        0xefcebdba,0xdfcdcfbb,0xbfbcbdaa,0xdfabbc99,0x8f9daebb,0xbfacbebb,0xffdceecb,
        0x9f9daeab,0xbfacbdbb,0xffdcedcb,0xaf8bbdaa,0xcfacceaa,0xffddffbb,0x9f9dadab,
        0xbfacbdbb,0xffddeecb,0x9f9cadab,0xafacadab,0xffddddcb,0xaf9bbeaa,0xbf8bbd9a,
        0xffbcdeaa,0xafbd9daa,0xcfbdbdaa,0xffeedebb,0xafbdadaa,0xbfbdacaa,0xffddcdba,
        0xbfacbd99,0xbeabbc99,0xdeaabb98
      },
      {
        0x7274867,0x49597a78,0xffefffaa,0x19386967,0x6f698a78,0xffefffaa,0x6f5a9f89,
        0x9f8aaf89,0xfffffffa,0x29584968,0x6f797a78,0xffffffaa,0x4a697a78,0x6d697a78,
        0xffafff9a,0x8f8aaf89,0x9f7aaf89,0xffafffa9,0x7f8f6f89,0xafaf9f99,0xfffffffa,
        0x8f9f8f89,0x9f9f8f89,0xffffafaa,0xffffff99,0xafafaf99,0xffafaf98,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff
      },
      {
        0x9596a89,0x7b8b8b99,0xefdedfcb,0x4b6a7a89,0x8c8b9b99,0xffdecfcb,0x9e9cbdaa,
        0xbfacbdaa,0xffdfdfcb,0x4b7a6a89,0x8c9b8b99,0xdfdecdcb,0x6c8b8b99,0x8c8b8b99,
        0xdfcdcebb,0xafacbdaa,0xbfadbdaa,0xffdfdfcb,0x9fad9caa,0xbfbdacaa,0xefefdfcb,
        0xafbdadab,0xbfbdadaa,0xefdfcfcb,0xcfcfcfbb,0xcfcfcfbb,0xffdedfcb,0x3a696a89,
        0x8c8a8b99,0xefdedecb,0x5b6a7a89,0x8c8b9b99,0xefcddebb,0x9d9bbcaa,0xbfacbdaa,
        0xffdeefcb,0x5b7a7a89,0x8c9b8b99,0xffdecdbb,0x7c8a8b89,0x8c8b8b89,0xdfcdcdba,
        0xaeacbdaa,0xaf9cbdaa,0xefcedfba,0x9fbc9caa,0xafbd9caa,0xffdfcfcb,0xafbd9daa,
        0xafbd9caa,0xffdfbeba,0xcfcecebb,0xcfbebeba,0xefcfcfba,0x7d8b9caa,0xafacacaa,
        0xffffffdc,0x8d9b9caa,0xafacbcaa,0xffefefdb,0xafacbdba,0xcfbdcdba,0xffefffdc,
        0x8d9c9caa,0xafacacaa,0xffefdedc,0x8d9c9caa,0xaeacacaa,0xffdfdfcb,0xbfbdcdba,
        0xbfadbeba,0xffcfefca,0xafbdadba,0xcfcebdbb,0xffffdfdc,0xbfceadbb,0xbfcdaeba,
        0xffefcecb,0xcfcecfbb,0xcfcecebb,0xefcfcea9,0x9fbdbebb,0xdfcecfcb,0xffffffec,
        0x9fbdbebb,0xcfcececb,0xffffffdc,0xafbecfbb,0xdfcfcfbb,0xffefefdb,0xafbdbfbb,
        0xdfcececb,0xffffffec,0xafbdbebb,0xcfbdbebb,0xffffffdb,0xbfbecfbb,0xcfbeceba,
        0xffdfefcb,0xbfcfbfbb,0xefdfcfbb,0xffffffdc,0xbfcebfbb,0xcfcebebb,0xffefdfcb,
        0xcfcfbfbb,0xcfbfbebb,0xdfbdbda9
      }
    },
    {
      {
        0x9394a8a,0x5a7a7b9b,0xefcedecd,0x3b4a7b8a,0x6c7b8c9b,0xefcedfcd,0x9f8cbfac,
        0xaf9dcfbc,0xffdfefde,0x3b6b5b8a,0x7c8b8b9b,0xefcedecd,0x6c7b8c9b,0x7c8b8c9b,
        0xdfcececd,0xbfadcfbc,0xbfadcfbc,0xffdfefde,0x9fbf9dbc,0xbfcfadbc,0xffffefde,
        0xbfcfaebc,0xcfcfbebd,0xffffdfcd,0xffdfdfce,0xffdfdfce,0xffffffdf,0x1a4a5a8a,
        0x6b7a8b9b,0xefddddcd,0x3c5a7b8a,0x7c7b9c9b,0xefcedecd,0x8f7cbeab,0xaf9dcfbc,
        0xffdfffde,0x4c7b6b8a,0x7c8b8b9b,0xffdedecc,0x6c7b8c9b,0x7c7b8c9b,0xdfcdcebc,
        0xaf9dcfbc,0xaf9cbeac,0xdfbddfcd,0x9fbe8dac,0xbfbfadbc,0xffefffde,0xafbeaebc,
        0xbfbeadbc,0xffdfcecd,0xefdfdfcd,0xdfcfdfcd,0xffdfdfcd,0x6e7c8dac,0x9d9cadbc,
        0xffefefed,0x6f7c9dac,0xae9cbdbc,0xffffffee,0x9f8ccfbc,0xcfaddfcd,0xffffffef,
        0x7f9d8dac,0xafadadbc,0xffffffde,0x7f9d9dac,0x9e9dadbc,0xffdfefdd,0xaf9dcfbc,
        0xaf9ccfbc,0xffcfffdd,0xafbf9ebc,0xdfdfbfcd,0xffffffff,0xbfcfafbd,0xbfcfadbc,
        0xffffdfdd,0xefdfffcd,0xcfcedfcd,0xdfcddecd,0x8fafbfcd,0xbfbecfcd,0xfffeffee,
        0x9f9fbfbd,0xbfbdcfcd,0xffffffee,0xaf9ddfbc,0xdfbfdfcd,0xfffffffe,0x9fbfafbd,
        0xcfbecfcd,0xfffffffe,0x9fafbfbd,0xbfbecfcd,0xffffffdd,0xaf9ddfbc,0xcfaddfbc,
        0xffefffdd,0xbfcfafbd,0xefdfcfcd,0xffffffdf,0xbfcfbfbd,0xcfcfbfbc,0xffffffde,
        0xcfcfdfbc,0xcfcddfbc,0xffdddecc
      },
      {
        0x8284868,0x496a7a89,0xffffffff,0x1a396a79,0x6f6a8f8a,0xffffffff,0x7f6faf9a,
        0xaf9fffaf,0xffffffff,0x1a595979,0x6f7f7a8a,0xffffffff,0x4c6a7a8a,0x5b7b7b8a,
        0xffffffff,0x9f9fbf9c,0x9f8fafab,0xffffffff,0x7f9f7f9b,0xafbf9faf,0xffffffff,
        0x9faf9faf,0xafbf9fab,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
        0xffffffff,0xffffffff,0xffffffff
      },
      {
        0x9495989,0x6b8b8b99,0xffefdfcc,0x4b6a7a89,0x7c8b9b9a,0xffffdfcb,0x9f9cbdbb,
        0xbfadcebb,0xfffeffdc,0x4b7a6a89,0x7c9b8b99,0xefdeddcc,0x6c8b8b99,0x8c9c9c99,
        0xdfdedfcb,0xafbdbebb,0xbfbecfbb,0xffefffdc,0x9fbd9dbb,0xbfcdadbb,0xffffdfdc,
        0xafbdadbb,0xbfcfaebb,0xffffdfdc,0xcfdfdfcc,0xcfcfcfcb,0xffffffcc,0x3a696a89,
        0x7b8b8b9a,0xefdedfcc,0x5b6a7a89,0x8c8b9b99,0xffefefcb,0x9f9cbdba,0xbfadcdbb,
        0xfffdffdc,0x5b7a6a89,0x8d9b8b99,0xefdfdfdc,0x6c8b8b99,0x8c8b8b99,0xdfcddfba,
        0xafadbdbb,0xbfadbdba,0xffcfdfcb,0x9fbd9daa,0xbfcdadbb,0xffffdfcc,0xafbfadbb,
        0xbfbdadba,0xffefcecb,0xcfdfcfcb,0xcfcfcfcb,0xffdfdfba,0x7c9b9caa,0xadbdbdbb,
        0xffffffdc,0x8d9c9caa,0xbfbcbcba,0xffffffed,0xbfadcebb,0xcfbedecb,0xffffffec,
        0x8dac9caa,0xafbdbdbb,0xfffffffc,0x9eacadba,0xafbdadba,0xffffffdb,0xbfbdcecb,
        0xbfbdcebb,0xffdfffdb,0xbfcfadbb,0xdfdfbfcb,0xfffffffc,0xbfcfbfcb,0xbfcfbfbb,
        0xffffdfdb,0xdfdfdfdc,0xcfcfcfcb,0xffcfcfba,0x8fbecfcb,0xcfdfdfdc,0xfffffffd,
        0x9fbebecb,0xcfdfcfcb,0xfffffffc,0xbfbfcfcb,0xdfcfdfcb,0xfffffffc,0xafbebfcb,
        0xdfdfcfcc,0xffffffec,0xafbfbfcb,0xcfcecfcb,0xffffffec,0xbfbfcfcb,0xcfbfcfcb,
        0xffdfffdb,0xbfdfafcb,0xdfdfcfcb,0xfffffffc,0xbfcfbfcb,0xcfcfbfcb,0xffffdfdb,
        0xcfcfcfcc,0xcfbfbfbb,0xdfcecfba
      }
    }
  },
  /* Intra luma 2x2 descriptors: */
  {
    {
      {
        0x4925967,0x83595687,0x78778788,0x88725935,0x96684695,0x68667678,0x77877657,
        0x95796786,0x79679777,0x78877887,0x66786786,0x66778678,0x66677766,0x66540000
      },
      {
        0x4925967,0x93695697,0x79789889,0x88815936,0x96784695,0x69778789,0x77888757,
        0xa5796795,0x7a679778,0x78988988,0x86796796,0x77679678,0x67777877,0x76660000
      }
    },
    {
      {
        0x4935967,0x93595687,0x78778788,0x88815935,0x96684695,0x68668678,0x77887757,
        0x95796785,0x79679778,0x78977888,0x77796786,0x77679678,0x66777877,0x76650000
      },
      {
        0x4925967,0x93695697,0x8978a789,0x99915935,0x96793694,0x69779789,0x78988846,
        0xa57a67a5,0x7a679789,0x78a88998,0x96796797,0x89789789,0x77988988,0x98880000
      }
    },
    {
      {
        0x4925967,0xa3595697,0x89779889,0x99915935,0x96793695,0x69779679,0x77898847,
        0xa5796895,0x7a679779,0x78a88998,0x87897897,0x89789779,0x77878977,0x88770000
      },
      {
        0x4a25a68,0xa35a4698,0x8a78a89a,0xaaa15925,0x968a3694,0x6978a78a,0x88aaaa47,
        0xa57a79b5,0x7a67a89a,0x89b89aaa,0xa78a79b8,0xab79b89b,0x9ab9ab99,0xaaaa0000
      }
    },
    {
      {
        0x4a25a68,0xb25a56a8,0x8a78a88a,0xaab15a35,0xa68a36a4,0x6988a67a,0x889aaa47,
        0xa57a78b5,0x7a67a88a,0x78b88aaa,0xa79b79a8,0x9b79b78b,0x99b89b88,0xaa9a0000
      },
      {
        0x5a26a79,0xb36a57a9,0xab89b99b,0xbbc05a36,0xa79b36a5,0x7a99b89b,0x99bccc57,
        0xb69b9bc6,0x8b79baac,0xabdaaccc,0xc8ac9bdb,0xce9bdabd,0xccdbcecc,0xdddd0000
      }
    },
    {
      {
        0x5b26b8a,0xc36b57b9,0xac79c9ac,0xccd05b36,0xb89d36b5,0x6b9ac78c,0x99bccd58,
        0xc68c9bd6,0x8c79caad,0x8acaadcc,0xd9bd9bdb,0xce9bd9bd,0xbceacebb,0xeddd0000
      },
      {
        0x4a25a99,0xb26a57aa,0xab99baac,0xdcd05a36,0xa9ac46a6,0x7aaac9ac,0xaabccd69,
        0xb8acbcd8,0x9c89cbac,0xbcfbccdd,0xdadfbded,0xcfccecdf,0xdcfccfcd,0xeede0000
      }
    }
  },
  /* Intra chroma 4x4 descriptor: */
  {
    {
      0x9496b8a,0x7c8b9cab,0xffdeefcd,0x4b5a8c9a,0x8d8badab,0xffdeefcc,0x9e8bbfab,
      0xbf9ccfab,0xffcdefcb,0x5b7a7b9a,0x8d9b9cab,0xefdedfcc,0x7c8b9c9b,0x9d8bad9b,
      0xefcedfcc,0xaf9ccfab,0xbfaccfab,0xffcdefbb,0x9fbd9dab,0xbfcdadbb,0xffefdecc,
      0xafbdadab,0xbfbdadab,0xffdececb,0xdfcdcfbb,0xdfcdcfbb,0xffdddeba,0x19596b8a,
      0x7b8a9c9a,0xefdedfcc,0x4b5a8c9a,0x8c8a9c9a,0xefcddfcc,0x8e7bbeaa,0xaf9bceaa,
      0xefcdefbb,0x5b7a7b8a,0x8d8b9c9a,0xefdedfcc,0x6c7a8c9a,0x8d8b9c9a,0xdfcdcfbb,
      0xaf9bbeaa,0xaf9bbeaa,0xefbcdfba,0x8eac8cab,0xafbd9dab,0xffdecebb,0xafad9dab,
      0xafbcadaa,0xefdecdbb,0xcfbdceaa,0xcfbdceaa,0xffcdcea9,0x4b6a7c9a,0x8c8b9dab,
      0xffdedfcc,0x6c6a8c9a,0x8d8badab,0xffdddfcc,0x8e7bbeab,0xaf9bcfab,0xffcdefbb,
      0x6c7b8c9a,0x9d9b9dab,0xffdedfcc,0x7d8b9c9a,0x8d8b9d9a,0xefcddfbb,0xaf9bbeab,
      0xaf9bbeaa,0xefbddfba,0x9fac8dab,0xbfbdadab,0xffdfdecb,0xafad9dab,0xafbdadaa,
      0xefdecebb,0xcfbdceaa,0xcfbdbdaa,0xefbccda9,0x5c7a8c9a,0x9d9b9c9a,0xefcccdba,
      0x6c7a8c8a,0x9d8a9c9a,0xefcccdaa,0x8d7a9c89,0xae8aac89,0xefbccd98,0x6c7a8c8a,
      0x9d9b9c9a,0xefcccdaa,0x7c7a8c89,0x8d8a9c89,0xdfbccda9,0x8d7a9c88,0x9d7a9c88,
      0xdfabbd98,0x8d8b7b89,0xae9b9c89,0xefccbca9,0x8d8b8b89,0x9d9b8b88,0xdfbcac98,
      0x9d8a9b77,0x9d8a9b77,0xbd899a76
    },
    {
      0xa4a6c9b,0x6c8c9dbc,0xffefffee,0x3c5b9dab,0x7d8caebc,0xffefefed,0x8f8ccfbc,
      0xbf9ddfcc,0xffdfffdd,0x4c7c7cab,0x8d9c9dbc,0xffefefde,0x6d8c9dac,0x8e9cadbc,
      0xffdfefdd,0xafadcfbc,0xbfaddfbc,0xffdeffdc,0x9fbe9ebd,0xbfcfaecd,0xffffdfdd,
      0xafbeafbc,0xbfcebfbc,0xffffdfdd,0xdfcedfcc,0xdfdedfcc,0xffefefcc,0x1b5a6c9b,
      0x6c8b9dab,0xffefefde,0x4c5b8c9b,0x7d8cadac,0xffdfefdd,0x8f7cbfac,0xaf9ccfbc,
      0xffceffcc,0x4c7b6c9b,0x7d9c9dac,0xffdfefdd,0x6d7b8dab,0x7d8c9dab,0xefdedfcd,
      0xaf9ccfbc,0xaf9ccfbc,0xffceefcc,0x8fbe8dac,0xafceadbc,0xffefdfdd,0xafbdaebc,
      0xafbdaebc,0xffefdfcc,0xcfcecfbc,0xdfcecfbb,0xffdedfbb,0x3c6b7dab,0x8d9cadbc,
      0xffefffee,0x5d6b9dab,0x8e9caebc,0xffefffdd,0x8f7cbfac,0xbf9dcfbc,0xffdfffdd,
      0x5d7c7dac,0x8e9cadbc,0xffefffdd,0x6e8c9dac,0x8e9cadac,0xffdfefdd,0x9f9cbfbc,
      0xaf9ccfbc,0xffcdefcc,0x8fbd8dac,0xbfbeaebc,0xffffefdd,0x9fbeaebc,0xafbdaebc,
      0xffdfcfcc,0xcfcecfbc,0xcfbdcfbb,0xefcdcfbb,0x5d7c8d9b,0x9e9badab,0xffdddfcc,
      0x6e7c8d9b,0x9e9cadab,0xffdddfcb,0x8f7bad9a,0xaf9cad9a,0xffcddfba,0x6d8c8d9b,
      0x9f9cadab,0xffdddecb,0x6d8c8d9b,0x8d9b9dab,0xefcddebb,0x8e8bad9a,0x9e8bad9a,
      0xdfacceaa,0x8f9c8d9a,0xafac9d9a,0xffdecebb,0x8f9c8c9a,0x9e9c9c9a,0xdfcdbdaa,
      0xaf9cac89,0xad9b9c88,0xce9aab87
    },
    {
      0xb5c6dad,0x7d9daece,0xffffffff,0x4d6c9fbd,0x8f9dbfcf,0xffffffff,0x9f8ddfcf,
      0xbfafffdf,0xffffffff,0x4d8d7dbd,0x8fadafcf,0xffffffff,0x7f9dafbd,0x9faebfcf,
      0xffffffff,0xbfbfdfdf,0xcfbfefdf,0xffffffff,0x9fcfafdf,0xcfdfcfdf,0xffffffff,
      0xbfdfcfdf,0xcfdfcfdf,0xffffffff,0xffffffdf,0xffefffdf,0xffffffff,0xb5b7dac,
      0x7d9cadcd,0xffffffff,0x4d6c9dad,0x8f9dbfce,0xffffffff,0x8f8dcfcd,0xbfaedfcf,
      0xffffffff,0x4d8c7dbd,0x8fadafcd,0xffffffff,0x6e8d9fbd,0x8f9dafbd,0xffffffef,
      0xafaedfce,0xbfaedfcd,0xffdfffdf,0x9fcf9fcf,0xbfdfbfcf,0xffffffff,0xafcfbfcf,
      0xbfcfbfcf,0xffffffef,0xdfdfffdf,0xefdfdfdf,0xffffffdd,0x3d7c8fbd,0x8fadafcf,
      0xffffffff,0x5e7c9fbd,0x9fadbfcf,0xffffffff,0x8f8dcfce,0xbfafdfcf,0xffffffff,
      0x5f8d8fbd,0x9faebfce,0xffffffff,0x7f9dafbd,0x9fadbfce,0xffffffff,0xafaedfce,
      0xbfaedfcd,0xffdfffdf,0x9fcf9fce,0xcfdfbfdf,0xffffffff,0xafcfbfcf,0xbfcfafcf,
      0xffffefef,0xdfdfefdf,0xdfdfdfdd,0xffdfefdd,0x5f8d9fbd,0x9facbfcd,0xffffffdd,
      0x6f8d9fbc,0xafadbfbd,0xffffffdd,0x8f8dbfac,0xbfadbfbc,0xffdfffcd,0x6f9d9fbd,
      0xafadafbd,0xffffffdd,0x7f9d9fac,0x9facafbc,0xffdfffdd,0x9f8cbfac,0xaf9cbfab,
      0xffceefcc,0x8fad8fac,0xbfbfbfbc,0xffffefdd,0x9fad9fac,0xafbd9eac,0xffefcfcc,
      0xbfacbfab,0xbfacadaa,0xcfbcbdaa
    },
    {
      0xc5c7dbf,0x7fafbfdf,0xffffffff,0x3f6dafcf,0x8fafbfdf,0xffffffff,0x9f9fffff,
      0xcfbfffff,0xffffffff,0x4f9f7fcf,0x9fbfbfdf,0xffffffff,0x7f9fafcf,0x9fbfbfdf,
      0xffffffff,0xbfbfffff,0xdfcfffff,0xffffffff,0xafffafff,0xcfffcfff,0xffffffff,
      0xcfffcfff,0xdfffcfff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc6c7fbf,
      0x7f9fafcf,0xffffffff,0x3f6d9fbf,0x8f9fbfdf,0xffffffff,0x9f8fdfdf,0xcfafffff,
      0xffffffff,0x4f8f7fbf,0x8fafafcf,0xffffffff,0x6f9fafcf,0x8fafafcf,0xffffffff,
      0xbfbfffdf,0xcfbfffdf,0xffffffff,0x9fcfafdf,0xcfffcfff,0xffffffff,0xbfdfcfdf,
      0xcfdfcfff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x3f7f8fcf,0x9fafbfff,
      0xffffffff,0x5f7fafcf,0x9fafcfdf,0xffffffff,0x8f8fcfcf,0xcfbfffdf,0xffffffff,
      0x5f9f9fcf,0x9fbfbfdf,0xffffffff,0x7f9fafcf,0x9fafbfdf,0xffffffff,0xafafffdf,
      0xbfafffdf,0xffffffff,0x9fcf9fcf,0xcfffcfff,0xffffffff,0xbfcfbfdf,0xbfefbfdf,
      0xffffffff,0xffffffff,0xdfffffff,0xffffffff,0x5f9f9fcf,0xafafbfcf,0xffffffff,
      0x7f8fafbf,0xafafbfcf,0xffffffff,0x8f8fbfbf,0xcfafcfcf,0xffffffff,0x7f9f9fbf,
      0xafbfbfcf,0xffffffff,0x7f9fafbf,0x9fafbfcf,0xffffffff,0x9f9dbfbf,0xaf9dcfbd,
      0xffdfffdf,0x8fbf9fbf,0xcfcfbfcf,0xffffffff,0x9fbfafbf,0xafbfafbe,0xffffffff,
      0xcfbfcfbc,0xbfbfbfbc,0xffcdcfcc
    },
    {
      0xf5f7fff,0x8fafbfff,0xffffffff,0x3f6fafff,0x9fafcfff,0xffffffff,0x9f9fffff,
      0xffcfffff,0xffffffff,0x4f9f8fff,0x9fcfbfff,0xffffffff,0x7fafbfff,0x9fbfcfff,
      0xffffffff,0xcfffffff,0xffffffff,0xffffffff,0xafffbfff,0xffffffff,0xffffffff,
      0xcfffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf6f7fcf,
      0x8fafbfff,0xffffffff,0x3f6fafcf,0x8fafcfff,0xffffffff,0x8f8fffff,0xcfbfffff,
      0xffffffff,0x3f9f7fff,0x9fbfbfff,0xffffffff,0x6f9fafff,0x8fafbfff,0xffffffff,
      0xbfbfffff,0xcfbfffff,0xffffffff,0x9fffafff,0xffffefff,0xffffffff,0xbfffcfff,
      0xcfffcfff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x3f7f9fff,0x9fafbfff,
      0xffffffff,0x5f7fafff,0x9fbfefff,0xffffffff,0x8f8fffff,0xffcfffff,0xffffffff,
      0x5f9f9fff,0xafbfbfff,0xffffffff,0x7fafafff,0x9fbfbfff,0xffffffff,0xafbfffff,
      0xbfbfffff,0xffffffff,0x9fff9fff,0xffffffff,0xffffffff,0xafffbfff,0xbfffcfff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x5f9fafff,0xafbfcfff,0xffffffff,
      0x7f8fafcf,0xafbfcfff,0xffffffff,0x8f8fcfbf,0xcfbfffff,0xffffffff,0x7f9f9fdf,
      0xbfbfbfff,0xffffffff,0x8fafafcf,0x9fbfbfff,0xffffffff,0xaf9fcfbf,0xbfafffcf,
      0xffffffff,0x8fbf9fcf,0xffffcfff,0xffffffff,0x9fcfafcf,0xbfcfbfcf,0xffffffff,
      0xcfcfffbf,0xcfbfffcf,0xffffffff
    }
  },
  /* Intra chroma 2x2 descriptors: */
  {
    {
      {
        0x4a25a78,0xa25956a8,0x8a68a88a,0x99a15936,0x968a36a5,0x6988a68a,0x78999947,
        0xa57a78a5,0x7a67a88a,0x79a88a99,0x978a78a8,0x8978a78a,0x88978988,0x98870000
      },
      {
        0x3925967,0xa2594698,0x8a89a89a,0xaaa15935,0x96793695,0x6978978a,0x88a99a57,
        0xa57a78a6,0x8a67a88a,0x89b99baa,0xa78a78a8,0x8a89a89a,0x89a9ab99,0xb9990000
      }
    },
    {
      {
        0x4b36b79,0xc36b57b9,0x9b78b99b,0xbbb05b36,0xb78b36b5,0x7a89b78b,0x89aaab57,
        0xb68b89c5,0x8b78b99b,0x89b99bbb,0xb79b89b9,0x9b79b89b,0x99a89b99,0xaa990000
      },
      {
        0x4a25a78,0xb36b56b8,0x9c9ac9ad,0xbcd05a36,0xa78b46a5,0x7b89c9ad,0x9acbbd57,
        0xb68c89d6,0x9c79baac,0xacdabdcc,0xe89b8ad9,0xadaac9ac,0xabdbdecc,0xdccd0000
      }
    },
    {
      {
        0x5c36d8a,0xd26c67ca,0xad79c9ac,0xccd05b37,0xc89e37c6,0x7baad79c,0x99cccd48,
        0xc68c9ad5,0x9d79daad,0x8adaaccc,0xd89d8aca,0xbd8ac8ad,0xabc9beaa,0xccbc0000
      },
      {
        0x4c16f8a,0xf37f68fb,0xbfbffbff,0xfff05c37,0xf8af58f6,0x9fccfcef,0xbfffff68,
        0xf7aeacf9,0xbf9bffcf,0xfffdffff,0xfbbfbfff,0xffcdfbcf,0xffffffdf,0xffff0000
      }
    },
    {
      {
        0x5c27d9b,0xf27e68eb,0xce8aeabf,0xdff06c37,0xd8ae37d6,0x8dbce79d,0xaadfdf58,
        0xd69dace6,0x9d89cbbe,0x9adaaddd,0xf8ad9adc,0xde8bd9bf,0xcdf9cfbb,0xdede0000
      },
      {
        0x4f15f9d,0xf37f68fa,0xffafffff,0xfff05b37,0xbbbf57f7,0x9fffffff,0xfffbff69,
        0xf7adfff9,0xbf9fffbf,0xffffffff,0xffffbfff,0xfffffbff,0xffffffff,0xffff0000
      }
    },
    {
      {
        0x5f27f9c,0xf27f68fc,0xff79facf,0xfff06d37,0xf9bf37c6,0x8fcdf79f,0xaadfff58,
        0xd79dbff5,0x9c8afcdf,0x8bfbafff,0xf9bfabff,0xdf8bfabf,0xfef9cfbc,0xffff0000
      },
      {
        0x3f16f9f,0xf39f6fff,0xffffffff,0xfff05c3a,0xffff59f7,0xffffffff,0xffffff7f,
        0xf9fffff9,0xff9fffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000
      }
    }
  },
  /* Intra extra levels descriptor: */
  {
    {
      0x2233455,0x56667788,0x88999aaa,0x999bcdee
    },
    {
      0x1244556,0x6778999a,0xaabbcccc,0xcccdffff
    },
    {
      0x1234577,0x8899abbb,0xccddddff,0xdfffdfff
    },
    {
      0x1234577,0x8899abbb,0xccffffff,0xffdbffff
    },
    {
      0x1234667,0x7899bacb,0xecdcbedc,0xbb9affff
    }
  },
  /* Inter CBP descriptor: */
  {
    {
      0x68878787,0x88777773,0x69a9a9b9,0xbaa9a996,0x9aebebeb,0xeddbdbd8,0x6a99baa9,
      0xab99a996,0x7bbacbb9,0xccb9baa6,0xaceaeceb,0xfddbecc8,0x9eabeddb,0xeebbddb8,
      0xaecbfedb,0xeecbedc8,0xced9fefa,0xffebfee8,0x6aaaa9a9,0xaba99996,0x8bcbbac9,
      0xccbab9a6,0xbcfdebfb,0xfeecebd8,0x8ccbcbca,0xccbabaa6,0x8ccbcbca,0xcccabaa6,
      0xbdecfcea,0xfdebebc7,0xbfddfeec,0xfedcedc8,0xbedcedeb,0xfedbdcc7,0xcffbfdfa,
      0xffebfdd7,0x9eeebbdb,0xdeedbbc8,0xaefdcbeb,0xfeeddbc8,0xdeffeafb,0xfffefbe8,
      0xbffedddc,0xffeddcc8,0xbeeddceb,0xfedcdcc7,0xcffefbfa,0xfffdfcd7,0xdfffffed,
      0xfffefeda,0xcffefeeb,0xfffdedd8,0xdffcfdf9,0xfffcfdd7,0x6baaaab9,0xaa999996,
      0x8ccbcbca,0xccbabaa7,0xbdfdfdfc,0xfdececd8,0x8cbbcbca,0xbca9baa6,0x8ccbcbca,
      0xccbabaa6,0xbdfcfdeb,0xeedbecc7,0xaecdeedc,0xeebbddb8,0xaedceddb,0xedcadcb7,
      0xcfebfefb,0xffdaedd7,0x7ccbbbca,0xbcbaa996,0x8cdbcbca,0xcccabaa6,0xbdfdeceb,
      0xeeecdbc7,0x8ccbcbca,0xccbabaa6,0x8cbbcbb9,0xccb9b995,0xaddbdbda,0xddcacab6,
      0xbfddeedc,0xeecbdcb7,0xadcbdcca,0xddcacba6,0xaddbecda,0xedcadbb5,0xafeecdec,
      0xdeecbbb8,0xbeeddceb,0xeedccab7,0xcffefcfc,0xffeddbd7,0xafeddddc,0xeedccbb7,
      0xaddccbda,0xddcbbaa6,0xbdecdbda,0xeddbcab6,0xcffffefd,0xffededc8,0xbedcecdb,
      0xeecbcbb6,0xaedbdcd9,0xedcacaa4,0x9eeeedec,0xbdbbbcb8,0xbffefefd,0xdedcdcc8,
      0xdffffffe,0xfffdfdea,0xaeedeeed,0xdebbccb8,0xbeedfdec,0xddcbdcb7,0xcffefffd,
      0xffebfdd8,0xcfdffffe,0xefabfeb8,0xcfedfefd,0xefbaedc7,0xcffcfffc,0xffcafdd7,
      0xaeeeddec,0xcedcbbb8,0xaefdedec,0xdddccbc7,0xcffffefd,0xfffcebd8,0xafedddec,
      0xddcbcba7,0xaddcdcdb,0xccbabaa6,0xbeecedeb,0xeddacbb6,0xcfeefffd,0xefbbddb7,
      0xaedcecdb,0xddbacba5,0xaddbecda,0xedb9caa4,0xbfffeefe,0xdfee9bb8,0xcfffedfc,
      0xeeedbac7,0xdffffdfc,0xfffddad7,0xcffeeeed,0xefdcbba7,0xaeecdcdb,0xddcbbaa5,
      0xaeecebda,0xddcab9a4,0xcffefffd,0xffdddca7,0xaddcdcda,0xddbaba94,0x9ccacbc8,
      0xccb8b992
    },
    {
      0x46666676,0x67666663,0x68a8a8a8,0xa9989895,0xaadadada,0xecdbdbc8,0x5a98a9a8,
      0xaa889985,0x7aa9bab9,0xbba9baa6,0xacdaecea,0xeddbdcc8,0x9daaedcb,0xddaadcb8,
      0xadcaedda,0xeecaddc8,0xbdd9fefa,0xffeafed8,0x59a998a8,0x9a998885,0x8bbab9b9,
      0xbbbaa9a6,0xbcecdaea,0xeedcdbd8,0x8bbababa,0xbcaabaa6,0x8bbacab9,0xccbabaa6,
      0xbdebebda,0xeedbdcc7,0xbedceddc,0xffdcedc8,0xbedceddb,0xeecbdcc8,0xceebfdea,
      0xffebedd8,0x9dddbacb,0xdedcbab8,0xbdedcadb,0xeeedcac8,0xcefedafa,0xfffdebe8,
      0xbeeddddc,0xeedddcc8,0xbeeddcdb,0xeedcdcc8,0xcefdecfa,0xffedecd8,0xdfffffed,
      0xffffffda,0xdffdfeeb,0xfffdedd8,0xdffdfdfa,0xfffdfdd8,0x5a9999a9,0x9a888885,
      0x8bbacaca,0xbbaabaa6,0xbdfcfdfc,0xedebecd8,0x7baabbba,0xab99aa96,0x8bbacbca,
      0xcba9baa6,0xbdebedeb,0xeddbdcc8,0xaecceddc,0xdeaaddb8,0xadcbeddb,0xddbadcb7,
      0xceebfeeb,0xeedaedd7,0x7bbaaaba,0xabaa9996,0x8ccbcaca,0xbcbaa9a6,0xbdedeceb,
      0xeddcdbc8,0x8cbbbbba,0xbcaaaa96,0x8bbabab9,0xbba9a996,0xacdbdbda,0xdccacab6,
      0xbedceddc,0xeecbccb8,0xadcbdcca,0xddbacba6,0xaddbdcda,0xddcacbb6,0xaeedccdc,
      0xdedcaab8,0xbeeddbdb,0xdddcbab7,0xcffeebfc,0xfeeddbd8,0xbeeddddc,0xeedcbbb8,
      0xaddccbca,0xdccbbaa6,0xbdecdbda,0xedcbcab6,0xcffefeed,0xffedddb8,0xbedcdcdb,
      0xedcbcbb7,0xbddcecda,0xddcbcbb5,0x9ddcdddc,0xbcbbbba8,0xbeededfd,0xddcbdcc8,
      0xdffffffe,0xfffdfdfa,0xaeddeddd,0xcdabccb8,0xbeddedec,0xddcbdcc8,0xcffdfefd,
      0xfeebfdd8,0xcfdefffd,0xdfabedb8,0xcfedfefd,0xeebaedc8,0xdffcfffd,0xfecafdd8,
      0xaeeddddc,0xcdccaaa8,0xbeededec,0xddcccbb8,0xcffffdfd,0xfefdebd8,0xaeddeddc,
      0xddbbbba7,0xaddcdccb,0xccbabaa6,0xbdececdc,0xddcbcbb7,0xcfeefeed,0xefbbdda8,
      0xbedcecdb,0xddbacba6,0xbddcecdb,0xedc9cbb5,0xbffedded,0xcedd9aa8,0xcffeeded,
      0xeeedbab7,0xdffffdfd,0xfeeddad7,0xbffeeded,0xdfddbba7,0xaddcdcdb,0xddcbbaa6,
      0xbdecdcdb,0xddcbcab5,0xdfffffed,0xffdccca7,0xbeececdb,0xddcbcb95,0xadcbdbc9,
      0xdcb9b993
    },
    {
      0x35555565,0x56555552,0x589898a8,0x99989895,0x9adadada,0xdcdadac8,0x59889998,
      0x9a889985,0x7aa8bab9,0xbba9baa6,0xacdaecea,0xeddaecd8,0x9caaddca,0xddaacca8,
      0xadbaedda,0xeecaddc8,0xbdc9fefa,0xffdafdd8,0x59998898,0x9a998885,0x7abaa9b9,
      0xbbbaa9a6,0xacecdaea,0xeddcdbd8,0x7bbbbbba,0xbcaaaaa7,0x8bbabbca,0xccbabaa7,
      0xadecdcea,0xeedcecd8,0xbfddeedb,0xefdcddc9,0xaedcedeb,0xefdcedc8,0xceebfefb,
      0xffecedd8,0x9dddaaca,0xdddcaaa8,0xadedcadb,0xeeedcac8,0xcdfedafb,0xfffdebe9,
      0xbfeedddb,0xffdddcc9,0xbeeddcdb,0xefdddcc8,0xcffdfcfb,0xfffdfce9,0xdfffffed,
      0xffffffda,0xcffefffc,0xfffefed9,0xdffdfdfb,0xfffefee9,0x599999a9,0x89888885,
      0x8bbabaca,0xbba9baa7,0xbdededfc,0xeddbecd9,0x7baabbba,0xab99aa96,0x8bbacbca,
      0xbca9bba7,0xaddcedec,0xeddbecd8,0xaebceedc,0xdeaaddb8,0xadccedec,0xeecaedc8,
      0xceebfefc,0xfedafed8,0x7bbaaaba,0xabaa8996,0x8bcbbaca,0xbcbbaaa7,0xbdedecfc,
      0xedecdbd8,0x8cbbbbcb,0xbcaaaa97,0x8bbbbbca,0xbcaabaa6,0xacdcdceb,0xdddbdbc7,
      0xbeddeedc,0xefccddb8,0xadccdddb,0xdecbdcb7,0xaddcedeb,0xeedbdcc7,0xadddccdc,
      0xcddcaaa8,0xaeeddcec,0xdeddcac8,0xcfffecfc,0xfffeebe9,0xaeeedddc,0xeeddccb8,
      0xaddcccdb,0xddcccbb7,0xbeedeceb,0xeedcdbc7,0xcffffffd,0xffeeeec9,0xbeededec,
      0xefdcddc8,0xbeededeb,0xeedcdcc7,0x9dccdcdc,0xacaaaaa8,0xbefdedfd,0xdddcdcc9,
      0xdfffffff,0xfefcfdfa,0xaeddeded,0xcdabcca8,0xbeedeefd,0xddcbdcc8,0xcffefffe,
      0xfeebfde9,0xbfdefffd,0xdfabdeb8,0xcfedfffd,0xefcbeec8,0xdffdfffe,0xffdbfee9,
      0xaddddddc,0xbdccaaa8,0xaeedddfd,0xdddccbc8,0xcffffefe,0xfefdece9,0xaeeddded,
      0xdeccbca8,0xaddcdddc,0xcdcbcbb7,0xbeedfdfd,0xeeecdcd8,0xcfeffffe,0xefccddb8,
      0xbeddeeec,0xdecbdcb7,0xbeddeeec,0xeedbdcc7,0xbfeecded,0xcedd9aa8,0xbffeedfd,
      0xeeedcbc8,0xdffffdfe,0xfefedbe9,0xbfeeeeed,0xefddbca8,0xaeedddec,0xdedccbb7,
      0xbeededec,0xeedcdbc7,0xdffffffe,0xffdddda8,0xbeedeeec,0xeedcdcb7,0xaddcdcdb,
      0xcdcbcbb6
    },
    {
      0x15545565,0x56555552,0x589898a8,0x99989896,0x9adadada,0xdcdbdbc8,0x59889998,
      0x9a889986,0x7aa8bab9,0xbba9baa7,0xacdafceb,0xfddbecd9,0x9caaddca,0xcdaacca8,
      0xaccaeddb,0xeecbedc9,0xbddafefb,0xffebfee9,0x59998898,0x9a998886,0x7abaa9b9,
      0xbbbaa9a7,0xbcfcdafb,0xfeecdbd9,0x8cbbbbba,0xccbbbba7,0x9ccbcbca,0xddcbcbb8,
      0xbdfceceb,0xfffcfdd9,0xbfddfedc,0xffddeeca,0xbfedfeeb,0xffedfed9,0xdffdfefc,
      0xfffdffea,0x9ddcaacb,0xddccaab8,0xbdfdcadb,0xfeeddbc9,0xcdfedafb,0xfffefcea,
      0xbfeedddc,0xffeeddca,0xcffeddec,0xfffeedda,0xdffefdfc,0xfffefdea,0xeffffffd,
      0xffffffdb,0xeffffffc,0xffffffeb,0xeffefefc,0xfffffffa,0x599999a9,0x89888886,
      0x8bcbcbdb,0xbbbabaa7,0xbdfdfdfd,0xedecfcda,0x7baabbba,0xab99aa97,0x9ccbdcdb,
      0xccbacbb8,0xbeecfefd,0xfeebfde9,0xaeccfedc,0xdeabddb9,0xbfdcfffd,0xfecbeed9,
      0xdffdfffd,0xffecffea,0x7bbbaaba,0xabaa8997,0x9cdccbdb,0xcccbbab8,0xcefefdfd,
      0xfefdecea,0x9ccccccb,0xcdbbbba8,0x9cccccdb,0xcdcbbbb8,0xbeedfdfc,0xfeececd9,
      0xcfeeffed,0xffcdeeb9,0xbfddffec,0xffdcedc9,0xcffdfefc,0xfffcfee9,0xaeedccdc,
      0xceddabb9,0xbefedcfd,0xfefdcbc9,0xdffffdfd,0xfffffcfa,0xbfffeeed,0xefddcdb9,
      0xbffeedfc,0xffeddcc9,0xcffefdfc,0xfffefde9,0xeffffffe,0xffffffcb,0xdffffffd,
      0xfffefeda,0xdffefffc,0xfffefed9,0x9dccccdc,0xacaaaaa8,0xbefefefd,0xdddcdcda,
      0xefffffff,0xfffdfdfb,0xaeddeeed,0xcdabccb9,0xcfeefffe,0xeecbedc9,0xdfffffff,
      0xfffcfffb,0xcfdefffe,0xdfabeeb9,0xdfffffff,0xffccffda,0xefffffff,0xfffcfffa,
      0xaeedcddd,0xcdccaba9,0xbffffefe,0xeeedcbd9,0xefffffff,0xfffefdfb,0xbfeefffd,
      0xdeccccb9,0xbffeeefd,0xdedcdcc9,0xdffffffe,0xfffdfdea,0xdfffffff,0xffddeeba,
      0xcffefffd,0xffdcfdc9,0xdffffffe,0xfffdfde9,0xbffedefd,0xceddabb9,0xcffffeff,
      0xfffecbda,0xefffffff,0xfffffcfa,0xdffffffe,0xffeecdba,0xcffffffe,0xfffddcc9,
      0xdffffffe,0xfffeedd9,0xefffffff,0xffefefca,0xdffffffd,0xffededc9,0xbeededfd,
      0xdfecdcc8
    },
    {
      0x14444455,0x45454553,0x579798a8,0x99989897,0x9acacada,0xdccbcbc9,0x59789998,
      0x9a889986,0x7aa9bab9,0xbba9bba8,0xacdaedeb,0xfddbedda,0x9caadccb,0xcdaaccb9,
      0xadcafddb,0xeedbedda,0xbddafffc,0xfffcffeb,0x59997898,0x9a998887,0x7abba9ba,
      0xbbbbbab8,0xacfddbeb,0xfefddcda,0x8cbbbbba,0xccbbbba9,0x9ccbcbca,0xddccccb9,
      0xcdfdedfc,0xfffdfdeb,0xbfddfedc,0xffddeecb,0xcfedffec,0xffedffdb,0xdffdfffd,
      0xfffffffb,0x9cdcaacb,0xcdccabb9,0xadeecbdc,0xfffedcda,0xbdffdbfc,0xffffecfb,
      0xbfefdedd,0xffefddcb,0xcffffdfc,0xfffffdeb,0xdffffdfd,0xfffffefc,0xeffffffe,
      0xffffffec,0xfffffffe,0xfffffffc,0xeffffffd,0xfffffffc,0x59999999,0x79887886,
      0x8bcbcbcb,0xbbbabab9,0xbdfdfdfd,0xfeedfdeb,0x7baabbba,0xab99ab98,0x9ccbdcdb,
      0xccbaccb9,0xcefdfffd,0xfeecfeeb,0xaecceeed,0xddabddba,0xcfddfffd,0xfeccfdda,
      0xdffdfffe,0xfffdfffb,0x7bbbaabb,0xabaa8998,0x9cdccbdc,0xccccbab9,0xcefefdfd,
      0xfffefceb,0x9dcccccc,0xcdbbbba9,0x9cccccdb,0xcdcbcbb9,0xcffdfefd,0xffedfdea,
      0xcfefffed,0xffddeecb,0xcfedfffd,0xffddeeda,0xdffefffd,0xfffeffeb,0xadedccdd,
      0xceddabba,0xcfffddfd,0xfffedcdb,0xdffffdff,0xfffffdfc,0xcfffefee,0xffefddcb,
      0xcffeedfd,0xfffeddda,0xdffffffe,0xfffffefb,0xffffffff,0xffffffdc,0xefffffff,
      0xffffffeb,0xdfffffff,0xfffffffb,0x8cccccdc,0x9bababa9,0xbefeffff,0xdddcdcdb,
      0xdfffffff,0xfffefffd,0xaeddeded,0xcdabccba,0xcffefffe,0xeedcfedb,0xefffffff,
      0xfffdfffc,0xbfdeffff,0xdfacefcb,0xdfffffff,0xffddffeb,0xffffffff,0xfffdfffc,
      0xaeddcded,0xbdccabba,0xcffffeff,0xeeeedcdb,0xffffffff,0xfffffefc,0xcffffffe,
      0xdfcdcdca,0xcffffffe,0xefedddda,0xefffffff,0xfffffffb,0xdfffffff,0xffdeffcb,
      0xdfffffff,0xffddffeb,0xdfffffff,0xfffffffb,0xaffecefe,0xceeeabba,0xdfffffff,
      0xffffddeb,0xefffffff,0xfffffdfc,0xdfffffff,0xffefddcb,0xdfffffff,0xffffdddb,
      0xdfffffff,0xfffffefb,0xefffffff,0xffffefdc,0xdfffffff,0xffffffeb,0xbddddefd,
      0xdfeddeda
    },
    {
      0x4454566,0x46564555,0x589898a9,0xaaa9a9a8,0x9adbdbfb,0xfcfcdcfb,0x59889aa9,
      0x9a899a98,0x7aa9cbcb,0xccbbccca,0xacfbfffc,0xfffdfffc,0x9dabddcc,0xcfbcdfcb,
      0xadcbfffd,0xffddfffc,0xbdfbffff,0xfffffffd,0x599a88a9,0x9aaa8998,0x8bcbbacb,
      0xccccbbca,0xbcfffcfd,0xfffffdfc,0x8ccccccc,0xcdccccba,0x9ddcdcdc,0xffdedddb,
      0xcfffffff,0xfffffffc,0xcfffffff,0xfffffffd,0xcfffffff,0xfffffffd,0xdfffffff,
      0xffffffff,0x9ddfabdc,0xdfffbccb,0xbfffccfd,0xfffffdfc,0xcffffcff,0xfffffffd,
      0xcfffffff,0xfffffffd,0xdfffffff,0xfffffffd,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x59999aaa,0x8a898998,
      0x8cccccdc,0xbccbcbca,0xcfffffff,0xfffffffd,0x7cbbcccc,0xac9bbcba,0x9dccfffd,
      0xddccdddb,0xcfffffff,0xfffffffd,0xafcfffff,0xdfbcffdc,0xcfffffff,0xfffffffd,
      0xffffffff,0xffffffff,0x7cccabcc,0xacbc9bba,0x9dffdcfd,0xdffdccdb,0xdfffffff,
      0xfffffffd,0x9fdfdddd,0xcfcdcdbb,0x9ddddffd,0xdfdddddb,0xcfffffff,0xfffffffd,
      0xcfffffff,0xfffffffd,0xcfffffff,0xfffffffd,0xdfffffff,0xffffffff,0xafffcfff,
      0xdfffbddc,0xcfffffff,0xfffffffd,0xffffffff,0xffffffff,0xcfffffff,0xfffffffd,
      0xdfffffff,0xfffffffd,0xdfffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xefffffff,0xffffffff,0x8dcdcdff,0xacbcacbb,0xcfffffff,0xfffffffd,
      0xffffffff,0xffffffff,0xafdfffff,0xcfbcdfcc,0xcfffffff,0xfffffffd,0xffffffff,
      0xffffffff,0xbfffffff,0xdfbfffdd,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xafffdfff,0xcfdfbccc,0xcfffffff,0xfffffffd,0xffffffff,0xffffffff,0xcfffffff,
      0xffdfffdd,0xcfffffff,0xfffffffd,0xffffffff,0xffffffff,0xdfffffff,0xffffffff,
      0xdfffffff,0xffffffff,0xffffffff,0xffffffff,0xafffdfff,0xdfffbfdd,0xdfffffff,
      0xffffffff,0xffffffff,0xffffffff,0xdfffffff,0xffffffff,0xdfffffff,0xffffffff,
      0xdfffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xbfffffff,
      0xfffffffc
    },
    {
      0x4454567,0x46575666,0x489999ba,0x9aaa9ab9,0x8acbcbfd,0xfdfffcfc,0x49899aaa,
      0x9a8a9aa9,0x7aaabccc,0xbcbbcccb,0xacfcffff,0xffffffff,0x8dabdfcd,0xcfbdffcc,
      0xafccffff,0xffffffff,0xaddcffff,0xffffffff,0x49aa89aa,0x9bab8aaa,0x7bccaadc,
      0xcdcfbbcb,0xacfffcff,0xffffffff,0x8cbcbccd,0xcfcfcfcc,0x9dcdccfd,0xfffffffc,
      0xcfffffff,0xffffffff,0xbfffffff,0xffffffff,0xcfffffff,0xffffffff,0xcfffffff,
      0xffffffff,0x8dffabdf,0xcfffbdcc,0xafffccff,0xffffffff,0xbfffdcff,0xffffffff,
      0xbfffffff,0xffffffff,0xcfffffff,0xffffffff,0xcfffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x499a9abb,0x7a9a8aaa,
      0x8bccccff,0xbcccccfc,0xbfffffff,0xffffffff,0x7cacbccd,0xac9cbdbb,0x9dcdffff,
      0xcfcdfffd,0xcfffffff,0xffffffff,0xafcfffff,0xcfbfffff,0xbfffffff,0xffffffff,
      0xdfffffff,0xffffffff,0x7cccacdf,0xaccd9bbb,0x9dffcfff,0xcfffccfd,0xcfffffff,
      0xffffffff,0x9fdfcfff,0xcfcfcfcd,0x9fffdfff,0xdfffcffc,0xcfffffff,0xffffffff,
      0xcfffffff,0xffffffff,0xcfffffff,0xffffffff,0xcfffffff,0xffffffff,0x9fffcfff,
      0xdfffbfff,0xcfffffff,0xffffffff,0xffffffff,0xffffffff,0xcfffffff,0xffffffff,
      0xcfffffff,0xffffffff,0xcfffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xcfffffff,0xffffffff,0x8dcfcfff,0x9dbdaccc,0xbfffffff,0xffffffff,
      0xffffffff,0xffffffff,0xafffffff,0xbfbfffff,0xcfffffff,0xffffffff,0xffffffff,
      0xffffffff,0xafffffff,0xcfcfffff,0xdfffffff,0xffffffff,0xffffffff,0xffffffff,
      0x9fffdfff,0xbfffbfff,0xcfffffff,0xffffffff,0xffffffff,0xffffffff,0xbfffffff,
      0xffffffff,0xcfffffff,0xffffffff,0xffffffff,0xffffffff,0xdfffffff,0xffffffff,
      0xcfffffff,0xffffffff,0xdfffffff,0xffffffff,0xafffdfff,0xdfffbfff,0xcfffffff,
      0xffffffff,0xffffffff,0xffffffff,0xcfffffff,0xffffffff,0xcfffffff,0xffffffff,
      0xcfffffff,0xffffffff,0xdfffffff,0xffffffff,0xcfffffff,0xffffffff,0x9fffffff,
      0xdffffffd
    }
  },
  /* Inter 8x8 descriptor: */
  {
    {
      {
        0x5525342,0x54322332
      },
      {
        0x5535342,0x54323331
      },
      {
        0x6636443,0x64434330
      },
      {
        0x6646453,0x65424330
      }
    },
    {
      {
        0x5525243,0x54232332
      },
      {
        0x5535333,0x53323331
      },
      {
        0x5535343,0x54323321
      },
      {
        0x6646453,0x65424330
      }
    },
    {
      {
        0x5525243,0x54232332
      },
      {
        0x4424343,0x44333331
      },
      {
        0x5535342,0x54323331
      },
      {
        0x6646453,0x65424330
      }
    },
    {
      {
        0x5525243,0x54232332
      },
      {
        0x4424343,0x44333331
      },
      {
        0x5535342,0x54323331
      },
      {
        0x6636453,0x65433330
      }
    },
    {
      {
        0x4424243,0x44232333
      },
      {
        0x4424343,0x44232332
      },
      {
        0x5535343,0x54323321
      },
      {
        0x6636453,0x65433330
      }
    },
    {
      {
        0x4424243,0x44232333
      },
      {
        0x4424343,0x44232332
      },
      {
        0x4424333,0x43332332
      },
      {
        0x5535343,0x54323321
      }
    },
    {
      {
        0x3323244,0x34242434
      },
      {
        0x3323343,0x34242433
      },
      {
        0x3323343,0x34332333
      },
      {
        0x3324343,0x44332332
      }
    }
  },
  /* Inter luma 4x4 descriptor: */
  {
    {
      0x6464655,0x69687876,0xbdabbba8,0x58576866,0x7a788987,0xcebbbca8,0x9c89ab87,
      0xbd9abc98,0xffbbdca8,0x58686876,0x8a898987,0xdfbbcca8,0x7a798987,0x9c9a9a87,
      0xdfbbcca8,0xbd9abc98,0xcfabcc98,0xffcbdda8,0xacab9a98,0xcdbbab98,0xffcccca8,
      0xbebbab98,0xcfccbba8,0xffdccca8,0xdfcccda8,0xffccdda8,0xffccdca7,0x38575866,
      0x7a788977,0xcebbcca8,0x69687977,0x8b899a87,0xdfbbcca8,0xac89ab87,0xbd9abc98,
      0xffcbdda8,0x69787977,0x9b9a9a87,0xdfcccca8,0x8b898a87,0xac9a9a98,0xefcccca8,
      0xbdaabc98,0xcfabcc98,0xffbbdca7,0xadab9a98,0xcebcab98,0xffdccca8,0xbebcab98,
      0xcfccbba8,0xffdccca8,0xefcccca8,0xffcccca8,0xffcbcc96,0x7a798a88,0x9c9aab98,
      0xefccddb9,0x8b8a9a88,0xbdaaab98,0xffccddb9,0xbd9abc98,0xdfabcd98,0xffcceda8,
      0x8b9a8a98,0xbdabab98,0xffdcddb9,0xad9bab98,0xbeabbca9,0xffdcddb9,0xcfabcda8,
      0xdfbbcda8,0xffccdda8,0xbebc9b98,0xdfccaba9,0xffdddcb8,0xcfccbca9,0xdfccbca9,
      0xffddccb8,0xefcccda8,0xffcccda8,0xffcbcc97,0x9c9a9b98,0xbdabbca9,0xffccddb8,
      0xad9aab98,0xcfabbca9,0xffdcddb8,0xbe9abc87,0xdfaacd97,0xffbbdd97,0xadabab98,
      0xcfbcbca9,0xffdcddb8,0xbeabac99,0xcfbcbca9,0xffdcddb8,0xcfaacc97,0xdfabcd97,
      0xffbbdd97,0xbebc9a98,0xdfccab98,0xffdccca7,0xcfbcab98,0xdfccbb98,0xffdccb97,
      0xdfbbbc97,0xdfbbbc96,0xffaaba74
    },
    {
      0x6364655,0x59677876,0xcdabbba8,0x48576866,0x7a788987,0xcfbbbca8,0x9c79ab88,
      0xbd9abc98,0xefbbdda8,0x59686876,0x7a898987,0xdfbbcba8,0x7a798987,0x9c9a9a88,
      0xdfbbcca8,0xbe9abc98,0xcfabcc98,0xffbcdda8,0x9dab8a98,0xbebcaba8,0xffcccca8,
      0xbebcaba8,0xcfbcbca9,0xffcccca8,0xdfcccda9,0xffcccda9,0xffccdda8,0x38575866,
      0x7a788987,0xcebbcca8,0x59687977,0x8b899a87,0xdfbbcca9,0x9c79ab88,0xbe9abc98,
      0xffbbdda8,0x6a786977,0x8b9a8a88,0xdfbccca9,0x8b898a88,0x9c9a9a98,0xdfbccca8,
      0xbe9abc98,0xcfabcc98,0xffbbdda8,0x9dab8a98,0xbfbcaba8,0xffddcca8,0xbfbcab99,
      0xcfbcaba9,0xffcccca8,0xdfcccda8,0xefcccda8,0xffcccc97,0x6a798a88,0x9c9aab99,
      0xefccddb9,0x8c8a9b98,0xad9bbc99,0xffccddb9,0xae8abc98,0xcfabcda9,0xffcceea9,
      0x8c9a8a98,0xadababa9,0xffddddb9,0x9d9bab99,0xbeabbca9,0xffccddb9,0xcfabcda9,
      0xcfabcda9,0xffbcdda8,0xaebc9b99,0xcfcdaca9,0xffddddb9,0xcfccaca9,0xdfcdbca9,
      0xffddccb9,0xefcddda9,0xefcccda9,0xffbccc97,0x8c9a9b99,0xbeabbca9,0xffdcddb9,
      0x9d9bac99,0xcfabbda9,0xffccddb9,0xbf8abd98,0xcf9bcd98,0xffbbdda8,0x9dab9b99,
      0xcfbcbca9,0xffddddb9,0xafabaca9,0xcfbcbda9,0xffddddb9,0xcfabcd98,0xdfabcd98,
      0xffbbdd97,0xbfbc9b98,0xdfccaba8,0xffddcca8,0xcfbcab98,0xdfccaca8,0xffddcca8,
      0xdfbcbc97,0xdfbbbc97,0xefaaab85
    },
    {
      0x6364655,0x59677877,0xcdabbba9,0x48576866,0x7a788987,0xcfbbcca9,0x9d79ac88,
      0xbe9abc99,0xffbcdda9,0x49685877,0x7a898987,0xdfbbcca9,0x7b798988,0x9c8a9a88,
      0xdfbccca9,0xbf9bbc99,0xcfabcda9,0xffbcdda9,0x9dac8a99,0xbfbcaba9,0xffcdccb9,
      0xbfbcaca9,0xcfbcbca9,0xffcdcdb9,0xdfcdcdba,0xffcddeba,0xffcddda9,0x28475866,
      0x7a798987,0xdebbcca9,0x5a587977,0x8b899a88,0xdfbccca9,0x9d7abc88,0xbf9abc99,
      0xffbcdda9,0x5a796977,0x8b9a8a88,0xdfbcccb9,0x8b8a8a88,0x9c9a9b98,0xdfbccca9,
      0xbf9bbd99,0xcf9bcda9,0xffbcdda9,0x9eac8a99,0xbfbcaba9,0xffddcdb9,0xbfbcaca9,
      0xcfbcaca9,0xffcdccb9,0xdfcdddaa,0xefcdcda9,0xffcccda8,0x6b7a8a89,0x9d9baba9,
      0xffccddba,0x8c8a9b99,0xae9bbca9,0xffcdddba,0xaf8abd99,0xcf9bcda9,0xffcdffba,
      0x8c9b8b99,0xaeacacaa,0xffddddca,0x9d9baca9,0xbfacbcaa,0xffcdddba,0xcfaccdaa,
      0xcfaccdaa,0xffbcdeb9,0xafbd9ba9,0xcfcdacaa,0xffefddca,0xcfcdbcaa,0xcfcdbcaa,
      0xffddcdba,0xefcddfba,0xdfcdcdba,0xffbccda8,0x8d9b9caa,0xbfbcbdba,0xffddddca,
      0x9f9cbdaa,0xcfbccdba,0xffddeeca,0xbf8bcd99,0xdfabcea9,0xffccefa9,0x9facacaa,
      0xcfbdbdba,0xffddddca,0xafacbdaa,0xcfbdcdba,0xffdddeca,0xcfaccda9,0xdfaccda9,
      0xffbcdea8,0xbfbd9ca9,0xdfcdaca9,0xffdecdb9,0xcfcdaca9,0xdfcdbca9,0xffddcca9,
      0xdfbccda8,0xdfbcbc98,0xdfaabb86
    },
    {
      0x6353656,0x58676877,0xcdbbbcaa,0x48476867,0x7a798988,0xcebcbcaa,0x8d7aac99,
      0xae9bbc9a,0xdfbcddba,0x48685877,0x7a797988,0xcfbcccaa,0x6a798a88,0x8c8a9a99,
      0xdfbcccba,0xaf9bbdaa,0xcfaccdaa,0xffcddeba,0x9eac8b99,0xbfbcabaa,0xefcdcdba,
      0xbfbdacaa,0xcfbdbcba,0xffcdddba,0xdfcddebb,0xffcddfbb,0xffdddeba,0x28475867,
      0x6a798988,0xcdbcccba,0x5a587978,0x8b799a89,0xdfbccdba,0x8d7aac99,0xbf9bbdaa,
      0xffbcdeba,0x5a796978,0x8b8a8a99,0xdfcccdba,0x7b8a8a89,0x9c8a9b99,0xdfbccdba,
      0xbf9bbdaa,0xbf9bcdaa,0xefbcddaa,0x9eac8b99,0xbfbdacaa,0xffddddba,0xbfbdacaa,
      0xcfbdacaa,0xffcdcdba,0xdfcddeba,0xdfcdceba,0xffcdcda9,0x5c7a8b99,0x9d9bacaa,
      0xffcdddcb,0x7d7b9c9a,0xae9bbcaa,0xffddefcb,0xaf8bbdaa,0xcfaccfaa,0xffcdffcb,
      0x7d9b8b9a,0xaeacacaa,0xffdedecb,0x9e9cacaa,0xaeacbcaa,0xffcedecb,0xbfacceaa,
      0xcfacceaa,0xffbddfba,0xafbd9caa,0xcfcebdbb,0xffefdecb,0xbfcdbdbb,0xcfcdbdbb,
      0xffdecdbb,0xefcedfbb,0xdfcdcebb,0xefbccda9,0x8e9cadab,0xbfbdbdbb,0xffdddecb,
      0x9f9cbdbb,0xcfbdcebb,0xffddefcb,0xaf8bceaa,0xdfacdfaa,0xffcdffba,0x9fadadbb,
      0xcfcdbdbb,0xffdeeecb,0xafbdbebb,0xcfbdcebb,0xffdeefcb,0xbfacceaa,0xcfacceaa,
      0xffbcdfb9,0xafbd9caa,0xdfcdbdaa,0xffefddba,0xbfcdadaa,0xcfcdbdaa,0xffdecdba,
      0xdfbdcda9,0xcfbcbda9,0xdfabbb97
    },
    {
      0x6263656,0x58686878,0xcdbcccbb,0x38486878,0x6a798a89,0xcfbdcdbb,0x8d7bbd9a,
      0xaf9ccdab,0xefcddfbb,0x49685878,0x7a7a7989,0xdfbdcdbb,0x6b7a8a89,0x8c8b9b9a,
      0xdfbdcdbb,0xbfacceab,0xcfadcebb,0xefcedfcc,0x9ebd8cab,0xbfbdacbb,0xefcedecc,
      0xbfbdbdbb,0xcfcdbdbb,0xffdedfcc,0xefcedfbc,0xffdfdfcc,0xffdfefcc,0x28485878,
      0x6a798a89,0xdecdcdbb,0x4a597a89,0x8b8a9b9a,0xdfcddecc,0x8e7bbd9a,0xbf9cceab,
      0xefcddfcc,0x5a7a6989,0x8c9b8b9a,0xdfcdddcc,0x7c8b8b9a,0x8c8b9b9a,0xdfbdcdbb,
      0xbfacceab,0xbfacceab,0xdfbddebb,0x9ead8cab,0xbfbdadbb,0xffdfdecc,0xbfbdadbb,
      0xbfcdadbb,0xefdecebc,0xdfcedfcc,0xdfcedfbc,0xefcecebb,0x5c7b8b9a,0x9dacacbb,
      0xefdeeedc,0x7d8bacab,0xaeacbdbb,0xffdeefdd,0x9f8cbeab,0xcfadcfbb,0xffdeffcc,
      0x7d9c8cab,0xaebdadbb,0xffefefdd,0x9e9cadab,0xaeadbdbb,0xefdedfcc,0xbfadcfbb,
      0xbfadcebb,0xefbdefcc,0xafbd9dab,0xcfcfbdbc,0xffffefdc,0xbfcebdbc,0xcfcebdbc,
      0xffdfcecc,0xefdfdfcc,0xdfcecfcc,0xdfbdcdbb,0x8fadaebc,0xcfbdbecc,0xffdeeedc,
      0xafadbfbc,0xcfbdcfcc,0xffdeffdc,0xaf9ccfab,0xdfaddfbb,0xffddffcb,0xafbdaebc,
      0xcfcecfcc,0xffefefdc,0xafbebfbc,0xcfcecfcc,0xffefefdc,0xbfadcfbb,0xcfadcfbb,
      0xffcdefbb,0xafbd9dab,0xdfcebebb,0xffffdecb,0xbfcebdbb,0xcfcebdbb,0xffdfdebb,
      0xdfcecfab,0xcfbdceaa,0xdfbcbca9
    },
    {
      0x6373767,0x59697989,0xcfcececd,0x39496989,0x6b7a8b9a,0xcfcecfcd,0x8f8cbfac,
      0xafadcfbd,0xefdfefdd,0x39695989,0x7b8b8a9b,0xcfcfdfcd,0x6b7b8b9b,0x8c9c9cab,
      0xdfcfdfcd,0xbfadcfbd,0xcfbfdfcd,0xffdfefdd,0x9fbe9dbc,0xbfcfbdcd,0xefdfdfdd,
      0xbfcfbfcd,0xcfcfcfcd,0xffdfefde,0xefdfefce,0xffdfefde,0xffffffee,0x18495979,
      0x6a7a8a9a,0xdfcededd,0x4a5a7b8a,0x7c8b9cab,0xdfcedfdd,0x8f7cbfac,0xbfadcfbc,
      0xffdfefde,0x4b7a6a8a,0x8c9c9cab,0xdfdfdfde,0x7c8c9cab,0x8c9c9cac,0xcfcecfcd,
      0xbfadcfbd,0xbfadcfbd,0xdfcfdfcd,0x9fbe8dac,0xbfcfbebd,0xffefefdd,0xbfcfbfbd,
      0xbfcfbecd,0xefdfdfdd,0xefdfdfde,0xdfcfdfcd,0xffdfdfcd,0x5d8c8dab,0x9dacadbc,
      0xffefefde,0x7e8cadac,0xafadbebd,0xffefffef,0x9f8dbfbc,0xcfaedfcd,0xffefffef,
      0x7e9c9dac,0xafbdbdbd,0xffffffef,0x9fadaebc,0xafadbebd,0xffdfefde,0xbfaecfcd,
      0xbfadcfcd,0xefcfffde,0x9fbe9ebc,0xcfcfbfcd,0xffffffee,0xbfcfbfcd,0xbfcfbfcd,
      0xffefdfde,0xefdfefde,0xdfcfdfcd,0xdfcedfcd,0x8fafafbd,0xcfbfcfcd,0xffefffee,
      0xafafbfcd,0xcfbfcfcd,0xffefffee,0xaf9ecfbc,0xdfbfdfcd,0xffefffdd,0xafbfafcd,
      0xcfcfcfcd,0xffffffee,0xafbfbfcd,0xcfcfcfcd,0xffefffed,0xbfbecfbd,0xcfbfdfcd,
      0xffdfffdd,0xafbfafbd,0xdfdfbfcd,0xffffffed,0xbfcfbfbd,0xcfcfbfcd,0xffffefdd,
      0xdfcfdfbd,0xcfcfcfbc,0xefcddecc
    },
    {
      0x7394879,0x5a7b7a9c,0xdfdfdfff,0x2a4a7b9b,0x6b8c9cac,0xdfdfffff,0x8f8fbfbf,
      0xafafdfcf,0xffffffff,0x3a6b5a9b,0x7c8c8cad,0xcfdfdfff,0x6c8c8cac,0x8d9fafbf,
      0xefdfffff,0xbfbfdfcf,0xcfcfffff,0xffffffff,0x9fbf9fcf,0xbfcfbfff,0xffffffff,
      0xbfcfcfdf,0xcfdfdfff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x194a5a8a,
      0x6b8c8cac,0xdfffffff,0x3b5b7c9c,0x7c8cafbf,0xffffffff,0x8f7fbfbf,0xbfafcfcf,
      0xffffffff,0x4b7c6c9c,0x7d9d9dbd,0xffffffff,0x6d8f9fad,0x7d9fafbf,0xcfdfffff,
      0xafafcfcf,0xbfbfdfdf,0xffffffff,0x8fbf9fbf,0xbfcfbfdf,0xffffffff,0xbfcfbfdf,
      0xbfcfbfdf,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x5f7f8fac,0x9fafafcf,
      0xffffffff,0x6f8f9fbf,0xafafbfcf,0xffffffff,0x9f8fbfcf,0xcfbfffff,0xffffffff,
      0x6f9f8fbf,0xafbfbfcf,0xffffffff,0x8fafafbf,0xafbfcfcf,0xffffffff,0xbfbfdfdf,
      0xbfbfdfff,0xffffffff,0x9fbf9fcf,0xcfdfcfff,0xffffffff,0xbfcfbfdf,0xbfdfcfff,
      0xffffffff,0xffffffff,0xdfffffff,0xffffffff,0x8fafafcf,0xbfcfcfef,0xffffffff,
      0x9fafcfcf,0xcfcfdfff,0xffffffff,0xafafdfcf,0xdfcfffff,0xffffffff,0x9fbfbfcf,
      0xcfcfcfdf,0xffffffff,0xafbfcfdf,0xcfcfdfff,0xffffffff,0xbfbfdfdf,0xdfdfffff,
      0xffffffff,0xafcfafdf,0xffffdfff,0xffffffff,0xbfdfcfdf,0xffffdfff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff
    }
  },
  /* Inter luma 2x2 descriptors: */
  {
    {
      {
        0x3725756,0x73575676,0x77677777,0x77725735,0x86674685,0x68777677,0x77777657,
        0x86786786,0x78678778,0x77878877,0x77887886,0x77788788,0x77767777,0x76650000
      },
      {
        0x4725856,0x83585687,0x78678788,0x88815836,0x86784685,0x68778678,0x78888747,
        0x95797886,0x79689788,0x78988988,0x86897897,0x78789789,0x77878878,0x87760000
      }
    },
    {
      {
        0x3725756,0x83574677,0x78667777,0x78725735,0x86684585,0x68778677,0x77777757,
        0x86796786,0x79679778,0x67878888,0x76897897,0x77789788,0x77767777,0x77650000
      },
      {
        0x3825857,0x83584687,0x78679789,0x88815836,0x86784685,0x69788689,0x78988847,
        0x95797896,0x7968a889,0x78989999,0x868978a7,0x8978a78a,0x88988988,0x98870000
      }
    },
    {
      {
        0x3725867,0x83574687,0x88678778,0x88815835,0x86794685,0x68778678,0x77888857,
        0x96797895,0x79779889,0x78988999,0x87897897,0x89789889,0x88878878,0x88870000
      },
      {
        0x3825867,0x92584697,0x89689789,0x99915836,0x96893695,0x79789789,0x88999947,
        0xa68a79a6,0x8a78a89a,0x89a99aaa,0xa79a89a8,0x9a89b89b,0x9aa89a9a,0xa9990000
      }
    },
    {
      {
        0x3825867,0x92585688,0x89678789,0x99a15836,0x96893695,0x69889679,0x78999957,
        0xa68a79a5,0x8a78a88a,0x78a89aa9,0x979a89a8,0x9a79a89a,0x99a79a89,0xa9990000
      },
      {
        0x3815868,0xa2595698,0x9a68989a,0xaab15936,0x978a4696,0x7989a78a,0x89aaba58,
        0xa69b8ab6,0x9b89baab,0x8ab9abbb,0xb8ab8aca,0xbc8ac9bc,0xabcabcab,0xcbcb0000
      }
    },
    {
      {
        0x3825968,0xa2484698,0x9b67989a,0xabb15936,0x968b3695,0x6a89b68a,0x88aaab47,
        0xa68b89c5,0x8b78b99b,0x79b99bbb,0xb79b8ac9,0xac8ac9ac,0xaac8ab9a,0xbaab0000
      },
      {
        0x4825979,0xb2595799,0xab78a99b,0xccc05947,0xa8ac47a6,0x8aaac78a,0x99bccd58,
        0xb7acace7,0x9c9acbce,0x9bcbbcdd,0xd8bdacec,0xefacebde,0xdefcdedd,0xeeff0000
      }
    },
    {
      {
        0x4926a8a,0xd26a67ba,0xbd68b9ad,0xcdf06a47,0xb8ae37b6,0x8cabe79c,0x9adddf58,
        0xc7ad9cf6,0x9d8aebcf,0x8aebbedd,0xf9bdaceb,0xdf9beacf,0xcdf9cfbc,0xedef0000
      },
      {
        0x3825a8b,0xf25957ab,0xcf78b9ac,0xfff05947,0xb9cf47a7,0x8ccdf89d,0xabefff59,
        0xc8bfdff8,0xbdacffff,0xbdfdffff,0xfaffcfff,0xffbffcff,0xffffffff,0xffff0000
      }
    },
    {
      {
        0x4a26c8b,0xf26b58da,0xcf69fabf,0xfff05b48,0xf8cf37f6,0x9fbef6af,0xabffff59,
        0xe7afadf6,0xaf9bfcff,0x8cfcdfff,0xf9bfbfff,0xffacfcff,0xfffbffff,0xffff0000
      },
      {
        0x2826aae,0xf25a68bf,0xff79faff,0xfff05a58,0xefff47f8,0xaffff9ff,0xffffff6a,
        0xfafffffa,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000
      }
    }
  },
  /* Inter chroma 4x4 descriptor: */
  {
    {
      0x6374767,0x59697988,0xcfbccdbb,0x39587a78,0x7b7a9b99,0xdfbcdebb,0x8d8abdaa,
      0xae9bcdaa,0xefcdefcb,0x49696988,0x7b8a9a99,0xdfcdddbb,0x7b7a9b99,0x9d9bac9a,
      0xefcddecb,0xaf9bceaa,0xcfacdebb,0xffddffcb,0xaeacacaa,0xcfbdbcbb,0xffdeeecb,
      0xbfbdbdbb,0xdfcdcdbb,0xffdfffcb,0xdfcdefcb,0xffdeffcb,0xffefffcb,0x18475878,
      0x6a798a89,0xcfbcddbb,0x4a598a88,0x8c8a9b99,0xdfbddebb,0x8d8abd9a,0xaf9bcdaa,
      0xffcdefcb,0x5a697a88,0x8c8a9b99,0xdfcdddbb,0x7c7a9b99,0x9c9bac9a,0xdfcddebb,
      0xae9bceaa,0xbfacceba,0xffcdefcb,0xaeac9caa,0xcfbdbcba,0xffdeeecb,0xbfbcbdbb,
      0xcfbdcdbb,0xffdeeecb,0xdfcdefbb,0xffcdefbb,0xffdeffcb,0x5b698b89,0x8c8bacaa,
      0xdfcdeecb,0x7c7a9c99,0x9d9bbdaa,0xefcdffcb,0x9e8bbeaa,0xbfacdfbb,0xffddffcb,
      0x7c8a9b9a,0xadabacaa,0xffdeefcb,0x9d9bacaa,0xaeacbdaa,0xefcdefcb,0xbfaccfbb,
      0xcfacdfbb,0xffcdffcb,0xbfbdacaa,0xcfcdbdbb,0xffefffdc,0xcfbdbdbb,0xdfcdcdbb,
      0xffdfdfcb,0xefceefcb,0xefcedfcb,0xffdeefca,0x7c7a9c9a,0xae9bbdaa,0xefcdeecb,
      0x8d8bad9a,0xaf9bcdaa,0xffcdefcb,0xae8bbd99,0xbfabdeaa,0xffcdffba,0x8d9bacaa,
      0xbfacbdaa,0xffddeecb,0x9e9bbdaa,0xbfaccdaa,0xffddefcb,0xbf9bceaa,0xcfacdeaa,
      0xffccefba,0xbfac9caa,0xdfcdbdaa,0xffefdeca,0xcfbdbdaa,0xcfbdbdaa,0xffdeddba,
      0xdfbcceaa,0xdfbccdaa,0xefbccc98
    },
    {
      0x6364767,0x49697989,0xcfbdddcb,0x39587a88,0x7b7a9b99,0xdfcddecb,0x8d8bbdaa,
      0xbfaccebb,0xefdeefcc,0x49696988,0x7b8a8a99,0xdfcddecb,0x6b7a9b99,0x9c9bacaa,
      0xefcedfcc,0xafaccfbb,0xcfbddfbb,0xffdfffdc,0xaebdacab,0xcfbdbdbb,0xffdfdfcc,
      0xcfbdbdbb,0xdfcececc,0xffefffdc,0xefcfefcc,0xffdfffdc,0xffffffdc,0x18475878,
      0x6a798a89,0xdfcddecb,0x4a598a89,0x7c8aab9a,0xdfcddfcc,0x8e8bbdaa,0xbfaccebb,
      0xffdeffdc,0x5a697a89,0x8c8b9b9a,0xdfcddecc,0x7b7a9b9a,0x8c9bacaa,0xdfcddfcc,
      0xbfaccebb,0xcfacdfbb,0xffdeffcc,0xaead9cab,0xcfcebdbb,0xffefefdc,0xbfbdbdbb,
      0xcfcecdbc,0xffefefcc,0xefcfefcc,0xffdfffcc,0xffefffdc,0x4b698b99,0x8c8bacaa,
      0xefcdeecc,0x6c7a9c9a,0x9d9bbdab,0xffdeffdc,0x9f8bceab,0xcfacdfbb,0xffdfffdc,
      0x7c8b8b9a,0xaeacacab,0xffdfffdc,0x8d9bacab,0xaeacbdbb,0xffdfefdc,0xbfaddfbb,
      0xcfbddfcc,0xffceffdc,0xafbd9cbb,0xcfcebdbc,0xffffffdd,0xcfcebebc,0xcfcebecc,
      0xffefdfdc,0xffdfffdc,0xefdfefdc,0xffdfefcb,0x7d8b9dab,0xaf9cbdbb,0xffdeefdc,
      0x8e8bbdab,0xbfaccebb,0xffdeffdc,0xaf8bceaa,0xcfacdfbb,0xffddffcb,0x8e9cadab,
      0xbfadbdbb,0xffdfffdc,0x9f9cbebb,0xbfbdcebb,0xffdfffdc,0xbfaccfbb,0xcfacdfbb,
      0xffcdffcb,0xafbd9cab,0xcfcebdbb,0xffffefcb,0xbfbebdbb,0xcfcebdbb,0xffefdecb,
      0xdfcdcfbb,0xcfbdcebb,0xdfbccda9
    },
    {
      0x6274768,0x49697a99,0xdfdedfdd,0x39597a89,0x7b8a9baa,0xefdfefdd,0x9f9ccfbc,
      0xcfbddfcc,0xffffffde,0x39696989,0x7b8b9bab,0xdfdfefdd,0x7b8b9cab,0x9dacadbc,
      0xffdfffde,0xbfbddfcd,0xdfcfffdd,0xffffffff,0xafbfadcc,0xcfcfcecd,0xffffffef,
      0xcfcfcfcd,0xdfdfdfde,0xffffffff,0xffefffef,0xffffffff,0xffffffff,0x18485979,
      0x6a7a8b9a,0xdfdfefdd,0x4a598b9a,0x8c8bacab,0xffdfffdd,0x9f8ccfbc,0xcfbddfcc,
      0xfffffffd,0x4a7a6a9a,0x8c9c9cab,0xffdfffdd,0x7c8b9cab,0x9d9cadbb,0xffdfefdd,
      0xbfbddfcd,0xdfbfefcd,0xffefffee,0xafbf9dbc,0xcfdfcfcd,0xffffffef,0xcfcfcfcd,
      0xdfdfcfcd,0xffffffef,0xffefffef,0xffffffff,0xffffffef,0x4c6b8cab,0x9d9cacbc,
      0xfffffffe,0x6d7badab,0xafaccfcc,0xffffffff,0xaf9ddfbc,0xcfbeffdd,0xffffffff,
      0x7d9c8cab,0xafbdbdcc,0xffffffff,0x9fadbdbc,0xafbdbecc,0xffefffef,0xcfbfefdd,
      0xcfbfffdd,0xffdfffdf,0xafcf9dbc,0xdfdfcfdd,0xffffffff,0xcfdfcfde,0xcfdfcfde,
      0xffffefef,0xffffffff,0xffefffef,0xffefffdd,0x7f9dafbc,0xbfbdcfcd,0xfffffffd,
      0x9f9dbfbc,0xcfbedfcd,0xfffffffe,0xaf9ccfbc,0xdfbdefcc,0xffffffed,0x9fadafbc,
      0xcfcfcfcd,0xfffffffe,0xafbdcfcd,0xcfcfdfcd,0xfffffffe,0xcfbddfcc,0xcfbedfcc,
      0xffdfffdc,0xafbfaebc,0xdfdfcfcd,0xffffffdd,0xbfcfbfcd,0xcfdfcfcd,0xffffdfdd,
      0xdfcfdfcc,0xcfcfdfcc,0xefcdcebb
    },
    {
      0x7384879,0x5a7a8bab,0xffffffff,0x3a5a8b9b,0x8c9cafbc,0xffffffff,0xafafffdf,
      0xdfcfffff,0xffffffff,0x3a7b6b9b,0x7c9c9cbd,0xffffffff,0x7c9dafbd,0xafbfbfcf,
      0xffffffff,0xdfcfffff,0xffffffff,0xffffffff,0xbfdfbfff,0xcfffdfff,0xffffffff,
      0xdfffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x9496a8a,
      0x7b8b9cbc,0xffffffff,0x4b6b9cab,0x8f9cbfcf,0xffffffff,0xaf9fffdf,0xdfcfffff,
      0xffffffff,0x5b8c7bac,0x9fafafcf,0xffffffff,0x8f9dafbf,0x9fafbfcf,0xffffffff,
      0xdfcfffff,0xffcfffff,0xffffffff,0xbfdfafdf,0xffffdfff,0xffffffff,0xefffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x5f8c9fbd,0xafbfbfcf,
      0xffffffff,0x7f8dbfcf,0xbfbfdfff,0xffffffff,0xbf9fffdf,0xffcfffff,0xffffffff,
      0x7faf9fbf,0xbfcfcfdf,0xffffffff,0x9fbfcfdf,0xafcfcfff,0xffffffff,0xdfcfffff,
      0xdfcfffff,0xffffffff,0xbfffafdf,0xffffdfff,0xffffffff,0xdfffffff,0xffffcfff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x7fafbfcf,0xcfcfdfff,0xffffffff,
      0x9fafcfdf,0xdfcfffff,0xffffffff,0xaf9fffcf,0xffcfffff,0xffffffff,0x9fbfbfcf,
      0xcfffdfff,0xffffffff,0xafcfdfff,0xcfdfffff,0xffffffff,0xcfbfffdf,0xdfcfffff,
      0xffffffff,0xafcfafcf,0xffffcfff,0xffffffff,0xcfffcfff,0xcfffcfff,0xffffffff,
      0xffffffff,0xdfffffff,0xffdfffde
    },
    {
      0x738498a,0x4a8b8cbf,0xffffffff,0x3a5b8cac,0x8f9fbfcf,0xffffffff,0xbfafffff,
      0xffffffff,0xffffffff,0x3b7c6baf,0x7fafafef,0xffffffff,0x7f9fafcf,0xafbfcfff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xbfffcfff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x95a6b9c,
      0x6b9c9fbf,0xffffffff,0x4c6b9fbf,0x9fafbfff,0xffffffff,0xafafffff,0xffcfffff,
      0xffffffff,0x4c8f7fbf,0x8fbfafff,0xffffffff,0x8fafbfcf,0x9fbfbfff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xbfffbfff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x5f8f9fcf,0xafbfcfff,
      0xffffffff,0x7f8fbfcf,0xbfbfffff,0xffffffff,0xaf9fffff,0xffcfffff,0xffffffff,
      0x7fafafcf,0xbfcfcfff,0xffffffff,0x9fbfcfff,0xafcfffff,0xffffffff,0xefffffff,
      0xffcfffff,0xffffffff,0xbfffafff,0xffffffff,0xffffffff,0xffffffff,0xffffcfff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x6fafbfff,0xcfffffff,0xffffffff,
      0x9fafcfff,0xffcfffff,0xffffffff,0xaf9fffff,0xffbfffff,0xffffffff,0x9fbfbfff,
      0xffffffff,0xffffffff,0xafcfffff,0xffffffff,0xffffffff,0xcfbfffff,0xffbfffff,
      0xffffffff,0xafffafff,0xffffffff,0xffffffff,0xcfffcfff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff
    },
    {
      0x7394a9f,0x4b8f9fff,0xffffffff,0x3b6b8fbf,0x8fafbfff,0xffffffff,0xbfbfffff,
      0xffffffff,0xffffffff,0x3b8f7fbf,0x7fafafff,0xffffffff,0x7fafbfff,0xafffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xbfffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xa5b6faf,
      0x6f9fafff,0xffffffff,0x4f6f9fbf,0x8fafffff,0xffffffff,0xafafffff,0xffffffff,
      0xffffffff,0x4f9f7fbf,0x8fbfbfff,0xffffffff,0x8fafbfff,0x9fbfbfff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xbfffbfff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x4f8f9fff,0xafbfffff,
      0xffffffff,0x7f8fbfff,0xbfffffff,0xffffffff,0xaf9fffff,0xffffffff,0xffffffff,
      0x7fafafff,0xbfffffff,0xffffffff,0x9fbfffff,0xafffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xafffafff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x5f9fbfff,0xbfffffff,0xffffffff,
      0x8f9fffff,0xffffffff,0xffffffff,0xaf8fffff,0xffbfffff,0xffffffff,0x8fffbfff,
      0xffffffff,0xffffffff,0xafffffff,0xffffffff,0xffffffff,0xcfbfffff,0xffbfffff,
      0xffffffff,0xafffafff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff
    },
    {
      0x93b4faf,0x5f9fafff,0xffffffff,0x2f6f9fff,0x8fbfffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0x3f9f8fff,0x8fffffff,0xffffffff,0x8fbfffff,0xafffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf5f7fff,
      0x7fafbfff,0xffffffff,0x4f7fafff,0x9fbfffff,0xffffffff,0xbfafffff,0xffffffff,
      0xffffffff,0x4faf8fff,0x9fffffff,0xffffffff,0x8fbfffff,0x9fffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x4f8fafff,0xafffffff,
      0xffffffff,0x7f9fffff,0xffffffff,0xffffffff,0xbfafffff,0xffffffff,0xffffffff,
      0x7fffafff,0xffffffff,0xffffffff,0x9fffffff,0xbfffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xbfffbfff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x5fafefff,0xefffffff,0xffffffff,
      0x8f9fffff,0xffffffff,0xffffffff,0xaf8fffff,0xffbfffff,0xffffffff,0x9fffffff,
      0xffffffff,0xffffffff,0xafffffff,0xffffffff,0xffffffff,0xffbfffff,0xffffffff,
      0xffffffff,0xbfffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
      0xffffffff,0xffffffff,0xffffffff
    }
  },
  /* Inter chroma 2x2 descriptors: */
  {
    {
      {
        0x3825867,0x92584698,0x89679789,0x99915836,0x97893695,0x69889679,0x78999957,
        0x968a89a6,0x8a78a99a,0x78a89aaa,0x979a89a8,0x9a79a89a,0x99a79a89,0x99980000
      },
      {
        0x3815967,0x92595698,0x8978a89a,0x9aa15936,0x97894696,0x7988989a,0x99aaaa58,
        0xa68a89b7,0x8a79a99a,0x9abaabaa,0xa8ab9ab9,0xab9ab9ab,0xaababbab,0xbbaa0000
      }
    },
    {
      {
        0x3825978,0xa2484698,0x9a67988a,0xaab14936,0x978a3595,0x6989a689,0x88aaaa57,
        0xa68a89b6,0x8a78b99b,0x79a99aba,0xa79b8ab9,0xab89b9ab,0xaab89b99,0xaaa90000
      },
      {
        0x3814967,0xa2595698,0x9a78a89a,0xaab15936,0x978a4695,0x7989a89b,0x99babb58,
        0xa78b8ac7,0x9b89baab,0x9bcabccb,0xc9ac9bca,0xbcabcabc,0xbbcbcdcc,0xdccc0000
      }
    },
    {
      {
        0x3925979,0xb15957a9,0xab68a89b,0xbcc15936,0xa89c36a6,0x7a9ab78b,0x99bbbc58,
        0xb79c9bd6,0x9c89caac,0x8acaaccc,0xc8ac9bda,0xbd8adabd,0xbbd8bcab,0xccbb0000
      },
      {
        0x3925a79,0xb25a57a9,0xac89cabd,0xccd05947,0xb89c47a6,0x8baac9bc,0xabddce69,
        0xb8adabe8,0xac9adbbd,0xbdfccfdd,0xfbcebdec,0xdfcdfddf,0xdefdffef,0xfeef0000
      }
    },
    {
      {
        0x3b26b9a,0xd25b68cb,0xcd7acabd,0xddd06b47,0xc9bd37c7,0x8cbcd8ad,0xabdddd69,
        0xd8adacf7,0xad9bdccf,0x9bebceee,0xe9cebcdc,0xee9cebce,0xcde9cdbc,0xdddd0000
      },
      {
        0x3a15b8a,0xf36b68ea,0xbf9afacf,0xfff05a47,0xf8bf58e7,0x9fbcfbdf,0xbfffff7a,
        0xd9bfbff9,0xcfbffcdf,0xdfffffff,0xfccfffff,0xffffffff,0xdfffffff,0xffff0000
      }
    },
    {
      {
        0x3b26c9b,0xe26c68db,0xbc7adace,0xedd05c47,0xc9ce37c7,0x8dcce7ad,0xbbeedd69,
        0xc8acbdf7,0xad9beccf,0x9bebceed,0xeabdbddc,0xee9bdbce,0xdee9ccbc,0xedde0000
      },
      {
        0x3f16f9c,0xf27f69ff,0xffbffeff,0xfff06f58,0xf9ff6bf8,0xcfffffff,0xffffff8f,
        0xfacffffb,0xffffffff,0xffffffff,0xffdfffff,0xffffffff,0xffffffff,0xffff0000
      }
    },
    {
      {
        0x4f27dac,0xd17d79fc,0xcd8cfbcf,0xfdf06d59,0xdbff48d8,0xafeff9bf,0xccffdf7a,
        0xdacdddf7,0xbdacffff,0x9becdfff,0xfadddeff,0xef9cfcdd,0xfff9cfcd,0xffff0000
      },
      {
        0x3f17f9f,0xf28f7fff,0xffffffff,0xfff06f49,0xffff6ffa,0xffffffff,0xffffff9e,
        0xf9fffffd,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000
      }
    },
    {
      {
        0x4f27fbb,0xf17f79fc,0xcf8cfbcf,0xfff07f59,0xfbff48f8,0xafcff8bd,0xbbffff7a,
        0xcabfdff7,0xbfacffef,0x8cdbcfff,0xf9bcdcff,0xff8cfcbf,0xfff9bfde,0xffff0000
      },
      {
        0x3f17fff,0xf2bfffff,0xffffffff,0xfff06f4b,0xffff5fff,0xffffffff,0xffffff8f,
        0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000
      }
    }
  },
  /* Inter extra levels descriptor: */
  {
    {
      0x1334456,0x66777889,0x999aaaab,0xaaacdeff
    },
    {
      0x1244556,0x67888999,0xaabbbbcc,0xbbcdffff
    },
    {
      0x1235566,0x778899ab,0xbbcccdde,0xddffffff
    },
    {
      0x1234577,0x8899aabb,0xcceeffff,0xffffffff
    },
    {
      0x1234567,0x89acdeff,0xffffffff,0xffffffff
    },
    {
      0x1234567,0x99aacbbc,0xffffffff,0xffffffff
    },
    {
      0x1234567,0x999adcef,0xffffffff,0xffffefff
    }
  }
};

