#!/usr/bin/env bash
##
## SPDX-License-Identifier: LGPL-2.1-only
##
## @file runTest.sh
## @author MyungJoo Ham <myungjoo.ham@gmail.com>
## @date Nov 01 2018
## @brief SSAT Test Cases for NNStreamer
##
if [[ "$SSATAPILOADED" != "1" ]]; then
    SILENT=0
    INDEPENDENT=1
    search="ssat-api.sh"
    source $search
    printf "${Blue}Independent Mode${NC}"
fi

# This is compatible with SSAT (https://github.com/myungjoo/SSAT)
testInit $1

PATH_TO_PLUGIN="../../build"

if [ "$SKIPGEN" == "YES" ]; then
    echo "Test Case Generation Skipped"
    sopath=$2
else
    echo "Test Case Generation Started"
    python3 generateTest.py
    sopath=$1
fi

# Test gst availability. (0)
gstTest "videotestsrc num-buffers=1 ! video/x-raw,format=RGB,width=280,height=40,framerate=0/1 ! videoconvert ! video/x-raw, format=RGB ! filesink location=\"testcase.apitest.log\" sync=true" 0 0 0 $PERFORMANCE

gstTest "--gst-plugin-path=${PATH_TO_PLUGIN} multifilesrc location=\"test_%02d.dat\" caps=\"application/octet-stream\" ! tensor_converter input-dim=50:100:1:1 input-type=float32 ! tensor_transform mode=stand option=default ! multifilesink location=\"./result_%02d.log\" sync=true" 1 0 0 $PERFORMANCE

python3 checkResult.py standardization test_00.dat.golden result_00.log 4 4 f f default

testResult $? 1 "Golden test comparison 1" 0 1

gstTest "--gst-plugin-path=${PATH_TO_PLUGIN} multifilesrc location=\"test_%02d.dat\" caps=\"application/octet-stream\" ! tensor_converter input-dim=50:100:1:1 input-type=float32 ! tensor_transform mode=stand option=default,per-channel:true ! multifilesink location=\"./result_%02d.log\" sync=true" 2 0 0 $PERFORMANCE

python3 checkResult.py standardization test_01.dat.golden result_01.log 4 4 f f default

testResult $? 1 "Golden test comparison 2" 0 1

gstTest "--gst-plugin-path=${PATH_TO_PLUGIN} multifilesrc location=\"test_%02d.dat\" caps=\"application/octet-stream\" ! tensor_converter input-dim=50:100:1:1 input-type=float32 ! tensor_transform mode=stand option=dc-average:float32 ! multifilesink location=\"./result_%02d.log\" sync=true" 3 0 0 $PERFORMANCE

python3 checkResult.py standardization test_02.dat.golden result_02.log 4 4 f f default

testResult $? 1 "Golden test comparison 3" 0 1

gstTest "--gst-plugin-path=${PATH_TO_PLUGIN} multifilesrc location=\"test_%02d.dat\" caps=\"application/octet-stream\" ! tensor_converter input-dim=50:100:1:1 input-type=float32 ! tensor_transform mode=stand option=dc-average:float32,per-channel:true ! multifilesink location=\"./result_%02d.log\" sync=true" 4 0 0 $PERFORMANCE

python3 checkResult.py standardization test_03.dat.golden result_03.log 4 4 f f default

testResult $? 1 "Golden test comparison 4" 0 1

rm -f *.log *.bmp *.png *.golden *.raw *.dat

report
