#ifndef FSL_DEVCOMPAT_LINUX_FB_H
#define FSL_DEVCOMPAT_LINUX_FB_H

#if ! WIN32
#error This file should only be used on windows.
#endif
#ifdef __cplusplus
extern "C"
{
#endif
  /****************************************************************************************************************************************************
    * Copyright (c) 2016 Freescale Semiconductor, Inc.
    * All rights reserved.
    *
    * Redistribution and use in source and binary forms, with or without
    * modification, are permitted provided that the following conditions are met:
    *
    *    * Redistributions of source code must retain the above copyright notice,
    *      this list of conditions and the following disclaimer.
    *
    *    * Redistributions in binary form must reproduce the above copyright notice,
    *      this list of conditions and the following disclaimer in the documentation
    *      and/or other materials provided with the distribution.
    *
    *    * Neither the name of the Freescale Semiconductor, Inc. nor the names of
    *      its contributors may be used to endorse or promote products derived from
    *      this software without specific prior written permission.
    *
    * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
    * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
    * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
    * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
    * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
    * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
    *
    ****************************************************************************************************************************************************/

    // On demand recreation of the necessary structs to allow files to compile under windows.
    // No implementation for it is provided, so the compiled executables will not work.
    // But being able to compile is useful too.

    // This file is not 100% compatible with the original it just has what is needed at the current time.
    // Also types might differ so again, dont rely too heavily on it.

#include <stdint.h>

  struct fb_bitfield
  {
    uint32_t offset;
    uint32_t length;
    uint32_t msb_right;
  };


  struct fb_fix_screeninfo
  {
    char          id[16];
    unsigned long smem_start;
    uint32_t      smem_len;
    uint32_t      type;
    uint32_t      type_aux;
    uint32_t      visual;
    uint16_t      xpanstep;
    uint16_t      ypanstep;
    uint16_t      ywrapstep;
    uint32_t      line_length;
    unsigned long mmio_start;
    uint32_t      mmio_len;
    uint32_t      accel;
    uint16_t      capabilities;
    uint16_t      reserved[2];
  };


  struct fb_var_screeninfo
  {
    uint32_t           xres;
    uint32_t           yres;
    uint32_t           xres_virtual;
    uint32_t           yres_virtual;
    uint32_t           xoffset;
    uint32_t           yoffset;
    uint32_t           bits_per_pixel;
    uint32_t           grayscale;
    struct fb_bitfield red;
    struct fb_bitfield green;
    struct fb_bitfield blue;
    struct fb_bitfield transp;
    uint32_t           nonstd;
    uint32_t           activate;
    uint32_t           height;
    uint32_t           width;
    uint32_t           accel_flags;
    uint32_t           pixclock;
    uint32_t           left_margin;
    uint32_t           right_margin;
    uint32_t           upper_margin;
    uint32_t           lower_margin;
    uint32_t           hsync_len;
    uint32_t           vsync_len;
    uint32_t           sync;
    uint32_t           vmode;
    uint32_t           rotate;
    uint32_t           colorspace;
    uint32_t           reserved[4];
  };

#define FBIOGET_FSCREENINFO  0
#define FBIOGET_VSCREENINFO  0
#define FBIO_WAITFORVSYNC    0
#define FBIOPAN_DISPLAY      0
#define FBIOPUT_VSCREENINFO  0

#ifdef __cplusplus
}
#endif
#endif
