#ifndef FSLSCENEFORMAT_SFVERTEXELEMENT_HPP
#define FSLSCENEFORMAT_SFVERTEXELEMENT_HPP
/****************************************************************************************************************************************************
* Copyright (c) 2015 Freescale Semiconductor, Inc.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*    * Redistributions of source code must retain the above copyright notice,
*      this list of conditions and the following disclaimer.
*
*    * Redistributions in binary form must reproduce the above copyright notice,
*      this list of conditions and the following disclaimer in the documentation
*      and/or other materials provided with the distribution.
*
*    * Neither the name of the Freescale Semiconductor, Inc. nor the names of
*      its contributors may be used to endorse or promote products derived from
*      this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************************************************************************************/

#include <FslBase/BasicTypes.hpp>
#include <FslSceneFormat/VertexElementFormat.hpp>
#include <FslSceneFormat/VertexElementUsage.hpp>

namespace Fsl
{
  namespace SceneFormat
  {
    struct SFVertexElement
    {
      SceneFormat::VertexElementFormat Format;
      SceneFormat::VertexElementUsage Usage;
      uint8_t UsageIndex;

      SFVertexElement()
        : Format(SceneFormat::VertexElementFormat::Single)
        , Usage(SceneFormat::VertexElementUsage::Color)
        , UsageIndex(0)
      {
      }

      SFVertexElement(const SceneFormat::VertexElementFormat format, const SceneFormat::VertexElementUsage usage, const uint8_t usageIndex)
        : Format(format)
        , Usage(usage)
        , UsageIndex(usageIndex)
      {
      }

      bool operator==(const SFVertexElement& rhs) const
      {
        return Format == rhs.Format && Usage == rhs.Usage && UsageIndex == rhs.UsageIndex;
      }
      bool operator!=(const SFVertexElement& rhs) const
      {
        return !(*this == rhs);
      }
    };
  }
}

#endif
