/****************************************************************************************************************************************************
* Copyright (c) 2014 Freescale Semiconductor, Inc.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*    * Redistributions of source code must retain the above copyright notice,
*      this list of conditions and the following disclaimer.
*
*    * Redistributions in binary form must reproduce the above copyright notice,
*      this list of conditions and the following disclaimer in the documentation
*      and/or other materials provided with the distribution.
*
*    * Neither the name of the Freescale Semiconductor, Inc. nor the names of
*      its contributors may be used to endorse or promote products derived from
*      this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************************************************************************************/

#include <FslGraphicsGLES3/Exceptions.hpp>
#include <FslGraphicsGLES3/GLCheck.hpp>
#include <FslGraphicsGLES3/GLVertexArray.hpp>

#include <algorithm>

namespace Fsl
{
  namespace GLES3
  {

    GLVertexArray::GLVertexArray()
      : m_handle(GLValues::INVALID_HANDLE)
    {
    }


    GLVertexArray::GLVertexArray(const bool bInitialize)
      : m_handle(GLValues::INVALID_HANDLE)
    {
      Reset(bInitialize);
    }


    GLVertexArray::~GLVertexArray()
    {
      Reset();
    }


    void GLVertexArray::Reset()
    {
      if (m_handle != GLValues::INVALID_HANDLE)
      {
        glDeleteVertexArrays(1, &m_handle);
        m_handle = GLValues::INVALID_HANDLE;
      }
    }


    void GLVertexArray::Reset(const bool bInitialize)
    {
      Reset();
      if (bInitialize)
      {
        GL_CHECK(glGenVertexArrays(1, &m_handle));
      }
    }


    void GLVertexArray::Bind()
    {
      if (!IsValid())
        throw UsageErrorException("Can't bind a invalid vertex array");

      glBindVertexArray(m_handle);
    }


    void GLVertexArray::Unbind()
    {
      glBindVertexArray(0);
    }
  }
}
