#ifndef FSLDEMOHOST_SERVICE_HOST_HOSTINFOSERVICE_HPP
#define FSLDEMOHOST_SERVICE_HOST_HOSTINFOSERVICE_HPP
/****************************************************************************************************************************************************
* Copyright (c) 2016 Freescale Semiconductor, Inc.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*    * Redistributions of source code must retain the above copyright notice,
*      this list of conditions and the following disclaimer.
*
*    * Redistributions in binary form must reproduce the above copyright notice,
*      this list of conditions and the following disclaimer in the documentation
*      and/or other materials provided with the distribution.
*
*    * Neither the name of the Freescale Semiconductor, Inc. nor the names of
*      its contributors may be used to endorse or promote products derived from
*      this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************************************************************************************/

#include <FslDemoHost/Service/ThreadLocal/ThreadLocalService.hpp>
#include <FslDemoApp/Service/Host/IHostInfo.hpp>
#include <FslDemoHost/Service/Host/IHostInfoControl.hpp>

namespace Fsl
{

  class HostInfoService
    : public ThreadLocalService
    , public IHostInfo
    , public IHostInfoControl
  {
    DemoHostFeature m_activeAPI;
    std::shared_ptr<DemoAppHostConfig> m_appHostConfig;
  public:
    HostInfoService(const ServiceProvider& serviceProvider);
    ~HostInfoService();

    // From IHostInfo
    virtual DemoHostFeature GetActiveAPI() const override;
    virtual std::shared_ptr<DemoAppHostConfig> GetAppHostConfig() const override;
    // From IHostInfoControl
    virtual void SetActiveAPI(const DemoHostFeature feature) override;
    virtual void SetAppHostConfig(std::shared_ptr<DemoAppHostConfig> appHostConfig) override;
  private:
  };
}

#endif
