/*
 * Copyright (C) 2015 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <asm/arch/clock.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/mx7-pins.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>
#include <asm/mach-imx/iomux-v3.h>
#include <asm/mach-imx/boot_mode.h>
#include <asm/mach-imx/fbpanel.h>
#include <asm/io.h>
#include <linux/sizes.h>
#include <common.h>
#include <fsl_esdhc_imx.h>
#include <malloc.h>
#include <mmc.h>
#include <power/pmic.h>
#include <power/pfuze3000_pmic.h>
#include "../../freescale/common/pfuze.h"
#include <i2c.h>
#include <asm/mach-imx/mxc_i2c.h>
#include <asm/arch/crm_regs.h>
#include <usb.h>
#include "../common/bd_common.h"
#include "../common/padctrl.h"

DECLARE_GLOBAL_DATA_PTR;

#define UART_PAD_CTRL  (PAD_CTL_DSE_3P3V_49OHM | \
	PAD_CTL_PUS_PU100KOHM | PAD_CTL_HYS)

#define USDHC_PAD_CTRL (PAD_CTL_DSE_3P3V_32OHM | PAD_CTL_SRE_SLOW | \
	PAD_CTL_HYS | PAD_CTL_PUE | PAD_CTL_PUS_PU47KOHM)

#define I2C_PAD_CTRL    (PAD_CTL_DSE_3P3V_32OHM | PAD_CTL_SRE_SLOW | \
	PAD_CTL_HYS | PAD_CTL_PUE | PAD_CTL_PUS_PU100KOHM)

#define QSPI_PAD_CTRL	(PAD_CTL_SRE_FAST | PAD_CTL_PUS_PU100KOHM | PAD_CTL_DSE_3P3V_49OHM)

#define RGB_PAD_CTRL	PAD_CTL_DSE_3P3V_49OHM

#define SETUP_IOMUX_PADS(x)					\
	imx_iomux_v3_setup_multiple_pads(x, ARRAY_SIZE(x))

static const iomux_v3_cfg_t init_pads[] = {
	/* fec */
#ifdef CONFIG_FEC_MXC
	/* PHY - AR8035 */
	IOMUX_PAD_CTRL(GPIO1_IO10__ENET1_MDIO, PAD_CTRL_ENET_MDIO),
	IOMUX_PAD_CTRL(GPIO1_IO11__ENET1_MDC, PAD_CTRL_ENET_MDC),
	IOMUX_PAD_CTRL(ENET1_RGMII_TX_CTL__ENET1_RGMII_TX_CTL, PAD_CTRL_ENET_TX),
	IOMUX_PAD_CTRL(ENET1_RGMII_TD0__ENET1_RGMII_TD0, PAD_CTRL_ENET_TX),
	IOMUX_PAD_CTRL(ENET1_RGMII_TD1__ENET1_RGMII_TD1, PAD_CTRL_ENET_TX),
	IOMUX_PAD_CTRL(ENET1_RGMII_TD2__ENET1_RGMII_TD2, PAD_CTRL_ENET_TX),
	IOMUX_PAD_CTRL(ENET1_RGMII_TD3__ENET1_RGMII_TD3, PAD_CTRL_ENET_TX),
	IOMUX_PAD_CTRL(ENET1_RGMII_TXC__ENET1_RGMII_TXC, PAD_CTRL_ENET_TX),
	IOMUX_PAD_CTRL(GPIO1_IO12__CCM_ENET_REF_CLK1, PAD_CTRL_ENET_TX),
#endif
#define GP_RGMII_PHY_RESET	IMX_GPIO_NR(6, 10)
	IOMUX_PAD_CTRL(SD3_STROBE__GPIO6_IO10, PAD_CTL_PUS_PU100KOHM | PAD_CTL_DSE_1P8V_23OHM),
#define GPIRQ_ENET_PHY		IMX_GPIO_NR(1, 2)
	IOMUX_PAD_CTRL(GPIO1_IO02__GPIO1_IO2, WEAK_PULLUP),

	/* flexcan2 */
	IOMUX_PAD_CTRL(GPIO1_IO14__FLEXCAN2_RX, WEAK_PULLUP),
	IOMUX_PAD_CTRL(GPIO1_IO15__FLEXCAN2_TX, WEAK_PULLUP),
#define GP_CAN_STANDBY		IMX_GPIO_NR(2, 14)
	IOMUX_PAD_CTRL(EPDC_DATA14__GPIO2_IO14, WEAK_PULLUP),

	/* GPIOs - J2 */
	IOMUX_PAD_CTRL(SAI1_TX_DATA__GPIO6_IO15, WEAK_PULLUP),	/* pin 1 */
	IOMUX_PAD_CTRL(SAI1_RX_DATA__GPIO6_IO12, WEAK_PULLUP),	/* pin 3 */
	IOMUX_PAD_CTRL(SD1_WP__GPIO5_IO1, WEAK_PULLUP),		/* pin 5 */
	IOMUX_PAD_CTRL(SD1_RESET_B__GPIO5_IO2, WEAK_PULLUP),	/* pin 7 */
	IOMUX_PAD_CTRL(EPDC_DATA07__GPIO2_IO7, WEAK_PULLUP),	/* pin 15 */
	IOMUX_PAD_CTRL(EPDC_DATA08__GPIO2_IO8, WEAK_PULLUP),	/* pin 17 */
	IOMUX_PAD_CTRL(EPDC_DATA09__GPIO2_IO9, WEAK_PULLUP),	/* pin 19 */
	IOMUX_PAD_CTRL(EPDC_DATA10__GPIO2_IO10, WEAK_PULLUP),	/* pin 21 */
	IOMUX_PAD_CTRL(EPDC_DATA11__GPIO2_IO11, WEAK_PULLUP),	/* pin 23 */
	IOMUX_PAD_CTRL(EPDC_DATA12__GPIO2_IO12, WEAK_PULLUP),	/* pin 25 */
	IOMUX_PAD_CTRL(EPDC_DATA13__GPIO2_IO13, WEAK_PULLUP),	/* pin 27 */
	IOMUX_PAD_CTRL(EPDC_GDCLK__GPIO2_IO24, WEAK_PULLUP),	/* pin 33 */
	IOMUX_PAD_CTRL(EPDC_GDOE__GPIO2_IO25, WEAK_PULLUP),	/* pin 35 */
	IOMUX_PAD_CTRL(EPDC_GDRL__GPIO2_IO26, WEAK_PULLUP),	/* pin 37 */
	IOMUX_PAD_CTRL(EPDC_SDCE0__GPIO2_IO20, WEAK_PULLUP),	/* pin 39 */
	IOMUX_PAD_CTRL(EPDC_SDCE1__GPIO2_IO21, WEAK_PULLUP),	/* pin 41 */
	IOMUX_PAD_CTRL(EPDC_SDCE2__GPIO2_IO22, WEAK_PULLUP),	/* pin 43 */
	IOMUX_PAD_CTRL(EPDC_SDCE3__GPIO2_IO23, WEAK_PULLUP),	/* pin 45 */
	IOMUX_PAD_CTRL(EPDC_GDSP__GPIO2_IO27, WEAK_PULLUP),	/* pin 47 */
	IOMUX_PAD_CTRL(EPDC_SDCLK__GPIO2_IO16, WEAK_PULLUP),	/* pin 51 */
	IOMUX_PAD_CTRL(EPDC_SDLE__GPIO2_IO17, WEAK_PULLUP),	/* pin 53 */
	IOMUX_PAD_CTRL(EPDC_SDOE__GPIO2_IO18, WEAK_PULLUP),	/* pin 55 */
	IOMUX_PAD_CTRL(EPDC_PWR_COM__GPIO2_IO30, WEAK_PULLUP),	/* pin 57 */
	IOMUX_PAD_CTRL(EPDC_PWR_STAT__GPIO2_IO31, WEAK_PULLUP),	/* pin 59 */

	IOMUX_PAD_CTRL(EPDC_BDR0__GPIO2_IO28, WEAK_PULLUP),	/* pin 2 */
	IOMUX_PAD_CTRL(EPDC_BDR1__GPIO2_IO29, WEAK_PULLUP),	/* pin 4 */
	IOMUX_PAD_CTRL(EPDC_SDSHR__GPIO2_IO19, WEAK_PULLUP),	/* pin 6 */
	IOMUX_PAD_CTRL(SD2_RESET_B__GPIO5_IO11, WEAK_PULLUP),	/* pin 10 */
	IOMUX_PAD_CTRL(SAI1_TX_SYNC__GPIO6_IO14, WEAK_PULLUP),	/* pin 26 */
	IOMUX_PAD_CTRL(SAI1_TX_BCLK__GPIO6_IO13, WEAK_PULLUP),	/* pin 28 */
	IOMUX_PAD_CTRL(SD2_CD_B__GPIO5_IO9, WEAK_PULLUP),	/* pin 30 */
	IOMUX_PAD_CTRL(SAI2_RX_DATA__GPIO6_IO21, WEAK_PULLUP),	/* pin 34 */
	IOMUX_PAD_CTRL(SAI2_TX_DATA__GPIO6_IO22, WEAK_PULLUP),	/* pin 38 */
	IOMUX_PAD_CTRL(SAI2_TX_BCLK__GPIO6_IO20, WEAK_PULLUP),	/* pin 40 */
	IOMUX_PAD_CTRL(SAI2_TX_SYNC__GPIO6_IO19, WEAK_PULLUP),	/* pin 42 */

	/* i2c1 - pmic */
#define GP_PMIC_INT_B	IMX_GPIO_NR(4, 22)
	IOMUX_PAD_CTRL(ECSPI2_MISO__GPIO4_IO22, WEAK_PULLUP),

	/* i2c2 - rv4162 */
#define GP_RTC			IMX_GPIO_NR(2, 15)
	IOMUX_PAD_CTRL(EPDC_DATA15__GPIO2_IO15, WEAK_PULLUP),

	/* i2c2a */
#define GP_I2C2A_EN		IMX_GPIO_NR(1, 7)
	IOMUX_PAD_CTRL(GPIO1_IO07__GPIO1_IO7, WEAK_PULLUP),
#define GP_MIPI			IMX_GPIO_NR(1, 6)
	IOMUX_PAD_CTRL(GPIO1_IO06__GPIO1_IO6, WEAK_PULLUP),
#define GP_MIPI_BACKLIGHT	 IMX_GPIO_NR(1, 13)
	IOMUX_PAD_CTRL(GPIO1_IO13__GPIO1_IO13, WEAK_PULLUP),

	/* i2c3 - J9, J2(gpio connector), J20(rgb connector) */
#define GP_I2C_TOUCH	IMX_GPIO_NR(5, 10)
//	IOMUX_PAD_CTRL(SD2_WP__GPIO5_IO10, WEAK_PULLUP),
	/* i2c4 - PCIe, WM8960*/

	/* PCIe */
#define GP_PCIE_DISABLE		IMX_GPIO_NR(6, 17)
	IOMUX_PAD_CTRL(SAI1_RX_BCLK__GPIO6_IO17, WEAK_PULLUP),
#define GP_PCIE_RESET		IMX_GPIO_NR(6, 16)
	IOMUX_PAD_CTRL(SAI1_RX_SYNC__GPIO6_IO16, WEAK_PULLUP),

	/* PWM1 - rgb */
#define GP_BACKLIGHT_RGB	IMX_GPIO_NR(1, 1)
	IOMUX_PAD_CTRL(GPIO1_IO01__GPIO1_IO1, WEAK_PULLDN_OUTPUT),
//	IOMUX_PAD_CTRL(GPIO1_IO01__PWM1_OUT, WEAK_PULLDN_OUTPUT),

	/* PWM2 */
	IOMUX_PAD_CTRL(GPIO1_IO09__PWM2_OUT, WEAK_PULLUP),

	/* QSPIA */
	IOMUX_PAD_CTRL(EPDC_DATA00__QSPI_A_DATA0, QSPI_PAD_CTRL),
	IOMUX_PAD_CTRL(EPDC_DATA01__QSPI_A_DATA1, QSPI_PAD_CTRL),
#if 1
	IOMUX_PAD_CTRL(EPDC_DATA02__QSPI_A_DATA2, QSPI_PAD_CTRL),
	IOMUX_PAD_CTRL(EPDC_DATA03__QSPI_A_DATA3, QSPI_PAD_CTRL),
#else
#define GP_SPI_nWP		IMX_GPIO_NR(2, 2)
	IOMUX_PAD_CTRL(EPDC_DATA02__GPIO2_IO2, WEAK_PULLUP),
#define GP_SPI_nHOLD		IMX_GPIO_NR(2, 3)
	IOMUX_PAD_CTRL(EPDC_DATA03__GPIO2_IO3, WEAK_PULLUP),
#endif
	IOMUX_PAD_CTRL(EPDC_DATA05__QSPI_A_SCLK, QSPI_PAD_CTRL),
	IOMUX_PAD_CTRL(EPDC_DATA06__QSPI_A_SS0_B, QSPI_PAD_CTRL),

	/* SAI1 - wm8960 on i2c4 */
	IOMUX_PAD_CTRL(ENET1_CRS__SAI1_TX_SYNC, WEAK_PULLUP),
	IOMUX_PAD_CTRL(ENET1_RX_CLK__SAI1_TX_BCLK, WEAK_PULLUP),
	IOMUX_PAD_CTRL(ENET1_TX_CLK__SAI1_RX_DATA0, WEAK_PULLUP),
	IOMUX_PAD_CTRL(ENET1_COL__SAI1_TX_DATA0, WEAK_PULLUP),
	IOMUX_PAD_CTRL(SAI1_MCLK__SAI1_MCLK, WEAK_PULLUP),

	/* uart1 */
	IOMUX_PAD_CTRL(UART1_TX_DATA__UART1_DCE_TX, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(UART1_RX_DATA__UART1_DCE_RX, UART_PAD_CTRL),

	/* uart2 */
	IOMUX_PAD_CTRL(UART2_TX_DATA__UART2_DCE_TX, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(UART2_RX_DATA__UART2_DCE_RX, UART_PAD_CTRL),

	/* uart3 */
	IOMUX_PAD_CTRL(UART3_TX_DATA__UART3_DCE_TX, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(UART3_RX_DATA__UART3_DCE_RX, UART_PAD_CTRL),
#define GP_UART3_RS485_TX	IMX_GPIO_NR(2, 4)
	IOMUX_PAD_CTRL(EPDC_DATA04__GPIO2_IO4, WEAK_PULLUP),

	/* uart6 - bluetooth */
	IOMUX_PAD_CTRL(ECSPI1_MOSI__UART6_DCE_TX, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(ECSPI1_SCLK__UART6_DCE_RX, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(ECSPI1_MISO__UART6_DCE_RTS, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(ECSPI1_SS0__UART6_DCE_CTS, UART_PAD_CTRL),

#ifdef CONFIG_USB_EHCI_MX7
	/* usbotg1 */
	IOMUX_PAD_CTRL(GPIO1_IO04__USB_OTG1_OC, WEAK_PULLUP),
	IOMUX_PAD_CTRL(GPIO1_IO05__USB_OTG1_PWR, WEAK_PULLUP),
//	IOMUX_PAD_CTRL(SD2_WP__USB_OTG1_ID, WEAK_PULLUP),
#define GP_OTG1_ID	IMX_GPIO_NR(5, 10)
	IOMUX_PAD_CTRL(SD2_WP__GPIO5_IO10, WEAK_PULLUP),

	/* usbotg2 */
	IOMUX_PAD_CTRL(UART3_RTS_B__USB_OTG2_OC, WEAK_PULLUP),
	IOMUX_PAD_CTRL(UART3_CTS_B__USB_OTG2_PWR, WEAK_PULLUP),
#endif

	/* usdhc1 */
	IOMUX_PAD_CTRL(SD1_CLK__SD1_CLK, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD1_CMD__SD1_CMD, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD1_DATA0__SD1_DATA0, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD1_DATA1__SD1_DATA1, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD1_DATA2__SD1_DATA2, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD1_DATA3__SD1_DATA3, USDHC_PAD_CTRL),
#define GP_USDHC1_CD		IMX_GPIO_NR(5, 0)
	IOMUX_PAD_CTRL(SD1_CD_B__GPIO5_IO0, USDHC_PAD_CTRL),
#define GP_PMIC_SD1_VSEL	IMX_GPIO_NR(1, 8)
	IOMUX_PAD_CTRL(GPIO1_IO08__SD1_VSELECT, WEAK_PULLUP),

	/* usdhc2 - murata wifi */
	IOMUX_PAD_CTRL(SD2_CLK__SD2_CLK, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_CMD__SD2_CMD, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DATA0__SD2_DATA0, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DATA1__SD2_DATA1, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DATA2__SD2_DATA2, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DATA3__SD2_DATA3, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(GPIO1_IO03__CCM_CLKO2, WEAK_PULLUP),	/* Slow clock */
#define GP_BT_REG_ON	IMX_GPIO_NR(4, 23)
	IOMUX_PAD_CTRL(ECSPI2_SS0__GPIO4_IO23, WEAK_PULLUP),
#define GP_WL_HOST_WAKE	IMX_GPIO_NR(4, 20)
	IOMUX_PAD_CTRL(ECSPI2_SCLK__GPIO4_IO20, WEAK_PULLUP),
#define GP_WL_REG_ON	IMX_GPIO_NR(4, 21)
	IOMUX_PAD_CTRL(ECSPI2_MOSI__GPIO4_IO21, WEAK_PULLUP),

	/* usdhc3 - emmc */
	IOMUX_PAD_CTRL(SD3_CLK__SD3_CLK, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_CMD__SD3_CMD, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA0__SD3_DATA0, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA1__SD3_DATA1, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA2__SD3_DATA2, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA3__SD3_DATA3, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA4__SD3_DATA4, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA5__SD3_DATA5, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA6__SD3_DATA6, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DATA7__SD3_DATA7, USDHC_PAD_CTRL),
#define GP_EMMC_RESET	IMX_GPIO_NR(6, 11)
	IOMUX_PAD_CTRL(SD3_RESET_B__GPIO6_IO11, USDHC_PAD_CTRL),

	/* watchdog */
	IOMUX_PAD_CTRL(GPIO1_IO00__WDOG1_WDOG_B, WEAK_PULLUP_OUTPUT),
};

static const iomux_v3_cfg_t rgb_pads[] = {
	IOMUX_PAD_CTRL(LCD_CLK__LCD_CLK, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_ENABLE__LCD_ENABLE, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_HSYNC__LCD_HSYNC, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_VSYNC__LCD_VSYNC, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_RESET__LCD_RESET, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA00__LCD_DATA0, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA01__LCD_DATA1, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA02__LCD_DATA2, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA03__LCD_DATA3, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA04__LCD_DATA4, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA05__LCD_DATA5, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA06__LCD_DATA6, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA07__LCD_DATA7, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA08__LCD_DATA8, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA09__LCD_DATA9, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA10__LCD_DATA10, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA11__LCD_DATA11, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA12__LCD_DATA12, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA13__LCD_DATA13, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA14__LCD_DATA14, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA15__LCD_DATA15, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA16__LCD_DATA16, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA17__LCD_DATA17, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA18__LCD_DATA18, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA19__LCD_DATA19, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA20__LCD_DATA20, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA21__LCD_DATA21, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA22__LCD_DATA22, RGB_PAD_CTRL),
	IOMUX_PAD_CTRL(LCD_DATA23__LCD_DATA23, RGB_PAD_CTRL),
};

static const iomux_v3_cfg_t rgb_gpio_pads[] = {
	IOMUX_PAD_CTRL(LCD_CLK__GPIO3_IO0, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_ENABLE__GPIO3_IO1, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_HSYNC__GPIO3_IO2, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_VSYNC__GPIO3_IO3, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_RESET__GPIO3_IO4, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA00__GPIO3_IO5, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA01__GPIO3_IO6, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA02__GPIO3_IO7, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA03__GPIO3_IO8, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA04__GPIO3_IO9, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA05__GPIO3_IO10, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA06__GPIO3_IO11, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA07__GPIO3_IO12, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA08__GPIO3_IO13, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA09__GPIO3_IO14, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA10__GPIO3_IO15, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA11__GPIO3_IO16, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA12__GPIO3_IO17, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA13__GPIO3_IO18, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA14__GPIO3_IO19, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA15__GPIO3_IO20, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA16__GPIO3_IO21, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA17__GPIO3_IO22, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA18__GPIO3_IO23, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA19__GPIO3_IO24, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA20__GPIO3_IO25, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA21__GPIO3_IO26, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA22__GPIO3_IO27, WEAK_PULLUP),
	IOMUX_PAD_CTRL(LCD_DATA23__GPIO3_IO28, WEAK_PULLUP),
};

#ifdef CONFIG_SYS_I2C_MXC
/* I2C1 for PMIC */
static const struct i2c_pads_info i2c_pads[] = {
	I2C_PADS_INFO_ENTRY(I2C1, I2C1_SCL, 4, 8, I2C1_SDA, 4, 9, I2C_PAD_CTRL),
	I2C_PADS_INFO_ENTRY(I2C2, I2C2_SCL, 4, 10, I2C2_SDA, 4, 11, I2C_PAD_CTRL),
	I2C_PADS_INFO_ENTRY(I2C3, I2C3_SCL, 4, 12, I2C3_SDA, 4, 13, I2C_PAD_CTRL),
	I2C_PADS_INFO_ENTRY(I2C4, I2C4_SCL, 4, 14, I2C4_SDA, 4, 15, I2C_PAD_CTRL),
};
#define I2C_BUS_CNT	4
#else
#define i2c_pads	NULL
#define I2C_BUS_CNT	0
#endif

#ifdef CONFIG_FSL_ESDHC_IMX
struct fsl_esdhc_cfg board_usdhc_cfg[] = {
	{.esdhc_base = USDHC1_BASE_ADDR, .bus_width = 4,
			.gp_cd = GP_USDHC1_CD},
	{.esdhc_base = USDHC3_BASE_ADDR, .bus_width = 8,
			.gp_reset = GP_EMMC_RESET},
};
#endif

#ifdef CONFIG_CMD_FBPANEL
void board_enable_lcd(const struct display_info_t *di, int enable)
{
	if (enable)
		SETUP_IOMUX_PADS(rgb_pads);
	else
		SETUP_IOMUX_PADS(rgb_gpio_pads);
	gpio_direction_output(GP_BACKLIGHT_RGB, enable);
}

static const struct display_info_t displays[] = {
	/* fusion7 specific touchscreen */
	VD_FUSION7(LCD, fbp_detect_i2c, 2, 0x10, FBTS_FUSION7),

	/* tsc2004 */
	VD_CLAA_WVGA(LCD, fbp_detect_i2c, 2, 0x48, FBTS_TSC2004),
	VD_SHARP_WVGA(LCD, NULL, 2, 0x48, FBTS_TSC2004),
	VD_DC050WX(LCD, NULL, 2, 0x48, FBTS_TSC2004),
	VD_QVGA(LCD, NULL, 2, 0x48, FBTS_TSC2004),
	VD_AT035GT_07ET3(LCD, NULL, 2, 0x48, FBTS_TSC2004),

	VD_LSA40AT9001(LCD, NULL, 0, 0x00),
};
#define display_cnt	ARRAY_SIZE(displays)
#else
#define displays	NULL
#define display_cnt	0
#endif

static const unsigned short gpios_out_low[] = {
	GP_RGMII_PHY_RESET,
	GP_I2C2A_EN,
	GP_MIPI_BACKLIGHT,
	GP_PCIE_DISABLE,
	GP_PCIE_RESET,
	GP_BACKLIGHT_RGB,
	GP_UART3_RS485_TX,
	GP_PMIC_SD1_VSEL,
	GP_BT_REG_ON,
	GP_WL_REG_ON,
	GP_EMMC_RESET,
};

static const unsigned short gpios_out_high[] = {
	GP_CAN_STANDBY,
#ifdef GP_SPI_nWP
	GP_SPI_nWP,
#endif
#ifdef GP_SPI_nHOLD
	GP_SPI_nHOLD,
#endif
};

static const unsigned short gpios_in[] = {
	GPIRQ_ENET_PHY,
	GP_PMIC_INT_B,
	GP_RTC,
	GP_MIPI,
	GP_I2C_TOUCH,
	GP_USDHC1_CD,
	GP_WL_HOST_WAKE,
	GP_OTG1_ID,
};

int board_early_init_f(void)
{
	set_gpios_in(gpios_in, ARRAY_SIZE(gpios_in));
	set_gpios(gpios_out_high, ARRAY_SIZE(gpios_out_high), 1);
	set_gpios(gpios_out_low, ARRAY_SIZE(gpios_out_low), 0);
	SETUP_IOMUX_PADS(init_pads);
	SETUP_IOMUX_PADS(rgb_gpio_pads);
	return 0;
}

int board_init(void)
{
	common_board_init(i2c_pads, I2C_BUS_CNT, 0,
			displays, display_cnt, 0);
	return 0;
}

#ifdef CONFIG_CMD_BMODE
const struct boot_mode board_boot_modes[] = {
	/* 4 bit bus width */
	{"sd1", MAKE_CFGVAL(0x10, 0x10, 0x00, 0x00)},
	{"emmc", MAKE_CFGVAL(0x10, 0x2a, 0x00, 0x00)},
	{NULL,   0},
};
#endif

#ifdef CONFIG_POWER
#define I2C_PMIC	0
int power_init_board(void)
{
	struct pmic *p;
	int ret;
	unsigned int reg, rev_id;

	ret = power_pfuze3000_init(I2C_PMIC);
	if (ret)
		return ret;

	p = pmic_get("PFUZE3000");
	ret = pmic_probe(p);
	if (ret)
		return ret;

	pmic_reg_read(p, PFUZE3000_DEVICEID, &reg);
	pmic_reg_read(p, PFUZE3000_REVID, &rev_id);
	printf("PMIC: PFUZE3000 DEV_ID=0x%x REV_ID=0x%x\n", reg, rev_id);

	/* disable Low Power Mode during standby mode */
	pmic_reg_read(p, PFUZE3000_LDOGCTL, &reg);
	reg |= 0x1;
	pmic_reg_write(p, PFUZE3000_LDOGCTL, reg);

	return 0;
}
#endif

u32 get_board_rev(void)
{
	return get_cpu_rev();
}

const struct button_key board_buttons[] = {
	{NULL, 0, 0, 0},
};

#ifdef CONFIG_USB_EHCI_MX7
int board_usb_phy_mode(int port)
{
	if (port)
		return USB_INIT_HOST;
	return gpio_get_value(GP_OTG1_ID) ? USB_INIT_DEVICE : USB_INIT_HOST;
}

int board_ehci_hcd_init(int port)
{
	switch (port) {
	case 0:
		break;
	case 1:
		break;
	default:
		printf("MXC USB port %d not yet supported\n", port);
		return -EINVAL;
	}
	return 0;
}
#endif
