/*
 * Copyright (C) 2010-2013 Freescale Semiconductor, Inc.
 * Copyright (C) 2014, Boundary Devices <info@boundarydevices.com>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <asm/io.h>
#include <asm/arch/clock.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/iomux.h>
#include <asm/arch/sys_proto.h>
#include <malloc.h>
#include <asm/arch/mx6-pins.h>
#include <linux/errno.h>
#include <asm/gpio.h>
#include <asm/mach-imx/boot_mode.h>
#include <asm/mach-imx/fbpanel.h>
#include <asm/mach-imx/iomux-v3.h>
#include <asm/mach-imx/mxc_i2c.h>
#include <asm/mach-imx/spi.h>
#include <mmc.h>
#include <fsl_esdhc_imx.h>
#include <linux/fb.h>
#include <ipu_pixfmt.h>
#include <asm/arch/crm_regs.h>
#include <asm/arch/mxc_hdmi.h>
#include <i2c.h>
#include <input.h>
#include <splash.h>
#include <usb/ehci-ci.h>
#include "../common/bd_common.h"
#include "../common/padctrl.h"

DECLARE_GLOBAL_DATA_PTR;

#define AUD_PAD_CTRL  (PAD_CTL_PUS_100K_UP |			\
	PAD_CTL_SPEED_LOW | PAD_CTL_DSE_40ohm |			\
	PAD_CTL_HYS | PAD_CTL_SRE_FAST)

#define BUTTON_PAD_CTRL (PAD_CTL_PUS_100K_UP |			\
	PAD_CTL_SPEED_MED | PAD_CTL_DSE_40ohm | PAD_CTL_HYS)

#define CEC_PAD_CTRL	(PAD_CTL_HYS | PAD_CTL_PUS_22K_UP | PAD_CTL_ODE | \
	PAD_CTL_SPEED_MED | PAD_CTL_DSE_40ohm | PAD_CTL_SRE_FAST)

#define I2C_PAD_CTRL	(PAD_CTL_PUS_100K_UP |			\
	PAD_CTL_SPEED_MED | PAD_CTL_DSE_40ohm | PAD_CTL_HYS |	\
	PAD_CTL_ODE | PAD_CTL_SRE_FAST)

#define SPI_PAD_CTRL (PAD_CTL_HYS | PAD_CTL_SPEED_MED |		\
	PAD_CTL_DSE_40ohm     | PAD_CTL_SRE_FAST)

#define UART_PAD_CTRL  (PAD_CTL_PUS_100K_UP |			\
	PAD_CTL_SPEED_MED | PAD_CTL_DSE_40ohm |			\
	PAD_CTL_HYS | PAD_CTL_SRE_FAST)

#define USDHC_CLK_PAD_CTRL (PAD_CTL_SPEED_LOW | PAD_CTL_DSE_40ohm | \
	PAD_CTL_SRE_FAST  | PAD_CTL_HYS)

#define USDHC_PAD_CTRL (USDHC_CLK_PAD_CTRL | PAD_CTL_PUS_47K_UP)

/*
 *
 */
static const iomux_v3_cfg_t init_pads[] = {
//	IOMUX_PAD_CTRL(GPIO_8__XTALOSC_REF_CLK_32K, OUTPUT_40OHM),	/* TiWi, WM5102, GTM609W */

	/* Accelerometer (MPU-9250) (i2c3) */
#ifdef CONFIG_NEW_REV
#define GPIRQ_ACCEL		IMX_GPIO_NR(3, 28)
	IOMUX_PAD_CTRL(EIM_D28__GPIO3_IO28, WEAK_PULLUP),
#else
#define GPIRQ_ACCEL		IMX_GPIO_NR(5, 30)
	IOMUX_PAD_CTRL(CSI0_DAT12__GPIO5_IO30, WEAK_PULLUP),
#endif

	/* AUDMUX  - GSM */
	IOMUX_PAD_CTRL(CSI0_DAT7__AUD3_RXD, AUD_PAD_CTRL),
	IOMUX_PAD_CTRL(CSI0_DAT4__AUD3_TXC, AUD_PAD_CTRL),
	IOMUX_PAD_CTRL(CSI0_DAT5__AUD3_TXD, AUD_PAD_CTRL),
	IOMUX_PAD_CTRL(CSI0_DAT6__AUD3_TXFS, AUD_PAD_CTRL),

	/* AUDMUX  - wm5102 */
	IOMUX_PAD_CTRL(DI0_PIN4__AUD6_RXD, AUD_PAD_CTRL),
	IOMUX_PAD_CTRL(DI0_PIN15__AUD6_TXC, AUD_PAD_CTRL),
	IOMUX_PAD_CTRL(DI0_PIN2__AUD6_TXD, AUD_PAD_CTRL),
	IOMUX_PAD_CTRL(DI0_PIN3__AUD6_TXFS, AUD_PAD_CTRL),

	/* Camera (mipi) - LM3555 strobe/flash */
#ifdef CONFIG_NEW_REV
#define GP_CAM_STROBE		IMX_GPIO_NR(3, 29)
	IOMUX_PAD_CTRL(EIM_D29__GPIO3_IO29, WEAK_PULLDN_OUTPUT),
#define GP_CAM_TORCH		IMX_GPIO_NR(3, 30)
	IOMUX_PAD_CTRL(EIM_D30__GPIO3_IO30, WEAK_PULLDN_OUTPUT),
#else
#define GP_CAM_STROBE		IMX_GPIO_NR(3, 18)
	IOMUX_PAD_CTRL(EIM_D18__GPIO3_IO18, WEAK_PULLDN_OUTPUT),
#define GP_CAM_TORCH		IMX_GPIO_NR(3, 19)
	IOMUX_PAD_CTRL(EIM_D19__GPIO3_IO19, WEAK_PULLDN_OUTPUT),
#endif

#define GP_CAM_MIPI_RESET	IMX_GPIO_NR(1, 30)
	IOMUX_PAD_CTRL(ENET_TXD0__GPIO1_IO30, WEAK_PULLDN_OUTPUT),
#define GP_CAM_MIPI_EN		IMX_GPIO_NR(1, 29)
	IOMUX_PAD_CTRL(ENET_TXD1__GPIO1_IO29, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(GPIO_3__CCM_CLKO2, OUTPUT_40OHM),	/* XCLK */

	/* Display (Braille) */
#define GP_DISP_STROBE		IMX_GPIO_NR(5, 8)
	IOMUX_PAD_CTRL(DISP0_DAT14__GPIO5_IO08, WEAK_PULLDN_OUTPUT),
#define GP_DISP_HV_EN		IMX_GPIO_NR(2, 24)
	IOMUX_PAD_CTRL(EIM_CS1__GPIO2_IO24, WEAK_PULLDN_OUTPUT),

#define GP_DISP_KEY_1		IMX_GPIO_NR(3, 6)
	IOMUX_PAD_CTRL(EIM_DA6__GPIO3_IO06, WEAK_PULLDN),
#define GP_DISP_KEY_2		IMX_GPIO_NR(3, 7)
	IOMUX_PAD_CTRL(EIM_DA7__GPIO3_IO07, WEAK_PULLDN),
#define GP_DISP_KEY_3		IMX_GPIO_NR(3, 8)
	IOMUX_PAD_CTRL(EIM_DA8__GPIO3_IO08, WEAK_PULLDN),
#define GP_DISP_KEY_4		IMX_GPIO_NR(3, 9)
	IOMUX_PAD_CTRL(EIM_DA9__GPIO3_IO09, WEAK_PULLDN),
#define GP_DISP_KEY_5		IMX_GPIO_NR(3, 10)
	IOMUX_PAD_CTRL(EIM_DA10__GPIO3_IO10, WEAK_PULLDN),
#define GP_DISP_KEY_6		IMX_GPIO_NR(3, 11)
	IOMUX_PAD_CTRL(EIM_DA11__GPIO3_IO11, WEAK_PULLDN),
#define GP_DISP_KEY_SHIFT	IMX_GPIO_NR(3, 12)
	IOMUX_PAD_CTRL(EIM_DA12__GPIO3_IO12, WEAK_PULLDN),
#define GP_DISP_KEY_SPACE	IMX_GPIO_NR(3, 13)
	IOMUX_PAD_CTRL(EIM_DA13__GPIO3_IO13, WEAK_PULLDN),
#define GP_DISP_KEY_CTRL	IMX_GPIO_NR(3, 14)
	IOMUX_PAD_CTRL(EIM_DA14__GPIO3_IO14, WEAK_PULLDN),
#define GP_DISP_LED_RED		IMX_GPIO_NR(5, 9)
	IOMUX_PAD_CTRL(DISP0_DAT15__GPIO5_IO09, WEAK_PULLDN_OUTPUT),
#ifdef CONFIG_NEW_REV
#define GP_DISP_LED_GREEN	IMX_GPIO_NR(4, 25)
	IOMUX_PAD_CTRL(DISP0_DAT4__GPIO4_IO25, WEAK_PULLDN_OUTPUT),
#else
#define GP_DISP_LED_GREEN	IMX_GPIO_NR(5, 10)
	IOMUX_PAD_CTRL(DISP0_DAT16__GPIO5_IO10, WEAK_PULLDN_OUTPUT),
#endif

	/* Keypad */
	IOMUX_PAD_CTRL(KEY_COL0__KEY_COL0, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(KEY_COL1__KEY_COL1, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(KEY_COL2__KEY_COL2, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(KEY_COL3__KEY_COL3, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(KEY_COL4__KEY_COL4, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(GPIO_19__KEY_COL5, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(KEY_ROW0__KEY_ROW0, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(KEY_ROW1__KEY_ROW1, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(KEY_ROW2__KEY_ROW2, WEAK_PULLDN_OUTPUT),

	/* ECSPI1 pads (serial nor eeprom) */
#ifdef CONFIG_NEW_REV
	IOMUX_PAD_CTRL(EIM_D17__ECSPI1_MISO, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(EIM_D18__ECSPI1_MOSI, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(EIM_D16__ECSPI1_SCLK, SPI_PAD_CTRL),
#define GP_ECSPI1_NOR_CS	IMX_GPIO_NR(3, 19)
	IOMUX_PAD_CTRL(EIM_D19__GPIO3_IO19, WEAK_PULLUP),
#else
	IOMUX_PAD_CTRL(DISP0_DAT22__ECSPI1_MISO, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(DISP0_DAT21__ECSPI1_MOSI, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(DISP0_DAT20__ECSPI1_SCLK, SPI_PAD_CTRL),
#define GP_ECSPI1_NOR_CS	IMX_GPIO_NR(5, 17)
	IOMUX_PAD_CTRL(DISP0_DAT23__GPIO5_IO17, WEAK_PULLUP),
#endif

	/* ECSPI2 pads (Braille Display) */
#ifdef CONFIG_NEW_REV
	IOMUX_PAD_CTRL(DISP0_DAT16__ECSPI2_MOSI, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(DISP0_DAT17__ECSPI2_MISO, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(DISP0_DAT19__ECSPI2_SCLK, SPI_PAD_CTRL),
#define GP_ECSPI2_CS0		IMX_GPIO_NR(5, 12)
	IOMUX_PAD_CTRL(DISP0_DAT18__GPIO5_IO12, WEAK_PULLUP),
#else
#define GP_BRL_MISO	IMX_GPIO_NR(5, 18)
	IOMUX_PAD_CTRL(CSI0_PIXCLK__GPIO5_IO18, WEAK_PULLUP),
#define GP_BRL_MOSI		IMX_GPIO_NR(5, 29)
	IOMUX_PAD_CTRL(CSI0_DAT11__GPIO5_IO29, WEAK_PULLDN_OUTPUT),
#define GP_BRL_CLK		IMX_GPIO_NR(4, 16)
	IOMUX_PAD_CTRL(DI0_DISP_CLK__GPIO4_IO16, WEAK_PULLDN_OUTPUT),
#define GP_BRL_DATA_BUF_EN	IMX_GPIO_NR(5, 28)
	IOMUX_PAD_CTRL(CSI0_DAT10__GPIO5_IO28, WEAK_PULLDN_OUTPUT),
#endif

	/* ECSPI3 pads GSM (GTM609W) */
	IOMUX_PAD_CTRL(DISP0_DAT2__ECSPI3_MISO, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(DISP0_DAT1__ECSPI3_MOSI, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(DISP0_DAT0__ECSPI3_SCLK, SPI_PAD_CTRL),
#define GP_ECSPI3_GSM		IMX_GPIO_NR(4, 24)
	IOMUX_PAD_CTRL(DISP0_DAT3__GPIO4_IO24, WEAK_PULLUP),

	/* ECSPI5 pads sound(wm5102) */
	IOMUX_PAD_CTRL(SD1_DAT0__ECSPI5_MISO, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(SD1_CMD__ECSPI5_MOSI, SPI_PAD_CTRL),
	IOMUX_PAD_CTRL(SD1_CLK__ECSPI5_SCLK, SPI_PAD_CTRL),
#define GP_ECSPI5_WM5102	IMX_GPIO_NR(1, 17)
	IOMUX_PAD_CTRL(SD1_DAT1__GPIO1_IO17, WEAK_PULLUP),

	/* GSM sim (GTM609W) */
#define GP_GSM_SIM_RESET	IMX_GPIO_NR(5, 19)
	IOMUX_PAD_CTRL(CSI0_MCLK__GPIO5_IO19, WEAK_PULLUP),
#define GP_GSM_HOST_WAKE_WWAN	IMX_GPIO_NR(5, 20)
	IOMUX_PAD_CTRL(CSI0_DATA_EN__GPIO5_IO20, WEAK_PULLUP),
#define GP_GSM_PWR_EN		IMX_GPIO_NR(6, 2)
	IOMUX_PAD_CTRL(CSI0_DAT16__GPIO6_IO02, WEAK_PULLUP),
#define GP_GSM_RESET		IMX_GPIO_NR(6, 3)
	IOMUX_PAD_CTRL(CSI0_DAT17__GPIO6_IO03, WEAK_PULLUP),
#define GP_GSM_ON_OFF		IMX_GPIO_NR(6, 4)
	IOMUX_PAD_CTRL(CSI0_DAT18__GPIO6_IO04, WEAK_PULLUP),
#define GP_GSM_HOST_WAKE	IMX_GPIO_NR(6, 5)
	IOMUX_PAD_CTRL(CSI0_DAT19__GPIO6_IO05, WEAK_PULLUP),
//	IOMUX_PAD_CTRL(GPIO_8__XTALOSC_REF_CLK_32K, OUTPUT_40OHM),	/* slow clock */

	/* GPS */
#define GP_GPS_HEARTBEAT	IMX_GPIO_NR(4, 27)
	IOMUX_PAD_CTRL(DISP0_DAT6__GPIO4_IO27, WEAK_PULLDN_OUTPUT),
#define GPIRQ_GPS		IMX_GPIO_NR(4, 28)
	IOMUX_PAD_CTRL(DISP0_DAT7__GPIO4_IO28, WEAK_PULLDN_OUTPUT),
#define GP_GPS_RESET		IMX_GPIO_NR(4, 30)
	IOMUX_PAD_CTRL(DISP0_DAT9__GPIO4_IO30, WEAK_PULLDN_OUTPUT),

	/* HDMI CEC */
	IOMUX_PAD_CTRL(EIM_A25__HDMI_TX_CEC_LINE, CEC_PAD_CTRL),

	/* I2C1 - rv4162(rtc), */

	/* I2C2 - J12(touch connector), */
#define GP_I2C2_HDMI_EN	IMX_GPIO_NR(5, 5)
	IOMUX_PAD_CTRL(DISP0_DAT11__GPIO5_IO05, WEAK_PULLDN_OUTPUT),
#ifdef CONFIG_NEW_REV
#define GP_I2C2_CAMERA_EN	IMX_GPIO_NR(2, 1)
	IOMUX_PAD_CTRL(NANDF_D1__GPIO2_IO01, WEAK_PULLDN_OUTPUT),
#define GP_I2C2_FLASH_EN	IMX_GPIO_NR(2, 31)
	IOMUX_PAD_CTRL(EIM_EB3__GPIO2_IO31, WEAK_PULLDN_OUTPUT),
#else
#define GP_I2C2_CAMERA_EN	IMX_GPIO_NR(1, 31)
	IOMUX_PAD_CTRL(ENET_MDC__GPIO1_IO31, WEAK_PULLDN_OUTPUT),
#define GP_I2C2_FLASH_EN	IMX_GPIO_NR(3, 17)
	IOMUX_PAD_CTRL(EIM_D17__GPIO3_IO17, WEAK_PULLDN_OUTPUT),
#endif

	/* I2C3 - MPR21 cap touch, MPU-9250(accelerometer) */
#define GP_I2C3_ACCEL_EN	IMX_GPIO_NR(5, 31)
	IOMUX_PAD_CTRL(CSI0_DAT13__GPIO5_IO31, WEAK_PULLDN_OUTPUT),
#ifndef CONFIG_NEW_REV
#define GP_I2C3_MAX77818_EN	IMX_GPIO_NR(4, 25)
	IOMUX_PAD_CTRL(DISP0_DAT4__GPIO4_IO25, WEAK_PULLDN_OUTPUT),
#endif

	/* MAX77818, ends with B(active low) */
#define GP_MAX77818_INOKB		IMX_GPIO_NR(4, 26)	/* C5 */
	IOMUX_PAD_CTRL(DISP0_DAT5__GPIO4_IO26, WEAK_PULLUP),
#define GP_MAX77818_INTB		IMX_GPIO_NR(5, 6)	/* C3 */
	IOMUX_PAD_CTRL(DISP0_DAT12__GPIO5_IO06, WEAK_PULLUP),
#define GP_MAX77818_WCINOKB		IMX_GPIO_NR(5, 7)	/* A5 */
	IOMUX_PAD_CTRL(DISP0_DAT13__GPIO5_IO07, WEAK_PULLUP),

	/* Power */
#define GP_MAIN_ON_OFF		IMX_GPIO_NR(3, 20)	/* input to or gate */
	IOMUX_PAD_CTRL(EIM_D20__GPIO3_IO20, WEAK_PULLUP),
#ifdef CONFIG_NEW_REV
#define GP_ON_OFF_IRQ		IMX_GPIO_NR(5, 14)
	IOMUX_PAD_CTRL(DISP0_DAT20__GPIO5_IO14, WEAK_PULLUP),
#else
#define GP_ON_OFF_IRQ		IMX_GPIO_NR(5, 11)
	IOMUX_PAD_CTRL(DISP0_DAT17__GPIO5_IO11, WEAK_PULLUP),
#endif

	/* PMIC */
#define GP_PMIC_C0_OUT		IMX_GPIO_NR(2, 28)
	IOMUX_PAD_CTRL(EIM_EB0__GPIO2_IO28, WEAK_PULLUP),
#define GP_PMIC_C1_OUT		IMX_GPIO_NR(2, 29)
	IOMUX_PAD_CTRL(EIM_EB1__GPIO2_IO29, WEAK_PULLUP),
#define GP_PMIC_C2_OUT		IMX_GPIO_NR(3, 0)
	IOMUX_PAD_CTRL(EIM_DA0__GPIO3_IO00, WEAK_PULLUP),
#define GP_PMIC_C3_OUT		IMX_GPIO_NR(3, 1)
	IOMUX_PAD_CTRL(EIM_DA1__GPIO3_IO01, WEAK_PULLUP),
#define GP_PMIC_C4_OUT		IMX_GPIO_NR(2, 25)
	IOMUX_PAD_CTRL(EIM_OE__GPIO2_IO25, WEAK_PULLUP),
#define GP_PMIC_C5_OUT		IMX_GPIO_NR(2, 27)
	IOMUX_PAD_CTRL(EIM_LBA__GPIO2_IO27, WEAK_PULLUP),
#define GP_PMIC_R0_IN		IMX_GPIO_NR(3, 2)
	IOMUX_PAD_CTRL(EIM_DA2__GPIO3_IO02, WEAK_PULLUP),
#define GP_PMIC_R1_IN		IMX_GPIO_NR(3, 3)
	IOMUX_PAD_CTRL(EIM_DA3__GPIO3_IO03, WEAK_PULLUP),
#define GP_PMIC_R2_IN		IMX_GPIO_NR(3, 4)
	IOMUX_PAD_CTRL(EIM_DA4__GPIO3_IO04, WEAK_PULLUP),
#define GP_PMIC_R3_IN		IMX_GPIO_NR(3, 5)
	IOMUX_PAD_CTRL(EIM_DA5__GPIO3_IO05, WEAK_PULLUP),
#define GP_PMIC_R4_IN		IMX_GPIO_NR(2, 23)
	IOMUX_PAD_CTRL(EIM_CS0__GPIO2_IO23, WEAK_PULLUP),
#define GP_PMIC_R5_IN		IMX_GPIO_NR(2, 26)
	IOMUX_PAD_CTRL(EIM_RW__GPIO2_IO26, WEAK_PULLUP),
#define GP_PMIC_KEYPAD_LOCK	IMX_GPIO_NR(5, 0)
	IOMUX_PAD_CTRL(EIM_WAIT__GPIO5_IO00, WEAK_PULLUP),

	/* PWM1 */
#define GP_PWM1_BUZZER		IMX_GPIO_NR(4, 29)
	IOMUX_PAD_CTRL(DISP0_DAT8__GPIO4_IO29, WEAK_PULLDN_OUTPUT),

	/* Regulator - HDMI, USBH1_DN3, WM5102 speaker, braille display */
#define GP_REG_5V_EN	IMX_GPIO_NR(7, 8)
	IOMUX_PAD_CTRL(SD3_RST__GPIO7_IO08, WEAK_PULLUP_OUTPUT),

	/* rtc */
#ifdef CONFIG_NEW_REV
#define GP_RTC_RV4162_IRQ	IMX_GPIO_NR(5, 15)
	IOMUX_PAD_CTRL(DISP0_DAT21__GPIO5_IO15, WEAK_PULLUP),
#else
#define GP_RTC_RV4162_IRQ	IMX_GPIO_NR(5, 12)
	IOMUX_PAD_CTRL(DISP0_DAT18__GPIO5_IO12, WEAK_PULLUP),
#endif

	/* Test points */
#define GP_TP6			IMX_GPIO_NR(1, 4)
	IOMUX_PAD_CTRL(GPIO_4__GPIO1_IO04, WEAK_PULLUP),	/* 1.8V */
#define GP_TP7			IMX_GPIO_NR(1, 7)
	IOMUX_PAD_CTRL(GPIO_9__GPIO1_IO09, WEAK_PULLUP),	/* 1.8V */
#define GP_TP24			IMX_GPIO_NR(6, 31)
	IOMUX_PAD_CTRL(EIM_BCLK__GPIO6_IO31, WEAK_PULLUP),	/* 1.8V */
#define GP_TP29			IMX_GPIO_NR(1, 19)
	IOMUX_PAD_CTRL(SD1_DAT2__GPIO1_IO19, WEAK_PULLUP),	/* 1.8V */
#define GP_TP30			IMX_GPIO_NR(1, 21)
	IOMUX_PAD_CTRL(SD1_DAT3__GPIO1_IO21, WEAK_PULLUP),	/* 1.8V */
#define GP_TP92			IMX_GPIO_NR(6, 10)
	IOMUX_PAD_CTRL(NANDF_RB0__GPIO6_IO10, WEAK_PULLUP),	/* 2.6V */
#define GP_TP93			IMX_GPIO_NR(1, 27)
	IOMUX_PAD_CTRL(ENET_RXD0__GPIO1_IO27, WEAK_PULLUP),	/* 2.6V */

#ifdef CONFIG_NEW_REV
#define GP_TP28			IMX_GPIO_NR(5, 16)
	IOMUX_PAD_CTRL(DISP0_DAT22__GPIO5_IO16, OUTPUT_40OHM),	/* tri-state */
#define GP_TP107		IMX_GPIO_NR(5, 17)
	IOMUX_PAD_CTRL(DISP0_DAT23__GPIO5_IO17, OUTPUT_40OHM),	/* tri-state */
#define GP_TP108		IMX_GPIO_NR(5, 30)
	IOMUX_PAD_CTRL(CSI0_DAT12__GPIO5_IO30, WEAK_PULLUP),
#define GP_TP110		IMX_GPIO_NR(5, 18)
	IOMUX_PAD_CTRL(CSI0_PIXCLK__GPIO5_IO18, WEAK_PULLUP),
#define GP_TP111		IMX_GPIO_NR(5, 29)
	IOMUX_PAD_CTRL(CSI0_DAT11__GPIO5_IO29, WEAK_PULLDN),
#else
#define GP_TP25			IMX_GPIO_NR(2, 31)
	IOMUX_PAD_CTRL(EIM_EB3__GPIO2_IO31, OUTPUT_40OHM),	/* tri-state */
#define GP_TP27			IMX_GPIO_NR(3, 28)
	IOMUX_PAD_CTRL(EIM_D28__GPIO3_IO28, OUTPUT_40OHM),	/* tri-state */
#define GP_TP28			IMX_GPIO_NR(3, 30)
	IOMUX_PAD_CTRL(EIM_D30__GPIO3_IO30, OUTPUT_40OHM),	/* tri-state */
#define GP_TP107		IMX_GPIO_NR(4, 13)
	IOMUX_PAD_CTRL(KEY_ROW3__GPIO4_IO13, OUTPUT_40OHM),	/* tri-state */
#endif

	/* UART1 */
	IOMUX_PAD_CTRL(SD3_DAT7__UART1_TX_DATA, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DAT6__UART1_RX_DATA, UART_PAD_CTRL),

	/* UART2 */
	IOMUX_PAD_CTRL(EIM_D26__UART2_TX_DATA, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(EIM_D27__UART2_RX_DATA, UART_PAD_CTRL),

	/* UART3 for wl1271 */
	IOMUX_PAD_CTRL(EIM_D24__UART3_TX_DATA, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(EIM_D25__UART3_RX_DATA, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(EIM_D23__UART3_CTS_B, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(EIM_D31__UART3_RTS_B, UART_PAD_CTRL),

	/* UART5 - gps */
	IOMUX_PAD_CTRL(CSI0_DAT14__UART5_TX_DATA, UART_PAD_CTRL),
	IOMUX_PAD_CTRL(CSI0_DAT15__UART5_RX_DATA, UART_PAD_CTRL),

	/* USBH1 */
#define GP_USBH1_HUB_RESET	IMX_GPIO_NR(4, 31)
	IOMUX_PAD_CTRL(DISP0_DAT10__GPIO4_IO31, WEAK_PULLDN_OUTPUT),
#define GP_VBUS_GOOD		IMX_GPIO_NR(3, 15)
	IOMUX_PAD_CTRL(EIM_DA15__GPIO3_IO15, WEAK_PULLUP),	/* 1.8V */

	/* USB OTG */
	IOMUX_PAD_CTRL(GPIO_1__USB_OTG_ID, WEAK_PULLUP),
	IOMUX_PAD_CTRL(EIM_D21__USB_OTG_OC, WEAK_PULLUP),
#define GP_USB_OTG_PWR		IMX_GPIO_NR(3, 22)
	IOMUX_PAD_CTRL(EIM_D22__GPIO3_IO22, WEAK_PULLDN_OUTPUT),

	/* USDHC2 - TiWi wl1271 pads */
	IOMUX_PAD_CTRL(SD2_CLK__SD2_CLK, USDHC_CLK_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_CMD__SD2_CMD, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DAT0__SD2_DATA0, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DAT1__SD2_DATA1, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DAT2__SD2_DATA2, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD2_DAT3__SD2_DATA3, USDHC_PAD_CTRL),
#define GPIRQ_WL1271_WL	IMX_GPIO_NR(6, 11)
	IOMUX_PAD_CTRL(NANDF_CS0__GPIO6_IO11, WEAK_PULLDN),
#define GP_WL12XX_WL_ENABLE	IMX_GPIO_NR(6, 15)
	IOMUX_PAD_CTRL(NANDF_CS2__GPIO6_IO15, OUTPUT_40OHM),
#define GP_WL12XX_BT_ENABLE	IMX_GPIO_NR(6, 16)
	IOMUX_PAD_CTRL(NANDF_CS3__GPIO6_IO16, OUTPUT_40OHM),
//	IOMUX_PAD_CTRL(GPIO_8__XTALOSC_REF_CLK_32K, OUTPUT_40OHM),	/* slow clock */

	/* USDHC3 - micro SD card */
	IOMUX_PAD_CTRL(SD3_CLK__SD3_CLK, USDHC_CLK_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_CMD__SD3_CMD, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DAT0__SD3_DATA0, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DAT1__SD3_DATA1, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DAT2__SD3_DATA2, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD3_DAT3__SD3_DATA3, USDHC_PAD_CTRL),
#define GP_USDHC3_WP		IMX_GPIO_NR(7, 1)
	IOMUX_PAD_CTRL(SD3_DAT4__GPIO7_IO01, WEAK_PULLUP),
#define GP_USDHC3_CD		IMX_GPIO_NR(7, 0)
	IOMUX_PAD_CTRL(SD3_DAT5__GPIO7_IO00, WEAK_PULLUP),

	/* USDHC4 - eMMC */
	IOMUX_PAD_CTRL(SD4_CLK__SD4_CLK, USDHC_CLK_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_CMD__SD4_CMD, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT0__SD4_DATA0, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT1__SD4_DATA1, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT2__SD4_DATA2, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT3__SD4_DATA3, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT4__SD4_DATA4, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT5__SD4_DATA5, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT6__SD4_DATA6, USDHC_PAD_CTRL),
	IOMUX_PAD_CTRL(SD4_DAT7__SD4_DATA7, USDHC_PAD_CTRL),
#define GP_EMMC_RESET		IMX_GPIO_NR(2, 6)
	IOMUX_PAD_CTRL(NANDF_D6__GPIO2_IO06, WEAK_PULLUP),

	/* wm5102 */
#define GP_WM5102_GPIO4		IMX_GPIO_NR(2, 0)
	IOMUX_PAD_CTRL(NANDF_D0__GPIO2_IO00, WEAK_PULLUP),
#define GP_WM5102_GPIO5		IMX_GPIO_NR(6, 9)
	IOMUX_PAD_CTRL(NANDF_WP_B__GPIO6_IO09, WEAK_PULLUP),
#define GP_WM5102_LINE_HP_DET		IMX_GPIO_NR(2, 21)
	IOMUX_PAD_CTRL(EIM_A17__GPIO2_IO21, WEAK_PULLUP),
#define GP_WM5102_LINE_HP_DET2		IMX_GPIO_NR(2, 22)
	IOMUX_PAD_CTRL(EIM_A16__GPIO2_IO22, WEAK_PULLUP),
#define GPIRQ_WM5102			IMX_GPIO_NR(2, 20)
	IOMUX_PAD_CTRL(EIM_A18__GPIO2_IO20, WEAK_PULLUP),
#define GP_WM5102_RESET			IMX_GPIO_NR(6, 8)
	IOMUX_PAD_CTRL(NANDF_ALE__GPIO6_IO08, WEAK_PULLDN_OUTPUT),
#define GP_WM5102_LDO_EN		IMX_GPIO_NR(6, 7)
	IOMUX_PAD_CTRL(NANDF_CLE__GPIO6_IO07, WEAK_PULLDN_OUTPUT),
	IOMUX_PAD_CTRL(GPIO_0__CCM_CLKO1, OUTPUT_40OHM),	/* MCLK1 */
//	IOMUX_PAD_CTRL(GPIO_8__XTALOSC_REF_CLK_32K, OUTPUT_40OHM),	/* MCLK2 */
};

static const struct i2c_pads_info i2c_pads[] = {
	/* I2C1, rv4162 */
	I2C_PADS_INFO_ENTRY(I2C1, CSI0_DAT9, 5, 27, CSI0_DAT8, 5, 26, I2C_PAD_CTRL),
#ifdef CONFIG_NEW_REV
	I2C_PADS_INFO_ENTRY(I2C2, EIM_EB2, 2, 30, KEY_ROW3, 4, 13, I2C_PAD_CTRL),
#else
	I2C_PADS_INFO_ENTRY(I2C2, EIM_EB2, 2, 30, EIM_D16, 3, 16, I2C_PAD_CTRL),
#endif
	I2C_PADS_INFO_ENTRY(I2C3, GPIO_5, 1, 05, GPIO_16, 7, 11, I2C_PAD_CTRL),
};
#define I2C_BUS_CNT	3

#ifdef CONFIG_USB_EHCI_MX6
static void charge_from_usb(int enable)
{
	u8 val8 = enable ? 0x27 : 7;
	u8 orig_i2c_bus = i2c_get_bus_num();

	i2c_set_bus_num(2);
	i2c_write(0x69, 0xc3, 1, &val8, 1);
	i2c_set_bus_num(orig_i2c_bus);
}

int board_ehci_hcd_init(int port)
{
	return 0;
}

int board_ehci_power(int port, int on)
{
	int gp = port ? GP_USBH1_HUB_RESET : GP_USB_OTG_PWR;

	if (!port && on)
		charge_from_usb(0);
	gpio_set_value(gp, on);
	if (!port && !on)
		charge_from_usb(1);
	return 0;
}

#endif

#ifdef CONFIG_FSL_ESDHC_IMX
struct fsl_esdhc_cfg board_usdhc_cfg[] = {
	{.esdhc_base = USDHC3_BASE_ADDR, .bus_width = 4,
			.gp_cd = GP_USDHC3_CD},
	{.esdhc_base = USDHC4_BASE_ADDR, .bus_width = 8,
			.gp_reset = GP_EMMC_RESET},
};
#endif

#ifdef CONFIG_MXC_SPI
int board_spi_cs_gpio(unsigned bus, unsigned cs)
{
	int gp = (bus == 0 && cs == 0) ? GP_ECSPI1_NOR_CS : -1;
	return gp;
}
#endif

#if defined(CONFIG_VIDEO_IPUV3)

static const struct display_info_t displays[] = {
	/* hdmi */
	VD_1280_720M_60(HDMI, fbp_detect_i2c, 1, 0x50),
	VD_1920_1080M_60(HDMI, NULL, 1, 0x50),
	VD_1024_768M_60(HDMI, NULL, 1, 0x50),
};
#define display_cnt	ARRAY_SIZE(displays)
#else
#define displays	NULL
#define display_cnt	0
#endif

static const unsigned short gpios_out_low[] = {
	GP_CAM_STROBE,
	GP_CAM_TORCH,
	GP_CAM_MIPI_RESET,
	GP_CAM_MIPI_EN,
	GP_DISP_HV_EN,
#ifndef CONFIG_NEW_REV
	GP_BRL_DATA_BUF_EN,
	GP_I2C3_MAX77818_EN,
#endif
	GP_DISP_LED_RED,
	GP_DISP_LED_GREEN,
	GP_GSM_SIM_RESET,
	GP_GSM_PWR_EN,
	GP_GSM_RESET,
	GP_GSM_ON_OFF,
	GP_GPS_RESET,
	GP_I2C2_HDMI_EN,
	GP_I2C2_CAMERA_EN,
	GP_I2C2_FLASH_EN,
	GP_I2C3_ACCEL_EN,
	GP_PWM1_BUZZER,
	GP_USBH1_HUB_RESET,
	GP_USB_OTG_PWR,
	GP_WL12XX_WL_ENABLE,
	GP_WL12XX_BT_ENABLE,
	GP_EMMC_RESET,
	GP_WM5102_RESET,
	GP_WM5102_LDO_EN,
};

static const unsigned short gpios_out_high[] = {
	GP_MAIN_ON_OFF,
	GP_ECSPI1_NOR_CS,
	GP_ECSPI3_GSM,
	GP_ECSPI5_WM5102,
	GP_REG_5V_EN,
};

static const unsigned short gpios_in[] = {
	GPIRQ_ACCEL,
	GP_DISP_KEY_1,
	GP_DISP_KEY_2,
	GP_DISP_KEY_3,
	GP_DISP_KEY_4,
	GP_DISP_KEY_5,
	GP_DISP_KEY_6,
	GP_DISP_KEY_SHIFT,
	GP_DISP_KEY_SPACE,
	GP_DISP_KEY_CTRL,
	GP_DISP_STROBE,
#ifndef CONFIG_NEW_REV
	GP_BRL_MISO,
	GP_BRL_MOSI,
	GP_BRL_CLK,
#endif
	GP_VBUS_GOOD,
	GP_GSM_HOST_WAKE_WWAN,
	GP_GSM_HOST_WAKE,
	GP_GPS_HEARTBEAT,
	GPIRQ_GPS,
	GP_MAX77818_INOKB,
	GP_MAX77818_INTB,
	GP_MAX77818_WCINOKB,
	GP_ON_OFF_IRQ,
	GP_PMIC_C0_OUT,
	GP_PMIC_C1_OUT,
	GP_PMIC_C2_OUT,
	GP_PMIC_C3_OUT,
	GP_PMIC_C4_OUT,
	GP_PMIC_C5_OUT,
	GP_PMIC_R0_IN,
	GP_PMIC_R1_IN,
	GP_PMIC_R2_IN,
	GP_PMIC_R3_IN,
	GP_PMIC_R4_IN,
	GP_PMIC_R5_IN,
	GP_PMIC_KEYPAD_LOCK,
	GP_RTC_RV4162_IRQ,
	GP_TP6,
	GP_TP7,
	GP_TP24,
	GP_TP29,
	GP_TP30,
	GP_TP92,
	GP_TP93,
#ifndef CONFIG_NEW_REV
	GP_TP25,
	GP_TP27,
#endif
	GP_TP28,
	GP_TP107,
#ifdef CONFIG_NEW_REV
	GP_TP108,
	GP_TP110,
	GP_TP111,
#endif
	GPIRQ_WL1271_WL,
	GP_USDHC3_WP,
	GP_USDHC3_CD,
	GP_WM5102_GPIO4,
	GP_WM5102_GPIO5,
	GP_WM5102_LINE_HP_DET,
	GP_WM5102_LINE_HP_DET2,
	GPIRQ_WM5102,
};

int board_early_init_f(void)
{
	set_gpios_in(gpios_in, ARRAY_SIZE(gpios_in));
	set_gpios(gpios_out_high, ARRAY_SIZE(gpios_out_high), 1);
	set_gpios(gpios_out_low, ARRAY_SIZE(gpios_out_low), 0);
	SETUP_IOMUX_PADS(init_pads);
	return 0;
}

void board_poweroff(void)
{
	struct snvs_regs *snvs = (struct snvs_regs *)(SNVS_BASE_ADDR);

	gpio_set_value(GP_MAIN_ON_OFF, 0);
	writel(0x60, &snvs->lpcr);
	mdelay(500);
}

int board_init(void)
{
#ifndef CONFIG_NEW_REV
	gpio_set_value(GP_I2C3_MAX77818_EN, 1);
#endif
	common_board_init(i2c_pads, I2C_BUS_CNT, IOMUXC_GPR1_OTG_ID_GPIO1,
			displays, display_cnt, 0);

#ifndef CONFIG_NEW_REV
	gpio_set_value(GP_I2C3_MAX77818_EN, 0);
#endif
	return 0;
}

const struct button_key board_buttons[] = {
	{ "1",	GP_DISP_KEY_1,		'1', 0},
	{ "2",	GP_DISP_KEY_2,		'2', 0},
	{ "3",	GP_DISP_KEY_3,		'3', 0},
	{ "4",	GP_DISP_KEY_4,		'4', 0},
	{ "5",	GP_DISP_KEY_5,		'5', 0},
	{ "6",	GP_DISP_KEY_6,		'6', 0},
	{ "S",	GP_DISP_KEY_SHIFT,	'S', 0},
	{ "P",	GP_DISP_KEY_SPACE,	'P', 0},
	{ "C",	GP_DISP_KEY_CTRL,	'C', 0},
	{NULL, 0, 0, 0},
};

#ifdef CONFIG_CMD_BMODE
const struct boot_mode board_boot_modes[] = {
	/* 4 bit bus width */
	{"mmc0",	MAKE_CFGVAL(0x40, 0x30, 0x00, 0x00)},
	{"mmc1",	MAKE_CFGVAL(0x60, 0x58, 0x00, 0x00)},	/* 8-bit eMMC */
	{NULL,		0},
};
#endif

static int _do_poweroff(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	board_poweroff();
	return 0;
}

U_BOOT_CMD(
	poweroff, 70, 0, _do_poweroff,
	"power down board",
	""
);
