/*
 * Copyright (C) 2018, Boundary Devices <info@boundarydevices.com>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */
#define GP_PHY_RX_CTL	IMX_GPIO_NR(1, 24)
#define GP_PHY_RXC	IMX_GPIO_NR(1, 25)
#define GP_PHY_RD0	IMX_GPIO_NR(1, 26)
#define GP_PHY_RD1	IMX_GPIO_NR(1, 27)
#define GP_PHY_RD2	IMX_GPIO_NR(1, 28)
#define GP_PHY_RD3	IMX_GPIO_NR(1, 29)

#ifndef STRAP_AR8035
#define STRAP_AR8035	(0x28 | (CONFIG_FEC_MXC_PHYADDR & 3))
#endif

#define PULL_GP(a, bit)                (((a >> bit) & 1) ? WEAK_PULLUP_OUTPUT : WEAK_PULLDN_OUTPUT)

#ifdef CONFIG_PHY_ATHEROS

#ifndef GP_RGMII_PHY_RESET
#define GP_RGMII_PHY_RESET	IMX_GPIO_NR(3, 15)
#endif

#ifdef CONFIG_FEC_RESET_PULLUP
#define ATHEROS_RESET_PINCTRL	WEAK_PULLUP_OUTPUT
#else
#define ATHEROS_RESET_PINCTRL	WEAK_PULLDN_OUTPUT
#endif

static const iomux_v3_cfg_t enet_ar8035_gpio_pads[] = {
#if GP_RGMII_PHY_RESET == IMX_GPIO_NR(3, 15)
	IOMUX_PAD_CTRL(NAND_RE_B__GPIO3_IO15, ATHEROS_RESET_PINCTRL),
#elif GP_RGMII_PHY_RESET == IMX_GPIO_NR(2, 10)
	IOMUX_PAD_CTRL(SD1_RESET_B__GPIO2_IO10, ATHEROS_RESET_PINCTRL),
#endif
	IOMUX_PAD_CTRL(ENET_RD0__GPIO1_IO26, PULL_GP(STRAP_AR8035, 0)),
	IOMUX_PAD_CTRL(ENET_RD1__GPIO1_IO27, PULL_GP(STRAP_AR8035, 1)),
	IOMUX_PAD_CTRL(ENET_RD2__GPIO1_IO28, PULL_GP(STRAP_AR8035, 2)),
	IOMUX_PAD_CTRL(ENET_RD3__GPIO1_IO29, PULL_GP(STRAP_AR8035, 3)),
	IOMUX_PAD_CTRL(ENET_RX_CTL__GPIO1_IO24, PULL_GP(STRAP_AR8035, 4)),
	IOMUX_PAD_CTRL(ENET_RXC__GPIO1_IO25, PULL_GP(STRAP_AR8035, 5)),
};

static const iomux_v3_cfg_t enet_ar8035_pads[] = {
	IOMUX_PAD_CTRL(ENET_RD0__ENET1_RGMII_RD0, PAD_CTRL_ENET_RX),
	IOMUX_PAD_CTRL(ENET_RD1__ENET1_RGMII_RD1, PAD_CTRL_ENET_RX),
	IOMUX_PAD_CTRL(ENET_RD2__ENET1_RGMII_RD2, PAD_CTRL_ENET_RX),
	IOMUX_PAD_CTRL(ENET_RD3__ENET1_RGMII_RD3, PAD_CTRL_ENET_RX),
	IOMUX_PAD_CTRL(ENET_RX_CTL__ENET1_RGMII_RX_CTL, PAD_CTRL_ENET_RX),
	IOMUX_PAD_CTRL(ENET_RXC__ENET1_RGMII_RXC, PAD_CTRL_ENET_RX),
};
#endif
