/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2009-2010 Amit Kucheria <amit.kucheria@canonical.com>
 * Copyright (C) 2010 Freescale Semiconductor, Inc.
 * Copyright (C) 2009-2012 Genesi USA, Inc.
 */

/*
 * The vast majority of this file is taken from the Linux kernel at
 * commit 5d23b39
 */

#ifndef __IOMUX_MX51_H__
#define __IOMUX_MX51_H__

#include <asm/mach-imx/iomux-v3.h>

/* Pad control groupings */
#define MX51_AUD_PAD_CTRL	(PAD_CTL_PUS_100K_UP | PAD_CTL_DSE_HIGH | \
				PAD_CTL_HYS | PAD_CTL_SRE_FAST)
#define MX51_UART_PAD_CTRL	(PAD_CTL_PUS_100K_DOWN | PAD_CTL_DSE_HIGH | \
				PAD_CTL_HYS | PAD_CTL_SRE_FAST)
#define MX51_I2C_PAD_CTRL	(PAD_CTL_SRE_FAST | PAD_CTL_ODE | \
				PAD_CTL_DSE_HIGH | PAD_CTL_PUS_100K_UP | \
				PAD_CTL_HYS)
#define MX51_ESDHC_PAD_CTRL	(PAD_CTL_SRE_FAST | PAD_CTL_ODE | \
				PAD_CTL_DSE_HIGH | PAD_CTL_PUS_100K_UP | \
				PAD_CTL_HYS)
#define MX51_USBH_PAD_CTRL	(PAD_CTL_SRE_FAST | PAD_CTL_DSE_HIGH | \
				PAD_CTL_PUS_100K_UP | PAD_CTL_HYS)
#define MX51_ECSPI_PAD_CTRL	(PAD_CTL_PKE | PAD_CTL_HYS | \
				PAD_CTL_DSE_HIGH | PAD_CTL_SRE_FAST)
#define MX51_SDHCI_PAD_CTRL	(PAD_CTL_DSE_HIGH | PAD_CTL_PUS_47K_UP | \
				PAD_CTL_SRE_FAST | PAD_CTL_DVS)
#define MX51_GPIO_PAD_CTRL	(PAD_CTL_DSE_HIGH | PAD_CTL_PKE | PAD_CTL_SRE_FAST)

#define MX51_PAD_CTRL_2		(PAD_CTL_PKE | PAD_CTL_HYS)
#define MX51_PAD_CTRL_4		(PAD_CTL_PKE | PAD_CTL_DVS | PAD_CTL_HYS)
#define MX51_PAD_CTRL_5		(PAD_CTL_DVS | PAD_CTL_DSE_HIGH)

/*
 * The naming convention for the pad modes is MX51_PAD_<padname>__<padmode>
 * If <padname> or <padmode> refers to a GPIO, it is named GPIO<unit>_<num>
 * See also iomux-v3.h
 */

#define IOMUX_P(mux_ctrl_ofs, pad_ctrl_ofs, sel_input_ofs,		\
		mux_mode, sel_input, pad_ctrl)				\
		IOMUX_PAD(pad_ctrl_ofs, mux_ctrl_ofs, mux_mode,		\
		sel_input_ofs, sel_input, pad_ctrl)
/*							    PAD    MUX   ALT INPSE PATH PADCTRL */
enum {
	MX51_PAD_EIM_D16__GPIO2_0		= IOMUX_PAD(0x3f0, 0x05c, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D16__USBH2_DATA0		= IOMUX_PAD(0x3f0, 0x05c, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D16__I2C1_SDA		= IOMUX_PAD(0x3f0, 0x05c, 0x14, 0x9b4, 0, MX51_I2C_PAD_CTRL),
	MX51_PAD_EIM_D17__GPIO2_1		= IOMUX_PAD(0x3f4, 0x060, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D17__USBH2_DATA1		= IOMUX_PAD(0x3f4, 0x060, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D18__USBH2_DATA2		= IOMUX_PAD(0x3f8, 0x064, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D19__GPIO2_3		= IOMUX_PAD(0x3fc, 0x068, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D19__USBH2_DATA3		= IOMUX_PAD(0x3fc, 0x068, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D19__I2C1_SCL		= IOMUX_PAD(0x3fc, 0x068, 0x14, 0x9b0, 0, MX51_I2C_PAD_CTRL),
	MX51_PAD_EIM_D20__USBH2_DATA4		= IOMUX_PAD(0x400, 0x06c, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D21__GPIO2_5		= IOMUX_PAD(0x404, 0x070, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D21__USBH2_DATA5		= IOMUX_PAD(0x404, 0x070, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D22__GPIO2_6		= IOMUX_PAD(0x408, 0x074, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D22__USBH2_DATA6		= IOMUX_PAD(0x408, 0x074, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D23__USBH2_DATA7		= IOMUX_PAD(0x40c, 0x078, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_D24__GPIO2_8		= IOMUX_PAD(0x410, 0x07c, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D24__I2C2_SDA		= IOMUX_PAD(0x410, 0x07c, 0x14, 0x9bc, 0, MX51_I2C_PAD_CTRL),
	MX51_PAD_EIM_D25__UART3_RXD		= IOMUX_PAD(0x414, 0x080, 3, 0x9f4, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_EIM_D26__KEY_COL7		= IOMUX_PAD(0x418, 0x084, 1, 0x9cc, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D26__UART3_TXD		= IOMUX_PAD(0x418, 0x084, 3, __NA_, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_EIM_D27__GPIO2_9		= IOMUX_PAD(0x41c, 0x088, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_D27__I2C2_SCL		= IOMUX_PAD(0x41c, 0x088, 0x14, 0x9b8, 0, MX51_I2C_PAD_CTRL),
	MX51_PAD_EIM_A16__GPIO2_10		= IOMUX_PAD(0x430, 0x09c, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_A17__GPIO2_11		= IOMUX_PAD(0x434, 0x0a0, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_A20__GPIO2_14		= IOMUX_PAD(0x440, 0x0ac, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_A22__GPIO2_16		= IOMUX_PAD(0x448, 0x0b4, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_A23__GPIO2_17		= IOMUX_PAD(0x44c, 0x0b8, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_A24__USBH2_CLK		= IOMUX_PAD(0x450, 0x0bc, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_A25__USBH2_DIR		= IOMUX_PAD(0x454, 0x0c0, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_A26__GPIO2_20		= IOMUX_PAD(0x458, 0x0c4, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_A26__USBH2_STP		= IOMUX_PAD(0x458, 0x0c4, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_A27__USBH2_NXT		= IOMUX_PAD(0x45c, 0x0c8, 2, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_EIM_EB2__FEC_MDIO		= IOMUX_PAD(0x468, 0x0d4, 3, 0x954, 0, PAD_CTL_PUS_22K_UP | PAD_CTL_SRE_FAST | PAD_CTL_DSE_HIGH | PAD_CTL_HYS),
	MX51_PAD_EIM_EB3__FEC_RDATA1		= IOMUX_PAD(0x46c, 0x0d8, 3, 0x95c, 0, NO_PAD_CTRL),
	MX51_PAD_EIM_EB3__GPIO2_23		= IOMUX_PAD(0x46c, 0x0d8, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_CS0__GPIO2_25		= IOMUX_PAD(0x474, 0x0e0, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_CS2__FEC_RDATA2		= IOMUX_PAD(0x47c, 0x0e8, 3, 0x960, 0, NO_PAD_CTRL),
	MX51_PAD_EIM_CS2__GPIO2_27		= IOMUX_PAD(0x47c, 0x0e8, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_CS3__FEC_RDATA3		= IOMUX_PAD(0x480, 0x0ec, 3, 0x964, 0, NO_PAD_CTRL),
	MX51_PAD_EIM_CS3__GPIO2_28		= IOMUX_PAD(0x480, 0x0ec, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_CS4__FEC_RX_ER		= IOMUX_PAD(0x484, 0x0f0, 3, 0x970, 0, MX51_PAD_CTRL_2),
	MX51_PAD_EIM_CS4__GPIO2_29		= IOMUX_PAD(0x484, 0x0f0, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_EIM_CS5__FEC_CRS		= IOMUX_PAD(0x488, 0x0f4, 3, 0x950, 0, MX51_PAD_CTRL_2),
	MX51_PAD_DRAM_RAS__DRAM_RAS		= IOMUX_PAD(0x4a4, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_CAS__DRAM_CAS		= IOMUX_PAD(0x4a8, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDWE__DRAM_SDWE		= IOMUX_PAD(0x4ac, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDCKE0__DRAM_SDCKE0	= IOMUX_PAD(0x4b0, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDCKE1__DRAM_SDCKE1	= IOMUX_PAD(0x4b4, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDCLK__DRAM_SDCLK		= IOMUX_PAD(0x4b8, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDQS0__DRAM_SDQS0		= IOMUX_PAD(0x4bc, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDQS1__DRAM_SDQS1		= IOMUX_PAD(0x4c0, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDQS2__DRAM_SDQS2		= IOMUX_PAD(0x4c4, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_SDQS3__DRAM_SDQS3		= IOMUX_PAD(0x4c8, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_CS0__DRAM_CS0		= IOMUX_PAD(0x4cc, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_CS1__DRAM_CS1		= IOMUX_PAD(0x4d0, 0x104, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_DQM0__DRAM_DQM0		= IOMUX_PAD(0x4d4, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_DQM1__DRAM_DQM1		= IOMUX_PAD(0x4d8, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_DQM2__DRAM_DQM2		= IOMUX_PAD(0x4dc, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DRAM_DQM3__DRAM_DQM3		= IOMUX_PAD(0x4e0, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_WE_B__PATA_DIOW		= IOMUX_PAD(0x4e4, 0x108, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_WE_B__GPIO3_3		= IOMUX_PAD(0x4e4, 0x108, 3, 0x980, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_RE_B__PATA_DIOR		= IOMUX_PAD(0x4e8, 0x10c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_RE_B__GPIO3_4		= IOMUX_PAD(0x4e8, 0x10c, 3, 0x984, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_ALE__PATA_BUFFER_EN	= IOMUX_PAD(0x4ec, 0x110, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CLE__PATA_RESET_B	= IOMUX_PAD(0x4f0, 0x114, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CLE__GPIO3_6		= IOMUX_PAD(0x4f0, 0x114, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_WP_B__PATA_DMACK		= IOMUX_PAD(0x4f4, 0x118, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_WP_B__GPIO3_7		= IOMUX_PAD(0x4f4, 0x118, 3, 0x990, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_RB0__PATA_DMARQ		= IOMUX_PAD(0x4f8, 0x11c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_RB0__GPIO3_8		= IOMUX_PAD(0x4f8, 0x11c, 3, 0x994, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_RB1__PATA_IORDY		= IOMUX_PAD(0x4fc, 0x120, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_RB1__GPIO3_9		= IOMUX_PAD(0x4fc, 0x120, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_RB2__FEC_COL		= IOMUX_PAD(0x500, 0x124, 1, 0x94c, 0, MX51_PAD_CTRL_2),
	MX51_PAD_NANDF_RB2__GPIO3_10		= IOMUX_PAD(0x500, 0x124, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_RB3__FEC_RX_CLK		= IOMUX_PAD(0x504, 0x128, 1, 0x968, 0, MX51_PAD_CTRL_2),
	MX51_PAD_NANDF_RB3__GPIO3_11		= IOMUX_PAD(0x504, 0x128, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO_NAND__GPIO3_12		= IOMUX_PAD(0x514, 0x12c, 0, 0x998, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO_NAND__PATA_INTRQ		= IOMUX_PAD(0x514, 0x12c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CS0__GPIO3_16		= IOMUX_PAD(0x518, 0x130, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_CS1__GPIO3_17		= IOMUX_PAD(0x51c, 0x134, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_CS2__FEC_TX_ER		= IOMUX_PAD(0x520, 0x138, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_NANDF_CS2__PATA_CS_0		= IOMUX_PAD(0x520, 0x138, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CS3__FEC_MDC		= IOMUX_PAD(0x524, 0x13c, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_NANDF_CS3__PATA_CS_1		= IOMUX_PAD(0x524, 0x13c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CS4__FEC_TDATA1		= IOMUX_PAD(0x528, 0x140, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_NANDF_CS4__PATA_DA_0		= IOMUX_PAD(0x528, 0x140, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CS5__FEC_TDATA2		= IOMUX_PAD(0x52c, 0x144, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_NANDF_CS5__PATA_DA_1		= IOMUX_PAD(0x52c, 0x144, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CS6__FEC_TDATA3		= IOMUX_PAD(0x530, 0x148, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_NANDF_CS6__PATA_DA_2		= IOMUX_PAD(0x530, 0x148, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_CS7__FEC_TX_EN		= IOMUX_PAD(0x534, 0x14c, 1, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_NANDF_RDY_INT__FEC_TX_CLK	= IOMUX_PAD(0x538, 0x150, 1, 0x974, 0, MX51_PAD_CTRL_4),
	MX51_PAD_NANDF_D15__GPIO3_25		= IOMUX_PAD(0x53c, 0x154, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_D15__PATA_DATA15		= IOMUX_PAD(0x53c, 0x154, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D14__GPIO3_26		= IOMUX_PAD(0x540, 0x158, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_D14__PATA_DATA14		= IOMUX_PAD(0x540, 0x158, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D13__GPIO3_27		= IOMUX_PAD(0x544, 0x15c, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_D13__PATA_DATA13		= IOMUX_PAD(0x544, 0x15c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D12__PATA_DATA12		= IOMUX_PAD(0x548, 0x160, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D12__GPIO3_28		= IOMUX_PAD(0x548, 0x160, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_D11__FEC_RX_DV		= IOMUX_PAD(0x54c, 0x164, 2, 0x96c, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D11__PATA_DATA11		= IOMUX_PAD(0x54c, 0x164, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D10__GPIO3_30		= IOMUX_PAD(0x550, 0x168, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_D10__PATA_DATA10		= IOMUX_PAD(0x550, 0x168, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D9__FEC_RDATA0		= IOMUX_PAD(0x554, 0x16c, 0x12, 0x958, 0, MX51_PAD_CTRL_4),
	MX51_PAD_NANDF_D9__GPIO3_31		= IOMUX_PAD(0x554, 0x16c, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_NANDF_D9__PATA_DATA9		= IOMUX_PAD(0x554, 0x16c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D8__FEC_TDATA0		= IOMUX_PAD(0x558, 0x170, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_NANDF_D8__PATA_DATA8		= IOMUX_PAD(0x558, 0x170, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D7__PATA_DATA7		= IOMUX_PAD(0x55c, 0x174, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D6__PATA_DATA6		= IOMUX_PAD(0x560, 0x178, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D5__PATA_DATA5		= IOMUX_PAD(0x564, 0x17c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D4__PATA_DATA4		= IOMUX_PAD(0x568, 0x180, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D3__PATA_DATA3		= IOMUX_PAD(0x56c, 0x184, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D2__PATA_DATA2		= IOMUX_PAD(0x570, 0x188, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D1__PATA_DATA1		= IOMUX_PAD(0x574, 0x18c, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_NANDF_D0__PATA_DATA0		= IOMUX_PAD(0x578, 0x190, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_CSI1_D8__CSI1_D8		= IOMUX_P(0x194, 0x57c, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D8__GPIO3_12		= IOMUX_P(0x194, 0x57c, 0x998, 0x3, 0x1, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSI1_D9__CSI1_D9		= IOMUX_P(0x198, 0x580, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D9__GPIO3_13		= IOMUX_P(0x198, 0x580, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSI1_D10__CSI1_D10		= IOMUX_P(0x19c, 0x584, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D11__CSI1_D11		= IOMUX_P(0x1a0, 0x588, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D12__CSI1_D12		= IOMUX_P(0x1a4, 0x58c, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D13__CSI1_D13		= IOMUX_P(0x1a8, 0x590, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D14__CSI1_D14		= IOMUX_P(0x1ac, 0x594, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D15__CSI1_D15		= IOMUX_P(0x1b0, 0x598, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D16__CSI1_D16		= IOMUX_P(0x1b4, 0x59c, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D17__CSI1_D17		= IOMUX_P(0x1b8, 0x5a0, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D18__CSI1_D18		= IOMUX_P(0x1bc, 0x5a4, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_D19__CSI1_D19		= IOMUX_P(0x1c0, 0x5a8, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_VSYNC__CSI1_VSYNC		= IOMUX_P(0x1c4, 0x5ac, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_VSYNC__GPIO3_14		= IOMUX_P(0x1c4, 0x5ac, __NA_, 0x3, 0x0, 0x0),
	MX51_PAD_CSI1_HSYNC__CSI1_HSYNC		= IOMUX_P(0x1c8, 0x5b0, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_HSYNC__GPIO3_15		= IOMUX_P(0x1c8, 0x5b0, __NA_, 0x3, 0x0, 0x0),
	MX51_PAD_CSI1_PIXCLK__CSI1_PIXCLK	= IOMUX_P(__NA_, 0x5b4, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI1_MCLK__CSI1_MCLK		= IOMUX_P(__NA_, 0x5b8, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D12__CSI2_D12		= IOMUX_P(0x1cc, 0x5bc, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D12__GPIO4_9		= IOMUX_P(0x1cc, 0x5bc, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSI2_D13__CSI2_D13		= IOMUX_P(0x1d0, 0x5c0, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D13__GPIO4_10		= IOMUX_P(0x1d0, 0x5c0, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSI2_D14__CSI2_D14		= IOMUX_P(0x1d4, 0x5c4, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D15__CSI2_D15		= IOMUX_P(0x1d8, 0x5c8, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D16__CSI2_D16		= IOMUX_P(0x1dc, 0x5cc, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D17__CSI2_D17		= IOMUX_P(0x1e0, 0x5d0, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D18__CSI2_D18		= IOMUX_P(0x1e4, 0x5d4, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D18__GPIO4_11		= IOMUX_P(0x1e4, 0x5d4, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSI2_D19__CSI2_D19		= IOMUX_P(0x1e8, 0x5d8, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_D19__GPIO4_12		= IOMUX_P(0x1e8, 0x5d8, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSI2_VSYNC__CSI2_VSYNC		= IOMUX_P(0x1ec, 0x5dc, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_VSYNC__GPIO4_13		= IOMUX_P(0x1ec, 0x5dc, __NA_, 0x3, 0x0, 0x0),
	MX51_PAD_CSI2_HSYNC__CSI2_HSYNC		= IOMUX_P(0x1f0, 0x5e0, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_HSYNC__GPIO4_14		= IOMUX_P(0x1f0, 0x5e0, __NA_, 0x3, 0x0, 0x0),
	MX51_PAD_CSI2_PIXCLK__CSI2_PIXCLK	= IOMUX_P(0x1f4, 0x5e4, __NA_, 0x0, 0x0, 0x0),
	MX51_PAD_CSI2_PIXCLK__GPIO4_15		= IOMUX_P(0x1f4, 0x5e4, __NA_, 0x3, 0x0, 0x0),
	MX51_PAD_I2C1_CLK__I2C1_CLK		= IOMUX_PAD(0x5e8, 0x1f8, 0x10, __NA_, 0, MX51_I2C_PAD_CTRL),
	MX51_PAD_I2C1_CLK__GPIO4_16		= IOMUX_PAD(0x5e8, 0x1f8, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_I2C1_DAT__I2C1_DAT		= IOMUX_PAD(0x5ec, 0x1fc, 0x10, __NA_, 0, MX51_I2C_PAD_CTRL),
	MX51_PAD_I2C1_DAT__GPIO4_17		= IOMUX_PAD(0x5ec, 0x1fc, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_AUD3_BB_TXD__AUD3_TXD		= IOMUX_P(0x200, 0x5f0, __NA_, 0x0, 0x0, MX51_AUD_PAD_CTRL),
	MX51_PAD_AUD3_BB_TXD__GPIO4_18		= IOMUX_P(0x200, 0x5f0, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_AUD3_BB_RXD__AUD3_RXD		= IOMUX_P(0x204, 0x5f4, __NA_, 0x0, 0x0, MX51_AUD_PAD_CTRL),
	MX51_PAD_AUD3_BB_RXD__GPIO4_19		= IOMUX_P(0x204, 0x5f4, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_AUD3_BB_RXD__UART3_RXD		= IOMUX_P(0x204, 0x5f4, 0x9f4, 0x1, 0x2, MX51_UART_PAD_CTRL),
	MX51_PAD_AUD3_BB_CK__AUD3_TXC		= IOMUX_P(0x208, 0x5f8, __NA_, 0x0, 0x0, MX51_AUD_PAD_CTRL),
	MX51_PAD_AUD3_BB_CK__GPIO4_20		= IOMUX_P(0x208, 0x5f8, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_AUD3_BB_FS__AUD3_TXFS		= IOMUX_P(0x20c, 0x5fc, __NA_, 0x0, 0x0, MX51_AUD_PAD_CTRL),
	MX51_PAD_AUD3_BB_FS__GPIO4_21		= IOMUX_P(0x20c, 0x5fc, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_AUD3_BB_FS__UART3_TXD		= IOMUX_P(0x20c, 0x5fc, __NA_, 0x1, 0x0, MX51_UART_PAD_CTRL),
	MX51_PAD_CSPI1_MOSI__ECSPI1_MOSI	= IOMUX_PAD(0x600, 0x210, 0, __NA_, 0, MX51_ECSPI_PAD_CTRL),
	MX51_PAD_CSPI1_MISO__ECSPI1_MISO	= IOMUX_PAD(0x604, 0x214, 0, __NA_, 0, MX51_ECSPI_PAD_CTRL),
	MX51_PAD_CSPI1_SS0__ECSPI1_SS0		= IOMUX_PAD(0x608, 0x218, 0, __NA_, 0, MX51_ECSPI_PAD_CTRL),
	MX51_PAD_CSPI1_SS0__GPIO4_24		= IOMUX_PAD(0x608, 0x218, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSPI1_SS1__ECSPI1_SS1		= IOMUX_PAD(0x60c, 0x21c, 0, __NA_, 0, MX51_ECSPI_PAD_CTRL),
	MX51_PAD_CSPI1_SS1__GPIO4_25		= IOMUX_PAD(0x60c, 0x21c, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSPI1_RDY__ECSPI1_RDY		= IOMUX_PAD(0x610, 0x220, 0, __NA_, 0, MX51_ECSPI_PAD_CTRL),
	MX51_PAD_CSPI1_RDY__GPIO4_26		= IOMUX_PAD(0x610, 0x220, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_CSPI1_SCLK__ECSPI1_SCLK	= IOMUX_PAD(0x614, 0x224, 0, __NA_, 0, MX51_ECSPI_PAD_CTRL),
	MX51_PAD_UART1_RXD__UART1_RXD		= IOMUX_PAD(0x618, 0x228, 0, 0x9e4, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_UART1_RXD__GPIO4_28		= IOMUX_P(0x228, 0x618, __NA_, 0x3, 0x0, MX51_UART_PAD_CTRL),
	MX51_PAD_UART1_TXD__UART1_TXD		= IOMUX_PAD(0x61c, 0x22c, 0, __NA_, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_UART1_TXD__GPIO4_29		= IOMUX_P(0x22c, 0x61c, __NA_, 0x3, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_UART1_RTS__UART1_RTS		= IOMUX_PAD(0x620, 0x230, 0, 0x9e0, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_UART1_RTS__GPIO4_30		= IOMUX_PAD(0x620, 0x230, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_UART1_CTS__UART1_CTS		= IOMUX_PAD(0x624, 0x234, 0, __NA_, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_UART1_CTS__GPIO4_31		= IOMUX_PAD(0x624, 0x234, 3, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_UART2_RXD__UART2_RXD		= IOMUX_PAD(0x628, 0x238, 0, 0x9ec, 2, MX51_UART_PAD_CTRL),
	MX51_PAD_UART2_TXD__UART2_TXD		= IOMUX_PAD(0x62c, 0x23c, 0, __NA_, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_UART3_RXD__UART3_RXD		= IOMUX_PAD(0x630, 0x240, 1, 0x9f4, 4, MX51_UART_PAD_CTRL),
	MX51_PAD_UART3_TXD__UART3_TXD		= IOMUX_PAD(0x634, 0x244, 1, __NA_, 0, MX51_UART_PAD_CTRL),
	MX51_PAD_USBH1_CLK__USBH1_CLK		= IOMUX_PAD(0x678, 0x278, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DIR__USBH1_DIR		= IOMUX_PAD(0x67c, 0x27c, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_STP__GPIO1_27		= IOMUX_PAD(0x680, 0x280, 2, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_USBH1_STP__USBH1_STP		= IOMUX_PAD(0x680, 0x280, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_NXT__USBH1_NXT		= IOMUX_PAD(0x684, 0x284, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA0__USBH1_DATA0	= IOMUX_PAD(0x688, 0x288, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA1__USBH1_DATA1	= IOMUX_PAD(0x68c, 0x28c, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA2__USBH1_DATA2	= IOMUX_PAD(0x690, 0x290, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA3__USBH1_DATA3	= IOMUX_PAD(0x694, 0x294, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA4__USBH1_DATA4	= IOMUX_PAD(0x698, 0x298, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA5__USBH1_DATA5	= IOMUX_PAD(0x69c, 0x29c, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA6__USBH1_DATA6	= IOMUX_PAD(0x6a0, 0x2a0, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_USBH1_DATA7__USBH1_DATA7	= IOMUX_PAD(0x6a4, 0x2a4, 0, __NA_, 0, MX51_USBH_PAD_CTRL),
	MX51_PAD_DI1_PIN11__ECSPI1_SS2		= IOMUX_PAD(0x6a8, 0x2a8, 7, __NA_, 0, MX51_ECSPI_PAD_CTRL),
	MX51_PAD_DI1_PIN11__GPIO3_0		= IOMUX_P(0x2a8, 0x6a8, __NA_, 0x4, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_DI1_PIN12__GPIO3_1		= IOMUX_PAD(0x6ac, 0x2ac, 4, 0x978, 1, MX51_GPIO_PAD_CTRL),
	MX51_PAD_DI1_PIN13__GPIO3_2		= IOMUX_PAD(0x6b0, 0x2b0, 4, 0x97c, 1, MX51_GPIO_PAD_CTRL),
	MX51_PAD_DI1_D0_CS__GPIO3_3		= IOMUX_PAD(0x6b4, 0x2b4, 4, 0x980, 1, MX51_GPIO_PAD_CTRL),
	MX51_PAD_DI1_D1_CS__GPIO3_4		= IOMUX_PAD(0x6b8, 0x2b8, 4, 0x984, 1, MX51_GPIO_PAD_CTRL),
	MX51_PAD_DISPB2_SER_DIN__GPIO3_5	= IOMUX_PAD(0x6bc, 0x2bc, 4, 0x988, 1, MX51_GPIO_PAD_CTRL),
	MX51_PAD_DISPB2_SER_DIO__GPIO3_6	= IOMUX_PAD(0x6c0, 0x2c0, 4, 0x98c, 1, MX51_GPIO_PAD_CTRL),
	MX51_PAD_DISP1_DAT0__DISP1_DAT0		= IOMUX_PAD(0x6cc, 0x2cc, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT1__DISP1_DAT1		= IOMUX_PAD(0x6d0, 0x2d0, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT2__DISP1_DAT2		= IOMUX_PAD(0x6d4, 0x2d4, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT3__DISP1_DAT3		= IOMUX_PAD(0x6d8, 0x2d8, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT4__DISP1_DAT4		= IOMUX_PAD(0x6dc, 0x2dc, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT5__DISP1_DAT5		= IOMUX_PAD(0x6e0, 0x2e0, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT6__DISP1_DAT6		= IOMUX_PAD(0x6e4, 0x2e4, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT7__DISP1_DAT7		= IOMUX_PAD(0x6e8, 0x2e8, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT8__DISP1_DAT8		= IOMUX_PAD(0x6ec, 0x2ec, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT9__DISP1_DAT9		= IOMUX_PAD(0x6f0, 0x2f0, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT10__DISP1_DAT10	= IOMUX_PAD(0x6f4, 0x2f4, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT11__DISP1_DAT11	= IOMUX_PAD(0x6f8, 0x2f8, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT12__DISP1_DAT12	= IOMUX_PAD(0x6fc, 0x2fc, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT13__DISP1_DAT13	= IOMUX_PAD(0x700, 0x300, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT14__DISP1_DAT14	= IOMUX_PAD(0x704, 0x304, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT15__DISP1_DAT15	= IOMUX_PAD(0x708, 0x308, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT16__DISP1_DAT16	= IOMUX_PAD(0x70c, 0x30c, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT17__DISP1_DAT17	= IOMUX_PAD(0x710, 0x310, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT18__DISP1_DAT18	= IOMUX_PAD(0x714, 0x314, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT19__DISP1_DAT19	= IOMUX_PAD(0x718, 0x318, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT20__DISP1_DAT20	= IOMUX_PAD(0x71c, 0x31c, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT21__DISP1_DAT21	= IOMUX_PAD(0x720, 0x320, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT22__DISP1_DAT22	= IOMUX_PAD(0x724, 0x324, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP1_DAT23__DISP1_DAT23	= IOMUX_PAD(0x728, 0x328, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DI1_PIN3__DI1_PIN3		= IOMUX_PAD(0x72c, 0x32c, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DI1_DISP_CLK__DI1_DISP_CLK	= IOMUX_PAD(0x730, 0x000, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DI1_PIN2__DI1_PIN2		= IOMUX_PAD(0x734, 0x330, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DI1_PIN15__DI1_PIN15		= IOMUX_PAD(0x738, 0x000, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DI2_PIN2__FEC_MDC		= IOMUX_PAD(0x74C, 0x344, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DI2_DISP_CLK__DI2_DISP_CLK	= IOMUX_PAD(0x754, 0x34c, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DI_GP4__DI2_PIN15		= IOMUX_PAD(0x758, 0x350, 4, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_DISP2_DAT0__DISP2_DAT0		= IOMUX_PAD(0x75c, 0x354, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT1__DISP2_DAT1		= IOMUX_PAD(0x760, 0x358, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT2__DISP2_DAT2		= IOMUX_PAD(0x764, 0x35c, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT3__DISP2_DAT3		= IOMUX_PAD(0x768, 0x360, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT4__DISP2_DAT4		= IOMUX_PAD(0x76c, 0x364, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT5__DISP2_DAT5		= IOMUX_PAD(0x770, 0x368, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT6__DISP2_DAT6		= IOMUX_PAD(0x774, 0x36c, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT6__FEC_TDAT1		= IOMUX_PAD(0x774, 0x36C, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT7__DISP2_DAT7		= IOMUX_PAD(0x778, 0x370, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT7__FEC_TDAT2		= IOMUX_PAD(0x778, 0x370, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT8__DISP2_DAT8		= IOMUX_PAD(0x77c, 0x374, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT8__FEC_TDAT3		= IOMUX_PAD(0x77C, 0x374, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT9__DISP2_DAT9		= IOMUX_PAD(0x780, 0x378, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT9__FEC_TX_EN		= IOMUX_PAD(0x780, 0x378, 2, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT10__DISP2_DAT10	= IOMUX_PAD(0x784, 0x37c, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT10__FEC_COL		= IOMUX_PAD(0x784, 0x37C, 2, 0x94c, 0x1, MX51_PAD_CTRL_2),
	MX51_PAD_DISP2_DAT11__DISP2_DAT11	= IOMUX_PAD(0x788, 0x380, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT11__FEC_RXCLK		= IOMUX_PAD(0x788, 0x380, 2, 0x968, 0x1, MX51_PAD_CTRL_2),
	MX51_PAD_DISP2_DAT12__DISP2_DAT12	= IOMUX_PAD(0x78c, 0x384, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT12__FEC_RX_DV		= IOMUX_PAD(0x78C, 0x384, 2, 0x96c, 0x1, MX51_PAD_CTRL_4),
	MX51_PAD_DISP2_DAT13__DISP2_DAT13	= IOMUX_PAD(0x790, 0x388, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT13__FEC_TX_CLK	= IOMUX_PAD(0x790, 0x388, 2, 0x974, 0x1, MX51_PAD_CTRL_4),
	MX51_PAD_DISP2_DAT14__DISP2_DAT14	= IOMUX_PAD(0x794, 0x38c, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT14__FEC_RDAT0		= IOMUX_PAD(0x794, 0x38C, 2, 0x958, 0x1, MX51_PAD_CTRL_4),
	MX51_PAD_DISP2_DAT15__DISP2_DAT15	= IOMUX_PAD(0x798, 0x390, 0, __NA_, 0, MX51_PAD_CTRL_5),
	MX51_PAD_DISP2_DAT15__FEC_TDAT0		= IOMUX_PAD(0x798, 0x390, 2, 0x0, 0, MX51_PAD_CTRL_5),
	MX51_PAD_SD1_CMD__SD1_CMD		= IOMUX_PAD(0x79c, 0x394, 0x10, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD1_CLK__SD1_CLK		= IOMUX_PAD(0x7a0, 0x398, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL | PAD_CTL_HYS),
	MX51_PAD_SD1_DATA0__SD1_DATA0		= IOMUX_PAD(0x7a4, 0x39c, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD1_DATA1__SD1_DATA1		= IOMUX_PAD(0x7a8, 0x3a0, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD1_DATA2__SD1_DATA2		= IOMUX_PAD(0x7ac, 0x3a4, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD1_DATA3__SD1_DATA3		= IOMUX_PAD(0x7b0, 0x3a8, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_GPIO1_0__GPIO1_0		= IOMUX_PAD(0x7b4, 0x3ac, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_0__SD1_CD		= IOMUX_PAD(0x7b4, 0x3ac, 0, __NA_, 0, MX51_ESDHC_PAD_CTRL),
	MX51_PAD_GPIO1_1__SD1_WP		= IOMUX_PAD(0x7b8, 0x3b0, 0, __NA_, 0, MX51_ESDHC_PAD_CTRL),
	MX51_PAD_GPIO1_1__GPIO1_1		= IOMUX_PAD(0x7b8, 0x3b0, 1, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_SD2_CMD__SD2_CMD		= IOMUX_PAD(0x7bc, 0x3b4, 0x10, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD2_CLK__SD2_CLK		= IOMUX_PAD(0x7c0, 0x3b8, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL | PAD_CTL_HYS),
	MX51_PAD_SD2_DATA0__SD2_DATA0		= IOMUX_PAD(0x7c4, 0x3bc, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD2_DATA1__SD2_DATA1		= IOMUX_PAD(0x7c8, 0x3c0, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD2_DATA2__SD2_DATA2		= IOMUX_PAD(0x7cc, 0x3c4, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_SD2_DATA3__SD2_DATA3		= IOMUX_PAD(0x7d0, 0x3c8, 0, __NA_, 0, MX51_SDHCI_PAD_CTRL),
	MX51_PAD_GPIO1_2__GPIO1_2		= IOMUX_PAD(0x7d4, 0x3cc, 0, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_2__PWM1_PWMO		= IOMUX_PAD(0x7d4, 0x3cc, 1, __NA_, 0, NO_PAD_CTRL),
	MX51_PAD_GPIO1_3__GPIO1_3		= IOMUX_PAD(0x7d8, 0x3d0, 0, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_4__GPIO1_4		= IOMUX_PAD(0x804, 0x3d8, 0, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_5__GPIO1_5		= IOMUX_PAD(0x808, 0x3dc, 0, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_6__GPIO1_6		= IOMUX_PAD(0x80c, 0x3e0, 0, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_7__GPIO1_7		= IOMUX_PAD(0x810, 0x3e4, 0, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_7__SD2_WP		= IOMUX_PAD(0x810, 0x3e4, 6, __NA_, 0, MX51_ESDHC_PAD_CTRL),
	MX51_PAD_GPIO1_8__GPIO1_8		= IOMUX_PAD(0x814, 0x3e8, 0, __NA_, 0, MX51_GPIO_PAD_CTRL),
	MX51_PAD_GPIO1_8__SD2_CD		= IOMUX_PAD(0x814, 0x3e8, 6, __NA_, 0, MX51_ESDHC_PAD_CTRL),
	MX51_PAD_GPIO1_9__GPIO1_9		= IOMUX_P(0x3ec, 0x818, __NA_, 0x0, 0x0, MX51_GPIO_PAD_CTRL),
	MX51_GRP_DDRPKS				= IOMUX_PAD(0x820, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_B4			= IOMUX_PAD(0x82c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_PKEDDR				= IOMUX_PAD(0x838, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DDR_A0				= IOMUX_PAD(0x83c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DDR_A1				= IOMUX_PAD(0x848, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DDRAPUS			= IOMUX_PAD(0x84c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_HYSDDR0			= IOMUX_PAD(0x85c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_HYSDDR1			= IOMUX_PAD(0x864, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_HYSDDR2			= IOMUX_PAD(0x86c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_HYSDDR3			= IOMUX_PAD(0x874, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_SR_B0			= IOMUX_PAD(0x878, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DDRAPKS			= IOMUX_PAD(0x87c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_SR_B1			= IOMUX_PAD(0x880, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DDRPUS				= IOMUX_PAD(0x884, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_SR_B2			= IOMUX_PAD(0x88c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_PKEADDR			= IOMUX_PAD(0x890, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_SR_B4			= IOMUX_PAD(0x89c, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_INMODE1			= IOMUX_PAD(0x8a0, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_B0			= IOMUX_PAD(0x8a4, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_B1			= IOMUX_PAD(0x8ac, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DRAM_B2			= IOMUX_PAD(0x8b8, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
	MX51_GRP_DDR_SR_A1			= IOMUX_PAD(0x8bc, __NA_, 0, __NA_, 0, NO_PAD_CTRL),
};

#endif /* __IOMUX_MX51_H__ */
