/*
 * Copyright 2005-2009 Freescale Semiconductor, Inc. All rights reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

/**
 * @file apihelp.h
 * @brief Support definitions and functions for test code of FSL SHW API
 */

#ifndef APIHELP_C
#define APIHELP_C

#ifdef __KERNEL__

#include "portable_os.h"

#define printf printk
#define malloc(x) os_alloc_memory(x, GFP_KERNEL)
#define free(y) os_free_memory(y)

#else  /* not in kernel */

#include <stdio.h>
#include <stddef.h>

#include <sys/time.h>

#include <inttypes.h>

#endif /* not in kernel */


#include <fsl_shw.h>
#include <fsl_shw_keystore.h>

/*!
 * Number of bytes of difference for compare_result() to print when expected
 * and actual do not compare equal.
 */
#define MAX_DUMP 20


/*!
 * Compare two strings.  Print debug information if they do not compare.
 *
 * @param   model   The correct version of @a result.
 * @param   result  An output string from a test.
 * @param   length  The number of bytes of @a model, @a result to compare.
 * @param   name    A NUL-terminated string which is the name of the string
 *                  being compared.
 *
 * @return zero if the strings compare, non-zero otherwise.
 */
int compare_result(const uint8_t* model, const uint8_t* result,
                   uint32_t length, const char* name);

/*!
 * Return a (non-allocated) string containing an interpretation of
 * an FSL SHW API error code.
 *
 * @param  code    The error code to interpret.
 *
 * @return  The associated English interpretation of the code.
 */
char* fsl_error_string(fsl_shw_return_t code);

/*!
 * Return the number of bytes generated by a hash algorithm.
 *
 * @param alg  The hash algorithm to check.
 *
 * @return The number of bytes for that algorithm.
 */
unsigned get_hash_size(fsl_shw_hash_alg_t alg);

#endif
