/*
 * Copyright (C) 2012 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this software; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "memtools_register_info.h"

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AIPSTZ
#endif

// Bitfields in register AIPSTZ_MPR.
static const field_t hw_aipstz_mpr[] =
{
    {
        "MPROT3",
        "Master 3 Priviledge, Buffer, Read, Write Control.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT1",
        "Master 1 Priviledge, Buffer, Read, Write Control",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT0",
        "Master 0 Priviledge, Buffer, Read, Write Control",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR.
static const field_t hw_aipstz_opacr[] =
{
    {
        "OPAC7",
        "Off-platform Peripheral Access Control 7",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC6",
        "Off-platform Peripheral Access Control 6",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC5",
        "Off-platform Peripheral Access Control 5",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC4",
        "Off-platform Peripheral Access Control 4",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC3",
        "Off-platform Peripheral Access Control 3",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC2",
        "Off-platform Peripheral Access Control 2",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC1",
        "Off-platform Peripheral Access Control 1",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC0",
        "Off-platform Peripheral Access Control 0",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR1.
static const field_t hw_aipstz_opacr1[] =
{
    {
        "OPAC15",
        "Off-platform Peripheral Access Control 15",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC14",
        "Off-platform Peripheral Access Control 14",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC13",
        "Off-platform Peripheral Access Control 13",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC12",
        "Off-platform Peripheral Access Control 12",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC11",
        "Off-platform Peripheral Access Control 11",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC10",
        "Off-platform Peripheral Access Control 10",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC9",
        "Off-platform Peripheral Access Control 9",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC8",
        "Off-platform Peripheral Access Control 8",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR2.
static const field_t hw_aipstz_opacr2[] =
{
    {
        "OPAC23",
        "Off-platform Peripheral Access Control 23",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC22",
        "Off-platform Peripheral Access Control 22",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC21",
        "Off-platform Peripheral Access Control 21",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC20",
        "Off-platform Peripheral Access Control 20",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC19",
        "Off-platform Peripheral Access Control 19",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC18",
        "Off-platform Peripheral Access Control 18",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC17",
        "Off-platform Peripheral Access Control 17",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC16",
        "Off-platform Peripheral Access Control 16",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR3.
static const field_t hw_aipstz_opacr3[] =
{
    {
        "OPAC31",
        "Off-platform Peripheral Access Control 31",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC30",
        "Off-platform Peripheral Access Control 30",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC29",
        "Off-platform Peripheral Access Control 29",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC28",
        "Off-platform Peripheral Access Control 28",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC27",
        "Off-platform Peripheral Access Control 27",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC26",
        "Off-platform Peripheral Access Control 26",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC25",
        "Off-platform Peripheral Access Control 25",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC24",
        "Off-platform Peripheral Access Control 24",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR4.
static const field_t hw_aipstz_opacr4[] =
{
    {
        "OPAC33",
        "Off-platform Peripheral Access Control 33",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC32",
        "Off-platform Peripheral Access Control 32",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AIPSTZ module.
static const reg_t hw_aipstz[] =
{
    {
        "MPR",
        "Each AIPSTZ_MPR specifies 16 4-bit fields defining the access privileg"
        "e level associated with a bus master in the platform, as well as speci"
        "fying whether write accesses from this master are bufferable shown in "
        " The registers provide one field per bus master, where field 15 corres"
        "ponds to master 15, field 14 to master 14,...",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_aipstz_mpr
    },
    {
        "OPACR",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr
    },
    {
        "OPACR1",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr1
    },
    {
        "OPACR2",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr2
    },
    {
        "OPACR3",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr3
    },
    {
        "OPACR4",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_aipstz_opacr4
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ARMGLOBALTIMER
#endif

// Bitfields in register ARMGLOBALTIMER_COUNTER0.
static const field_t hw_armglobaltimer_counter0[] =
{
    {
        "VALUE",
        "32-bits of the counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_COUNTER1.
static const field_t hw_armglobaltimer_counter1[] =
{
    {
        "VALUE",
        "32-bits of the counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_CONTROL.
static const field_t hw_armglobaltimer_control[] =
{
    {
        "TIMER_ENABLE",
        "Timer enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COMP_ENABLE",
        "This bit is banked per Cortex-A9 processor.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ENABLE",
        "This bit is banked per Cortex-A9 processor.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTO_INCREMENT",
        "This bit is banked per Cortex-A9 processor.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALER",
        "The prescaler modifies the clock period for the decrementing event for"
        " the Counter Register.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_IRQSTATUS.
static const field_t hw_armglobaltimer_irqstatus[] =
{
    {
        "EVENT_FLAG",
        "The event flag is a sticky bit that is automatically set when the Coun"
        "ter Register reaches the Comparator Register value.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_COMPARATOR0.
static const field_t hw_armglobaltimer_comparator0[] =
{
    {
        "VALUE",
        "32-bits of the comparator value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_COMPARATOR1.
static const field_t hw_armglobaltimer_comparator1[] =
{
    {
        "VALUE",
        "32-bits of the comparator value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_AUTOINCREMENT.
static const field_t hw_armglobaltimer_autoincrement[] =
{
    {
        "VALUE",
        "32-bit auto-increment value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ARMGLOBALTIMER module.
static const reg_t hw_armglobaltimer[] =
{
    {
        "COUNTER0",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_counter0
    },
    {
        "COUNTER1",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_counter1
    },
    {
        "CONTROL",
        "Configuration and control of the Global Timer.",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_armglobaltimer_control
    },
    {
        "IRQSTATUS",
        "This is a banked register for all Cortex-A9 processors present.",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_irqstatus
    },
    {
        "COMPARATOR0",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_comparator0
    },
    {
        "COMPARATOR1",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000214, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_comparator1
    },
    {
        "AUTOINCREMENT",
        "This 32-bit register gives the increment value of the Comparator Regis"
        "ter when the Auto-increment bit is set in the Timer Control Register.",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_autoincrement
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AUDMUX
#endif

// Bitfields in register AUDMUX_PTCR1.
static const field_t hw_audmux_ptcr1[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR1.
static const field_t hw_audmux_pdcr1[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR2.
static const field_t hw_audmux_ptcr2[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR2.
static const field_t hw_audmux_pdcr2[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR3.
static const field_t hw_audmux_ptcr3[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR3.
static const field_t hw_audmux_pdcr3[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR4.
static const field_t hw_audmux_ptcr4[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR4.
static const field_t hw_audmux_pdcr4[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR5.
static const field_t hw_audmux_ptcr5[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR5.
static const field_t hw_audmux_pdcr5[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR6.
static const field_t hw_audmux_ptcr6[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR6.
static const field_t hw_audmux_pdcr6[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR7.
static const field_t hw_audmux_ptcr7[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR7.
static const field_t hw_audmux_pdcr7[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AUDMUX module.
static const reg_t hw_audmux[] =
{
    {
        "PTCR1",
        "PTCR1 is the Port Timing Control Register for Port 1.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr1
    },
    {
        "PDCR1",
        "PDCR1 is the Port Data Control Register for Port 1.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr1
    },
    {
        "PTCR2",
        "PTCR2 is the Port Timing Control Register for Port 2.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr2
    },
    {
        "PDCR2",
        "PDCR2 is the Port Data Control Register for Port 2.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr2
    },
    {
        "PTCR3",
        "PTCR3 is the Port Timing Control Register for Port 3.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr3
    },
    {
        "PDCR3",
        "PDCR3 is the Port Data Control Register for Port 3.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr3
    },
    {
        "PTCR4",
        "Port Timing Control Register for Port 4",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr4
    },
    {
        "PDCR4",
        "PDCR4 is the Port Data Control Register for Port 4.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr4
    },
    {
        "PTCR5",
        "Port Timing Control Register for Port 5",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr5
    },
    {
        "PDCR5",
        "PDCR5 is the Port Data Control Register for Port 5.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr5
    },
    {
        "PTCR6",
        "Port Timing Control Register for Port 6",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr6
    },
    {
        "PDCR6",
        "PDCR6 is the Port Data Control Register for Port 6.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr6
    },
    {
        "PTCR7",
        "Port Timing Control Register for Port 7",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr7
    },
    {
        "PDCR7",
        "PDCR7 is the Port Data Control Register for Port 7 .",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr7
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM
#endif

// Bitfields in register CCM_CCR.
static const field_t hw_ccm_ccr[] =
{
    {
        "OSCNT",
        "Oscillator ready counter value.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_EN",
        "On chip oscillator enable bit - this bit value is reflected on the out"
        "put cosc_en.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_COUNT",
        "Well Bias counter.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG_BYPASS_COUNT",
        "Counter for analog_reg_bypass signal assertion after standby voltage r"
        "equest by pmic_vstby_req.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBC_EN",
        "Enable for REG_BYPASS_COUNTER.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCDR.
static const field_t hw_ccm_ccdr[] =
{
    {
        "MMDC_ROOT_MASK",
        "During divider ratio mmdc_root_axi_podf change or sync mux periph2_clk"
        "_sel change (but not jtag) or SRC request during warm reset, mask hand"
        "shake with mmdc_root module.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_CH0_MASK",
        "During divider ratio mmdc_ch0_axi_podf change or sync mux periph_clk_s"
        "el change (but not jtag) or SRC request during warm reset, mask handsh"
        "ake with mmdc_ch0 module.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSR.
static const field_t hw_ccm_csr[] =
{
    {
        "REF_EN_B",
        "Status of the value of ref_en_b output of ccm",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COSC_READY",
        "Status indication of on board oscillator.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCSR.
static const field_t hw_ccm_ccsr[] =
{
    {
        "PLL3_SW_CLK_SEL",
        "Selects source to generate pll3_sw_clk.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL2_SW_CLK_SEL",
        "Selects source to generate pll2_sw_clk.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL1_SW_CLK_SEL",
        "Selects source to generate pll1_sw_clk.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STEP_SEL",
        "Selects the option to be chosen for the step frequency when shifting A"
        "RM frequency.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_396M_DIS_MASK",
        "Mask of 396M PFD auto-disable.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_352M_DIS_MASK",
        "Mask of 352M PFD auto-disable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_594M_DIS_MASK",
        "Mask of 594M PFD auto-disable.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_508M_DIS_MASK",
        "Mask of 508M PFD auto-disable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_454M_DIS_MASK",
        "Mask of 454M PFD auto-disable.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_720M_DIS_MASK",
        "Mask of 720M PFD auto-disable.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_540M_DIS_MASK",
        "Mask of 540M PFD auto-disable.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CACRR.
static const field_t hw_ccm_cacrr[] =
{
    {
        "ARM_PODF",
        "Divider for ARM clock root.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCDR.
static const field_t hw_ccm_cbcdr[] =
{
    {
        "PERIPH2_CLK2_PODF",
        "Divider for periph2_clk2 podf.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FABRIC_MMDC_PODF",
        "Post divider for fabric_mmdc clock.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_CLK_SEL",
        "OCRAM clock source select",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_ALT_CLK_SEL",
        "OCRAM alternative clock select",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPG_PODF",
        "Divider for ipg podf.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF",
        "Divider for ahb podf.",
        10, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_PODF",
        "Post divider for ocram clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL",
        "Selector for peripheral main clock (source of mmdc_ch0_axi_clk_root).",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL",
        "Selector for peripheral2 main clock (source of mmdc_root_axi_clk_root "
        ").",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_PODF",
        "Divider for periph2 clock podf.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCMR.
static const field_t hw_ccm_cbcmr[] =
{
    {
        "GPU2D_OVG_CORE_CLK_SEL",
        "Selector for gpu2d_ovg_core clock multiplexer",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU2D_CORE_CLK_SEL",
        "Selector for gpu2d_core clock multiplexer",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDOAXI_CLK_SEL",
        "Selector for vdoaxi clock multiplexer",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_SEL",
        "Selector for peripheral clk2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH_CLK_SEL",
        "Selector for pre_periph clock multiplexer",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK2_SEL",
        "Selector for periph2_clk2 clock multiplexer",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH2_CLK_SEL",
        "Selector for pre_periph2 clock multiplexer",
        21, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_PIX_PODF",
        "Post divider for EPDC_PIX.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU2D_OVG_CORE_PODF",
        "Divider for gpu3d_core clock.",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU2D_CORE_PODF",
        "Post divider for gpu2d_core clock.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR1.
static const field_t hw_ccm_cscmr1[] =
{
    {
        "PERCLK_PODF",
        "Divider for perclk podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERCLK_CLK_SEL",
        "Selector for the perclk clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI1_CLK_SEL",
        "Selector for ssi1 clock multiplexer",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI2_CLK_SEL",
        "Selector for ssi2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_SEL",
        "Selector for ssi3 clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_CLK_SEL",
        "Selector for usdhc1 clock multiplexer",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_CLK_SEL",
        "Selector for usdhc2 clock multiplexer",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC3_CLK_SEL",
        "Selector for usdhc3 clock multiplexer",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC4_CLK_SEL",
        "Selector for usdhc4 clock multiplexer",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_PIX_PODF",
        "Post divider for LCDIF_PIX.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EMI_SLOW_PODF",
        "Divider for aclk_emi_slow clock root.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EMI_SLOW_SEL",
        "Selector for aclk_emi_slow root clock multiplexer",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR2.
static const field_t hw_ccm_cscmr2[] =
{
    {
        "EXTERN_AUDIO_CLK_SEL",
        "Selector for external audio clock multiplexer",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR1.
static const field_t hw_ccm_cscdr1[] =
{
    {
        "UART_CLK_PODF",
        "Divider for uart clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UART_CLK_SEL",
        "Selector for the UART clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_PODF",
        "Divider for usdhc1 clock podf.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_PODF",
        "Divider for usdhc2 clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC3_PODF",
        "Divider for usdhc3 clock podf.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC4_PODF",
        "Divider for esdhc4 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS1CDR.
static const field_t hw_ccm_cs1cdr[] =
{
    {
        "SSI1_CLK_PODF",
        "Divider for ssi1 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI1_CLK_PRED",
        "Divider for ssi1 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTERN_AUDIO_CLK_PRED",
        "Divider for external audio clock pred.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_PODF",
        "Divider for ssi3 clock podf.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_PRED",
        "Divider for ssi3 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTERN_AUDIO_CLK_PODF",
        "Divider for external audio clock podf.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS2CDR.
static const field_t hw_ccm_cs2cdr[] =
{
    {
        "SSI2_CLK_PODF",
        "Divider for ssi2 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI2_CLK_PRED",
        "Divider for ssi2 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_CLK_SEL",
        "Selector for ldb_di1 clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI1_CLK_SEL",
        "Selector for ldb_di1 clock multiplexer",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CDCDR.
static const field_t hw_ccm_cdcdr[] =
{
    {
        "SPDIF1_CLK_SEL",
        "Selector for spdif1 clock multiplexer",
        7, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF1_CLK_PODF",
        "Divider for spdif1 clock podf.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF1_CLK_PRED",
        "Divider for spdif1 clock pred.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_SEL",
        "Selector for spdif0 clock multiplexer",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PODF",
        "Divider for spdif0 clock podf.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PRED",
        "Divider for spdif0 clock pred.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CHSCCDR.
static const field_t hw_ccm_chsccdr[] =
{
    {
        "PXP_AXI_PODF",
        "Divider for pxp_axi clock divider.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_AXI_CLK_SEL",
        "Selector for pxp_axi root clock multiplexer",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_AXI_PODF",
        "Divider for epdc_axi (SiPix) clock divider.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_AXI_CLK_SEL",
        "Selector for epdc_axi (SiPix) root clock multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR2.
static const field_t hw_ccm_cscdr2[] =
{
    {
        "LCDIF_PIX_PRED",
        "Divider for lcdif_pix clock divider.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_PIX_CLK_SEL",
        "Selector for lcdif_pix root clock multiplexer",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_PIX_PRED",
        "Divider for epdc_pix clock divider.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_PIX_CLK_SEL",
        "Selector for epdc_pix root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_SEL",
        "Selector for the ECSPI clock multiplexor",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_PODF",
        "Divider for ecspi clock podf.",
        19, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR3.
static const field_t hw_ccm_cscdr3[] =
{
    {
        "CSI_CORE_CLK_SEL",
        "Selector for csi_core clock multiplexer",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_CORE_PODF",
        "Post divider for csi_core clock.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_AXI_CLK_SEL",
        "Selector for lcdif_axi clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_AXI_PODF",
        "Divider for lcdif_axi clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CWDR.
static const field_t hw_ccm_cwdr[] =
{
    { 0 } // Terminator
};

// Bitfields in register CCM_CDHIPR.
static const field_t hw_ccm_cdhipr[] =
{
    {
        "AXI_PODF_BUSY",
        "Busy indicator for axi_podf.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AHB_PODF_BUSY",
        "Busy indicator for ahb_podf.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MMDC_ROOT_PODF_BUSY",
        "Busy indicator for mmdc_root_axi_podf.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH2_CLK_SEL_BUSY",
        "Busy indicator for periph2_clk_sel mux control.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MMDC_CH0_PODF_BUSY",
        "Busy indicator for mmdc_ch0_axi_podf.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH_CLK_SEL_BUSY",
        "Busy indicator for periph_clk_sel mux control.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARM_PODF_BUSY",
        "Busy indicator for arm_podf.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CTOR.
static const field_t hw_ccm_ctor[] =
{
    {
        "OBS_SPARE_OUTPUT_2_SEL",
        "Selection of the signal to be generated on obs_output_2 (output of CCM"
        ") for observability on the pads.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBS_SPARE_OUTPUT_1_SEL",
        "Selection of the signal to be generated on obs_output_1 (output of CCM"
        ") for observability on the pads.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBS_SPARE_OUTPUT_0_SEL",
        "Selection of the signal to be generated on obs_output_0 (output of CCM"
        ") for observability on the pads.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBS_EN",
        "observability enable bit.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CLPCR.
static const field_t hw_ccm_clpcr[] =
{
    {
        "LPM",
        "Setting the low power mode that system will enter on next assertion of"
        " dsm_request signal.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_PMIC_VFUNCTIONAL_READY",
        "By asserting this bit CCM will bypass waiting for pmic_vfunctional_rea"
        "dy signal when coming out of STOP mode.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_CLK_DIS_ON_LPM",
        "Define if ARM clocks (arm_clk, soc_mxclk, soc_pclk, soc_dbg_pclk, vl_w"
        "rck) will be disabled on wait mode.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SBYOS",
        "Standby clock oscillator bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_REF_OSC",
        "dis_ref_osc - in run mode, software can manually control closing of ex"
        "ternal reference oscillator clock, i.e.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSTBY",
        "Voltage standby request bit.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STBY_COUNT",
        "Standby counter definition.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_PWRDOWN",
        "In run mode, software can manually control powering down of on chip os"
        "cillator, i.e.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_PER_AT_LPM",
        "Enable periphery charge pump for well biasing at low power mode (stop "
        "or wait)",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_MMDC_CH0_LPM_HS",
        "Bypass handshake with mmdc_ch0 on next entrance to low power mode (wai"
        "t or stop mode).",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_MMDC_ROOT_LPM_HS",
        "Bypass handshake with mmdc_root on next entrance to low power mode (wa"
        "it or stop mode).",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE0_WFI",
        "Mask WFI of core0 for entering low power mode  Note: assertion of all "
        "bits[27:22] will generate low power mode request",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_SCU_IDLE",
        "Mask SCU IDLE for entering low power mode  Note: assertion of all bits"
        "[27:22] will generate low power mode request",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_L2CC_IDLE",
        "Mask L2CC IDLE for entering low power mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CISR.
static const field_t hw_ccm_cisr[] =
{
    {
        "LRF_PLL",
        "Interrupt ipi_int_2 generated due to lock of all enabled and not bypas"
        "eed pll's",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_READY",
        "Interrupt ipi_int_2 generated due to on board oscillator ready, i.e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of axi_a_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_B_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of axi_b_podf",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH2_CLK_SEL_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of periph2_clk_s"
        "el",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_ROOT_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of mmdc_ch0_podf"
        "_ loaded",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL_LOADED",
        "Interrupt ipi_int_1 generated due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_CH0_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to update of mmdc_ch0_axi_podf.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of arm_podf.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CIMR.
static const field_t hw_ccm_cimr[] =
{
    {
        "MASK_LRF_PLL",
        "mask interrupt generation due to lrf of pll's",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_COSC_READY",
        "mask interrupt generation due to on board oscillator ready",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AXI_PODF_LOADED",
        "mask interrupt generation due to frequency change of axi_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AXI_B_PODF_LOADED",
        "mask interrupt generation due to frequency change of axi_b_podf",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MASK_PERIPH2_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph2_clk_sel.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AHB_PODF_LOADED",
        "mask interrupt generation due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_MMDC_ROOT_PODF_LOADED",
        "mask interrupt generation due to update of mask_mmdc_root_podf",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_MMDC_CH0_PODF_LOADED",
        "mask interrupt generation due to update of mask_mmdc_ch0_podf",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "mask interrupt generation due to frequency change of arm_podf",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCOSR.
static const field_t hw_ccm_ccosr[] =
{
    {
        "CLKO1_SEL",
        "Selection of the clock to be generated on clko1",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_DIV",
        "Setting the divider of CLKO1",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_EN",
        "Enable of CLKO1 clock",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_CLKO2_SEL",
        "CLKO1 output to reflect clko1 or clko2 clocks",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_SEL",
        "Selection of the clock to be generated on clko2",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_DIV",
        "Setting the divider of CLKO2",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_EN",
        "Enable of CLKO2 clock",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CGPR.
static const field_t hw_ccm_cgpr[] =
{
    {
        "PMIC_DELAY_SCALER",
        "Defines clock dividion of clock for stby_count (pmic delay counter)",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MEM_IGP_STOP_MASK",
        "Clear this bit to disallow putting the ARM cache into low power mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_EXT_CLK_DIS",
        "Disable external clock driver of MMDC during STOP mode",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EFUSE_PROG_SUPPLY_GATE",
        "Defines the value of the output signal cgpr_dout[4].",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPL",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0.
static const field_t hw_ccm_ccgr0[] =
{
    {
        "CG0",
        "aips_tz1 clocks (aips_tz1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "aips_tz2 clocks (aips_tz2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "Reserved",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "Reserved",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "Reserved",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "Reserved",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "Reserved",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "CPU debug clocks (cheetah_dbg_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "Reserved",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1.
static const field_t hw_ccm_ccgr1[] =
{
    {
        "CG0",
        "ecspi1 clocks (ecspi1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "ecspi2 clocks (ecspi2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "ecspi3 clocks (ecspi3_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "ecspi4 clocks (ecspi4_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "Reserved",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "epit1 clocks (epit1_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "epit2 clocks (epit2_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "esai clocks (extern_audio_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "gpt bus clock (gpt_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "gpt serial clock (gpt_serial_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpu2d ovg clock (gpu2d_ovg_core_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2.
static const field_t hw_ccm_ccgr2[] =
{
    {
        "CG0",
        "Reserved",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "i2c1_serial clock (i2c1_serial_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "i2c2_serial clock (i2c2_serial_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "i2c3_serial clock (i2c3_serial_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "OCOTP_CTRL clock (iim_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "iomux_ipt_clk_io clock (iomux_ipt_clk_io_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "ipmux1 clock (ipmux1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ipmux2 clock (ipmux2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ipmux3 clock (ipmux3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ipsync_ip2apb_tzasc1_ipg clocks (ipsync_ip2apb_tzasc1_ipg_master_clk_e"
        "nable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "ipsync_vdoa_ipg clocks (ipsync_vdoa_ipg_master_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3.
static const field_t hw_ccm_ccgr3[] =
{
    {
        "CG0",
        "csi core clock (csi_core_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "pxp axi clock (pxp_axi_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "epdc axi clock (epdc_axi_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "lcdif axi clock (lcdif_axi_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "ipu2_ipu_di0 clock (ipu2_ipu_di0_clk_enable)  lcdif_pix clock (lcdif_p"
        "ix_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "epdc_pix clock (epdc_pix_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "Reserved",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "Reserved",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "mmdc_core_aclk_fast_core_p0 clock (mmdc_core_aclk_fast_core_p0_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "Reserved",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "mmdc_core_ipg_clk_p0 clock (mmdc_core_ipg_clk_p0_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "mmdc_core_ipg_clk_p1 clock (mmdc_core_ipg_clk_p1_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "ocram clock (ocram_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4.
static const field_t hw_ccm_ccgr4[] =
{
    {
        "CG0",
        "Reserved",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "Reserved.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "pl301_mx6qfast1_s133 clock (pl301_mx6qfast1_s133clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "Reserved",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "pl301_mx6qper2_mainclk_enable (pl301_mx6qper2_mainclk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm1 clocks (pwm1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "pwm2 clocks (pwm2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "pwm3 clocks (pwm3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "pwm4 clocks (pwm4_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "rawnand_u_bch_input_apb clock (rawnand_u_bch_input_apb_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "rawnand_u_gpmi_bch_input_bch clock (rawnand_u_gpmi_bch_input_bch_clk_e"
        "nable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "rawnand_u_gpmi_bch_input_gpmi_io clock (rawnand_u_gpmi_bch_input_gpmi_"
        "io_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "rawnand_u_gpmi_input_apb clock rawnand_u_gpmi_input_apb_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5.
static const field_t hw_ccm_ccgr5[] =
{
    {
        "CG0",
        "rom clock (rom_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "100M clock (100M_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sdma clock (sdma_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "Reserved",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "spba clock (spba_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "spdif clock (spdif_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ssi1 clocks (ssi1_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ssi2 clocks (ssi2_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ssi3 clocks (ssi3_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "uart clock (uart_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "uart_serial clock (uart_serial_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6.
static const field_t hw_ccm_ccgr6[] =
{
    {
        "CG0",
        "usboh3 clock (usboh3_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "usdhc1 clocks (usdhc1_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "usdhc2 clocks (usdhc2_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "usdhc3 clocks (usdhc3_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "usdhc4 clocks (usdhc4_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "emi_slow clocks (emi_slow_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "vdoaxiclk root clock (vdoaxiclk_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "vpu clocks (vpu_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "Reserved",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "Reserved",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "Reserved",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CMEOR.
static const field_t hw_ccm_cmeor[] =
{
    {
        "MOD_EN_OV_VDOA",
        "overide clock enable signal from vdoa - clock will not be gated based "
        "on vdoa signal.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_GPT",
        "overide clock enable signal from gpt - clock will not be gated based o"
        "n gpt's signal 'ipg_enable_clk' .",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_EPIT",
        "overide clock enable signal from epit - clock will not be gated based "
        "on epit's signal 'ipg_enable_clk' .",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_USDHC",
        "overide clock enable signal from usdhc.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_DAP",
        "overide clock enable signal from dap- clock will not be gated based on"
        " dap's signal 'dap_dbgen' .",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_VPU",
        "overide clock enable signal from vpu- clock will not be gated based on"
        " vpu's signal 'vpu_idle' .",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_GPU2D",
        "overide clock enable signal from gpu2d - clock will not be gated based"
        " on gpu2d's signal 'gpu2d_busy' .",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_GPU3D",
        "overide clock enable signal from gpu3d - clock will not be gated based"
        " on gpu3d's signal.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN2_CPI",
        "overide clock enable signal from can2 - clock will not be gated based "
        "on can's signal 'enable_clk_cpi'.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN1_CPI",
        "overide clock enable signal from can1 - clock will not be gated based "
        "on can's signal 'enable_clk_cpi'.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM module.
static const reg_t hw_ccm[] =
{
    {
        "CCR",
        "The figure below represents the CCM Control Register (CCR), which cont"
        "ains bits to control general operation of CCM.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_ccr
    },
    {
        "CCDR",
        "The figure below represents the CCM Control Divider Register (CCDR), w"
        "hich contains bits that control the loading of the dividers that need "
        "handshake with the modules they affect.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_ccm_ccdr
    },
    {
        "CSR",
        "The figure below represents the CCM status Register (CSR).",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_ccm_csr
    },
    {
        "CCSR",
        "The figure below represents the CCM Clock Switcher register (CCSR).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_ccsr
    },
    {
        "CACRR",
        "The figure below represents the CCM Arm Clock Root register (CACRR).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_cacrr
    },
    {
        "CBCDR",
        "The figure below represents the CCM Bus Clock Divider Register (CBCDR)"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cbcdr
    },
    {
        "CBCMR",
        "The figure below represents the CCM Bus Clock Multiplexer Register (CB"
        "CMR).",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cbcmr
    },
    {
        "CSCMR1",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "1 (CSCMR1).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_cscmr1
    },
    {
        "CSCMR2",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "2 (CSCMR2).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_cscmr2
    },
    {
        "CSCDR1",
        "The figure below represents the CCM Serial Clock Divider Register 1 (C"
        "SCDR1).",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cscdr1
    },
    {
        "CS1CDR",
        "The figure below represents the CCM SSI1, SSI3, ESAI Clock Divider Reg"
        "ister (CS1CDR).",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cs1cdr
    },
    {
        "CS2CDR",
        "The figure below represents the CCM SSI2, LDB Clock Divider Register ("
        "CS2CDR).",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_cs2cdr
    },
    {
        "CDCDR",
        "The figure below represents the CCM DI Clock Divider Register (CDCDR).",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cdcdr
    },
    {
        "CHSCCDR",
        "The figure below represents the CCM IPU1 DI Clock Divider Register (CH"
        "SCCDR).",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_chsccdr
    },
    {
        "CSCDR2",
        "The figure below represents the CCM Serial Clock Divider Register 2(CS"
        "CDR2).",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cscdr2
    },
    {
        "CSCDR3",
        "The figure below represents the CCM Serial Clock Divider Register 3(CS"
        "CDR3).",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_cscdr3
    },
    {
        "CWDR",
        "The figure below represents the CCM Wakeup Detector Register (CWDR).",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_ccm_cwdr
    },
    {
        "CDHIPR",
        "The figure below represents the CCM Divider Handshake In-Process Regis"
        "ter (CDHIPR).",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_ccm_cdhipr
    },
    {
        "CTOR",
        "The figure below represents the CCM Testing Observability Register (CT"
        "OR).",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_ctor
    },
    {
        "CLPCR",
        "The figure below represents the CCM Low Power Control Register (CLPCR)"
        ".",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_clpcr
    },
    {
        "CISR",
        "The figure below represents the CCM Interrupt Status Register (CISR).",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cisr
    },
    {
        "CIMR",
        "The figure below represents the CCM Interrupt Mask Register (CIMR).",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cimr
    },
    {
        "CCOSR",
        "The figure below represents the CCM Clock Output Source Register (CCOS"
        "R).",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_ccosr
    },
    {
        "CGPR",
        "Fast PLL enable.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cgpr
    },
    {
        "CCGR0",
        "CG(i) bits CCGR 0-7  These bits are used to turn on/off the clock to e"
        "ach module independently.The following table details the possible cloc"
        "k activity conditions for each module         CGR value    Clock Activ"
        "ity Description        00    clock is off during all modes.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr0
    },
    {
        "CCGR1",
        "The figure below represents the CCM Clock Gating Register 1(CCM_CCGR1)"
        ".",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr1
    },
    {
        "CCGR2",
        "The figure below represents the CCM Clock Gating Register 2 (CCM_CCGR2"
        ").",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr2
    },
    {
        "CCGR3",
        "The figure below represents the CCM Clock Gating Register 3 (CCM_CCGR3"
        ").",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr3
    },
    {
        "CCGR4",
        "The figure below represents the CCM Clock Gating Register 4 (CCM_CCGR4"
        ").",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr4
    },
    {
        "CCGR5",
        "The figure below represents the CCM Clock Gating Register 5 (CCM_CCGR5"
        ").",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr5
    },
    {
        "CCGR6",
        "The figure below represents the CCM Clock Gating Register 6 (CCM_CCGR6"
        ").",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr6
    },
    {
        "CMEOR",
        "The follow figure represents the CCM Module Enable Override Register ("
        "CMEOR).",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cmeor
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM_ANALOG
#endif

// Bitfields in register CCM_ANALOG_PLL_ARM.
static const field_t hw_ccm_analog_pll_arm[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog debug bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_SEL",
        "Analog Debug Bit",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_24MHZ_SEL",
        "Analog Debug Bit",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_USB1.
static const field_t hw_ccm_analog_pll_usb1[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_USB2.
static const field_t hw_ccm_analog_pll_usb2[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_SYS.
static const field_t hw_ccm_analog_pll_sys[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog Debug bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_AUDIO.
static const field_t hw_ccm_analog_pll_audio[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog debug Bit",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSC_EN",
        "Reserved Bit",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_AUDIO_NUM.
static const field_t hw_ccm_analog_pll_audio_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_AUDIO_DENOM.
static const field_t hw_ccm_analog_pll_audio_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_VIDEO.
static const field_t hw_ccm_analog_pll_video[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog Debug bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSC_EN",
        "Revserved BIt",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked;  0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_VIDEO_NUM.
static const field_t hw_ccm_analog_pll_video_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider(Signed number), absolute v"
        "alue should be less than denominator",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_VIDEO_DENOM.
static const field_t hw_ccm_analog_pll_video_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_ENET.
static const field_t hw_ccm_analog_pll_enet[] =
{
    {
        "DIV_SELECT",
        "Controls the frequency of the ethernet reference clock.00 - 25MHz; 01 "
        "- 50MHz; 10 - 100MHz (not 50% duty cycle); 11 - 125MHz;",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog debug bit",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the ethernet clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_100M",
        "Enables an offset in the phase frequency detector.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PFD_480.
static const field_t hw_ccm_analog_pfd_480[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PFD_528.
static const field_t hw_ccm_analog_pfd_528[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_MISC0.
static const field_t hw_ccm_analog_misc0[] =
{
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        11, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_MISC2.
static const field_t hw_ccm_analog_misc2[] =
{
    {
        "PLL3_DISABLE",
        "Default value of \"0\".",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL: 0x0=div-by-1(default), 0x1=div-by-2"
        ", 0x2=div-by-1, 0x3=div-by-4.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL: 0x0=div-by-1(default), 0x1=div-by-2"
        ", 0x2=div-by-1, 0x3=div-by-4.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video: 0x0=div-by-1(default), 0x1=div-by-2, 0x2=div-b"
        "y-1, 0x3=div-by-4.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM_ANALOG module.
static const reg_t hw_ccm_analog[] =
{
    {
        "PLL_ARM",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_arm
    },
    {
        "PLL_USB1",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_pll_usb1
    },
    {
        "PLL_USB2",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_pll_usb2
    },
    {
        "PLL_SYS",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_pll_sys
    },
    {
        "PLL_AUDIO",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_audio
    },
    {
        "PLL_AUDIO_NUM",
        "This register contains the numerator (A) of Audio PLL fractional loop "
        "divider.(Signed number), absolute value should be less than denominato"
        "r  Absolute value should be less than denominator",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_audio_num
    },
    {
        "PLL_AUDIO_DENOM",
        "This register contains the Denominator (B) of Audio PLL fractional loo"
        "p divider.(unsigned number)",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_audio_denom
    },
    {
        "PLL_VIDEO",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_video
    },
    {
        "PLL_VIDEO_NUM",
        "This register contains the numerator (A) of Video PLL fractional loop "
        "divider.(Signed number)  Absolute value should be less than denominato"
        "r",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_video_num
    },
    {
        "PLL_VIDEO_DENOM",
        "This register contains the Denominator (B) of Video PLL fractional loo"
        "p divider.(Unsigned number)",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_video_denom
    },
    {
        "PLL_ENET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_enet
    },
    {
        "PFD_480",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_pfd_480
    },
    {
        "PFD_528",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_pfd_528
    },
    {
        "MISC0",
        "This register defines the control for miscellaneous CCM Analog blocks.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_misc0
    },
    {
        "MISC2",
        "This register defines the control for miscellaneous CCM Analog blocks.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_analog_misc2
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CSI
#endif

// Bitfields in register CSI_CSICR1.
static const field_t hw_csi_csicr1[] =
{
    {
        "PIXEL_BIT",
        "Pixel Bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REDGE",
        "Valid Pixel Clock Edge Select.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_PCLK",
        "Invert Pixel Clock Input.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_DATA",
        "Invert Data Input.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GCLK_MODE",
        "Gated Clock Mode Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_RXFIFO",
        "Asynchronous RXFIFO Clear.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_STATFIFO",
        "Asynchronous STATFIFO Clear.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PACK_DIR",
        "Data Packing Direction.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCC",
        "FIFO Clear Control.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CCIR_EN",
        "CCIR656 Interface Enable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_POL",
        "HSYNC Polarity Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INTEN",
        "Start Of Frame (SOF) Interrupt Enable.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_POL",
        "SOF Interrupt Polarity.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INTEN",
        "RxFIFO Full Interrupt Enable.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB1_DMA_DONE_INTEN",
        "Frame Buffer1 DMA Transfer Done Interrupt Enable.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB2_DMA_DONE_INTEN",
        "Frame Buffer2 DMA Transfer Done Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INTEN",
        "STATFIFO Full Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFF_DMA_DONE_INTEN",
        "STATFIFO DMA Transfer Done Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INTEN",
        "RxFIFO Overrun Interrupt Enable.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INTEN",
        "STAT FIFO Overrun Interrupt Enable.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT_EN",
        "Change Of Image Field (COF) Interrupt Enable.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CCIR_MODE",
        "CCIR Mode Select.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRP_IF_EN",
        "CSI-PrP Interface Enable.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT_EN",
        "End-of-Frame Interrupt Enable.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXT_VSYNC",
        "External VSYNC Enable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWAP16_EN",
        "SWAP 16-Bit Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR2.
static const field_t hw_csi_csicr2[] =
{
    {
        "HSC",
        "Horizontal Skip Count.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSC",
        "Vertical Skip Count.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVRM",
        "Live View Resolution Mode.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BTS",
        "Bayer Tile Start.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCE",
        "Skip Count Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFS",
        "Auto Focus Spread.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRM",
        "Double Resolution Mode.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_SFF",
        "Burst Type of DMA Transfer from STATFIFO.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_RFF",
        "Burst Type of DMA Transfer from RxFIFO.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR3.
static const field_t hw_csi_csicr3[] =
{
    {
        "ECC_AUTO_EN",
        "Automatic Error Correction Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT_EN",
        "Error Detection Interrupt Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZERO_PACK_EN",
        "Dummy Zero Packing Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWO_8BIT_SENSOR",
        "Two 8-bit Sensor Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_LEVEL",
        "RxFIFO Full Level .",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_EN",
        "Hresponse Error Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_LEVEL",
        "STATFIFO Full Level.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_SFF",
        "DMA Request Enable for STATFIFO.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_RFF",
        "DMA Request Enable for RxFIFO.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_SFF",
        "Reflash DMA Controller for STATFIFO.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_RFF",
        "Reflash DMA Controller for RxFIFO.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT_RST",
        "Frame Count Reset.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT",
        "Frame Counter.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISTATFIFO.
static const field_t hw_csi_csistatfifo[] =
{
    {
        "STAT",
        "Static data from sensor",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRFIFO.
static const field_t hw_csi_csirfifo[] =
{
    {
        "IMAGE",
        "Received image data",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRXCNT.
static const field_t hw_csi_csirxcnt[] =
{
    {
        "RXCNT",
        "RxFIFO Count.",
        0, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISR.
static const field_t hw_csi_csisr[] =
{
    {
        "DRDY",
        "RXFIFO Data Ready.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT",
        "CCIR Error Interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_INT",
        "Hresponse Error Interrupt Status.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT",
        "Change Of Field Interrupt Status.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F1_INT",
        "CCIR Field 1 Interrupt Status.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F2_INT",
        "CCIR Field 2 Interrupt Status.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INT",
        "Start of Frame Interrupt Status.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT",
        "End of Frame (EOF) Interrupt Status.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INT",
        "RXFIFO Full Interrupt Status.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB1",
        "DMA Transfer Done in Frame Buffer1.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB2",
        "DMA Transfer Done in Frame Buffer2.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INT",
        "STATFIFO Full Interrupt Status.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_SFF",
        "DMA Transfer Done from StatFIFO.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INT",
        "RxFIFO Overrun Interrupt Status.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INT",
        "STATFIFO Overrun Interrupt Status.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_STATFIFO.
static const field_t hw_csi_csidmasa_statfifo[] =
{
    {
        "DMA_START_ADDR_SFF",
        "DMA Start Address for STATFIFO.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMATS_STATFIFO.
static const field_t hw_csi_csidmats_statfifo[] =
{
    {
        "DMA_TSF_SIZE_SFF",
        "DMA Transfer Size for STATFIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB1.
static const field_t hw_csi_csidmasa_fb1[] =
{
    {
        "DMA_START_ADDR_FB1",
        "DMA Start Address in Frame Buffer1.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB2.
static const field_t hw_csi_csidmasa_fb2[] =
{
    {
        "DMA_START_ADDR_FB2",
        "DMA Start Address in Frame Buffer2.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIFBUF_PARA.
static const field_t hw_csi_csifbuf_para[] =
{
    {
        "FBUF_STRIDE",
        "Frame Buffer Parameter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIIMAG_PARA.
static const field_t hw_csi_csiimag_para[] =
{
    {
        "IMAGE_HEIGHT",
        "Image Height.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMAGE_WIDTH",
        "Image Width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CSI module.
static const reg_t hw_csi[] =
{
    {
        "CSICR1",
        "This register controls the sensor interface timing and interrupt gener"
        "ation.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_csi_csicr1
    },
    {
        "CSICR2",
        "This register provides the statistic block with data about which live "
        "view resolution is being used, and the starting sensor pixel of the Ba"
        "yer pattern.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_csi_csicr2
    },
    {
        "CSICR3",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1, adding additional control and features.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_csi_csicr3
    },
    {
        "CSISTATFIFO",
        "The StatFIFO is a read-only register containing statistic data from th"
        "e sensor.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csistatfifo
    },
    {
        "CSIRFIFO",
        "This read-only register contains received image data.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csirfifo
    },
    {
        "CSIRXCNT",
        "This register works for EOF interrupt generation.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csirxcnt
    },
    {
        "CSISR",
        "This read/write register shows sensor interface status, and which kind"
        " of interrupt is being generated.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_csi_csisr
    },
    {
        "CSIDMASA_STATFIFO",
        "This register provides the start address for the embedded DMA controll"
        "er of STATFIFO.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_statfifo
    },
    {
        "CSIDMATS_STATFIFO",
        "This register provides the total transfer size for the embedded DMA co"
        "ntroller of STATFIFO.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmats_statfifo
    },
    {
        "CSIDMASA_FB1",
        "This register provides the start address in the frame buffer1 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb1
    },
    {
        "CSIDMASA_FB2",
        "This register provides the start address in the frame buffer2 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb2
    },
    {
        "CSIFBUF_PARA",
        "This register provides the stride of the frame buffer to show how many"
        " words to skip before starting to write the next row of the image.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csifbuf_para
    },
    {
        "CSIIMAG_PARA",
        "This register provides the width and the height of the image from the "
        "sensor.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csi_csiimag_para
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CSU
#endif

// Bitfields in register CSU_CSL0.
static const field_t hw_csu_csl0[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL1.
static const field_t hw_csu_csl1[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL2.
static const field_t hw_csu_csl2[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL3.
static const field_t hw_csu_csl3[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL4.
static const field_t hw_csu_csl4[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL5.
static const field_t hw_csu_csl5[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL6.
static const field_t hw_csu_csl6[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL7.
static const field_t hw_csu_csl7[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL8.
static const field_t hw_csu_csl8[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL9.
static const field_t hw_csu_csl9[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL10.
static const field_t hw_csu_csl10[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL11.
static const field_t hw_csu_csl11[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL12.
static const field_t hw_csu_csl12[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL13.
static const field_t hw_csu_csl13[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL14.
static const field_t hw_csu_csl14[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL15.
static const field_t hw_csu_csl15[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL16.
static const field_t hw_csu_csl16[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL17.
static const field_t hw_csu_csl17[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL18.
static const field_t hw_csu_csl18[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL19.
static const field_t hw_csu_csl19[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL20.
static const field_t hw_csu_csl20[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL21.
static const field_t hw_csu_csl21[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL22.
static const field_t hw_csu_csl22[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL23.
static const field_t hw_csu_csl23[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL24.
static const field_t hw_csu_csl24[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL25.
static const field_t hw_csu_csl25[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL26.
static const field_t hw_csu_csl26[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL27.
static const field_t hw_csu_csl27[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL28.
static const field_t hw_csu_csl28[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL29.
static const field_t hw_csu_csl29[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL30.
static const field_t hw_csu_csl30[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL31.
static const field_t hw_csu_csl31[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL32.
static const field_t hw_csu_csl32[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL33.
static const field_t hw_csu_csl33[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL34.
static const field_t hw_csu_csl34[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL35.
static const field_t hw_csu_csl35[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL36.
static const field_t hw_csu_csl36[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL37.
static const field_t hw_csu_csl37[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL38.
static const field_t hw_csu_csl38[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL39.
static const field_t hw_csu_csl39[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_HP0.
static const field_t hw_csu_hp0[] =
{
    {
        "HP",
        "Privilege indicator bits",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L",
        "Lock bit set by secure software",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP1",
        "Privilege indicator bits",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L1",
        "Lock bit set by secure software",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP2",
        "Privilege indicator bits",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2",
        "Lock bit set by secure software",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP3",
        "Privilege indicator bits",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L3",
        "Lock bit set by secure software",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP4",
        "Privilege indicator bits",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L4",
        "Lock bit set by secure software",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP5",
        "Privilege indicator bits",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L5",
        "Lock bit set by secure software",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP6",
        "Privilege indicator bits",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L6",
        "Lock bit set by secure software",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP7",
        "Privilege indicator bits",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L7",
        "Lock bit set by secure software",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP8",
        "Privilege indicator bits",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L8",
        "Lock bit set by secure software",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP9",
        "Privilege indicator bits",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L9",
        "Lock bit set by secure software",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP10",
        "Privilege indicator bits",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L10",
        "Lock bit set by secure software",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP11",
        "Privilege indicator bits",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L11",
        "Lock bit set by secure software",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP12",
        "Privilege indicator bits",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L12",
        "Lock bit set by secure software",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP13",
        "Privilege indicator bits",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L13",
        "Lock bit set by secure software",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP14",
        "Privilege indicator bits",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L14",
        "Lock bit set by secure software",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP15",
        "Privilege indicator bits",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L15",
        "Lock bit set by secure software",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_HP1.
static const field_t hw_csu_hp1[] =
{
    {
        "HP",
        "Privilege indicator bits",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L",
        "Lock bit set by secure software",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP1",
        "Privilege indicator bits",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L1",
        "Lock bit set by secure software",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP2",
        "Privilege indicator bits",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2",
        "Lock bit set by secure software",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP3",
        "Privilege indicator bits",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L3",
        "Lock bit set by secure software",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP4",
        "Privilege indicator bits",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L4",
        "Lock bit set by secure software",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP5",
        "Privilege indicator bits",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L5",
        "Lock bit set by secure software",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP6",
        "Privilege indicator bits",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L6",
        "Lock bit set by secure software",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP7",
        "Privilege indicator bits",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L7",
        "Lock bit set by secure software",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP8",
        "Privilege indicator bits",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L8",
        "Lock bit set by secure software",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP9",
        "Privilege indicator bits",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L9",
        "Lock bit set by secure software",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP10",
        "Privilege indicator bits",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L10",
        "Lock bit set by secure software",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP11",
        "Privilege indicator bits",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L11",
        "Lock bit set by secure software",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP12",
        "Privilege indicator bits",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L12",
        "Lock bit set by secure software",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP13",
        "Privilege indicator bits",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L13",
        "Lock bit set by secure software",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP14",
        "Privilege indicator bits",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L14",
        "Lock bit set by secure software",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP15",
        "Privilege indicator bits",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L15",
        "Lock bit set by secure software",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_SA.
static const field_t hw_csu_sa[] =
{
    {
        "NSA",
        "Non-Secure Access Policy indicator bits",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L",
        "Lock bit set by secure software",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA1",
        "Non-Secure Access Policy indicator bits",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L1",
        "Lock bit set by secure software",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA2",
        "Non-Secure Access Policy indicator bits",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2",
        "Lock bit set by secure software",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA3",
        "Non-Secure Access Policy indicator bits",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L3",
        "Lock bit set by secure software",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA4",
        "Non-Secure Access Policy indicator bits",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L4",
        "Lock bit set by secure software",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA5",
        "Non-Secure Access Policy indicator bits",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L5",
        "Lock bit set by secure software",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA6",
        "Non-Secure Access Policy indicator bits",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L6",
        "Lock bit set by secure software",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA7",
        "Non-Secure Access Policy indicator bits",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L7",
        "Lock bit set by secure software",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA8",
        "Non-Secure Access Policy indicator bits",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L8",
        "Lock bit set by secure software",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA9",
        "Non-Secure Access Policy indicator bits",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L9",
        "Lock bit set by secure software",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA10",
        "Non-Secure Access Policy indicator bits",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L10",
        "Lock bit set by secure software",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA11",
        "Non-Secure Access Policy indicator bits",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L11",
        "Lock bit set by secure software",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA12",
        "Non-Secure Access Policy indicator bits",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L12",
        "Lock bit set by secure software",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA13",
        "Non-Secure Access Policy indicator bits",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L13",
        "Lock bit set by secure software",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA14",
        "Non-Secure Access Policy indicator bits",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L14",
        "Lock bit set by secure software",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA15",
        "Non-Secure Access Policy indicator bits",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L15",
        "Lock bit set by secure software",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CSU module.
static const reg_t hw_csu[] =
{
    {
        "CSL0",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl0
    },
    {
        "CSL1",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl1
    },
    {
        "CSL2",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl2
    },
    {
        "CSL3",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl3
    },
    {
        "CSL4",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl4
    },
    {
        "CSL5",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl5
    },
    {
        "CSL6",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl6
    },
    {
        "CSL7",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl7
    },
    {
        "CSL8",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl8
    },
    {
        "CSL9",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl9
    },
    {
        "CSL10",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl10
    },
    {
        "CSL11",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl11
    },
    {
        "CSL12",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl12
    },
    {
        "CSL13",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl13
    },
    {
        "CSL14",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl14
    },
    {
        "CSL15",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl15
    },
    {
        "CSL16",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl16
    },
    {
        "CSL17",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl17
    },
    {
        "CSL18",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl18
    },
    {
        "CSL19",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl19
    },
    {
        "CSL20",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl20
    },
    {
        "CSL21",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl21
    },
    {
        "CSL22",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl22
    },
    {
        "CSL23",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl23
    },
    {
        "CSL24",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl24
    },
    {
        "CSL25",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl25
    },
    {
        "CSL26",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl26
    },
    {
        "CSL27",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl27
    },
    {
        "CSL28",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl28
    },
    {
        "CSL29",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl29
    },
    {
        "CSL30",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl30
    },
    {
        "CSL31",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl31
    },
    {
        "CSL32",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl32
    },
    {
        "CSL33",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl33
    },
    {
        "CSL34",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl34
    },
    {
        "CSL35",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl35
    },
    {
        "CSL36",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl36
    },
    {
        "CSL37",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl37
    },
    {
        "CSL38",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl38
    },
    {
        "CSL39",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl39
    },
    {
        "HP0",
        "The HP register may be programmed to determine the privilege (either U"
        "ser Mode or Supervisor Mode) for up to sixteen different masters.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_csu_hp0
    },
    {
        "HP1",
        "The HP register may be programmed to determine the privilege (either U"
        "ser Mode or Supervisor Mode) for up to sixteen different masters.",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_csu_hp1
    },
    {
        "SA",
        "The Secure Access register may be programmed to specify the access pol"
        "icy (either Secure or Non-secure) for up to sixteen different masters.",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_csu_sa
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DBGMON
#endif

// Bitfields in register DBGMON_HW_DBGMON_CTRL.
static const field_t hw_dbgmon_hw_dbgmon_ctrl[] =
{
    {
        "RUN",
        "Set this bit to one to enable the DBGMON operation",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SNAP",
        "Set this bit to snapshot the registers selected by REQSEL to SNVS doma"
        "in registers",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR",
        "Set this bit to clear the registers in SOC domain.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_SNVS",
        "Set this bit to clear the registers in SNVS domain",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDR_TRAPMODE",
        "The bit defines the address trap function.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ID_TRAPMODE",
        "The bit defines the ID trap function.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REQSEL",
        "This field defines which sets of AXI transaction will be snaped to SNV"
        "S domain registers.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WORKMODE",
        "This field defines whether ignore the transaction in IRQ",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDR_MASKEN",
        "This field control the address mask function,",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_IRQ_SEL",
        "Select the source of WDOG IRQ.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal oepration.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set to zero for normal operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_MASTER_EN.
static const field_t hw_dbgmon_hw_dbgmon_master_en[] =
{
    {
        "MID0",
        "Set to 1 to enable monitoring on MasterID 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID1",
        "Set to 1 to enable monitoring on MasterID 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID2",
        "Set to 1 to enable monitoring on MasterID 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID3",
        "Set to 1 to enable monitoring on MasterID 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID4",
        "Set to 1 to enable monitoring on MasterID 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID5",
        "Set to 1 to enable monitoring on MasterID 5",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID6",
        "Set to 1 to enable monitoring on MasterID 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID7",
        "Set to 1 to enable monitoring on MasterID 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID8",
        "Set to 1 to enable monitoring on MasterID 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID9",
        "Set to 1 to enable monitoring on MasterID 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID10",
        "Set to 1 to enable monitoring on MasterID 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID11",
        "Set to 1 to enable monitoring on MasterID 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID12",
        "Set to 1 to enable monitoring on MasterID 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID13",
        "Set to 1 to enable monitoring on MasterID 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID14",
        "Set to 1 to enable monitoring on MasterID 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MID15",
        "Set to 1 to enable monitoring on MasterID 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_IRQ.
static const field_t hw_dbgmon_hw_dbgmon_irq[] =
{
    {
        "ADDR_TRAP_IRQEN",
        "Address trap interrupt control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ID_TRAP_IRQEN",
        "ID trap interrupt control.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDR_TRAP_IRQ",
        "This bit indicates the Address trap interrupt is happening.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ID_TRAP_IRQ",
        "This bit indicates the ID trap interrupt is happening.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_MID",
        "This field indicate which master sends the interrupt, will not update "
        "until all interrupts are cleared.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_TRAP_ADDR_LOW.
static const field_t hw_dbgmon_hw_dbgmon_trap_addr_low[] =
{
    {
        "ADDRESS",
        "This field contains 32-bit low address for the address trap range",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_TRAP_ADDR_HIGH.
static const field_t hw_dbgmon_hw_dbgmon_trap_addr_high[] =
{
    {
        "ADDRESS",
        "This field contains 32-bit high address for the address trap range",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_TRAP_ID.
static const field_t hw_dbgmon_hw_dbgmon_trap_id[] =
{
    {
        "TRAP_ID_LOW",
        "This field contains 16-bit low ID for ID trap range",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRAP_ID_HIGH",
        "This field contains 16-bit high ID for ID trap range",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_SNVS_ADDR.
static const field_t hw_dbgmon_hw_dbgmon_snvs_addr[] =
{
    {
        "ADDR",
        "This field contains 32-bit Address in SNVS domain register",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_SNVS_DATA.
static const field_t hw_dbgmon_hw_dbgmon_snvs_data[] =
{
    {
        "DATA",
        "This field contains 32-bit Data of AXI transaction in SNVS domain regi"
        "ster",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_SNVS_INFO.
static const field_t hw_dbgmon_hw_dbgmon_snvs_info[] =
{
    {
        "COMPLETE",
        "The field indicates whether the AXI transaction in SNVS domain complet"
        "e.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDWR",
        "The field indicates the read/write attribute of AXI transaction in SNV"
        "S domain.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ID",
        "The field contain the ID of the AXI transaction in SNVS domain",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DBGMON_HW_DBGMON_VERSION.
static const field_t hw_dbgmon_hw_dbgmon_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DBGMON module.
static const reg_t hw_dbgmon[] =
{
    {
        "HW_DBGMON_CTRL",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_dbgmon_hw_dbgmon_ctrl
    },
    {
        "HW_DBGMON_MASTER_EN",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_dbgmon_hw_dbgmon_master_en
    },
    {
        "HW_DBGMON_IRQ",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_dbgmon_hw_dbgmon_irq
    },
    {
        "HW_DBGMON_TRAP_ADDR_LOW",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dbgmon_hw_dbgmon_trap_addr_low
    },
    {
        "HW_DBGMON_TRAP_ADDR_HIGH",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dbgmon_hw_dbgmon_trap_addr_high
    },
    {
        "HW_DBGMON_TRAP_ID",
        "",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dbgmon_hw_dbgmon_trap_id
    },
    {
        "HW_DBGMON_SNVS_ADDR",
        "",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dbgmon_hw_dbgmon_snvs_addr
    },
    {
        "HW_DBGMON_SNVS_DATA",
        "",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dbgmon_hw_dbgmon_snvs_data
    },
    {
        "HW_DBGMON_SNVS_INFO",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_dbgmon_hw_dbgmon_snvs_info
    },
    {
        "HW_DBGMON_VERSION",
        "",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_dbgmon_hw_dbgmon_version
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DCP
#endif

// Bitfields in register DCP_CTRL.
static const field_t hw_dcp_ctrl[] =
{
    {
        "CHANNEL_INTERRUPT_ENABLE",
        "Per-channel interrupt enable bit.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_CONTEXT_SWITCHING",
        "Enable automatic context switching for the channels.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_CONTEXT_CACHING",
        "Software should set this bit to enable caching of contexts between ope"
        "rations.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GATHER_RESIDUAL_WRITES",
        "Software should set this bit to enable ragged writes to unaligned buff"
        "ers to be gathered between multiple write operations.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESENT_SHA",
        "Indicates whether the SHA1/SHA2 functions are present.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PRESENT_CRYPTO",
        "Indicates whether the crypto (Cipher/Hash) functions are present.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal DCP operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_STAT.
static const field_t hw_dcp_stat[] =
{
    {
        "IRQ",
        "Indicates which channels have pending interrupt requests.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "READY_CHANNELS",
        "Indicates which channels are ready to proceed with a transfer (active "
        "channel also included).",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CUR_CHANNEL",
        "Current (active) channel (encoded).",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OTP_KEY_READY",
        "When set, indicates that the OTP key has been shifted from the fuse bl"
        "ock and is ready for use.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CHANNELCTRL.
static const field_t hw_dcp_channelctrl[] =
{
    {
        "ENABLE_CHANNEL",
        "Setting a bit in this field will enabled the DMA channel associated wi"
        "th it.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HIGH_PRIORITY_CHANNEL",
        "Setting a bit in this field causes the corresponding channel to have h"
        "igh-priority arbitration.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_IRQ_MERGED",
        "Indicates that the interrupt for channel 0 should be merged with the o"
        "ther interrupts on the shared dcp_irq interrupt.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CAPABILITY0.
static const field_t hw_dcp_capability0[] =
{
    {
        "NUM_KEYS",
        "Encoded value indicating the number of key storage locations implement"
        "ed in the design.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_CHANNELS",
        "Encoded value indicating the number of channels implemented in the des"
        "ign.",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DISABLE_UNIQUE_KEY",
        "Write to a 1 disable the per-device unique key.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_DECRYPT",
        "Write to a 1 to disable decryption.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CAPABILITY1.
static const field_t hw_dcp_capability1[] =
{
    {
        "CIPHER_ALGORITHMS",
        "One-hot field indicating which cipher algorithms are available.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_ALGORITHMS",
        "One-hot field indicating which hashing features are implemented in HW.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CONTEXT.
static const field_t hw_dcp_context[] =
{
    {
        "ADDR",
        "Context pointer address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_KEY.
static const field_t hw_dcp_key[] =
{
    {
        "SUBWORD",
        "Key subword pointer.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INDEX",
        "Key index pointer.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_KEYDATA.
static const field_t hw_dcp_keydata[] =
{
    {
        "DATA",
        "Word 0 data for key.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET0.
static const field_t hw_dcp_packet0[] =
{
    {
        "ADDR",
        "Next Pointer Register,",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET1.
static const field_t hw_dcp_packet1[] =
{
    {
        "INTERRUPT",
        "Reflects whether the channel should issue an interrupt upon completion"
        " of the packet.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DECR_SEMAPHORE",
        "Reflects whether the channel's semaphore should be decremented at the "
        "end of the current operation.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "Reflects whether the next command pointer register should be loaded in"
        "to the channel's current descriptor pointer.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN_CONTIGUOUS",
        "Reflects whether the next packet's address is located following this p"
        "acket's payload.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_MEMCOPY",
        "Reflects whether the selected hashing function should be enabled for t"
        "his operation.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_CIPHER",
        "Reflects whether the selected cipher function should be enabled for th"
        "is operation.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_HASH",
        "Reflects whether the selected hashing function should be enabled for t"
        "his operation.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_BLIT",
        "Reflects whether the DCP should perform a blit operation.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CIPHER_ENCRYPT",
        "When the cipher block is enabled, this bit indicates whether the opera"
        "tion is encryption or decryption.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CIPHER_INIT",
        "Reflects whether the cipher block should load the initialization vecto"
        "r from the payload for this operation.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OTP_KEY",
        "Reflects whether a hardware-based key should be used.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PAYLOAD_KEY",
        "When set, indicates the payload contains the key.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_INIT",
        "Reflects whether the current hashing block is the initial block in the"
        " hashing operation, so the hash registers should be initialized before"
        " the operation.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_TERM",
        "Reflects whether the current hashing block is the final block in the h"
        "ashing operation, so the hash padding should be applied by hardware.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHECK_HASH",
        "Reflects whether the calculated hash value should be compared against "
        "the hash provided in the payload.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_OUTPUT",
        "When hashing is enabled, this bit controls whether the input or output"
        " data is hashed.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CONSTANT_FILL",
        "When this bit is set (MEMCOPY and BLIT modes only), the DCP will simpl"
        "y fill the destination buffer with the value found in the  Source Addr"
        "ess field.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEST_SEMA_IRQ",
        "This bit is used to test the channel semaphore transition to 0.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KEY_BYTESWAP",
        "Reflects whether the DCP engine will swap key bytes (big-endian key).",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KEY_WORDSWAP",
        "Reflects whether the DCP engine will swap key words (big-endian key).",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INPUT_BYTESWAP",
        "Reflects whether the DCP engine will byteswap input data (big-endian d"
        "ata).",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INPUT_WORDSWAP",
        "Reflects whether the DCP engine will wordswap input data (big-endian d"
        "ata).",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTPUT_BYTESWAP",
        "Reflects whether the DCP engine will byteswap output data (big-endian "
        "data).",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTPUT_WORDSWAP",
        "Reflects whether the DCP engine will wordswap output data (big-endian "
        "data).",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TAG",
        "Packet Tag",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET2.
static const field_t hw_dcp_packet2[] =
{
    {
        "CIPHER_SELECT",
        "Cipher Selection Field",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CIPHER_MODE",
        "Cipher Mode Selection Field.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KEY_SELECT",
        "Key Selection Field.",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_SELECT",
        "Hash Selection Field",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CIPHER_CFG",
        "Cipher configuration bits.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET3.
static const field_t hw_dcp_packet3[] =
{
    {
        "ADDR",
        "Source Buffer Address Pointer.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET4.
static const field_t hw_dcp_packet4[] =
{
    {
        "ADDR",
        "Destination Buffer Address Pointer.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET5.
static const field_t hw_dcp_packet5[] =
{
    {
        "COUNT",
        "Byte Count register.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET6.
static const field_t hw_dcp_packet6[] =
{
    {
        "ADDR",
        "This regiser reflects the payload pointer for the current control pack"
        "et.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0CMDPTR.
static const field_t hw_dcp_ch0cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 0.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0SEMA.
static const field_t hw_dcp_ch0sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0STAT.
static const field_t hw_dcp_ch0stat[] =
{
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware has detected an invalid programmi"
        "ng configuration such as a buffer length that is not a multiple of the"
        " natural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a a bus error occurred when reading the packet"
        " or payload or when writing status back to the packet payload.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0OPTS.
static const field_t hw_dcp_ch0opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1CMDPTR.
static const field_t hw_dcp_ch1cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 1.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1SEMA.
static const field_t hw_dcp_ch1sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1STAT.
static const field_t hw_dcp_ch1stat[] =
{
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware detected an invalid programming c"
        "onfiguration such as a buffer length that is not a multiple of the nat"
        "ural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a bus error occurs when reading the packet or "
        "payload or when writing status back to the packet paylaod.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1OPTS.
static const field_t hw_dcp_ch1opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2CMDPTR.
static const field_t hw_dcp_ch2cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 2.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2SEMA.
static const field_t hw_dcp_ch2sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2STAT.
static const field_t hw_dcp_ch2stat[] =
{
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware detected an invalid programming c"
        "onfiguration such as a buffer length that is not a multiple of the nat"
        "ural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a bus error occurred when reading the packet o"
        "r payload or when writing status back to the packet paylaod.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2OPTS.
static const field_t hw_dcp_ch2opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3CMDPTR.
static const field_t hw_dcp_ch3cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 3.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3SEMA.
static const field_t hw_dcp_ch3sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3STAT.
static const field_t hw_dcp_ch3stat[] =
{
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware detected an invalid programming c"
        "onfiguration such as a buffer length that is not a multiple of the nat"
        "ural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a bus error occurred when reading the packet o"
        "r payload or when writing status back to the packet paylaod.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3OPTS.
static const field_t hw_dcp_ch3opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_DBGSELECT.
static const field_t hw_dcp_dbgselect[] =
{
    {
        "INDEX",
        "Selects a value to read via the debug data register.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_DBGDATA.
static const field_t hw_dcp_dbgdata[] =
{
    {
        "DATA",
        "Debug Data",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PAGETABLE.
static const field_t hw_dcp_pagetable[] =
{
    {
        "ENABLE",
        "Page Table Enable control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FLUSH",
        "Page Table Flush control.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASE",
        "Page Table Base Address.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_VERSION.
static const field_t hw_dcp_version[] =
{
    {
        "STEP",
        "Fixed read-onlyl value reflecting the stepping of version of the desig"
        "n implementation.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-onlyl value reflecting the MINOR version of the design impl"
        "ementation.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-onlyl value reflecting the MAJOR version of the design impl"
        "ementation.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DCP module.
static const reg_t hw_dcp[] =
{
    {
        "CTRL",
        "The CTRL register contains controls for the DCP module.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_dcp_ctrl
    },
    {
        "STAT",
        "The DCP Interrupt Status register provides channel interrupt status in"
        "formation.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dcp_stat
    },
    {
        "CHANNELCTRL",
        "The DCP Channel Control register provides controls for channel arbitra"
        "tion and channel enables.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dcp_channelctrl
    },
    {
        "CAPABILITY0",
        "This register contains additional information about the DCP module imp"
        "lementation parameters.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dcp_capability0
    },
    {
        "CAPABILITY1",
        "This register contains information about the algorithms available on t"
        "he implementation.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_dcp_capability1
    },
    {
        "CONTEXT",
        "This register contains a pointer to the memory region to be used for D"
        "CP context swap operations.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_context
    },
    {
        "KEY",
        "This register contains a pointer to the key location to be written.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_key
    },
    {
        "KEYDATA",
        "This register provides write access to the key/key subword specified b"
        "y the Key Index Register.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_keydata
    },
    {
        "PACKET0",
        "This register displays the values for the current work packet offset 0"
        "x00 (Next Command) field.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet0
    },
    {
        "PACKET1",
        "This register displays the values for the current work packet offset 0"
        "x04 (control) field.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        false, // Writable
        25, // Number of bitfields
        hw_dcp_packet1
    },
    {
        "PACKET2",
        "This register displays the values for the current work packet offset 0"
        "x08 (Control1) field.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_dcp_packet2
    },
    {
        "PACKET3",
        "This register displays the values for the current work packet offset 0"
        "x0C (Source Address) field.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet3
    },
    {
        "PACKET4",
        "This register displays the values for the current work packet offset 0"
        "x10 (Destination Address) field.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet4
    },
    {
        "PACKET5",
        "This register displays the values for the current work packet offset 0"
        "x14 (Buffer Size) field.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet5
    },
    {
        "PACKET6",
        "This register displays the values for the current work packet offset 0"
        "x1C (Payload Pointer) field.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet6
    },
    {
        "CH0CMDPTR",
        "The DCP channel 0 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch0cmdptr
    },
    {
        "CH0SEMA",
        "The DCP Channel 0 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch0sema
    },
    {
        "CH0STAT",
        "The DCP Channel 0 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_dcp_ch0stat
    },
    {
        "CH0OPTS",
        "The DCP Channel 0 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch0opts
    },
    {
        "CH1CMDPTR",
        "The DCP channel 1 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch1cmdptr
    },
    {
        "CH1SEMA",
        "The DCP Channel 1 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch1sema
    },
    {
        "CH1STAT",
        "The DCP Channel 1 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_dcp_ch1stat
    },
    {
        "CH1OPTS",
        "The DCP Channel 1 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch1opts
    },
    {
        "CH2CMDPTR",
        "The DCP channel 2 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch2cmdptr
    },
    {
        "CH2SEMA",
        "The DCP Channel 2 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch2sema
    },
    {
        "CH2STAT",
        "The DCP Channel 2 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_dcp_ch2stat
    },
    {
        "CH2OPTS",
        "The DCP Channel 2 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch2opts
    },
    {
        "CH3CMDPTR",
        "The DCP channel 3 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch3cmdptr
    },
    {
        "CH3SEMA",
        "The DCP Channel 3 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000001d0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch3sema
    },
    {
        "CH3STAT",
        "The DCP Channel 3 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_dcp_ch3stat
    },
    {
        "CH3OPTS",
        "The DCP Channel 3 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch3opts
    },
    {
        "DBGSELECT",
        "This register selects a debug register to view.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_dbgselect
    },
    {
        "DBGDATA",
        "Reading this register returns the debug data value from the selected i"
        "ndex.",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_dbgdata
    },
    {
        "PAGETABLE",
        "The DCP Page Table register controls the virtual memory functionality "
        "of the DCP.",
        4, // Width in bytes
        0x00000420, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dcp_pagetable
    },
    {
        "VERSION",
        "Read-only register indicating implemented version of the DCP.",
        4, // Width in bytes
        0x00000430, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_dcp_version
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DVFSC
#endif

// Bitfields in register DVFSC_THRS.
static const field_t hw_dvfsc_thrs[] =
{
    {
        "PNCTHR",
        "Panic threshold for load tracking",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DWTHR",
        "Down threshold for load tracking",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPTHR",
        "Upper threshold for load tracking",
        22, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_COUN.
static const field_t hw_dvfsc_coun[] =
{
    {
        "UPCNT",
        "UP counter threshold value",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DN_CNT",
        "Down counter threshold value",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_SIG1.
static const field_t hw_dvfsc_sig1[] =
{
    {
        "WSW6",
        "General purpose load tracking signal weight dvfs_w_sig[6]",
        2, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW7",
        "General purpose load tracking signal weight dvfs_w_sig[7]",
        5, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW8",
        "General purpose load tracking signal weight dvfs_w_sig[8]",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW9",
        "General purpose load tracking signal weight dvfs_w_sig[9]",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW10",
        "General purpose load tracking signal weight dvfs_w_sig[10]",
        14, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW11",
        "General purpose load tracking signal weight dvfs_w_sig[11]",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW12",
        "General purpose load tracking signal weight dvfs_w_sig[12]",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW13",
        "General purpose load tracking signal weight dvfs_w_sig[13]",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW14",
        "General purpose load tracking signal weight dvfs_w_sig[14]",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW15",
        "General purpose load tracking signal weight dvfs_w_sig[15]",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSSIG0.
static const field_t hw_dvfsc_dvfssig0[] =
{
    {
        "WSW0",
        "General purpose load tracking signal weight dvfs_w_sig[0].",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW1",
        "General purpose load tracking signal weight dvfs_w_sig[1].",
        6, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW2",
        "General purpose load tracking signal weight dvfs_w_sig[2]",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW3",
        "General purpose load tracking signal weight dvfs_w_sig[3]",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW4",
        "General purpose load tracking signal weight dvfs_w_sig[4]",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW5",
        "General purpose load tracking signal weight dvfs_w_sig[5]",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPC0.
static const field_t hw_dvfsc_dvfsgpc0[] =
{
    {
        "GPBC0",
        "GPBC0 - General Purpose bits Counter 0  During period of this counter "
        "the GeP bit 0 will be set and WSW0 will be added to the calculations.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C0ACT",
        "C0ACT - Counter 0 active indicator",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "C0STRT",
        "C0STRT - Counter 0 start  Setting of this bit will initialize down cou"
        "nting of the GPC0 value.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPC1.
static const field_t hw_dvfsc_dvfsgpc1[] =
{
    {
        "GPBC1",
        "GPBC1 - General Purpose bits Counter 1  During period of this counter "
        "the GeP bit 1 will be set and WSW1 will be added to the calculations.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C1ACT",
        "C1ACT - Counter 1 active indicator",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "C1STRT",
        "C1STRT - Counter 1start  Setting of this bit will initialize down coun"
        "ting of the GPC1 value.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPBT.
static const field_t hw_dvfsc_dvfsgpbt[] =
{
    {
        "GPB0",
        "General purpose bit 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB1",
        "General purpose bit 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB2",
        "General purpose bit 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB3",
        "General purpose bit 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB4",
        "General purpose bit 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB5",
        "General purpose bit 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB6",
        "General purpose bit 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB7",
        "General purpose bit 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB8",
        "General purpose bit 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB9",
        "General purpose bit 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB10",
        "General purpose bit 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB11",
        "General purpose bit 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB12",
        "General purpose bit 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB13",
        "General purpose bit 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB14",
        "General purpose bit 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB15",
        "General purpose bit 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSEMAC.
static const field_t hw_dvfsc_dvfsemac[] =
{
    {
        "EMAC",
        "EMAC - EMA control value",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEN0",
        "DVFS tracking for core0 enable.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSVAI0",
        "DVFS Frequency adjustment status of core 0.",
        16, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFIM0",
        "DVFS Wait for Interrupt of core 0 mask bit",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_CNTR.
static const field_t hw_dvfsc_cntr[] =
{
    {
        "LTBRSR",
        "LTBRSR - Load Tracking Buffer Register Source:",
        3, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LTBRSH",
        "LTBRSH - Load Tracking Buffer Register Shift:",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFUS",
        "PFUS - Periodic Frequency Update Status",
        6, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFUE",
        "PFUE - Period Frequency Update Enable",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIV_RATIO",
        "DIV_RATIO - Divider value.",
        11, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MINF",
        "Minimum frequency reached.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAXF",
        "Maximum frequency reached.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSVAI",
        "FSVAI  DVFS Frequency adjustment interrupt.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FSVAIM",
        "DVFS Frequency adjustment interrupt mask.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PIRQS",
        "PIRQS - Pattern IRQ Source  * write '1' to clear.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFIS",
        "DVFS Interrupt select.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBFL0",
        "Load buffer 0 - full status bit.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBFL1",
        "Load buffer 1 - full status bit.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBMI",
        "Load buffer full mask interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEV",
        "Always give a DVFS event.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIV3CK",
        "DIV3CK - div_3_clk division ratio inside the DVFS module.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR0_0.
static const field_t hw_dvfsc_dvfsltr0_0[] =
{
    {
        "LTS0_0",
        "core 0 Load Tracking Sample 0",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_1",
        "core 0 Load Tracking Sample 1",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_2",
        "core 0 Load Tracking Sample 2",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_3",
        "core 0 Load Tracking Sample 3",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_4",
        "core 0 Load Tracking Sample 4",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_5",
        "core 0 Load Tracking Sample 5",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_6",
        "core 0 Load Tracking Sample 6",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_7",
        "core 0 Load Tracking Sample 7",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR0_1.
static const field_t hw_dvfsc_dvfsltr0_1[] =
{
    {
        "LTS0_8",
        "core 0 Load Tracking Sample 8",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_9",
        "core 0 Load Tracking Sample 9",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_10",
        "core 0 Load Tracking Sample 10",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_11",
        "core 0 Load Tracking Sample 11",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_12",
        "core 0 Load Tracking Sample 12",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_13",
        "core 0 Load Tracking Sample 13",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_14",
        "core 0 Load Tracking Sample 14",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_15",
        "core 0 Load Tracking Sample 15",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR1_0.
static const field_t hw_dvfsc_dvfsltr1_0[] =
{
    {
        "LTS1_0",
        "core 0 Load Tracking Sample 0",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_1",
        "core 0 Load Tracking Sample 1",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_2",
        "core 0 Load Tracking Sample 2",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_3",
        "core 0 Load Tracking Sample 3",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_4",
        "core 0 Load Tracking Sample 4",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_5",
        "core 0 Load Tracking Sample 5",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_6",
        "core 0 Load Tracking Sample 6",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_7",
        "core 0 Load Tracking Sample 7",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR1_1.
static const field_t hw_dvfsc_dvfsltr1_1[] =
{
    {
        "LTS1_8",
        "core 0 Load Tracking Sample 8",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_9",
        "core 0 Load Tracking Sample 9",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_10",
        "core 0 Load Tracking Sample 10",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_11",
        "core 0 Load Tracking Sample 11",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_12",
        "core 0 Load Tracking Sample 12",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_13",
        "core 0 Load Tracking Sample 13",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_14",
        "core 0 Load Tracking Sample 14",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_15",
        "core 0 Load Tracking Sample 15",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT0.
static const field_t hw_dvfsc_dvfspt0[] =
{
    {
        "FPTN0",
        "FPTN0 - Frequency pattern 0 counter  During period of this counter the"
        " frequency will be reduced from the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT0A",
        "PT0A - Pattern 0 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT1.
static const field_t hw_dvfsc_dvfspt1[] =
{
    {
        "FPTN1",
        "FPTN1 - Frequency pattern 1 counter  During period of this counter the"
        " frequency will be set to the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT1A",
        "PT1A - Pattern 1 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT2.
static const field_t hw_dvfsc_dvfspt2[] =
{
    {
        "FPTN2",
        "FPTN2 - Frequency pattern 2 counter  During period of this counter the"
        " frequency will be increased to higher, than detected by the EMA-detec"
        "ted level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT2A",
        "PT2A - Pattern 2 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "P2THR",
        "P2THR - Pattern 2 Threshold  Threshold of current DVFS load (after EMA"
        "), for generating interrupts with PFUS indicators 110, 111.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT3.
static const field_t hw_dvfsc_dvfspt3[] =
{
    {
        "FPTN3",
        "FPTN3 - Frequency pattern 3 counter  During period of this counter the"
        " frequency will be set to the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT3A",
        "PT3A - Pattern 3 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DVFSC module.
static const reg_t hw_dvfsc[] =
{
    {
        "THRS",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_thrs
    },
    {
        "COUN",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_coun
    },
    {
        "SIG1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dvfsc_sig1
    },
    {
        "DVFSSIG0",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_dvfsc_dvfssig0
    },
    {
        "DVFSGPC0",
        "DVFS general purpose bits weight counter.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfsgpc0
    },
    {
        "DVFSGPC1",
        "DVFS general purpose bits weight counter1.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfsgpc1
    },
    {
        "DVFSGPBT",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_dvfsc_dvfsgpbt
    },
    {
        "DVFSEMAC",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dvfsc_dvfsemac
    },
    {
        "CNTR",
        "DIV3CK division         DIV3CK setting  dividing ratio  sum_3 passing "
        "bits  div_1_clk cumulative divider      00  1  4-0  1*512=512    001  "
        "4  6-2  4*512=2048    010  16  8-4  16*512=8192    011  64  10-6  64*5"
        "12=32768    100  256  12-8  256*512=131072    101  1024  16-10  1024*5"
        "12=524288       Preliminary Divider definition       DIV_RATIO value  "
        "ARM clk division ratio      000000  1    000001  2    000010  3    ...",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_dvfsc_cntr
    },
    {
        "DVFSLTR0_0",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr0_0
    },
    {
        "DVFSLTR0_1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr0_1
    },
    {
        "DVFSLTR1_0",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr1_0
    },
    {
        "DVFSLTR1_1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr1_1
    },
    {
        "DVFSPT0",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt0
    },
    {
        "DVFSPT1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt1
    },
    {
        "DVFSPT2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfspt2
    },
    {
        "DVFSPT3",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt3
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ECSPI
#endif

// Bitfields in register ECSPI_RXDATA.
static const field_t hw_ecspi_rxdata[] =
{
    {
        "ECSPI_RXDATA",
        "Receive Data.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TXDATA.
static const field_t hw_ecspi_txdata[] =
{
    {
        "ECSPI_TXDATA",
        "Transmit Data.",
        0, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONREG.
static const field_t hw_ecspi_conreg[] =
{
    {
        "EN",
        "SPI Block Enable Control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT",
        "Hardware Trigger Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XCH",
        "SPI Exchange Bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMC",
        "Start Mode Control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_MODE",
        "SPI CHANNEL MODE selects the mode for each SPI channel.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIVIDER",
        "SPI Post Divider.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_DIVIDER",
        "SPI Pre Divider.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRCTL",
        "SPI Data Ready Control.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_SELECT",
        "SPI CHANNEL SELECT bits.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_LENGTH",
        "Burst Length.",
        20, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONFIGREG.
static const field_t hw_ecspi_configreg[] =
{
    {
        "SCLK_PHA",
        "SPI Clock/Data Phase Control.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_POL",
        "SPI Clock Polarity Control.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_CTL",
        "SPI SS Wave Form Select.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_POL",
        "SPI SS Polarity Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_CTL",
        "DATA CTL.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_CTL",
        "SCLK CTL.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT_LENGTH",
        "HT LENGTH.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_INTREG.
static const field_t hw_ecspi_intreg[] =
{
    {
        "TEEN",
        "TXFIFO Empty Interrupt enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDREN",
        "TXFIFO Data Request Interrupt enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFEN",
        "TXFIFO Full Interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RREN",
        "RXFIFO Ready Interrupt enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDREN",
        "RXFIFO Data Request Interrupt enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "RXFIFO Full Interrupt enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROEN",
        "RXFIFO Overflow Interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCEN",
        "Transfer Completed Interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_DMAREG.
static const field_t hw_ecspi_dmareg[] =
{
    {
        "TX_THRESHOLD",
        "TX THRESHOLD.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEDEN",
        "TXFIFO Empty DMA Request Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_THRESHOLD",
        "RX THRESHOLD.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDEN",
        "RXFIFO DMA Request Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DMA_LENGTH",
        "RX DMA LENGTH.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXTDEN",
        "RXFIFO TAIL DMA Request Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_STATREG.
static const field_t hw_ecspi_statreg[] =
{
    {
        "TE",
        "TXFIFO Empty.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDR",
        "TXFIFO Data Request.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TF",
        "TXFIFO Full.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RR",
        "RXFIFO Ready.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDR",
        "RXFIFO Data Request.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RF",
        "RXFIFO Full.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RO",
        "RXFIFO Overflow.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TC",
        "Transfer Completed Status bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_PERIODREG.
static const field_t hw_ecspi_periodreg[] =
{
    {
        "SAMPLE_PERIOD",
        "Sample Period Control.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSRC",
        "Clock Source Control.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSD_CTL",
        "Chip Select Delay Control bits.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TESTREG.
static const field_t hw_ecspi_testreg[] =
{
    {
        "TXCNT",
        "TXFIFO Counter.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXCNT",
        "RXFIFO Counter.",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBC",
        "Loop Back Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_MSGDATA.
static const field_t hw_ecspi_msgdata[] =
{
    {
        "ECSPI_MSGDATA",
        "ECSPI_MSGDATA holds the top word of MSG Data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ECSPI module.
static const reg_t hw_ecspi[] =
{
    {
        "RXDATA",
        "The Receive Data register (ECSPI_RXDATA) is a read-only register that "
        "forms the top word of the 64 x 32 receive FIFO.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_rxdata
    },
    {
        "TXDATA",
        "The Transmit Data (ECSPI_TXDATA) register is a write-only data registe"
        "r that forms the bottom word of the 64 x 32 TXFIFO.",
        4, // Width in bytes
        0x00000004, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ecspi_txdata
    },
    {
        "CONREG",
        "The Control Register (ECSPI_CONREG) allows software to enable the ECSP"
        "I , configure its operating modes, specify the divider value, and SPI_"
        "RDY control signal, and define the transfer length.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ecspi_conreg
    },
    {
        "CONFIGREG",
        "The Config Register (ECSPI_CONFIGREG) allows software to configure eac"
        "h SPI channel, configure its operating modes, specify the phase and po"
        "larity of the clock, configure the Chip Select (SS), and define the HT"
        " transfer length.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ecspi_configreg
    },
    {
        "INTREG",
        "The Interrupt Control Register (ECSPI_INTREG) enables the generation o"
        "f interrupts to the host processor.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_intreg
    },
    {
        "DMAREG",
        "The Direct Memory Access Control Register (ECSPI_DMAREG) provides soft"
        "ware a way to use an on-chip DMA controller for ECSPI data.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ecspi_dmareg
    },
    {
        "STATREG",
        "The ECSPI Status Register (ECSPI_STATREG) reflects the status of the E"
        "CSPI's operating condition.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_statreg
    },
    {
        "PERIODREG",
        "The Sample Period Control Register (ECSPI_PERIODREG) provides software"
        " a way to insert delays (wait states) between consecutive SPI transfer"
        "s.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_periodreg
    },
    {
        "TESTREG",
        "The Test Control Register (ECSPI_TESTREG) provides software a mechanis"
        "m to internally connect the receive and transmit devices of the ECSPI "
        " , and monitor the contents of the receive and transmit FIFOs.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_testreg
    },
    {
        "MSGDATA",
        "The Message Data Register (ECSPI_MSGDATA) forms the top word of the 16"
        " x 32 MSG Data FIFO.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ecspi_msgdata
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EIM
#endif

// Bitfields in register EIM_CS0GCR1.
static const field_t hw_eim_cs0gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0GCR2.
static const field_t hw_eim_cs0gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR1.
static const field_t hw_eim_cs0rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR2.
static const field_t hw_eim_cs0rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR1.
static const field_t hw_eim_cs0wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR2.
static const field_t hw_eim_cs0wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR1.
static const field_t hw_eim_cs1gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR2.
static const field_t hw_eim_cs1gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR1.
static const field_t hw_eim_cs1rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR2.
static const field_t hw_eim_cs1rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR1.
static const field_t hw_eim_cs1wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR2.
static const field_t hw_eim_cs1wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR1.
static const field_t hw_eim_cs2gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR2.
static const field_t hw_eim_cs2gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR1.
static const field_t hw_eim_cs2rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR2.
static const field_t hw_eim_cs2rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR1.
static const field_t hw_eim_cs2wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR2.
static const field_t hw_eim_cs2wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR1.
static const field_t hw_eim_cs3gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR2.
static const field_t hw_eim_cs3gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR1.
static const field_t hw_eim_cs3rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR2.
static const field_t hw_eim_cs3rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR1.
static const field_t hw_eim_cs3wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR2.
static const field_t hw_eim_cs3wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR1.
static const field_t hw_eim_cs4gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR2.
static const field_t hw_eim_cs4gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR1.
static const field_t hw_eim_cs4rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR2.
static const field_t hw_eim_cs4rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR1.
static const field_t hw_eim_cs4wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR2.
static const field_t hw_eim_cs4wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR1.
static const field_t hw_eim_cs5gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR2.
static const field_t hw_eim_cs5gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR1.
static const field_t hw_eim_cs5rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR2.
static const field_t hw_eim_cs5rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR1.
static const field_t hw_eim_cs5wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR2.
static const field_t hw_eim_cs5wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WCR.
static const field_t hw_eim_wcr[] =
{
    {
        "BCM",
        "Burst Clock Mode.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBCD",
        "General Burst Clock Divisor.",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CONT_BCLK_SEL",
        "When this bit is set BCLK pin output continuous clock.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTEN",
        "Interrupt Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTPOL",
        "Interrupt Polarity.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_EN",
        "Memory WDog enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_LIMIT",
        "Memory Watch Dog (WDog) cycle limit.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRUN_ACLK_EN",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_DCR.
static const field_t hw_eim_dcr[] =
{
    {
        "DLL_CTRL_ENABLE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_RESET",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_FORCE_UPD",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OFFSET_DEC",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OFFSET",
        "",
        4, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DLL_CTRL_GATE_UPDATE",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OVERRIDE",
        "Use override value in DLL_CTRL_SLV_OVERRIDE_VAL bit field instead of D"
        "LL locked value as delay.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OVERRIDE_VAL",
        "",
        9, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_REF_INITIAL_VAL",
        "",
        16, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_UPDATE_INT",
        "Update interval of slave DLL.",
        23, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_REF_UPDATE_INT",
        "Update interval of reference DLL.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_DSR.
static const field_t hw_eim_dsr[] =
{
    {
        "DLL_STS_SLV_LOCK",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_STS_REF_LOCK",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_STS_SLV_SEL",
        "",
        2, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_STS_REF_SEL",
        "",
        9, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WIAR.
static const field_t hw_eim_wiar[] =
{
    {
        "IPS_REQ",
        "IPS request.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPS_ACK",
        "IPS ACK.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT",
        "Interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERRST",
        "READY After Reset.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EN",
        "ACLK enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_EAR.
static const field_t hw_eim_ear[] =
{
    {
        "ERROR_ADDR",
        "Error Address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a EIM module.
static const reg_t hw_eim[] =
{
    {
        "CS0GCR1",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs0gcr1
    },
    {
        "CS0GCR2",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs0gcr2
    },
    {
        "CS0RCR1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs0rcr1
    },
    {
        "CS0RCR2",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs0rcr2
    },
    {
        "CS0WCR1",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs0wcr1
    },
    {
        "CS0WCR2",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs0wcr2
    },
    {
        "CS1GCR1",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs1gcr1
    },
    {
        "CS1GCR2",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs1gcr2
    },
    {
        "CS1RCR1",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs1rcr1
    },
    {
        "CS1RCR2",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs1rcr2
    },
    {
        "CS1WCR1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs1wcr1
    },
    {
        "CS1WCR2",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs1wcr2
    },
    {
        "CS2GCR1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs2gcr1
    },
    {
        "CS2GCR2",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs2gcr2
    },
    {
        "CS2RCR1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs2rcr1
    },
    {
        "CS2RCR2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs2rcr2
    },
    {
        "CS2WCR1",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs2wcr1
    },
    {
        "CS2WCR2",
        "",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs2wcr2
    },
    {
        "CS3GCR1",
        "",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs3gcr1
    },
    {
        "CS3GCR2",
        "",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs3gcr2
    },
    {
        "CS3RCR1",
        "",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs3rcr1
    },
    {
        "CS3RCR2",
        "",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs3rcr2
    },
    {
        "CS3WCR1",
        "",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs3wcr1
    },
    {
        "CS3WCR2",
        "",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs3wcr2
    },
    {
        "CS4GCR1",
        "",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs4gcr1
    },
    {
        "CS4GCR2",
        "",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs4gcr2
    },
    {
        "CS4RCR1",
        "",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs4rcr1
    },
    {
        "CS4RCR2",
        "",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs4rcr2
    },
    {
        "CS4WCR1",
        "",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs4wcr1
    },
    {
        "CS4WCR2",
        "",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs4wcr2
    },
    {
        "CS5GCR1",
        "",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs5gcr1
    },
    {
        "CS5GCR2",
        "",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs5gcr2
    },
    {
        "CS5RCR1",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs5rcr1
    },
    {
        "CS5RCR2",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs5rcr2
    },
    {
        "CS5WCR1",
        "",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs5wcr1
    },
    {
        "CS5WCR2",
        "",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs5wcr2
    },
    {
        "WCR",
        "",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_wcr
    },
    {
        "DCR",
        "",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_dcr
    },
    {
        "DSR",
        "",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_eim_dsr
    },
    {
        "WIAR",
        "",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_wiar
    },
    {
        "EAR",
        "",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_ear
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark LCDIF
#endif

// Bitfields in register LCDIF_CTRL.
static const field_t hw_lcdif_ctrl[] =
{
    {
        "RUN",
        "When this bit is set by software, the eLCDIF will begin transferring d"
        "ata between the SoC and the display.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_FORMAT_24_BIT",
        "Used only when WORD_LENGTH = 3, i.e.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_FORMAT_18_BIT",
        "Used only when WORD_LENGTH = 2, i.e.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_FORMAT_16_BIT",
        "When this bit is 1 and WORD_LENGTH = 0, it implies that the the 16-bit"
        " data is in ARGB555 format.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASTER",
        "Set this bit to make the eLCDIF act as a bus master.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_PXP_HANDSHAKE",
        "If this bit is set and LCDIF_MASTER bit is set, the eLCDIF will act as"
        " bus master and the handshake mechanism between eLCDIF and ePXP will b"
        "e turned on.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RGB_TO_YCBCR422_CSC",
        "Set this bit to 1 to enable conversion from RGB to YCbCr colorspace.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WORD_LENGTH",
        "Input data format.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCD_DATABUS_WIDTH",
        "LCD Data bus transfer width.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSC_DATA_SWIZZLE",
        "This field specifies how to swap the bytes after the data has been con"
        "verted into an internal representation of 24 bits per pixel and before"
        " it is transmitted over the LCD interface bus.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INPUT_DATA_SWIZZLE",
        "This field specifies how to swap the bytes fetched by the bus master i"
        "nterface.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_SELECT",
        "Command Mode polarity bit.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOTCLK_MODE",
        "Set this bit to 1 to make the hardware go into the DOTCLK mode, i.e.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_MODE",
        "Setting this bit to 1 will make the eLCDIF hardware go into VSYNC mode"
        ".",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_COUNT",
        "When this bit is 0, it means that eLCDIF will stop the block operation"
        " and turn off the RUN bit after the amount of data indicated by the LC"
        "DIF_TRANSFER_COUNT register has been transferred out.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVI_MODE",
        "Set this bit to 1 to get into theITU-R BT.656 digital video interface "
        "mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SHIFT_NUM_BITS",
        "The data to be transmitted is shifted left or right by this number of "
        "bits.",
        21, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_SHIFT_DIR",
        "Use this bit to determine the direction of shift of transmit data.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAIT_FOR_VSYNC_EDGE",
        "Setting this bit to 1 will make the hardware wait for the triggering V"
        "SYNC edge before starting write transfers to the LCD.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "READ_WRITEB",
        "By default, eLCDIF is in the write mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "YCBCR422_INPUT",
        "Zero implies input data is in RGB color space.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "This bit must be set to zero to enable normal operation of the eLCDIF.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CTRL1.
static const field_t hw_lcdif_ctrl1[] =
{
    {
        "RESET",
        "Reset bit for the external LCD controller.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE86",
        "This bit is used to select between the 8080 and 6800 series of micropr"
        "ocessor modes.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUSY_ENABLE",
        "This bit enables the use of the interface's busy signal input.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_EDGE_IRQ",
        "This bit is set to indicate that an interrupt is requested by the eLCD"
        "IF block.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CUR_FRAME_DONE_IRQ",
        "This bit is set to indicate that an interrupt is requested by the eLCD"
        "IF block.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNDERFLOW_IRQ",
        "This bit is set to indicate that an interrupt is requested by the eLCD"
        "IF block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OVERFLOW_IRQ",
        "This bit is set to indicate that an interrupt is requested by the eLCD"
        "IF block.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_EDGE_IRQ_EN",
        "This bit is set to enable an interrupt every time the hardware encount"
        "ers the leading VSYNC edge in the VSYNC and DOTCLK modes, or the begin"
        "ning of every field in DVI mode.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CUR_FRAME_DONE_IRQ_EN",
        "This bit is set to 1 enable an interrupt every time the hardware enter"
        "s in the vertical blanking state.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNDERFLOW_IRQ_EN",
        "This bit is set to enable an underflow interrupt in the TXFIFO in the "
        "write mode.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OVERFLOW_IRQ_EN",
        "This bit is set to enable an overflow interrupt in the TXFIFO in the w"
        "rite mode.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYTE_PACKING_FORMAT",
        "This bitfield is used to show which data bytes in a 32-bit word are va"
        "lid.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ON_ALTERNATE_FIELDS",
        "If this bit is set, the eLCDIF block will assert the cur_frame_done in"
        "terrupt only on alternate fields, otherwise it will issue the interrup"
        "t on both odd and even field.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_CLEAR",
        "Set this bit to clear all the data in the latency FIFO (LFIFO), TXFIFO"
        " and the RXFIFO.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "START_INTERLACE_FROM_SECOND_FIELD",
        "The default is to grab the odd lines first and then the even lines.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTERLACE_FIELDS",
        "Set this bit if it is required that the eLCDIF block fetches odd lines"
        " in one field and even lines in the other field.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RECOVER_ON_UNDERFLOW",
        "Set this bit to enable the eLCDIF block to recover in the next field/f"
        "rame if there was an underflow in the current field/frame.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "This bit is set to indicate that an interrupt is requested by the eLCD"
        "IF block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ_EN",
        "This bit is set to enable bus master error interrupt in the eLCDIF mas"
        "ter mode.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COMBINE_MPU_WR_STRB",
        "If this bit is not set, the write strobe will be driven on LCD_WR_RWn "
        "pin in the 8080 mode and on the LCD_RD_E pin in the 6800 mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CTRL2.
static const field_t hw_lcdif_ctrl2[] =
{
    {
        "INITIAL_DUMMY_READ",
        "The value in this field determines the number of dummy 8/16/18/24-bit "
        "subwords that have to be read back from the LCD panel/controller.",
        1, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "READ_MODE_NUM_PACKED_SUBWORDS",
        "Indicates the number of valid 8/16/18/24-bit subwords that will be pac"
        "ked into the 32-bit word in read mode.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "READ_MODE_6_BIT_INPUT",
        "Setting this bit to 1 indicates to eLCDIF that even though LCD_DATABUS"
        "_WIDTH is set to 8 bits, the input data is actually only 6 bits wide a"
        "nd exists on D5-D0.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "READ_MODE_OUTPUT_IN_RGB_FORMAT",
        "Setting this bit will enable the eLCDIF to convert the incoming data t"
        "o the RGB format given by WORD_LENGTH bitfield.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "READ_PACK_DIR",
        "The default value of 0 indicates data is stored in the little endian f"
        "ormat.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EVEN_LINE_PATTERN",
        "This field determines the order of the RGB components of each pixel in"
        " EVEN lines (line numbers 2,4,6,..).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODD_LINE_PATTERN",
        "This field determines the order of the RGB components of each pixel in"
        " ODD lines (line numbers 1,3,5,..).",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_LEN_8",
        "By default, when the eLCDIF is in the bus master mode, it will issue A"
        "XI bursts of length 16 (except when in packed 24 bpp mode, it will iss"
        "ue bursts of length 15).",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTSTANDING_REQS",
        "This bitfield indicates the maximum number of outstanding transactions"
        " that eLCDIF should request when it is acting as a bus master.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_TRANSFER_COUNT.
static const field_t hw_lcdif_transfer_count[] =
{
    {
        "H_COUNT",
        "Total valid data (pixels) in each horizontal line.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "V_COUNT",
        "Number of horizontal lines per frame which contain valid data.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CUR_BUF.
static const field_t hw_lcdif_cur_buf[] =
{
    {
        "ADDR",
        "-",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_NEXT_BUF.
static const field_t hw_lcdif_next_buf[] =
{
    {
        "ADDR",
        "-",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_TIMING.
static const field_t hw_lcdif_timing[] =
{
    {
        "DATA_SETUP",
        "Data bus setup time in CLK_DIS_LCDIFn cycles.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_HOLD",
        "Data bus hold time in CLK_DIS_LCDIFn cycles.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD_SETUP",
        "Number of CLK_DIS_LCDIFn cycles that the the DCn signal is active befo"
        "re CEn is asserted.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD_HOLD",
        "Number of CLK_DIS_LCDIFn cycles that the DCn signal is active after CE"
        "n is deasserted.",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_VDCTRL0.
static const field_t hw_lcdif_vdctrl0[] =
{
    {
        "VSYNC_PULSE_WIDTH",
        "Number of units for which VSYNC signal is active.",
        0, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LINE_MODE",
        "When this bit is 0, the first field (VSYNC period) will end in half a "
        "horizontal line and the second field will begin with half a horizontal"
        " line.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LINE",
        "Setting this bit to 1 will make the total VSYNC period equal to the VS"
        "YNC_PERIOD field plus half the HORIZONTAL_PERIOD field (i.e.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_PULSE_WIDTH_UNIT",
        "Default 0 for counting VSYNC_PULSE_WIDTH in terms of CLK_DIS_LCDIFn cy"
        "cles.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_PERIOD_UNIT",
        "Default 0 for counting VSYNC_PERIOD in terms of CLK_DIS_LCDIFn cycles.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_POL",
        "Default 0 active low during valid data transfer on each horizontal lin"
        "e.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOTCLK_POL",
        "Default is data launched at negative edge of DOTCLK and captured at po"
        "sitive edge.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_POL",
        "Default 0 active low during HSYNC_PULSE_WIDTH time and will be high du"
        "ring the rest of the HSYNC period.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_POL",
        "Default 0 active low during VSYNC_PULSE_WIDTH time and will be high du"
        "ring the rest of the VSYNC period.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_PRESENT",
        "Setting this bit to 1 will make the hardware generate the ENABLE signa"
        "l in the DOTCLK mode, thereby making it the true RGB interface along w"
        "ith the remaining three signals VSYNC, HSYNC and DOTCLK.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_OEB",
        "0 means the VSYNC signal is an output, 1 means it is an input.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_VDCTRL1.
static const field_t hw_lcdif_vdctrl1[] =
{
    {
        "VSYNC_PERIOD",
        "Total number of units between two positive or two negative edges of th"
        "e VSYNC signal.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_VDCTRL2.
static const field_t hw_lcdif_vdctrl2[] =
{
    {
        "HSYNC_PERIOD",
        "Total number of CLK_DIS_LCDIFn cycles between two positive or two nega"
        "tive edges of the HSYNC signal.",
        0, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_PULSE_WIDTH",
        "Number of CLK_DIS_LCDIFn cycles for which HSYNC signal is active.",
        18, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_VDCTRL3.
static const field_t hw_lcdif_vdctrl3[] =
{
    {
        "VERTICAL_WAIT_CNT",
        "In the VSYNC interface mode, wait for this number of CLK_DIS_LCDIFn cy"
        "cles from the falling VSYNC edge (or rising if VSYNC_POL is 1) before "
        "starting LCD transactions and is applicable only if WAIT_FOR_VSYNC_EDG"
        "E is set.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HORIZONTAL_WAIT_CNT",
        "In the DOTCLK mode, wait for this number of clocks from falling edge ("
        "or rising if HSYNC_POL is 1) of HSYNC signal to account for horizontal"
        " back porch plus the number of DOTCLKs before the moving picture infor"
        "mation begins.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_ONLY",
        "This bit must be set to 1 in the VSYNC mode of operation, and 0 in the"
        " DOTCLK mode of operation.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_SYNC_SIGNALS",
        "When this bit is set, the eLCDIF block will internally mux HSYNC with "
        "LCD_D14, DOTCLK with LCD_D13 and ENABLE with LCD_D12, otherwise these "
        "signals will go out on separate pins.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_VDCTRL4.
static const field_t hw_lcdif_vdctrl4[] =
{
    {
        "DOTCLK_H_VALID_DATA_CNT",
        "Total number of CLK_DIS_LCDIFn cycles on each horizontal line that car"
        "ry valid data in DOTCLK mode.",
        0, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNC_SIGNALS_ON",
        "Set this field to 1 if the LCD controller requires that the VSYNC or V"
        "SYNC/HSYNC/DOTCLK control signals should be active atleast one frame b"
        "efore the data transfers actually start and remain active atleast one "
        "frame after the data transfers end.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOTCLK_DLY_SEL",
        "This bitfield selects the amount of time by which the DOTCLK signal sh"
        "ould be delayed before coming out of the LCD_DOTCK pin.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DVICTRL0.
static const field_t hw_lcdif_dvictrl0[] =
{
    {
        "H_BLANKING_CNT",
        "Number of blanking samples to be inserted between EAV and SAV during h"
        "orizontal blanking interval.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "H_ACTIVE_CNT",
        "Number of active video samples to be transmitted.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DVICTRL1.
static const field_t hw_lcdif_dvictrl1[] =
{
    {
        "F2_START_LINE",
        "Vertical line number from which Field 2 begins.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F1_END_LINE",
        "Vertical line number at which Field1 ends.",
        10, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F1_START_LINE",
        "Vertical line number from which Field 1 begins.",
        20, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DVICTRL2.
static const field_t hw_lcdif_dvictrl2[] =
{
    {
        "V1_BLANK_END_LINE",
        "Vertical line number in the beginning part of Field2 where first Verti"
        "cal Blanking interval ends.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "V1_BLANK_START_LINE",
        "Vertical line number towards the end of Field1 where first Vertical Bl"
        "anking interval starts.",
        10, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F2_END_LINE",
        "Vertical line number at which Field 2 ends.",
        20, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DVICTRL3.
static const field_t hw_lcdif_dvictrl3[] =
{
    {
        "V_LINES_CNT",
        "Total number of vertical lines per frame (generally 525 or 625)",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "V2_BLANK_END_LINE",
        "Vertical line number in the beginning part of Field1 where second Vert"
        "ical Blanking interval ends.",
        10, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "V2_BLANK_START_LINE",
        "Vertical line number towards the end of Field2 where second Vertical B"
        "lanking interval starts.",
        20, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DVICTRL4.
static const field_t hw_lcdif_dvictrl4[] =
{
    {
        "H_FILL_CNT",
        "Number of active video samples that have to be filled with the filler "
        "data in the front and back portions of the active horizontal interval.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CR_FILL_VALUE",
        "Value of CR component of filler data.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CB_FILL_VALUE",
        "Value of CB component of filler data",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "Y_FILL_VALUE",
        "Value of Y component of filler data",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CSC_COEFF0.
static const field_t hw_lcdif_csc_coeff0[] =
{
    {
        "CSC_SUBSAMPLE_FILTER",
        "This register describes the filtering and subsampling scheme to be per"
        "formed on the chroma components in order to convert from YCbCr 4:4:4 t"
        "o YCbCr 4:2:2 space.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C0",
        "Two's complement red multiplier coefficient for Y",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CSC_COEFF1.
static const field_t hw_lcdif_csc_coeff1[] =
{
    {
        "C1",
        "Two's complement green multiplier coefficient for Y",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C2",
        "Two's complement blue multiplier coefficient for Y",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CSC_COEFF2.
static const field_t hw_lcdif_csc_coeff2[] =
{
    {
        "C3",
        "Two's complement red multiplier coefficient for Cb",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C4",
        "Two's complement green multiplier coefficient for Cb",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CSC_COEFF3.
static const field_t hw_lcdif_csc_coeff3[] =
{
    {
        "C5",
        "Two's complement blue multiplier coefficient for Cb",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C6",
        "Two's complement red multiplier coefficient for Cr",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CSC_COEFF4.
static const field_t hw_lcdif_csc_coeff4[] =
{
    {
        "C7",
        "Two's complement green multiplier coefficient for Cr",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C8",
        "Two's complement blue multiplier coefficient for Cr",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CSC_OFFSET.
static const field_t hw_lcdif_csc_offset[] =
{
    {
        "Y_OFFSET",
        "Two's complement offset for the Y component",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CBCR_OFFSET",
        "Two's complement offset for the Cb and Cr components",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CSC_LIMIT.
static const field_t hw_lcdif_csc_limit[] =
{
    {
        "Y_MAX",
        "Upper limit of Y after RGB to 4:2:2 YCbCr conversion",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "Y_MIN",
        "Lower limit of Y after RGB to 4:2:2 YCbCr conversion",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CBCR_MAX",
        "Upper limit of Cb and Cr after RGB to 4:2:2 YCbCr conversion",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CBCR_MIN",
        "Lower limit of Cb and Cr after RGB to 4:2:2 YCbCr conversion",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DATA.
static const field_t hw_lcdif_data[] =
{
    {
        "DATA_ZERO",
        "Byte 0 (least significant byte) of data written to eLCDIF.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_ONE",
        "Byte 1 of data written to eLCDIF.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_TWO",
        "Byte 2 of data written to eLCDIF.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_THREE",
        "Byte 3 (most significant byte) of data written to LCDIF.",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_BM_ERROR_STAT.
static const field_t hw_lcdif_bm_error_stat[] =
{
    {
        "ADDR",
        "Virtual address at which bus master error occurred.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_CRC_STAT.
static const field_t hw_lcdif_crc_stat[] =
{
    {
        "CRC_VALUE",
        "Calculated CRC value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_STAT.
static const field_t hw_lcdif_stat[] =
{
    {
        "LFIFO_COUNT",
        "Read only view of the current count in Latency buffer (LFIFO).",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DVI_CURRENT_FIELD",
        "Read only view of the current field being transmitted.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUSY",
        "Read only view of the input busy signal from the external LCD controll"
        "er.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TXFIFO_EMPTY",
        "Read only view of the signal that indicates that LCD write dapatath FI"
        "FO is empty, will be generally used in the read mode of the LCD interf"
        "ace.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TXFIFO_FULL",
        "Read only view of the signal that indicates that LCD write datapath FI"
        "FO is full, will be generally used in the write mode of the LCD interf"
        "ace.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LFIFO_EMPTY",
        "Read only view of the signal that indicates that LCD read dapatath FIF"
        "O is empty, will be generally used in the read mode of the LCD interfa"
        "ce.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LFIFO_FULL",
        "Read only view of the signal that indicates that LCD read datapath FIF"
        "O is full, will be generally used in the write mode of the LCD interfa"
        "ce.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PRESENT",
        "0: eLCDIF not present on this product  1: eLCDIF is present.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_VERSION.
static const field_t hw_lcdif_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DEBUG0.
static const field_t hw_lcdif_debug0[] =
{
    {
        "MST_WORDS",
        "Read only view of the current bursts issued by the AXI bus master.",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MST_OUTSTANDING_REQS",
        "Read only view of the current outstanding requests issued by the AXI b"
        "us master.",
        4, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MST_AVALID",
        "Read only view of the mst_avalid signal issued by the AXI bus master.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CUR_REQ_STATE",
        "Read only view of the request state machine.",
        10, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_B1_DONE",
        "Buffer1 done signal issued by eLCDIF.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_LCDIF_B1_READY",
        "Buffer1 ready signal issued by ePXP.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_B0_DONE",
        "Buffer0 done signal issued by eLCDIF.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_LCDIF_B0_READY",
        "Buffer0 ready signal issued by ePXP.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CUR_STATE",
        "Read only view of the current state machine state in the current mode "
        "of operation.",
        16, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EMPTY_WORD",
        "Indicates that the current word is empty.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CUR_FRAME_TX",
        "This bit is 1 for the time the current frame is being transmitted in t"
        "he VSYNC mode.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VSYNC",
        "Read only view of VSYNC signal.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HSYNC",
        "Read only view of HSYNC signal.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE",
        "Read only view of ENABLE signal.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SYNC_SIGNALS_ON_REG",
        "Read only view of internal sync_signals_on_reg signal.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT_FOR_VSYNC_EDGE_OUT",
        "Read only view of WAIT_FOR_VSYNC_EDGE bit in the VSYNC mode after it c"
        "omes out of the TXFIFO.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STREAMING_END_DETECTED",
        "Read only view of the DOTCLK_MODE or DVI_MODE bit going from 1 to 0.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DEBUG1.
static const field_t hw_lcdif_debug1[] =
{
    {
        "V_DATA_COUNT",
        "Read only view of the current state of the vertical data counter.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "H_DATA_COUNT",
        "Read only view of the current state of the horizontal data counter.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_DEBUG2.
static const field_t hw_lcdif_debug2[] =
{
    {
        "MST_ADDRESS",
        "Read only view of the current address issued by the AXI bus master.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register LCDIF_THRES.
static const field_t hw_lcdif_thres[] =
{
    {
        "PANIC",
        "This value should be set to a value of pixels, from 0 to 511.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FASTCLOCK",
        "This value should be set to a value of pixels, from 0 to 511.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a LCDIF module.
static const reg_t hw_lcdif[] =
{
    {
        "CTRL",
        "The LCD Interface Control Register provides overall control of the eLC"
        "DIF block.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        23, // Number of bitfields
        hw_lcdif_ctrl
    },
    {
        "CTRL1",
        "The eLCDIF Control Register provides overall control of the eLCDIF blo"
        "ck.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        20, // Number of bitfields
        hw_lcdif_ctrl1
    },
    {
        "CTRL2",
        "The eLCDIF Control Register provides overall control of the eLCDIF blo"
        "ck.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_lcdif_ctrl2
    },
    {
        "TRANSFER_COUNT",
        "This register tells the eLCDIF how much data will be sent for this fra"
        "me, or transaction.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_transfer_count
    },
    {
        "CUR_BUF",
        "This register indicates the address of the current frame being transmi"
        "tted by eLCDIF.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_lcdif_cur_buf
    },
    {
        "NEXT_BUF",
        "This register indicates the address of next frame that will be transmi"
        "tted by eLCDIF.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_lcdif_next_buf
    },
    {
        "TIMING",
        "The LCD interface timing register controls the various setup and hold "
        "times enforced by the LCD interface in the 6800/8080 MPU and VSYNC mod"
        "es of operation.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_lcdif_timing
    },
    {
        "VDCTRL0",
        "This register is used to control the VSYNC and DOTCLK modes of the LCD"
        "IF so as to work with different types of LCDs like moving picture disp"
        "lays and delta pixel displays.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_lcdif_vdctrl0
    },
    {
        "VDCTRL1",
        "This register is used to control the VSYNC signal in the VSYNC and DOT"
        "CLK modes of the block.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_lcdif_vdctrl1
    },
    {
        "VDCTRL2",
        "This register is used to control the HSYNC signal in the DOTCLK mode o"
        "f the block.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_vdctrl2
    },
    {
        "VDCTRL3",
        "This register is used to determine the vertical and horizontal wait co"
        "unts.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_lcdif_vdctrl3
    },
    {
        "VDCTRL4",
        "This register is used to control the DOTCLK mode of the block.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_lcdif_vdctrl4
    },
    {
        "DVICTRL0",
        "The Digital Video interface Control0 register provides the overall con"
        "trol of the Digital Video interface.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_dvictrl0
    },
    {
        "DVICTRL1",
        "The Digital Video interface Control1 register provides the overall con"
        "trol of the Digital Video interface.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_lcdif_dvictrl1
    },
    {
        "DVICTRL2",
        "The Digital Video interface Control2 register provides the overall con"
        "trol of the Digital Video interface.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_lcdif_dvictrl2
    },
    {
        "DVICTRL3",
        "The Digital Video interface Control3 register provides the overall con"
        "trol of the Digital Video interface.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_lcdif_dvictrl3
    },
    {
        "DVICTRL4",
        "The Digital Video interface Control4 register provides the overall con"
        "trol of the Digital Video interface.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_lcdif_dvictrl4
    },
    {
        "CSC_COEFF0",
        "LCDIF_CSC_COEFF0 register provides overall control over color space co"
        "nversion from RGB to 4:2:2 YCbCr.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_csc_coeff0
    },
    {
        "CSC_COEFF1",
        "LCDIF_CSC_COEFF1 register provides overall control over color space co"
        "nversion from RGB to 4:2:2 YCbCr.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_csc_coeff1
    },
    {
        "CSC_COEFF2",
        "LCDIF_CSC_COEFF2 register provides overall control over color space co"
        "nversion from RGB to 4:2:2 YCbCr.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_csc_coeff2
    },
    {
        "CSC_COEFF3",
        "LCDIF_CSC_COEFF3 register provides overall control over color space co"
        "nversion from RGB to 4:2:2 YCbCr.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_csc_coeff3
    },
    {
        "CSC_COEFF4",
        "LCDIF_CSC_COEFF4 register provides overall control over color space co"
        "nversion from RGB to 4:2:2 YCbCr.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_csc_coeff4
    },
    {
        "CSC_OFFSET",
        "LCDIF_CSC_ register provides overall control over color space conversi"
        "on from RGB to 4:2:2 YCbCr.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_csc_offset
    },
    {
        "CSC_LIMIT",
        "LCDIF_CSC_CTRL0 register provides overall control over color space con"
        "version from RGB to 4:2:2 YCbCr.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_lcdif_csc_limit
    },
    {
        "DATA",
        "This register is used to transfer data using the PIO interface mode of"
        " operation.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_lcdif_data
    },
    {
        "BM_ERROR_STAT",
        "This register reflects the virtual address at which the AXI master rec"
        "eived an error response from the slave.",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_lcdif_bm_error_stat
    },
    {
        "CRC_STAT",
        "This register reflects the CRC value of each frame sent out by eLCDIF.",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_lcdif_crc_stat
    },
    {
        "STAT",
        "The LCD interface status register can be used to check the current sta"
        "tus of the eLCDIF block.",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_lcdif_stat
    },
    {
        "VERSION",
        "The LCD interface version register can be used to read the version of "
        "the eLCDIF IP being used in this SoC.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_lcdif_version
    },
    {
        "DEBUG0",
        "The LCD interface debug0 register provides a diagnostic view of the st"
        "ate machine and other useful internal signals.",
        4, // Width in bytes
        0x000001d0, // Base address offset
        true, // Readable
        false, // Writable
        17, // Number of bitfields
        hw_lcdif_debug0
    },
    {
        "DEBUG1",
        "The LCD interface debug1 register provides a diagnostic view of the st"
        "ate machine and other useful internal signals.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_lcdif_debug1
    },
    {
        "DEBUG2",
        "The LCD interface debug2 register provides a diagnostic view of the st"
        "ate machine and other useful internal signals.",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_lcdif_debug2
    },
    {
        "THRES",
        "This register is used to activate control signals when the number of p"
        "ixels reaches the programmed threshold.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_lcdif_thres
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EPDC
#endif

// Bitfields in register EPDC_CTRL.
static const field_t hw_epdc_ctrl[] =
{
    {
        "BURST_LEN_8",
        "0- EPDC display fifo logic will issue AXI bursts of length 16.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the LUT data before store to LUTRA"
        "M.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the UPD data before the WB constru"
        "ction.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal EPDC operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WVADDR.
static const field_t hw_epdc_wvaddr[] =
{
    {
        "ADDR",
        "Start address of waveform tables.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_ADDR.
static const field_t hw_epdc_wb_addr[] =
{
    {
        "ADDR",
        "Address for EPDC working buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_RES.
static const field_t hw_epdc_res[] =
{
    {
        "HORIZONTAL",
        "Horizontal Resolution (in pixels)",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VERTICAL",
        "Vertical Resoltion (in pixels)",
        16, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FORMAT.
static const field_t hw_epdc_format[] =
{
    {
        "TFT_PIXEL_FORMAT",
        "EPDC TFT Pixel Format.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_FORMAT",
        "EPDC Input Buffer Pixel format.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEFAULT_TFT_PIXEL",
        "Default TFT pixel value.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_SCALE",
        "Selects method of conversion from 8-bit input",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FIFOCTRL.
static const field_t hw_epdc_fifoctrl[] =
{
    {
        "FIFO_L_LEVEL",
        "Lower level value of FIFO watermark.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_H_LEVEL",
        "Upper level value of FIFO watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_INIT_LEVEL",
        "This register sets the watermark for the pixel-fifo.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_PRIORITY",
        "Enable watermark-based priority elevation mechanism.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_ADDR.
static const field_t hw_epdc_upd_addr[] =
{
    {
        "ADDR",
        "Address for incoming region update.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_STRIDE.
static const field_t hw_epdc_upd_stride[] =
{
    {
        "STRIDE",
        "line stride for incoming region update",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_CORD.
static const field_t hw_epdc_upd_cord[] =
{
    {
        "XCORD",
        "X co-ordinate for incoming region update",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "YCORD",
        "Y co-ordinate for incoming region update",
        16, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_SIZE.
static const field_t hw_epdc_upd_size[] =
{
    {
        "WIDTH",
        "Width (in pixels)",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HEIGHT",
        "Height (in pixels)",
        16, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_CTRL.
static const field_t hw_epdc_upd_ctrl[] =
{
    {
        "UPDATE_MODE",
        "Update Mode",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRY_RUN",
        "Enable Dry Run mode(set to 1).",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTOWV",
        "enable automatical waveform mode selection",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTOWV_PAUSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NO_LUT_CANCEL",
        "EPDC will cancel LUT loading for void update (no real update needed be"
        "cause of partial or collision), set this bit to 1 to disable this feat"
        "ure",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAVEFORM_MODE",
        "Waveform Mode 0-255",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_SEL",
        "LUT select 0-63",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "Use fixed pixel values (requires programming of EPDC_UPD_FIXED)",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_FIXED.
static const field_t hw_epdc_upd_fixed[] =
{
    {
        "FIXCP",
        "CP value if fixecp_en is set to 1.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP",
        "NP value if fixenp_en is set to 1.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXCP_EN",
        "If set to 1, current updated region has the CP value defined by FIXCP",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP_EN",
        "If set to 1, current updated region has the NP value defined by FIXNP",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TEMP.
static const field_t hw_epdc_temp[] =
{
    {
        "TEMPERATURE",
        "Temperature Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_AUTOWV_LUT.
static const field_t hw_epdc_autowv_lut[] =
{
    {
        "ADDR",
        "ADDR",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA",
        "DATA",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_CTRL.
static const field_t hw_epdc_tce_ctrl[] =
{
    {
        "PIXELS_PER_SDCLK",
        "Number of TFT pixels per SDCLK period.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_WIDTH",
        "Selects either 8 or 16 bit SDDO bus format",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DUAL_SCAN",
        "Enables dual scan-mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_0",
        "Determines scan direction for each half of the TFT panel",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_1",
        "Determines scan direction for each half of the TFT panel",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE",
        "If set, the upper 8-bit of the SDDO bus are used for LVDS differential"
        " signalling.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE_CE",
        "If set (together with LVDS_MODE=1), SDCE[9:5] shall be driven as the d"
        "ifferential inverse of SDCE[4:0].",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_MODE",
        "If set, SDDO data is driven on both positive and negative edges of SDC"
        "LK.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_MODE",
        "This field determines the method used to drive the VCOM signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_VAL",
        "When VCOM_MODE = MANUAL, this value is used to manually set the VCOM v"
        "alue for the VCOM[1:0] pins",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSCAN_HOLDOFF",
        "This period (expressed in vertical lines), sets the portion of the ver"
        "tical blanking available for new LUTs to be activated.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_SDCFG.
static const field_t hw_epdc_tce_sdcfg[] =
{
    {
        "PIXELS_PER_CE",
        "Number of pixels (outputs) per source-driver IC.",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_INVERT",
        "Setting this bit to 1 reverses the polarity of each SDDO bit so 0xAAAA"
        " in 16-bit mode for example becomes 0x5555.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_REFORMAT",
        "This register defines the various re-formatting options to enable more"
        " flexibility in the source-driver interface:",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUM_CE",
        "Number of source driver IC chip-enables.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDSHR",
        "Value for source-driver shift direction output port",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_HOLD",
        "Setting this bit to 1 holds the SDCLK low during LINE_BEGIN",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_GDCFG.
static const field_t hw_epdc_tce_gdcfg[] =
{
    {
        "GDSP_MODE",
        "Selects method for driving GDSP pulse.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_MODE",
        "Selects method for driving GDOE signal.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDRL",
        "Value for gate-driver right/left shift output port",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIOD_VSCAN",
        "when vscan state is splited, this reg defines the counter period",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN1.
static const field_t hw_epdc_tce_hscan1[] =
{
    {
        "LINE_SYNC",
        "Number of PIXCLK cycles for line sync duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_SYNC_WIDTH",
        "Number of PIXCLK cycles for the SDLE active time.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN2.
static const field_t hw_epdc_tce_hscan2[] =
{
    {
        "LINE_BEGIN",
        "Number of PIXCLK cycles for line begin duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_END",
        "Number of PIXCLK cycles for line end duration.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_VSCAN.
static const field_t hw_epdc_tce_vscan[] =
{
    {
        "FRAME_SYNC",
        "Number of lines for frame sync duration.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_BEGIN",
        "Number of lines for frame begin duration.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END",
        "Number of lines for frame end duration.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_OE.
static const field_t hw_epdc_tce_oe[] =
{
    {
        "SDOEZ_DLY",
        "Number of PIXCLK cycles from SDLE falling edge to SDOEZ rising (Must b"
        "e greater than 0)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOEZ_WIDTH",
        "Number of PIXCLK cycles from SDOEZ high to SDOEZ falling (Must be grea"
        "ter than 0)",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_DLY",
        "Number of PIXCLK cycles from SDOEZ low to SDOED rising (Must be greate"
        "r than 0)",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_WIDTH",
        "Number of PIXCLK cycles from SDOED high to SDOED falling (Must be grea"
        "ter than 0)",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_POLARITY.
static const field_t hw_epdc_tce_polarity[] =
{
    {
        "SDCE_POL",
        "0 = Active Low, 1 = Active High.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_POL",
        "0 = Active Low, 1 = Active High.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOE_POL",
        "0 = Active Low, 1 = Active High.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_POL",
        "0 = Active Low, 1 = Active High.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDSP_POL",
        "0 = Active Low, 1 = Active High.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING1.
static const field_t hw_epdc_tce_timing1[] =
{
    {
        "SDCLK_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 4 cycle"
        "s",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_INVERT",
        "Invert phase of SDCLK",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 3 PIXCL"
        "K cycles",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING2.
static const field_t hw_epdc_tce_timing2[] =
{
    {
        "GDSP_OFFSET",
        "This register allows the user to shift the GDSP pulse by N PIXCLKs whe"
        "re N=1 to 65535.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDCLK_HP",
        "This register controls the GDCLK high-pulse width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING3.
static const field_t hw_epdc_tce_timing3[] =
{
    {
        "GDCLK_OFFSET",
        "This register allows the user to shift the GDCLK from the line time by"
        " N PIXCLK cycles.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_OFFSET",
        "When using GDOE_MODE=1, this register sets the delay from GDCLK to the"
        " GDOE in terms of N PIXCLK cycles",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL0.
static const field_t hw_epdc_pigeon_ctrl0[] =
{
    {
        "FD_PERIOD",
        "period of line counter during FD phase",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LD_PERIOD",
        "period of pclk counter during LD phase",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL1.
static const field_t hw_epdc_pigeon_ctrl1[] =
{
    {
        "FRAME_CNT_PERIOD",
        "period of frame counter",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_CNT_CYCLES",
        "max cycles of frame counter",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK1.
static const field_t hw_epdc_irq_mask1[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT0~31 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK2.
static const field_t hw_epdc_irq_mask2[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT32~64 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ1.
static const field_t hw_epdc_irq1[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 0~31 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ2.
static const field_t hw_epdc_irq2[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 32~64 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK.
static const field_t hw_epdc_irq_mask[] =
{
    {
        "WB_CMPLT_IRQ_EN",
        "Enable WB complete interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COL_IRQ_EN",
        "Enable collision detection interrupts for all LUTs",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ_EN",
        "Enable pixel FIFO under-run condition detection.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ_EN",
        "If this bit is set, EPDC will assert the current frame end interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ_EN",
        "Enable AXI BUS ERROR interrupt detection.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ_EN",
        "Enable TCE Idle interrupt detection.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ_EN",
        "Enable UPD complete interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ_EN",
        "Enable power interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ.
static const field_t hw_epdc_irq[] =
{
    {
        "WB_CMPLT_IRQ",
        "Working buffer process complete Interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_COL_IRQ",
        "Collision detection interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ",
        "Interrupt to indicate that a pixel FIFO under-run has occured.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ",
        "Interrupt to indicate EPDC has completed the current frame and is in t"
        "he vertical blanking period.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ",
        "Interrupt to indicate AXI BUS error occurs.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ",
        "Interrupt to indicate that the TCE has completed TFT frame scans and i"
        "s in an idle state.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ",
        "Working buffer process complete Interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ",
        "Power Interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS1.
static const field_t hw_epdc_status_luts1[] =
{
    {
        "LUTN_STS",
        "LUT 0~31 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS2.
static const field_t hw_epdc_status_luts2[] =
{
    {
        "LUTN_STS",
        "LUT 32~63 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_NEXTLUT.
static const field_t hw_epdc_status_nextlut[] =
{
    {
        "NEXT_LUT",
        "Next available LUT value",
        0, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXT_LUT_VALID",
        "This bitfield can be used to check against a LUTs full condition",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL1.
static const field_t hw_epdc_status_col1[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL2.
static const field_t hw_epdc_status_col2[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS.
static const field_t hw_epdc_status[] =
{
    {
        "WB_BUSY",
        "Working buffer process is busy cannot accept new update requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_BUSY",
        "Provides a summary status of LUTs.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_UNDERRUN",
        "Provides a summary status of LUT fill.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UPD_VOID",
        "shows the update buffer is void (don't need any real pixel update)",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HISTOGRAM_NP",
        "Indicates which histogram matched the processed bitmap(NP).",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HISTOGRAM_CP",
        "Indicates which histogram matched the existing bitmap(CP).",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_COL_CORD.
static const field_t hw_epdc_upd_col_cord[] =
{
    {
        "XCORD",
        "X co-ordinate for collision region of the latest completed update",
        0, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YCORD",
        "Y co-ordinate for collision region of the latest completed update",
        16, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_COL_SIZE.
static const field_t hw_epdc_upd_col_size[] =
{
    {
        "WIDTH",
        "Width (in pixels)",
        0, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HEIGHT",
        "Height (in pixels)",
        16, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST1_PARAM.
static const field_t hw_epdc_hist1_param[] =
{
    {
        "VALUE0",
        "value for 1-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST2_PARAM.
static const field_t hw_epdc_hist2_param[] =
{
    {
        "VALUE0",
        "Black value for 2-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "White value for 2-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST4_PARAM.
static const field_t hw_epdc_hist4_param[] =
{
    {
        "VALUE0",
        "GRAY0 (Black) value for 4-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "GRAY1 value for 4-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE2",
        "GRAY2 value for 4-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE3",
        "GRAY3 (White) value for 4-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST8_PARAM0.
static const field_t hw_epdc_hist8_param0[] =
{
    {
        "VALUE0",
        "GRAY0 (Black) value for 8-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "GRAY1 value for 8-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE2",
        "GRAY2 value for 8-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE3",
        "GRAY3 value for 8-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST8_PARAM1.
static const field_t hw_epdc_hist8_param1[] =
{
    {
        "VALUE4",
        "GRAY4 value for 8-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE5",
        "GRAY5 value for 8-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE6",
        "GRAY6 value for 8-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE7",
        "GRAY7 (White) value for 8-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM0.
static const field_t hw_epdc_hist16_param0[] =
{
    {
        "VALUE0",
        "GRAY0 (Black) value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "GRAY1 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE2",
        "GRAY2 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE3",
        "GRAY3 value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM1.
static const field_t hw_epdc_hist16_param1[] =
{
    {
        "VALUE4",
        "GRAY4 value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE5",
        "GRAY5 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE6",
        "GRAY6 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE7",
        "GRAY7 value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM2.
static const field_t hw_epdc_hist16_param2[] =
{
    {
        "VALUE8",
        "GRAY8 value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE9",
        "GRAY9 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE10",
        "GRAY10 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE11",
        "GRAY11 value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM3.
static const field_t hw_epdc_hist16_param3[] =
{
    {
        "VALUE12",
        "GRAY12 value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE13",
        "GRAY13 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE14",
        "GRAY14 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE15",
        "GRAY15 (White) value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_GPIO.
static const field_t hw_epdc_gpio[] =
{
    {
        "BDR",
        "Controls ipp_epdc_bdr[1:0] output",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCTRL",
        "Controls ipp_epdc_pwrctrl[3:0] output",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCOM",
        "Controls ipp_epdc_pwrcom output",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRWAKE",
        "Controls ipp_epdc_pwrwake output",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRSTAT",
        "reflect ipp_epdc_pwrstat input",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_VERSION.
static const field_t hw_epdc_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_0_0.
static const field_t hw_epdc_pigeon_0_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_0_1.
static const field_t hw_epdc_pigeon_0_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_0_2.
static const field_t hw_epdc_pigeon_0_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_1_0.
static const field_t hw_epdc_pigeon_1_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_1_1.
static const field_t hw_epdc_pigeon_1_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_1_2.
static const field_t hw_epdc_pigeon_1_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_2_0.
static const field_t hw_epdc_pigeon_2_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_2_1.
static const field_t hw_epdc_pigeon_2_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_2_2.
static const field_t hw_epdc_pigeon_2_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_3_0.
static const field_t hw_epdc_pigeon_3_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_3_1.
static const field_t hw_epdc_pigeon_3_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_3_2.
static const field_t hw_epdc_pigeon_3_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_4_0.
static const field_t hw_epdc_pigeon_4_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_4_1.
static const field_t hw_epdc_pigeon_4_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_4_2.
static const field_t hw_epdc_pigeon_4_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_5_0.
static const field_t hw_epdc_pigeon_5_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_5_1.
static const field_t hw_epdc_pigeon_5_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_5_2.
static const field_t hw_epdc_pigeon_5_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_6_0.
static const field_t hw_epdc_pigeon_6_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_6_1.
static const field_t hw_epdc_pigeon_6_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_6_2.
static const field_t hw_epdc_pigeon_6_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_7_0.
static const field_t hw_epdc_pigeon_7_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_7_1.
static const field_t hw_epdc_pigeon_7_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_7_2.
static const field_t hw_epdc_pigeon_7_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_8_0.
static const field_t hw_epdc_pigeon_8_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_8_1.
static const field_t hw_epdc_pigeon_8_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_8_2.
static const field_t hw_epdc_pigeon_8_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_9_0.
static const field_t hw_epdc_pigeon_9_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_9_1.
static const field_t hw_epdc_pigeon_9_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_9_2.
static const field_t hw_epdc_pigeon_9_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_10_0.
static const field_t hw_epdc_pigeon_10_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_10_1.
static const field_t hw_epdc_pigeon_10_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_10_2.
static const field_t hw_epdc_pigeon_10_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_11_0.
static const field_t hw_epdc_pigeon_11_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_11_1.
static const field_t hw_epdc_pigeon_11_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_11_2.
static const field_t hw_epdc_pigeon_11_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_12_0.
static const field_t hw_epdc_pigeon_12_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_12_1.
static const field_t hw_epdc_pigeon_12_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_12_2.
static const field_t hw_epdc_pigeon_12_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_13_0.
static const field_t hw_epdc_pigeon_13_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_13_1.
static const field_t hw_epdc_pigeon_13_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_13_2.
static const field_t hw_epdc_pigeon_13_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_14_0.
static const field_t hw_epdc_pigeon_14_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_14_1.
static const field_t hw_epdc_pigeon_14_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_14_2.
static const field_t hw_epdc_pigeon_14_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_15_0.
static const field_t hw_epdc_pigeon_15_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_15_1.
static const field_t hw_epdc_pigeon_15_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_15_2.
static const field_t hw_epdc_pigeon_15_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal  sigout : final output signal of t"
        "his generator  mask : final mask of this generator  this_sig : interme"
        "diate signal of this generator before logic operation  other_masks : i"
        "ntermediate mask result of this generator before logic operation  sig_"
        "another : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_ADDR_TCE.
static const field_t hw_epdc_wb_addr_tce[] =
{
    {
        "ADDR",
        "Address for EPDC working buffer (only for TCE).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a EPDC module.
static const reg_t hw_epdc[] =
{
    {
        "CTRL",
        "EPDC Main control register  This register controls various high-level "
        "functions of the EPDC",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_epdc_ctrl
    },
    {
        "WVADDR",
        "EPDC Waveform Address Pointer  N/A   EXAMPLE   N/A",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_wvaddr
    },
    {
        "WB_ADDR",
        "EPDC Working Buffer Address  This register controls various functions "
        "throughout the digital portion of the chip.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_wb_addr
    },
    {
        "RES",
        "EPDC Screen Resolution.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_res
    },
    {
        "FORMAT",
        "EPDC Pixel format control register.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_format
    },
    {
        "FIFOCTRL",
        "Allows for programmability of pixel FIFO watermarks used in conjunctio"
        "n with system arbitration hardware  This register houses FIFO control "
        "bits",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_fifoctrl
    },
    {
        "UPD_ADDR",
        "EPDC Update Region Address  When stride feature not enabled(EPDC_UPD_S"
        "TRIDE==0), it must be aligned to 64-bit boundary, this is default beha"
        "vior to keep compatible like before; When stride feature is enabled(EP"
        "DC_UPD_STRIDE!=0), it can start from any byte address, no alignment re"
        "quirement, but still recomended be aligned get best bus performance.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_upd_addr
    },
    {
        "UPD_STRIDE",
        "EPDC Update Region Stride  When UPD_STRIDE==0 (stride feature disabled"
        "), UPD buffer line must start from 64-bit boundary and end on 64-bit b"
        "oundary(padding if not).",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_upd_stride
    },
    {
        "UPD_CORD",
        "EPDC Update Command Co-ordinate  N/A   EXAMPLE   N/A",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_upd_cord
    },
    {
        "UPD_SIZE",
        "EPDC Update Command Size  This register controls various functions thr"
        "oughout the digital portion of the chip.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_upd_size
    },
    {
        "UPD_CTRL",
        "EPDC Update Command Control.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_epdc_upd_ctrl
    },
    {
        "UPD_FIXED",
        "EPDC Update Control register for fixed-pixel updates (enabled via EPDC"
        "_UPD_CTRL[USE_FIXED])",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_upd_fixed
    },
    {
        "TEMP",
        "EPDC Temperature Compensation Register  N/A   EXAMPLE   N/A",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_temp
    },
    {
        "AUTOWV_LUT",
        "This register is used to access the waveform mode lookup table.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_autowv_lut
    },
    {
        "TCE_CTRL",
        "TCE general control register  This register houses Horizontal scan tim"
        "ing.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_epdc_tce_ctrl
    },
    {
        "TCE_SDCFG",
        "Source-driver configuration register",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_epdc_tce_sdcfg
    },
    {
        "TCE_GDCFG",
        "This register houses gate-driver configuration.",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_tce_gdcfg
    },
    {
        "TCE_HSCAN1",
        "Horizontal scan timing registers.",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_tce_hscan1
    },
    {
        "TCE_HSCAN2",
        "Horizontal scan timing registers.",
        4, // Width in bytes
        0x00000280, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_tce_hscan2
    },
    {
        "TCE_VSCAN",
        "Vertical scan timing registers  This register houses vertical scan tim"
        "ing.",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_epdc_tce_vscan
    },
    {
        "TCE_OE",
        "This register contain delay programming values for the SDOEZ and SDOED"
        " source driver control signals  This register contain delay programmin"
        "g values for the SDOZ and SDOE source driver control signals",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_tce_oe
    },
    {
        "TCE_POLARITY",
        "This registers allows for programming the polarity of source/gate driv"
        "er control signals  This register houses FIFO control bits",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_epdc_tce_polarity
    },
    {
        "TCE_TIMING1",
        "This register contains various timing adjustment controls  This regist"
        "er houses general purpose timing adjustment registers",
        4, // Width in bytes
        0x00000300, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_epdc_tce_timing1
    },
    {
        "TCE_TIMING2",
        "This register contains various timing adjustment controls  This regist"
        "er houses general purpose timing adjustment registers",
        4, // Width in bytes
        0x00000310, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_tce_timing2
    },
    {
        "TCE_TIMING3",
        "This register contains various timing adjustment controls  This regist"
        "er houses general purpose timing adjustment registers",
        4, // Width in bytes
        0x00000320, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_tce_timing3
    },
    {
        "PIGEON_CTRL0",
        "This register contains global counter settings for Pigeon Mode  This r"
        "egister houses general purpose timing adjustment registers",
        4, // Width in bytes
        0x00000380, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_ctrl0
    },
    {
        "PIGEON_CTRL1",
        "This register contains global counter setting for pigeon mode  This re"
        "gister houses general purpose timing adjustment registers",
        4, // Width in bytes
        0x00000390, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_ctrl1
    },
    {
        "IRQ_MASK1",
        "Controls masking EPDC LUT complete interrupts  This register controls "
        "LUT0~31 IRQ masks for EPDC interrupts",
        4, // Width in bytes
        0x000003c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_irq_mask1
    },
    {
        "IRQ_MASK2",
        "Controls masking EPDC LUT complete interrupts  This register controls "
        "LUT0~31 IRQ masks for EPDC interrupts",
        4, // Width in bytes
        0x000003d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_irq_mask2
    },
    {
        "IRQ1",
        "EPDC LUT Completion IRQs.",
        4, // Width in bytes
        0x000003e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_irq1
    },
    {
        "IRQ2",
        "EPDC LUT Completion IRQs.",
        4, // Width in bytes
        0x000003f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_irq2
    },
    {
        "IRQ_MASK",
        "Controls masking for all EPDC interrupts  This register controls IRQ m"
        "asks for all EPDC interrupts",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_epdc_irq_mask
    },
    {
        "IRQ",
        "EPDC LUT Completion IRQs.",
        4, // Width in bytes
        0x00000420, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_epdc_irq
    },
    {
        "STATUS_LUTS1",
        "EPDC Status Register - LUTS 0~31",
        4, // Width in bytes
        0x00000440, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_status_luts1
    },
    {
        "STATUS_LUTS2",
        "EPDC Status Register - LUTS 0~31",
        4, // Width in bytes
        0x00000450, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_status_luts2
    },
    {
        "STATUS_NEXTLUT",
        "Holds value of next available LUT.",
        4, // Width in bytes
        0x00000460, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_status_nextlut
    },
    {
        "STATUS_COL1",
        "EPDC LUT Collision Status Register and works in conjuction with EPDC_I"
        "RQ[LUT_COL_IRQ].",
        4, // Width in bytes
        0x00000480, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_status_col1
    },
    {
        "STATUS_COL2",
        "EPDC LUT Collision Status Register and works in conjuction with EPDC_I"
        "RQ[LUT_COL_IRQ].",
        4, // Width in bytes
        0x00000490, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_status_col2
    },
    {
        "STATUS",
        "Register to house non LUT specific status bits  This register houses g"
        "eneral status bits",
        4, // Width in bytes
        0x000004a0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_epdc_status
    },
    {
        "UPD_COL_CORD",
        "EPDC Collision Region Co-ordinate, cleared when new update issued  Thi"
        "s register only valid after WB completion and collision happens.",
        4, // Width in bytes
        0x000004c0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_upd_col_cord
    },
    {
        "UPD_COL_SIZE",
        "EPDC Collision Region Size of the latest completed update cleared when"
        " new update issued  This register only valid after WB completion and c"
        "ollision happens.",
        4, // Width in bytes
        0x000004e0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_upd_col_size
    },
    {
        "HIST1_PARAM",
        "This register specifies the valid values for a 1-level(single color) h"
        "istogram.",
        4, // Width in bytes
        0x00000600, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_hist1_param
    },
    {
        "HIST2_PARAM",
        "This register specifies the valid values for a 2-level histogram.",
        4, // Width in bytes
        0x00000610, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_hist2_param
    },
    {
        "HIST4_PARAM",
        "This register specifies the valid values for a 4-level histogram.",
        4, // Width in bytes
        0x00000620, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_hist4_param
    },
    {
        "HIST8_PARAM0",
        "This register specifies four of the valid values for an 8-level histog"
        "ram.",
        4, // Width in bytes
        0x00000630, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_hist8_param0
    },
    {
        "HIST8_PARAM1",
        "This register specifies four of the valid values for an 8-level histog"
        "ram.",
        4, // Width in bytes
        0x00000640, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_hist8_param1
    },
    {
        "HIST16_PARAM0",
        "This register specifies four of the valid values for a 16-level histog"
        "ram.",
        4, // Width in bytes
        0x00000650, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_hist16_param0
    },
    {
        "HIST16_PARAM1",
        "This register specifies four of the valid values for a 16-level histog"
        "ram.",
        4, // Width in bytes
        0x00000660, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_hist16_param1
    },
    {
        "HIST16_PARAM2",
        "This register specifies four of the valid values for a 16-level histog"
        "ram.",
        4, // Width in bytes
        0x00000670, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_hist16_param2
    },
    {
        "HIST16_PARAM3",
        "This register specifies four of the valid values for a 16-level histog"
        "ram.",
        4, // Width in bytes
        0x00000680, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_epdc_hist16_param3
    },
    {
        "GPIO",
        "GPIO register to control ipp_epdc_bdr[1:0], ipp_epdc_pwr[3:0] and ipp_"
        "epdc_pwrcom output signals  Houses software control signal reisters",
        4, // Width in bytes
        0x00000700, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_epdc_gpio
    },
    {
        "VERSION",
        "This register reflects the version number for the EPDC.",
        4, // Width in bytes
        0x000007f0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_epdc_version
    },
    {
        "PIGEON_0_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000800, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_0_0
    },
    {
        "PIGEON_0_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000810, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_0_1
    },
    {
        "PIGEON_0_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000820, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_0_2
    },
    {
        "PIGEON_1_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000840, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_1_0
    },
    {
        "PIGEON_1_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000850, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_1_1
    },
    {
        "PIGEON_1_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000860, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_1_2
    },
    {
        "PIGEON_2_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000880, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_2_0
    },
    {
        "PIGEON_2_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000890, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_2_1
    },
    {
        "PIGEON_2_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000008a0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_2_2
    },
    {
        "PIGEON_3_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000008c0, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_3_0
    },
    {
        "PIGEON_3_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000008d0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_3_1
    },
    {
        "PIGEON_3_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000008e0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_3_2
    },
    {
        "PIGEON_4_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000900, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_4_0
    },
    {
        "PIGEON_4_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000910, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_4_1
    },
    {
        "PIGEON_4_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000920, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_4_2
    },
    {
        "PIGEON_5_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000940, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_5_0
    },
    {
        "PIGEON_5_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000950, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_5_1
    },
    {
        "PIGEON_5_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000960, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_5_2
    },
    {
        "PIGEON_6_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000980, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_6_0
    },
    {
        "PIGEON_6_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000990, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_6_1
    },
    {
        "PIGEON_6_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000009a0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_6_2
    },
    {
        "PIGEON_7_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000009c0, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_7_0
    },
    {
        "PIGEON_7_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000009d0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_7_1
    },
    {
        "PIGEON_7_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x000009e0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_7_2
    },
    {
        "PIGEON_8_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a00, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_8_0
    },
    {
        "PIGEON_8_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a10, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_8_1
    },
    {
        "PIGEON_8_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a20, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_8_2
    },
    {
        "PIGEON_9_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a40, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_9_0
    },
    {
        "PIGEON_9_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a50, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_9_1
    },
    {
        "PIGEON_9_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a60, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_9_2
    },
    {
        "PIGEON_10_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a80, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_10_0
    },
    {
        "PIGEON_10_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000a90, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_10_1
    },
    {
        "PIGEON_10_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000aa0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_10_2
    },
    {
        "PIGEON_11_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000ac0, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_11_0
    },
    {
        "PIGEON_11_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000ad0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_11_1
    },
    {
        "PIGEON_11_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000ae0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_11_2
    },
    {
        "PIGEON_12_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b00, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_12_0
    },
    {
        "PIGEON_12_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b10, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_12_1
    },
    {
        "PIGEON_12_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b20, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_12_2
    },
    {
        "PIGEON_13_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b40, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_13_0
    },
    {
        "PIGEON_13_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b50, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_13_1
    },
    {
        "PIGEON_13_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b60, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_13_2
    },
    {
        "PIGEON_14_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b80, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_14_0
    },
    {
        "PIGEON_14_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000b90, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_14_1
    },
    {
        "PIGEON_14_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000ba0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_14_2
    },
    {
        "PIGEON_15_0",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000bc0, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_epdc_pigeon_15_0
    },
    {
        "PIGEON_15_1",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000bd0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_15_1
    },
    {
        "PIGEON_15_2",
        "parameters for timing signal generation",
        4, // Width in bytes
        0x00000be0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_epdc_pigeon_15_2
    },
    {
        "WB_ADDR_TCE",
        "EPDC Working Buffer Address used by TCE only",
        4, // Width in bytes
        0x00000c10, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epdc_wb_addr_tce
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EPIT
#endif

// Bitfields in register EPIT_CR.
static const field_t hw_epit_cr[] =
{
    {
        "EN",
        "This bit enables the EPIT.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENMOD",
        "EPIT enable mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCIEN",
        "Output compare interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RLD",
        "Counter reload control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALAR",
        "Counter clock prescaler value.",
        4, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Software reset.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IOVW",
        "EPIT counter overwrite enable.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "This bit is used to keep the EPIT functional in debug mode.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAITEN",
        "This read/write control bit enables the operation of the EPIT during w"
        "ait mode.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "EPIT stop mode enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM",
        "EPIT output mode.This bit field determines the mode of EPIT output on "
        "the output pin.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKSRC",
        "Select clock source  These bits determine which clock input is to be s"
        "elected for running the counter.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_SR.
static const field_t hw_epit_sr[] =
{
    {
        "OCIF",
        "Output compare interrupt flag.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_LR.
static const field_t hw_epit_lr[] =
{
    {
        "LOAD",
        "Load value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CMPR.
static const field_t hw_epit_cmpr[] =
{
    {
        "COMPARE",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CNR.
static const field_t hw_epit_cnr[] =
{
    {
        "COUNT",
        "Counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a EPIT module.
static const reg_t hw_epit[] =
{
    {
        "CR",
        "The EPIT control register (EPIT_CR) is used to configure the operating"
        " settings of the EPIT.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_epit_cr
    },
    {
        "SR",
        "The EPIT status register (EPIT_SR) has a single status bit for the out"
        "put compare event.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_sr
    },
    {
        "LR",
        "The EPIT load register (EPIT_LR) contains the value that is to be load"
        "ed into the counter when EPIT counter reaches zero if the RLD bit in E"
        "PIT_CR is set.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_lr
    },
    {
        "CMPR",
        "The EPIT compare register (EPIT_CMPR) holds the value that determines "
        "when a compare event is generated.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_cmpr
    },
    {
        "CNR",
        "The EPIT counter register (EPIT_CNR) contains the current count value "
        "and can be read at any time without disturbing the counter.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_epit_cnr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark FEC
#endif

// Bitfields in register FEC_EIR.
static const field_t hw_fec_eir[] =
{
    {
        "UN",
        "Transmit FIFO underrun.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Collision retry limit.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Late collision.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Ethernet bus error.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "MII interrupt.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Receive buffer interrupt.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Receive frame interrupt.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Transmit buffer interrupt.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Transmit frame interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "Graceful stop complete.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Babbling transmit error.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Babbling receive error.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBERR",
        "Heartbeat error.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_EIMR.
static const field_t hw_fec_eimr[] =
{
    {
        "UN",
        "Interrupt mask.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Interrupt mask.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Interrupt mask.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Interrupt mask.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Interrupt mask.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Interrupt mask.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Interrupt mask.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Interrupt mask.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Interrupt mask.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "Interrupt mask.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Interrupt mask.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Interrupt mask.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBERR",
        "Interrupt mask.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_RDAR.
static const field_t hw_fec_rdar[] =
{
    {
        "R_DES_ACTIVE",
        "Set to one when this register is written, regardless of the value writ"
        "ten.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_TDAR.
static const field_t hw_fec_tdar[] =
{
    {
        "X_DES_ACTIVE",
        "Set to one when this register is written, regardless of the value writ"
        "ten.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_ECR.
static const field_t hw_fec_ecr[] =
{
    {
        "RESET",
        "When this bit is set, the equivalent of a hardware reset is performed "
        "but it is local to the FEC, ETHER_EN is cleared and all other FEC regi"
        "sters take their reset values.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETHER_EN",
        "When this bit is set, the FEC is enabled, and reception and transmissi"
        "on are possible.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_MMFR.
static const field_t hw_fec_mmfr[] =
{
    {
        "DATA",
        "Management frame data.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TA",
        "Turn around.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RA",
        "Register address.",
        18, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PA",
        "PHY address.",
        23, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OP",
        "Operation code.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ST",
        "Start of frame delimiter.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_MSCR.
static const field_t hw_fec_mscr[] =
{
    {
        "MII_SPEED",
        "MII_SPEED controls the frequency of the MII management interface clock"
        " (FEC_MDC) relative to the system clock.",
        1, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_PREAMBLE",
        "Asserting this bit causes preamble (0xFFFF_FFFF) not to be prepended t"
        "o the MII management frame.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_MIBC.
static const field_t hw_fec_mibc[] =
{
    {
        "MB_IDLE",
        "A read-only status bit.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIB_DISABLE",
        "A read/write control bit.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_RCR.
static const field_t hw_fec_rcr[] =
{
    {
        "LOOP",
        "Internal loopback.When LOOP is set to 1, transmitted frames are looped"
        " back internal to the device and the transmit output signals are not a"
        "sserted.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRT",
        "Disable receive on transmit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII_MODE",
        "Media independent interface mode.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROM",
        "Promiscuous mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BC_REJ",
        "Broadcast frame reject.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCE",
        "Flow control enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAX_FL",
        "Maximum frame length.",
        16, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_TCR.
static const field_t hw_fec_tcr[] =
{
    {
        "GTS",
        "Graceful transmit stop.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBC",
        "Heartbeat control.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FDEN",
        "Full duplex enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFC_PAUSE",
        "Transmit frame control pause.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFC_PAUSE",
        "Receive frame control pause.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_PALR.
static const field_t hw_fec_palr[] =
{
    {
        "PADDR1",
        "Bytes 0 (bits 31:24), 1 (bits 23:16), 2 (bits 15:8) and 3 (bits 7:0) o"
        "f the 6-byte individual address to be used for exact match, and the so"
        "urce address field in pause frames.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_PAUR.
static const field_t hw_fec_paur[] =
{
    {
        "TYPE",
        "Type field in pause frames.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PADDR2",
        "Bytes 4 (bits 31:24) and 5 (bits 23:16) of the 6-byte individual addre"
        "ss to be used for exact match, and the source address field in pause f"
        "rames.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_OPDR.
static const field_t hw_fec_opdr[] =
{
    {
        "PAUSE_DUR",
        "Pause duration field used in pause frames.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE",
        "Opcode field used in pause frames.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_IAUR.
static const field_t hw_fec_iaur[] =
{
    {
        "IADDR1",
        "The upper 32 bits of the 64-bit hash table used in the address recogni"
        "tion process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_IALR.
static const field_t hw_fec_ialr[] =
{
    {
        "IADDR2",
        "The lower 32 bits of the 64-bit hash table used in the address recogni"
        "tion process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_GAUR.
static const field_t hw_fec_gaur[] =
{
    {
        "GADDR1",
        "The GADDR1 register contains the upper 32 bits of the 64-bit hash tabl"
        "e used in the address recognition process for receive frames with a mu"
        "lticast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_GALR.
static const field_t hw_fec_galr[] =
{
    {
        "GADDR2",
        "The GADDR2 register contains the lower 32 bits of the 64-bit hash tabl"
        "e used in the address recognition process for receive frames with a mu"
        "lticast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_TFWR.
static const field_t hw_fec_tfwr[] =
{
    {
        "X_WMRK",
        "Number of bytes written to transmit FIFO before transmission of a fram"
        "e begins",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_FRBR.
static const field_t hw_fec_frbr[] =
{
    {
        "R_BOUND",
        "Read-only.",
        2, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_FRSR.
static const field_t hw_fec_frsr[] =
{
    {
        "R_FSTART",
        "Address of first receive FIFO location.",
        2, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_ERDSR.
static const field_t hw_fec_erdsr[] =
{
    {
        "R_DES_START",
        "Pointer to start of receive buffer descriptor queue.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_ETDSR.
static const field_t hw_fec_etdsr[] =
{
    {
        "X_DES_START",
        "Pointer to start of transmit buffer descriptor queue.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FEC_EMRBR.
static const field_t hw_fec_emrbr[] =
{
    {
        "R_BUF_SIZE",
        "Receive buffer size.",
        4, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a FEC module.
static const reg_t hw_fec[] =
{
    {
        "EIR",
        "The FEC_EIR bit assignments are shown below.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fec_eir
    },
    {
        "EIMR",
        "The FEC_EIMR controls which of the interrupt events flagged in the FEC"
        "_EIR are allowed to generate actual interrupts.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fec_eimr
    },
    {
        "RDAR",
        "FEC_RDAR is a user-writeable command register which indicates that the"
        " receive descriptor ring has been updated, and that empty receive buff"
        "ers have been produced by the driver with the empty bit in RxBD set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_rdar
    },
    {
        "TDAR",
        "The FEC_TDAR is a command register,which is written by the user, to in"
        "dicate that the transmit descriptor ring has been updated (transmit bu"
        "ffers have been produced by the driver with the ready bit set in the b"
        "uffer descriptor).",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_tdar
    },
    {
        "ECR",
        "The ECR is used to enable/disable the FEC_ ECR which is a read/write u"
        "ser register, though both fields in this register can also be altered "
        "by hardware.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_fec_ecr
    },
    {
        "MMFR",
        "The FEC_MMFR is used to communicate with the attached MII compatible P"
        "HY device(s) by providing read/write access to their MII registers.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_fec_mmfr
    },
    {
        "MSCR",
        "The FEC_MSCR provides control of the frequency of the MII clock (FEC_M"
        "DC signal), and allows a preamble drop on the MII management frame .",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_fec_mscr
    },
    {
        "MIBC",
        "The MIB control register is a read/write register which is used to pro"
        "vide control of and to observe the state of the Message Information Bl"
        "ock (MIB).",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_fec_mibc
    },
    {
        "RCR",
        "The FEC_RCR is programmed by the user, and controls the operational mo"
        "de of the receive block.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_fec_rcr
    },
    {
        "TCR",
        "This register is read/write register which is written by the user to c"
        "onfigure the transmit block.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_fec_tcr
    },
    {
        "PALR",
        "The FEC_PALR, which is written by the user, contains the lower 32 bits"
        " (bytes 0,1,2,3) of the 48-bit address used in the address recognition"
        " process to check for possible match between the DA field of receive f"
        "rames and an individual DA.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_palr
    },
    {
        "PAUR",
        "The FEC_PAUR, which is written by the user, and contains the upper 16 "
        "bits (bytes 4 and 5) of the 48-bit address used in the address recogni"
        "tion process to check for possible match between the DA field of recei"
        "ve frames and an individual DA.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_fec_paur
    },
    {
        "OPDR",
        "FEC_OPDR contains the 16-bit Opcode, and 16-bit pause duration fields "
        "used in transmission of a pause frame.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_fec_opdr
    },
    {
        "IAUR",
        "The FEC_IAUR, which is written by the user, contains the upper 32 bits"
        " of the 64-bit individual address hash table used in the address recog"
        "nition process to check for possible match between the DA field of rec"
        "eive frames and an individual DA.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_iaur
    },
    {
        "IALR",
        "The FEC_IALR, which is written by the user, contains the lower 32 bits"
        " of the 64-bit individual address hash table used in the address recog"
        "nition process to check for possible match with the DA field of receiv"
        "e frames with an individual DA.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_ialr
    },
    {
        "GAUR",
        "The FEC_GAUR, which is written by the user, contains the upper 32 bits"
        " of the 64-bit hash table used in the address recognition process for "
        "receive frames with a multicast address.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_gaur
    },
    {
        "GALR",
        "The FEC_GALR, which is written by the user, contains the lower 32 bits"
        " of the 64-bit hash table used in the address recognition process for "
        "receive frames with a multicast address.",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_galr
    },
    {
        "TFWR",
        "The FEC_TFWR is programmed by the user to control the amount of data r"
        "equired in the transmit FIFO before transmission of a frame can begin.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_tfwr
    },
    {
        "FRBR",
        "The FEC_FRBR register can be read to determine the upper address bound"
        " of the FIFO RAM.",
        4, // Width in bytes
        0x0000014c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_fec_frbr
    },
    {
        "FRSR",
        "FEC_FRSR is an 8-bit register programmed by the user to indicate the s"
        "tarting address of the receive FIFO.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_frsr
    },
    {
        "ERDSR",
        "The register, which is written by the user, provides a pointer to the "
        "start of the circular receive buffer descriptor queue in external memo"
        "ry.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_erdsr
    },
    {
        "ETDSR",
        "The register, which is written by the user, provides a pointer to the "
        "start of the circular transmit buffer descriptor queue in external mem"
        "ory.",
        4, // Width in bytes
        0x00000184, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_etdsr
    },
    {
        "EMRBR",
        "The FEC_EMRBR is a user-programmable register which dictates the maxim"
        "um size of all receive buffers.",
        4, // Width in bytes
        0x00000188, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fec_emrbr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPC
#endif

// Bitfields in register GPC_CNTR.
static const field_t hw_gpc_cntr[] =
{
    {
        "GPU_VPU_PDN_REQ",
        "GPU Power Down request.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_VPU_PUP_REQ",
        "GPU Power Up request.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFS0CR",
        "DVFS0 (ARM) Change request (bit is read-only)",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "GPCIRQM",
        "GPC interrupt/event masking",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_PGR.
static const field_t hw_gpc_pgr[] =
{
    {
        "DRCIC",
        "Debug ref cir in mux control",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR1.
static const field_t hw_gpc_imr1[] =
{
    {
        "IMR1",
        "IRQ[63:32] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR2.
static const field_t hw_gpc_imr2[] =
{
    {
        "IMR2",
        "IRQ[95:64] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR3.
static const field_t hw_gpc_imr3[] =
{
    {
        "IMR3",
        "IRQ[127:96] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR4.
static const field_t hw_gpc_imr4[] =
{
    {
        "IMR4",
        "IRQ[159:128] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR1.
static const field_t hw_gpc_isr1[] =
{
    {
        "ISR1",
        "IRQ[63:32] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR2.
static const field_t hw_gpc_isr2[] =
{
    {
        "ISR2",
        "IRQ[95:64] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR3.
static const field_t hw_gpc_isr3[] =
{
    {
        "ISR3",
        "IRQ[127:96] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR4.
static const field_t hw_gpc_isr4[] =
{
    {
        "ISR4",
        "IRQ[159:128] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPC module.
static const reg_t hw_gpc[] =
{
    {
        "CNTR",
        "CNTR - Interface control register",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpc_cntr
    },
    {
        "PGR",
        "PGR - Power Gating Register",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_pgr
    },
    {
        "IMR1",
        "IMR1 Register - masking of irq[63:32].",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr1
    },
    {
        "IMR2",
        "IMR2 Register - masking of irq[95:64].",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr2
    },
    {
        "IMR3",
        "IMR3 Register - masking of irq[127:96].",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr3
    },
    {
        "IMR4",
        "IMR4 Register - masking of irq[159:128].",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr4
    },
    {
        "ISR1",
        "ISR1 Register - status of irq [63:32].",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr1
    },
    {
        "ISR2",
        "ISR2 Register - status of irq [95:64].",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr2
    },
    {
        "ISR3",
        "ISR3 Register - status of irq [127:96].",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr3
    },
    {
        "ISR4",
        "ISR4 Register - status of irq [159:128].",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr4
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPIO
#endif

// Bitfields in register GPIO_DR.
static const field_t hw_gpio_dr[] =
{
    {
        "DR",
        "Data bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_GDIR.
static const field_t hw_gpio_gdir[] =
{
    {
        "GDIR",
        "GPIO direction bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PSR.
static const field_t hw_gpio_psr[] =
{
    {
        "PSR",
        "GPIO pad status bits (status bits).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ICR1.
static const field_t hw_gpio_icr1[] =
{
    {
        "ICR0",
        "Interrupt configuration 1 fields.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR1",
        "Interrupt configuration 1 fields.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR2",
        "Interrupt configuration 1 fields.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR3",
        "Interrupt configuration 1 fields.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR4",
        "Interrupt configuration 1 fields.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR5",
        "Interrupt configuration 1 fields.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR6",
        "Interrupt configuration 1 fields.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR7",
        "Interrupt configuration 1 fields.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR8",
        "Interrupt configuration 1 fields.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR9",
        "Interrupt configuration 1 fields.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR10",
        "Interrupt configuration 1 fields.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR11",
        "Interrupt configuration 1 fields.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR12",
        "Interrupt configuration 1 fields.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR13",
        "Interrupt configuration 1 fields.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR14",
        "Interrupt configuration 1 fields.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR15",
        "Interrupt configuration 1 fields.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ICR2.
static const field_t hw_gpio_icr2[] =
{
    {
        "ICR16",
        "Interrupt configuration 2 fields.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR17",
        "Interrupt configuration 2 fields.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR18",
        "Interrupt configuration 2 fields.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR19",
        "Interrupt configuration 2 fields.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR20",
        "Interrupt configuration 2 fields.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR21",
        "Interrupt configuration 2 fields.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR22",
        "Interrupt configuration 2 fields.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR23",
        "Interrupt configuration 2 fields.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR24",
        "Interrupt configuration 2 fields.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR25",
        "Interrupt configuration 2 fields.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR26",
        "Interrupt configuration 2 fields.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR27",
        "Interrupt configuration 2 fields.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR28",
        "Interrupt configuration 2 fields.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR29",
        "Interrupt configuration 2 fields.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR30",
        "Interrupt configuration 2 fields.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR31",
        "Interrupt configuration 2 fields.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_IMR.
static const field_t hw_gpio_imr[] =
{
    {
        "IMR",
        "Interrupt Mask bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ISR.
static const field_t hw_gpio_isr[] =
{
    {
        "ISR",
        "Interrupt status bits - Bit n of this register is asserted (active hig"
        "h) when the active condition (as determined by the corresponding ICR b"
        "it) is detected on the GPIO input and is waiting for service.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_EDGE_SEL.
static const field_t hw_gpio_edge_sel[] =
{
    {
        "GPIO_EDGE_SEL",
        "Edge select.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPIO module.
static const reg_t hw_gpio[] =
{
    {
        "DR",
        "The 32-bit GPIO_DR register stores data that is ready to be driven to "
        "the output lines.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_dr
    },
    {
        "GDIR",
        "GPIO_GDIR functions as direction control when the IOMUXC is in GPIO mo"
        "de.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_gdir
    },
    {
        "PSR",
        "GPIO_PSR is a read-only register.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpio_psr
    },
    {
        "ICR1",
        "GPIO_ICR1 contains 16 two-bit fields, where each field specifies the i"
        "nterrupt configuration for a different input signal.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_gpio_icr1
    },
    {
        "ICR2",
        "GPIO_ICR2 contains 16 two-bit fields, where each field specifies the i"
        "nterrupt configuration for a different input signal.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_gpio_icr2
    },
    {
        "IMR",
        "GPIO_IMR contains masking bits for each interrupt line.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_imr
    },
    {
        "ISR",
        "The GPIO_ISR functions as an interrupt status indicator.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_isr
    },
    {
        "EDGE_SEL",
        "GPIO_EDGE_SEL may be used to override the ICR registers' configuration"
        ".",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_edge_sel
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPT
#endif

// Bitfields in register GPT_CR.
static const field_t hw_gpt_cr[] =
{
    {
        "EN",
        "GPT Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENMOD",
        "GPT Enable mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "GPT debug mode enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAITEN",
        "GPT Wait Mode enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOZEEN",
        "GPT Doze Mode Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "GPT Stop Mode enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKSRC",
        "Clock Source select.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRR",
        "Free-Run or Restart mode.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "_24MEN",
        "Enable 24MHz clock input from crystal.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Software reset.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IM1",
        "See IM2",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IM2",
        "IM2 (bits 19-18, Input Capture Channel 2 operating mode)  IM1 (bits 17"
        "-16, Input Capture Channel 1 operating mode)  The IM n bit field deter"
        "mines the transition on the input pin (for Input capture channel n ), "
        "which will trigger a capture event.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM1",
        "See OM3",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM2",
        "See OM3",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM3",
        "OM3 (bits 28-26) controls the Output Compare Channel 3 operating mode.",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FO1",
        "See F03",
        29, // LSB
        29, // MSB
        false, // Readable
        true // Writable
    },
    {
        "FO2",
        "See F03",
        30, // LSB
        30, // MSB
        false, // Readable
        true // Writable
    },
    {
        "FO3",
        "FO3 Force Output Compare Channel 3  FO2 Force Output Compare Channel 2"
        "  FO1 Force Output Compare Channel 1  The FO n bit causes the pin acti"
        "on programmed for the timer Output Compare n pin (according to the OM "
        "n bits in this register).",
        31, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_PR.
static const field_t hw_gpt_pr[] =
{
    {
        "PRESCALER",
        "Prescaler bits.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALER24M",
        "Prescaler bits.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_SR.
static const field_t hw_gpt_sr[] =
{
    {
        "OF1",
        "See OF3",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2",
        "See OF3",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF3",
        "OF3 Output Compare 3 Flag  OF2 Output Compare 2 Flag  OF1 Output Compa"
        "re 1 Flag  The OF n bit indicates that a compare event has occurred on"
        " Output Compare channel n .",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF1",
        "See IF2",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF2",
        "IF2 Input capture 2 Flag  IF1 Input capture 1 Flag  The IF n bit indic"
        "ates that a capture event has occurred on Input Capture channel n .",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROV",
        "Rollover Flag.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_IR.
static const field_t hw_gpt_ir[] =
{
    {
        "OF1IE",
        "See OF3IE",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2IE",
        "See OF3IE",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF3IE",
        "OF3IE Output Compare 3 Interrupt Enable  OF2IE Output Compare 2 Interr"
        "upt Enable  OF1IE Output Compare 1 Interrupt Enable  The OF n IE bit c"
        "ontrols the Output Compare Channel n interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF1IE",
        "See IF2IE",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF2IE",
        "IF2IE Input capture 2 Interrupt Enable  IF1IE Input capture 1 Interrup"
        "t Enable  The IF n IE bit controls the IF n IE Input Capture n Interru"
        "pt Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROVIE",
        "Rollover Interrupt Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR1.
static const field_t hw_gpt_ocr1[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR2.
static const field_t hw_gpt_ocr2[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR3.
static const field_t hw_gpt_ocr3[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_ICR1.
static const field_t hw_gpt_icr1[] =
{
    {
        "CAPT",
        "Capture Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_ICR2.
static const field_t hw_gpt_icr2[] =
{
    {
        "CAPT",
        "Capture Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_CNT.
static const field_t hw_gpt_cnt[] =
{
    {
        "COUNT",
        "Counter Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPT module.
static const reg_t hw_gpt[] =
{
    {
        "CR",
        "The GPT Control Register (GPT_CR) is used to program and configure GPT"
        " operations.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_gpt_cr
    },
    {
        "PR",
        "The GPT Prescaler Register (GPT_PR) contains bits that determine the d"
        "ivide value of the clock that runs the counter.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_gpt_pr
    },
    {
        "SR",
        "The GPT Status Register (GPT_SR) contains bits that indicate that a co"
        "unter has rolled over, and if any event has occurred on the Input Capt"
        "ure and Output Compare channels.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpt_sr
    },
    {
        "IR",
        "The GPT Interrupt Register (GPT_IR) contains bits that control whether"
        " interrupts are generated after rollover, input capture and output com"
        "pare events.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpt_ir
    },
    {
        "OCR1",
        "The GPT Compare Register 1 (GPT_OCR1) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 1.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr1
    },
    {
        "OCR2",
        "The GPT Compare Register 2 (GPT_OCR2) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 2.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr2
    },
    {
        "OCR3",
        "The GPT Compare Register 3 (GPT_OCR3) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 3.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr3
    },
    {
        "ICR1",
        "The GPT Input Capture Register 1 (GPT_ICR1) is a read-only register th"
        "at holds the value that was in the counter during the last capture eve"
        "nt on Input Capture Channel 1.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_icr1
    },
    {
        "ICR2",
        "The GPT Input capture Register 2 (GPT_ICR2) is a read-only register wh"
        "ich holds the value that was in the counter during the last capture ev"
        "ent on input capture channel 2.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_icr2
    },
    {
        "CNT",
        "The GPT Counter Register (GPT_CNT) is the main counter's register.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_cnt
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPU2D
#endif

// Bitfields in register GPU2D_AQHICLOCKCONTROL.
static const field_t hw_gpu2d_aqhiclockcontrol[] =
{
    {
        "MULTI_PIPE_USE_SINGLE_AXI",
        "Force all the transactions to go to one AXI.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MULTI_PIPE_REG_SELECT",
        "Determines which HI/MC to use while reading registers.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISOLATE_GPU",
        "Isolate GPU bit",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE_VG",
        "VG pipe is idle.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE2_D",
        "2D pipe is idle.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE3_D",
        "3D pipe is idle.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOFT_RESET",
        "Soft resets the IP.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_DEBUG_REGISTERS",
        "Disable debug registers.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_RAM_CLOCK_GATING",
        "Disables clock gating for rams.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSCALE_CMD_LOAD",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSCALE_VAL",
        "",
        23, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK2D_DIS",
        "Disable 2D clock.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK3D_DIS",
        "Disable 3D clock.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQHIIDLE.
static const field_t hw_gpu2d_aqhiidle[] =
{
    {
        "AXI_LP",
        "AXI is in low power mode.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_TS",
        "TS is idle.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_FP",
        "FP is idle.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_IM",
        "IM is idle.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_VG",
        "VG is idle.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_TX",
        "TX is idle.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_RA",
        "RA is idle.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_SE",
        "SE is idle.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_PA",
        "PA is idle.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_SH",
        "SH is idle.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_PE",
        "PE is idle.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_DE",
        "DE is idle.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_FE",
        "FE is idle.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQAXICONFIG.
static const field_t hw_gpu2d_aqaxiconfig[] =
{
    {
        "ARCACHE",
        "",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWCACHE",
        "",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARID",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWID",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQAXISTATUS.
static const field_t hw_gpu2d_aqaxistatus[] =
{
    {
        "WR_ERR_ID",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RD_ERR_ID",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DET_WR_ERR",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DET_RD_ERR",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQINTRACKNOWLEDGE.
static const field_t hw_gpu2d_aqintracknowledge[] =
{
    {
        "INTR_VEC",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQINTRENBL.
static const field_t hw_gpu2d_aqintrenbl[] =
{
    {
        "INTR_ENBL_VEC",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQIDENT.
static const field_t hw_gpu2d_aqident[] =
{
    {
        "CUSTOMER",
        "Customer value.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TECHNOLOGY",
        "Technology value.",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REVISION",
        "Revision value.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PRODUCT",
        "Product value.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAMILY",
        "Family value.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_FEATURES.
static const field_t hw_gpu2d_features[] =
{
    {
        "FE20_BIT_INDEX",
        "Supports 20 bit index.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RS_YUV_TARGET",
        "Supports resolving into YUV target.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYTE_WRITE_3D",
        "3D PE has byte write capability.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FE20",
        "FE 2.0 is present.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VGTS",
        "VG tessellator is present.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_VG",
        "VG pipe is present.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MEM32_BIT_SUPPORT",
        "32 bit memory address support.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUY2_RENDER_TARGET",
        "YUY2 support in PE and YUY2 to RGB conversion in resolve.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALF_TX_CACHE",
        "TX cache is half.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALF_PE_CACHE",
        "PE cache is half.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUY2_AVERAGING",
        "YUY2 averaging support in resolve.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO_SCALER",
        "IP does not have 2D scaler.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYTE_WRITE_2D",
        "Supports byte write in 2D.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUFFER_INTERLEAVING",
        "IP supports interleaving depth and color buffers.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO422_TEXTURE",
        "IP does not have 422 texture input format.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO_EZ",
        "IP does not have early-Z.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIN_AREA",
        "IP is configured to have minimum area.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CG",
        "Second level clock gating is available.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUV420_TILER",
        "YUV 4:2:0 tiler is available.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HIGH_DYNAMIC_RANGE",
        "Shows if the IP has HDR support.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_SCALER",
        "Shows if the IP has HD scaler.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ETC1_TEXTURE_COMPRESSION",
        "ETC1 texture compression.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_2D",
        "Shows if there is 2D engine.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DC",
        "Shows if there is a display controller in the IP.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MSAA",
        "MSAA support.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUV420_FILTER",
        "YUV 4:2:0 support in filter blit.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ZCOMPRESSION",
        "Depth and color compression.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_MODE",
        "Debug registers.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DXT_TEXTURE_COMPRESSION",
        "DXT texture compression.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_3D",
        "3D pipe.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SPECIAL_ANTI_ALIASING",
        "Full-screen anti-aliasing.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_CLEAR",
        "Fast clear.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPID.
static const field_t hw_gpu2d_chipid[] =
{
    {
        "ID",
        "Id.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPREV.
static const field_t hw_gpu2d_chiprev[] =
{
    {
        "REV",
        "Revision.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPDATE.
static const field_t hw_gpu2d_chipdate[] =
{
    {
        "DATE",
        "Date.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPTIME.
static const field_t hw_gpu2d_chiptime[] =
{
    {
        "TIME",
        "Time.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPCUSTOMER.
static const field_t hw_gpu2d_chipcustomer[] =
{
    {
        "GROUP",
        "Group.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPANY",
        "Company.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MINORFEATURES0.
static const field_t hw_gpu2d_minorfeatures0[] =
{
    {
        "FLIP_Y",
        "Y flipping capability is added to resolve.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DUAL_RETURN_BUS",
        "Dual Return Bus from HI to clients.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENDIANNESS_CONFIG",
        "Configurable endianness support.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEXTURE8_K",
        "Supports 8Kx8K textures.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_TEXTURE_CONVERTER",
        "Driver hack is not needed.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SPECIAL_MSAA_LOD",
        "Special LOD calculation when MSAA is on.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_CLEAR_FLUSH",
        "Proper flush is done in fast clear cache.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "_2DPE20",
        "2D PE 2.0 is present.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_AUTO_DISABLE",
        "Auto disable in FC is correct.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RENDER_8K",
        "Supports 8K render target.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TILE_STATUS_2BITS",
        "2 bits are used instead of 4 bits for tile status.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEPARATE_TILE_STATUS_WHEN_INTERLEAVED",
        "Use 2 separate tile status buffers in interleaved mode.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SUPER_TILED_32X32",
        "32x32 super tile is available.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_20",
        "Major updates to VG pipe (TS buffer tiling.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TS_EXTENDED_COMMANDS",
        "New commands added to the tessellator.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPRESSION_FIFO_FIXED",
        "If this bit is not set, the FIFO counter should be set to 50.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EXTRA_SHADER_INSTRUCTIONS0",
        "Floor, ceil, and sign instructions are available.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_FILTER",
        "VG filter is available.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_21",
        "Minor updates to VG pipe (Event generation from VG, TS, PE).",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SHADER_GETS_W",
        "W is sent to SH from RA.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EXTRA_SHADER_INSTRUCTIONS1",
        "Sqrt, sin, cos instructions are available.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEFAULT_REG0",
        "Unavailable registers will return 0.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MC_20",
        "New style MC with separate paths for color and depth.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SHADER_MSAA_SIDEBAND",
        "Put the MSAA data into sideband fifo.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES0",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VAA",
        "VAA is available or not.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYPASS_IN_MSAA",
        "Shader supports bypass mode when MSAA is enabled.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HIERARCHICAL_Z",
        "Hierarchiccal Z is supported.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEW_TEXTURE",
        "New texture unit is available.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "A8_TARGET_SUPPORT",
        "2D engine supports A8 target.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_STENCIL",
        "Correct stencil behavior in depth only.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENHANCE_VR",
        "Enhance VR and add a mode to walk 16 pixels in 16-bit mode in Vertical"
        " pass to improve $ hit rate when rotating 90/270.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CACHECONTROL.
static const field_t hw_gpu2d_cachecontrol[] =
{
    {
        "NOT_USED",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_RESETMEMCOUNTERS.
static const field_t hw_gpu2d_resetmemcounters[] =
{
    {
        "RESET",
        "",
        0, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADS.
static const field_t hw_gpu2d_totalreads[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITES.
static const field_t hw_gpu2d_totalwrites[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPSPECS.
static const field_t hw_gpu2d_chipspecs[] =
{
    {
        "VERTEX_OUTPUT_BUFFER_SIZE",
        "Log2 of vertex output buffer size.",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_PIXEL_PIPES",
        "Number of pixel pipes.",
        4, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_SHADER_CORES",
        "Number of shader cores.",
        7, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VERTEX_CACHE_SIZE",
        "Number of entries in the vertex shader cache.",
        15, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "THREAD_COUNT",
        "Log2 of thread count.",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEMP_REGISTERS",
        "Log2 of temporary registers.",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STREAMS",
        "Number of vertex streams.",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITEBURSTS.
static const field_t hw_gpu2d_totalwritebursts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITEREQS.
static const field_t hw_gpu2d_totalwritereqs[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITELASTS.
static const field_t hw_gpu2d_totalwritelasts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADBURSTS.
static const field_t hw_gpu2d_totalreadbursts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADREQS.
static const field_t hw_gpu2d_totalreadreqs[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADLASTS.
static const field_t hw_gpu2d_totalreadlasts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_GPOUT0.
static const field_t hw_gpu2d_gpout0[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_GPOUT1.
static const field_t hw_gpu2d_gpout1[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_GPOUT2.
static const field_t hw_gpu2d_gpout2[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AXICONTROL.
static const field_t hw_gpu2d_axicontrol[] =
{
    {
        "WR_FULL_BURST_MODE",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MINORFEATURES1.
static const field_t hw_gpu2d_minorfeatures1[] =
{
    {
        "TEXTURE_STRIDE",
        "Texture has stride and memory addressing.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES2",
        "",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES1",
        "",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_DOUBLE_BUFFER",
        "Double buffering support for VG (second TS-->VG semaphore is present).",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "V2_COMPRESSION",
        "V2 compression.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSUV_SWIZZLE",
        "Resolve UV swizzle.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALCYCLES.
static const field_t hw_gpu2d_totalcycles[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALIDLECYLES.
static const field_t hw_gpu2d_totalidlecyles[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPSPECS2.
static const field_t hw_gpu2d_chipspecs2[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MODULEPOWERCONTROLS.
static const field_t hw_gpu2d_modulepowercontrols[] =
{
    {
        "TURN_OFF_COUNTER",
        "Counter value for clock gating the module if the module is idle for th"
        "is amount of clock cycles.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TURN_ON_COUNTER",
        "Number of clock cycles to wait after turning on the clock.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_STARVE_MODULE_CLOCK_GATING",
        "Disables module level clock gating for starve/idle condition.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_STALL_MODULE_CLOCK_GATING",
        "Disables module level clock gating for stall condition.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_MODULE_CLOCK_GATING",
        "Enables module level clock gating.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MODULEPOWERMODULECONTROL.
static const field_t hw_gpu2d_modulepowermodulecontrol[] =
{
    {
        "DISABLE_MODULE_CLOCK_GATING_TS",
        "Disables module level clock gating for TS.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_FP",
        "Disables module level clock gating for FP.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_IM",
        "Disables module level clock gating for IM.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_VG",
        "Disables module level clock gating for VG.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_TX",
        "Disables module level clock gating for TX.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_RA",
        "Disables module level clock gating for RA.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_SE",
        "Disables module level clock gating for SE.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_PA",
        "Disables module level clock gating for PA.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_SH",
        "Disables module level clock gating for SH.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_PE",
        "Disables module level clock gating for PE.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_DE",
        "Disables module level clock gating for DE.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_FE",
        "Disables module level clock gating for FE.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MODULEPOWERMODULESTATUS.
static const field_t hw_gpu2d_modulepowermodulestatus[] =
{
    {
        "MODULE_CLOCK_GATED_TS",
        "Module level clock gating is ON for TS.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_FP",
        "Module level clock gating is ON for FP.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_IM",
        "Module level clock gating is ON for IM.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_VG",
        "Module level clock gating is ON for VG.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_TX",
        "Module level clock gating is ON for TX.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_RA",
        "Module level clock gating is ON for RA.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_SE",
        "Module level clock gating is ON for SE.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_PA",
        "Module level clock gating is ON for PA.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_SH",
        "Module level clock gating is ON for SH.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_PE",
        "Module level clock gating is ON for PE.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_DE",
        "Module level clock gating is ON for DE.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_FE",
        "Module level clock gating is ON for FE.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPU2D module.
static const reg_t hw_gpu2d[] =
{
    {
        "AQHICLOCKCONTROL",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_gpu2d_aqhiclockcontrol
    },
    {
        "AQHIIDLE",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        13, // Number of bitfields
        hw_gpu2d_aqhiidle
    },
    {
        "AQAXICONFIG",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpu2d_aqaxiconfig
    },
    {
        "AQAXISTATUS",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpu2d_aqaxistatus
    },
    {
        "AQINTRACKNOWLEDGE",
        "Interrupt acknowledge register.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_aqintracknowledge
    },
    {
        "AQINTRENBL",
        "Interrupt enable register.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_aqintrenbl
    },
    {
        "AQIDENT",
        "Identification register.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_gpu2d_aqident
    },
    {
        "FEATURES",
        "Shows which features are enabled in this chip.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        32, // Number of bitfields
        hw_gpu2d_features
    },
    {
        "CHIPID",
        "Shows the ID for the chip in BCD.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chipid
    },
    {
        "CHIPREV",
        "Shows the revision for the chip in BCD.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chiprev
    },
    {
        "CHIPDATE",
        "Shows the release date for the IP.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chipdate
    },
    {
        "CHIPTIME",
        "Shows the release time for the IP.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chiptime
    },
    {
        "CHIPCUSTOMER",
        "Shows the customer and group for the IP.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_gpu2d_chipcustomer
    },
    {
        "MINORFEATURES0",
        "Shows which minor features are enabled in this chip.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        false, // Writable
        32, // Number of bitfields
        hw_gpu2d_minorfeatures0
    },
    {
        "CACHECONTROL",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_cachecontrol
    },
    {
        "RESETMEMCOUNTERS",
        "Writing 1 will reset the counters and stop counting.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_resetmemcounters
    },
    {
        "TOTALREADS",
        "Total reads in terms of 64bits.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreads
    },
    {
        "TOTALWRITES",
        "Total writes in terms of 64bits.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwrites
    },
    {
        "CHIPSPECS",
        "Specs for the chip.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_gpu2d_chipspecs
    },
    {
        "TOTALWRITEBURSTS",
        "Total write Data Count in terms of 64bits.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwritebursts
    },
    {
        "TOTALWRITEREQS",
        "Total write Request Count.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwritereqs
    },
    {
        "TOTALWRITELASTS",
        "Total WLAST Count.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwritelasts
    },
    {
        "TOTALREADBURSTS",
        "Total Read Data Count in terms of 64bits.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreadbursts
    },
    {
        "TOTALREADREQS",
        "Total Read Request Count.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreadreqs
    },
    {
        "TOTALREADLASTS",
        "Total RLAST Count.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreadlasts
    },
    {
        "GPOUT0",
        "General Purpose output register0.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_gpout0
    },
    {
        "GPOUT1",
        "General Purpose output register1.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_gpout1
    },
    {
        "GPOUT2",
        "General Purpose output register2.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_gpout2
    },
    {
        "AXICONTROL",
        "Special Handling on AXI Bus",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_axicontrol
    },
    {
        "MINORFEATURES1",
        "Shows which features are enabled in this chip.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_gpu2d_minorfeatures1
    },
    {
        "TOTALCYCLES",
        "Total cycles.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalcycles
    },
    {
        "TOTALIDLECYLES",
        "Total cycles where the GPU is idle.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalidlecyles
    },
    {
        "CHIPSPECS2",
        "Specs for the chip.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_chipspecs2
    },
    {
        "MODULEPOWERCONTROLS",
        "The Power Management register set has just a few registers for control"
        "ling clock gating within the core.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_gpu2d_modulepowercontrols
    },
    {
        "MODULEPOWERMODULECONTROL",
        "Module level control registers.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gpu2d_modulepowermodulecontrol
    },
    {
        "MODULEPOWERMODULESTATUS",
        "Module level control status.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        false, // Writable
        12, // Number of bitfields
        hw_gpu2d_modulepowermodulestatus
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark I2C
#endif

// Bitfields in register I2C_IADR.
static const field_t hw_i2c_iadr[] =
{
    {
        "ADR",
        "Slave address.",
        1, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_IFDR.
static const field_t hw_i2c_ifdr[] =
{
    {
        "IC",
        "I2C clock rate.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2CR.
static const field_t hw_i2c_i2cr[] =
{
    {
        "RSTA",
        "Repeat start.",
        2, // LSB
        2, // MSB
        false, // Readable
        true // Writable
    },
    {
        "TXAK",
        "Transmit acknowledge enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MTX",
        "Transmit/receive mode select bit.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSTA",
        "Master/slave mode select bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IIEN",
        "I2C interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IEN",
        "I2C enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2SR.
static const field_t hw_i2c_i2sr[] =
{
    {
        "RXAK",
        "Received acknowledge.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IIF",
        "I2C interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRW",
        "Slave read/write.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAL",
        "Arbitration lost.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBB",
        "I2C bus busy bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAAS",
        "I2C addressed as a slave bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ICF",
        "Data transferring bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2DR.
static const field_t hw_i2c_i2dr[] =
{
    {
        "DATA",
        "Data Byte.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a I2C module.
static const reg_t hw_i2c[] =
{
    {
        "IADR",
        "",
        2, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_iadr
    },
    {
        "IFDR",
        "The I2C_IFDR provides a programmable prescaler to configure the clock "
        "for bit-rate selection.",
        2, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_ifdr
    },
    {
        "I2CR",
        "The I2C_I2CR is used to enable the I2C and the I2C interrupt.",
        2, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_i2c_i2cr
    },
    {
        "I2SR",
        "The I2C_I2SR contains bits that indicate transaction direction and sta"
        "tus.",
        2, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_i2c_i2sr
    },
    {
        "I2DR",
        "In master-receive mode, reading the data register allows a read to occ"
        "ur and initiates the next byte to be received.",
        2, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_i2dr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark IOMUXC
#endif

// Bitfields in register IOMUXC_GPR0.
static const field_t hw_iomuxc_gpr0[] =
{
    {
        "DMAREQ_MUX_SEL0",
        "Selects between two possible sources for SDMA_EVENT[2]:",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL1",
        "Selects between two possible sources for SDMA_EVENT[3]:",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL2",
        "Selects between two possible sources for SDMA_EVENT[4]:",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL3",
        "Selects between two possible sources for SDMA_EVENT[5]:",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL4",
        "Selects between two possible sources for SDMA_EVENT[10]:",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL5",
        "Selects between two possible sources for SDMA_EVENT[9]:",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL6",
        "Selects between two possible sources for SDMA_EVENT[23]:",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL7",
        "Selects between two possible sources for SDMA_EVENT[14]:",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR1.
static const field_t hw_iomuxc_gpr1[] =
{
    {
        "ACT_CS0",
        "See description for ADDRS3[10]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS0",
        "See description for ADDRS3[10]",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACT_CS1",
        "See description for ADDRS3[10]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS1",
        "See description for ADDRS3[10]",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACT_CS2",
        "See description for ADDRS3[10]",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS2",
        "See description for ADDRS3[10]",
        7, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACT_CS3",
        "See description for ADDRS3[10]",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS3",
        "Active Chip Select and Address Space.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GINT",
        "Global interrupt \"0\" bit (connected to ARM IRQ#0 and GPC)",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_CLK_SEL",
        "choose enet reference clk mode",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USB_EXP_MODE",
        "USB Exposure mode",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADD_DS",
        "set to 0 will make output driver ~10% stronger at highest strength (DS"
        "E=111) for use in case if IO buffer operation at WCS and 200 MHz is ma"
        "rginal",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_CLK_SEL_FROM_ANALOG_LOOPBACK",
        "When ENET_CLK_SEL(GPR1[14]) is program to 0(means get enet txclk from "
        "internal anatop), use these 2 bits to select from 4 options of loopbac"
        "k path.",
        17, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXC_MON",
        "Exclusive monitor response select of illegal command (of lal gaskets, "
        "except MMDC)",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR2.
static const field_t hw_iomuxc_gpr2[] =
{
    {
        "EPDC_MEM_EN_POWERSAVING",
        "enable power saving features on epdc memory",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_MEM_SHUTDOWN",
        "set to bring memory to shutdown state (most power saving state, Shut D"
        "own periphery and core, no memory retention)",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_MEM_DEEPSLEEP",
        "control how memory enter Deep Sleep mode (shutdown periphery power, bu"
        "t maintain memory contents, outputs of memory are pulled low)",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_MEM_LIGHTSLEEP",
        "set to bring memory to light sleep state (Low leakage mode, maintain m"
        "emory contents, no change to memory output)",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDC_MEM_EN_POWERSAVING",
        "enable power saving features on SPDC memory",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDC_MEM_SHUTDOWN",
        "set to bring memory to shutdown state (most power saving state, Shut D"
        "own periphery and core, no memory retention)",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDC_MEM_DEEPSLEEP",
        "control how memory enter Deep Sleep mode (shutdown periphery power, bu"
        "t maintain memory contents, outputs of memory are pulled low)",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDC_MEM_LIGHTSLEEP",
        "set to bring memory to light sleep state (Low leakage mode, maintain m"
        "emory contents, no change to memory output)",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_MEM_EN_POWERSAVING",
        "enable power saving features on PXP memory",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_MEM_SHUTDOWN",
        "set to bring memory to shutdown state (most power saving state, Shut D"
        "own periphery and core, no memory retention)",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_MEM_DEEPSLEEP",
        "control how memory enter Deep Sleep mode (shutdown periphery power, bu"
        "t maintain memory contents, outputs of memory are pulled low)",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_MEM_LIGHTSLEEP",
        "set to bring memory to light sleep state (Low leakage mode, maintain m"
        "emory contents, no change to memory output)",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_MEM_EN_POWERSAVING",
        "enable power saving features on LCDIF memory",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_MEM_SHUTDOWN",
        "set to bring memory to shutdown state (most power saving state, Shut D"
        "own periphery and core, no memory retention)",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_MEM_DEEPSLEEP",
        "control how memory enter Deep Sleep mode (shutdown periphery power, bu"
        "t maintain memory contents, outputs of memory are pulled low)",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_MEM_LIGHTSLEEP",
        "set to bring memory to light sleep state (Low leakage mode, maintain m"
        "emory contents, no change to memory output)",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DCP_MEM_EN_POWERSAVING",
        "enable power saving features on DCP memory",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DCP_MEM_SHUTDOWN",
        "set to bring memory to shutdown state (most power saving state, Shut D"
        "own periphery and core, no memory retention)",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DCP_MEM_DEEPSLEEP",
        "control how memory enter Deep Sleep mode (shutdown periphery power, bu"
        "t maintain memory contents, outputs of memory are pulled low)",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DCP_MEM_LIGHTSLEEP",
        "set to bring memory to light sleep state (Low leakage mode, maintain m"
        "emory contents, no change to memory output)",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2_MEM_EN_POWERSAVING",
        "enable power saving features on L2 memory",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2_MEM_SHUTDOWN",
        "set to bring memory to shutdown state (most power saving state, Shut D"
        "own periphery and core, no memory retention)",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2_MEM_DEEPSLEEP",
        "control how memory enter Deep Sleep mode (shutdown periphery power, bu"
        "t maintain memory contents, outputs of memory are pulled low)",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2_MEM_LIGHTSLEEP",
        "set to bring memory to light sleep state (Low leakage mode, maintain m"
        "emory contents, no change to memory output)",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR3.
static const field_t hw_iomuxc_gpr3[] =
{
    {
        "OCRAM_L2_CTL",
        "OCRAM_L2_CTL[3] write address pipeline control bit.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_L2_STATUS",
        "This field shows the OCRAM_L2 pipeline settings status, controlled by "
        "OCRAM_L2_CTL[3:0] bits respectively.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TZASC1_BOOT_LOCK",
        "TZASC-1 secure boot lock",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CORE_DBG_ACK_EN",
        "Mask control of Core debug acknowledge to global debug acknowledge",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_STATUS",
        "This field shows the OCRAM pipeline settings status, controlled by OCR"
        "AM_CTL[24:21] bits respectively.",
        17, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OCRAM_CTL",
        "OCRAM_CTL[24] write address pipeline control bit.",
        21, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHCX_RD_CACHE_CTL",
        "Control uSDHCx [1-4] blocks cacheable attribute of AXI read transactio"
        "ns",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHCX_WR_CACHE_CTL",
        "Control uSDHCx [1-4] blocks cacheable attribute of AXI write transacti"
        "ons",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR4.
static const field_t hw_iomuxc_gpr4[] =
{
    {
        "SOC_VERSION",
        "This is status (read only) field.",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RNGB_STOP_ACK",
        "RNGB stop acknowledge.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SDMA_STOP_ACK",
        "SDMA stop acknowledge.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR5.
static const field_t hw_iomuxc_gpr5[] =
{
    {
        "ARM_WFI",
        "ARM WFI event out indicating on WFI state of the cores (these are stat"
        "us, read only bits)",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARM_WFE",
        "ARM WFE event out indication on WFE state of the cores (these are stat"
        "us, read only bits)",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "L2_CLK_STOP",
        "L2 cache clock stop indication (this is a status, read only bit]",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR6.
static const field_t hw_iomuxc_gpr6[] =
{
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR7.
static const field_t hw_iomuxc_gpr7[] =
{
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR8.
static const field_t hw_iomuxc_gpr8[] =
{
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR9.
static const field_t hw_iomuxc_gpr9[] =
{
    {
        "TZASC1_BYP",
        "TZASC-1 BYPASS MUX control",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR10.
static const field_t hw_iomuxc_gpr10[] =
{
    {
        "DBG_EN",
        "ARM non secure (non-invasive) debug enable",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBG_CLK_EN",
        "ARM Debug clock enable",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEC_ERR_RESP",
        "Security error response enable for all security gaskets (on both AHB a"
        "nd AXI busses)",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_L2_TZ_EN",
        "OCRAM_L2 TrustZone (TZ) enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_L2_TZ_ADDR",
        "OCRAM_L2 TrustZone (TZ) start address.",
        4, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_TZ_EN",
        "OCRAM TrustZone (TZ) enable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_TZ_ADDR",
        "OCRAM TrustZone (TZ) start address.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_DBG_EN",
        "Lock DBG_EN field for changes.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_DBG_CLK_EN",
        "Lock DBG_CLK_EN field for changes.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_SEC_ERR_RESP",
        "Lock SEC_ERR_RESP field for changes.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_OCRAM_L2_TZ_EN",
        "Lock OCRAM_L2_TZ_EN field for changes.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_OCRAM_L2_TZ_ADDR",
        "Lock OCRAM_L2_TZ_ADDR field for changes.",
        20, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_OCRAM_TZ_EN",
        "Lock OCRAM_TZ_EN field for changes.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_OCRAM_TZ_ADDR",
        "Lock OCRAM_TZ_ADDR field for changes.",
        27, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR11.
static const field_t hw_iomuxc_gpr11[] =
{
    {
        "OCRAM_L2_EN",
        "set to use L2 cache as ocram",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK_OCRAM_L2_EN",
        "lock ocram_l2 enable bit",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR12.
static const field_t hw_iomuxc_gpr12[] =
{
    {
        "GPU_AWQOS0",
        "QOS control for write channel of gpu port m_g_0",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_ARQOS0",
        "QOS control for read channel of gpu port m_g_0",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_AWQOS1",
        "QOS control for write channel of gpu port m_g_1",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_ARQOS1",
        "QOS control for read channel of gpu port m_g_1",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_AWQOS2",
        "QOS control for write channel of gpu port m_g_2",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_ARQOS2",
        "QOS control for read channel of gpu port m_g_2",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_APB_CLK_EN",
        "ARM platform APB clock enable",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_ATB_CLK_EN",
        "ARM platform ATB clock enable",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_AHB_CLK_EN",
        "ARM platform AHB clock enable",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_IPG_CLK_EN",
        "ARM platform IPG clock enable",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DCP_KEY_SEL",
        "select 128bit dcp key from 256bit's key from snvs/ocotp",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR13.
static const field_t hw_iomuxc_gpr13[] =
{
    {
        "PXP_RD_CACHE_VAL",
        "PXP block cacheable attribute value of AXI read transactions  The valu"
        "e of PXP_RD_CACHE_VAL is affecting the transactions only if PXP_RD_CAC"
        "HE_SEL is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_WR_CACHE_VAL",
        "PXP block cacheable attribute value of AXI write transactions  The val"
        "ue of PXP_WR_CACHE_VAL is affecting the transactions only if PXP_WR_CA"
        "CHE_SEL is set.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_RD_CACHE_SEL",
        "This bit selects the cacheable attribute of PXP AXI read transcations)",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_WR_CACHE_SEL",
        "This bit selects the cacheable attribute of PXP AXI write transcations",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_RD_CACHE_VAL",
        "EPDC block cacheable attribute value of AXI read transactions  The val"
        "ue of EPDC_RD_CACHE_VAL is affecting the transactions only if EPDC_RD_"
        "CACHE_SEL is set.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_WR_CACHE_VAL",
        "EPDC block cacheable attribute value of AXI write transactions  The va"
        "lue of EPDC_WR_CACHE_VAL is affecting the transactions only if EPDC_WR"
        "_CACHE_SEL is set.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_RD_CACHE_SEL",
        "This bit selects the cacheable attribute of EPDC AXI read transcations"
        ")",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_WR_CACHE_SEL",
        "This bit selects the cacheable attribute of EPDC AXI write transcation"
        "s",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_RD_CACHE_VAL",
        "LCDIF block cacheable attribute value of AXI read transactions  The va"
        "lue of LCDIF_RD_CACHE_VAL is affecting the transactions only if LCDIF_"
        "RD_CACHE_SEL is set.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_RD_CACHE_SEL",
        "This bit selects the cacheable attribute of LCDIF AXI read transcation"
        "s)",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDMA_STOP_REQ",
        "SDMA stop request",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_AUD_MCLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_aud_mclk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_AUD_RXC.
static const field_t hw_iomuxc_sw_mux_ctl_pad_aud_rxc[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_AUD_RXD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_aud_rxd[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_AUD_RXFS.
static const field_t hw_iomuxc_sw_mux_ctl_pad_aud_rxfs[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_AUD_TXC.
static const field_t hw_iomuxc_sw_mux_ctl_pad_aud_txc[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_AUD_TXD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_aud_txd[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_AUD_TXFS.
static const field_t hw_iomuxc_sw_mux_ctl_pad_aud_txfs[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MISO.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi1_miso[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi1_mosi[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi1_sclk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SS0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi1_ss0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MISO.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi2_miso[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MOSI.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi2_mosi[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SCLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi2_sclk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SS0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ecspi2_ss0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_bdr0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_bdr1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D10.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d10[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D11.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d11[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D12.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d12[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D13.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d13[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D14.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d14[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D15.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d15[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D4.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d4[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D5.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d5[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D6.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d6[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D7.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d7[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D8.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d8[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_D9.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_d9[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_gdclk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_gdoe[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_gdrl[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_gdsp[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCOM.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrcom[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrctrl0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrctrl1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrctrl2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrctrl3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRINT.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrint[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRSTAT.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrstat[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRWAKEUP.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_pwrwakeup[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdce0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdce1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdce2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdce3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdclk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdle[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdoe[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_sdshr[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_vcom0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_epdc_vcom1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_CRS_DV.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_crs_dv[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_MDC.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_mdc[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_MDIO.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_mdio[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_REF_CLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_ref_clk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_RX_ER.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_rx_er[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_RXD0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_rxd0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_RXD1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_rxd1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_TX_CLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_tx_clk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_TX_EN.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_tx_en[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_TXD0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_txd0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_FEC_TXD1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_fec_txd1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_HSIC_DAT.
static const field_t hw_iomuxc_sw_mux_ctl_pad_hsic_dat[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_HSIC_STROBE.
static const field_t hw_iomuxc_sw_mux_ctl_pad_hsic_strobe[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_I2C1_SCL.
static const field_t hw_iomuxc_sw_mux_ctl_pad_i2c1_scl[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_I2C1_SDA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_i2c1_sda[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_I2C2_SCL.
static const field_t hw_iomuxc_sw_mux_ctl_pad_i2c2_scl[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_I2C2_SDA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_i2c2_sda[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL4.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col4[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL5.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col5[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL6.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col6[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_COL7.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_col7[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW4.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row4[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW5.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row5[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW6.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row6[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_KEY_ROW7.
static const field_t hw_iomuxc_sw_mux_ctl_pad_key_row7[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_CLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_clk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT10.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat10[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT11.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat11[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT12.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat12[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT13.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat13[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT14.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat14[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT15.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat15[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT16.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat16[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT17.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat17[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT18.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat18[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT19.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat19[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT20.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat20[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT21.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat21[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT22.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat22[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT23.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat23[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT4.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat4[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT5.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat5[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT6.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat6[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT7.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat7[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT8.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat8[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_DAT9.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_dat9[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_enable[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_hsync[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_RESET.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_reset[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC.
static const field_t hw_iomuxc_sw_mux_ctl_pad_lcd_vsync[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_PWM1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_pwm1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_REF_CLK_24M.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ref_clk_24m[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_REF_CLK_32K.
static const field_t hw_iomuxc_sw_mux_ctl_pad_ref_clk_32k[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_CLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_clk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_CMD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_cmd[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT4.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat4[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT5.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat5[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT6.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat6[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD1_DAT7.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd1_dat7[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_CLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_clk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_CMD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_cmd[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT4.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat4[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT5.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat5[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT6.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat6[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT7.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat7[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_RST.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_rst[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD3_CLK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd3_clk[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD3_CMD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd3_cmd[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD3_DAT0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd3_dat0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD3_DAT1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd3_dat1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD3_DAT2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd3_dat2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD3_DAT3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd3_dat3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART1_RXD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart1_rxd[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART1_TXD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart1_txd[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_WDOG_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_wdog_b[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_AUD_MCLK.
static const field_t hw_iomuxc_sw_pad_ctl_pad_aud_mclk[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: AUD_MCLK.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: AUD_MCLK.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: AUD_MCLK.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: AUD_MC"
        "LK.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: AUD_M"
        "CLK.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: AUD_M"
        "CLK.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " AUD_MCLK.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: AUD_MC"
        "LK.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: AUD_M"
        "CLK.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_AUD_RXC.
static const field_t hw_iomuxc_sw_pad_ctl_pad_aud_rxc[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: AUD_RXC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: AUD_RXC.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: AUD_RXC.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: AUD_RX"
        "C.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: AUD_R"
        "XC.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: AUD_R"
        "XC.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " AUD_RXC.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: AUD_RX"
        "C.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: AUD_R"
        "XC.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_AUD_RXD.
static const field_t hw_iomuxc_sw_pad_ctl_pad_aud_rxd[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: AUD_RXD.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: AUD_RXD.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: AUD_RXD.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: AUD_RX"
        "D.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: AUD_R"
        "XD.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: AUD_R"
        "XD.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " AUD_RXD.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: AUD_RX"
        "D.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: AUD_R"
        "XD.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_AUD_RXFS.
static const field_t hw_iomuxc_sw_pad_ctl_pad_aud_rxfs[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: AUD_RXFS.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: AUD_RXFS.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: AUD_RXFS.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: AUD_RX"
        "FS.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: AUD_R"
        "XFS.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: AUD_R"
        "XFS.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " AUD_RXFS.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: AUD_RX"
        "FS.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: AUD_R"
        "XFS.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_AUD_TXC.
static const field_t hw_iomuxc_sw_pad_ctl_pad_aud_txc[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: AUD_TXC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: AUD_TXC.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: AUD_TXC.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: AUD_TX"
        "C.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: AUD_T"
        "XC.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: AUD_T"
        "XC.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " AUD_TXC.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: AUD_TX"
        "C.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: AUD_T"
        "XC.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_AUD_TXD.
static const field_t hw_iomuxc_sw_pad_ctl_pad_aud_txd[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: AUD_TXD.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: AUD_TXD.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: AUD_TXD.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: AUD_TX"
        "D.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: AUD_T"
        "XD.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: AUD_T"
        "XD.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " AUD_TXD.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: AUD_TX"
        "D.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: AUD_T"
        "XD.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_AUD_TXFS.
static const field_t hw_iomuxc_sw_pad_ctl_pad_aud_txfs[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: AUD_TXFS.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: AUD_TXFS.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: AUD_TXFS.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: AUD_TX"
        "FS.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: AUD_T"
        "XFS.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: AUD_T"
        "XFS.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " AUD_TXFS.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: AUD_TX"
        "FS.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: AUD_T"
        "XFS.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a0[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A0.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A0.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a1[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A1.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A10.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a10[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A10.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "10.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A10.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A11.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a11[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A11.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "11.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A11.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A12.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a12[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A12.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "12.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A12.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A13.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a13[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A13.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "13.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A13.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A14.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a14[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A14.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "14.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A14.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A15.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a15[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A15.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "15.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A15.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A2.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a2[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A2.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "2.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A2.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A3.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a3[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A3.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "3.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A3.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A4.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a4[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A4.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "4.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A4.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A5.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a5[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A5.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "5.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A5.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A6.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a6[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A6.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "6.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A6.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A7.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a7[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A7.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "7.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A7.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A8.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a8[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A8.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "8.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A8.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_A9.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_a9[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "A9.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_A"
        "9.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_A9.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_cas[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_CAS.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "CAS.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_C"
        "AS.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_CAS.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_cs0[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_CTLDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "CS0.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_C"
        "S0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_CS0.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_cs1[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_CTLDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "CS1.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_C"
        "S1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_CS1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_dqm0[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_DQM0"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "DQM0.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_D"
        "QM0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_DQM0.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_dqm1[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_DQM1"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "DQM1.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_D"
        "QM1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_DQM1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_dqm2[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_DQM2"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "DQM2.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_D"
        "QM2.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_DQM2.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_dqm3[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_DQM3"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "DQM3.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_D"
        "QM3.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_DQM3.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_ras[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_RAS.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "RAS.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_R"
        "AS.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_RAS.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_reset[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_RESE"
        "T.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "RESET.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "RESET.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "RESET.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_RESET.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_R"
        "ESET.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_RESET.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Select one out of next values for pad: DRAM_RESET.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdba0[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDBA0.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DBA0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDBA0.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdba1[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_ADDDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDBA1.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DBA1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDBA1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdba2[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_CTLDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDBA2.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDBA2.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDBA2.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DBA2.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDBA2.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdcke0[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_CTLDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDCKE0.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDCKE0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDCKE0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDCKE0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DCKE0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDCKE0.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdcke1[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_CTLDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDCKE1.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDCKE1.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDCKE1.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDCKE1.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DCKE1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDCKE1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdclk_0[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_SDCL"
        "K_0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDCLK_0.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DCLK_0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDCLK_0.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdodt0[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_SDOD"
        "T0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDODT0.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDODT0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDODT0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDODT0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DODT0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDODT0.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdodt1[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_SDOD"
        "T1.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDODT1.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDODT1.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDODT1.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDODT1.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DODT1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDODT1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdqs0[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_SDQS"
        "0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Read Only Field",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDQS0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDQS0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDQS0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Read Only Field  Can be configured using Grou"
        "p Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRHYS",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Read Only Field  Can be configured using "
        "Group Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdqs1[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_SDQS"
        "1.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Read Only Field",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDQS1.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDQS1.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDQS1.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Read Only Field  Can be configured using Grou"
        "p Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRHYS",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Read Only Field  Can be configured using "
        "Group Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdqs2[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_SDQS"
        "2.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Read Only Field",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDQS2.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDQS2.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDQS2.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Read Only Field  Can be configured using Grou"
        "p Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRHYS",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Read Only Field  Can be configured using "
        "Group Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdqs3[] =
{
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: DRAM_SDQS"
        "3.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Read Only Field",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: DRAM_"
        "SDQS3.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: DRAM_"
        "SDQS3.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " DRAM_SDQS3.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Read Only Field  Can be configured using Grou"
        "p Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRHYS",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Read Only Field  Can be configured using "
        "Group Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE.
static const field_t hw_iomuxc_sw_pad_ctl_pad_dram_sdwe[] =
{
    {
        "DSE",
        "Drive Strength Field  Read Only Field  Can be configured using Group C"
        "ontrol Register: IOMUXC_SW_PAD_CTL_GRP_CTLDS",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODT",
        "On Die Termination Field  Select one out of next values for pad: DRAM_"
        "SDWE.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPKE",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Read Only Field  Can be configured using Gro"
        "up Control Register: IOMUXC_SW_PAD_CTL_GRP_DDRPK",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Read Only Field",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: DRAM_S"
        "DWE.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_INPUT",
        "DDR / CMOS Input Mode Field  Select one out of next values for pad: DR"
        "AM_SDWE.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_SEL",
        "DDR Standard Field  Read Only Field  Can be configured using Group Con"
        "trol Register: IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DO_TRIM",
        "Pad Output Delay Field  Read Only Field",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MISO.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi1_miso[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI1_MISO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI1_MI"
        "SO.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI1_MISO.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI1"
        "_MISO.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "1_MISO.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "1_MISO.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI1_MISO.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI1"
        "_MISO.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "1_MISO.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi1_mosi[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI1_MOSI.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI1_MO"
        "SI.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI1_MOSI.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI1"
        "_MOSI.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "1_MOSI.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "1_MOSI.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI1_MOSI.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI1"
        "_MOSI.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "1_MOSI.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi1_sclk[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI1_SCLK.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI1_SC"
        "LK.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI1_SCLK.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI1"
        "_SCLK.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "1_SCLK.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "1_SCLK.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI1_SCLK.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI1"
        "_SCLK.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "1_SCLK.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SS0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi1_ss0[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI1_SS0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI1_SS"
        "0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI1_SS0.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI1"
        "_SS0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "1_SS0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "1_SS0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI1_SS0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI1"
        "_SS0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "1_SS0.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MISO.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi2_miso[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI2_MISO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI2_MI"
        "SO.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI2_MISO.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI2"
        "_MISO.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "2_MISO.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "2_MISO.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI2_MISO.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI2"
        "_MISO.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "2_MISO.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MOSI.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi2_mosi[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI2_MOSI.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI2_MO"
        "SI.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI2_MOSI.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI2"
        "_MOSI.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "2_MOSI.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "2_MOSI.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI2_MOSI.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI2"
        "_MOSI.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "2_MOSI.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SCLK.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi2_sclk[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI2_SCLK.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI2_SC"
        "LK.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI2_SCLK.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI2"
        "_SCLK.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "2_SCLK.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "2_SCLK.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI2_SCLK.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI2"
        "_SCLK.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "2_SCLK.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SS0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_ecspi2_ss0[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: ECSPI2_SS0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: ECSPI2_SS"
        "0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: ECSPI2_SS0.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: ECSPI2"
        "_SS0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: ECSPI"
        "2_SS0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: ECSPI"
        "2_SS0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " ECSPI2_SS0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: ECSPI2"
        "_SS0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: ECSPI"
        "2_SS0.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_bdr0[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_BDR0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_BDR0"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_BDR0.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_B"
        "DR0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "BDR0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "BDR0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_BDR0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_B"
        "DR0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "BDR0.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_bdr1[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_BDR1.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_BDR1"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_BDR1.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_B"
        "DR1.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "BDR1.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "BDR1.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_BDR1.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_B"
        "DR1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "BDR1.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d0[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D0.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D0.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d1[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D1.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D1.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D1.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "1.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D1.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D1.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D1.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D1.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D10.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d10[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D10.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D10.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D10.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "10.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D10.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D10.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D10.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "10.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D10.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D11.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d11[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D11.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D11.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D11.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D11.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D11.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D11.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "11.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D11.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D12.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d12[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D12.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D12.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D12.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "12.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D12.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D12.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "12.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D12.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D13.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d13[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D13.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D13.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D13.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "13.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D13.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D13.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "13.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D13.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D14.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d14[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D14.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D14.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D14.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "14.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D14.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D14.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D14.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "14.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D14.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D15.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d15[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D15.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D15.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D15.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "15.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D15.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D15.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D15.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "15.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D15.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D2.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d2[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D2.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D2.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D2.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "2.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D2.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D2.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D2.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "2.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D2.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D3.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d3[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D3.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D3.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "3.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D3.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D3.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D3.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "3.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D3.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D4.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d4[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D4.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D4.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D4.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "4.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D4.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D4.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D4.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "4.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D4.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D5.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d5[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D5.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D5.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D5.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "5.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D5.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D5.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D5.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "5.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D5.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D6.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d6[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D6.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D6.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D6.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "6.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D6.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D6.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D6.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "6.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D7.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d7[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D7.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D7.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D7.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "7.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D7.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D7.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "7.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D7.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D8.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d8[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D8.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D8.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D8.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "8.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D8.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D8.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D8.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "8.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D8.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_D9.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_d9[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_D9.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_D9.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_D9.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_D"
        "9.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "D9.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "D9.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_D9.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_D"
        "9.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "D9.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_gdclk[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_GDCLK.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_GDCL"
        "K.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_GDCLK.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_G"
        "DCLK.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "GDCLK.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "GDCLK.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_GDCLK.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_G"
        "DCLK.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "GDCLK.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_gdoe[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_GDOE.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_GDOE"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_GDOE.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_G"
        "DOE.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "GDOE.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "GDOE.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_GDOE.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_G"
        "DOE.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "GDOE.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_gdrl[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_GDRL.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_GDRL"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_GDRL.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_G"
        "DRL.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "GDRL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "GDRL.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_GDRL.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_G"
        "DRL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "GDRL.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_gdsp[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_GDSP.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_GDSP"
        ".",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_GDSP.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_G"
        "DSP.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "GDSP.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "GDSP.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_GDSP.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_G"
        "DSP.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "GDSP.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCOM.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrcom[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRCOM.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRC"
        "OM.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRCOM.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCOM.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCOM.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRCOM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRCOM.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCOM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCOM.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrctrl0[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRCTRL0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRC"
        "TRL0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRCTRL0.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRCTRL0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL0.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrctrl1[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRCTRL1.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRC"
        "TRL1.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRCTRL1.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL1.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL1.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL1.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRCTRL1.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL1.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL2.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrctrl2[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRCTRL2.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRC"
        "TRL2.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRCTRL2.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL2.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL2.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL2.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRCTRL2.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL2.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL2.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL3.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrctrl3[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRCTRL3.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRC"
        "TRL3.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRCTRL3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL3.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL3.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL3.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRCTRL3.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRCTRL3.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRCTRL3.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRINT.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrint[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRINT.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRI"
        "NT.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRINT.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRINT.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRINT.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRINT.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRINT.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRINT.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRINT.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRSTAT.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrstat[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRSTAT.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRS"
        "TAT.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRSTAT.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRSTAT.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRSTAT.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRSTAT.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRSTAT.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRSTAT.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRSTAT.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRWAKEUP.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_pwrwakeup[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_PWRWAKEUP"
        ".",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_PWRW"
        "AKEUP.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_PWRWAKEUP.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_P"
        "WRWAKEUP.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "PWRWAKEUP.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "PWRWAKEUP.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_PWRWAKEUP.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_P"
        "WRWAKEUP.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "PWRWAKEUP.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_sdce0[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_SDCE0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_SDCE"
        "0.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_SDCE0.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE0.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "SDCE0.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_SDCE0.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE0.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_sdce1[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_SDCE1.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_SDCE"
        "1.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_SDCE1.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE1.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE1.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "SDCE1.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_SDCE1.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE1.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE1.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_sdce2[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_SDCE2.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_SDCE"
        "2.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_SDCE2.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE2.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE2.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "SDCE2.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_SDCE2.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE2.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE2.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_sdce3[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_SDCE3.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_SDCE"
        "3.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Speed Field  Select one out of next values for pad: EPDC_SDCE3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Open Drain Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE3.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PKE",
        "Pull / Keep Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE3.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUE",
        "Pull / Keep Select Field  Select one out of next values for pad: EPDC_"
        "SDCE3.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUS",
        "Pull Up / Down Configure Field  Select one out of next values for pad:"
        " EPDC_SDCE3.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HYS",
        "Hysteresis Enable Field  Select one out of next values for pad: EPDC_S"
        "DCE3.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVE",
        "Low Voltage Enable Field  Select one out of next values for pad: EPDC_"
        "SDCE3.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK.
static const field_t hw_iomuxc_sw_pad_ctl_pad_epdc_sdclk[] =
{
    {
        "SRE",
        "Slew Rate Field  Select one out of next values for pad: EPDC_SDCLK.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Drive Strength Field  Select one out of next values for pad: EPDC_SDCL"
        "K.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "