<!--
Semi-automated TOC generation with instructions from
https://github.com/ekalinin/github-markdown-toc#auto-insert-and-update-toc
-->

<!--ts-->

*   [TensorFlow Lite for Microcontrollers](#tensorflow-lite-for-microcontrollers)
*   [Getting Help and Involved](#getting-help-and-involved)
*   [Additional Documentation for the TFLM Internals](#additional-documentation-for-the-tflm-internals)

<!-- Added by: advaitjain, at: Mon 05 Oct 2020 02:37:34 PM PDT -->

<!--te-->

# TensorFlow Lite for Microcontrollers

TensorFlow Lite for Microcontrollers is a port of TensorFlow Lite designed to
run machine learning models on microcontrollers and other devices with only
kilobytes of memory.

To learn how to use the framework, visit the developer documentation at
[tensorflow.org/lite/microcontrollers](https://www.tensorflow.org/lite/microcontrollers).

# Getting Help and Involved

A
[TF Lite Micro Github issue](https://github.com/tensorflow/tensorflow/issues/new?labels=comp%3Amicro&template=70-tflite-micro-issue.md)
should be the primary method of getting in touch with the TensorFlow Lite Micro
(TFLM) team.

The following resources may also be useful:

1.  SIG Micro [email group](https://groups.google.com/a/tensorflow.org/g/micro)
    and
    [monthly meetings](http://doc/1YHq9rmhrOUdcZnrEnVCWvd87s2wQbq4z17HbeRl-DBc).

1.  SIG Micro [gitter chat room](https://gitter.im/tensorflow/sig-micro).

If you are interested in contributing code to TensorFlow Lite for
Microcontrollers then please read our [contributions guide](CONTRIBUTING.md).

# Additional Documentation

For developers that are interested in more details of the internals of the
project, we have additional documentation in the [docs](docs/) folder.

*   [Benchmarks](benchmarks/README.md)
*   [Memory Management](docs/memory_management.md)
*   [New Platform Support](docs/new_platform_support.md)
